/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.ui.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.ui.i18n.ResourceBundleWrapper;
import org.apache.manifoldcf.ui.util.Encoder;
import org.apache.manifoldcf.ui.util.Formatter;
import org.apache.manifoldcf.ui.util.MultilineParser;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class Messages
extends org.apache.manifoldcf.core.i18n.Messages {
    public static final String DEFAULT_BUNDLE_NAME = "org.apache.manifoldcf.ui.i18n.common";

    public static String getString(Locale locale, String messageKey) {
        return Messages.getString(DEFAULT_BUNDLE_NAME, locale, messageKey, null);
    }

    public static String getAttributeString(Locale locale, String messageKey) {
        return Messages.getAttributeString(DEFAULT_BUNDLE_NAME, locale, messageKey, null);
    }

    public static String getBodyString(Locale locale, String messageKey) {
        return Messages.getBodyString(DEFAULT_BUNDLE_NAME, locale, messageKey, null);
    }

    public static String getAttributeJavascriptString(Locale locale, String messageKey) {
        return Messages.getAttributeJavascriptString(DEFAULT_BUNDLE_NAME, locale, messageKey, null);
    }

    public static String getBodyJavascriptString(Locale locale, String messageKey) {
        return Messages.getBodyJavascriptString(DEFAULT_BUNDLE_NAME, locale, messageKey, null);
    }

    public static String getString(Locale locale, String messageKey, Object[] args) {
        return Messages.getString(DEFAULT_BUNDLE_NAME, locale, messageKey, args);
    }

    public static String getAttributeString(Locale locale, String messageKey, Object[] args) {
        return Messages.getAttributeString(DEFAULT_BUNDLE_NAME, locale, messageKey, args);
    }

    public static String getBodyString(Locale locale, String messageKey, Object[] args) {
        return Messages.getBodyString(DEFAULT_BUNDLE_NAME, locale, messageKey, args);
    }

    public static String getAttributeJavascriptString(Locale locale, String messageKey, Object[] args) {
        return Messages.getAttributeJavascriptString(DEFAULT_BUNDLE_NAME, locale, messageKey, args);
    }

    public static String getBodyJavascriptString(Locale locale, String messageKey, Object[] args) {
        return Messages.getBodyJavascriptString(DEFAULT_BUNDLE_NAME, locale, messageKey, args);
    }

    public static String getString(String bundleName, Locale locale, String messageKey, Object[] args) {
        return Messages.getString(Messages.class, (String)bundleName, (Locale)locale, (String)messageKey, (Object[])args);
    }

    public static String getAttributeString(String bundleName, Locale locale, String messageKey, Object[] args) {
        return Messages.getAttributeString(Messages.class, bundleName, locale, messageKey, args);
    }

    public static String getBodyString(String bundleName, Locale locale, String messageKey, Object[] args) {
        return Messages.getBodyString(Messages.class, bundleName, locale, messageKey, args);
    }

    public static String getAttributeJavascriptString(String bundleName, Locale locale, String messageKey, Object[] args) {
        return Messages.getAttributeJavascriptString(Messages.class, bundleName, locale, messageKey, args);
    }

    public static String getBodyJavascriptString(String bundleName, Locale locale, String messageKey, Object[] args) {
        return Messages.getBodyJavascriptString(Messages.class, bundleName, locale, messageKey, args);
    }

    protected Messages() {
    }

    public static void outputResourceWithVelocity(IHTTPOutput output, Class clazz, String bundleName, String pathName, Locale locale, String resourceKey, Map<String, Object> contextObjects) throws ManifoldCFException {
        VelocityEngine engine = Messages.createVelocityEngine((Class)clazz);
        try {
            VelocityContext context = new VelocityContext();
            context.put("Encoder", Encoder.class);
            context.put("Formatter", Formatter.class);
            context.put("MultilineParser", MultilineParser.class);
            ResourceBundle rb = Messages.getResourceBundle((Class)clazz, (String)bundleName, (Locale)locale);
            context.put("ResourceBundle", (Object)new ResourceBundleWrapper(rb, bundleName, locale));
            if (contextObjects != null) {
                for (String key : contextObjects.keySet()) {
                    Object value = contextObjects.get(key);
                    context.put(key, value);
                }
            }
            String resourcePath = Messages.localizeResourceName(pathName, resourceKey, locale);
            OutputWriter outputWriter = new OutputWriter(output);
            engine.mergeTemplate(resourcePath, StandardCharsets.UTF_8.name(), (Context)context, (Writer)outputWriter);
            ((Writer)outputWriter).flush();
        }
        catch (IOException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public static void outputResourceWithVelocity(IHTTPOutput output, Class clazz, String bundleName, String pathName, Locale locale, String resourceKey, Map<String, String> substitutionParameters, boolean mapToUpperCase) throws ManifoldCFException {
        HashMap<String, Object> contextObjects = null;
        if (substitutionParameters != null) {
            contextObjects = new HashMap<String, Object>();
            for (String key : substitutionParameters.keySet()) {
                String value = substitutionParameters.get(key);
                if (mapToUpperCase) {
                    key = key.toUpperCase();
                }
                if (value == null) {
                    value = "";
                }
                contextObjects.put(key, value);
                contextObjects.put(key + "_A", Encoder.attributeEscape(value));
                contextObjects.put(key + "_B", Encoder.bodyEscape(value));
                contextObjects.put(key + "_AJ", Encoder.attributeJavascriptEscape(value));
                contextObjects.put(key + "_BJ", Encoder.bodyJavascriptEscape(value));
            }
        }
        Messages.outputResourceWithVelocity(output, clazz, bundleName, pathName, locale, resourceKey, contextObjects);
    }

    private static String localizeResourceName(String pathName, String resourceName, Locale locale) {
        return resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputResource(IHTTPOutput output, Class classInstance, String pathName, Locale locale, String resourceKey, Map<String, String> substitutionParameters, boolean mapToUpperCase) throws ManifoldCFException {
        try (InputStream is = Messages.getResourceAsStream((Class)classInstance, (String)pathName, (Locale)locale, (String)resourceKey);){
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                if (substitutionParameters != null) {
                    Iterator<String> i = substitutionParameters.keySet().iterator();
                    boolean parsedLine = false;
                    while (i.hasNext()) {
                        String key = i.next();
                        String value = substitutionParameters.get(key);
                        if (mapToUpperCase) {
                            key = key.toUpperCase();
                        }
                        if (value == null) {
                            value = "";
                        }
                        line = Messages.doReplace(line, "${" + key + "}", value);
                        line = Messages.doReplace(line, "${" + key + ":A}", Encoder.attributeEscape(value));
                        line = Messages.doReplace(line, "${" + key + ":B}", Encoder.bodyEscape(value));
                        line = Messages.doReplace(line, "${" + key + ":AJ}", Encoder.attributeJavascriptEscape(value));
                        line = Messages.doReplace(line, "${" + key + ":BJ}", Encoder.bodyJavascriptEscape(value));
                    }
                }
                output.println(line);
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    private static String doReplace(String line, String key, String value) {
        if (line.indexOf(key) == -1) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (true) {
            int newIndex;
            if ((newIndex = line.indexOf(key, index)) == -1) break;
            sb.append(line.substring(index, newIndex)).append(value);
            index = newIndex + key.length();
        }
        sb.append(line.substring(index));
        return sb.toString();
    }

    public static String getBodyString(Class clazz, String bundleName, Locale locale, String messageKey, Object[] args) {
        return Encoder.bodyEscape(Messages.getString((Class)clazz, (String)bundleName, (Locale)locale, (String)messageKey, (Object[])args));
    }

    public static String getAttributeString(Class clazz, String bundleName, Locale locale, String messageKey, Object[] args) {
        return Encoder.attributeEscape(Messages.getString((Class)clazz, (String)bundleName, (Locale)locale, (String)messageKey, (Object[])args));
    }

    public static String getAttributeJavascriptString(Class clazz, String bundleName, Locale locale, String messageKey, Object[] args) {
        return Encoder.attributeJavascriptEscape(Messages.getString((Class)clazz, (String)bundleName, (Locale)locale, (String)messageKey, (Object[])args));
    }

    public static String getBodyJavascriptString(Class clazz, String bundleName, Locale locale, String messageKey, Object[] args) {
        return Encoder.bodyJavascriptEscape(Messages.getString((Class)clazz, (String)bundleName, (Locale)locale, (String)messageKey, (Object[])args));
    }

    private static class OutputWriter
    extends Writer {
        private IHTTPOutput output;

        public OutputWriter(IHTTPOutput output) {
            this.output = output;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off == 0 && len == cbuf.length) {
                this.output.print(cbuf);
            } else {
                this.output.print(new String(cbuf, off, len));
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    }
}

