/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.alfrescowebscript;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.authorities.authorities.alfrescowebscript.Messages;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ConfigurationHandler {
    private static final String PARAM_PROTOCOL = "protocol";
    private static final String PARAM_HOSTNAME = "hostname";
    private static final String PARAM_PORT = "port";
    private static final String PARAM_ENDPOINT = "endpoint";
    private static final String PARAM_USERNAME = "username";
    private static final String PARAM_PASSWORD = "password";
    private static final String EDIT_CONFIG_HEADER = "editConfiguration.js";
    private static final String EDIT_CONFIG_SERVER = "editConfiguration_Server.html";
    private static final String VIEW_CONFIG = "viewConfiguration.html";
    private static final Map<String, String> DEFAULT_CONFIGURATION_PARAMETERS = new HashMap<String, String>();

    private ConfigurationHandler() {
    }

    public static void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "Alfresco.Server"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ConfigurationHandler.fillInParameters(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER, paramMap);
    }

    private static void fillInParameters(Map<String, Object> paramMap, IHTTPOutput out, ConfigParams parameters) {
        for (Map.Entry<String, String> parameter : DEFAULT_CONFIGURATION_PARAMETERS.entrySet()) {
            String paramValue;
            String paramName = parameter.getKey();
            if (paramName.endsWith(PARAM_PASSWORD)) {
                paramValue = parameters.getObfuscatedParameter(paramName);
                if (paramValue == null) {
                    paramValue = parameter.getValue();
                }
                paramMap.put(paramName, out.mapPasswordToKey(paramValue));
                continue;
            }
            paramValue = parameters.getParameter(paramName);
            if (paramValue == null) {
                paramValue = parameter.getValue();
            }
            paramMap.put(paramName, paramValue);
        }
    }

    public static void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tabName", tabName);
        ConfigurationHandler.fillInParameters(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_SERVER, paramMap);
    }

    public static String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        for (String paramName : DEFAULT_CONFIGURATION_PARAMETERS.keySet()) {
            String paramValue = variableContext.getParameter(paramName);
            if (paramValue == null) continue;
            if (paramName.endsWith(PARAM_PASSWORD)) {
                parameters.setObfuscatedParameter(paramName, variableContext.mapKeyToPassword(paramValue));
                continue;
            }
            parameters.setParameter(paramName, paramValue);
        }
        return null;
    }

    public static void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ConfigurationHandler.fillInParameters(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG, paramMap);
    }

    static {
        DEFAULT_CONFIGURATION_PARAMETERS.put(PARAM_PROTOCOL, "http");
        DEFAULT_CONFIGURATION_PARAMETERS.put(PARAM_HOSTNAME, "localhost");
        DEFAULT_CONFIGURATION_PARAMETERS.put(PARAM_PORT, "8080");
        DEFAULT_CONFIGURATION_PARAMETERS.put(PARAM_ENDPOINT, "/alfresco/service");
        DEFAULT_CONFIGURATION_PARAMETERS.put(PARAM_USERNAME, "");
        DEFAULT_CONFIGURATION_PARAMETERS.put(PARAM_PASSWORD, "");
    }
}

