/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.amazoncloudsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.output.amazoncloudsearch.DocumentRecord;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.TempFileInput;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;

public class DocumentChunkManager
extends BaseTable {
    private static final String UID_FIELD = "uid";
    private static final String URI_FIELD = "documenturi";
    private static final String ACTIVITY_FIELD = "activity";
    private static final String LENGTH_FIELD = "doclength";
    private static final String HOST_FIELD = "serverhost";
    private static final String PATH_FIELD = "serverpath";
    private static final String SDF_DATA_FIELD = "sdfdata";

    public DocumentChunkManager(IDBInterface database) {
        super(database, "amazoncloudsearch_documentdata");
    }

    public void install() throws ManifoldCFException {
        block5: {
            HashMap<String, ColumnDescription> map;
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                map = new HashMap<String, ColumnDescription>();
                map.put(UID_FIELD, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(HOST_FIELD, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(PATH_FIELD, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(URI_FIELD, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(ACTIVITY_FIELD, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(LENGTH_FIELD, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(SDF_DATA_FIELD, new ColumnDescription("BLOB", false, true, null, null, false));
                this.performCreate(map, null);
            } else if (existing.get(URI_FIELD) == null) {
                map = new HashMap();
                map.put(URI_FIELD, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(ACTIVITY_FIELD, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(LENGTH_FIELD, new ColumnDescription("BIGINT", false, true, null, null, false));
                this.performAlter(map, null, null, null);
            }
            IndexDescription keyIndex = new IndexDescription(true, new String[]{HOST_FIELD, PATH_FIELD, UID_FIELD});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (keyIndex != null && id.equals((Object)keyIndex)) {
                    keyIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (keyIndex == null) break block5;
            this.performAddIndex(null, keyIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordDocument(String uid, String host, String path, String uri, String activity, Long length, InputStream sdfData) throws ManifoldCFException, IOException {
        TempFileInput tfi = null;
        try {
            try {
                tfi = new TempFileInput(sdfData);
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    throw e;
                }
                throw new IOException("Fetch failed: " + e.getMessage());
            }
            while (true) {
                long sleepAmt = 0L;
                try {
                    this.beginTransaction();
                    try {
                        ArrayList params = new ArrayList();
                        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(HOST_FIELD, (Object)host), new UnitaryClause(PATH_FIELD, (Object)path), new UnitaryClause(UID_FIELD, (Object)uid)});
                        IResultSet set = this.performQuery("SELECT uid FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", params, null, null);
                        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                        parameterMap.put(SDF_DATA_FIELD, tfi);
                        parameterMap.put(URI_FIELD, uri);
                        parameterMap.put(ACTIVITY_FIELD, activity);
                        if (length != null) {
                            parameterMap.put(LENGTH_FIELD, length);
                        }
                        if (set.getRowCount() > 0) {
                            this.performUpdate(parameterMap, " WHERE " + query, params, null);
                        } else {
                            parameterMap.put(UID_FIELD, uid);
                            parameterMap.put(HOST_FIELD, host);
                            parameterMap.put(PATH_FIELD, path);
                            this.performInsert(parameterMap, null);
                        }
                    }
                    catch (ManifoldCFException e) {
                        this.signalRollback();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        this.signalRollback();
                        throw e;
                    }
                    finally {
                        this.endTransaction();
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 6) {
                        sleepAmt = this.getSleepAmt();
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        finally {
            if (tfi != null) {
                tfi.discard();
            }
        }
    }

    public boolean equalOrMoreThan(String host, String path, int maximumNumber) throws ManifoldCFException {
        long count;
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(HOST_FIELD, (Object)host), new UnitaryClause(PATH_FIELD, (Object)path)});
        IResultSet set = this.performQuery("SELECT " + this.constructCountClause(UID_FIELD) + " AS countval FROM " + this.getTableName() + " WHERE " + query + " " + this.constructOffsetLimitClause(0, maximumNumber), params, null, null);
        if (set.getRowCount() > 0) {
            IResultRow row = set.getRow(0);
            Long countVal = (Long)row.getValue("countval");
            count = countVal;
        } else {
            count = 0L;
        }
        return count >= (long)maximumNumber;
    }

    public DocumentRecord[] readChunk(String host, String path, int maximumNumber) throws ManifoldCFException {
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(HOST_FIELD, (Object)host), new UnitaryClause(PATH_FIELD, (Object)path)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query + " " + this.constructOffsetLimitClause(0, maximumNumber), params, null, null);
        DocumentRecord[] rval = new DocumentRecord[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = new DocumentRecord(host, path, (String)row.getValue(UID_FIELD), (String)row.getValue(URI_FIELD), (String)row.getValue(ACTIVITY_FIELD), (Long)row.getValue(LENGTH_FIELD), (BinaryInput)row.getValue(SDF_DATA_FIELD));
        }
        return rval;
    }

    public void deleteChunk(DocumentRecord[] records) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            try {
                this.beginTransaction();
                try {
                    for (DocumentRecord dr : records) {
                        String host = dr.getHost();
                        String path = dr.getPath();
                        String uid = dr.getUid();
                        ArrayList params = new ArrayList();
                        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(HOST_FIELD, (Object)host), new UnitaryClause(PATH_FIELD, (Object)path), new UnitaryClause(UID_FIELD, (Object)uid)});
                        this.performDelete("WHERE " + query, params, null);
                    }
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (RuntimeException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 6) {
                    sleepAmt = this.getSleepAmt();
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

