/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.documentfilter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.transformation.BaseTransformationConnector;
import org.apache.manifoldcf.agents.transformation.documentfilter.Messages;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class DocumentFilter
extends BaseTransformationConnector {
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_CONTENTS_HTML = "editSpecification_Contents.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    protected static final String ACTIVITY_FILTER = "filter";
    protected static final String[] activitiesList = new String[]{"filter"};

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public VersionContext getPipelineDescription(Specification os) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(os);
        return new VersionContext(sp.toPackedString(), this.params, os);
    }

    public boolean checkDateIndexable(VersionContext outputDescription, Date date, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(outputDescription.getSpecification());
        return this.checkDateIndexable(sp, outputDescription, date, activities);
    }

    protected boolean checkDateIndexable(SpecPacker sp, VersionContext outputDescription, Date date, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (sp.checkDate(date)) {
            return super.checkDateIndexable(outputDescription, date, activities);
        }
        return false;
    }

    public boolean checkMimeTypeIndexable(VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(outputDescription.getSpecification());
        return this.checkMimeTypeIndexable(sp, outputDescription, mimeType, activities);
    }

    protected boolean checkMimeTypeIndexable(SpecPacker sp, VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (sp.checkMimeType(mimeType)) {
            return super.checkMimeTypeIndexable(outputDescription, mimeType, activities);
        }
        return false;
    }

    public boolean checkLengthIndexable(VersionContext outputDescription, long length, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(outputDescription.getSpecification());
        return this.checkLengthIndexable(sp, outputDescription, length, activities);
    }

    protected boolean checkLengthIndexable(SpecPacker sp, VersionContext outputDescription, long length, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (sp.checkLengthIndexable(length)) {
            return super.checkLengthIndexable(outputDescription, length, activities);
        }
        return false;
    }

    public boolean checkURLIndexable(VersionContext outputDescription, String url, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(outputDescription.getSpecification());
        return this.checkURLIndexable(sp, outputDescription, url, activities);
    }

    protected boolean checkURLIndexable(SpecPacker sp, VersionContext outputDescription, String url, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (sp.checkURLIndexable(url)) {
            return super.checkURLIndexable(outputDescription, url, activities);
        }
        return false;
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext outputDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        SpecPacker sp = new SpecPacker(outputDescription.getSpecification());
        if (!this.checkURLIndexable(sp, outputDescription, documentURI, (IOutputCheckActivity)activities)) {
            activities.noDocument();
            activities.recordActivity(null, ACTIVITY_FILTER, null, documentURI, "EXCLUDEDURL", "Rejected due to URL ('" + documentURI + "')");
            if (Logging.ingest.isDebugEnabled()) {
                Logging.ingest.debug((Object)("Document filter: Rejected document " + documentURI + " due to URL ('" + documentURI + "')"));
            }
            return 1;
        }
        if (!this.checkLengthIndexable(sp, outputDescription, document.getBinaryLength(), (IOutputCheckActivity)activities)) {
            activities.noDocument();
            activities.recordActivity(null, ACTIVITY_FILTER, null, documentURI, "EXCLUDEDLENGTH", "Rejected due to length (" + document.getBinaryLength() + ")");
            if (Logging.ingest.isDebugEnabled()) {
                Logging.ingest.debug((Object)("Document filter: Rejected document " + documentURI + " due to length (" + document.getBinaryLength() + ")"));
            }
            return 1;
        }
        if (!this.checkMimeTypeIndexable(sp, outputDescription, document.getMimeType(), (IOutputCheckActivity)activities)) {
            activities.noDocument();
            activities.recordActivity(null, ACTIVITY_FILTER, null, documentURI, "EXCLUDEDMIMETYPE", "Rejected due to mime type ('" + document.getMimeType() + "')");
            if (Logging.ingest.isDebugEnabled()) {
                Logging.ingest.debug((Object)("Document filter: Rejected document " + documentURI + " due to mime type ('" + document.getMimeType() + "')"));
            }
            return 1;
        }
        if (!this.checkDateIndexable(sp, outputDescription, document.getModifiedDate(), (IOutputCheckActivity)activities)) {
            activities.noDocument();
            activities.recordActivity(null, ACTIVITY_FILTER, null, documentURI, "EXCLUDEDDATE", "Rejected due to date ('" + document.getModifiedDate() + "')");
            if (Logging.ingest.isDebugEnabled()) {
                Logging.ingest.debug((Object)("Document filter: Rejected document " + documentURI + " due to date ('" + document.getModifiedDate() + "')"));
            }
            return 1;
        }
        return activities.sendDocument(documentURI, document);
    }

    protected static void fillInContentsSpecificationMap(Map<String, Object> paramMap, Specification os) {
        String minFileSize = "0";
        String maxFileSize = "1000000000";
        String allowedMimeTypes = "*\napplication/msword\napplication/vnd.ms-excel\napplication/vnd.openxmlformats-officedocument.wordprocessingml.document\napplication/vnd.openxmlformats-officedocument.spreadsheetml.sheet\ntext/html\napplication/pdf\napplication/vnd.ms-powerpoint\napplication/vnd.openxmlformats-officedocument.presentationml.presentation\napplication/vnd.oasis.opendocument.text\napplication/vnd.oasis.opendocument.spreadsheet\napplication/vnd.oasis.opendocument.formula\napplication/rtf\ntext/plain\naudio/mpeg\naudio/x-wav\naudio/ogg\naudio/flac\napplication/x-bittorrent";
        String allowedFileExtensions = "*\nlog\ndoc\ndocx\nxls\nxlsx\nppt\npptx\nhtml\npdf\nodt\nods\nrtf\ntxt\nmp3\nmp4\nwav\nogg\nflac\ntorrent";
        Long minDate = null;
        for (int i = 0; i < os.getChildCount(); ++i) {
            SpecificationNode sn = os.getChild(i);
            if (sn.getType().equals("maxlength")) {
                maxFileSize = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("minlength")) {
                minFileSize = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("mimetypes")) {
                allowedMimeTypes = sn.getValue();
                continue;
            }
            if (sn.getType().equals("extensions")) {
                allowedFileExtensions = sn.getValue();
                continue;
            }
            if (!sn.getType().equals("mindate")) continue;
            minDate = new Long(sn.getAttributeValue("value"));
        }
        paramMap.put("MINFILESIZE", minFileSize);
        paramMap.put("MAXFILESIZE", maxFileSize);
        paramMap.put("MIMETYPES", allowedMimeTypes);
        paramMap.put("EXTENSIONS", allowedFileExtensions);
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(minDate == null ? 0L : minDate);
        paramMap.put("MINDATEYEAR", Integer.toString(c.get(1)));
        paramMap.put("MINDATEMONTH", Integer.toString(c.get(2)));
        paramMap.put("MINDATEDAY", Integer.toString(c.get(5)));
        paramMap.put("MINDATEHOUR", Integer.toString(c.get(11)));
        paramMap.put("MINDATEMINUTE", String.format("%02d", c.get(12)));
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "DocumentFilter.ContentsTabName"));
        DocumentFilter.fillInContentsSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        DocumentFilter.fillInContentsSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_CONTENTS_HTML, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        SpecificationNode sn;
        SpecificationNode node;
        String x;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String minDateYear = variableContext.getParameter(seqPrefix + "mindateyear");
        String minDateMonth = variableContext.getParameter(seqPrefix + "mindatemonth");
        String minDateDay = variableContext.getParameter(seqPrefix + "mindateday");
        String minDateHour = variableContext.getParameter(seqPrefix + "mindatehour");
        String minDateMinute = variableContext.getParameter(seqPrefix + "mindateminute");
        if (minDateYear != null && minDateMonth != null && minDateDay != null && minDateHour != null && minDateMinute != null) {
            GregorianCalendar c = new GregorianCalendar();
            try {
                c.set(Integer.parseInt(minDateYear), Integer.parseInt(minDateMonth), Integer.parseInt(minDateDay), Integer.parseInt(minDateHour), Integer.parseInt(minDateMinute));
            }
            catch (Exception e) {
                // empty catch block
            }
            long theTime = c.getTimeInMillis();
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode node2 = os.getChild(i);
                if (node2.getType().equals("mindate")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode sn2 = new SpecificationNode("mindate");
            sn2.setAttribute("value", new Long(theTime).toString());
            os.addChild(os.getChildCount(), (ConfigurationNode)sn2);
        }
        if ((x = variableContext.getParameter(seqPrefix + "minfilesize")) != null) {
            int i = 0;
            while (i < os.getChildCount()) {
                node = os.getChild(i);
                if (node.getType().equals("minlength")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode("minlength");
            sn.setAttribute("value", x);
            os.addChild(os.getChildCount(), (ConfigurationNode)sn);
        }
        if ((x = variableContext.getParameter(seqPrefix + "maxfilesize")) != null) {
            int i = 0;
            while (i < os.getChildCount()) {
                node = os.getChild(i);
                if (node.getType().equals("maxlength")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode("maxlength");
            sn.setAttribute("value", x);
            os.addChild(os.getChildCount(), (ConfigurationNode)sn);
        }
        if ((x = variableContext.getParameter(seqPrefix + "mimetypes")) != null) {
            int i = 0;
            while (i < os.getChildCount()) {
                node = os.getChild(i);
                if (node.getType().equals("mimetypes")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode("mimetypes");
            sn.setValue(x);
            os.addChild(os.getChildCount(), (ConfigurationNode)sn);
        }
        if ((x = variableContext.getParameter(seqPrefix + "extensions")) != null) {
            int i = 0;
            while (i < os.getChildCount()) {
                node = os.getChild(i);
                if (node.getType().equals("extensions")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode("extensions");
            sn.setValue(x);
            os.addChild(os.getChildCount(), (ConfigurationNode)sn);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        DocumentFilter.fillInContentsSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, paramMap);
    }

    protected static Set<String> fillSet(String input) {
        HashSet<String> rval = new HashSet<String>();
        try {
            StringReader sr = new StringReader(input);
            BufferedReader br = new BufferedReader(sr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("*")) {
                    rval = null;
                    continue;
                }
                if (rval == null || line.length() <= 0) continue;
                rval.add(line.toLowerCase(Locale.ROOT));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception reading strings: " + e.getMessage(), e);
        }
        return rval;
    }

    protected static class SpecPacker {
        private final Set<String> extensions;
        private final Set<String> mimeTypes;
        private final Long minLength;
        private final Long lengthCutoff;
        private final Long minDate;

        public SpecPacker(Specification os) {
            Long minDate = null;
            Long minLength = null;
            Long lengthCutoff = null;
            String extensions = null;
            String mimeTypes = null;
            for (int i = 0; i < os.getChildCount(); ++i) {
                String value;
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("mimetypes")) {
                    mimeTypes = sn.getValue();
                    continue;
                }
                if (sn.getType().equals("extensions")) {
                    extensions = sn.getValue();
                    continue;
                }
                if (sn.getType().equals("maxlength")) {
                    value = sn.getAttributeValue("value");
                    lengthCutoff = new Long(value);
                    continue;
                }
                if (sn.getType().equals("minlength")) {
                    value = sn.getAttributeValue("value");
                    minLength = new Long(value);
                    continue;
                }
                if (!sn.getType().equals("mindate")) continue;
                value = sn.getAttributeValue("value");
                minDate = new Long(value);
            }
            this.minDate = minDate;
            this.minLength = minLength;
            this.lengthCutoff = lengthCutoff;
            this.extensions = DocumentFilter.fillSet(extensions);
            this.mimeTypes = DocumentFilter.fillSet(mimeTypes);
        }

        public String toPackedString() {
            int i;
            StringBuilder sb = new StringBuilder();
            if (this.lengthCutoff == null) {
                sb.append('-');
            } else {
                sb.append('+');
                DocumentFilter.pack((StringBuilder)sb, (String)this.lengthCutoff.toString(), (char)'+');
            }
            if (this.mimeTypes == null) {
                sb.append('-');
            } else {
                sb.append('+');
                Object[] mimeTypes = new String[this.mimeTypes.size()];
                i = 0;
                for (String mimeType : this.mimeTypes) {
                    mimeTypes[i++] = mimeType;
                }
                Arrays.sort(mimeTypes);
                DocumentFilter.packList((StringBuilder)sb, (String[])((String[])mimeTypes), (char)'+');
            }
            if (this.extensions == null) {
                sb.append('-');
            } else {
                sb.append('+');
                Object[] extensions = new String[this.extensions.size()];
                i = 0;
                for (String extension : this.extensions) {
                    extensions[i++] = extension;
                }
                Arrays.sort(extensions);
                DocumentFilter.packList((StringBuilder)sb, (String[])((String[])extensions), (char)'+');
            }
            if (this.minLength == null) {
                sb.append('-');
            } else {
                sb.append('+');
                DocumentFilter.pack((StringBuilder)sb, (String)this.minLength.toString(), (char)'+');
            }
            if (this.minDate == null) {
                sb.append('-');
            } else {
                sb.append('+');
                DocumentFilter.pack((StringBuilder)sb, (String)this.minDate.toString(), (char)'+');
            }
            return sb.toString();
        }

        public boolean checkLengthIndexable(long length) {
            if (this.minLength != null && length < this.minLength) {
                return false;
            }
            return this.lengthCutoff == null || length <= this.lengthCutoff;
        }

        public boolean checkDate(Date date) {
            return this.minDate == null || date == null || date.getTime() >= this.minDate;
        }

        public boolean checkMimeType(String mimeType) {
            if (mimeType == null) {
                mimeType = "application/unknown";
            }
            if (this.mimeTypes == null) {
                return true;
            }
            return this.mimeTypes.contains(mimeType.toLowerCase(Locale.ROOT));
        }

        public boolean checkURLIndexable(String url) {
            String extension = null;
            try {
                String path = new URI(url).getPath();
                if (path != null) {
                    extension = FilenameUtils.getExtension((String)path);
                }
            }
            catch (URISyntaxException e) {
                extension = FilenameUtils.getExtension((String)url);
            }
            if (extension == null || extension.length() == 0) {
                extension = ".";
            }
            if (this.extensions == null) {
                return true;
            }
            return this.extensions.contains(extension.toLowerCase(Locale.ROOT));
        }
    }
}

