/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.JoinClause;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.NullCheckClause;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.jobs.JobDescription;

public class PipelineManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: PipelineManager.java 1607170 2014-07-01 19:20:49Z kwright $";
    public static final String ownerIDField = "ownerid";
    public static final String ordinalField = "ordinal";
    public static final String prerequisiteField = "prerequisite";
    public static final String outputNameField = "outputname";
    public static final String transformationNameField = "transformationname";
    public static final String connectionDescriptionField = "connectiondesc";
    public static final String connectionSpecField = "connectionspec";

    public PipelineManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "jobpipelines");
    }

    public void install(String ownerTable, String owningTablePrimaryKey, String outputTableName, String outputTableNameField, String transformationTableName, String transformationTableNameField) throws ManifoldCFException {
        block7: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(ownerIDField, new ColumnDescription("BIGINT", false, false, ownerTable, owningTablePrimaryKey, false));
                map.put(ordinalField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(prerequisiteField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(outputNameField, new ColumnDescription("VARCHAR(32)", false, true, outputTableName, outputTableNameField, false));
                map.put(transformationNameField, new ColumnDescription("VARCHAR(32)", false, true, transformationTableName, transformationTableNameField, false));
                map.put(connectionDescriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(connectionSpecField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription ownerIndex = new IndexDescription(false, new String[]{ownerIDField});
            IndexDescription transformationNameIndex = new IndexDescription(false, new String[]{transformationNameField});
            IndexDescription outputNameIndex = new IndexDescription(false, new String[]{outputNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (ownerIndex != null && id.equals((Object)ownerIndex)) {
                    ownerIndex = null;
                    continue;
                }
                if (transformationNameIndex != null && id.equals((Object)transformationNameIndex)) {
                    transformationNameIndex = null;
                    continue;
                }
                if (outputNameIndex != null && id.equals((Object)outputNameIndex)) {
                    outputNameIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (ownerIndex != null) {
                this.performAddIndex(null, ownerIndex);
            }
            if (transformationNameIndex != null) {
                this.performAddIndex(null, transformationNameIndex);
            }
            if (outputNameIndex == null) break block7;
            this.performAddIndex(null, outputNameIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void buildTransformationQueryClause(StringBuilder query, ArrayList params, String parentIDField, List<String> connectionNames) {
        query.append("SELECT 'x' FROM ").append(this.getTableName()).append(" WHERE ");
        query.append(this.buildConjunctionClause(params, new ClauseDescription[]{new JoinClause(parentIDField, ownerIDField), new MultiClause(transformationNameField, connectionNames)}));
    }

    public void buildOutputQueryClause(StringBuilder query, ArrayList params, String parentIDField, List<String> connectionNames) {
        query.append("SELECT 'x' FROM ").append(this.getTableName()).append(" WHERE ");
        query.append(this.buildConjunctionClause(params, new ClauseDescription[]{new JoinClause(parentIDField, ownerIDField), new MultiClause(outputNameField, connectionNames)}));
    }

    public String[] getTransformationConnectionNames(Long ownerID) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        StringBuilder query = new StringBuilder("SELECT ");
        query.append(transformationNameField).append(" FROM ").append(this.getTableName()).append(" WHERE ");
        query.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID), new NullCheckClause(transformationNameField, false)}));
        IResultSet set = this.performQuery(query.toString(), newList, null, null);
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(transformationNameField);
        }
        return rval;
    }

    public String[] getOutputConnectionNames(Long ownerID) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        StringBuilder query = new StringBuilder("SELECT ");
        query.append(outputNameField).append(" FROM ").append(this.getTableName()).append(" WHERE ");
        query.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID), new NullCheckClause(outputNameField, false)}));
        IResultSet set = this.performQuery(query.toString(), newList, null, null);
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(outputNameField);
        }
        return rval;
    }

    public void getRows(Map<Long, JobDescription> returnValues, String ownerIDList, ArrayList ownerIDParams) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + ownerIDField + " IN (" + ownerIDList + ") ORDER BY " + ordinalField + " ASC", ownerIDParams, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long ownerID = (Long)row.getValue(ownerIDField);
            Long prerequisite = (Long)row.getValue(prerequisiteField);
            String outputName = (String)row.getValue(outputNameField);
            String transformationName = (String)row.getValue(transformationNameField);
            String transformationDesc = (String)row.getValue(connectionDescriptionField);
            String transformationSpec = (String)row.getValue(connectionSpecField);
            boolean isOutput = outputName != null && outputName.length() > 0;
            int prerequisiteValue = prerequisite == null ? -1 : (int)prerequisite.longValue();
            JobDescription jd = returnValues.get(ownerID);
            jd.addPipelineStage(prerequisiteValue, isOutput, isOutput ? outputName : transformationName, transformationDesc).fromXML(transformationSpec);
        }
    }

    public boolean compareRows(Long ownerID, IJobDescription job) throws ManifoldCFException {
        HashSet<String> outputSet = new HashSet<String>();
        for (int i = 0; i < job.countPipelineStages(); ++i) {
            if (!job.getPipelineStageIsOutputConnection(i)) continue;
            String outputName = job.getPipelineStageConnectionName(i);
            if (outputSet.contains(outputName)) {
                throw new ManifoldCFException("Output name '" + outputName + "' is duplicated within job; not allowed");
            }
            outputSet.add(outputName);
        }
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query + " ORDER BY " + ordinalField + " ASC", params, null, null);
        if (set.getRowCount() != job.countPipelineStages()) {
            return false;
        }
        for (int i = 0; i < set.getRowCount(); ++i) {
            int prerequisiteValue;
            boolean isOutputConnection;
            IResultRow row = set.getRow(i);
            String outputConnectionName = (String)row.getValue(outputNameField);
            boolean bl = isOutputConnection = outputConnectionName != null && outputConnectionName.length() > 0;
            if (isOutputConnection && !outputSet.contains(outputConnectionName)) {
                throw new ManifoldCFException("Output name '" + outputConnectionName + "' removed from job; not allowed");
            }
            String transformationConnectionName = (String)row.getValue(transformationNameField);
            Long prerequisite = (Long)row.getValue(prerequisiteField);
            String spec = (String)row.getValue(connectionSpecField);
            if (spec == null) {
                spec = "";
            }
            int n = prerequisiteValue = prerequisite == null ? -1 : (int)prerequisite.longValue();
            if (job.getPipelineStagePrerequisite(i) != prerequisiteValue) {
                return false;
            }
            if (job.getPipelineStageIsOutputConnection(i) != isOutputConnection) {
                return false;
            }
            if (!job.getPipelineStageConnectionName(i).equals(isOutputConnection ? outputConnectionName : transformationConnectionName)) {
                return false;
            }
            if (job.getPipelineStageSpecification(i).toXML().equals(spec)) continue;
            return false;
        }
        return true;
    }

    public void writeOutputStage(Long ownerID, String outputConnectionName, String outputSpecification) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ownerIDField, ownerID);
        map.put(ordinalField, new Long(0L));
        map.put(outputNameField, outputConnectionName);
        map.put(connectionSpecField, outputSpecification);
        this.performInsert(map, null);
    }

    public void writeRows(Long ownerID, IJobDescription job) throws ManifoldCFException {
        this.beginTransaction();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < job.countPipelineStages(); ++i) {
                boolean isOutput = job.getPipelineStageIsOutputConnection(i);
                int prerequisite = job.getPipelineStagePrerequisite(i);
                String pipelineConnectionName = job.getPipelineStageConnectionName(i);
                String pipelineStageDescription = job.getPipelineStageDescription(i);
                Specification os = job.getPipelineStageSpecification(i);
                map.clear();
                map.put(ownerIDField, ownerID);
                map.put(ordinalField, new Long(i));
                if (prerequisite != -1) {
                    map.put(prerequisiteField, new Long(prerequisite));
                }
                if (isOutput) {
                    map.put(outputNameField, pipelineConnectionName);
                } else {
                    map.put(transformationNameField, pipelineConnectionName);
                }
                if (pipelineStageDescription != null && pipelineStageDescription.length() > 0) {
                    map.put(connectionDescriptionField, pipelineStageDescription);
                }
                map.put(connectionSpecField, os.toXML());
                this.performInsert(map, null);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteRows(Long ownerID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID)});
        this.performDelete("WHERE " + query, list, null);
    }
}

