/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.dropbox;

import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import com.dropbox.client2.session.WebAuthSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.common.XThreadStringBuffer;

public class DropboxSession {
    private DropboxAPI<?> client;

    public DropboxSession(String app_key, String app_secret, String key, String secret) {
        AppKeyPair appKeyPair = new AppKeyPair(app_key, app_secret);
        WebAuthSession session = new WebAuthSession(appKeyPair, Session.AccessType.DROPBOX);
        AccessTokenPair ac = new AccessTokenPair(key, secret);
        session.setAccessTokenPair(ac);
        this.client = new DropboxAPI((Session)session);
    }

    public Map<String, String> getRepositoryInfo() throws DropboxException {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Country", this.client.accountInfo().country);
        info.put("Display Name", this.client.accountInfo().displayName);
        info.put("Referral Link", this.client.accountInfo().referralLink);
        info.put("Quota", String.valueOf(this.client.accountInfo().quota));
        info.put("Quota Normal", String.valueOf(this.client.accountInfo().quotaNormal));
        info.put("Quota Shared", String.valueOf(this.client.accountInfo().quotaShared));
        info.put("Uid", String.valueOf(this.client.accountInfo().uid));
        return info;
    }

    public void getSeeds(XThreadStringBuffer idBuffer, String path, int max_dirs) throws DropboxException, InterruptedException {
        idBuffer.add(path);
        DropboxAPI.Entry root_entry = this.client.metadata(path, max_dirs, null, true, null);
        List entries = root_entry.contents;
        for (DropboxAPI.Entry e : entries) {
            if (!e.isDir) continue;
            idBuffer.add(e.path);
        }
    }

    public DropboxAPI.Entry getObject(String id) throws DropboxException {
        return this.client.metadata(id, 25000, null, true, null);
    }

    public DropboxAPI.DropboxInputStream getDropboxInputStream(String id) throws DropboxException {
        return this.client.getFileStream(id, null);
    }

    public void close() {
    }
}

