/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class XThreadInputStream
extends InputStream {
    private final byte[] buffer = new byte[65536];
    private int startPoint = 0;
    private int byteCount = 0;
    private boolean streamEnd = false;
    private IOException failureException = null;
    private boolean abort = false;
    private final InputStream sourceStream;

    public XThreadInputStream(InputStream sourceStream) {
        this.sourceStream = sourceStream;
    }

    public XThreadInputStream() {
        this.sourceStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        XThreadInputStream xThreadInputStream = this;
        synchronized (xThreadInputStream) {
            this.abort = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stuffQueue(byte[] byteBuffer, int offset, int amount) throws InterruptedException {
        while (amount > 0) {
            int readStartPoint;
            int maxToRead;
            XThreadInputStream xThreadInputStream = this;
            synchronized (xThreadInputStream) {
                if (this.abort || this.streamEnd) {
                    return;
                }
                maxToRead = this.buffer.length - this.byteCount;
                if (maxToRead == 0) {
                    this.wait();
                    continue;
                }
                readStartPoint = this.startPoint + this.byteCount & this.buffer.length - 1;
            }
            if (readStartPoint + maxToRead >= this.buffer.length) {
                maxToRead = this.buffer.length - readStartPoint;
            }
            int amt = amount > maxToRead ? maxToRead : amount;
            System.arraycopy(byteBuffer, offset, this.buffer, readStartPoint, amt);
            offset += amt;
            amount -= amt;
            XThreadInputStream xThreadInputStream2 = this;
            synchronized (xThreadInputStream2) {
                this.byteCount += amt;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneStuffingQueue() {
        XThreadInputStream xThreadInputStream = this;
        synchronized (xThreadInputStream) {
            this.streamEnd = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stuffQueue() throws IOException, InterruptedException {
        while (true) {
            int readStartPoint;
            int maxToRead;
            XThreadInputStream xThreadInputStream = this;
            synchronized (xThreadInputStream) {
                if (this.streamEnd || this.abort) {
                    return;
                }
                maxToRead = this.buffer.length - this.byteCount;
                if (maxToRead == 0) {
                    this.wait();
                    continue;
                }
                readStartPoint = this.startPoint + this.byteCount & this.buffer.length - 1;
            }
            if (readStartPoint + maxToRead >= this.buffer.length) {
                maxToRead = this.buffer.length - readStartPoint;
            }
            int amt = -1;
            IOException exception = null;
            try {
                amt = this.sourceStream.read(this.buffer, readStartPoint, maxToRead);
            }
            catch (IOException e) {
                exception = e;
            }
            XThreadInputStream xThreadInputStream2 = this;
            synchronized (xThreadInputStream2) {
                if (exception != null) {
                    this.failureException = exception;
                } else if (amt == -1) {
                    this.streamEnd = true;
                } else {
                    this.byteCount += amt;
                }
                this.notifyAll();
            }
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int amt = this.read(b, 0, 1);
        if (amt == -1) {
            return amt;
        }
        return b[0] & 0xFFFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int totalAmt = 0;
            while (true) {
                int copyLen;
                if (len == 0) {
                    return totalAmt;
                }
                XThreadInputStream xThreadInputStream = this;
                synchronized (xThreadInputStream) {
                    int remLen;
                    copyLen = this.byteCount;
                    if (copyLen > len) {
                        copyLen = len;
                    }
                    if (copyLen > (remLen = this.buffer.length - this.startPoint)) {
                        copyLen = remLen;
                    }
                    if (copyLen == 0) {
                        if (this.streamEnd) {
                            if (totalAmt != 0) {
                                return totalAmt;
                            }
                            return -1;
                        }
                        if (this.failureException != null) {
                            throw this.failureException;
                        }
                        this.wait();
                        continue;
                    }
                }
                System.arraycopy(this.buffer, this.startPoint, b, off, copyLen);
                totalAmt += copyLen;
                off += copyLen;
                len -= copyLen;
                xThreadInputStream = this;
                synchronized (xThreadInputStream) {
                    this.startPoint += copyLen;
                    this.startPoint &= this.buffer.length - 1;
                    this.byteCount -= copyLen;
                    this.notifyAll();
                }
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return 0L;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }
}

