/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.mappers.regexp;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.manifoldcf.authorities.mappers.BaseMappingConnector;
import org.apache.manifoldcf.authorities.mappers.regexp.MatchMap;
import org.apache.manifoldcf.authorities.mappers.regexp.Messages;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.ui.util.Encoder;

public class RegexpMapper
extends BaseMappingConnector {
    public static final String _rcsid = "@(#)$Id: RegexpMapper.java 1498125 2013-06-30 14:04:52Z kwright $";
    private MatchMap matchMap = null;

    public void disconnect() throws ManifoldCFException {
        this.matchMap = null;
        super.disconnect();
    }

    private MatchMap getSession() throws ManifoldCFException {
        if (this.matchMap == null) {
            this.matchMap = new MatchMap(this.params.getParameter("User name map"));
        }
        return this.matchMap;
    }

    public String mapUser(String userName) throws ManifoldCFException {
        MatchMap mm = this.getSession();
        String outputUserName = mm.translate(userName);
        if (Logging.mappingConnectors.isDebugEnabled()) {
            Logging.mappingConnectors.debug((Object)("RegexpMapper: Input user name '" + userName + "'; output user name '" + outputUserName + "'"));
        }
        return outputUserName;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "RegexpMapper.UserMapping"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.usernameregexp.value != \"\" && !isRegularExpression(editconnection.usernameregexp.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "RegexpMapper.UserNameRegularExpressionMustBeValidRegularExpression") + "\");\n" + "    editconnection.usernameregexp.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "\n" + "function checkConfigForSave()\n" + "{\n" + "  if (editconnection.usernameregexp.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "RegexpMapper.UserNameRegularExpressionCannotBeNull") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "RegexpMapper.UserMapping") + "\");\n" + "    editconnection.usernameregexp.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "//-->\n" + "</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String userNameMapping = parameters.getParameter("User name map");
        if (userNameMapping == null) {
            userNameMapping = "^(.*)\\\\@([A-Z|a-z|0-9|_|-]*)\\\\.(.*)$=$(2)\\\\$(1l)";
        }
        MatchMap matchMap = new MatchMap(userNameMapping);
        String usernameRegexp = matchMap.getMatchString(0);
        String livelinkUserExpr = matchMap.getReplaceString(0);
        if (tabName.equals(Messages.getString(locale, "RegexpMapper.UserMapping"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RegexpMapper.UserNameRegularExpressionColon") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"40\" name=\"usernameregexp\" value=\"" + Encoder.attributeEscape((String)usernameRegexp) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RegexpMapper.UserExpressionColon") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"40\" name=\"livelinkuserexpr\" value=\"" + Encoder.attributeEscape((String)livelinkUserExpr) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"usernameregexp\" value=\"" + Encoder.attributeEscape((String)usernameRegexp) + "\"/>\n" + "<input type=\"hidden\" name=\"livelinkuserexpr\" value=\"" + Encoder.attributeEscape((String)livelinkUserExpr) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String usernameRegexp = variableContext.getParameter("usernameregexp");
        String livelinkUserExpr = variableContext.getParameter("livelinkuserexpr");
        if (usernameRegexp != null && livelinkUserExpr != null) {
            MatchMap matchMap = new MatchMap();
            matchMap.appendMatchPair(usernameRegexp, livelinkUserExpr);
            parameters.setParameter("User name map", matchMap.toString());
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        MatchMap matchMap = new MatchMap(parameters.getParameter("User name map"));
        String usernameRegexp = matchMap.getMatchString(0);
        String livelinkUserExpr = matchMap.getReplaceString(0);
        out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RegexpMapper.UserNameRegularExpressionColon") + "</nobr></td>\n" + "    <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)usernameRegexp) + "</nobr></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "RegexpMapper.UserExpressionColon") + "</nobr></td>\n" + "    <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)livelinkUserExpr) + "</nobr></td>\n" + "  </tr>\n" + "</table>\n");
    }
}

