/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.handlers;

import java.util.Hashtable;
import org.exolab.castor.mapping.MapHandler;
import org.exolab.castor.mapping.handlers.J1MapHandler;

public final class MapHandlers {
    private static final String J2MAP_CLASSNAME = "java.util.Map";
    private static final String J2MAP_HANDLER_CLASSNAME = "org.exolab.castor.mapping.handlers.J2MapHandler";
    private static MapHandler HASHTABLE_HANDLER = new J1MapHandler();
    private static MapHandler ANYMAP_HANDLER = null;
    private static Class J2MapClass = null;

    public static MapHandler getHandler(Object object) {
        if (object == null) {
            return null;
        }
        return MapHandlers.getHandler(object.getClass());
    }

    public static MapHandler getHandler(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (Hashtable.class.isAssignableFrom(clazz)) {
            return HASHTABLE_HANDLER;
        }
        if (J2MapClass != null && J2MapClass.isAssignableFrom(clazz)) {
            return ANYMAP_HANDLER;
        }
        return null;
    }

    static {
        if (J2MapClass == null) {
            try {
                ClassLoader loader = MapHandlers.class.getClassLoader();
                J2MapClass = loader != null ? loader.loadClass(J2MAP_CLASSNAME) : Class.forName(J2MAP_CLASSNAME);
                Class<?> handler = Class.forName(J2MAP_HANDLER_CLASSNAME);
                ANYMAP_HANDLER = (MapHandler)handler.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

