/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.text.ParseException;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.types.Duration;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSDuration
extends XSType {
    private static final JType JTYPE = new JClass("org.exolab.castor.types.Duration");
    private static final Log LOG = LogFactory.getLog((Class)XSDuration.class);
    private Duration _maxInclusive;
    private Duration _maxExclusive;
    private Duration _minInclusive;
    private Duration _minExclusive;

    public XSDuration() {
        super((short)2);
    }

    public JType getJType() {
        return JTYPE;
    }

    public Duration getMaxExclusive() {
        return this._maxExclusive;
    }

    public Duration getMaxInclusive() {
        return this._maxInclusive;
    }

    public Duration getMinExclusive() {
        return this._minExclusive;
    }

    public Duration getMinInclusive() {
        return this._minInclusive;
    }

    public void setMaxExclusive(Duration max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(Duration max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(Duration min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(Duration min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSDuration.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            try {
                if ("maxExclusive".equals(name)) {
                    this.setMaxExclusive(Duration.parseDuration(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(name)) {
                    this.setMaxInclusive(Duration.parseDuration(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(name)) {
                    this.setMinExclusive(Duration.parseDuration(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(name)) {
                    this.setMinInclusive(Duration.parseDuration(facet.getValue()));
                    continue;
                }
                if (!"pattern".equals(name)) continue;
                LOG.warn((Object)"Warning: The facet 'pattern' is not currently supported for Duration.");
            }
            catch (ParseException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("org.exolab.castor.xml.validators.DurationValidator typeValidator = new org.exolab.castor.xml.validators.DurationValidator();");
        if (this.hasMinimum()) {
            Duration min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(");
            }
            jsc.append("new org.exolab.castor.types.Duration(" + min.toLong() + "L)");
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            Duration max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(");
            }
            jsc.append("new org.exolab.castor.types.Duration(" + max.toLong() + "L)");
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

