﻿// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class SpanishStemmer : SnowballProgram
    {
        // LUCENENET specific: Factored out methodObject by using Func<bool> instead of Reflection

        private readonly static Among[] a_0 = {
                    new Among ( "", -1, 6 ),
                    new Among ( "\u00E1", 0, 1 ),
                    new Among ( "\u00E9", 0, 2 ),
                    new Among ( "\u00ED", 0, 3 ),
                    new Among ( "\u00F3", 0, 4 ),
                    new Among ( "\u00FA", 0, 5 )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "la", -1, -1 ),
                    new Among ( "sela", 0, -1 ),
                    new Among ( "le", -1, -1 ),
                    new Among ( "me", -1, -1 ),
                    new Among ( "se", -1, -1 ),
                    new Among ( "lo", -1, -1 ),
                    new Among ( "selo", 5, -1 ),
                    new Among ( "las", -1, -1 ),
                    new Among ( "selas", 7, -1 ),
                    new Among ( "les", -1, -1 ),
                    new Among ( "los", -1, -1 ),
                    new Among ( "selos", 10, -1 ),
                    new Among ( "nos", -1, -1 )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "ando", -1, 6 ),
                    new Among ( "iendo", -1, 6 ),
                    new Among ( "yendo", -1, 7 ),
                    new Among ( "\u00E1ndo", -1, 2 ),
                    new Among ( "i\u00E9ndo", -1, 1 ),
                    new Among ( "ar", -1, 6 ),
                    new Among ( "er", -1, 6 ),
                    new Among ( "ir", -1, 6 ),
                    new Among ( "\u00E1r", -1, 3 ),
                    new Among ( "\u00E9r", -1, 4 ),
                    new Among ( "\u00EDr", -1, 5 )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "ic", -1, -1 ),
                    new Among ( "ad", -1, -1 ),
                    new Among ( "os", -1, -1 ),
                    new Among ( "iv", -1, 1 )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "able", -1, 1 ),
                    new Among ( "ible", -1, 1 ),
                    new Among ( "ante", -1, 1 )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "ic", -1, 1 ),
                    new Among ( "abil", -1, 1 ),
                    new Among ( "iv", -1, 1 )
                };

        private readonly static Among[] a_6 = {
                    new Among ( "ica", -1, 1 ),
                    new Among ( "ancia", -1, 2 ),
                    new Among ( "encia", -1, 5 ),
                    new Among ( "adora", -1, 2 ),
                    new Among ( "osa", -1, 1 ),
                    new Among ( "ista", -1, 1 ),
                    new Among ( "iva", -1, 9 ),
                    new Among ( "anza", -1, 1 ),
                    new Among ( "log\u00EDa", -1, 3 ),
                    new Among ( "idad", -1, 8 ),
                    new Among ( "able", -1, 1 ),
                    new Among ( "ible", -1, 1 ),
                    new Among ( "ante", -1, 2 ),
                    new Among ( "mente", -1, 7 ),
                    new Among ( "amente", 13, 6 ),
                    new Among ( "aci\u00F3n", -1, 2 ),
                    new Among ( "uci\u00F3n", -1, 4 ),
                    new Among ( "ico", -1, 1 ),
                    new Among ( "ismo", -1, 1 ),
                    new Among ( "oso", -1, 1 ),
                    new Among ( "amiento", -1, 1 ),
                    new Among ( "imiento", -1, 1 ),
                    new Among ( "ivo", -1, 9 ),
                    new Among ( "ador", -1, 2 ),
                    new Among ( "icas", -1, 1 ),
                    new Among ( "ancias", -1, 2 ),
                    new Among ( "encias", -1, 5 ),
                    new Among ( "adoras", -1, 2 ),
                    new Among ( "osas", -1, 1 ),
                    new Among ( "istas", -1, 1 ),
                    new Among ( "ivas", -1, 9 ),
                    new Among ( "anzas", -1, 1 ),
                    new Among ( "log\u00EDas", -1, 3 ),
                    new Among ( "idades", -1, 8 ),
                    new Among ( "ables", -1, 1 ),
                    new Among ( "ibles", -1, 1 ),
                    new Among ( "aciones", -1, 2 ),
                    new Among ( "uciones", -1, 4 ),
                    new Among ( "adores", -1, 2 ),
                    new Among ( "antes", -1, 2 ),
                    new Among ( "icos", -1, 1 ),
                    new Among ( "ismos", -1, 1 ),
                    new Among ( "osos", -1, 1 ),
                    new Among ( "amientos", -1, 1 ),
                    new Among ( "imientos", -1, 1 ),
                    new Among ( "ivos", -1, 9 )
                };

        private readonly static Among[] a_7 = {
                    new Among ( "ya", -1, 1 ),
                    new Among ( "ye", -1, 1 ),
                    new Among ( "yan", -1, 1 ),
                    new Among ( "yen", -1, 1 ),
                    new Among ( "yeron", -1, 1 ),
                    new Among ( "yendo", -1, 1 ),
                    new Among ( "yo", -1, 1 ),
                    new Among ( "yas", -1, 1 ),
                    new Among ( "yes", -1, 1 ),
                    new Among ( "yais", -1, 1 ),
                    new Among ( "yamos", -1, 1 ),
                    new Among ( "y\u00F3", -1, 1 )
                };

        private readonly static Among[] a_8 = {
                    new Among ( "aba", -1, 2 ),
                    new Among ( "ada", -1, 2 ),
                    new Among ( "ida", -1, 2 ),
                    new Among ( "ara", -1, 2 ),
                    new Among ( "iera", -1, 2 ),
                    new Among ( "\u00EDa", -1, 2 ),
                    new Among ( "ar\u00EDa", 5, 2 ),
                    new Among ( "er\u00EDa", 5, 2 ),
                    new Among ( "ir\u00EDa", 5, 2 ),
                    new Among ( "ad", -1, 2 ),
                    new Among ( "ed", -1, 2 ),
                    new Among ( "id", -1, 2 ),
                    new Among ( "ase", -1, 2 ),
                    new Among ( "iese", -1, 2 ),
                    new Among ( "aste", -1, 2 ),
                    new Among ( "iste", -1, 2 ),
                    new Among ( "an", -1, 2 ),
                    new Among ( "aban", 16, 2 ),
                    new Among ( "aran", 16, 2 ),
                    new Among ( "ieran", 16, 2 ),
                    new Among ( "\u00EDan", 16, 2 ),
                    new Among ( "ar\u00EDan", 20, 2 ),
                    new Among ( "er\u00EDan", 20, 2 ),
                    new Among ( "ir\u00EDan", 20, 2 ),
                    new Among ( "en", -1, 1 ),
                    new Among ( "asen", 24, 2 ),
                    new Among ( "iesen", 24, 2 ),
                    new Among ( "aron", -1, 2 ),
                    new Among ( "ieron", -1, 2 ),
                    new Among ( "ar\u00E1n", -1, 2 ),
                    new Among ( "er\u00E1n", -1, 2 ),
                    new Among ( "ir\u00E1n", -1, 2 ),
                    new Among ( "ado", -1, 2 ),
                    new Among ( "ido", -1, 2 ),
                    new Among ( "ando", -1, 2 ),
                    new Among ( "iendo", -1, 2 ),
                    new Among ( "ar", -1, 2 ),
                    new Among ( "er", -1, 2 ),
                    new Among ( "ir", -1, 2 ),
                    new Among ( "as", -1, 2 ),
                    new Among ( "abas", 39, 2 ),
                    new Among ( "adas", 39, 2 ),
                    new Among ( "idas", 39, 2 ),
                    new Among ( "aras", 39, 2 ),
                    new Among ( "ieras", 39, 2 ),
                    new Among ( "\u00EDas", 39, 2 ),
                    new Among ( "ar\u00EDas", 45, 2 ),
                    new Among ( "er\u00EDas", 45, 2 ),
                    new Among ( "ir\u00EDas", 45, 2 ),
                    new Among ( "es", -1, 1 ),
                    new Among ( "ases", 49, 2 ),
                    new Among ( "ieses", 49, 2 ),
                    new Among ( "abais", -1, 2 ),
                    new Among ( "arais", -1, 2 ),
                    new Among ( "ierais", -1, 2 ),
                    new Among ( "\u00EDais", -1, 2 ),
                    new Among ( "ar\u00EDais", 55, 2 ),
                    new Among ( "er\u00EDais", 55, 2 ),
                    new Among ( "ir\u00EDais", 55, 2 ),
                    new Among ( "aseis", -1, 2 ),
                    new Among ( "ieseis", -1, 2 ),
                    new Among ( "asteis", -1, 2 ),
                    new Among ( "isteis", -1, 2 ),
                    new Among ( "\u00E1is", -1, 2 ),
                    new Among ( "\u00E9is", -1, 1 ),
                    new Among ( "ar\u00E9is", 64, 2 ),
                    new Among ( "er\u00E9is", 64, 2 ),
                    new Among ( "ir\u00E9is", 64, 2 ),
                    new Among ( "ados", -1, 2 ),
                    new Among ( "idos", -1, 2 ),
                    new Among ( "amos", -1, 2 ),
                    new Among ( "\u00E1bamos", 70, 2 ),
                    new Among ( "\u00E1ramos", 70, 2 ),
                    new Among ( "i\u00E9ramos", 70, 2 ),
                    new Among ( "\u00EDamos", 70, 2 ),
                    new Among ( "ar\u00EDamos", 74, 2 ),
                    new Among ( "er\u00EDamos", 74, 2 ),
                    new Among ( "ir\u00EDamos", 74, 2 ),
                    new Among ( "emos", -1, 1 ),
                    new Among ( "aremos", 78, 2 ),
                    new Among ( "eremos", 78, 2 ),
                    new Among ( "iremos", 78, 2 ),
                    new Among ( "\u00E1semos", 78, 2 ),
                    new Among ( "i\u00E9semos", 78, 2 ),
                    new Among ( "imos", -1, 2 ),
                    new Among ( "ar\u00E1s", -1, 2 ),
                    new Among ( "er\u00E1s", -1, 2 ),
                    new Among ( "ir\u00E1s", -1, 2 ),
                    new Among ( "\u00EDs", -1, 2 ),
                    new Among ( "ar\u00E1", -1, 2 ),
                    new Among ( "er\u00E1", -1, 2 ),
                    new Among ( "ir\u00E1", -1, 2 ),
                    new Among ( "ar\u00E9", -1, 2 ),
                    new Among ( "er\u00E9", -1, 2 ),
                    new Among ( "ir\u00E9", -1, 2 ),
                    new Among ( "i\u00F3", -1, 2 )
                };

        private readonly static Among[] a_9 = {
                    new Among ( "a", -1, 1 ),
                    new Among ( "e", -1, 2 ),
                    new Among ( "o", -1, 1 ),
                    new Among ( "os", -1, 1 ),
                    new Among ( "\u00E1", -1, 1 ),
                    new Among ( "\u00E9", -1, 2 ),
                    new Among ( "\u00ED", -1, 1 ),
                    new Among ( "\u00F3", -1, 1 )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)1, (char)17, (char)4, (char)10 };

        private int I_p2;
        private int I_p1;
        private int I_pV;

        private void copy_from(SpanishStemmer other)
        {
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            I_pV = other.I_pV;
            base.CopyFrom(other);
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_6;
            int v_8;
            // (, line 31
            I_pV = m_limit;
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 37
            v_1 = m_cursor;
            do
            {
                // (, line 37
                // or, line 39
                do
                {
                    v_2 = m_cursor;
                    do
                    {
                        // (, line 38
                        if (!(InGrouping(g_v, 97, 252)))
                        {
                            goto lab2;
                        }
                        // or, line 38
                        do
                        {
                            v_3 = m_cursor;
                            do
                            {
                                // (, line 38
                                if (!(OutGrouping(g_v, 97, 252)))
                                {
                                    goto lab4;
                                }
                                // gopast, line 38
                                while (true)
                                {
                                    do
                                    {
                                        if (!(InGrouping(g_v, 97, 252)))
                                        {
                                            goto lab6;
                                        }
                                        goto golab5;
                                    } while (false);
                                    lab6:
                                    if (m_cursor >= m_limit)
                                    {
                                        goto lab4;
                                    }
                                    m_cursor++;
                                }
                                golab5:
                                goto lab3;
                            } while (false);
                            lab4:
                            m_cursor = v_3;
                            // (, line 38
                            if (!(InGrouping(g_v, 97, 252)))
                            {
                                goto lab2;
                            }
                            // gopast, line 38
                            while (true)
                            {
                                do
                                {
                                    if (!(OutGrouping(g_v, 97, 252)))
                                    {
                                        goto lab8;
                                    }
                                    goto golab7;
                                } while (false);
                                lab8:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab2;
                                }
                                m_cursor++;
                            }
                            golab7: {/* LUCENENET: intentionally blank */}
                        } while (false);
                        lab3:
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = v_2;
                    // (, line 40
                    if (!(OutGrouping(g_v, 97, 252)))
                    {
                        goto lab0;
                    }
                    // or, line 40
                    do
                    {
                        v_6 = m_cursor;
                        do
                        {
                            // (, line 40
                            if (!(OutGrouping(g_v, 97, 252)))
                            {
                                goto lab10;
                            }
                            // gopast, line 40
                            while (true)
                            {
                                do
                                {
                                    if (!(InGrouping(g_v, 97, 252)))
                                    {
                                        goto lab12;
                                    }
                                    goto golab11;
                                } while (false);
                                lab12:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab10;
                                }
                                m_cursor++;
                            }
                            golab11:
                            goto lab9;
                        } while (false);
                        lab10:
                        m_cursor = v_6;
                        // (, line 40
                        if (!(InGrouping(g_v, 97, 252)))
                        {
                            goto lab0;
                        }
                        // next, line 40
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    } while (false);
                    lab9: {/* LUCENENET: intentionally blank */}
                } while (false);
                lab1:
                // setmark pV, line 41
                I_pV = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 43
            v_8 = m_cursor;
            do
            {
                // (, line 43
                // gopast, line 44
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 252)))
                        {
                            goto lab15;
                        }
                        goto golab14;
                    } while (false);
                    lab15:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab14:
                // gopast, line 44
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 252)))
                        {
                            goto lab17;
                        }
                        goto golab16;
                    } while (false);
                    lab17:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab16:
                // setmark p1, line 44
                I_p1 = m_cursor;
                // gopast, line 45
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 252)))
                        {
                            goto lab19;
                        }
                        goto golab18;
                    } while (false);
                    lab19:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab18:
                // gopast, line 45
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 252)))
                        {
                            goto lab21;
                        }
                        goto golab20;
                    } while (false);
                    lab21:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab20:
                // setmark p2, line 45
                I_p2 = m_cursor;
            } while (false);
            lab13:
            m_cursor = v_8;
            return true;
        }

        private bool r_postlude()
        {
            int among_var;
            int v_1;
            // repeat, line 49
            while (true)
            {
                v_1 = m_cursor;
                do
                {
                    // (, line 49
                    // [, line 50
                    m_bra = m_cursor;
                    // substring, line 50
                    among_var = FindAmong(a_0, 6);
                    if (among_var == 0)
                    {
                        goto lab1;
                    }
                    // ], line 50
                    m_ket = m_cursor;
                    switch (among_var)
                    {
                        case 0:
                            goto lab1;
                        case 1:
                            // (, line 51
                            // <-, line 51
                            SliceFrom("a");
                            break;
                        case 2:
                            // (, line 52
                            // <-, line 52
                            SliceFrom("e");
                            break;
                        case 3:
                            // (, line 53
                            // <-, line 53
                            SliceFrom("i");
                            break;
                        case 4:
                            // (, line 54
                            // <-, line 54
                            SliceFrom("o");
                            break;
                        case 5:
                            // (, line 55
                            // <-, line 55
                            SliceFrom("u");
                            break;
                        case 6:
                            // (, line 57
                            // next, line 57
                            if (m_cursor >= m_limit)
                            {
                                goto lab1;
                            }
                            m_cursor++;
                            break;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            return true;
        }

        private bool r_RV()
        {
            if (!(I_pV <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_attached_pronoun()
        {
            int among_var;
            // (, line 67
            // [, line 68
            m_ket = m_cursor;
            // substring, line 68
            if (FindAmongB(a_1, 13) == 0)
            {
                return false;
            }
            // ], line 68
            m_bra = m_cursor;
            // substring, line 72
            among_var = FindAmongB(a_2, 11);
            if (among_var == 0)
            {
                return false;
            }
            // call RV, line 72
            if (!r_RV())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 73
                    // ], line 73
                    m_bra = m_cursor;
                    // <-, line 73
                    SliceFrom("iendo");
                    break;
                case 2:
                    // (, line 74
                    // ], line 74
                    m_bra = m_cursor;
                    // <-, line 74
                    SliceFrom("ando");
                    break;
                case 3:
                    // (, line 75
                    // ], line 75
                    m_bra = m_cursor;
                    // <-, line 75
                    SliceFrom("ar");
                    break;
                case 4:
                    // (, line 76
                    // ], line 76
                    m_bra = m_cursor;
                    // <-, line 76
                    SliceFrom("er");
                    break;
                case 5:
                    // (, line 77
                    // ], line 77
                    m_bra = m_cursor;
                    // <-, line 77
                    SliceFrom("ir");
                    break;
                case 6:
                    // (, line 81
                    // delete, line 81
                    SliceDel();
                    break;
                case 7:
                    // (, line 82
                    // literal, line 82
                    if (!(Eq_S_B(1, "u")))
                    {
                        return false;
                    }
                    // delete, line 82
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_standard_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            // (, line 86
            // [, line 87
            m_ket = m_cursor;
            // substring, line 87
            among_var = FindAmongB(a_6, 46);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 87
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 98
                    // call R2, line 99
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 99
                    SliceDel();
                    break;
                case 2:
                    // (, line 104
                    // call R2, line 105
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 105
                    SliceDel();
                    // try, line 106
                    v_1 = m_limit - m_cursor;
                    do
                    {
                        // (, line 106
                        // [, line 106
                        m_ket = m_cursor;
                        // literal, line 106
                        if (!(Eq_S_B(2, "ic")))
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        // ], line 106
                        m_bra = m_cursor;
                        // call R2, line 106
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        // delete, line 106
                        SliceDel();
                    } while (false);
                    lab0:
                    break;
                case 3:
                    // (, line 110
                    // call R2, line 111
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 111
                    SliceFrom("log");
                    break;
                case 4:
                    // (, line 114
                    // call R2, line 115
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 115
                    SliceFrom("u");
                    break;
                case 5:
                    // (, line 118
                    // call R2, line 119
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 119
                    SliceFrom("ente");
                    break;
                case 6:
                    // (, line 122
                    // call R1, line 123
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 123
                    SliceDel();
                    // try, line 124
                    v_2 = m_limit - m_cursor;
                    do
                    {
                        // (, line 124
                        // [, line 125
                        m_ket = m_cursor;
                        // substring, line 125
                        among_var = FindAmongB(a_3, 4);
                        if (among_var == 0)
                        {
                            m_cursor = m_limit - v_2;
                            goto lab1;
                        }
                        // ], line 125
                        m_bra = m_cursor;
                        // call R2, line 125
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_2;
                            goto lab1;
                        }
                        // delete, line 125
                        SliceDel();
                        switch (among_var)
                        {
                            case 0:
                                m_cursor = m_limit - v_2;
                                goto lab1;
                            case 1:
                                // (, line 126
                                // [, line 126
                                m_ket = m_cursor;
                                // literal, line 126
                                if (!(Eq_S_B(2, "at")))
                                {
                                    m_cursor = m_limit - v_2;
                                    goto lab1;
                                }
                                // ], line 126
                                m_bra = m_cursor;
                                // call R2, line 126
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_2;
                                    goto lab1;
                                }
                                // delete, line 126
                                SliceDel();
                                break;
                        }
                    } while (false);
                    lab1:
                    break;
                case 7:
                    // (, line 134
                    // call R2, line 135
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 135
                    SliceDel();
                    // try, line 136
                    v_3 = m_limit - m_cursor;
                    do
                    {
                        // (, line 136
                        // [, line 137
                        m_ket = m_cursor;
                        // substring, line 137
                        among_var = FindAmongB(a_4, 3);
                        if (among_var == 0)
                        {
                            m_cursor = m_limit - v_3;
                            goto lab2;
                        }
                        // ], line 137
                        m_bra = m_cursor;
                        switch (among_var)
                        {
                            case 0:
                                m_cursor = m_limit - v_3;
                                goto lab2;
                            case 1:
                                // (, line 140
                                // call R2, line 140
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_3;
                                    goto lab2;
                                }
                                // delete, line 140
                                SliceDel();
                                break;
                        }
                    } while (false);
                    lab2:
                    break;
                case 8:
                    // (, line 146
                    // call R2, line 147
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 147
                    SliceDel();
                    // try, line 148
                    v_4 = m_limit - m_cursor;
                    do
                    {
                        // (, line 148
                        // [, line 149
                        m_ket = m_cursor;
                        // substring, line 149
                        among_var = FindAmongB(a_5, 3);
                        if (among_var == 0)
                        {
                            m_cursor = m_limit - v_4;
                            goto lab3;
                        }
                        // ], line 149
                        m_bra = m_cursor;
                        switch (among_var)
                        {
                            case 0:
                                m_cursor = m_limit - v_4;
                                goto lab3;
                            case 1:
                                // (, line 152
                                // call R2, line 152
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_4;
                                    goto lab3;
                                }
                                // delete, line 152
                                SliceDel();
                                break;
                        }
                    } while (false);
                    lab3:
                    break;
                case 9:
                    // (, line 158
                    // call R2, line 159
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 159
                    SliceDel();
                    // try, line 160
                    v_5 = m_limit - m_cursor;
                    do
                    {
                        // (, line 160
                        // [, line 161
                        m_ket = m_cursor;
                        // literal, line 161
                        if (!(Eq_S_B(2, "at")))
                        {
                            m_cursor = m_limit - v_5;
                            goto lab4;
                        }
                        // ], line 161
                        m_bra = m_cursor;
                        // call R2, line 161
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_5;
                            goto lab4;
                        }
                        // delete, line 161
                        SliceDel();
                    } while (false);
                    lab4:
                    break;
            }
            return true;
        }

        private bool r_y_verb_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            // (, line 167
            // setlimit, line 168
            v_1 = m_limit - m_cursor;
            // tomark, line 168
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 168
            // [, line 168
            m_ket = m_cursor;
            // substring, line 168
            among_var = FindAmongB(a_7, 12);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 168
            m_bra = m_cursor;
            m_limit_backward = v_2;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 171
                    // literal, line 171
                    if (!(Eq_S_B(1, "u")))
                    {
                        return false;
                    }
                    // delete, line 171
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_verb_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // (, line 175
            // setlimit, line 176
            v_1 = m_limit - m_cursor;
            // tomark, line 176
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 176
            // [, line 176
            m_ket = m_cursor;
            // substring, line 176
            among_var = FindAmongB(a_8, 96);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 176
            m_bra = m_cursor;
            m_limit_backward = v_2;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 179
                    // try, line 179
                    v_3 = m_limit - m_cursor;
                    do
                    {
                        // (, line 179
                        // literal, line 179
                        if (!(Eq_S_B(1, "u")))
                        {
                            m_cursor = m_limit - v_3;
                            goto lab0;
                        }
                        // test, line 179
                        v_4 = m_limit - m_cursor;
                        // literal, line 179
                        if (!(Eq_S_B(1, "g")))
                        {
                            m_cursor = m_limit - v_3;
                            goto lab0;
                        }
                        m_cursor = m_limit - v_4;
                    } while (false);
                    lab0:
                    // ], line 179
                    m_bra = m_cursor;
                    // delete, line 179
                    SliceDel();
                    break;
                case 2:
                    // (, line 200
                    // delete, line 200
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_residual_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            // (, line 204
            // [, line 205
            m_ket = m_cursor;
            // substring, line 205
            among_var = FindAmongB(a_9, 8);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 205
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 208
                    // call RV, line 208
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 208
                    SliceDel();
                    break;
                case 2:
                    // (, line 210
                    // call RV, line 210
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 210
                    SliceDel();
                    // try, line 210
                    v_1 = m_limit - m_cursor;
                    do
                    {
                        // (, line 210
                        // [, line 210
                        m_ket = m_cursor;
                        // literal, line 210
                        if (!(Eq_S_B(1, "u")))
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        // ], line 210
                        m_bra = m_cursor;
                        // test, line 210
                        v_2 = m_limit - m_cursor;
                        // literal, line 210
                        if (!(Eq_S_B(1, "g")))
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        m_cursor = m_limit - v_2;
                        // call RV, line 210
                        if (!r_RV())
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        // delete, line 210
                        SliceDel();
                    } while (false);
                    lab0:
                    break;
            }
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            // (, line 215
            // do, line 216
            v_1 = m_cursor;
            do
            {
                // call mark_regions, line 216
                if (!r_mark_regions())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // backwards, line 217
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 217
            // do, line 218
            v_2 = m_limit - m_cursor;
            do
            {
                // call attached_pronoun, line 218
                if (!r_attached_pronoun())
                {
                    goto lab1;
                }
            } while (false);
            lab1:
            m_cursor = m_limit - v_2;
            // do, line 219
            v_3 = m_limit - m_cursor;
            do
            {
                // (, line 219
                // or, line 219
                do
                {
                    v_4 = m_limit - m_cursor;
                    do
                    {
                        // call standard_suffix, line 219
                        if (!r_standard_suffix())
                        {
                            goto lab4;
                        }
                        goto lab3;
                    } while (false);
                    lab4:
                    m_cursor = m_limit - v_4;
                    do
                    {
                        // call y_verb_suffix, line 220
                        if (!r_y_verb_suffix())
                        {
                            goto lab5;
                        }
                        goto lab3;
                    } while (false);
                    lab5:
                    m_cursor = m_limit - v_4;
                    // call verb_suffix, line 221
                    if (!r_verb_suffix())
                    {
                        goto lab2;
                    }
                } while (false);
                lab3: {/* LUCENENET: intentionally blank */}
            } while (false);
            lab2:
            m_cursor = m_limit - v_3;
            // do, line 223
            v_5 = m_limit - m_cursor;
            do
            {
                // call residual_suffix, line 223
                if (!r_residual_suffix())
                {
                    goto lab6;
                }
            } while (false);
            lab6:
            m_cursor = m_limit - v_5;
            m_cursor = m_limit_backward;                    // do, line 225
            v_6 = m_cursor;
            do
            {
                // call postlude, line 225
                if (!r_postlude())
                {
                    goto lab7;
                }
            } while (false);
            lab7:
            m_cursor = v_6;
            return true;
        }

        public override bool Equals(object o)
        {
            return o is SpanishStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}