---
uid: contributing
---
Lucene.Net project contributing guide
===============

---------------

## Getting involved

_There are lots ways to help contribute to the Lucene.Net project!_

Lucene.Net is a very large project (over 400,000 executable lines of code and nearly 1,000,000 lines of text total) and we welcome any and all help to maintain such an effort. 

### Ask a Question

If you have a general how-to question or need help from the Lucene.Net community, please email the Apache Lucene.Net-User mailing list by sending a message to:

[user@lucenenet.apache.org](mailto:user@lucenenet.apache.org)

We recommend you join the [user mailing list](https://cwiki.apache.org/confluence/display/LUCENENET/Mailing+Lists) to stay looped into all user discussions.

Alternatively, you can get help via [StackOverflow](https://stackoverflow.com/questions/tagged/lucene.net).

Please do not submit general how-to questions to GitHub, use GitHub Issues for bug reports and tasks only.

see __[mailing lists](xref:contributing/mailing-lists)__ 

### Start a Discussion

To start a development discussion regarding technical features of Lucene.Net, please email the Apache Lucene.Net-Developer mailing list by sending a message to: 

[dev@lucenenet.apache.org](mailto:dev@lucenenet.apache.org)

We recommend you join both the [user and dev mailing lists](https://cwiki.apache.org/confluence/display/LUCENENET/Mailing+Lists) to stay looped in to all user and developer discussions.

see __[mailing lists](xref:contributing/mailing-lists)__ 

### Website and Documentation

Help with keeping this website and documentation up to date would be a great help. It would be great to migrate/consolidate a lot of the important information from the wiki to this website. See __[website and documentation](xref:contributing/documentation)__ for more information about contributing to this area.

### Report a Bug

To report a bug, please use the [GitHub issue tracker](xref:contributing/issue-tracker).

### Submit a Pull Request

First have a look at the __[Current Status](xref:contributing/current-status)__ of the project to see where things are at.

There's a [detailed contribution guide here](https://github.com/apache/lucenenet/blob/master/CONTRIBUTING.md). _(it would be good to migrate this guide to this website)_

And another guide is here about all the basics of getting started with the repo and how we prefer to receive pull requests [Git Setup and Pull Requests](https://cwiki.apache.org/confluence/display/LUCENENET/Git+Setup+and+Pull+Requests)