/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;

public class WithCollectionVariable
extends VariableBase {
    public WithCollectionVariable(Variable.Type type) {
        super(type);
    }

    @Override
    public boolean match(Object inputVal, Operand op, Object val, String name, Row row) {
        Map withCollectionMap = (Map)inputVal;
        if (withCollectionMap == null || withCollectionMap.isEmpty()) {
            return true;
        }
        HashSet uniqueColls = new HashSet();
        row.forEachReplica(replicaInfo -> uniqueColls.add(replicaInfo.getCollection()));
        for (Map.Entry e : withCollectionMap.entrySet()) {
            if (!uniqueColls.contains(e.getKey()) || uniqueColls.contains(e.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void projectAddReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> opCollector, boolean strictMode) {
        if (strictMode) {
            return;
        }
        Map withCollectionMap = (Map)cell.val;
        if (withCollectionMap == null || withCollectionMap.isEmpty()) {
            return;
        }
        HashSet uniqueColls = new HashSet();
        Row row = cell.row;
        row.forEachReplica(replicaInfo -> uniqueColls.add(replicaInfo.getCollection()));
        for (Map.Entry e : withCollectionMap.entrySet()) {
            if (!uniqueColls.contains(e.getKey()) || uniqueColls.contains(e.getValue())) continue;
            String withCollection = (String)e.getValue();
            opCollector.accept(new Row.OperationInfo(withCollection, "shard1", row.node, cell.name, true, Replica.Type.NRT));
        }
    }

    @Override
    public int compareViolation(Violation v1, Violation v2) {
        return Integer.compare(v1.getViolatingReplicas().size(), v2.getViolatingReplicas().size());
    }

    @Override
    public boolean addViolatingReplicas(Violation.Ctx ctx) {
        String node = ctx.currentViolation.node;
        for (Row row : ctx.allRows) {
            Map withCollectionMap;
            if (!node.equals(row.node) || (withCollectionMap = (Map)row.getVal("withCollection")) == null) continue;
            row.forEachReplica(r -> {
                String withCollection = (String)withCollectionMap.get(r.getCollection());
                if (withCollection != null) {
                    HashSet uniqueCollections = new HashSet();
                    row.forEachReplica(replicaInfo -> uniqueCollections.add(replicaInfo.getCollection()));
                    if (!uniqueCollections.contains(withCollection)) {
                        ctx.currentViolation.addReplica(new Violation.ReplicaInfoAndErr((ReplicaInfo)r).withDelta(1.0));
                    }
                }
            });
            ctx.currentViolation.replicaCountDelta = ctx.currentViolation.getViolatingReplicas().size();
        }
        return true;
    }

    @Override
    public void getSuggestions(Suggestion.Ctx ctx) {
        if (ctx.violation.getViolatingReplicas().isEmpty()) {
            return;
        }
        Map<String, Object> nodeValues = ctx.session.nodeStateProvider.getNodeValues(ctx.violation.node, Collections.singleton("withCollection"));
        Map withCollectionsMap = (Map)nodeValues.get("withCollection");
        if (withCollectionsMap == null) {
            return;
        }
        HashSet<String> uniqueCollections = new HashSet<String>();
        for (Violation.ReplicaInfoAndErr replicaInfoAndErr : ctx.violation.getViolatingReplicas()) {
            uniqueCollections.add(replicaInfoAndErr.replicaInfo.getCollection());
        }
        block1: for (String collection : uniqueCollections) {
            String withCollection = (String)withCollectionsMap.get(collection);
            if (withCollection == null) continue;
            for (Row row : ctx.session.matrix) {
                if (ctx.violation.node.equals(row.node)) continue;
                HashSet hostedCollections = new HashSet();
                row.forEachReplica(replicaInfo -> hostedCollections.add(replicaInfo.getCollection()));
                if (!hostedCollections.contains(withCollection) || hostedCollections.contains(collection)) continue;
                ArrayList movableReplicas = new ArrayList();
                row.forEachReplica(replicaInfo -> {
                    if (replicaInfo.getCollection().equals(withCollection)) {
                        movableReplicas.add(replicaInfo);
                    }
                });
                for (ReplicaInfo toMove : movableReplicas) {
                    Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).forceOperation(true).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(withCollection, "shard1")).hint(Suggester.Hint.SRC_NODE, row.node).hint(Suggester.Hint.REPLICA, toMove.getName()).hint(Suggester.Hint.TARGET_NODE, ctx.violation.node);
                    if (ctx.addSuggestion(suggester) == null) continue;
                    continue block1;
                }
            }
            Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.ADDREPLICA).forceOperation(true).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(withCollection, "shard1")).hint(Suggester.Hint.TARGET_NODE, ctx.violation.node);
            ctx.addSuggestion(suggester);
        }
    }
}

