/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.plugins.model.PluginEntry;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> namespaces = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllNamespaces() {
        return this.namespaces;
    }

    public Map<String, PluginEntry> getNamespace(String namespace) {
        String key = namespace.toLowerCase(Locale.ROOT);
        return this.namespaces.computeIfAbsent(key, ignored -> new TreeMap());
    }

    public void loadCacheFiles(Enumeration<URL> resources) throws IOException {
        this.namespaces.clear();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(url.openStream()));){
                int count = in.readInt();
                for (int i = 0; i < count; ++i) {
                    PluginEntry.Builder builder = PluginEntry.builder().setNamespace(in.readUTF());
                    Map<String, PluginEntry> m = this.getNamespace(builder.getNamespace());
                    int entries = in.readInt();
                    for (int j = 0; j < entries; ++j) {
                        PluginEntry entry = builder.setKey(in.readUTF()).setClassName(in.readUTF()).setName(in.readUTF()).setPrintable(in.readBoolean()).setDeferChildren(in.readBoolean()).get();
                        m.putIfAbsent(entry.key(), entry);
                    }
                }
            }
        }
    }

    public int size() {
        return this.namespaces.size();
    }
}

