/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.mongodb.MongoDbConnection;
import org.apache.logging.log4j.mongodb.MongoDbDocumentObjectCodec;
import org.apache.logging.log4j.mongodb.MongoDbLevelCodec;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

@Configurable(printObject=true)
@Plugin(value="MongoDb")
public final class MongoDbProvider
implements NoSqlProvider<MongoDbConnection> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final CodecRegistry CODEC_REGISTRIES = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromCodecs((Codec[])new Codec[]{MongoDbLevelCodec.INSTANCE}), CodecRegistries.fromCodecs((Codec[])new Codec[]{new MongoDbDocumentObjectCodec()})});
    private static final long DEFAULT_COLLECTION_SIZE = 0x20000000L;
    private final Long collectionSize;
    private final boolean isCapped;
    private final MongoClient mongoClient;
    private final MongoDatabase mongoDatabase;
    private final ConnectionString connectionString;

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private MongoDbProvider(String connectionStringSource, boolean isCapped, Long collectionSize) {
        LOGGER.debug("Creating ConnectionString {}...", (Object)connectionStringSource);
        this.connectionString = new ConnectionString(connectionStringSource);
        LOGGER.debug("Created ConnectionString {}", (Object)this.connectionString);
        LOGGER.debug("Creating MongoClientSettings...");
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(this.connectionString).codecRegistry(CODEC_REGISTRIES).build();
        LOGGER.debug("Created MongoClientSettings {}", (Object)settings);
        LOGGER.debug("Creating MongoClient {}...", (Object)settings);
        this.mongoClient = MongoClients.create((MongoClientSettings)settings);
        LOGGER.debug("Created MongoClient {}", (Object)this.mongoClient);
        String databaseName = this.connectionString.getDatabase();
        LOGGER.debug("Getting MongoDatabase {}...", (Object)databaseName);
        this.mongoDatabase = this.mongoClient.getDatabase(databaseName);
        LOGGER.debug("Got MongoDatabase {}", (Object)this.mongoDatabase);
        this.isCapped = isCapped;
        this.collectionSize = collectionSize;
    }

    public MongoDbConnection getConnection() {
        return new MongoDbConnection(this.connectionString, this.mongoClient, this.mongoDatabase, this.isCapped, this.collectionSize);
    }

    public String toString() {
        return String.format("%s [connectionString=%s, collectionSize=%s, isCapped=%s, mongoClient=%s, mongoDatabase=%s]", MongoDbProvider.class.getSimpleName(), this.connectionString, this.collectionSize, this.isCapped, this.mongoClient, this.mongoDatabase);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<MongoDbProvider> {
        @PluginAttribute(value="connection")
        @Required(message="No connection string provided")
        private @PluginAttribute(value="connection") String connectionStringSource;
        @PluginAttribute
        private long collectionSize = 0x20000000L;
        @PluginAttribute(value="capped")
        private @PluginAttribute(value="capped") boolean capped = false;

        public MongoDbProvider build() {
            return new MongoDbProvider(this.connectionStringSource, this.capped, this.collectionSize);
        }

        public B setConnectionStringSource(String connectionStringSource) {
            this.connectionStringSource = connectionStringSource;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCapped(boolean isCapped) {
            this.capped = isCapped;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionSize(long collectionSize) {
            this.collectionSize = collectionSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

