/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.env.internal;

import org.apache.logging.log4j.kit.env.PropertySource;
import org.apache.logging.log4j.status.StatusLogger;
import org.jspecify.annotations.Nullable;

public class ContextualJavaPropsPropertySource
implements PropertySource {
    private static final int DEFAULT_PRIORITY = 100;
    private final String prefix;
    private final int priority;

    public ContextualJavaPropsPropertySource(String contextName) {
        this(contextName, 100);
    }

    public ContextualJavaPropsPropertySource(String contextName, int priority) {
        this.prefix = "log4j.contexts." + contextName + ".";
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public @Nullable String getProperty(String key) {
        String actualKey = this.prefix + key;
        try {
            return System.getProperty(actualKey);
        }
        catch (SecurityException e) {
            StatusLogger.getLogger().warn("{} lacks permissions to access system property {}.", (Object)this.getClass().getName(), (Object)actualKey, (Object)e);
            return null;
        }
    }
}

