/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.plugins;

import org.apache.logging.log4j.catalog.api.ConstraintType;
import org.apache.logging.log4j.catalog.api.util.StringUtils;
import org.apache.logging.log4j.core.config.plugins.Plugin;

@Plugin(name="minLength", category="Constraint")
public class MinLengthConstraint
implements ConstraintType {
    @Override
    public void validate(boolean isRequestContext, String name, String value, String minLength, StringBuilder error) {
        if (StringUtils.isBlank(minLength)) {
            StringUtils.appendNewline(error);
            if (isRequestContext) {
                error.append("ThreadContext key ");
            }
            error.append(name).append(" has no minimum length value defined");
            return;
        }
        if (!StringUtils.isBlank(value)) {
            try {
                int minlen = Integer.parseInt(minLength);
                if (value.length() < minlen) {
                    StringUtils.appendNewline(error);
                    if (isRequestContext) {
                        error.append("ThreadContext key ");
                    }
                    error.append(name).append(" does not contain ").append(minLength).append(" characters.");
                }
            }
            catch (Exception ex) {
                StringUtils.appendNewline(error);
                if (isRequestContext) {
                    error.append("ThreadContext key ");
                }
                error.append(name).append(" encountered an error trying to determine the minimum length value: ").append(ex.getMessage());
            }
        }
    }
}

