/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdbm.helper.ExplicitList;

public class ActionVersioning {
    private Version nextVersion;
    private AtomicReference<Version> readReference;
    private ExplicitList<Version> versions = new ExplicitList();
    private Lock listLock = new ReentrantLock();

    public ActionVersioning() {
        Version readVersion = new Version(0L);
        this.nextVersion = new Version(1L);
        this.readReference = new AtomicReference<Version>(readVersion);
        this.versions.addFirst(this.nextVersion.getVersionsLink());
        this.versions.addFirst(readVersion.getVersionsLink());
    }

    public Version beginWriteAction() {
        return this.nextVersion;
    }

    public Version endWriteAction() {
        Version newNextVersion = new Version(this.nextVersion.getVersion() + 1L);
        Version oldReadVersion = this.readReference.getAndSet(this.nextVersion);
        this.listLock.lock();
        this.versions.addLast(newNextVersion.getVersionsLink());
        if (oldReadVersion.getNumActions().get() == 0 && oldReadVersion.getVersionsLink().isLinked()) {
            this.versions.remove(oldReadVersion.getVersionsLink());
            oldReadVersion.getVersionsLink().uninit();
        }
        Version minVersion = this.versions.begin().getElement();
        this.listLock.unlock();
        this.nextVersion = newNextVersion;
        return minVersion;
    }

    public Version beginReadAction() {
        Version readVersion = this.readReference.get();
        readVersion.getNumActions().incrementAndGet();
        if (readVersion != this.readReference.get()) {
            this.listLock.lock();
            if (readVersion.getVersionsLink().isUnLinked()) {
                readVersion = this.readReference.get();
                readVersion.getNumActions().incrementAndGet();
            }
            this.listLock.unlock();
        }
        return readVersion;
    }

    public Version endReadAction(Version version) {
        long numActions = version.getNumActions().decrementAndGet();
        if (numActions < 0L) {
            throw new IllegalStateException("NumActions zero when read action is ended : " + version);
        }
        if (numActions > 0L || version == this.readReference.get()) {
            return null;
        }
        Version minVersion = null;
        this.listLock.lock();
        if (version.getNumActions().get() == 0 && version.getVersionsLink().isLinked()) {
            version.getVersionsLink().remove();
            version.getVersionsLink().uninit();
        }
        minVersion = this.versions.begin().getElement();
        this.listLock.unlock();
        return minVersion;
    }

    public static class Version {
        private long version;
        private ExplicitList.Link<Version> versionsLink;
        private AtomicInteger numActions;

        public Version(long version) {
            this.version = version;
            this.versionsLink = new ExplicitList.Link<Version>(this);
            this.numActions = new AtomicInteger(0);
        }

        private ExplicitList.Link<Version> getVersionsLink() {
            return this.versionsLink;
        }

        private AtomicInteger getNumActions() {
            return this.numActions;
        }

        public long getVersion() {
            return this.version;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Version: ");
            sb.append("(vesion: ").append(this.version);
            sb.append(", numActions: ").append(this.numActions);
            sb.append(")\n");
            return sb.toString();
        }
    }
}

