/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.security.auth.callback.TextCallbackHandler;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.shell.ClientContext;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxClientRetryHandler;
import org.apache.knox.gateway.shell.KnoxDataSource;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.KnoxShellMessages;
import org.apache.knox.gateway.shell.util.ClientTrustStoreHelper;
import org.apache.knox.gateway.util.JsonUtils;

public class KnoxSession
implements Closeable {
    private static final String DEFAULT_JAAS_FILE = "/jaas.conf";
    public static final String JGSS_LOGIN_MOUDLE = "com.sun.security.jgss.initiate";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----\n";
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----\n";
    private static final KnoxShellMessages LOG = (KnoxShellMessages)MessagesFactory.get(KnoxShellMessages.class);
    private static final CredentialsProvider EMPTY_CREDENTIALS_PROVIDER = new BasicCredentialsProvider();
    private boolean isKerberos;
    private URL jaasConfigURL;
    String base;
    HttpHost host;
    CloseableHttpClient client;
    BasicHttpContext context;
    ExecutorService executor;
    Map<String, String> headers = new HashMap<String, String>();
    private static final String KNOXSQLHISTORIES_JSON = "knoxsqlhistories.json";
    private static final String KNOXDATASOURCES_JSON = "knoxdatasources.json";
    private static final String KNOXMOUNTPOINTS_JSON = "knoxmountpoints.json";

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    protected KnoxSession() throws KnoxShellException, URISyntaxException {
    }

    public KnoxSession(ClientContext clientContext) throws KnoxShellException, URISyntaxException {
        this.executor = Executors.newCachedThreadPool();
        this.base = clientContext.url();
        try {
            this.client = this.createClient(clientContext);
        }
        catch (GeneralSecurityException e) {
            throw new KnoxShellException("Failed to create HTTP client.", e);
        }
    }

    public static KnoxSession login(String url, Map<String, String> headers) throws URISyntaxException {
        KnoxSession instance = new KnoxSession(ClientContext.with(url));
        instance.setHeaders(headers);
        return instance;
    }

    public static KnoxSession login(String url, Map<String, String> headers, String truststoreLocation, String truststorePass) throws URISyntaxException {
        return KnoxSession.login(url, headers, truststoreLocation, truststorePass, null);
    }

    public static KnoxSession login(String url, Map<String, String> headers, String truststoreLocation, String truststorePass, String truststoreType) throws URISyntaxException {
        KnoxSession instance = new KnoxSession(ClientContext.with(url).connection().withTruststore(truststoreLocation, truststorePass, truststoreType).end());
        instance.setHeaders(headers);
        return instance;
    }

    public static KnoxSession login(String url, String username, String password) throws URISyntaxException {
        return new KnoxSession(ClientContext.with(username, password, url));
    }

    public static KnoxSession login(String url, String username, String password, String truststoreLocation, String truststorePass) throws URISyntaxException {
        return KnoxSession.login(url, username, password, truststoreLocation, truststorePass, null);
    }

    public static KnoxSession login(String url, String username, String password, String truststoreLocation, String truststorePass, String truststoreType) throws URISyntaxException {
        return new KnoxSession(ClientContext.with(username, password, url).connection().withTruststore(truststoreLocation, truststorePass, truststoreType).end());
    }

    public static KnoxSession login(ClientContext context) throws URISyntaxException {
        return new KnoxSession(context);
    }

    public static KnoxSession kerberosLogin(String url, String jaasConf, String krb5Conf, boolean debug) throws URISyntaxException {
        return new KnoxSession(ClientContext.with(url).kerberos().enable(true).jaasConf(jaasConf).krb5Conf(krb5Conf).debug(debug).end());
    }

    public static KnoxSession kerberosLogin(String url) throws URISyntaxException {
        return KnoxSession.kerberosLogin(url, false);
    }

    public static KnoxSession kerberosLogin(String url, boolean debug) throws URISyntaxException {
        return KnoxSession.kerberosLogin(url, "", "", debug);
    }

    public static KnoxSession loginInsecure(String url, String username, String password) throws URISyntaxException {
        return new KnoxSession(ClientContext.with(username, password, url).connection().secure(false).end());
    }

    @SuppressForbidden
    protected CloseableHttpClient createClient(ClientContext clientContext) throws GeneralSecurityException {
        Object hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        TrustSelfSignedStrategy trustStrategy = null;
        if (clientContext.connection().secure()) {
            hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        } else {
            trustStrategy = TrustSelfSignedStrategy.INSTANCE;
            System.out.println("**************** WARNING ******************\nThis is an insecure client instance and may\nleave the interactions subject to a man in\nthe middle attack. Please use the login()\nmethod instead of loginInsecure() for any\nsensitive or production usecases.\n*******************************************");
        }
        KeyStore trustStore = this.getTrustStore(clientContext);
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)trustStrategy).build();
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(clientContext.pool().maxTotal());
        connectionManager.setDefaultMaxPerRoute(clientContext.pool().defaultMaxPerRoute());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(clientContext.connection().bufferSize()).build();
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(clientContext.socket().keepalive()).setSoLinger(clientContext.socket().linger()).setSoReuseAddress(clientContext.socket().reuseAddress()).setSoTimeout(clientContext.socket().timeout()).setTcpNoDelay(clientContext.socket().tcpNoDelay()).build();
        connectionManager.setDefaultSocketConfig(socketConfig);
        URI uri = URI.create(clientContext.url());
        this.host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        if (clientContext.kerberos().enable()) {
            String useSubjectCredsOnly;
            this.isKerberos = true;
            if (!StringUtils.isBlank((CharSequence)clientContext.kerberos().krb5Conf())) {
                System.setProperty("java.security.krb5.conf", clientContext.kerberos().krb5Conf());
            }
            if (!StringUtils.isBlank((CharSequence)clientContext.kerberos().jaasConf())) {
                File f = new File(clientContext.kerberos().jaasConf());
                if (f.exists()) {
                    try {
                        this.jaasConfigURL = f.getCanonicalFile().toURI().toURL();
                        LOG.jaasConfigurationLocation(this.jaasConfigURL.toExternalForm());
                    }
                    catch (IOException e) {
                        LOG.failedToLocateJAASConfiguration(e.getMessage());
                    }
                } else {
                    LOG.jaasConfigurationDoesNotExist(f.getAbsolutePath());
                }
            }
            if (this.jaasConfigURL == null) {
                LOG.usingDefaultJAASConfiguration();
                this.jaasConfigURL = this.getClass().getResource(DEFAULT_JAAS_FILE);
                LOG.jaasConfigurationLocation(this.jaasConfigURL.toExternalForm());
            }
            if (clientContext.kerberos().debug()) {
                System.setProperty("sun.security.krb5.debug", "true");
                System.setProperty("sun.security.jgss.debug", "true");
            }
            if ((useSubjectCredsOnly = System.getProperty("javax.security.auth.useSubjectCredsOnly")) != null && !Boolean.parseBoolean(useSubjectCredsOnly)) {
                LOG.useSubjectCredsOnlyIsFalse();
            }
            Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider(EMPTY_CREDENTIALS_PROVIDER).build();
        }
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme authScheme = new BasicScheme();
        authCache.put(this.host, (AuthScheme)authScheme);
        this.context = new BasicHttpContext();
        this.context.setAttribute("http.auth.auth-cache", (Object)authCache);
        BasicCredentialsProvider credentialsProvider = null;
        if (clientContext.username() != null && clientContext.password() != null) {
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.host.getHostName(), this.host.getPort()), (Credentials)new UsernamePasswordCredentials(clientContext.username(), clientContext.password()));
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultCredentialsProvider(credentialsProvider);
        if (clientContext.connection().retryCount() != -1) {
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new KnoxClientRetryHandler(clientContext.connection().retryCount(), clientContext.connection().requestSentRetryEnabled())).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new DefaultServiceUnavailableRetryStrategy(clientContext.connection().retryCount(), clientContext.connection().retryIntervalMillis()));
        }
        return httpClientBuilder.build();
    }

    protected X509Certificate generateCertificateFromBytes(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    private KeyStore getTrustStore(ClientContext clientContext) throws GeneralSecurityException {
        KeyStore ks;
        block26: {
            String truststorePass;
            String pem = clientContext.connection().endpointPublicCertPem();
            if (pem != null) {
                if (pem.contains("BEGIN")) {
                    pem = pem.substring(BEGIN_CERTIFICATE.length() - 1, pem.indexOf(END_CERTIFICATE.substring(0, END_CERTIFICATE.length() - 1)));
                }
                try {
                    byte[] bytes = Base64.decodeBase64((String)pem);
                    KeyStore keystore = KeyStore.getInstance(clientContext.connection().truststoreType());
                    keystore.load(null);
                    keystore.setCertificateEntry("knox-gateway", this.generateCertificateFromBytes(bytes));
                    return keystore;
                }
                catch (IOException e) {
                    LOG.unableToLoadProvidedPEMEncodedTrustedCert(e);
                }
            }
            this.discoverTruststoreDetails(clientContext);
            File file = new File(clientContext.connection().truststoreLocation());
            if (file.exists()) {
                truststorePass = clientContext.connection().truststorePass();
            } else {
                String truststore = System.getProperty("javax.net.ssl.trustStore");
                truststorePass = System.getProperty("javax.net.ssl.trustStorePassword", "changeit");
                if (truststore == null) {
                    String truststoreDir = System.getProperty("java.home");
                    truststore = truststoreDir + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
                }
                file = new File(truststore);
            }
            if (file.exists()) {
                try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    ks = KeyStore.getInstance(clientContext.connection().truststoreType());
                    ks.load(is, truststorePass.toCharArray());
                    break block26;
                }
                catch (KeyStoreException e) {
                    throw new KnoxShellException("Unable to create keystore of expected type.", e);
                }
                catch (FileNotFoundException e) {
                    throw new KnoxShellException("Unable to read truststore. Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new KnoxShellException("Unable to load the truststore. Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.", e);
                }
                catch (CertificateException e) {
                    throw new KnoxShellException("Certificate cannot be found in the truststore. Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.", e);
                }
                catch (IOException e) {
                    throw new KnoxShellException("Unable to load truststore. May be related to password setting or truststore format.", e);
                }
            }
            throw new KnoxShellException("Unable to find a truststore for secure login.Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.");
        }
        return ks;
    }

    protected void discoverTruststoreDetails(ClientContext clientContext) {
        if (clientContext.connection().truststoreLocation() != null && clientContext.connection().truststorePass() != null && clientContext.connection().truststoreType() != null) {
            return;
        }
        String truststoreLocation = ClientTrustStoreHelper.getClientTrustStoreFile().getAbsolutePath();
        String truststorePass = ClientTrustStoreHelper.getClientTrustStoreFilePassword();
        String truststoreType = ClientTrustStoreHelper.getClientTrustStoreType();
        clientContext.connection().withTruststore(truststoreLocation, truststorePass, truststoreType);
    }

    public String base() {
        return this.base;
    }

    @SuppressForbidden
    public CloseableHttpResponse executeNow(HttpRequest request) throws IOException {
        if (this.isKerberos) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            try {
                if (subject == null) {
                    JAASClientConfig jaasConf;
                    LOG.noSubjectAvailable();
                    try {
                        jaasConf = new JAASClientConfig(this.jaasConfigURL);
                    }
                    catch (Exception e) {
                        LOG.failedToLoadJAASConfiguration(this.jaasConfigURL.toExternalForm());
                        throw new KnoxShellException(e.toString(), e);
                    }
                    LoginContext lc = new LoginContext(JGSS_LOGIN_MOUDLE, null, new TextCallbackHandler(), jaasConf);
                    lc.login();
                    subject = lc.getSubject();
                }
                return Subject.doAs(subject, () -> {
                    try {
                        CloseableHttpResponse response = this.client.execute(this.host, request, (HttpContext)this.context);
                        if (response.getStatusLine().getStatusCode() < 400) {
                            return response;
                        }
                        throw new ErrorResponse(request.getRequestLine().getUri() + ": ", (HttpResponse)response);
                    }
                    catch (IOException e) {
                        throw new KnoxShellException(e.toString(), e);
                    }
                });
            }
            catch (LoginException e) {
                throw new KnoxShellException(e.toString(), e);
            }
        }
        CloseableHttpResponse response = this.client.execute(this.host, request, (HttpContext)this.context);
        if (response.getStatusLine().getStatusCode() < 400) {
            return response;
        }
        throw new ErrorResponse(request.getRequestLine().getUri() + ": ", (HttpResponse)response);
    }

    public <T> Future<T> executeLater(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    public void waitFor(Future<?> ... futures) throws ExecutionException, InterruptedException {
        if (futures != null) {
            for (Future<?> future : futures) {
                future.get();
            }
        }
    }

    public void waitFor(long timeout, TimeUnit units, Future<?> ... futures) throws ExecutionException, TimeoutException, InterruptedException {
        if (futures != null) {
            timeout = TimeUnit.MILLISECONDS.convert(timeout, units);
            for (Future<?> future : futures) {
                long start = System.currentTimeMillis();
                future.get(timeout, TimeUnit.MILLISECONDS);
                timeout -= System.currentTimeMillis() - start;
            }
        }
    }

    private void closeClient() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    public void shutdown() throws InterruptedException, IOException {
        try {
            this.executor.shutdownNow();
        }
        finally {
            this.closeClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException, IOException {
        try {
            this.executor.shutdown();
            boolean bl = this.executor.awaitTermination(timeout, unit);
            return bl;
        }
        finally {
            this.closeClient();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KnoxShellException("Can not shutdown underlying resources", e);
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "KnoxSession{base='%s'}", this.base);
    }

    public static <T> void persistToKnoxShell(String fileName, Map<String, List<T>> map) {
        String s = JsonUtils.renderAsJsonString(map);
        String home = System.getProperty("user.home");
        try {
            KnoxSession.write(new File(home + File.separator + ".knoxshell" + File.separator + fileName), s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> void persistDataSourcesToKnoxShell(String fileName, Map<String, T> map) {
        KnoxSession.persistMapToKnoxShell(fileName, map);
    }

    public static <T> void persistMapToKnoxShell(String fileName, Map<String, T> map) {
        String s = JsonUtils.renderAsJsonString(map);
        String home = System.getProperty("user.home");
        try {
            KnoxSession.write(new File(home + File.separator + ".knoxshell" + File.separator + fileName), s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(File file, String s) throws IOException {
        Class<KnoxSession> clazz = KnoxSession.class;
        synchronized (KnoxSession.class) {
            Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                channel.tryLock();
                FileUtils.write((File)file, (CharSequence)s, (Charset)StandardCharsets.UTF_8);
            }
            catch (OverlappingFileLockException e) {
                System.out.println("Unable to acquire write lock for: " + file.getAbsolutePath());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void persistSQLHistory(Map<String, List<String>> sqlHistories) {
        KnoxSession.persistToKnoxShell(KNOXSQLHISTORIES_JSON, sqlHistories);
    }

    public static void persistDataSources(Map<String, KnoxDataSource> datasources) {
        KnoxSession.persistDataSourcesToKnoxShell(KNOXDATASOURCES_JSON, datasources);
    }

    public static void persistMountPoints(Map<String, String> mounts) {
        KnoxSession.persistMapToKnoxShell(KNOXMOUNTPOINTS_JSON, mounts);
    }

    public static Map<String, List<String>> loadSQLHistories() throws IOException {
        Map<String, List<String>> sqlHistories = null;
        String home = System.getProperty("user.home");
        File historyFile = new File(home + File.separator + ".knoxshell" + File.separator + KNOXSQLHISTORIES_JSON);
        if (historyFile.exists()) {
            String json = KnoxSession.readFileToString(historyFile);
            sqlHistories = KnoxSession.getMapOfStringArrayListsFromJsonString(json);
        }
        return sqlHistories;
    }

    public static Map<String, String> loadMountPoints() throws IOException {
        Map<String, String> mounts = new HashMap<String, String>();
        String home = System.getProperty("user.home");
        File mountFile = new File(home + File.separator + ".knoxshell" + File.separator + KNOXMOUNTPOINTS_JSON);
        if (mountFile.exists()) {
            String json = KnoxSession.readFileToString(mountFile);
            mounts = KnoxSession.getMapFromJsonString(json);
        }
        return mounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileToString(File file) throws IOException {
        String content = null;
        Class<KnoxSession> clazz = KnoxSession.class;
        synchronized (KnoxSession.class) {
            try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
                channel.tryLock(0L, Long.MAX_VALUE, true);
                content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (OverlappingFileLockException e) {
                System.out.println("Unable to acquire write lock for: " + file.getAbsolutePath());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return content;
        }
    }

    public static Map<String, KnoxDataSource> loadDataSources() throws IOException {
        Map<String, KnoxDataSource> datasources = null;
        String home = System.getProperty("user.home");
        File dsFile = new File(home + File.separator + ".knoxshell" + File.separator + KNOXDATASOURCES_JSON);
        if (dsFile.exists()) {
            String json = KnoxSession.readFileToString(dsFile);
            datasources = KnoxSession.getMapOfDataSourcesFromJsonString(json);
        }
        return datasources;
    }

    public static Map<String, List<String>> getMapOfStringArrayListsFromJsonString(String json) throws IOException {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<Map<String, List<String>>> typeRef = new TypeReference<Map<String, List<String>>>(){};
        Map obj = (Map)mapper.readValue(json, (TypeReference)typeRef);
        return obj;
    }

    public static <T> Map<String, T> getMapFromJsonString(String json) throws IOException {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference typeRef = new TypeReference<Map<String, T>>(){};
        Map obj = (Map)mapper.readValue(json, typeRef);
        return obj;
    }

    public static Map<String, KnoxDataSource> getMapOfDataSourcesFromJsonString(String json) throws IOException {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<Map<String, KnoxDataSource>> typeRef = new TypeReference<Map<String, KnoxDataSource>>(){};
        Map obj = (Map)mapper.readValue(json, (TypeReference)typeRef);
        return obj;
    }

    static {
        EMPTY_CREDENTIALS_PROVIDER.setCredentials(AuthScope.ANY, new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
    }

    private static class ConfigurationFactory {
        private static final Class implClazz;

        private ConfigurationFactory() {
        }

        static Configuration create(URI uri) {
            Configuration config = null;
            if (implClazz != null) {
                try {
                    Constructor ctor = implClazz.getDeclaredConstructor(URI.class);
                    config = (Configuration)ctor.newInstance(uri);
                }
                catch (Exception e) {
                    LOG.failedToInstantiateJAASConfigurationFileImplementation(implClazz.getCanonicalName(), e.getLocalizedMessage());
                }
            } else {
                LOG.noJAASConfigurationFileImplementation();
            }
            return config;
        }

        static {
            String implName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.login.ConfigFile" : "com.sun.security.auth.login.ConfigFile";
            LOG.usingJAASConfigurationFileImplementation(implName);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(implName, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                LOG.failedToLoadJAASConfigurationFileImplementation(implName, e.getLocalizedMessage());
            }
            implClazz = clazz;
        }
    }

    private static final class JAASClientConfig
    extends Configuration {
        private static final Configuration baseConfig = Configuration.getConfiguration();
        private Configuration configFile;

        JAASClientConfig(URL configFileURL) throws Exception {
            if (configFileURL != null) {
                this.configFile = ConfigurationFactory.create(configFileURL.toURI());
            }
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            AppConfigurationEntry[] result = null;
            if (this.configFile != null) {
                result = this.configFile.getAppConfigurationEntry(name);
            }
            if (result == null) {
                result = baseConfig.getAppConfigurationEntry(name);
            }
            return result;
        }
    }
}

