/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.ad.io.FileTimeValueTranscoder;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.ActiveDirectoryAccountState;

public class ActiveDirectoryAuthenticationResponseHandler
implements AuthenticationResponseHandler {
    private static final int HASH_CODE_SEED = 1201;
    private long maxPasswordAge = -1L;
    private int warningHours;

    public ActiveDirectoryAuthenticationResponseHandler() {
    }

    public ActiveDirectoryAuthenticationResponseHandler(long passwordAge) {
        if (passwordAge < 0L) {
            throw new IllegalArgumentException("Password age must be >= 0");
        }
        this.maxPasswordAge = passwordAge;
    }

    public ActiveDirectoryAuthenticationResponseHandler(int warning) {
        if (warning < 0) {
            throw new IllegalArgumentException("Warning hours must be >= 0");
        }
        this.warningHours = warning;
    }

    public ActiveDirectoryAuthenticationResponseHandler(int warning, long passwordAge) {
        if (warning < 0) {
            throw new IllegalArgumentException("Warning hours must be >= 0");
        }
        this.warningHours = warning;
        if (passwordAge < 0L) {
            throw new IllegalArgumentException("Password age must be >= 0");
        }
        this.maxPasswordAge = passwordAge;
    }

    public ActiveDirectoryAuthenticationResponseHandler(String warning) {
        this((int)LdapUtils.durationDecode(warning, TimeUnit.HOURS));
    }

    public ActiveDirectoryAuthenticationResponseHandler(String warning, String passwordAge) {
        this((int)LdapUtils.durationDecode(warning, TimeUnit.HOURS), LdapUtils.durationDecode(passwordAge, TimeUnit.MILLISECONDS));
    }

    @Override
    public void handle(AuthenticationResponse response) {
        ActiveDirectoryAccountState.Error adError;
        if (((Boolean)response.getResult()).booleanValue()) {
            LdapEntry entry = response.getLdapEntry();
            LdapAttribute expTime = entry.getAttribute("msDS-UserPasswordExpiryTimeComputed");
            LdapAttribute pwdLastSet = entry.getAttribute("pwdLastSet");
            Calendar exp = null;
            if (expTime != null && !"9223372036854775807".equals(expTime.getStringValue())) {
                exp = expTime.getValue(new FileTimeValueTranscoder());
            } else if (this.maxPasswordAge >= 0L && pwdLastSet != null) {
                exp = pwdLastSet.getValue(new FileTimeValueTranscoder());
                exp.setTimeInMillis(exp.getTimeInMillis() + this.maxPasswordAge);
            }
            if (exp != null) {
                if (this.warningHours > 0) {
                    Calendar now = Calendar.getInstance();
                    Calendar warn = (Calendar)exp.clone();
                    warn.add(11, -this.warningHours);
                    if (now.after(warn)) {
                        response.setAccountState(new ActiveDirectoryAccountState(exp));
                    }
                } else {
                    response.setAccountState(new ActiveDirectoryAccountState(exp));
                }
            }
        } else if (response.getMessage() != null && (adError = ActiveDirectoryAccountState.Error.parse(response.getMessage())) != null) {
            response.setAccountState(new ActiveDirectoryAccountState(adError));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ActiveDirectoryAuthenticationResponseHandler) {
            ActiveDirectoryAuthenticationResponseHandler v = (ActiveDirectoryAuthenticationResponseHandler)o;
            return LdapUtils.areEqual(this.maxPasswordAge, v.maxPasswordAge) && LdapUtils.areEqual(this.warningHours, v.warningHours);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(1201, this.maxPasswordAge, this.warningHours);
    }

    public String toString() {
        return String.format("[%s@%d::maxPasswordAge=%s, warningHours=%s]", this.getClass().getName(), this.hashCode(), this.maxPasswordAge, this.warningHours);
    }
}

