/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.filter.AclParser;
import org.apache.knox.gateway.filter.InvalidACLException;
import org.apache.knox.gateway.filter.PathAclsAuthorizationMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class PathAclParser {
    private static PathAclsAuthorizationMessages log = (PathAclsAuthorizationMessages)MessagesFactory.get(PathAclsAuthorizationMessages.class);
    public Map<Matcher, AclParser> rulesMap = new HashMap<Matcher, AclParser>();

    public void parsePathAcls(String resourceRole, Map<String, String> rawRules) throws InvalidACLException {
        if (rawRules != null && !rawRules.isEmpty()) {
            for (Map.Entry<String, String> rules : rawRules.entrySet()) {
                Template urlPatternTemplate;
                String acls = rules.getValue();
                Matcher urlMatcher = new Matcher();
                AclParser aclParser = new AclParser();
                if (acls == null) continue;
                String path = acls.substring(0, acls.indexOf(59));
                String aclRules = acls.substring(acls.indexOf(59) + 1);
                log.aclsFoundForResource(rules.getKey());
                if (StringUtils.isBlank((CharSequence)path) || StringUtils.isBlank((CharSequence)aclRules)) {
                    log.invalidAclsFoundForResource(rules.getKey());
                    throw new InvalidACLException("Invalid Path ACLs specified for rule: " + rules.getKey());
                }
                log.aclsFoundForResource(rules.getKey());
                try {
                    urlPatternTemplate = Parser.parseTemplate((String)path);
                }
                catch (URISyntaxException e) {
                    log.invalidURLPattern(rules.getKey());
                    throw new InvalidACLException("Invalid URL pattern for rule: " + rules.getKey());
                }
                urlMatcher.add(urlPatternTemplate, (Object)rules.getKey());
                aclParser.parseAcls(resourceRole, aclRules);
                this.rulesMap.put(urlMatcher, aclParser);
            }
        } else {
            log.noAclsFoundForResource(resourceRole);
        }
    }

    public Map getRulesMap() {
        return Collections.unmodifiableMap(this.rulesMap);
    }
}

