/*
 * Decompiled with CFR 0.152.
 */
package jdbm;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum I18n {
    ERR_513("ERR_513"),
    ERR_514("ERR_514"),
    ERR_515("ERR_515"),
    ERR_516("ERR_516"),
    ERR_517("ERR_517"),
    ERR_518("ERR_518"),
    ERR_519("ERR_519"),
    ERR_522("ERR_522"),
    ERR_523("ERR_523"),
    ERR_524("ERR_524"),
    ERR_525("ERR_525"),
    ERR_526("ERR_526"),
    ERR_527("ERR_527"),
    ERR_528("ERR_528"),
    ERR_529("ERR_529"),
    ERR_531("ERR_531"),
    ERR_532("ERR_532"),
    ERR_533("ERR_533"),
    ERR_534("ERR_534"),
    ERR_535("ERR_535"),
    ERR_536("ERR_536"),
    ERR_537("ERR_537"),
    ERR_538("ERR_538"),
    ERR_539_BAD_BLOCK_ID("ERR_539_BAD_BLOCK_ID"),
    ERR_540("ERR_540"),
    ERR_541("ERR_541"),
    ERR_542("ERR_542"),
    ERR_543("ERR_543"),
    ERR_544("ERR_544"),
    ERR_545("ERR_545"),
    ERR_546("ERR_546"),
    ERR_547("ERR_547"),
    ERR_548("ERR_548"),
    ERR_549("ERR_549"),
    ERR_550("ERR_550"),
    ERR_551("ERR_551"),
    ERR_552("ERR_552"),
    ERR_553("ERR_553"),
    ERR_554("ERR_554"),
    ERR_555("ERR_555"),
    ERR_556("ERR_556"),
    ERR_557("ERR_557"),
    ERR_558("ERR_558"),
    ERR_559("ERR_559"),
    ERR_560("ERR_560"),
    ERR_561("ERR_561"),
    ERR_562("ERR_562"),
    ERR_563("ERR_563"),
    ERR_564("ERR_564"),
    ERR_565("ERR_565"),
    ERR_566("ERR_566"),
    ERR_567("ERR_567");

    private static ResourceBundle errBundle;
    private static final ResourceBundle msgBundle;
    private String errorCode;

    private I18n(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static String err(I18n err, Object ... args) {
        try {
            return (Object)((Object)err) + " " + MessageFormat.format(errBundle.getString(err.getErrorCode()), args);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            for (Object obj : args) {
                if (comma) {
                    sb.append(",");
                } else {
                    comma = true;
                }
                sb.append(obj);
            }
            return (Object)((Object)err) + " (" + sb.toString() + ")";
        }
    }

    public static String msg(String msg, Object ... args) {
        try {
            return MessageFormat.format(msgBundle.getString(msg), args);
        }
        catch (MissingResourceException mre) {
            try {
                return MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                StringBuffer sb = new StringBuffer();
                boolean comma = false;
                for (Object obj : args) {
                    if (comma) {
                        sb.append(",");
                    } else {
                        comma = true;
                    }
                    sb.append(obj);
                }
                return msg + " (" + sb.toString() + ")";
            }
        }
    }

    static {
        errBundle = ResourceBundle.getBundle("jdbm.errors");
        msgBundle = ResourceBundle.getBundle("jdbm/messages");
    }
}

