/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletResponse;

public class HttpExceptionUtils {
    private static final String ERROR_JSON = "RemoteException";
    private static final String ERROR_EXCEPTION_JSON = "exception";
    private static final String ERROR_CLASSNAME_JSON = "javaClassName";
    private static final String ERROR_MESSAGE_JSON = "message";
    private static final String APPLICATION_JSON_MIME = "application/json";
    private static final String ENTER = System.getProperty("line.separator");
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();

    public static void createServletExceptionResponse(HttpServletResponse response, int status, Throwable ex) throws IOException {
        response.setStatus(status);
        response.setContentType(APPLICATION_JSON_MIME);
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put(ERROR_MESSAGE_JSON, HttpExceptionUtils.getOneLineMessage(ex));
        json.put(ERROR_EXCEPTION_JSON, ex.getClass().getSimpleName());
        json.put(ERROR_CLASSNAME_JSON, ex.getClass().getName());
        LinkedHashMap<String, LinkedHashMap<String, String>> jsonResponse = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        jsonResponse.put(ERROR_JSON, json);
        PrintWriter responseWriter = response.getWriter();
        WRITER.writeValue((Writer)response.getWriter(), jsonResponse);
        ((Writer)responseWriter).flush();
    }

    private static String getOneLineMessage(Throwable exception) {
        int i;
        String message = exception.getMessage();
        if (message != null && (i = message.indexOf(ENTER)) > -1) {
            message = message.substring(0, i);
        }
        return message;
    }
}

