/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Basic arguments used for Rolling Restart Cluster commands.")
public class ApiSimpleRollingRestartClusterArgs {
    @SerializedName(value="slaveBatchSize")
    private BigDecimal slaveBatchSize = null;
    @SerializedName(value="sleepSeconds")
    private BigDecimal sleepSeconds = null;
    @SerializedName(value="slaveFailCountThreshold")
    private BigDecimal slaveFailCountThreshold = null;

    public ApiSimpleRollingRestartClusterArgs slaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
        return this;
    }

    @Schema(description="Number of hosts with slave roles to restart at a time. Must be greater than zero. Default is 1.")
    public BigDecimal getSlaveBatchSize() {
        return this.slaveBatchSize;
    }

    public void setSlaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
    }

    public ApiSimpleRollingRestartClusterArgs sleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
        return this;
    }

    @Schema(description="Number of seconds to sleep between restarts of slave host batches. <p> Must be greater than or equal to 0. Default is 0.")
    public BigDecimal getSleepSeconds() {
        return this.sleepSeconds;
    }

    public void setSleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public ApiSimpleRollingRestartClusterArgs slaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
        return this;
    }

    @Schema(description="The threshold for number of slave host batches that are allowed to fail to restart before the entire command is considered failed. <p> Must be greater than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>")
    public BigDecimal getSlaveFailCountThreshold() {
        return this.slaveFailCountThreshold;
    }

    public void setSlaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiSimpleRollingRestartClusterArgs apiSimpleRollingRestartClusterArgs = (ApiSimpleRollingRestartClusterArgs)o;
        return Objects.equals(this.slaveBatchSize, apiSimpleRollingRestartClusterArgs.slaveBatchSize) && Objects.equals(this.sleepSeconds, apiSimpleRollingRestartClusterArgs.sleepSeconds) && Objects.equals(this.slaveFailCountThreshold, apiSimpleRollingRestartClusterArgs.slaveFailCountThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.slaveBatchSize, this.sleepSeconds, this.slaveFailCountThreshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiSimpleRollingRestartClusterArgs {\n");
        sb.append("    slaveBatchSize: ").append(this.toIndentedString(this.slaveBatchSize)).append("\n");
        sb.append("    sleepSeconds: ").append(this.toIndentedString(this.sleepSeconds)).append("\n");
        sb.append("    slaveFailCountThreshold: ").append(this.toIndentedString(this.slaveFailCountThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

