/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A supported external account type. An external account type represents an external authentication source that is used by Cloudera Manager in its APIs to take suitable actions that require authentication to an external service.  An external account type is uniquely identified by a server-generated ID and identifies with a category identifier: e.g. The \"AWS\" category has an account type \"AWS_Access_Key_Authorization\"")
public class ApiExternalAccountType {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="categoryName")
    private String categoryName = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="allowedAccountConfigs")
    private ApiConfigList allowedAccountConfigs = null;

    public ApiExternalAccountType name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Represents the immutable name for this account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiExternalAccountType categoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    @Schema(description="Represents the category of this account.")
    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public ApiExternalAccountType type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Represents the type for this account.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ApiExternalAccountType displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Represents the localized display name for this account.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiExternalAccountType description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Represents the localized description for this account type.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiExternalAccountType allowedAccountConfigs(ApiConfigList allowedAccountConfigs) {
        this.allowedAccountConfigs = allowedAccountConfigs;
        return this;
    }

    @Schema(description="")
    public ApiConfigList getAllowedAccountConfigs() {
        return this.allowedAccountConfigs;
    }

    public void setAllowedAccountConfigs(ApiConfigList allowedAccountConfigs) {
        this.allowedAccountConfigs = allowedAccountConfigs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiExternalAccountType apiExternalAccountType = (ApiExternalAccountType)o;
        return Objects.equals(this.name, apiExternalAccountType.name) && Objects.equals(this.categoryName, apiExternalAccountType.categoryName) && Objects.equals(this.type, apiExternalAccountType.type) && Objects.equals(this.displayName, apiExternalAccountType.displayName) && Objects.equals(this.description, apiExternalAccountType.description) && Objects.equals(this.allowedAccountConfigs, apiExternalAccountType.allowedAccountConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.categoryName, this.type, this.displayName, this.description, this.allowedAccountConfigs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiExternalAccountType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    categoryName: ").append(this.toIndentedString(this.categoryName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    allowedAccountConfigs: ").append(this.toIndentedString(this.allowedAccountConfigs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

