/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiEntityTag;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A Control Plane in a Cloudera Manager instance")
public class ApiControlPlane {
    @SerializedName(value="namespace")
    private String namespace = null;
    @SerializedName(value="dnsSuffix")
    private String dnsSuffix = null;
    @SerializedName(value="uuid")
    private String uuid = null;
    @SerializedName(value="remoteRepoUrl")
    private String remoteRepoUrl = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="manifest")
    private String manifest = null;
    @SerializedName(value="valuesYaml")
    private String valuesYaml = null;
    @SerializedName(value="tags")
    private List<ApiEntityTag> tags = null;
    @SerializedName(value="kubernetesType")
    private String kubernetesType = null;

    public ApiControlPlane namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(value="The namespace where the control plane is installed. Append the domain to the namespace to get the url of the control plane.")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ApiControlPlane dnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    @ApiModelProperty(value="The domain where the control plane is installed. Append the domain to the namespace to get the url of the control plane.")
    public String getDnsSuffix() {
        return this.dnsSuffix;
    }

    public void setDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
    }

    public ApiControlPlane uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(value="The universally unique ID of this control plane in Cloudera Manager")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ApiControlPlane remoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
        return this;
    }

    @ApiModelProperty(value="The url of the remote repository where the artifacts used to install the control plane are hosted")
    public String getRemoteRepoUrl() {
        return this.remoteRepoUrl;
    }

    public void setRemoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
    }

    public ApiControlPlane version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="The CDP version of the control plane")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ApiControlPlane manifest(String manifest) {
        this.manifest = manifest;
        return this;
    }

    @ApiModelProperty(value="The content of the manifest.json of the control plane")
    public String getManifest() {
        return this.manifest;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public ApiControlPlane valuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
        return this;
    }

    @ApiModelProperty(value="The content of the values.yaml used to configure the control plane")
    public String getValuesYaml() {
        return this.valuesYaml;
    }

    public void setValuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
    }

    public ApiControlPlane tags(List<ApiEntityTag> tags) {
        this.tags = tags;
        return this;
    }

    public ApiControlPlane addTagsItem(ApiEntityTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<ApiEntityTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tags associated with the control plane. Available since V46.")
    public List<ApiEntityTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ApiEntityTag> tags) {
        this.tags = tags;
    }

    public ApiControlPlane kubernetesType(String kubernetesType) {
        this.kubernetesType = kubernetesType;
        return this;
    }

    @ApiModelProperty(value="The kubernetes type on which the control plane is running")
    public String getKubernetesType() {
        return this.kubernetesType;
    }

    public void setKubernetesType(String kubernetesType) {
        this.kubernetesType = kubernetesType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiControlPlane apiControlPlane = (ApiControlPlane)o;
        return Objects.equals(this.namespace, apiControlPlane.namespace) && Objects.equals(this.dnsSuffix, apiControlPlane.dnsSuffix) && Objects.equals(this.uuid, apiControlPlane.uuid) && Objects.equals(this.remoteRepoUrl, apiControlPlane.remoteRepoUrl) && Objects.equals(this.version, apiControlPlane.version) && Objects.equals(this.manifest, apiControlPlane.manifest) && Objects.equals(this.valuesYaml, apiControlPlane.valuesYaml) && Objects.equals(this.tags, apiControlPlane.tags) && Objects.equals(this.kubernetesType, apiControlPlane.kubernetesType);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.dnsSuffix, this.uuid, this.remoteRepoUrl, this.version, this.manifest, this.valuesYaml, this.tags, this.kubernetesType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiControlPlane {\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    dnsSuffix: ").append(this.toIndentedString(this.dnsSuffix)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    remoteRepoUrl: ").append(this.toIndentedString(this.remoteRepoUrl)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    manifest: ").append(this.toIndentedString(this.manifest)).append("\n");
        sb.append("    valuesYaml: ").append(this.toIndentedString(this.valuesYaml)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    kubernetesType: ").append(this.toIndentedString(this.kubernetesType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

