/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.topology.monitor;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.topology.impl.DefaultTopologyService;
import org.apache.knox.gateway.topology.simple.DiscoveryException;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorHandler;

public class DescriptorsMonitor
extends FileAlterationListenerAdaptor
implements FileFilter {
    public static final List<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("json", "yml", "yaml"));
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final GatewayConfig gatewayConfig;
    private final File topologiesDir;
    private final AliasService aliasService;
    private final Map<String, List<String>> providerConfigReferences = new HashMap<String, List<String>>();

    public DescriptorsMonitor(GatewayConfig config, File topologiesDir, AliasService aliasService) {
        this.gatewayConfig = config;
        this.topologiesDir = topologiesDir;
        this.aliasService = aliasService;
    }

    public List<String> getReferencingDescriptors(String providerConfigPath) {
        String normalizedPath = FilenameUtils.normalize((String)providerConfigPath);
        return this.providerConfigReferences.computeIfAbsent(normalizedPath, p -> new ArrayList());
    }

    public void onFileCreate(File file) {
        this.onFileChange(file);
    }

    public void onFileDelete(File file) {
        for (String ext : DefaultTopologyService.SUPPORTED_TOPOLOGY_FILE_EXTENSIONS) {
            File topologyFile = new File(this.topologiesDir, FilenameUtils.getBaseName((String)file.getName()) + "." + ext);
            if (!topologyFile.exists()) continue;
            LOG.deletingTopologyForDescriptorDeletion(topologyFile.getName(), file.getName());
            topologyFile.delete();
        }
        String normalizedFilePath = FilenameUtils.normalize((String)file.getAbsolutePath());
        String reference = null;
        for (Map.Entry<String, List<String>> entry : this.providerConfigReferences.entrySet()) {
            if (!entry.getValue().contains(normalizedFilePath)) continue;
            reference = entry.getKey();
            break;
        }
        if (reference != null) {
            this.providerConfigReferences.get(reference).remove(normalizedFilePath);
            LOG.removedProviderConfigurationReference(normalizedFilePath, reference);
        }
    }

    public void onFileChange(File file) {
        try {
            String descriptorName;
            List<String> refs;
            Map result = SimpleDescriptorHandler.handle((GatewayConfig)this.gatewayConfig, (File)file, (File)this.topologiesDir, (Service[])new Service[]{this.aliasService, GatewayServer.getGatewayServices()});
            LOG.generatedTopologyForDescriptorChange(((File)result.get("topology")).getName(), file.getName());
            String providerConfig = FilenameUtils.normalize((String)((File)result.get("reference")).getAbsolutePath());
            if (!this.providerConfigReferences.containsKey(providerConfig)) {
                this.providerConfigReferences.put(providerConfig, new ArrayList());
            }
            if (!(refs = this.providerConfigReferences.get(providerConfig)).contains(descriptorName = FilenameUtils.normalize((String)file.getAbsolutePath()))) {
                for (List<String> descs : this.providerConfigReferences.values()) {
                    descs.remove(descriptorName);
                }
                refs.add(descriptorName);
                LOG.addedProviderConfigurationReference(descriptorName, providerConfig);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.simpleDescriptorHandlingError(file.getName(), e);
            String descriptorName = FilenameUtils.normalize((String)file.getAbsolutePath());
            for (List<String> descs : this.providerConfigReferences.values()) {
                descs.remove(descriptorName);
            }
        }
        catch (DiscoveryException e) {
            LOG.failedToDiscoverClusterServices(e.getClusterName(), e.getTopologyName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.simpleDescriptorHandlingError(file.getName(), e);
        }
    }

    @Override
    public boolean accept(File file) {
        String extension;
        boolean accept = false;
        if (!file.isDirectory() && file.canRead() && SUPPORTED_EXTENSIONS.contains(extension = FilenameUtils.getExtension((String)file.getName()))) {
            accept = true;
        }
        return accept;
    }
}

