/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hdfs;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.model.hdfs.HdfsUIServiceModelGenerator;

public class WebHdfsServiceModelGenerator
extends HdfsUIServiceModelGenerator {
    private static final String SERVICE = "WEBHDFS";
    private static final String WEBHDFS_SUFFIX = "/webhdfs";
    static final String WEBHDFS_ENABLED = "dfs_webhdfs_enabled";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModelGeneratorHandleResponse handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        ServiceModelGeneratorHandleResponse response = super.handles(service, serviceConfig, role, roleConfig);
        if (response.handled()) {
            String webHdfsEnabled = this.getServiceConfigValue(serviceConfig, WEBHDFS_ENABLED);
            if (webHdfsEnabled == null) {
                response.addConfigurationIssue("Missing configuration: dfs_webhdfs_enabled");
            } else if (!Boolean.parseBoolean(webHdfsEnabled)) {
                response.addConfigurationIssue("Invalid configuration: dfs_webhdfs_enabled. Expected=true; Found=" + webHdfsEnabled);
            }
        }
        return response;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        ServiceModel parent = super.generateService(service, serviceConfig, role, roleConfig);
        String serviceUrl = parent.getServiceUrl() + WEBHDFS_SUFFIX;
        ServiceModel model = this.createServiceModel(serviceUrl);
        model.addServiceProperty(WEBHDFS_ENABLED, this.getServiceConfigValue(serviceConfig, WEBHDFS_ENABLED));
        this.addParentModelMetadata(model, parent);
        return model;
    }
}

