/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.securequery;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.securequery.SecureQueryDecryptDescriptor;
import org.apache.knox.gateway.securequery.SecureQueryMessages;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;
import org.apache.knox.gateway.util.urltemplate.Builder;
import org.apache.knox.gateway.util.urltemplate.Query;
import org.apache.knox.gateway.util.urltemplate.Template;

public class SecureQueryDecryptProcessor
implements UrlRewriteStepProcessor<SecureQueryDecryptDescriptor> {
    private static SecureQueryMessages log = (SecureQueryMessages)MessagesFactory.get(SecureQueryMessages.class);
    private static final String ENCRYPTED_PARAMETER_NAME = "_";
    private ConfigurableEncryptor encryptor;

    public String getType() {
        return "decrypt-query";
    }

    public void initialize(UrlRewriteEnvironment environment, SecureQueryDecryptDescriptor descriptor) throws Exception {
        this.encryptor = new ConfigurableEncryptor("encryptQueryString");
        this.encryptor.init((GatewayConfig)environment.getAttribute("org.apache.knox.gateway.config"));
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        Template currUrl = context.getCurrentUrl();
        Builder newUrl = new Builder(currUrl);
        Map map = newUrl.getQuery();
        Query query = (Query)map.remove(ENCRYPTED_PARAMETER_NAME);
        UrlRewriteStepStatus status = UrlRewriteStepStatus.FAILURE;
        status = this.getUrlRewriteStepStatus(context, newUrl, (Map<String, Query>)map, query, status);
        return status;
    }

    private UrlRewriteStepStatus getUrlRewriteStepStatus(UrlRewriteContext context, Builder newUrl, Map<String, Query> map, Query query, UrlRewriteStepStatus status) throws UnsupportedEncodingException {
        if (query != null) {
            String value = query.getFirstValue().getPattern();
            value = this.decode(value);
            status = this.getUrlRewriteStepStatus(context, newUrl, map, status, value);
        }
        return status;
    }

    private UrlRewriteStepStatus getUrlRewriteStepStatus(UrlRewriteContext context, Builder newUrl, Map<String, Query> map, UrlRewriteStepStatus status, String value) {
        if (value != null) {
            StringTokenizer outerParser = new StringTokenizer(value, "&");
            while (outerParser.hasMoreTokens()) {
                String pair = outerParser.nextToken();
                StringTokenizer innerParser = new StringTokenizer(pair, "=");
                if (!innerParser.hasMoreTokens()) continue;
                String paramName = innerParser.nextToken();
                if (innerParser.hasMoreTokens()) {
                    String paramValue = innerParser.nextToken();
                    map.remove(paramName);
                    newUrl.addQuery(paramName, "", paramValue, true);
                    continue;
                }
                newUrl.addQuery(paramName, "", null, true);
            }
            context.setCurrentUrl(newUrl.build());
            context.getParameters().resolve("gateway.name");
            status = UrlRewriteStepStatus.SUCCESS;
        }
        return status;
    }

    public void destroy() {
    }

    String decode(String string) throws UnsupportedEncodingException {
        byte[] bytes = Base64.decodeBase64((String)string);
        EncryptionResult result = EncryptionResult.fromByteArray((byte[])bytes);
        byte[] clear = null;
        try {
            clear = this.encryptor.decrypt(result.salt, result.iv, result.cipher);
        }
        catch (Exception e) {
            log.unableToDecryptValue(e);
        }
        if (clear != null) {
            return new String(clear, StandardCharsets.UTF_8);
        }
        return null;
    }
}

