/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.AbstractPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.MonitoringLdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingPoolableLdapConnectionFactory
extends AbstractPoolableLdapConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingPoolableLdapConnectionFactory.class);

    public ValidatingPoolableLdapConnectionFactory(LdapConnectionConfig config) {
        this(new DefaultLdapConnectionFactory(config));
    }

    public ValidatingPoolableLdapConnectionFactory(LdapConnectionConfig config, Class<? extends LdapConnectionFactory> connectionFactoryClass) {
        this(ValidatingPoolableLdapConnectionFactory.newLdapConnectionFactory(config, connectionFactoryClass));
    }

    public ValidatingPoolableLdapConnectionFactory(LdapConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void activateObject(PooledObject<LdapConnection> pooledObject) throws LdapException {
        LdapConnection connection = (LdapConnection)pooledObject.getObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04146_ACTIVATING, (Object[])new Object[]{connection}));
        }
        super.activateObject(pooledObject);
        ((MonitoringLdapConnection)connection).resetMonitors();
    }

    @Override
    public PooledObject<LdapConnection> makeObject() throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04150_CREATING_LDAP_CONNECTION, (Object[])new Object[0]));
        }
        return new DefaultPooledObject((Object)new MonitoringLdapConnection(this.connectionFactory.newLdapConnection()));
    }

    @Override
    public void passivateObject(PooledObject<LdapConnection> pooledObject) throws LdapException {
        LdapConnection connection = (LdapConnection)pooledObject.getObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04151_PASSIVATING, (Object[])new Object[]{connection}));
        }
        if (!connection.isConnected() || !connection.isAuthenticated() || ((MonitoringLdapConnection)connection).bindCalled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04172_REBIND_BIND_CONNECTION, (Object[])new Object[]{connection}));
            }
            this.connectionFactory.bindConnection(connection);
        }
        if (((MonitoringLdapConnection)connection).startTlsCalled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04173_UNBIND_START_TLS, (Object[])new Object[]{connection}));
            }
            connection.unBind();
            this.connectionFactory.bindConnection(connection);
        }
        this.connectionFactory.configureConnection(connection);
    }
}

