/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBList;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBValueStore;

public class JAXBListWrapper
extends ListWrapper {
    private JAXBValueStore jaxbValueStore;
    private XMLInverseReferenceMapping xmlInverseReferenceMapping;

    public JAXBListWrapper(JAXBValueStore aJAXBValueStore, SDOProperty aProperty) {
        super(aJAXBValueStore.getDataObject(), aProperty);
        this.jaxbValueStore = aJAXBValueStore;
        this.currentElements = new JAXBList(aJAXBValueStore, aProperty);
        this.xmlInverseReferenceMapping = null;
        Mapping jaxbMapping = this.jaxbValueStore.getJAXBMappingForProperty(this.property);
        if (jaxbMapping.isAbstractCompositeCollectionMapping()) {
            XMLCompositeCollectionMapping xmlCompositeCollectionMapping = (XMLCompositeCollectionMapping)jaxbMapping;
            this.xmlInverseReferenceMapping = xmlCompositeCollectionMapping.getInverseReferenceMapping();
        } else if (jaxbMapping.isReferenceMapping()) {
            XMLCollectionReferenceMapping xmlCollectionReferenceMapping = (XMLCollectionReferenceMapping)jaxbMapping;
            this.xmlInverseReferenceMapping = xmlCollectionReferenceMapping.getInverseReferenceMapping();
        }
    }

    @Override
    protected void copyElements() {
        if (this.isLogging() && !this.dataObject.getChangeSummary().isDirty(this)) {
            this.dataObject.getChangeSummary().getOriginalElements().put(this, new ArrayList(this.currentElements));
        }
    }

    @Override
    public JAXBList getCurrentElements() {
        return (JAXBList)this.currentElements;
    }

    @Override
    protected void updateContainment(Object item, boolean updateSequence) {
        super.updateContainment(item, updateSequence);
        if (this.xmlInverseReferenceMapping != null) {
            this.xmlInverseReferenceMapping.setAttributeValueInObject(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item), this.jaxbValueStore.getEntity());
        }
    }

    @Override
    protected void updateContainment(Collection items, boolean updateSequence) {
        super.updateContainment(items, updateSequence);
        if (this.xmlInverseReferenceMapping != null) {
            for (Object item : items) {
                this.xmlInverseReferenceMapping.setAttributeValueInObject(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)item), this.jaxbValueStore.getEntity());
            }
        }
    }
}

