/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.extractor;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;

public class FormExtractor
implements CredentialsExtractor<UsernamePasswordCredentials> {
    private final String usernameParameter;
    private final String passwordParameter;

    public FormExtractor(String usernameParameter, String passwordParameter) {
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
    }

    @Override
    public UsernamePasswordCredentials extract(WebContext context) {
        String username = context.getRequestParameter(this.usernameParameter);
        String password = context.getRequestParameter(this.passwordParameter);
        if (username == null || password == null) {
            return null;
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }
}

