/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.PageHeader;

final class FreePhysicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 291;
    FreePhysicalRowId[] slots = new FreePhysicalRowId[291];

    FreePhysicalRowIdPage(BlockIo block) {
        super(block);
    }

    static FreePhysicalRowIdPage getFreePhysicalRowIdPageView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreePhysicalRowIdPage) {
            return (FreePhysicalRowIdPage)view;
        }
        return new FreePhysicalRowIdPage(block);
    }

    short getCount() {
        return this.blockIo.readShort(18);
    }

    private void setCount(short i) {
        this.blockIo.writeShort(18, i);
    }

    void free(int slot) {
        this.get(slot).setSize(0);
        this.setCount((short)(this.getCount() - 1));
    }

    FreePhysicalRowId alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        return this.get(slot);
    }

    boolean isAllocated(int slot) {
        return this.get(slot).getSize() != 0;
    }

    boolean isFree(int slot) {
        return !this.isAllocated(slot);
    }

    FreePhysicalRowId get(int slot) {
        if (this.slots[slot] == null) {
            this.slots[slot] = new FreePhysicalRowId(this.blockIo, this.slotToOffset(slot));
        }
        return this.slots[slot];
    }

    short slotToOffset(int slot) {
        return (short)(20 + slot * 14);
    }

    int getFirstFree() {
        for (int i = 0; i < 291; ++i) {
            if (!this.isFree(i)) continue;
            return i;
        }
        return -1;
    }

    int getFirstLargerThan(int size) {
        for (int i = 0; i < 291; ++i) {
            if (!this.isAllocated(i) || this.get(i).getSize() < size) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FreePhysRowIdPage ( ");
        sb.append(super.toString()).append(", ");
        sb.append("count: ").append(this.getCount());
        for (int i = 0; i < 291; ++i) {
            if (this.slots[i] == null) continue;
            sb.append(", [").append(i).append("]=<").append(this.slots[i].getBlock()).append(", ").append(this.slots[i].getOffset()).append(", ").append(this.slots[i].getSize()).append(">");
        }
        sb.append(")");
        return sb.toString();
    }
}

