/**
 * @license Angular v5.2.11
 * (c) 2010-2018 Google, Inc. https://angular.io/
 * License: MIT
 */
function $getModule(name){return $provided[name]||require(name)}function define(modules,cb){$deferred={modules:modules,cb:cb}}var $reflect={defineMetadata:function(){},getOwnMetadata:function(){}};("undefined"!=typeof global&&global||{}).Reflect=$reflect;var $deferred,$resolved,$provided;module.exports=function(provided){if($resolved)return $resolved;var result={};return $provided=Object.assign({"reflect-metadata":$reflect},provided||{},{exports:result}),$deferred.cb.apply(this,$deferred.modules.map($getModule)),$resolved=result,result},define(["exports","fs","path","typescript"],function(exports,fs,path,ts){"use strict";function __extends(d,b){function __(){this.constructor=d}extendStatics(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}/**
 * @license Angular v5.2.11
 * (c) 2010-2018 Google, Inc. https://angular.io/
 * License: MIT
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function Inject(){}function Attribute(){}function Query(){}function Directive(){}function Component(){}function Pipe(){}function Input(){}function Output(){}function HostBinding(){}function HostListener(){}function NgModule(){}function ModuleWithProviders(){}function SchemaMetadata(){}function MetadataFactory(){}function makeMetadataFactory(name,props){var factory=function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];var values=props?props.apply(void 0,args):{};return __assign({ngMetadataName:name},values)};return factory.isTypeOf=function(obj){return obj&&obj.ngMetadataName===name},factory.ngMetadataName=name,factory}function Route(){}function dashCaseToCamelCase(input){return input.replace(DASH_CASE_REGEXP,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];return m[1].toUpperCase()})}function splitAtColon(input,defaultValues){return _splitAt(input,":",defaultValues)}function splitAtPeriod(input,defaultValues){return _splitAt(input,".",defaultValues)}function _splitAt(input,character,defaultValues){var characterIndex=input.indexOf(character);return-1==characterIndex?defaultValues:[input.slice(0,characterIndex).trim(),input.slice(characterIndex+1).trim()]}function visitValue(value,visitor,context){return Array.isArray(value)?visitor.visitArray(value,context):isStrictStringMap(value)?visitor.visitStringMap(value,context):null==value||"string"==typeof value||"number"==typeof value||"boolean"==typeof value?visitor.visitPrimitive(value,context):visitor.visitOther(value,context)}function isDefined(val){return null!==val&&void 0!==val}function noUndefined(val){return void 0===val?null:val}function syntaxError(msg,parseErrors){var error=Error(msg);return error[ERROR_SYNTAX_ERROR]=!0,parseErrors&&(error[ERROR_PARSE_ERRORS]=parseErrors),error}function isSyntaxError(error){return error[ERROR_SYNTAX_ERROR]}function getParseErrors(error){return error[ERROR_PARSE_ERRORS]||[]}function escapeRegExp(s){return s.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function isStrictStringMap(obj){return"object"==typeof obj&&null!==obj&&Object.getPrototypeOf(obj)===STRING_MAP_PROTO}function utf8Encode(str){for(var encoded="",index=0;index<str.length;index++){var codePoint=str.charCodeAt(index);if(codePoint>=55296&&codePoint<=56319&&str.length>index+1){var low=str.charCodeAt(index+1);low>=56320&&low<=57343&&(index++,codePoint=(codePoint-55296<<10)+low-56320+65536)}codePoint<=127?encoded+=String.fromCharCode(codePoint):codePoint<=2047?encoded+=String.fromCharCode(codePoint>>6&31|192,63&codePoint|128):codePoint<=65535?encoded+=String.fromCharCode(codePoint>>12|224,codePoint>>6&63|128,63&codePoint|128):codePoint<=2097151&&(encoded+=String.fromCharCode(codePoint>>18&7|240,codePoint>>12&63|128,codePoint>>6&63|128,63&codePoint|128))}return encoded}function stringify(token){if("string"==typeof token)return token;if(token instanceof Array)return"["+token.map(stringify).join(", ")+"]";if(null==token)return""+token;if(token.overriddenName)return""+token.overriddenName;if(token.name)return""+token.name;var res=token.toString();if(null==res)return""+res;var newLineIndex=res.indexOf("\n");return-1===newLineIndex?res:res.substring(0,newLineIndex)}function resolveForwardRef(type){return"function"==typeof type&&type.hasOwnProperty("__forward_ref__")?type():type}function isPromise(obj){return!!obj&&"function"==typeof obj.then}function templateVisitAll(visitor,asts,context){void 0===context&&(context=null);var result=[],visit=visitor.visit?function(ast){return visitor.visit(ast,context)||ast.visit(visitor,context)}:function(ast){return ast.visit(visitor,context)};return asts.forEach(function(ast){var astResult=visit(ast);astResult&&result.push(astResult)}),result}function preserveWhitespacesDefault(preserveWhitespacesOption,defaultSetting){return void 0===defaultSetting&&(defaultSetting=!0),null===preserveWhitespacesOption?defaultSetting:preserveWhitespacesOption}function _sanitizeIdentifier(name){return name.replace(/\W/g,"_")}function identifierName(compileIdentifier){if(!compileIdentifier||!compileIdentifier.reference)return null;var ref=compileIdentifier.reference;if(ref instanceof StaticSymbol)return ref.name;if(ref.__anonymousType)return ref.__anonymousType;var identifier=stringify(ref);return identifier.indexOf("(")>=0?(identifier="anonymous_"+_anonymousTypeIndex++,ref.__anonymousType=identifier):identifier=_sanitizeIdentifier(identifier),identifier}function identifierModuleUrl(compileIdentifier){var ref=compileIdentifier.reference;return ref instanceof StaticSymbol?ref.filePath:"./"+stringify(ref)}function viewClassName(compType,embeddedTemplateIndex){return"View_"+identifierName({reference:compType})+"_"+embeddedTemplateIndex}function rendererTypeName(compType){return"RenderType_"+identifierName({reference:compType})}function hostViewClassName(compType){return"HostView_"+identifierName({reference:compType})}function componentFactoryName(compType){return identifierName({reference:compType})+"NgFactory"}function tokenName(token){return null!=token.value?_sanitizeIdentifier(token.value):identifierName(token.identifier)}function tokenReference(token){return null!=token.identifier?token.identifier.reference:token.value}function _normalizeArray(obj){return obj||[]}function flatten$1(list){return list.reduce(function(flat,item){var flatItem=Array.isArray(item)?flatten$1(item):item;return flat.concat(flatItem)},[])}function jitSourceUrl(url){return url.replace(/(\w+:\/\/[\w:-]+)?(\/+)?/,"ng:///")}function templateSourceUrl(ngModuleType,compMeta,templateMeta){var url;return url=templateMeta.isInline?compMeta.type.reference instanceof StaticSymbol?compMeta.type.reference.filePath+"."+compMeta.type.reference.name+".html":identifierName(ngModuleType)+"/"+identifierName(compMeta.type)+".html":templateMeta.templateUrl,compMeta.type.reference instanceof StaticSymbol?url:jitSourceUrl(url)}function sharedStylesheetJitUrl(meta,id){var pathParts=meta.moduleUrl.split(/\/\\/g);return jitSourceUrl("css/"+id+pathParts[pathParts.length-1]+".ngstyle.js")}function ngModuleJitUrl(moduleMeta){return jitSourceUrl(identifierName(moduleMeta.type)+"/module.ngfactory.js")}function templateJitUrl(ngModuleType,compMeta){return jitSourceUrl(identifierName(ngModuleType)+"/"+identifierName(compMeta.type)+".ngfactory.js")}function visitAll(visitor,nodes,context){void 0===context&&(context=null);var result=[],visit=visitor.visit?function(ast){return visitor.visit(ast,context)||ast.visit(visitor,context)}:function(ast){return ast.visit(visitor,context)};return nodes.forEach(function(ast){var astResult=visit(ast);astResult&&result.push(astResult)}),result}function spanOf$1$1(ast){var start=ast.sourceSpan.start.offset,end=ast.sourceSpan.end.offset;return ast instanceof Element&&(ast.endSourceSpan?end=ast.endSourceSpan.end.offset:ast.children&&ast.children.length&&(end=spanOf$1$1(ast.children[ast.children.length-1]).end)),{start:start,end:end}}function findNode(nodes,position){var path$$1=[];return visitAll(new(function(_super){function class_1(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(class_1,_super),class_1.prototype.visit=function(ast,context){var span=spanOf$1$1(ast);if(!(span.start<=position&&position<span.end))return!0;path$$1.push(ast)},class_1}(RecursiveVisitor)),nodes),new AstPath(path$$1,position)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function assertArrayOfStrings(identifier,value){if(null!=value){if(!Array.isArray(value))throw new Error("Expected '"+identifier+"' to be an array of strings.");for(var i=0;i<value.length;i+=1)if("string"!=typeof value[i])throw new Error("Expected '"+identifier+"' to be an array of strings.")}}function assertInterpolationSymbols(identifier,value){if(!(null==value||Array.isArray(value)&&2==value.length))throw new Error("Expected '"+identifier+"' to be an array, [start, end].");if(null!=value){var start_1=value[0],end_1=value[1];INTERPOLATION_BLACKLIST_REGEXPS.forEach(function(regexp){if(regexp.test(start_1)||regexp.test(end_1))throw new Error("['"+start_1+"', '"+end_1+"'] contains unusable interpolation symbol.")})}}function isStyleUrlResolvable(url){if(null==url||0===url.length||"/"==url[0])return!1;var schemeMatch=url.match(URL_WITH_SCHEMA_REGEXP);return null===schemeMatch||"package"==schemeMatch[1]||"asset"==schemeMatch[1]}function extractStyleUrls(resolver,baseUrl,cssText){var foundUrls=[],modifiedCssText=cssText.replace(CSS_STRIPPABLE_COMMENT_REGEXP,"").replace(CSS_IMPORT_REGEXP,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];var url=m[1]||m[2];return isStyleUrlResolvable(url)?(foundUrls.push(resolver.resolve(baseUrl,url)),""):m[0]});return new StyleWithImports(modifiedCssText,foundUrls)}function splitNsName(elementName){if(":"!=elementName[0])return[null,elementName];var colonIndex=elementName.indexOf(":",1);if(-1==colonIndex)throw new Error('Unsupported format "'+elementName+'" expecting ":namespace:name"');return[elementName.slice(1,colonIndex),elementName.slice(colonIndex+1)]}function isNgContainer(tagName){return"ng-container"===splitNsName(tagName)[1]}function isNgContent(tagName){return"ng-content"===splitNsName(tagName)[1]}function isNgTemplate(tagName){return"ng-template"===splitNsName(tagName)[1]}function getNsPrefix(fullName){return null===fullName?null:splitNsName(fullName)[0]}function mergeNsAndName(prefix,localName){return prefix?":"+prefix+":"+localName:localName}function preparseElement(ast){var selectAttr=null,hrefAttr=null,relAttr=null,nonBindable=!1,projectAs=null;ast.attrs.forEach(function(attr){var lcAttrName=attr.name.toLowerCase();lcAttrName==NG_CONTENT_SELECT_ATTR?selectAttr=attr.value:lcAttrName==LINK_STYLE_HREF_ATTR?hrefAttr=attr.value:lcAttrName==LINK_STYLE_REL_ATTR?relAttr=attr.value:attr.name==NG_NON_BINDABLE_ATTR?nonBindable=!0:attr.name==NG_PROJECT_AS&&attr.value.length>0&&(projectAs=attr.value)}),selectAttr=normalizeNgContentSelect(selectAttr);var nodeName=ast.name.toLowerCase(),type=PreparsedElementType.OTHER;return isNgContent(nodeName)?type=PreparsedElementType.NG_CONTENT:nodeName==STYLE_ELEMENT?type=PreparsedElementType.STYLE:nodeName==SCRIPT_ELEMENT?type=PreparsedElementType.SCRIPT:nodeName==LINK_ELEMENT&&relAttr==LINK_STYLE_REL_VALUE&&(type=PreparsedElementType.STYLESHEET),new PreparsedElement(type,selectAttr,hrefAttr,nonBindable,projectAs)}function normalizeNgContentSelect(selectAttr){return null===selectAttr||0===selectAttr.length?"*":selectAttr}function isDirectiveMetadata(type){return createDirective.isTypeOf(type)||createComponent.isTypeOf(type)}function findLast(arr,condition){for(var i=arr.length-1;i>=0;i--)if(condition(arr[i]))return arr[i];return null}function isWhitespace(code){return code>=$TAB&&code<=$SPACE||code==$NBSP}function isDigit(code){return $0<=code&&code<=$9}function isAsciiLetter(code){return code>=$a&&code<=$z||code>=$A&&code<=$Z}function isAsciiHexDigit(code){return code>=$a&&code<=$f||code>=$A&&code<=$F||isDigit(code)}function newCharacterToken(index,code){return new Token(index,TokenType.Character,code,String.fromCharCode(code))}function newIdentifierToken(index,text){return new Token(index,TokenType.Identifier,0,text)}function newKeywordToken(index,text){return new Token(index,TokenType.Keyword,0,text)}function newOperatorToken(index,text){return new Token(index,TokenType.Operator,0,text)}function newStringToken(index,text){return new Token(index,TokenType.String,0,text)}function newNumberToken(index,n){return new Token(index,TokenType.Number,n,"")}function newErrorToken(index,message){return new Token(index,TokenType.Error,0,message)}function isIdentifierStart(code){return $a<=code&&code<=$z||$A<=code&&code<=$Z||code==$_||code==$$}function isIdentifier(input){if(0==input.length)return!1;var scanner=new _Scanner(input);if(!isIdentifierStart(scanner.peek))return!1;for(scanner.advance();scanner.peek!==$EOF;){if(!isIdentifierPart(scanner.peek))return!1;scanner.advance()}return!0}function isIdentifierPart(code){return isAsciiLetter(code)||isDigit(code)||code==$_||code==$$}function isExponentStart(code){return code==$e||code==$E}function isExponentSign(code){return code==$MINUS||code==$PLUS}function isQuote(code){return code===$SQ||code===$DQ||code===$BT}function unescape(code){switch(code){case $n:return $LF;case $f:return $FF;case $r:return $CR;case $t:return $TAB;case $v:return $VTAB;default:return code}}function parseIntAutoRadix(text){var result=parseInt(text);if(isNaN(result))throw new Error("Invalid integer literal when parsing "+text);return result}function visitAstChildren(ast,visitor,context){function visit(ast){visitor.visit&&visitor.visit(ast,context)||ast.visit(visitor,context)}function visitAll(asts){asts.forEach(visit)}ast.visit({visitBinary:function(ast){visit(ast.left),visit(ast.right)},visitChain:function(ast){visitAll(ast.expressions)},visitConditional:function(ast){visit(ast.condition),visit(ast.trueExp),visit(ast.falseExp)},visitFunctionCall:function(ast){ast.target&&visit(ast.target),visitAll(ast.args)},visitImplicitReceiver:function(ast){},visitInterpolation:function(ast){visitAll(ast.expressions)},visitKeyedRead:function(ast){visit(ast.obj),visit(ast.key)},visitKeyedWrite:function(ast){visit(ast.obj),visit(ast.key),visit(ast.obj)},visitLiteralArray:function(ast){visitAll(ast.expressions)},visitLiteralMap:function(ast){},visitLiteralPrimitive:function(ast){},visitMethodCall:function(ast){visit(ast.receiver),visitAll(ast.args)},visitPipe:function(ast){visit(ast.exp),visitAll(ast.args)},visitPrefixNot:function(ast){visit(ast.expression)},visitNonNullAssert:function(ast){visit(ast.expression)},visitPropertyRead:function(ast){visit(ast.receiver)},visitPropertyWrite:function(ast){visit(ast.receiver),visit(ast.value)},visitQuote:function(ast){},visitSafeMethodCall:function(ast){visit(ast.receiver),visitAll(ast.args)},visitSafePropertyRead:function(ast){visit(ast.receiver)}})}function _createInterpolateRegExp(config){var pattern=escapeRegExp(config.start)+"([\\s\\S]*?)"+escapeRegExp(config.end);return new RegExp(pattern,"g")}function typeSourceSpan(kind,type){var moduleUrl=identifierModuleUrl(type),sourceFileName=null!=moduleUrl?"in "+kind+" "+identifierName(type)+" in "+moduleUrl:"in "+kind+" "+identifierName(type),sourceFile=new ParseSourceFile("",sourceFileName);return new ParseSourceSpan(new ParseLocation(sourceFile,-1,-1,-1),new ParseLocation(sourceFile,-1,-1,-1))}function tokenize(source,url,getTagDefinition,tokenizeExpansionForms,interpolationConfig){return void 0===tokenizeExpansionForms&&(tokenizeExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),new _Tokenizer(new ParseSourceFile(source,url),getTagDefinition,tokenizeExpansionForms,interpolationConfig).tokenize()}function _unexpectedCharacterErrorMsg(charCode){return'Unexpected character "'+(charCode===$EOF?"EOF":String.fromCharCode(charCode))+'"'}function _unknownEntityErrorMsg(entitySrc){return'Unknown entity "'+entitySrc+'" - use the "&#<decimal>;" or  "&#x<hex>;" syntax'}function isNotWhitespace(code){return!isWhitespace(code)||code===$EOF}function isNameEnd(code){return isWhitespace(code)||code===$GT||code===$SLASH||code===$SQ||code===$DQ||code===$EQ}function isPrefixEnd(code){return(code<$a||$z<code)&&(code<$A||$Z<code)&&(code<$0||code>$9)}function isDigitEntityEnd(code){return code==$SEMICOLON||code==$EOF||!isAsciiHexDigit(code)}function isNamedEntityEnd(code){return code==$SEMICOLON||code==$EOF||!isAsciiLetter(code)}function isExpansionFormStart(input,offset,interpolationConfig){var isInterpolationStart=!!interpolationConfig&&input.indexOf(interpolationConfig.start,offset)==offset;return input.charCodeAt(offset)==$LBRACE&&!isInterpolationStart}function isExpansionCaseStart(peek){return peek===$EQ||isAsciiLetter(peek)||isDigit(peek)}function compareCharCodeCaseInsensitive(code1,code2){return toUpperCaseCharCode(code1)==toUpperCaseCharCode(code2)}function toUpperCaseCharCode(code){return code>=$a&&code<=$z?code-$a+$A:code}function mergeTextTokens(srcTokens){for(var dstTokens=[],lastDstToken=void 0,i=0;i<srcTokens.length;i++){var token=srcTokens[i];lastDstToken&&lastDstToken.type==TokenType$1.TEXT&&token.type==TokenType$1.TEXT?(lastDstToken.parts[0]+=token.parts[0],lastDstToken.sourceSpan.end=token.sourceSpan.end):(lastDstToken=token,dstTokens.push(lastDstToken))}return dstTokens}function lastOnStack(stack,element){return stack.length>0&&stack[stack.length-1]===element}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function digest(message){return message.id||sha1(serializeNodes(message.nodes).join("")+"["+message.meaning+"]")}function decimalDigest(message){if(message.id)return message.id;var visitor=new _SerializerIgnoreIcuExpVisitor;return computeMsgId(message.nodes.map(function(a){return a.visit(visitor,null)}).join(""),message.meaning)}function serializeNodes(nodes){return nodes.map(function(a){return a.visit(serializerVisitor,null)})}function sha1(str){var utf8=utf8Encode(str),words32=stringToWords32(utf8,Endian.Big),len=8*utf8.length,w=new Array(80),_a=[1732584193,4023233417,2562383102,271733878,3285377520],a=_a[0],b=_a[1],c=_a[2],d=_a[3],e=_a[4];words32[len>>5]|=128<<24-len%32,words32[15+(len+64>>9<<4)]=len;for(var i=0;i<words32.length;i+=16){for(var _b=[a,b,c,d,e],h0=_b[0],h1=_b[1],h2=_b[2],h3=_b[3],h4=_b[4],j=0;j<80;j++){w[j]=j<16?words32[i+j]:rol32(w[j-3]^w[j-8]^w[j-14]^w[j-16],1);var _c=fk(j,b,c,d),f=_c[0],k=_c[1],temp=[rol32(a,5),f,e,k,w[j]].reduce(add32);_d=[d,c,rol32(b,30),a,temp],e=_d[0],d=_d[1],c=_d[2],b=_d[3],a=_d[4]}_e=[add32(a,h0),add32(b,h1),add32(c,h2),add32(d,h3),add32(e,h4)],a=_e[0],b=_e[1],c=_e[2],d=_e[3],e=_e[4]}return byteStringToHexString(words32ToByteString([a,b,c,d,e]));var _d,_e}function fk(index,b,c,d){return index<20?[b&c|~b&d,1518500249]:index<40?[b^c^d,1859775393]:index<60?[b&c|b&d|c&d,2400959708]:[b^c^d,3395469782]}function fingerprint(str){var utf8=utf8Encode(str),_a=[hash32(utf8,0),hash32(utf8,102072)],hi=_a[0],lo=_a[1];return 0!=hi||0!=lo&&1!=lo||(hi^=319790063,lo^=-1801410264),[hi,lo]}function computeMsgId(msg,meaning){var _a=fingerprint(msg),hi=_a[0],lo=_a[1];if(meaning){var _b=fingerprint(meaning),him=_b[0],lom=_b[1];_c=add64(rol64([hi,lo],1),[him,lom]),hi=_c[0],lo=_c[1]}return byteStringToDecString(words32ToByteString([2147483647&hi,lo]));var _c}function hash32(str,c){var i,_a=[2654435769,2654435769],a=_a[0],b=_a[1],len=str.length;for(i=0;i+12<=len;i+=12)a=add32(a,wordAt(str,i,Endian.Little)),b=add32(b,wordAt(str,i+4,Endian.Little)),c=add32(c,wordAt(str,i+8,Endian.Little)),_b=mix([a,b,c]),a=_b[0],b=_b[1],c=_b[2];return a=add32(a,wordAt(str,i,Endian.Little)),b=add32(b,wordAt(str,i+4,Endian.Little)),c=add32(c,len),c=add32(c,wordAt(str,i+8,Endian.Little)<<8),mix([a,b,c])[2];var _b}function mix(_a){var a=_a[0],b=_a[1],c=_a[2];return a=sub32(a,b),a=sub32(a,c),a^=c>>>13,b=sub32(b,c),b=sub32(b,a),b^=a<<8,c=sub32(c,a),c=sub32(c,b),c^=b>>>13,a=sub32(a,b),a=sub32(a,c),a^=c>>>12,b=sub32(b,c),b=sub32(b,a),b^=a<<16,c=sub32(c,a),c=sub32(c,b),c^=b>>>5,a=sub32(a,b),a=sub32(a,c),a^=c>>>3,b=sub32(b,c),b=sub32(b,a),b^=a<<10,c=sub32(c,a),c=sub32(c,b),c^=b>>>15,[a,b,c]}function add32(a,b){return add32to64(a,b)[1]}function add32to64(a,b){var low=(65535&a)+(65535&b),high=(a>>>16)+(b>>>16)+(low>>>16);return[high>>>16,high<<16|65535&low]}function add64(_a,_b){var ah=_a[0],al=_a[1],bh=_b[0],bl=_b[1],_c=add32to64(al,bl),carry=_c[0],l=_c[1];return[add32(add32(ah,bh),carry),l]}function sub32(a,b){var low=(65535&a)-(65535&b);return(a>>16)-(b>>16)+(low>>16)<<16|65535&low}function rol32(a,count){return a<<count|a>>>32-count}function rol64(_a,count){var hi=_a[0],lo=_a[1];return[hi<<count|lo>>>32-count,lo<<count|hi>>>32-count]}function stringToWords32(str,endian){for(var words32=Array(str.length+3>>>2),i=0;i<words32.length;i++)words32[i]=wordAt(str,4*i,endian);return words32}function byteAt(str,index){return index>=str.length?0:255&str.charCodeAt(index)}function wordAt(str,index,endian){var word=0;if(endian===Endian.Big)for(var i=0;i<4;i++)word+=byteAt(str,index+i)<<24-8*i;else for(var i=0;i<4;i++)word+=byteAt(str,index+i)<<8*i;return word}function words32ToByteString(words32){return words32.reduce(function(str,word){return str+word32ToByteString(word)},"")}function word32ToByteString(word){for(var str="",i=0;i<4;i++)str+=String.fromCharCode(word>>>8*(3-i)&255);return str}function byteStringToHexString(str){for(var hex="",i=0;i<str.length;i++){var b=byteAt(str,i);hex+=(b>>>4).toString(16)+(15&b).toString(16)}return hex.toLowerCase()}function byteStringToDecString(str){for(var decimal="",toThePower="1",i=str.length-1;i>=0;i--)decimal=addBigInt(decimal,numberTimesBigInt(byteAt(str,i),toThePower)),toThePower=numberTimesBigInt(256,toThePower);return decimal.split("").reverse().join("")}function addBigInt(x,y){for(var sum="",len=Math.max(x.length,y.length),i=0,carry=0;i<len||carry;i++){var tmpSum=carry+ +(x[i]||0)+ +(y[i]||0);tmpSum>=10?(carry=1,sum+=tmpSum-10):(carry=0,sum+=tmpSum)}return sum}function numberTimesBigInt(num,b){for(var product="",bToThePower=b;0!==num;num>>>=1)1&num&&(product=addBigInt(product,bToThePower)),bToThePower=addBigInt(bToThePower,bToThePower);return product}function getHtmlTagDefinition(tagName){return TAG_DEFINITIONS[tagName.toLowerCase()]||_DEFAULT_TAG_DEFINITION}function createI18nMessageFactory(interpolationConfig){var visitor=new _I18nVisitor(_expParser,interpolationConfig);return function(nodes,meaning,description,id){return visitor.toI18nMessage(nodes,meaning,description,id)}}function _extractPlaceholderName(input){return input.split(_CUSTOM_PH_EXP)[2]}function extractMessages(nodes,interpolationConfig,implicitTags,implicitAttrs){return new _Visitor(implicitTags,implicitAttrs).extract(nodes,interpolationConfig)}function mergeTranslations(nodes,translations,interpolationConfig,implicitTags,implicitAttrs){return new _Visitor(implicitTags,implicitAttrs).merge(nodes,translations,interpolationConfig)}function _isOpeningComment(n){return!!(n instanceof Comment&&n.value&&n.value.startsWith("i18n"))}function _isClosingComment(n){return!!(n instanceof Comment&&n.value&&"/i18n"===n.value)}function _getI18nAttr(p){return p.attrs.find(function(attr){return attr.name===_I18N_ATTR})||null}function _parseMessageMeta(i18n){if(!i18n)return{meaning:"",description:"",id:""};var idIndex=i18n.indexOf(ID_SEPARATOR),descIndex=i18n.indexOf(MEANING_SEPARATOR),_a=idIndex>-1?[i18n.slice(0,idIndex),i18n.slice(idIndex+2)]:[i18n,""],meaningAndDesc=_a[0],id=_a[1],_b=descIndex>-1?[meaningAndDesc.slice(0,descIndex),meaningAndDesc.slice(descIndex+1)]:["",meaningAndDesc];return{meaning:_b[0],description:_b[1],id:id}}function getXmlTagDefinition(tagName){return _TAG_DEFINITION}function serialize(nodes){return nodes.map(function(node){return node.visit(_visitor)}).join("")}function escapeXml(text){return _ESCAPED_CHARS.reduce(function(text,entry){return text.replace(entry[0],entry[1])},text)}function getCtypeForTag(tag){switch(tag.toLowerCase()){case"br":return"lb";case"img":return"image";default:return"x-"+tag}}function getTypeForTag(tag){switch(tag.toLowerCase()){case"br":case"b":case"i":case"u":return"fmt";case"img":return"image";case"a":return"link";default:return"other"}}function digest$1(message){return decimalDigest(message)}function toPublicName(internalName){return internalName.toUpperCase().replace(/[^A-Z0-9_]/g,"_")}function createLazyProperty(messages,id,valueFn){Object.defineProperty(messages,id,{configurable:!0,enumerable:!0,get:function(){var value=valueFn();return Object.defineProperty(messages,id,{enumerable:!0,value:value}),value},set:function(_){throw new Error("Could not overwrite an XTB translation")}})}function createSerializer(format){switch(format=(format||"xlf").toLowerCase()){case"xmb":return new Xmb;case"xtb":return new Xtb;case"xliff2":case"xlf2":return new Xliff2;case"xliff":case"xlf":default:return new Xliff}}function ngfactoryFilePath(filePath,forceSourceFile){void 0===forceSourceFile&&(forceSourceFile=!1);var urlWithSuffix=splitTypescriptSuffix(filePath,forceSourceFile);return urlWithSuffix[0]+".ngfactory"+normalizeGenFileSuffix(urlWithSuffix[1])}function stripGeneratedFileSuffix(filePath){return filePath.replace(GENERATED_FILE,".")}function isGeneratedFile(filePath){return GENERATED_FILE.test(filePath)}function splitTypescriptSuffix(path$$1,forceSourceFile){if(void 0===forceSourceFile&&(forceSourceFile=!1),path$$1.endsWith(".d.ts"))return[path$$1.slice(0,-5),forceSourceFile?".ts":".d.ts"];var lastDot=path$$1.lastIndexOf(".");return-1!==lastDot?[path$$1.substring(0,lastDot),path$$1.substring(lastDot)]:[path$$1,""]}function normalizeGenFileSuffix(srcFileSuffix){return".tsx"===srcFileSuffix?".ts":srcFileSuffix}function summaryFileName(fileName){return fileName.replace(STRIP_SRC_FILE_SUFFIXES,"")+".ngsummary.json"}function summaryForJitFileName(fileName,forceSourceFile){void 0===forceSourceFile&&(forceSourceFile=!1);var urlWithSuffix=splitTypescriptSuffix(stripGeneratedFileSuffix(fileName),forceSourceFile);return urlWithSuffix[0]+".ngsummary"+urlWithSuffix[1]}function stripSummaryForJitFileSuffix(filePath){return filePath.replace(JIT_SUMMARY_FILE,".")}function summaryForJitName(symbolName){return symbolName+"NgSummary"}function stripSummaryForJitNameSuffix(symbolName){return symbolName.replace(JIT_SUMMARY_NAME,"")}function isLoweredSymbol(name){return LOWERED_SYMBOL.test(name)}function createLoweredSymbol(id){return"ɵ"+id}function createTokenForReference(reference){return{identifier:{reference:reference}}}function createTokenForExternalReference(reflector,reference){return createTokenForReference(reflector.resolveExternalReference(reference))}function hasLifecycleHook(reflector,hook,token){return reflector.hasLifecycleHook(token,getHookName(hook))}function getAllLifecycleHooks(reflector,token){return LIFECYCLE_HOOKS_VALUES.filter(function(hook){return hasLifecycleHook(reflector,hook,token)})}function getHookName(hook){switch(hook){case LifecycleHooks.OnInit:return"ngOnInit";case LifecycleHooks.OnDestroy:return"ngOnDestroy";case LifecycleHooks.DoCheck:return"ngDoCheck";case LifecycleHooks.OnChanges:return"ngOnChanges";case LifecycleHooks.AfterContentInit:return"ngAfterContentInit";case LifecycleHooks.AfterContentChecked:return"ngAfterContentChecked";case LifecycleHooks.AfterViewInit:return"ngAfterViewInit";case LifecycleHooks.AfterViewChecked:return"ngAfterViewChecked"}}function flattenArray(tree,out){if(void 0===out&&(out=[]),tree)for(var i=0;i<tree.length;i++){var item=resolveForwardRef(tree[i]);Array.isArray(item)?flattenArray(item,out):out.push(item)}return out}function dedupeArray(array){return array?Array.from(new Set(array)):[]}function flattenAndDedupeArray(tree){return dedupeArray(flattenArray(tree))}function isValidType(value){return value instanceof StaticSymbol||value instanceof Type}function extractIdentifiers(value,targetIdentifiers){visitValue(value,new _CompileValueConverter,targetIdentifiers)}function stringifyType(type){return type instanceof StaticSymbol?type.name+" in "+type.filePath:stringify(type)}function componentStillLoadingError(compType){var error=Error("Can't compile synchronously as "+stringify(compType)+" is still being loaded!");return error[ERROR_COMPONENT_TYPE]=compType,error}function nullSafeIsEquivalent(base,other){return null==base||null==other?base==other:base.isEquivalent(other)}function areAllEquivalent(base,other){var len=base.length;if(len!==other.length)return!1;for(var i=0;i<len;i++)if(!base[i].isEquivalent(other[i]))return!1;return!0}function findReadVarNames(stmts){var visitor=new _ReadVarVisitor;return visitor.visitAllStatements(stmts,null),visitor.varNames}function collectExternalReferences(stmts){var visitor=new _FindExternalReferencesVisitor;return visitor.visitAllStatements(stmts,null),visitor.externalReferences}function applySourceSpanToStatementIfNeeded(stmt,sourceSpan){if(!sourceSpan)return stmt;var transformer=new _ApplySourceSpanTransformer(sourceSpan);return stmt.visitStatement(transformer,null)}function applySourceSpanToExpressionIfNeeded(expr,sourceSpan){if(!sourceSpan)return expr;var transformer=new _ApplySourceSpanTransformer(sourceSpan);return expr.visitExpression(transformer,null)}function variable(name,type,sourceSpan){return new ReadVarExpr(name,type,sourceSpan)}function importExpr(id,typeParams,sourceSpan){return void 0===typeParams&&(typeParams=null),new ExternalExpr(id,null,typeParams,sourceSpan)}function importType(id,typeParams,typeModifiers){return void 0===typeParams&&(typeParams=null),void 0===typeModifiers&&(typeModifiers=null),null!=id?expressionType(importExpr(id,typeParams,null),typeModifiers):null}function expressionType(expr,typeModifiers){return void 0===typeModifiers&&(typeModifiers=null),new ExpressionType(expr,typeModifiers)}function literalArr(values,type,sourceSpan){return new LiteralArrayExpr(values,type,sourceSpan)}function literalMap(values,type){return void 0===type&&(type=null),new LiteralMapExpr(values.map(function(e){return new LiteralMapEntry(e.key,e.value,e.quoted)}),type,null)}function not(expr,sourceSpan){return new NotExpr(expr,sourceSpan)}function assertNotNull(expr,sourceSpan){return new AssertNotNull(expr,sourceSpan)}function fn(params,body,type,sourceSpan){return new FunctionExpr(params,body,type,sourceSpan)}function literal(value,type,sourceSpan){return new LiteralExpr(value,type,sourceSpan)}function _transformProvider(provider,_a){var useExisting=_a.useExisting,useValue=_a.useValue,deps=_a.deps;return{token:provider.token,useClass:provider.useClass,useExisting:useExisting,useFactory:provider.useFactory,useValue:useValue,deps:deps,multi:provider.multi}}function _transformProviderAst(provider,_a){var eager=_a.eager,providers=_a.providers;return new ProviderAst(provider.token,provider.multiProvider,provider.eager||eager,providers,provider.providerType,provider.lifecycleHooks,provider.sourceSpan)}function _resolveProvidersFromDirectives(directives,sourceSpan,targetErrors){var providersByToken=new Map;return directives.forEach(function(directive){_resolveProviders([{token:{identifier:directive.type},useClass:directive.type}],directive.isComponent?ProviderAstType.Component:ProviderAstType.Directive,!0,sourceSpan,targetErrors,providersByToken)}),directives.filter(function(dir){return dir.isComponent}).concat(directives.filter(function(dir){return!dir.isComponent})).forEach(function(directive){_resolveProviders(directive.providers,ProviderAstType.PublicService,!1,sourceSpan,targetErrors,providersByToken),_resolveProviders(directive.viewProviders,ProviderAstType.PrivateService,!1,sourceSpan,targetErrors,providersByToken)}),providersByToken}function _resolveProviders(providers,providerType,eager,sourceSpan,targetErrors,targetProvidersByToken){providers.forEach(function(provider){var resolvedProvider=targetProvidersByToken.get(tokenReference(provider.token));if(null!=resolvedProvider&&!!resolvedProvider.multiProvider!=!!provider.multi&&targetErrors.push(new ProviderError("Mixing multi and non multi provider is not possible for token "+tokenName(resolvedProvider.token),sourceSpan)),resolvedProvider)provider.multi||(resolvedProvider.providers.length=0),resolvedProvider.providers.push(provider);else{var lifecycleHooks=provider.token.identifier&&provider.token.identifier.lifecycleHooks?provider.token.identifier.lifecycleHooks:[],isUseValue=!(provider.useClass||provider.useExisting||provider.useFactory);resolvedProvider=new ProviderAst(provider.token,!!provider.multi,eager||isUseValue,[provider],providerType,lifecycleHooks,sourceSpan),targetProvidersByToken.set(tokenReference(provider.token),resolvedProvider)}})}function _getViewQueries(component){var viewQueryId=1,viewQueries=new Map;return component.viewQueries&&component.viewQueries.forEach(function(query){return _addQueryToTokenMap(viewQueries,{meta:query,queryId:viewQueryId++})}),viewQueries}function _getContentQueries(contentQueryStartId,directives){var contentQueryId=contentQueryStartId,contentQueries=new Map;return directives.forEach(function(directive,directiveIndex){directive.queries&&directive.queries.forEach(function(query){return _addQueryToTokenMap(contentQueries,{meta:query,queryId:contentQueryId++})})}),contentQueries}function _addQueryToTokenMap(map,query){query.meta.selectors.forEach(function(token){var entry=map.get(tokenReference(token));entry||(entry=[],map.set(tokenReference(token),entry)),entry.push(query)})}function convertValueToOutputAst(ctx,value,type){return void 0===type&&(type=null),visitValue(value,new _ValueOutputAstTransformer(ctx),type)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function providerDef(ctx,providerAst){var flags=0;providerAst.eager||(flags|=4096),providerAst.providerType===ProviderAstType.PrivateService&&(flags|=8192),providerAst.lifecycleHooks.forEach(function(lifecycleHook){lifecycleHook!==LifecycleHooks.OnDestroy&&providerAst.providerType!==ProviderAstType.Directive&&providerAst.providerType!==ProviderAstType.Component||(flags|=lifecycleHookToNodeFlag(lifecycleHook))});var _a=providerAst.multiProvider?multiProviderDef(ctx,flags,providerAst.providers):singleProviderDef(ctx,flags,providerAst.providerType,providerAst.providers[0]);return{providerExpr:_a.providerExpr,flags:_a.flags,depsExpr:_a.depsExpr,tokenExpr:tokenExpr(ctx,providerAst.token)}}function multiProviderDef(ctx,flags,providers){function convertDeps(providerIndex,deps){return deps.map(function(dep,depIndex){var paramName="p"+providerIndex+"_"+depIndex;return allParams.push(new FnParam(paramName,DYNAMIC_TYPE)),allDepDefs.push(depDef(ctx,dep)),variable(paramName)})}var allDepDefs=[],allParams=[],exprs=providers.map(function(provider,providerIndex){var expr;if(provider.useClass){var depExprs=convertDeps(providerIndex,provider.deps||provider.useClass.diDeps);expr=ctx.importExpr(provider.useClass.reference).instantiate(depExprs)}else if(provider.useFactory){var depExprs=convertDeps(providerIndex,provider.deps||provider.useFactory.diDeps);expr=ctx.importExpr(provider.useFactory.reference).callFn(depExprs)}else if(provider.useExisting){var depExprs=convertDeps(providerIndex,[{token:provider.useExisting}]);expr=depExprs[0]}else expr=convertValueToOutputAst(ctx,provider.useValue);return expr});return{providerExpr:fn(allParams,[new ReturnStatement(literalArr(exprs))],INFERRED_TYPE),flags:1024|flags,depsExpr:literalArr(allDepDefs)}}function singleProviderDef(ctx,flags,providerType,providerMeta){var providerExpr,deps;return providerType===ProviderAstType.Directive||providerType===ProviderAstType.Component?(providerExpr=ctx.importExpr(providerMeta.useClass.reference),flags|=16384,deps=providerMeta.deps||providerMeta.useClass.diDeps):providerMeta.useClass?(providerExpr=ctx.importExpr(providerMeta.useClass.reference),flags|=512,deps=providerMeta.deps||providerMeta.useClass.diDeps):providerMeta.useFactory?(providerExpr=ctx.importExpr(providerMeta.useFactory.reference),flags|=1024,deps=providerMeta.deps||providerMeta.useFactory.diDeps):providerMeta.useExisting?(providerExpr=NULL_EXPR,flags|=2048,deps=[{token:providerMeta.useExisting}]):(providerExpr=convertValueToOutputAst(ctx,providerMeta.useValue),flags|=256,deps=[]),{providerExpr:providerExpr,flags:flags,depsExpr:literalArr(deps.map(function(dep){return depDef(ctx,dep)}))}}function tokenExpr(ctx,tokenMeta){return tokenMeta.identifier?ctx.importExpr(tokenMeta.identifier.reference):literal(tokenMeta.value)}function depDef(ctx,dep){var expr=dep.isValue?convertValueToOutputAst(ctx,dep.value):tokenExpr(ctx,dep.token),flags=0;return dep.isSkipSelf&&(flags|=1),dep.isOptional&&(flags|=2),dep.isValue&&(flags|=8),0===flags?expr:literalArr([literal(flags),expr])}function lifecycleHookToNodeFlag(lifecycleHook){var nodeFlag=0;switch(lifecycleHook){case LifecycleHooks.AfterContentChecked:nodeFlag=2097152;break;case LifecycleHooks.AfterContentInit:nodeFlag=1048576;break;case LifecycleHooks.AfterViewChecked:nodeFlag=8388608;break;case LifecycleHooks.AfterViewInit:nodeFlag=4194304;break;case LifecycleHooks.DoCheck:nodeFlag=262144;break;case LifecycleHooks.OnChanges:nodeFlag=524288;break;case LifecycleHooks.OnDestroy:nodeFlag=131072;break;case LifecycleHooks.OnInit:nodeFlag=65536}return nodeFlag}function componentFactoryResolverProviderDef(reflector,ctx,flags,entryComponents){var entryComponentFactories=entryComponents.map(function(entryComponent){return ctx.importExpr(entryComponent.componentFactory)}),token=createTokenForExternalReference(reflector,Identifiers.ComponentFactoryResolver),classMeta={diDeps:[{isValue:!0,value:literalArr(entryComponentFactories)},{token:token,isSkipSelf:!0,isOptional:!0},{token:createTokenForExternalReference(reflector,Identifiers.NgModuleRef)}],lifecycleHooks:[],reference:reflector.resolveExternalReference(Identifiers.CodegenComponentFactoryResolver)},_a=singleProviderDef(ctx,flags,ProviderAstType.PrivateService,{token:token,multi:!1,useClass:classMeta});return{providerExpr:_a.providerExpr,flags:_a.flags,depsExpr:_a.depsExpr,tokenExpr:tokenExpr(ctx,token)}}function toBase64String(value){var b64="";value=utf8Encode(value);for(var i=0;i<value.length;){var i1=value.charCodeAt(i++),i2=value.charCodeAt(i++),i3=value.charCodeAt(i++);b64+=toBase64Digit(i1>>2),b64+=toBase64Digit((3&i1)<<4|(isNaN(i2)?0:i2>>4)),b64+=isNaN(i2)?"=":toBase64Digit((15&i2)<<2|i3>>6),b64+=isNaN(i2)||isNaN(i3)?"=":toBase64Digit(63&i3)}return b64}function toBase64VLQ(value){value=value<0?1+(-value<<1):value<<1;var out="";do{var digit=31&value;value>>=5,value>0&&(digit|=32),out+=toBase64Digit(digit)}while(value>0);return out}function toBase64Digit(value){if(value<0||value>=64)throw new Error("Can only encode value in the range [0, 63]");return B64_DIGITS[value]}function escapeIdentifier(input,escapeDollar,alwaysQuote){if(void 0===alwaysQuote&&(alwaysQuote=!0),null==input)return null;var body=input.replace(_SINGLE_QUOTE_ESCAPE_STRING_RE,function(){for(var match=[],_i=0;_i<arguments.length;_i++)match[_i]=arguments[_i];return"$"==match[0]?escapeDollar?"\\$":"$":"\n"==match[0]?"\\n":"\r"==match[0]?"\\r":"\\"+match[0]});return alwaysQuote||!_LEGAL_IDENTIFIER_RE.test(body)?"'"+body+"'":body}function _createIndent(count){for(var res="",i=0;i<count;i++)res+=_INDENT_WITH;return res}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function debugOutputAstAsTypeScript(ast){var converter=new _TsEmitterVisitor,ctx=EmitterVisitorContext.createRoot();return(Array.isArray(ast)?ast:[ast]).forEach(function(ast){if(ast instanceof Statement)ast.visitStatement(converter,ctx);else if(ast instanceof Expression)ast.visitExpression(converter,ctx);else{if(!(ast instanceof Type$1))throw new Error("Don't know how to print debug info for "+ast);ast.visitType(converter,ctx)}}),ctx.toSource()}function registerContext(ctx,specs){for(var _i=0,specs_1=specs;_i<specs_1.length;_i++){var spec=specs_1[_i];SECURITY_SCHEMA[spec.toLowerCase()]=ctx}}function _isPixelDimensionStyle(prop){switch(prop){case"width":case"height":case"minWidth":case"minHeight":case"maxWidth":case"maxHeight":case"left":case"top":case"bottom":case"right":case"fontSize":case"outlineWidth":case"outlineOffset":case"paddingTop":case"paddingLeft":case"paddingBottom":case"paddingRight":case"marginTop":case"marginLeft":case"marginBottom":case"marginRight":case"borderRadius":case"borderWidth":case"borderTopWidth":case"borderLeftWidth":case"borderRightWidth":case"borderBottomWidth":case"textIndent":return!0;default:return!1}}function stripComments(input){return input.replace(_commentRe,"")}function extractCommentsWithHash(input){return input.match(_commentWithHashRe)||[]}function processRules(input,ruleCallback){var inputWithEscapedBlocks=escapeBlocks(input),nextBlockIndex=0;return inputWithEscapedBlocks.escapedString.replace(_ruleRe,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];var selector=m[2],content="",suffix=m[4],contentPrefix="";suffix&&suffix.startsWith("{"+BLOCK_PLACEHOLDER)&&(content=inputWithEscapedBlocks.blocks[nextBlockIndex++],suffix=suffix.substring(BLOCK_PLACEHOLDER.length+1),contentPrefix="{");var rule=ruleCallback(new CssRule(selector,content));return""+m[1]+rule.selector+m[3]+contentPrefix+rule.content+suffix})}function escapeBlocks(input){for(var inputParts=input.split(_curlyRe),resultParts=[],escapedBlocks=[],bracketCount=0,currentBlockParts=[],partIndex=0;partIndex<inputParts.length;partIndex++){var part=inputParts[partIndex];part==CLOSE_CURLY&&bracketCount--,bracketCount>0?currentBlockParts.push(part):(currentBlockParts.length>0&&(escapedBlocks.push(currentBlockParts.join("")),resultParts.push(BLOCK_PLACEHOLDER),currentBlockParts=[]),resultParts.push(part)),part==OPEN_CURLY&&bracketCount++}return currentBlockParts.length>0&&(escapedBlocks.push(currentBlockParts.join("")),resultParts.push(BLOCK_PLACEHOLDER)),new StringWithEscapedBlocks(resultParts.join(""),escapedBlocks)}function getStylesVarName(component){var result="styles";return component&&(result+="_"+identifierName(component.type)),result}function hasPreserveWhitespacesAttr(attrs){return attrs.some(function(attr){return attr.name===PRESERVE_WS_ATTR_NAME})}function replaceNgsp(value){return value.replace(new RegExp(NGSP_UNICODE,"g")," ")}function removeWhitespaces(htmlAstWithErrors){return new ParseTreeResult(visitAll(new WhitespaceVisitor,htmlAstWithErrors.rootNodes),htmlAstWithErrors.errors)}function expandNodes(nodes){var expander=new _Expander;return new ExpansionResult(visitAll(expander,nodes),expander.isExpanded,expander.errors)}function _expandPluralForm(ast,errors){var children=ast.cases.map(function(c){-1!=PLURAL_CASES.indexOf(c.value)||c.value.match(/^=\d+$/)||errors.push(new ExpansionError(c.valueSourceSpan,'Plural cases should be "=<number>" or one of '+PLURAL_CASES.join(", ")));var expansionResult=expandNodes(c.expression);return errors.push.apply(errors,expansionResult.errors),new Element("ng-template",[new Attribute$1("ngPluralCase",""+c.value,c.valueSourceSpan)],expansionResult.nodes,c.sourceSpan,c.sourceSpan,c.sourceSpan)}),switchAttr=new Attribute$1("[ngPlural]",ast.switchValue,ast.switchValueSourceSpan);return new Element("ng-container",[switchAttr],children,ast.sourceSpan,ast.sourceSpan,ast.sourceSpan)}function _expandDefaultForm(ast,errors){var children=ast.cases.map(function(c){var expansionResult=expandNodes(c.expression);return errors.push.apply(errors,expansionResult.errors),"other"===c.value?new Element("ng-template",[new Attribute$1("ngSwitchDefault","",c.valueSourceSpan)],expansionResult.nodes,c.sourceSpan,c.sourceSpan,c.sourceSpan):new Element("ng-template",[new Attribute$1("ngSwitchCase",""+c.value,c.valueSourceSpan)],expansionResult.nodes,c.sourceSpan,c.sourceSpan,c.sourceSpan)}),switchAttr=new Attribute$1("[ngSwitch]",ast.switchValue,ast.switchValueSourceSpan);return new Element("ng-container",[switchAttr],children,ast.sourceSpan,ast.sourceSpan,ast.sourceSpan)}function _isAnimationLabel(name){return"@"==name[0]}function calcPossibleSecurityContexts(registry,selector,propName,isAttribute){var ctxs=[];return CssSelector.parse(selector).forEach(function(selector){var elementNames=selector.element?[selector.element]:registry.allKnownElementNames(),notElementNames=new Set(selector.notSelectors.filter(function(selector){return selector.isElementSelector()}).map(function(selector){return selector.element})),possibleElementNames=elementNames.filter(function(elementName){return!notElementNames.has(elementName)});ctxs.push.apply(ctxs,possibleElementNames.map(function(elementName){return registry.securityContext(elementName,propName,isAttribute)}))}),0===ctxs.length?[SecurityContext.NONE]:Array.from(new Set(ctxs)).sort()}function warnOnlyOnce(warnings){return function(error){return-1===warnings.indexOf(error.msg)||(warningCounts[error.msg]=(warningCounts[error.msg]||0)+1,warningCounts[error.msg]<=1)}}function splitExportAs(exportAs){return exportAs?exportAs.split(",").map(function(e){return e.trim()}):[]}function splitClasses(classAttrValue){return classAttrValue.trim().split(/\s+/g)}function createElementCssSelector$1(elementName,attributes){var cssSelector=new CssSelector,elNameNoNs=splitNsName(elementName)[1];cssSelector.setElement(elNameNoNs);for(var i=0;i<attributes.length;i++){var attrName=attributes[i][0],attrNameNoNs=splitNsName(attrName)[1],attrValue=attributes[i][1];if(cssSelector.addAttribute(attrNameNoNs,attrValue),attrName.toLowerCase()==CLASS_ATTR){splitClasses(attrValue).forEach(function(className){return cssSelector.addClassName(className)})}}return cssSelector}function _isEmptyTextNode(node){return node instanceof Text&&0==node.value.trim().length}function removeSummaryDuplicates(items){var map=new Map;return items.forEach(function(item){map.get(item.type.reference)||map.set(item.type.reference,item)}),Array.from(map.values())}function isEmptyExpression(ast){return ast instanceof ASTWithSource&&(ast=ast.ast),ast instanceof EmptyExpr}function isTemplate(el,enableLegacyTemplate,reportDeprecation){if(isNgTemplate(el.name))return!0;var tagNoNs=splitNsName(el.name)[1];return!(tagNoNs.toLowerCase()!==TEMPLATE_ELEMENT||!enableLegacyTemplate||tagNoNs.toLowerCase()!==TEMPLATE_ELEMENT)&&(reportDeprecation(TEMPLATE_ELEMENT_DEPRECATION_WARNING,el.sourceSpan),!0)}function convertActionBinding(localResolver,implicitReceiver,action,bindingId){localResolver||(localResolver=new DefaultLocalResolver);var actionWithoutBuiltins=convertPropertyBindingBuiltins({createLiteralArrayConverter:function(argCount){return function(args){return literalArr(args)}},createLiteralMapConverter:function(keys){return function(values){return literalMap(keys.map(function(k,i){return{key:k.key,value:values[i],quoted:k.quoted}}))}},createPipeConverter:function(name){throw new Error("Illegal State: Actions are not allowed to contain pipes. Pipe: "+name)}},action),visitor=new _AstToIrVisitor(localResolver,implicitReceiver,bindingId),actionStmts=[];flattenStatements(actionWithoutBuiltins.visit(visitor,_Mode.Statement),actionStmts),prependTemporaryDecls(visitor.temporaryCount,bindingId,actionStmts);var lastIndex=actionStmts.length-1,preventDefaultVar=null;if(lastIndex>=0){var lastStatement=actionStmts[lastIndex],returnExpr=convertStmtIntoExpression(lastStatement);returnExpr&&(preventDefaultVar=createPreventDefaultVar(bindingId),actionStmts[lastIndex]=preventDefaultVar.set(returnExpr.cast(DYNAMIC_TYPE).notIdentical(literal(!1))).toDeclStmt(null,[StmtModifier.Final]))}return new ConvertActionBindingResult(actionStmts,preventDefaultVar)}function convertPropertyBindingBuiltins(converterFactory,ast){return convertBuiltins(converterFactory,ast)}function convertPropertyBinding(localResolver,implicitReceiver,expressionWithoutBuiltins,bindingId,form){localResolver||(localResolver=new DefaultLocalResolver);var currValExpr=createCurrValueExpr(bindingId),stmts=[],visitor=new _AstToIrVisitor(localResolver,implicitReceiver,bindingId),outputExpr=expressionWithoutBuiltins.visit(visitor,_Mode.Expression);if(visitor.temporaryCount)for(var i=0;i<visitor.temporaryCount;i++)stmts.push(temporaryDeclaration(bindingId,i));else if(form==BindingForm.TrySimple)return new ConvertPropertyBindingResult([],outputExpr);return stmts.push(currValExpr.set(outputExpr).toDeclStmt(DYNAMIC_TYPE,[StmtModifier.Final])),new ConvertPropertyBindingResult(stmts,currValExpr)}function convertBuiltins(converterFactory,ast){var visitor=new _BuiltinAstConverter(converterFactory);return ast.visit(visitor)}function temporaryName(bindingId,temporaryNumber){return"tmp_"+bindingId+"_"+temporaryNumber}function temporaryDeclaration(bindingId,temporaryNumber){return new DeclareVarStmt(temporaryName(bindingId,temporaryNumber),NULL_EXPR)}function prependTemporaryDecls(temporaryCount,bindingId,statements){for(var i=temporaryCount-1;i>=0;i--)statements.unshift(temporaryDeclaration(bindingId,i))}function ensureStatementMode(mode,ast){if(mode!==_Mode.Statement)throw new Error("Expected a statement, but saw "+ast)}function ensureExpressionMode(mode,ast){if(mode!==_Mode.Expression)throw new Error("Expected an expression, but saw "+ast)}function convertToStatementIfNeeded(mode,expr){return mode===_Mode.Statement?expr.toStmt():expr}function flattenStatements(arg,output){Array.isArray(arg)?arg.forEach(function(entry){return flattenStatements(entry,output)}):output.push(arg)}function createCurrValueExpr(bindingId){return variable("currVal_"+bindingId)}function createPreventDefaultVar(bindingId){return variable("pd_"+bindingId)}function convertStmtIntoExpression(stmt){return stmt instanceof ExpressionStatement?stmt.expr:stmt instanceof ReturnStatement?stmt.value:null}function needsAdditionalRootNode(astNodes){var lastAstNode=astNodes[astNodes.length-1];return lastAstNode instanceof EmbeddedTemplateAst?lastAstNode.hasViewContainer:lastAstNode instanceof ElementAst?isNgContainer(lastAstNode.name)&&lastAstNode.children.length?needsAdditionalRootNode(lastAstNode.children):lastAstNode.hasViewContainer:lastAstNode instanceof NgContentAst}function elementBindingDef(inputAst,dirAst){switch(inputAst.type){case PropertyBindingType.Attribute:return literalArr([literal(1),literal(inputAst.name),literal(inputAst.securityContext)]);case PropertyBindingType.Property:return literalArr([literal(8),literal(inputAst.name),literal(inputAst.securityContext)]);case PropertyBindingType.Animation:return literalArr([literal(8|(dirAst&&dirAst.directive.isComponent?32:16)),literal("@"+inputAst.name),literal(inputAst.securityContext)]);case PropertyBindingType.Class:return literalArr([literal(2),literal(inputAst.name),NULL_EXPR]);case PropertyBindingType.Style:return literalArr([literal(4),literal(inputAst.name),literal(inputAst.unit)])}}function fixedAttrsDef(elementAst){var mapResult=Object.create(null);return elementAst.attrs.forEach(function(attrAst){mapResult[attrAst.name]=attrAst.value}),elementAst.directives.forEach(function(dirAst){Object.keys(dirAst.directive.hostAttributes).forEach(function(name){var value=dirAst.directive.hostAttributes[name],prevValue=mapResult[name];mapResult[name]=null!=prevValue?mergeAttributeValue(name,prevValue,value):value})}),literalArr(Object.keys(mapResult).sort().map(function(attrName){return literalArr([literal(attrName),literal(mapResult[attrName])])}))}function mergeAttributeValue(attrName,attrValue1,attrValue2){return attrName==CLASS_ATTR$1||attrName==STYLE_ATTR?attrValue1+" "+attrValue2:attrValue2}function callCheckStmt(nodeIndex,exprs){return exprs.length>10?CHECK_VAR.callFn([VIEW_VAR,literal(nodeIndex),literal(1),literalArr(exprs)]):CHECK_VAR.callFn([VIEW_VAR,literal(nodeIndex),literal(0)].concat(exprs))}function callUnwrapValue(nodeIndex,bindingIdx,expr){return importExpr(Identifiers.unwrapValue).callFn([VIEW_VAR,literal(nodeIndex),literal(bindingIdx),expr])}function findStaticQueryIds(nodes,result){return void 0===result&&(result=new Map),nodes.forEach(function(node){var staticQueryIds=new Set,dynamicQueryIds=new Set,queryMatches=void 0;node instanceof ElementAst?(findStaticQueryIds(node.children,result),node.children.forEach(function(child){var childData=result.get(child);childData.staticQueryIds.forEach(function(queryId){return staticQueryIds.add(queryId)}),childData.dynamicQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)})}),queryMatches=node.queryMatches):node instanceof EmbeddedTemplateAst&&(findStaticQueryIds(node.children,result),node.children.forEach(function(child){var childData=result.get(child);childData.staticQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)}),childData.dynamicQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)})}),queryMatches=node.queryMatches),queryMatches&&queryMatches.forEach(function(match){return staticQueryIds.add(match.queryId)}),dynamicQueryIds.forEach(function(queryId){return staticQueryIds.delete(queryId)}),result.set(node,{staticQueryIds:staticQueryIds,dynamicQueryIds:dynamicQueryIds})}),result}function staticViewQueryIds(nodeStaticQueryIds){var staticQueryIds=new Set,dynamicQueryIds=new Set;return Array.from(nodeStaticQueryIds.values()).forEach(function(entry){entry.staticQueryIds.forEach(function(queryId){return staticQueryIds.add(queryId)}),entry.dynamicQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)})}),dynamicQueryIds.forEach(function(queryId){return staticQueryIds.delete(queryId)}),{staticQueryIds:staticQueryIds,dynamicQueryIds:dynamicQueryIds}}function elementEventNameAndTarget(eventAst,dirAst){return eventAst.isAnimation?{name:"@"+eventAst.name+"."+eventAst.phase,target:dirAst&&dirAst.directive.isComponent?"component":null}:eventAst}function calcStaticDynamicQueryFlags(queryIds,queryId,isFirst){var flags=0;return!isFirst||!queryIds.staticQueryIds.has(queryId)&&queryIds.dynamicQueryIds.has(queryId)?flags|=536870912:flags|=268435456,flags}function elementEventFullName(target,name){return target?target+":"+name:name}function toTypeScript(file,preamble){if(void 0===preamble&&(preamble=""),!file.stmts)throw new Error("Illegal state: No stmts present on GeneratedFile "+file.genFileUrl);return(new TypeScriptEmitter).emitStatements(file.genFileUrl,file.stmts,preamble)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function listLazyRoutes(moduleMeta,reflector){for(var allLazyRoutes=[],_i=0,_a=moduleMeta.transitiveModule.providers;_i<_a.length;_i++){var _b=_a[_i],provider=_b.provider,module=_b.module;if(tokenReference(provider.token)===reflector.ROUTES)for(var loadChildren=_collectLoadChildren(provider.useValue),_c=0,loadChildren_1=loadChildren;_c<loadChildren_1.length;_c++){var route=loadChildren_1[_c];allLazyRoutes.push(parseLazyRoute(route,reflector,module.reference))}}return allLazyRoutes}function _collectLoadChildren(routes,target){if(void 0===target&&(target=[]),"string"==typeof routes)target.push(routes);else if(Array.isArray(routes))for(var _i=0,routes_1=routes;_i<routes_1.length;_i++){var route=routes_1[_i];_collectLoadChildren(route,target)}else routes.loadChildren?_collectLoadChildren(routes.loadChildren,target):routes.children&&_collectLoadChildren(routes.children,target);return target}function parseLazyRoute(route,reflector,module){var _a=route.split("#"),routePath=_a[0],routeName=_a[1],referencedModule=reflector.resolveExternalReference({moduleName:routePath,name:routeName},module?module.filePath:void 0);return{route:route,module:module||referencedModule,referencedModule:referencedModule}}function unescapeIdentifier(identifier){return identifier.startsWith("___")?identifier.substr(1):identifier}function unwrapResolvedMetadata(metadata){return metadata&&"resolved"===metadata.__symbolic?metadata.symbol:metadata}function serializeSummaries(srcFileName,forJitCtx,summaryResolver,symbolResolver,symbols,types){var toJsonSerializer=new ToJsonSerializer(symbolResolver,summaryResolver,srcFileName);symbols.forEach(function(resolvedSymbol){return toJsonSerializer.addSummary({symbol:resolvedSymbol.symbol,metadata:resolvedSymbol.metadata})}),types.forEach(function(_a){var summary=_a.summary;_a.metadata;toJsonSerializer.addSummary({symbol:summary.type.reference,metadata:void 0,type:summary})});var _a=toJsonSerializer.serialize(),json=_a.json,exportAs=_a.exportAs;if(forJitCtx){var forJitSerializer_1=new ForJitSerializer(forJitCtx,symbolResolver,summaryResolver);types.forEach(function(_a){var summary=_a.summary,metadata=_a.metadata;forJitSerializer_1.addSourceType(summary,metadata)}),toJsonSerializer.unprocessedSymbolSummariesBySymbol.forEach(function(summary){summaryResolver.isLibraryFile(summary.symbol.filePath)&&summary.type&&forJitSerializer_1.addLibType(summary.type)}),forJitSerializer_1.serialize(exportAs)}return{json:json,exportAs:exportAs}}function deserializeSummaries(symbolCache,summaryResolver,libraryFileName,json){return new FromJsonDeserializer(symbolCache,summaryResolver).deserialize(libraryFileName,json)}function createForJitStub(outputCtx,reference){return createSummaryForJitFunction(outputCtx,reference,NULL_EXPR)}function createSummaryForJitFunction(outputCtx,reference,value){var fnName=summaryForJitName(reference.name);outputCtx.statements.push(fn([],[new ReturnStatement(value)],new ArrayType(DYNAMIC_TYPE)).toDeclStmt(fnName,[StmtModifier.Final,StmtModifier.Exported]))}function isCall(metadata){return metadata&&"call"===metadata.__symbolic}function isFunctionCall(metadata){return isCall(metadata)&&unwrapResolvedMetadata(metadata.expression)instanceof StaticSymbol}function isMethodCallOnVariable(metadata){return isCall(metadata)&&metadata.expression&&"select"===metadata.expression.__symbolic&&unwrapResolvedMetadata(metadata.expression.expression)instanceof StaticSymbol}function _createEmptyStub(outputCtx){outputCtx.statements.push(importExpr(Identifiers.ComponentFactory).toStmt())}function _resolveStyleStatements(symbolResolver,compileResult,needsShim,fileSuffix){compileResult.dependencies.forEach(function(dep){dep.setValue(symbolResolver.getStaticSymbol(_stylesModuleUrl(dep.moduleUrl,needsShim,fileSuffix),dep.name))})}function _stylesModuleUrl(stylesheetUrl,shim,suffix){return stylesheetUrl+(shim?".shim":"")+".ngstyle"+suffix}function analyzeNgModules(fileNames,host,staticSymbolResolver,metadataResolver){return mergeAnalyzedFiles(_analyzeFilesIncludingNonProgramFiles(fileNames,host,staticSymbolResolver,metadataResolver))}function analyzeAndValidateNgModules(fileNames,host,staticSymbolResolver,metadataResolver){return validateAnalyzedModules(analyzeNgModules(fileNames,host,staticSymbolResolver,metadataResolver))}function validateAnalyzedModules(analyzedModules){if(analyzedModules.symbolsMissingModule&&analyzedModules.symbolsMissingModule.length){throw syntaxError(analyzedModules.symbolsMissingModule.map(function(s){return"Cannot determine the module for class "+s.name+" in "+s.filePath+"! Add "+s.name+" to the NgModule to fix it."}).join("\n"))}return analyzedModules}function _analyzeFilesIncludingNonProgramFiles(fileNames,host,staticSymbolResolver,metadataResolver){var seenFiles=new Set,files=[],visitFile=function(fileName){if(seenFiles.has(fileName)||!host.isSourceFile(fileName))return!1;seenFiles.add(fileName);var analyzedFile=analyzeFile(host,staticSymbolResolver,metadataResolver,fileName);files.push(analyzedFile),analyzedFile.ngModules.forEach(function(ngModule){ngModule.transitiveModule.modules.forEach(function(modMeta){return visitFile(modMeta.reference.filePath)})})};return fileNames.forEach(function(fileName){return visitFile(fileName)}),files}function analyzeFile(host,staticSymbolResolver,metadataResolver,fileName){var directives=[],pipes=[],injectables=[],ngModules=[],hasDecorators=staticSymbolResolver.hasDecorators(fileName),exportsNonSourceFiles=!1;return fileName.endsWith(".d.ts")&&!hasDecorators||staticSymbolResolver.getSymbolsOf(fileName).forEach(function(symbol){var resolvedSymbol=staticSymbolResolver.resolveSymbol(symbol),symbolMeta=resolvedSymbol.metadata;if(symbolMeta&&"error"!==symbolMeta.__symbolic){var isNgSymbol=!1;if("class"===symbolMeta.__symbolic)if(metadataResolver.isDirective(symbol))isNgSymbol=!0,directives.push(symbol);else if(metadataResolver.isPipe(symbol))isNgSymbol=!0,pipes.push(symbol);else if(metadataResolver.isNgModule(symbol)){var ngModule=metadataResolver.getNgModuleMetadata(symbol,!1);ngModule&&(isNgSymbol=!0,ngModules.push(ngModule))}else metadataResolver.isInjectable(symbol)&&(isNgSymbol=!0,injectables.push(symbol));isNgSymbol||(exportsNonSourceFiles=exportsNonSourceFiles||isValueExportingNonSourceFile(host,symbolMeta))}}),{fileName:fileName,directives:directives,pipes:pipes,ngModules:ngModules,injectables:injectables,exportsNonSourceFiles:exportsNonSourceFiles}}function isValueExportingNonSourceFile(host,metadata){var exportsNonSourceFiles=!1;return visitValue(metadata,new(function(){function Visitor(){}return Visitor.prototype.visitArray=function(arr,context){var _this=this;arr.forEach(function(v){return visitValue(v,_this,context)})},Visitor.prototype.visitStringMap=function(map,context){var _this=this;Object.keys(map).forEach(function(key){return visitValue(map[key],_this,context)})},Visitor.prototype.visitPrimitive=function(value,context){},Visitor.prototype.visitOther=function(value,context){value instanceof StaticSymbol&&!host.isSourceFile(value.filePath)&&(exportsNonSourceFiles=!0)},Visitor}()),null),exportsNonSourceFiles}function mergeAnalyzedFiles(analyzedFiles){var allNgModules=[],ngModuleByPipeOrDirective=new Map,allPipesAndDirectives=new Set;analyzedFiles.forEach(function(af){af.ngModules.forEach(function(ngModule){allNgModules.push(ngModule),ngModule.declaredDirectives.forEach(function(d){return ngModuleByPipeOrDirective.set(d.reference,ngModule)}),ngModule.declaredPipes.forEach(function(p){return ngModuleByPipeOrDirective.set(p.reference,ngModule)})}),af.directives.forEach(function(d){return allPipesAndDirectives.add(d)}),af.pipes.forEach(function(p){return allPipesAndDirectives.add(p)})});var symbolsMissingModule=[];return allPipesAndDirectives.forEach(function(ref){ngModuleByPipeOrDirective.has(ref)||symbolsMissingModule.push(ref)}),{ngModules:allNgModules,ngModuleByPipeOrDirective:ngModuleByPipeOrDirective,symbolsMissingModule:symbolsMissingModule,files:analyzedFiles}}function mergeAndValidateNgFiles(files){return validateAnalyzedModules(mergeAnalyzedFiles(files))}function indentStr(level){if(level<=0)return"";if(level<6)return[""," ","  ","   ","    ","     "][level];var half=indentStr(Math.floor(level/2));return half+half+(level%2==1?" ":"")}function formatChain(chain,indent){if(void 0===indent&&(indent=0),!chain)return"";var position=chain.position?chain.position.fileName+"("+(chain.position.line+1)+","+(chain.position.column+1)+")":"",prefix=position&&0===indent?position+": ":"",postfix=position&&0!==indent?" at "+position:"",message=""+prefix+chain.message+postfix;return""+indentStr(indent)+message+(chain.next&&"\n"+formatChain(chain.next,indent+2)||"")}function formattedError(chain){var message=formatChain(chain)+".",error=syntaxError(message);return error[FORMATTED_MESSAGE]=!0,error.chain=chain,error.position=chain.position,error}function isFormattedError(error){return!!error[FORMATTED_MESSAGE]}function shouldIgnore(value){return value&&"ignore"==value.__symbolic}function metadataError(message,summary,advise,position,symbol,context,chain){var error=syntaxError(message);return error[METADATA_ERROR]=!0,advise&&(error.advise=advise),position&&(error.position=position),summary&&(error.summary=summary),context&&(error.context=context),chain&&(error.chain=chain),symbol&&(error.symbol=symbol),error}function isMetadataError(error){return!!error[METADATA_ERROR]}function expandedMessage(message,context){switch(message){case REFERENCE_TO_NONEXPORTED_CLASS:if(context&&context.className)return"References to a non-exported class are not supported in decorators but "+context.className+" was referenced.";break;case VARIABLE_NOT_INITIALIZED:return"Only initialized variables and constants can be referenced in decorators because the value of this variable is needed by the template compiler";case DESTRUCTURE_NOT_SUPPORTED:return"Referencing an exported destructured variable or constant is not supported in decorators and this value is needed by the template compiler";case COULD_NOT_RESOLVE_TYPE:if(context&&context.typeName)return"Could not resolve type "+context.typeName;break;case FUNCTION_CALL_NOT_SUPPORTED:return context&&context.name?"Function calls are not supported in decorators but '"+context.name+"' was called":"Function calls are not supported in decorators";case REFERENCE_TO_LOCAL_SYMBOL:if(context&&context.name)return"Reference to a local (non-exported) symbols are not supported in decorators but '"+context.name+"' was referenced";break;case LAMBDA_NOT_SUPPORTED:return"Function expressions are not supported in decorators"}return message}function messageAdvise(message,context){switch(message){case REFERENCE_TO_NONEXPORTED_CLASS:if(context&&context.className)return"Consider exporting '"+context.className+"'";break;case DESTRUCTURE_NOT_SUPPORTED:return"Consider simplifying to avoid destructuring";case REFERENCE_TO_LOCAL_SYMBOL:if(context&&context.name)return"Consider exporting '"+context.name+"'";break;case LAMBDA_NOT_SUPPORTED:return"Consider changing the function expression into an exported function"}}function errorSummary(error){if(error.summary)return error.summary;switch(error.message){case REFERENCE_TO_NONEXPORTED_CLASS:if(error.context&&error.context.className)return"references non-exported class "+error.context.className;break;case VARIABLE_NOT_INITIALIZED:return"is not initialized";case DESTRUCTURE_NOT_SUPPORTED:return"is a destructured variable";case COULD_NOT_RESOLVE_TYPE:return"could not be resolved";case FUNCTION_CALL_NOT_SUPPORTED:return error.context&&error.context.name?"calls '"+error.context.name+"'":"calls a function";case REFERENCE_TO_LOCAL_SYMBOL:return error.context&&error.context.name?"references local variable "+error.context.name:"references a local variable"}return"contains the error"}function mapStringMap(input,transform){if(!input)return{};var result={};return Object.keys(input).forEach(function(key){var value=transform(input[key],key);shouldIgnore(value)||(HIDDEN_KEY.test(key)?Object.defineProperty(result,key,{enumerable:!1,configurable:!0,value:value}):result[key]=value)}),result}function isPrimitive(o){return null===o||"function"!=typeof o&&"object"!=typeof o}function formatMetadataMessageChain(chain,advise){return{message:expandedMessage(chain.message,chain.context)+(chain.symbol?" in '"+chain.symbol.name+"'":""),position:chain.position,next:chain.next?formatMetadataMessageChain(chain.next,advise):advise?{message:advise}:void 0}}function formatMetadataError(e,context){if(isMetadataError(e)){var position=e.position;return formattedError(formatMetadataMessageChain({message:"Error during template compile of '"+context.name+"'",position:position,next:{message:e.message,next:e.chain,context:e.context,symbol:e.symbol}},e.advise||messageAdvise(e.message,e.context)))}return e}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createAotUrlResolver(host){return{resolve:function(basePath,url){var filePath=host.resourceNameToFileName(url,basePath);if(!filePath)throw syntaxError("Couldn't resolve resource "+url+" from "+basePath);return filePath}}}function createAotCompiler(compilerHost,options,errorCollector){var translations=options.translations||"",urlResolver=createAotUrlResolver(compilerHost),symbolCache=new StaticSymbolCache,summaryResolver=new AotSummaryResolver(compilerHost,symbolCache),symbolResolver=new StaticSymbolResolver(compilerHost,symbolCache,summaryResolver),staticReflector=new StaticReflector(summaryResolver,symbolResolver,[],[],errorCollector),htmlParser=new I18NHtmlParser(new HtmlParser,translations,options.i18nFormat,options.missingTranslation,console),config=new CompilerConfig({defaultEncapsulation:ViewEncapsulation.Emulated,useJit:!1,enableLegacyTemplate:!0===options.enableLegacyTemplate,missingTranslation:options.missingTranslation,preserveWhitespaces:options.preserveWhitespaces,strictInjectionParameters:options.strictInjectionParameters}),normalizer=new DirectiveNormalizer({get:function(url){return compilerHost.loadResource(url)}},urlResolver,htmlParser,config),expressionParser=new Parser(new Lexer),elementSchemaRegistry=new DomElementSchemaRegistry,tmplParser=new TemplateParser(config,staticReflector,expressionParser,elementSchemaRegistry,htmlParser,console,[]),resolver=new CompileMetadataResolver(config,htmlParser,new NgModuleResolver(staticReflector),new DirectiveResolver(staticReflector),new PipeResolver(staticReflector),summaryResolver,elementSchemaRegistry,normalizer,console,symbolCache,staticReflector,errorCollector),viewCompiler=new ViewCompiler(staticReflector),typeCheckCompiler=new TypeCheckCompiler(options,staticReflector);return{compiler:new AotCompiler(config,options,compilerHost,staticReflector,resolver,tmplParser,new StyleCompiler(urlResolver),viewCompiler,typeCheckCompiler,new NgModuleCompiler(staticReflector),new TypeScriptEmitter,summaryResolver,symbolResolver),reflector:staticReflector}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function interpretStatements(statements,reflector){var ctx=new _ExecutionContext(null,null,null,new Map);new StatementInterpreter(reflector).visitAllStatements(statements,ctx);var result={};return ctx.exports.forEach(function(exportName){result[exportName]=ctx.vars.get(exportName)}),result}function _executeFunctionStatements(varNames,varValues,statements,ctx,visitor){for(var childCtx=ctx.createChildWihtLocalVars(),i=0;i<varNames.length;i++)childCtx.vars.set(varNames[i],varValues[i]);var result=visitor.visitAllStatements(statements,childCtx);return result?result.value:null}function createDynamicClass(_classStmt,_ctx,_visitor){var propertyDescriptors={};_classStmt.getters.forEach(function(getter){propertyDescriptors[getter.name]={configurable:!1,get:function(){var instanceCtx=new _ExecutionContext(_ctx,this,_classStmt.name,_ctx.vars);return _executeFunctionStatements([],[],getter.body,instanceCtx,_visitor)}}}),_classStmt.methods.forEach(function(method){var paramNames=method.params.map(function(param){return param.name});propertyDescriptors[method.name]={writable:!1,configurable:!1,value:function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];var instanceCtx=new _ExecutionContext(_ctx,this,_classStmt.name,_ctx.vars);return _executeFunctionStatements(paramNames,args,method.body,instanceCtx,_visitor)}}});var ctorParamNames=_classStmt.constructorMethod.params.map(function(param){return param.name}),ctor=function(){for(var _this=this,args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];var instanceCtx=new _ExecutionContext(_ctx,this,_classStmt.name,_ctx.vars);_classStmt.fields.forEach(function(field){_this[field.name]=void 0}),_executeFunctionStatements(ctorParamNames,args,_classStmt.constructorMethod.body,instanceCtx,_visitor)},superClass=_classStmt.parent?_classStmt.parent.visitExpression(_visitor,_ctx):Object;return ctor.prototype=Object.create(superClass.prototype,propertyDescriptors),ctor}function _declareFn(varNames,statements,ctx,visitor){return function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];return _executeFunctionStatements(varNames,args,statements,ctx,visitor)}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function evalExpression(sourceUrl,ctx,vars,createSourceMap){var fnBody=ctx.toSource()+"\n//# sourceURL="+sourceUrl,fnArgNames=[],fnArgValues=[];for(var argName in vars)fnArgNames.push(argName),fnArgValues.push(vars[argName]);if(createSourceMap){var emptyFn=(new(Function.bind.apply(Function,[void 0].concat(fnArgNames.concat("return null;"))))).toString(),headerLines=emptyFn.slice(0,emptyFn.indexOf("return null;")).split("\n").length-1;fnBody+="\n"+ctx.toSourceMapGenerator(sourceUrl,headerLines).toJsComment()}return(new(Function.bind.apply(Function,[void 0].concat(fnArgNames.concat(fnBody))))).apply(void 0,fnArgValues)}function jitStatements(sourceUrl,statements,reflector,createSourceMaps){var converter=new JitEmitterVisitor(reflector),ctx=EmitterVisitorContext.createRoot();return converter.visitAllStatements(statements,ctx),converter.createReturnStmt(ctx),evalExpression(sourceUrl,ctx,converter.getArgs(),createSourceMaps)}function assertComponent(meta){if(!meta.isComponent)throw new Error("Could not compile '"+identifierName(meta.type)+"' because it is not a component.")}function createOutputContext(){return{statements:[],genFilePath:"",importExpr:function(symbol){return importExpr({name:identifierName(symbol),moduleName:null,runtime:symbol})}}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createUrlResolverWithoutPackagePrefix(){return new UrlResolver}function createOfflineCompileUrlResolver(){return new UrlResolver(".")}function getUrlScheme(url){var match=_split(url);return match&&match[_ComponentIndex.Scheme]||""}function _buildFromEncodedParts(opt_scheme,opt_userInfo,opt_domain,opt_port,opt_path,opt_queryData,opt_fragment){var out=[];return null!=opt_scheme&&out.push(opt_scheme+":"),null!=opt_domain&&(out.push("//"),null!=opt_userInfo&&out.push(opt_userInfo+"@"),out.push(opt_domain),null!=opt_port&&out.push(":"+opt_port)),null!=opt_path&&out.push(opt_path),null!=opt_queryData&&out.push("?"+opt_queryData),null!=opt_fragment&&out.push("#"+opt_fragment),out.join("")}function _split(uri){return uri.match(_splitRe)}function _removeDotSegments(path$$1){if("/"==path$$1)return"/";for(var leadingSlash="/"==path$$1[0]?"/":"",trailingSlash="/"===path$$1[path$$1.length-1]?"/":"",segments=path$$1.split("/"),out=[],up=0,pos=0;pos<segments.length;pos++){var segment=segments[pos];switch(segment){case"":case".":break;case"..":out.length>0?out.pop():up++;break;default:out.push(segment)}}if(""==leadingSlash){for(;up-- >0;)out.unshift("..");0===out.length&&out.push(".")}return leadingSlash+out.join("/")+trailingSlash}function _joinAndCanonicalizePath(parts){var path$$1=parts[_ComponentIndex.Path];return path$$1=null==path$$1?"":_removeDotSegments(path$$1),parts[_ComponentIndex.Path]=path$$1,_buildFromEncodedParts(parts[_ComponentIndex.Scheme],parts[_ComponentIndex.UserInfo],parts[_ComponentIndex.Domain],parts[_ComponentIndex.Port],path$$1,parts[_ComponentIndex.QueryData],parts[_ComponentIndex.Fragment])}function _resolveUrl(base,url){var parts=_split(encodeURI(url)),baseParts=_split(base);if(null!=parts[_ComponentIndex.Scheme])return _joinAndCanonicalizePath(parts);parts[_ComponentIndex.Scheme]=baseParts[_ComponentIndex.Scheme];for(var i=_ComponentIndex.Scheme;i<=_ComponentIndex.Port;i++)null==parts[i]&&(parts[i]=baseParts[i]);if("/"==parts[_ComponentIndex.Path][0])return _joinAndCanonicalizePath(parts);var path$$1=baseParts[_ComponentIndex.Path];null==path$$1&&(path$$1="/");var index=path$$1.lastIndexOf("/");return path$$1=path$$1.substring(0,index+1)+parts[_ComponentIndex.Path],parts[_ComponentIndex.Path]=path$$1,_joinAndCanonicalizePath(parts)}function createCommonjsModule(fn,module){return module={exports:{}},fn(module,module.exports),module.exports}function isFunction(x){return"function"==typeof x}function isObject(x){return null!=x&&"object"==typeof x}function tryCatcher(){try{return tryCatchTarget.apply(this,arguments)}catch(e){return errorObject.errorObject.e=e,errorObject.errorObject}}function tryCatch(fn){return tryCatchTarget=fn,tryCatcher}function flattenUnsubscriptionErrors(errors){return errors.reduce(function(errs,err){return errs.concat(err instanceof UnsubscriptionError_1.UnsubscriptionError?err.errors:err)},[])}function toSubscriber(nextOrObserver,error,complete){if(nextOrObserver){if(nextOrObserver instanceof Subscriber_1.Subscriber)return nextOrObserver;if(nextOrObserver[rxSubscriber.rxSubscriber])return nextOrObserver[rxSubscriber.rxSubscriber]()}return nextOrObserver||error||complete?new Subscriber_1.Subscriber(nextOrObserver,error,complete):new Subscriber_1.Subscriber(Observer.empty)}function noop$1$1(){}function pipe(){for(var fns=[],_i=0;_i<arguments.length;_i++)fns[_i-0]=arguments[_i];return pipeFromArray(fns)}function pipeFromArray(fns){return fns?1===fns.length?fns[0]:function(input){return fns.reduce(function(prev,fn){return fn(prev)},input)}:noop_1.noop}function isScheduler(value){return value&&"function"==typeof value.schedule}function isPromise$2(value){return value&&"function"!=typeof value.subscribe&&"function"==typeof value.then}function subscribeToResult(outerSubscriber,result,outerValue,outerIndex){var destination=new InnerSubscriber_1.InnerSubscriber(outerSubscriber,outerValue,outerIndex);if(destination.closed)return null;if(result instanceof Observable_1.Observable)return result._isScalar?(destination.next(result.value),destination.complete(),null):(destination.syncErrorThrowable=!0,result.subscribe(destination));if(isArrayLike.isArrayLike(result)){for(var i=0,len=result.length;i<len&&!destination.closed;i++)destination.next(result[i]);destination.closed||destination.complete()}else{if(isPromise_1.isPromise(result))return result.then(function(value){destination.closed||(destination.next(value),destination.complete())},function(err){return destination.error(err)}).then(null,function(err){root.root.setTimeout(function(){throw err})}),destination;if(result&&"function"==typeof result[iterator.iterator])for(var iterator$$1=result[iterator.iterator]();;){var item=iterator$$1.next();if(item.done){destination.complete();break}if(destination.next(item.value),destination.closed)break}else if(result&&"function"==typeof result[observable.observable]){var obs=result[observable.observable]();if("function"==typeof obs.subscribe)return obs.subscribe(new InnerSubscriber_1.InnerSubscriber(outerSubscriber,outerValue,outerIndex));destination.error(new TypeError("Provided object does not correctly implement Symbol.observable"))}else{var value=isObject_1.isObject(result)?"an invalid object":"'"+result+"'",msg="You provided "+value+" where a stream was expected. You can provide an Observable, Promise, Array, or Iterable.";destination.error(new TypeError(msg))}}return null}function mergeMap(project,resultSelector,concurrent){return void 0===concurrent&&(concurrent=Number.POSITIVE_INFINITY),function(source){return"number"==typeof resultSelector&&(concurrent=resultSelector,resultSelector=null),source.lift(new MergeMapOperator(project,resultSelector,concurrent))}}function identity(x){return x}function mergeAll(concurrent){return void 0===concurrent&&(concurrent=Number.POSITIVE_INFINITY),mergeMap_1.mergeMap(identity_1.identity,null,concurrent)}function merge(){for(var observables=[],_i=0;_i<arguments.length;_i++)observables[_i-0]=arguments[_i];var concurrent=Number.POSITIVE_INFINITY,scheduler=null,last=observables[observables.length-1];return isScheduler_1.isScheduler(last)?(scheduler=observables.pop(),observables.length>1&&"number"==typeof observables[observables.length-1]&&(concurrent=observables.pop())):"number"==typeof last&&(concurrent=observables.pop()),null===scheduler&&1===observables.length&&observables[0]instanceof Observable_1.Observable?observables[0]:mergeAll_1.mergeAll(concurrent)(new ArrayObservable_1.ArrayObservable(observables,scheduler))}function refCount(){return function(source){return source.lift(new RefCountOperator$1(source))}}function multicast(subjectOrSubjectFactory,selector){return function(source){var subjectFactory;if(subjectFactory="function"==typeof subjectOrSubjectFactory?subjectOrSubjectFactory:function(){return subjectOrSubjectFactory},"function"==typeof selector)return source.lift(new MulticastOperator(subjectFactory,selector));var connectable=Object.create(source,ConnectableObservable_1.connectableObservableDescriptor);return connectable.source=source,connectable.subjectFactory=subjectFactory,connectable}}function shareSubjectFactory(){return new Subject_1.Subject}function share$1(){return function(source){return refCount_1.refCount()(multicast_1.multicast(shareSubjectFactory)(source))}}function share(){return share_1.share()(this)}function makeDecorator(name,props,parentClass,chainFn){function DecoratorFactory(objOrType){if(this instanceof DecoratorFactory)return metaCtor.call(this,objOrType),this;var annotationInstance=new DecoratorFactory(objOrType),TypeDecorator=function(cls){return(cls.hasOwnProperty(ANNOTATIONS)?cls[ANNOTATIONS]:Object.defineProperty(cls,ANNOTATIONS,{value:[]})[ANNOTATIONS]).push(annotationInstance),cls};return chainFn&&chainFn(TypeDecorator),TypeDecorator}var metaCtor=makeMetadataCtor(props);return parentClass&&(DecoratorFactory.prototype=Object.create(parentClass.prototype)),DecoratorFactory.prototype.ngMetadataName=name,DecoratorFactory.annotationCls=DecoratorFactory,DecoratorFactory}function makeMetadataCtor(props){return function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];if(props){var values=props.apply(void 0,args);for(var propName in values)this[propName]=values[propName]}}}function makeParamDecorator(name,props,parentClass){function ParamDecoratorFactory(){function ParamDecorator(cls,unusedKey,index){for(var parameters=cls.hasOwnProperty(PARAMETERS)?cls[PARAMETERS]:Object.defineProperty(cls,PARAMETERS,{value:[]})[PARAMETERS];parameters.length<=index;)parameters.push(null);return(parameters[index]=parameters[index]||[]).push(annotationInstance),cls}for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];if(this instanceof ParamDecoratorFactory)return metaCtor.apply(this,args),this;var annotationInstance=new((_a=ParamDecoratorFactory).bind.apply(_a,[void 0].concat(args)));return ParamDecorator.annotation=annotationInstance,ParamDecorator;var _a}var metaCtor=makeMetadataCtor(props);return parentClass&&(ParamDecoratorFactory.prototype=Object.create(parentClass.prototype)),ParamDecoratorFactory.prototype.ngMetadataName=name,ParamDecoratorFactory.annotationCls=ParamDecoratorFactory,ParamDecoratorFactory}function getSymbolIterator(){if(!_symbolIterator){var Symbol_1=_global.Symbol;if(Symbol_1&&Symbol_1.iterator)_symbolIterator=Symbol_1.iterator;else for(var keys=Object.getOwnPropertyNames(Map.prototype),i=0;i<keys.length;++i){var key=keys[i];"entries"!==key&&"size"!==key&&Map.prototype[key]===Map.prototype.entries&&(_symbolIterator=key)}}return _symbolIterator}function scheduleMicroTask(fn){"undefined"==typeof Zone?promise.then(function(){fn&&fn.apply(null,null)}):Zone.current.scheduleMicroTask("scheduleMicrotask",fn)}function looseIdentical(a,b){return a===b||"number"==typeof a&&"number"==typeof b&&isNaN(a)&&isNaN(b)}function stringify$1(token){if("string"==typeof token)return token;if(token instanceof Array)return"["+token.map(stringify$1).join(", ")+"]";if(null==token)return""+token;if(token.overriddenName)return""+token.overriddenName;if(token.name)return""+token.name;var res=token.toString();if(null==res)return""+res;var newLineIndex=res.indexOf("\n");return-1===newLineIndex?res:res.substring(0,newLineIndex)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function forwardRef(forwardRefFn){return forwardRefFn.__forward_ref__=forwardRef,forwardRefFn.toString=function(){return stringify$1(this())},forwardRefFn}function resolveForwardRef$1(type){return"function"==typeof type&&type.hasOwnProperty("__forward_ref__")&&type.__forward_ref__===forwardRef?type():type}function resolveProvider(provider){var deps=computeDeps(provider),fn=IDENT,value=EMPTY,useNew=!1,provide=resolveForwardRef$1(provider.provide);if(USE_VALUE$1 in provider)value=provider.useValue;else if(provider.useFactory)fn=provider.useFactory;else if(provider.useExisting);else if(provider.useClass)useNew=!0,fn=resolveForwardRef$1(provider.useClass);else{if("function"!=typeof provide)throw staticError("StaticProvider does not have [useValue|useFactory|useExisting|useClass] or [provide] is not newable",provider);useNew=!0,fn=provide}return{deps:deps,fn:fn,useNew:useNew,value:value}}function multiProviderMixError(token){return staticError("Cannot mix multi providers and regular providers",token)}function recursivelyProcessProviders(records,provider){if(provider)if((provider=resolveForwardRef$1(provider))instanceof Array)for(var i=0;i<provider.length;i++)recursivelyProcessProviders(records,provider[i]);else{if("function"==typeof provider)throw staticError("Function/Class not supported",provider);if(!provider||"object"!=typeof provider||!provider.provide)throw staticError("Unexpected provider",provider);var token=resolveForwardRef$1(provider.provide),resolvedProvider=resolveProvider(provider);if(!0===provider.multi){var multiProvider=records.get(token);if(multiProvider){if(multiProvider.fn!==MULTI_PROVIDER_FN)throw multiProviderMixError(token)}else records.set(token,multiProvider={token:provider.provide,deps:[],useNew:!1,fn:MULTI_PROVIDER_FN,value:EMPTY});token=provider,multiProvider.deps.push({token:token,options:6})}var record=records.get(token);if(record&&record.fn==MULTI_PROVIDER_FN)throw multiProviderMixError(token);records.set(token,resolvedProvider)}}function tryResolveToken(token,record,records,parent,notFoundValue){try{return resolveToken(token,record,records,parent,notFoundValue)}catch(e){e instanceof Error||(e=new Error(e));var path$$1=e[NG_TEMP_TOKEN_PATH]=e[NG_TEMP_TOKEN_PATH]||[];throw path$$1.unshift(token),record&&record.value==CIRCULAR&&(record.value=EMPTY),e}}function resolveToken(token,record,records,parent,notFoundValue){var value;if(record){if((value=record.value)==CIRCULAR)throw Error(NO_NEW_LINE+"Circular dependency");if(value===EMPTY){record.value=CIRCULAR;var useNew=record.useNew,fn=record.fn,depRecords=record.deps,deps=EMPTY;if(depRecords.length){deps=[];for(var i=0;i<depRecords.length;i++){var depRecord=depRecords[i],options=depRecord.options,childRecord=2&options?records.get(depRecord.token):void 0;deps.push(tryResolveToken(depRecord.token,childRecord,records,childRecord||4&options?parent:NULL_INJECTOR,1&options?null:Injector.THROW_IF_NOT_FOUND))}}record.value=value=useNew?new((_a=fn).bind.apply(_a,[void 0].concat(deps))):fn.apply(void 0,deps)}}else value=parent.get(token,notFoundValue);return value;var _a}function computeDeps(provider){var deps=EMPTY,providerDeps=provider.deps;if(providerDeps&&providerDeps.length){deps=[];for(var i=0;i<providerDeps.length;i++){var options=6,token=resolveForwardRef$1(providerDeps[i]);if(token instanceof Array)for(var j=0,annotations=token;j<annotations.length;j++){var annotation=annotations[j];annotation instanceof Optional||annotation==Optional?options|=1:annotation instanceof SkipSelf||annotation==SkipSelf?options&=-3:annotation instanceof Self||annotation==Self?options&=-5:token=annotation instanceof Inject$1?annotation.token:resolveForwardRef$1(annotation)}deps.push({token:token,options:options})}}else if(provider.useExisting){var token=resolveForwardRef$1(provider.useExisting);deps=[{token:token,options:6}]}else if(!(providerDeps||USE_VALUE$1 in provider))throw staticError("'deps' required",provider);return deps}function formatError(text,obj,source){void 0===source&&(source=null),text=text&&"\n"===text.charAt(0)&&text.charAt(1)==NO_NEW_LINE?text.substr(2):text;var context=stringify$1(obj);if(obj instanceof Array)context=obj.map(stringify$1).join(" -> ");else if("object"==typeof obj){var parts=[];for(var key in obj)if(obj.hasOwnProperty(key)){var value=obj[key];parts.push(key+":"+("string"==typeof value?JSON.stringify(value):stringify$1(value)))}context="{"+parts.join(", ")+"}"}return"StaticInjectorError"+(source?"("+source+")":"")+"["+context+"]: "+text.replace(NEW_LINE,"\n  ")}function staticError(text,obj){return new Error(formatError(text,obj))}function getDebugContext(error){return error[ERROR_DEBUG_CONTEXT]}function getOriginalError(error){return error[ERROR_ORIGINAL_ERROR]}function getErrorLogger(error){return error[ERROR_LOGGER]||defaultErrorLogger}function defaultErrorLogger(console){for(var values=[],_i=1;_i<arguments.length;_i++)values[_i-1]=arguments[_i];console.error.apply(console,values)}function wrappedError(message,originalError){var msg=message+" caused by: "+(originalError instanceof Error?originalError.message:originalError),error=Error(msg);return error[ERROR_ORIGINAL_ERROR]=originalError,error}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function findFirstClosedCycle(keys){for(var res=[],i=0;i<keys.length;++i){if(res.indexOf(keys[i])>-1)return res.push(keys[i]),res;res.push(keys[i])}return res}function constructResolvingPath(keys){if(keys.length>1){return" ("+findFirstClosedCycle(keys.slice().reverse()).map(function(k){return stringify$1(k.token)}).join(" -> ")+")"}return""}function injectionError(injector,key,constructResolvingMessage,originalError){var keys=[key],errMsg=constructResolvingMessage(keys),error=originalError?wrappedError(errMsg,originalError):Error(errMsg);return error.addKey=addKey,error.keys=keys,error.injectors=[injector],error.constructResolvingMessage=constructResolvingMessage,error[ERROR_ORIGINAL_ERROR]=originalError,error}function addKey(injector,key){this.injectors.push(injector),this.keys.push(key),this.message=this.constructResolvingMessage(this.keys)}function noProviderError(injector,key){return injectionError(injector,key,function(keys){return"No provider for "+stringify$1(keys[0].token)+"!"+constructResolvingPath(keys)})}function cyclicDependencyError(injector,key){return injectionError(injector,key,function(keys){return"Cannot instantiate cyclic dependency!"+constructResolvingPath(keys)})}function instantiationError(injector,originalException,originalStack,key){return injectionError(injector,key,function(keys){var first=stringify$1(keys[0].token);return originalException.message+": Error during instantiation of "+first+"!"+constructResolvingPath(keys)+"."},originalException)}function invalidProviderError(provider){return Error("Invalid provider - only instances of Provider and Type are allowed, got: "+provider)}function noAnnotationError(typeOrFunc,params){for(var signature=[],i=0,ii=params.length;i<ii;i++){var parameter=params[i];parameter&&0!=parameter.length?signature.push(parameter.map(stringify$1).join(" ")):signature.push("?")}return Error("Cannot resolve all parameters for '"+stringify$1(typeOrFunc)+"'("+signature.join(", ")+"). Make sure that all the parameters are decorated with Inject or have valid type annotations and that '"+stringify$1(typeOrFunc)+"' is decorated with Injectable.")}function outOfBoundsError(index){return Error("Index "+index+" is out-of-bounds.")}function mixingMultiProvidersWithRegularProvidersError(provider1,provider2){return Error("Cannot mix multi providers and regular providers, got: "+provider1+" "+provider2)}function isType(v){return"function"==typeof v}function convertTsickleDecoratorIntoMetadata(decoratorInvocations){return decoratorInvocations?decoratorInvocations.map(function(decoratorInvocation){var decoratorType=decoratorInvocation.type,annotationCls=decoratorType.annotationCls,annotationArgs=decoratorInvocation.args?decoratorInvocation.args:[];return new(annotationCls.bind.apply(annotationCls,[void 0].concat(annotationArgs)))}):[]}function getParentCtor(ctor){var parentProto=ctor.prototype?Object.getPrototypeOf(ctor.prototype):null;return(parentProto?parentProto.constructor:null)||Object}function resolveReflectiveFactory(provider){var factoryFn,resolvedDeps;if(provider.useClass){var useClass=resolveForwardRef$1(provider.useClass);factoryFn=reflector.factory(useClass),resolvedDeps=_dependenciesFor(useClass)}else provider.useExisting?(factoryFn=function(aliasInstance){return aliasInstance},resolvedDeps=[ReflectiveDependency.fromKey(ReflectiveKey.get(provider.useExisting))]):provider.useFactory?(factoryFn=provider.useFactory,resolvedDeps=constructDependencies(provider.useFactory,provider.deps)):(factoryFn=function(){return provider.useValue},resolvedDeps=_EMPTY_LIST);return new ResolvedReflectiveFactory(factoryFn,resolvedDeps)}function resolveReflectiveProvider(provider){return new ResolvedReflectiveProvider_(ReflectiveKey.get(provider.provide),[resolveReflectiveFactory(provider)],provider.multi||!1)}function resolveReflectiveProviders(providers){var normalized=_normalizeProviders(providers,[]),resolved=normalized.map(resolveReflectiveProvider),resolvedProviderMap=mergeResolvedReflectiveProviders(resolved,new Map);return Array.from(resolvedProviderMap.values())}function mergeResolvedReflectiveProviders(providers,normalizedProvidersMap){for(var i=0;i<providers.length;i++){var provider=providers[i],existing=normalizedProvidersMap.get(provider.key.id);if(existing){if(provider.multiProvider!==existing.multiProvider)throw mixingMultiProvidersWithRegularProvidersError(existing,provider);if(provider.multiProvider)for(var j=0;j<provider.resolvedFactories.length;j++)existing.resolvedFactories.push(provider.resolvedFactories[j]);else normalizedProvidersMap.set(provider.key.id,provider)}else{var resolvedProvider=void 0;resolvedProvider=provider.multiProvider?new ResolvedReflectiveProvider_(provider.key,provider.resolvedFactories.slice(),provider.multiProvider):provider,normalizedProvidersMap.set(provider.key.id,resolvedProvider)}}return normalizedProvidersMap}function _normalizeProviders(providers,res){return providers.forEach(function(b){if(b instanceof Type$1$1)res.push({provide:b,useClass:b});else if(b&&"object"==typeof b&&void 0!==b.provide)res.push(b);else{if(!(b instanceof Array))throw invalidProviderError(b);_normalizeProviders(b,res)}}),res}function constructDependencies(typeOrFunc,dependencies){if(dependencies){var params_1=dependencies.map(function(t){return[t]});return dependencies.map(function(t){return _extractToken(typeOrFunc,t,params_1)})}return _dependenciesFor(typeOrFunc)}function _dependenciesFor(typeOrFunc){var params=reflector.parameters(typeOrFunc);if(!params)return[];if(params.some(function(p){return null==p}))throw noAnnotationError(typeOrFunc,params);return params.map(function(p){return _extractToken(typeOrFunc,p,params)})}function _extractToken(typeOrFunc,metadata,params){var token=null,optional=!1;if(!Array.isArray(metadata))return metadata instanceof Inject$1?_createDependency(metadata.token,optional,null):_createDependency(metadata,optional,null);for(var visibility=null,i=0;i<metadata.length;++i){var paramMetadata=metadata[i];paramMetadata instanceof Type$1$1?token=paramMetadata:paramMetadata instanceof Inject$1?token=paramMetadata.token:paramMetadata instanceof Optional?optional=!0:paramMetadata instanceof Self||paramMetadata instanceof SkipSelf?visibility=paramMetadata:paramMetadata instanceof InjectionToken&&(token=paramMetadata)}if(null!=(token=resolveForwardRef$1(token)))return _createDependency(token,optional,visibility);throw noAnnotationError(typeOrFunc,params)}function _createDependency(token,optional,visibility){return new ReflectiveDependency(ReflectiveKey.get(token),optional,visibility)}function _mapProviders(injector,fn){for(var res=new Array(injector._providers.length),i=0;i<injector._providers.length;++i)res[i]=fn(injector.getProviderAtIndex(i));return res}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function isPromise$1(obj){return!!obj&&"function"==typeof obj.then}function _appIdRandomProviderFactory(){return""+_randomChar()+_randomChar()+_randomChar()}function _randomChar(){return String.fromCharCode(97+Math.floor(25*Math.random()))}function _throwError(){throw new Error("Runtime compiler is not loaded")}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function noComponentFactoryError(component){var error=Error("No component factory found for "+stringify$1(component)+". Did you add it to @NgModule.entryComponents?");return error[ERROR_COMPONENT]=component,error}function createScope(signature,flags){return void 0===flags&&(flags=null),events.createScope(signature,flags)}function leave(scope,returnValue){return trace.leaveScope(scope,returnValue),returnValue}function noopScope(arg0,arg1){return null}function noop(){}function checkStable(zone){if(0==zone._nesting&&!zone.hasPendingMicrotasks&&!zone.isStable)try{zone._nesting++,zone.onMicrotaskEmpty.emit(null)}finally{if(zone._nesting--,!zone.hasPendingMicrotasks)try{zone.runOutsideAngular(function(){return zone.onStable.emit(null)})}finally{zone.isStable=!0}}}function forkInnerZoneWithAngularBehavior(zone){zone._inner=zone._inner.fork({name:"angular",properties:{isAngularZone:!0},onInvokeTask:function(delegate,current,target,task,applyThis,applyArgs){try{return onEnter(zone),delegate.invokeTask(target,task,applyThis,applyArgs)}finally{onLeave(zone)}},onInvoke:function(delegate,current,target,callback,applyThis,applyArgs,source){try{return onEnter(zone),delegate.invoke(target,callback,applyThis,applyArgs,source)}finally{onLeave(zone)}},onHasTask:function(delegate,current,target,hasTaskState){delegate.hasTask(target,hasTaskState),current===target&&("microTask"==hasTaskState.change?(zone.hasPendingMicrotasks=hasTaskState.microTask,checkStable(zone)):"macroTask"==hasTaskState.change&&(zone.hasPendingMacrotasks=hasTaskState.macroTask))},onHandleError:function(delegate,current,target,error){return delegate.handleError(target,error),zone.runOutsideAngular(function(){return zone.onError.emit(error)}),!1}})}function onEnter(zone){zone._nesting++,zone.isStable&&(zone.isStable=!1,zone.onUnstable.emit(null))}function onLeave(zone){zone._nesting--,checkStable(zone)}function isDevMode(){return _runModeLocked=!0,_devMode}function createPlatform(injector){if(_platform&&!_platform.destroyed&&!_platform.injector.get(ALLOW_MULTIPLE_PLATFORMS,!1))throw new Error("There can be only one platform. Destroy the previous one to create a new one.");_platform=injector.get(PlatformRef);var inits=injector.get(PLATFORM_INITIALIZER,null);return inits&&inits.forEach(function(init){return init()}),_platform}function assertPlatform(requiredToken){var platform=getPlatform();if(!platform)throw new Error("No platform exists!");if(!platform.injector.get(requiredToken,null))throw new Error("A platform with a different configuration has been created. Please destroy it first.");return platform}function getPlatform(){return _platform&&!_platform.destroyed?_platform:null}function getNgZone(ngZoneOption){return"noop"===ngZoneOption?new NoopNgZone:("zone.js"===ngZoneOption?void 0:ngZoneOption)||new NgZone({enableLongStackTrace:isDevMode()})}function _callAndReportToErrorHandler(errorHandler,ngZone,callback){try{var result=callback();return isPromise$1(result)?result.catch(function(e){throw ngZone.runOutsideAngular(function(){return errorHandler.handleError(e)}),e}):result}catch(e){throw ngZone.runOutsideAngular(function(){return errorHandler.handleError(e)}),e}}function optionsReducer(dst,objs){return dst=Array.isArray(objs)?objs.reduce(optionsReducer,dst):__assign({},dst,objs)}function remove(list,el){var index=list.indexOf(el);index>-1&&list.splice(index,1)}function flatten$2(list){return list.reduce(function(flat,item){var flatItem=Array.isArray(item)?flatten$2(item):item;return flat.concat(flatItem)},[])}function _queryElementChildren(element,predicate,matches){element.childNodes.forEach(function(node){node instanceof DebugElement&&(predicate(node)&&matches.push(node),_queryElementChildren(node,predicate,matches))})}function _queryNodeChildren(parentNode,predicate,matches){parentNode instanceof DebugElement&&parentNode.childNodes.forEach(function(node){predicate(node)&&matches.push(node),node instanceof DebugElement&&_queryNodeChildren(node,predicate,matches)})}function getDebugNode(nativeNode){return _nativeNodeToDebugNode.get(nativeNode)||null}function indexDebugNode(node){_nativeNodeToDebugNode.set(node.nativeNode,node)}function removeDebugNodeFromIndex(node){_nativeNodeToDebugNode.delete(node.nativeNode)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function devModeEqual(a,b){var isListLikeIterableA=isListLikeIterable(a),isListLikeIterableB=isListLikeIterable(b);if(isListLikeIterableA&&isListLikeIterableB)return areIterablesEqual(a,b,devModeEqual);var isAObject=a&&("object"==typeof a||"function"==typeof a),isBObject=b&&("object"==typeof b||"function"==typeof b);return!(isListLikeIterableA||!isAObject||isListLikeIterableB||!isBObject)||looseIdentical(a,b)}function isListLikeIterable(obj){return!!isJsObject(obj)&&(Array.isArray(obj)||!(obj instanceof Map)&&getSymbolIterator()in obj)}function areIterablesEqual(a,b,comparator){for(var iterator1=a[getSymbolIterator()](),iterator2=b[getSymbolIterator()]();;){var item1=iterator1.next(),item2=iterator2.next();if(item1.done&&item2.done)return!0;if(item1.done||item2.done)return!1;if(!comparator(item1.value,item2.value))return!1}}function iterateListLike(obj,fn){if(Array.isArray(obj))for(var i=0;i<obj.length;i++)fn(obj[i]);else for(var iterator=obj[getSymbolIterator()](),item=void 0;!(item=iterator.next()).done;)fn(item.value)}function isJsObject(o){return null!==o&&("function"==typeof o||"object"==typeof o)}function getPreviousIndex(item,addRemoveOffset,moveOffsets){var previousIndex=item.previousIndex;if(null===previousIndex)return previousIndex;var moveOffset=0;return moveOffsets&&previousIndex<moveOffsets.length&&(moveOffset=moveOffsets[previousIndex]),previousIndex+addRemoveOffset+moveOffset}function getTypeNameForDebugging(type){return type.name||typeof type}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function _iterableDiffersFactory(){return defaultIterableDiffers}function _keyValueDiffersFactory(){return defaultKeyValueDiffers}function _localeFactory(locale){return locale||"en-US"}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function shiftInitState(view,priorInitState,newInitState){var state=view.state,initState=1792&state;return initState===priorInitState?(view.state=-1793&state|newInitState,view.initIndex=-1,!0):initState===newInitState}function shouldCallLifecycleInitHook(view,initState,index){return(1792&view.state)===initState&&view.initIndex<=index&&(view.initIndex=index+1,!0)}function asTextData(view,index){return view.nodes[index]}function asElementData(view,index){return view.nodes[index]}function asProviderData(view,index){return view.nodes[index]}function asPureExpressionData(view,index){return view.nodes[index]}function asQueryList(view,index){return view.nodes[index]}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function expressionChangedAfterItHasBeenCheckedError(context,oldValue,currValue,isFirstCheck){var msg="ExpressionChangedAfterItHasBeenCheckedError: Expression has changed after it was checked. Previous value: '"+oldValue+"'. Current value: '"+currValue+"'.";return isFirstCheck&&(msg+=" It seems like the view has been created after its parent and its children have been dirty checked. Has it been created in a change detection hook ?"),viewDebugError(msg,context)}function viewWrappedDebugError(err,context){return err instanceof Error||(err=new Error(err.toString())),_addDebugContext(err,context),err}function viewDebugError(msg,context){var err=new Error(msg);return _addDebugContext(err,context),err}function _addDebugContext(err,context){err[ERROR_DEBUG_CONTEXT]=context,err[ERROR_LOGGER]=context.logError.bind(context)}function isViewDebugError(err){return!!getDebugContext(err)}function viewDestroyedError(action){return new Error("ViewDestroyedError: Attempt to use a destroyed view: "+action)}function tokenKey(token){var key=_tokenKeyCache.get(token);return key||(key=stringify$1(token)+"_"+_tokenKeyCache.size,_tokenKeyCache.set(token,key)),key}function checkBinding(view,def,bindingIdx,value){var oldValues=view.oldValues;return!(!(2&view.state)&&looseIdentical(oldValues[def.bindingIndex+bindingIdx],value))}function checkAndUpdateBinding(view,def,bindingIdx,value){return!!checkBinding(view,def,bindingIdx,value)&&(view.oldValues[def.bindingIndex+bindingIdx]=value,!0)}function checkBindingNoChanges(view,def,bindingIdx,value){var oldValue=view.oldValues[def.bindingIndex+bindingIdx];if(1&view.state||!devModeEqual(oldValue,value)){var bindingName=def.bindings[bindingIdx].name;throw expressionChangedAfterItHasBeenCheckedError(Services.createDebugContext(view,def.nodeIndex),bindingName+": "+oldValue,bindingName+": "+value,0!=(1&view.state))}}function markParentViewsForCheck(view){for(var currView=view;currView;)2&currView.def.flags&&(currView.state|=8),currView=currView.viewContainerParent||currView.parent}function markParentViewsForCheckProjectedViews(view,endView){for(var currView=view;currView&&currView!==endView;)currView.state|=64,currView=currView.viewContainerParent||currView.parent}function dispatchEvent(view,nodeIndex,eventName,event){try{return markParentViewsForCheck(33554432&view.def.nodes[nodeIndex].flags?asElementData(view,nodeIndex).componentView:view),Services.handleEvent(view,nodeIndex,eventName,event)}catch(e){view.root.errorHandler.handleError(e)}}function declaredViewContainer(view){if(view.parent){return asElementData(view.parent,view.parentNodeDef.nodeIndex)}return null}function viewParentEl(view){return view.parent?view.parentNodeDef.parent:null}function renderNode(view,def){switch(201347067&def.flags){case 1:return asElementData(view,def.nodeIndex).renderElement;case 2:return asTextData(view,def.nodeIndex).renderText}}function elementEventFullName$1(target,name){return target?target+":"+name:name}function isComponentView(view){return!!view.parent&&!!(32768&view.parentNodeDef.flags)}function isEmbeddedView(view){return!(!view.parent||32768&view.parentNodeDef.flags)}function splitDepsDsl(deps,sourceName){return deps.map(function(value){var token,flags;return Array.isArray(value)?(flags=value[0],token=value[1]):(flags=0,token=value),token&&("function"==typeof token||"object"==typeof token)&&sourceName&&Object.defineProperty(token,SOURCE,{value:sourceName,configurable:!0}),{flags:flags,token:token,tokenKey:tokenKey(token)}})}function getParentRenderElement(view,renderHost,def){var renderParent=def.renderParent;return renderParent?0==(1&renderParent.flags)||0==(33554432&renderParent.flags)||renderParent.element.componentRendererType&&renderParent.element.componentRendererType.encapsulation===ViewEncapsulation$1.Native?asElementData(view,def.renderParent.nodeIndex).renderElement:void 0:renderHost}function resolveDefinition(factory){var value=DEFINITION_CACHE.get(factory);return value||(value=factory(function(){return NOOP}),value.factory=factory,DEFINITION_CACHE.set(factory,value)),value}function rootRenderNodes(view){var renderNodes=[];return visitRootRenderNodes(view,0,void 0,void 0,renderNodes),renderNodes}function visitRootRenderNodes(view,action,parentNode,nextSibling,target){3===action&&(parentNode=view.renderer.parentNode(renderNode(view,view.def.lastRenderRootNode))),visitSiblingRenderNodes(view,action,0,view.def.nodes.length-1,parentNode,nextSibling,target)}function visitSiblingRenderNodes(view,action,startIndex,endIndex,parentNode,nextSibling,target){for(var i=startIndex;i<=endIndex;i++){var nodeDef=view.def.nodes[i];11&nodeDef.flags&&visitRenderNode(view,nodeDef,action,parentNode,nextSibling,target),i+=nodeDef.childCount}}function visitProjectedRenderNodes(view,ngContentIndex,action,parentNode,nextSibling,target){for(var compView=view;compView&&!isComponentView(compView);)compView=compView.parent;for(var hostView=compView.parent,hostElDef=viewParentEl(compView),startIndex=hostElDef.nodeIndex+1,endIndex=hostElDef.nodeIndex+hostElDef.childCount,i=startIndex;i<=endIndex;i++){var nodeDef=hostView.def.nodes[i];nodeDef.ngContentIndex===ngContentIndex&&visitRenderNode(hostView,nodeDef,action,parentNode,nextSibling,target),i+=nodeDef.childCount}if(!hostView.parent){var projectedNodes=view.root.projectableNodes[ngContentIndex];if(projectedNodes)for(var i=0;i<projectedNodes.length;i++)execRenderNodeAction(view,projectedNodes[i],action,parentNode,nextSibling,target)}}function visitRenderNode(view,nodeDef,action,parentNode,nextSibling,target){if(8&nodeDef.flags)visitProjectedRenderNodes(view,nodeDef.ngContent.index,action,parentNode,nextSibling,target);else{var rn=renderNode(view,nodeDef);if(3===action&&33554432&nodeDef.flags&&48&nodeDef.bindingFlags){if(16&nodeDef.bindingFlags&&execRenderNodeAction(view,rn,action,parentNode,nextSibling,target),32&nodeDef.bindingFlags){var compView=asElementData(view,nodeDef.nodeIndex).componentView;execRenderNodeAction(compView,rn,action,parentNode,nextSibling,target)}}else execRenderNodeAction(view,rn,action,parentNode,nextSibling,target);if(16777216&nodeDef.flags)for(var embeddedViews=asElementData(view,nodeDef.nodeIndex).viewContainer._embeddedViews,k=0;k<embeddedViews.length;k++)visitRootRenderNodes(embeddedViews[k],action,parentNode,nextSibling,target);1&nodeDef.flags&&!nodeDef.element.name&&visitSiblingRenderNodes(view,action,nodeDef.nodeIndex+1,nodeDef.nodeIndex+nodeDef.childCount,parentNode,nextSibling,target)}}function execRenderNodeAction(view,renderNode,action,parentNode,nextSibling,target){var renderer=view.renderer;switch(action){case 1:renderer.appendChild(parentNode,renderNode);break;case 2:renderer.insertBefore(parentNode,renderNode,nextSibling);break;case 3:renderer.removeChild(parentNode,renderNode);break;case 0:target.push(renderNode)}}function splitNamespace(name){if(":"===name[0]){var match=name.match(NS_PREFIX_RE);return[match[1],match[2]]}return["",name]}function createElement(view,renderHost,def){var el,elDef=def.element,rootSelectorOrNode=view.root.selectorOrNode,renderer=view.renderer;if(view.parent||!rootSelectorOrNode){el=elDef.name?renderer.createElement(elDef.name,elDef.ns):renderer.createComment("");var parentEl=getParentRenderElement(view,renderHost,def);parentEl&&renderer.appendChild(parentEl,el)}else el=renderer.selectRootElement(rootSelectorOrNode);if(elDef.attrs)for(var i=0;i<elDef.attrs.length;i++){var _a=elDef.attrs[i],ns=_a[0],name_2=_a[1],value=_a[2];renderer.setAttribute(el,name_2,value,ns)}return el}function listenToElementOutputs(view,compView,def,el){for(var i=0;i<def.outputs.length;i++){var output=def.outputs[i],handleEventClosure=renderEventHandlerClosure(view,def.nodeIndex,elementEventFullName$1(output.target,output.eventName)),listenTarget=output.target,listenerView=view;"component"===output.target&&(listenTarget=null,listenerView=compView);var disposable=listenerView.renderer.listen(listenTarget||el,output.eventName,handleEventClosure);view.disposables[def.outputIndex+i]=disposable}}function renderEventHandlerClosure(view,index,eventName){return function(event){return dispatchEvent(view,index,eventName,event)}}function checkAndUpdateElementInline(view,def,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){var bindLen=def.bindings.length,changed=!1;return bindLen>0&&checkAndUpdateElementValue(view,def,0,v0)&&(changed=!0),bindLen>1&&checkAndUpdateElementValue(view,def,1,v1)&&(changed=!0),bindLen>2&&checkAndUpdateElementValue(view,def,2,v2)&&(changed=!0),bindLen>3&&checkAndUpdateElementValue(view,def,3,v3)&&(changed=!0),bindLen>4&&checkAndUpdateElementValue(view,def,4,v4)&&(changed=!0),bindLen>5&&checkAndUpdateElementValue(view,def,5,v5)&&(changed=!0),bindLen>6&&checkAndUpdateElementValue(view,def,6,v6)&&(changed=!0),bindLen>7&&checkAndUpdateElementValue(view,def,7,v7)&&(changed=!0),bindLen>8&&checkAndUpdateElementValue(view,def,8,v8)&&(changed=!0),bindLen>9&&checkAndUpdateElementValue(view,def,9,v9)&&(changed=!0),changed}function checkAndUpdateElementDynamic(view,def,values){for(var changed=!1,i=0;i<values.length;i++)checkAndUpdateElementValue(view,def,i,values[i])&&(changed=!0);return changed}function checkAndUpdateElementValue(view,def,bindingIdx,value){if(!checkAndUpdateBinding(view,def,bindingIdx,value))return!1;var binding=def.bindings[bindingIdx],elData=asElementData(view,def.nodeIndex),renderNode$$1=elData.renderElement,name=binding.name;switch(15&binding.flags){case 1:setElementAttribute(view,binding,renderNode$$1,binding.ns,name,value);break;case 2:setElementClass(view,renderNode$$1,name,value);break;case 4:setElementStyle(view,binding,renderNode$$1,name,value);break;case 8:setElementProperty(33554432&def.flags&&32&binding.flags?elData.componentView:view,binding,renderNode$$1,name,value)}return!0}function setElementAttribute(view,binding,renderNode$$1,ns,name,value){var securityContext=binding.securityContext,renderValue=securityContext?view.root.sanitizer.sanitize(securityContext,value):value;renderValue=null!=renderValue?renderValue.toString():null;var renderer=view.renderer;null!=value?renderer.setAttribute(renderNode$$1,name,renderValue,ns):renderer.removeAttribute(renderNode$$1,name,ns)}function setElementClass(view,renderNode$$1,name,value){var renderer=view.renderer;value?renderer.addClass(renderNode$$1,name):renderer.removeClass(renderNode$$1,name)}function setElementStyle(view,binding,renderNode$$1,name,value){var renderValue=view.root.sanitizer.sanitize(SecurityContext$1.STYLE,value);if(null!=renderValue){renderValue=renderValue.toString();var unit=binding.suffix;null!=unit&&(renderValue+=unit)}else renderValue=null;var renderer=view.renderer;null!=renderValue?renderer.setStyle(renderNode$$1,name,renderValue):renderer.removeStyle(renderNode$$1,name)}function setElementProperty(view,binding,renderNode$$1,name,value){var securityContext=binding.securityContext,renderValue=securityContext?view.root.sanitizer.sanitize(securityContext,value):value;view.renderer.setProperty(renderNode$$1,name,renderValue)}function initNgModule(data){for(var def=data._def,providers=data._providers=new Array(def.providers.length),i=0;i<def.providers.length;i++){var provDef=def.providers[i];4096&provDef.flags||(providers[i]=_createProviderInstance$1(data,provDef))}}function resolveNgModuleDep(data,depDef,notFoundValue){if(void 0===notFoundValue&&(notFoundValue=Injector.THROW_IF_NOT_FOUND),8&depDef.flags)return depDef.token;if(2&depDef.flags&&(notFoundValue=null),1&depDef.flags)return data._parent.get(depDef.token,notFoundValue);var tokenKey$$1=depDef.tokenKey;switch(tokenKey$$1){case InjectorRefTokenKey$1:case NgModuleRefTokenKey:return data}var providerDef=data._def.providersByKey[tokenKey$$1];if(providerDef){var providerInstance=data._providers[providerDef.index];return void 0===providerInstance&&(providerInstance=data._providers[providerDef.index]=_createProviderInstance$1(data,providerDef)),providerInstance===UNDEFINED_VALUE?void 0:providerInstance}return data._parent.get(depDef.token,notFoundValue)}function _createProviderInstance$1(ngModule,providerDef){var injectable;switch(201347067&providerDef.flags){case 512:injectable=_createClass(ngModule,providerDef.value,providerDef.deps);break;case 1024:injectable=_callFactory(ngModule,providerDef.value,providerDef.deps);break;case 2048:injectable=resolveNgModuleDep(ngModule,providerDef.deps[0]);break;case 256:injectable=providerDef.value}return void 0===injectable?UNDEFINED_VALUE:injectable}function _createClass(ngModule,ctor,deps){var len=deps.length;switch(len){case 0:return new ctor;case 1:return new ctor(resolveNgModuleDep(ngModule,deps[0]));case 2:return new ctor(resolveNgModuleDep(ngModule,deps[0]),resolveNgModuleDep(ngModule,deps[1]));case 3:return new ctor(resolveNgModuleDep(ngModule,deps[0]),resolveNgModuleDep(ngModule,deps[1]),resolveNgModuleDep(ngModule,deps[2]));default:for(var depValues=new Array(len),i=0;i<len;i++)depValues[i]=resolveNgModuleDep(ngModule,deps[i]);return new(ctor.bind.apply(ctor,[void 0].concat(depValues)))}}function _callFactory(ngModule,factory,deps){var len=deps.length;switch(len){case 0:return factory();case 1:return factory(resolveNgModuleDep(ngModule,deps[0]));case 2:return factory(resolveNgModuleDep(ngModule,deps[0]),resolveNgModuleDep(ngModule,deps[1]));case 3:return factory(resolveNgModuleDep(ngModule,deps[0]),resolveNgModuleDep(ngModule,deps[1]),resolveNgModuleDep(ngModule,deps[2]));default:for(var depValues=Array(len),i=0;i<len;i++)depValues[i]=resolveNgModuleDep(ngModule,deps[i]);return factory.apply(void 0,depValues)}}function callNgModuleLifecycle(ngModule,lifecycles){for(var def=ngModule._def,i=0;i<def.providers.length;i++){if(131072&def.providers[i].flags){var instance=ngModule._providers[i];instance&&instance!==UNDEFINED_VALUE&&instance.ngOnDestroy()}}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function attachEmbeddedView(parentView,elementData,viewIndex,view){var embeddedViews=elementData.viewContainer._embeddedViews;null!==viewIndex&&void 0!==viewIndex||(viewIndex=embeddedViews.length),view.viewContainerParent=parentView,addToArray(embeddedViews,viewIndex,view),attachProjectedView(elementData,view),Services.dirtyParentQueries(view),renderAttachEmbeddedView(elementData,viewIndex>0?embeddedViews[viewIndex-1]:null,view)}function attachProjectedView(vcElementData,view){var dvcElementData=declaredViewContainer(view);if(dvcElementData&&dvcElementData!==vcElementData&&!(16&view.state)){view.state|=16;var projectedViews=dvcElementData.template._projectedViews;projectedViews||(projectedViews=dvcElementData.template._projectedViews=[]),projectedViews.push(view),markNodeAsProjectedTemplate(view.parent.def,view.parentNodeDef)}}function markNodeAsProjectedTemplate(viewDef,nodeDef){if(!(4&nodeDef.flags)){viewDef.nodeFlags|=4,nodeDef.flags|=4;for(var parentNodeDef=nodeDef.parent;parentNodeDef;)parentNodeDef.childFlags|=4,parentNodeDef=parentNodeDef.parent}}function detachEmbeddedView(elementData,viewIndex){var embeddedViews=elementData.viewContainer._embeddedViews;if((null==viewIndex||viewIndex>=embeddedViews.length)&&(viewIndex=embeddedViews.length-1),viewIndex<0)return null;var view=embeddedViews[viewIndex];return view.viewContainerParent=null,removeFromArray(embeddedViews,viewIndex),Services.dirtyParentQueries(view),renderDetachView(view),view}function detachProjectedView(view){if(16&view.state){var dvcElementData=declaredViewContainer(view);if(dvcElementData){var projectedViews=dvcElementData.template._projectedViews;projectedViews&&(removeFromArray(projectedViews,projectedViews.indexOf(view)),Services.dirtyParentQueries(view))}}}function moveEmbeddedView(elementData,oldViewIndex,newViewIndex){var embeddedViews=elementData.viewContainer._embeddedViews,view=embeddedViews[oldViewIndex];return removeFromArray(embeddedViews,oldViewIndex),null==newViewIndex&&(newViewIndex=embeddedViews.length),addToArray(embeddedViews,newViewIndex,view),Services.dirtyParentQueries(view),renderDetachView(view),renderAttachEmbeddedView(elementData,newViewIndex>0?embeddedViews[newViewIndex-1]:null,view),view}function renderAttachEmbeddedView(elementData,prevView,view){var prevRenderNode=prevView?renderNode(prevView,prevView.def.lastRenderRootNode):elementData.renderElement;visitRootRenderNodes(view,2,view.renderer.parentNode(prevRenderNode),view.renderer.nextSibling(prevRenderNode),void 0)}function renderDetachView(view){visitRootRenderNodes(view,3,null,null,void 0)}function addToArray(arr,index,value){index>=arr.length?arr.push(value):arr.splice(index,0,value)}function removeFromArray(arr,index){index>=arr.length-1?arr.pop():arr.splice(index,1)}function getComponentViewDefinitionFactory(componentFactory){return componentFactory.viewDefFactory}function createViewContainerData(view,elDef,elData){return new ViewContainerRef_(view,elDef,elData)}function createChangeDetectorRef(view){return new ViewRef_(view)}function createTemplateData(view,def){return new TemplateRef_(view,def)}function createInjector(view,elDef){return new Injector_(view,elDef)}function createRendererV1(view){return new RendererAdapter(view.renderer)}function createNgModuleRef(moduleType,parent,bootstrapComponents,def){return new NgModuleRef_(moduleType,parent,bootstrapComponents,def)}function createProviderInstance(view,def){return _createProviderInstance(view,def)}function createPipeInstance(view,def){for(var compView=view;compView.parent&&!isComponentView(compView);)compView=compView.parent;return createClass(compView.parent,viewParentEl(compView),!0,def.provider.value,def.provider.deps)}function createDirectiveInstance(view,def){var allowPrivateServices=(32768&def.flags)>0,instance=createClass(view,def.parent,allowPrivateServices,def.provider.value,def.provider.deps);if(def.outputs.length)for(var i=0;i<def.outputs.length;i++){var output=def.outputs[i],subscription=instance[output.propName].subscribe(eventHandlerClosure(view,def.parent.nodeIndex,output.eventName));view.disposables[def.outputIndex+i]=subscription.unsubscribe.bind(subscription)}return instance}function eventHandlerClosure(view,index,eventName){return function(event){return dispatchEvent(view,index,eventName,event)}}function checkAndUpdateDirectiveInline(view,def,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){var providerData=asProviderData(view,def.nodeIndex),directive=providerData.instance,changed=!1,changes=void 0,bindLen=def.bindings.length;return bindLen>0&&checkBinding(view,def,0,v0)&&(changed=!0,changes=updateProp(view,providerData,def,0,v0,changes)),bindLen>1&&checkBinding(view,def,1,v1)&&(changed=!0,changes=updateProp(view,providerData,def,1,v1,changes)),bindLen>2&&checkBinding(view,def,2,v2)&&(changed=!0,changes=updateProp(view,providerData,def,2,v2,changes)),bindLen>3&&checkBinding(view,def,3,v3)&&(changed=!0,changes=updateProp(view,providerData,def,3,v3,changes)),bindLen>4&&checkBinding(view,def,4,v4)&&(changed=!0,changes=updateProp(view,providerData,def,4,v4,changes)),bindLen>5&&checkBinding(view,def,5,v5)&&(changed=!0,changes=updateProp(view,providerData,def,5,v5,changes)),bindLen>6&&checkBinding(view,def,6,v6)&&(changed=!0,changes=updateProp(view,providerData,def,6,v6,changes)),bindLen>7&&checkBinding(view,def,7,v7)&&(changed=!0,changes=updateProp(view,providerData,def,7,v7,changes)),bindLen>8&&checkBinding(view,def,8,v8)&&(changed=!0,changes=updateProp(view,providerData,def,8,v8,changes)),bindLen>9&&checkBinding(view,def,9,v9)&&(changed=!0,changes=updateProp(view,providerData,def,9,v9,changes)),changes&&directive.ngOnChanges(changes),65536&def.flags&&shouldCallLifecycleInitHook(view,256,def.nodeIndex)&&directive.ngOnInit(),262144&def.flags&&directive.ngDoCheck(),changed}function checkAndUpdateDirectiveDynamic(view,def,values){for(var providerData=asProviderData(view,def.nodeIndex),directive=providerData.instance,changed=!1,changes=void 0,i=0;i<values.length;i++)checkBinding(view,def,i,values[i])&&(changed=!0,changes=updateProp(view,providerData,def,i,values[i],changes));return changes&&directive.ngOnChanges(changes),65536&def.flags&&shouldCallLifecycleInitHook(view,256,def.nodeIndex)&&directive.ngOnInit(),262144&def.flags&&directive.ngDoCheck(),changed}function _createProviderInstance(view,def){var allowPrivateServices=(8192&def.flags)>0,providerDef=def.provider;switch(201347067&def.flags){case 512:return createClass(view,def.parent,allowPrivateServices,providerDef.value,providerDef.deps);case 1024:return callFactory(view,def.parent,allowPrivateServices,providerDef.value,providerDef.deps);case 2048:return resolveDep(view,def.parent,allowPrivateServices,providerDef.deps[0]);case 256:return providerDef.value}}function createClass(view,elDef,allowPrivateServices,ctor,deps){var len=deps.length;switch(len){case 0:return new ctor;case 1:return new ctor(resolveDep(view,elDef,allowPrivateServices,deps[0]));case 2:return new ctor(resolveDep(view,elDef,allowPrivateServices,deps[0]),resolveDep(view,elDef,allowPrivateServices,deps[1]));case 3:return new ctor(resolveDep(view,elDef,allowPrivateServices,deps[0]),resolveDep(view,elDef,allowPrivateServices,deps[1]),resolveDep(view,elDef,allowPrivateServices,deps[2]));default:for(var depValues=new Array(len),i=0;i<len;i++)depValues[i]=resolveDep(view,elDef,allowPrivateServices,deps[i]);return new(ctor.bind.apply(ctor,[void 0].concat(depValues)))}}function callFactory(view,elDef,allowPrivateServices,factory,deps){var len=deps.length;switch(len){case 0:return factory();case 1:return factory(resolveDep(view,elDef,allowPrivateServices,deps[0]));case 2:return factory(resolveDep(view,elDef,allowPrivateServices,deps[0]),resolveDep(view,elDef,allowPrivateServices,deps[1]));case 3:return factory(resolveDep(view,elDef,allowPrivateServices,deps[0]),resolveDep(view,elDef,allowPrivateServices,deps[1]),resolveDep(view,elDef,allowPrivateServices,deps[2]));default:for(var depValues=Array(len),i=0;i<len;i++)depValues[i]=resolveDep(view,elDef,allowPrivateServices,deps[i]);return factory.apply(void 0,depValues)}}function resolveDep(view,elDef,allowPrivateServices,depDef,notFoundValue){if(void 0===notFoundValue&&(notFoundValue=Injector.THROW_IF_NOT_FOUND),8&depDef.flags)return depDef.token;var startView=view;2&depDef.flags&&(notFoundValue=null);var tokenKey$$1=depDef.tokenKey;for(tokenKey$$1===ChangeDetectorRefTokenKey&&(allowPrivateServices=!(!elDef||!elDef.element.componentView)),elDef&&1&depDef.flags&&(allowPrivateServices=!1,elDef=elDef.parent);view;){if(elDef)switch(tokenKey$$1){case RendererV1TokenKey:var compView=findCompView(view,elDef,allowPrivateServices);return createRendererV1(compView);case Renderer2TokenKey:var compView=findCompView(view,elDef,allowPrivateServices);return compView.renderer;case ElementRefTokenKey:return new ElementRef(asElementData(view,elDef.nodeIndex).renderElement);case ViewContainerRefTokenKey:return asElementData(view,elDef.nodeIndex).viewContainer;case TemplateRefTokenKey:if(elDef.element.template)return asElementData(view,elDef.nodeIndex).template;break;case ChangeDetectorRefTokenKey:return createChangeDetectorRef(findCompView(view,elDef,allowPrivateServices));case InjectorRefTokenKey:return createInjector(view,elDef);default:var providerDef_1=(allowPrivateServices?elDef.element.allProviders:elDef.element.publicProviders)[tokenKey$$1];if(providerDef_1){var providerData=asProviderData(view,providerDef_1.nodeIndex);return providerData||(providerData={instance:_createProviderInstance(view,providerDef_1)},view.nodes[providerDef_1.nodeIndex]=providerData),providerData.instance}}allowPrivateServices=isComponentView(view),elDef=viewParentEl(view),view=view.parent}var value=startView.root.injector.get(depDef.token,NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR);return value!==NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR||notFoundValue===NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR?value:startView.root.ngModule.injector.get(depDef.token,notFoundValue)}function findCompView(view,elDef,allowPrivateServices){var compView;if(allowPrivateServices)compView=asElementData(view,elDef.nodeIndex).componentView;else for(compView=view;compView.parent&&!isComponentView(compView);)compView=compView.parent;return compView}function updateProp(view,providerData,def,bindingIdx,value,changes){if(32768&def.flags){var compView=asElementData(view,def.parent.nodeIndex).componentView;2&compView.def.flags&&(compView.state|=8)}var binding=def.bindings[bindingIdx],propName=binding.name;if(providerData.instance[propName]=value,524288&def.flags){changes=changes||{};var oldValue=WrappedValue.unwrap(view.oldValues[def.bindingIndex+bindingIdx]);changes[def.bindings[bindingIdx].nonMinifiedName]=new SimpleChange(oldValue,value,0!=(2&view.state))}return view.oldValues[def.bindingIndex+bindingIdx]=value,changes}function callLifecycleHooksChildrenFirst(view,lifecycles){if(view.def.nodeFlags&lifecycles)for(var nodes=view.def.nodes,initIndex=0,i=0;i<nodes.length;i++){var nodeDef=nodes[i],parent_1=nodeDef.parent;for(!parent_1&&nodeDef.flags&lifecycles&&callProviderLifecycles(view,i,nodeDef.flags&lifecycles,initIndex++),0==(nodeDef.childFlags&lifecycles)&&(i+=nodeDef.childCount);parent_1&&1&parent_1.flags&&i===parent_1.nodeIndex+parent_1.childCount;)parent_1.directChildFlags&lifecycles&&(initIndex=callElementProvidersLifecycles(view,parent_1,lifecycles,initIndex)),parent_1=parent_1.parent}}function callElementProvidersLifecycles(view,elDef,lifecycles,initIndex){for(var i=elDef.nodeIndex+1;i<=elDef.nodeIndex+elDef.childCount;i++){var nodeDef=view.def.nodes[i];nodeDef.flags&lifecycles&&callProviderLifecycles(view,i,nodeDef.flags&lifecycles,initIndex++),i+=nodeDef.childCount}return initIndex}function callProviderLifecycles(view,index,lifecycles,initIndex){var providerData=asProviderData(view,index);if(providerData){var provider=providerData.instance;provider&&(Services.setCurrentNode(view,index),1048576&lifecycles&&shouldCallLifecycleInitHook(view,512,initIndex)&&provider.ngAfterContentInit(),2097152&lifecycles&&provider.ngAfterContentChecked(),4194304&lifecycles&&shouldCallLifecycleInitHook(view,768,initIndex)&&provider.ngAfterViewInit(),8388608&lifecycles&&provider.ngAfterViewChecked(),131072&lifecycles&&provider.ngOnDestroy())}}function createQuery(){return new QueryList}function dirtyParentQueries(view){for(var queryIds=view.def.nodeMatchedQueries;view.parent&&isEmbeddedView(view);){var tplDef=view.parentNodeDef;view=view.parent;for(var end=tplDef.nodeIndex+tplDef.childCount,i=0;i<=end;i++){var nodeDef=view.def.nodes[i];67108864&nodeDef.flags&&536870912&nodeDef.flags&&(nodeDef.query.filterId&queryIds)===nodeDef.query.filterId&&asQueryList(view,i).setDirty(),!(1&nodeDef.flags&&i+nodeDef.childCount<tplDef.nodeIndex)&&67108864&nodeDef.childFlags&&536870912&nodeDef.childFlags||(i+=nodeDef.childCount)}}if(134217728&view.def.nodeFlags)for(var i=0;i<view.def.nodes.length;i++){var nodeDef=view.def.nodes[i];134217728&nodeDef.flags&&536870912&nodeDef.flags&&asQueryList(view,i).setDirty(),i+=nodeDef.childCount}}function checkAndUpdateQuery(view,nodeDef){var queryList=asQueryList(view,nodeDef.nodeIndex);if(queryList.dirty){var directiveInstance,newValues=void 0;if(67108864&nodeDef.flags){var elementDef=nodeDef.parent.parent;newValues=calcQueryValues(view,elementDef.nodeIndex,elementDef.nodeIndex+elementDef.childCount,nodeDef.query,[]),directiveInstance=asProviderData(view,nodeDef.parent.nodeIndex).instance}else 134217728&nodeDef.flags&&(newValues=calcQueryValues(view,0,view.def.nodes.length-1,nodeDef.query,[]),directiveInstance=view.component);queryList.reset(newValues);for(var bindings=nodeDef.query.bindings,notify=!1,i=0;i<bindings.length;i++){var binding=bindings[i],boundValue=void 0;switch(binding.bindingType){case 0:boundValue=queryList.first;break;case 1:boundValue=queryList,notify=!0}directiveInstance[binding.propName]=boundValue}notify&&queryList.notifyOnChanges()}}function calcQueryValues(view,startIndex,endIndex,queryDef,values){for(var i=startIndex;i<=endIndex;i++){var nodeDef=view.def.nodes[i],valueType=nodeDef.matchedQueries[queryDef.id];if(null!=valueType&&values.push(getQueryValue(view,nodeDef,valueType)),1&nodeDef.flags&&nodeDef.element.template&&(nodeDef.element.template.nodeMatchedQueries&queryDef.filterId)===queryDef.filterId){var elementData=asElementData(view,i);if((nodeDef.childMatchedQueries&queryDef.filterId)===queryDef.filterId&&(calcQueryValues(view,i+1,i+nodeDef.childCount,queryDef,values),i+=nodeDef.childCount),16777216&nodeDef.flags)for(var embeddedViews=elementData.viewContainer._embeddedViews,k=0;k<embeddedViews.length;k++){var embeddedView=embeddedViews[k],dvc=declaredViewContainer(embeddedView);dvc&&dvc===elementData&&calcQueryValues(embeddedView,0,embeddedView.def.nodes.length-1,queryDef,values)}var projectedViews=elementData.template._projectedViews;if(projectedViews)for(var k=0;k<projectedViews.length;k++){var projectedView=projectedViews[k];calcQueryValues(projectedView,0,projectedView.def.nodes.length-1,queryDef,values)}}(nodeDef.childMatchedQueries&queryDef.filterId)!==queryDef.filterId&&(i+=nodeDef.childCount)}return values}function getQueryValue(view,nodeDef,queryValueType){if(null!=queryValueType)switch(queryValueType){case 1:return asElementData(view,nodeDef.nodeIndex).renderElement;case 0:return new ElementRef(asElementData(view,nodeDef.nodeIndex).renderElement);case 2:return asElementData(view,nodeDef.nodeIndex).template;case 3:return asElementData(view,nodeDef.nodeIndex).viewContainer;case 4:return asProviderData(view,nodeDef.nodeIndex).instance}}function appendNgContent(view,renderHost,def){var parentEl=getParentRenderElement(view,renderHost,def);if(parentEl){visitProjectedRenderNodes(view,def.ngContent.index,1,parentEl,null,void 0)}}function createPureExpression(view,def){return{value:void 0}}function checkAndUpdatePureExpressionInline(view,def,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){var bindings=def.bindings,changed=!1,bindLen=bindings.length;if(bindLen>0&&checkAndUpdateBinding(view,def,0,v0)&&(changed=!0),bindLen>1&&checkAndUpdateBinding(view,def,1,v1)&&(changed=!0),bindLen>2&&checkAndUpdateBinding(view,def,2,v2)&&(changed=!0),bindLen>3&&checkAndUpdateBinding(view,def,3,v3)&&(changed=!0),bindLen>4&&checkAndUpdateBinding(view,def,4,v4)&&(changed=!0),bindLen>5&&checkAndUpdateBinding(view,def,5,v5)&&(changed=!0),bindLen>6&&checkAndUpdateBinding(view,def,6,v6)&&(changed=!0),bindLen>7&&checkAndUpdateBinding(view,def,7,v7)&&(changed=!0),bindLen>8&&checkAndUpdateBinding(view,def,8,v8)&&(changed=!0),bindLen>9&&checkAndUpdateBinding(view,def,9,v9)&&(changed=!0),changed){var data=asPureExpressionData(view,def.nodeIndex),value=void 0;switch(201347067&def.flags){case 32:value=new Array(bindings.length),bindLen>0&&(value[0]=v0),bindLen>1&&(value[1]=v1),bindLen>2&&(value[2]=v2),bindLen>3&&(value[3]=v3),bindLen>4&&(value[4]=v4),bindLen>5&&(value[5]=v5),bindLen>6&&(value[6]=v6),bindLen>7&&(value[7]=v7),bindLen>8&&(value[8]=v8),bindLen>9&&(value[9]=v9);break;case 64:value={},bindLen>0&&(value[bindings[0].name]=v0),bindLen>1&&(value[bindings[1].name]=v1),bindLen>2&&(value[bindings[2].name]=v2),bindLen>3&&(value[bindings[3].name]=v3),bindLen>4&&(value[bindings[4].name]=v4),bindLen>5&&(value[bindings[5].name]=v5),bindLen>6&&(value[bindings[6].name]=v6),bindLen>7&&(value[bindings[7].name]=v7),bindLen>8&&(value[bindings[8].name]=v8),bindLen>9&&(value[bindings[9].name]=v9);break;case 128:var pipe=v0;switch(bindLen){case 1:value=pipe.transform(v0);break;case 2:value=pipe.transform(v1);break;case 3:value=pipe.transform(v1,v2);break;case 4:value=pipe.transform(v1,v2,v3);break;case 5:value=pipe.transform(v1,v2,v3,v4);break;case 6:value=pipe.transform(v1,v2,v3,v4,v5);break;case 7:value=pipe.transform(v1,v2,v3,v4,v5,v6);break;case 8:value=pipe.transform(v1,v2,v3,v4,v5,v6,v7);break;case 9:value=pipe.transform(v1,v2,v3,v4,v5,v6,v7,v8);break;case 10:value=pipe.transform(v1,v2,v3,v4,v5,v6,v7,v8,v9)}}data.value=value}return changed}function checkAndUpdatePureExpressionDynamic(view,def,values){for(var bindings=def.bindings,changed=!1,i=0;i<values.length;i++)checkAndUpdateBinding(view,def,i,values[i])&&(changed=!0);if(changed){var data=asPureExpressionData(view,def.nodeIndex),value=void 0;switch(201347067&def.flags){case 32:value=values;break;case 64:value={};for(var i=0;i<values.length;i++)value[bindings[i].name]=values[i];break;case 128:var pipe=values[0],params=values.slice(1);value=pipe.transform.apply(pipe,params)}data.value=value}return changed}function createText(view,renderHost,def){var renderNode$$1,renderer=view.renderer;renderNode$$1=renderer.createText(def.text.prefix);var parentEl=getParentRenderElement(view,renderHost,def);return parentEl&&renderer.appendChild(parentEl,renderNode$$1),{renderText:renderNode$$1}}function checkAndUpdateTextInline(view,def,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){var changed=!1,bindings=def.bindings,bindLen=bindings.length;if(bindLen>0&&checkAndUpdateBinding(view,def,0,v0)&&(changed=!0),bindLen>1&&checkAndUpdateBinding(view,def,1,v1)&&(changed=!0),bindLen>2&&checkAndUpdateBinding(view,def,2,v2)&&(changed=!0),bindLen>3&&checkAndUpdateBinding(view,def,3,v3)&&(changed=!0),bindLen>4&&checkAndUpdateBinding(view,def,4,v4)&&(changed=!0),bindLen>5&&checkAndUpdateBinding(view,def,5,v5)&&(changed=!0),bindLen>6&&checkAndUpdateBinding(view,def,6,v6)&&(changed=!0),bindLen>7&&checkAndUpdateBinding(view,def,7,v7)&&(changed=!0),bindLen>8&&checkAndUpdateBinding(view,def,8,v8)&&(changed=!0),bindLen>9&&checkAndUpdateBinding(view,def,9,v9)&&(changed=!0),changed){var value=def.text.prefix;bindLen>0&&(value+=_addInterpolationPart(v0,bindings[0])),bindLen>1&&(value+=_addInterpolationPart(v1,bindings[1])),bindLen>2&&(value+=_addInterpolationPart(v2,bindings[2])),bindLen>3&&(value+=_addInterpolationPart(v3,bindings[3])),bindLen>4&&(value+=_addInterpolationPart(v4,bindings[4])),bindLen>5&&(value+=_addInterpolationPart(v5,bindings[5])),bindLen>6&&(value+=_addInterpolationPart(v6,bindings[6])),bindLen>7&&(value+=_addInterpolationPart(v7,bindings[7])),bindLen>8&&(value+=_addInterpolationPart(v8,bindings[8])),bindLen>9&&(value+=_addInterpolationPart(v9,bindings[9]));var renderNode$$1=asTextData(view,def.nodeIndex).renderText;view.renderer.setValue(renderNode$$1,value)}return changed}function checkAndUpdateTextDynamic(view,def,values){for(var bindings=def.bindings,changed=!1,i=0;i<values.length;i++)checkAndUpdateBinding(view,def,i,values[i])&&(changed=!0);if(changed){for(var value="",i=0;i<values.length;i++)value+=_addInterpolationPart(values[i],bindings[i]);value=def.text.prefix+value;var renderNode$$1=asTextData(view,def.nodeIndex).renderText;view.renderer.setValue(renderNode$$1,value)}return changed}function _addInterpolationPart(value,binding){return(null!=value?value.toString():"")+binding.suffix}function createEmbeddedView(parent,anchorDef$$1,viewDef,context){var view=createView(parent.root,parent.renderer,parent,anchorDef$$1,viewDef);return initView(view,parent.component,context),createViewNodes(view),view}function createRootView(root,def,context){var view=createView(root,root.renderer,null,null,def);return initView(view,context,context),createViewNodes(view),view}function createComponentView(parentView,nodeDef,viewDef,hostElement){var compRenderer,rendererType=nodeDef.element.componentRendererType;return compRenderer=rendererType?parentView.root.rendererFactory.createRenderer(hostElement,rendererType):parentView.root.renderer,createView(parentView.root,compRenderer,parentView,nodeDef.element.componentProvider,viewDef)}function createView(root,renderer,parent,parentNodeDef,def){var nodes=new Array(def.nodes.length),disposables=def.outputCount?new Array(def.outputCount):null;return{def:def,parent:parent,viewContainerParent:null,parentNodeDef:parentNodeDef,context:null,component:null,nodes:nodes,state:13,root:root,renderer:renderer,oldValues:new Array(def.bindingCount),disposables:disposables,initIndex:-1}}function initView(view,component,context){view.component=component,view.context=context}function createViewNodes(view){var renderHost;if(isComponentView(view)){var hostDef=view.parentNodeDef;renderHost=asElementData(view.parent,hostDef.parent.nodeIndex).renderElement}for(var def=view.def,nodes=view.nodes,i=0;i<def.nodes.length;i++){var nodeDef=def.nodes[i];Services.setCurrentNode(view,i);var nodeData=void 0;switch(201347067&nodeDef.flags){case 1:var el=createElement(view,renderHost,nodeDef),componentView=void 0;if(33554432&nodeDef.flags){var compViewDef=resolveDefinition(nodeDef.element.componentView);componentView=Services.createComponentView(view,nodeDef,compViewDef,el)}listenToElementOutputs(view,componentView,nodeDef,el),nodeData={renderElement:el,componentView:componentView,viewContainer:null,template:nodeDef.element.template?createTemplateData(view,nodeDef):void 0},16777216&nodeDef.flags&&(nodeData.viewContainer=createViewContainerData(view,nodeDef,nodeData));break;case 2:nodeData=createText(view,renderHost,nodeDef);break;case 512:case 1024:case 2048:case 256:if(!((nodeData=nodes[i])||4096&nodeDef.flags)){var instance=createProviderInstance(view,nodeDef);nodeData={instance:instance}}break;case 16:var instance=createPipeInstance(view,nodeDef);nodeData={instance:instance};break;case 16384:if(!(nodeData=nodes[i])){var instance=createDirectiveInstance(view,nodeDef);nodeData={instance:instance}}if(32768&nodeDef.flags){initView(asElementData(view,nodeDef.parent.nodeIndex).componentView,nodeData.instance,nodeData.instance)}break;case 32:case 64:case 128:nodeData=createPureExpression(view,nodeDef);break;case 67108864:case 134217728:nodeData=createQuery();break;case 8:appendNgContent(view,renderHost,nodeDef),nodeData=void 0}nodes[i]=nodeData}execComponentViewsAction(view,ViewAction.CreateViewNodes),execQueriesAction(view,201326592,268435456,0)}function checkNoChangesView(view){markProjectedViewsForCheck(view),Services.updateDirectives(view,1),execEmbeddedViewsAction(view,ViewAction.CheckNoChanges),Services.updateRenderer(view,1),execComponentViewsAction(view,ViewAction.CheckNoChanges),view.state&=-97}function checkAndUpdateView(view){1&view.state?(view.state&=-2,view.state|=2):view.state&=-3,shiftInitState(view,0,256),markProjectedViewsForCheck(view),Services.updateDirectives(view,0),execEmbeddedViewsAction(view,ViewAction.CheckAndUpdate),execQueriesAction(view,67108864,536870912,0);var callInit=shiftInitState(view,256,512);callLifecycleHooksChildrenFirst(view,2097152|(callInit?1048576:0)),Services.updateRenderer(view,0),execComponentViewsAction(view,ViewAction.CheckAndUpdate),execQueriesAction(view,134217728,536870912,0),callInit=shiftInitState(view,512,768),callLifecycleHooksChildrenFirst(view,8388608|(callInit?4194304:0)),2&view.def.flags&&(view.state&=-9),view.state&=-97,shiftInitState(view,768,1024)}function checkAndUpdateNode(view,nodeDef,argStyle,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){return 0===argStyle?checkAndUpdateNodeInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9):checkAndUpdateNodeDynamic(view,nodeDef,v0)}function markProjectedViewsForCheck(view){var def=view.def;if(4&def.nodeFlags)for(var i=0;i<def.nodes.length;i++){var nodeDef=def.nodes[i];if(4&nodeDef.flags){var projectedViews=asElementData(view,i).template._projectedViews;if(projectedViews)for(var i_1=0;i_1<projectedViews.length;i_1++){var projectedView=projectedViews[i_1];projectedView.state|=32,markParentViewsForCheckProjectedViews(projectedView,view)}}else 0==(4&nodeDef.childFlags)&&(i+=nodeDef.childCount)}}function checkAndUpdateNodeInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){switch(201347067&nodeDef.flags){case 1:return checkAndUpdateElementInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9);case 2:return checkAndUpdateTextInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9);case 16384:return checkAndUpdateDirectiveInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9);case 32:case 64:case 128:return checkAndUpdatePureExpressionInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9);default:throw"unreachable"}}function checkAndUpdateNodeDynamic(view,nodeDef,values){switch(201347067&nodeDef.flags){case 1:return checkAndUpdateElementDynamic(view,nodeDef,values);case 2:return checkAndUpdateTextDynamic(view,nodeDef,values);case 16384:return checkAndUpdateDirectiveDynamic(view,nodeDef,values);case 32:case 64:case 128:return checkAndUpdatePureExpressionDynamic(view,nodeDef,values);default:throw"unreachable"}}function checkNoChangesNode(view,nodeDef,argStyle,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){return 0===argStyle?checkNoChangesNodeInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9):checkNoChangesNodeDynamic(view,nodeDef,v0),!1}function checkNoChangesNodeInline(view,nodeDef,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){var bindLen=nodeDef.bindings.length;bindLen>0&&checkBindingNoChanges(view,nodeDef,0,v0),bindLen>1&&checkBindingNoChanges(view,nodeDef,1,v1),bindLen>2&&checkBindingNoChanges(view,nodeDef,2,v2),bindLen>3&&checkBindingNoChanges(view,nodeDef,3,v3),bindLen>4&&checkBindingNoChanges(view,nodeDef,4,v4),bindLen>5&&checkBindingNoChanges(view,nodeDef,5,v5),bindLen>6&&checkBindingNoChanges(view,nodeDef,6,v6),bindLen>7&&checkBindingNoChanges(view,nodeDef,7,v7),bindLen>8&&checkBindingNoChanges(view,nodeDef,8,v8),bindLen>9&&checkBindingNoChanges(view,nodeDef,9,v9)}function checkNoChangesNodeDynamic(view,nodeDef,values){for(var i=0;i<values.length;i++)checkBindingNoChanges(view,nodeDef,i,values[i])}function checkNoChangesQuery(view,nodeDef){if(asQueryList(view,nodeDef.nodeIndex).dirty)throw expressionChangedAfterItHasBeenCheckedError(Services.createDebugContext(view,nodeDef.nodeIndex),"Query "+nodeDef.query.id+" not dirty","Query "+nodeDef.query.id+" dirty",0!=(1&view.state))}function destroyView(view){if(!(128&view.state)){if(execEmbeddedViewsAction(view,ViewAction.Destroy),execComponentViewsAction(view,ViewAction.Destroy),callLifecycleHooksChildrenFirst(view,131072),view.disposables)for(var i=0;i<view.disposables.length;i++)view.disposables[i]();detachProjectedView(view),view.renderer.destroyNode&&destroyViewNodes(view),isComponentView(view)&&view.renderer.destroy(),view.state|=128}}function destroyViewNodes(view){for(var len=view.def.nodes.length,i=0;i<len;i++){var def=view.def.nodes[i];1&def.flags?view.renderer.destroyNode(asElementData(view,i).renderElement):2&def.flags?view.renderer.destroyNode(asTextData(view,i).renderText):(67108864&def.flags||134217728&def.flags)&&asQueryList(view,i).destroy()}}function execComponentViewsAction(view,action){var def=view.def;if(33554432&def.nodeFlags)for(var i=0;i<def.nodes.length;i++){var nodeDef=def.nodes[i];33554432&nodeDef.flags?callViewAction(asElementData(view,i).componentView,action):0==(33554432&nodeDef.childFlags)&&(i+=nodeDef.childCount)}}function execEmbeddedViewsAction(view,action){var def=view.def;if(16777216&def.nodeFlags)for(var i=0;i<def.nodes.length;i++){var nodeDef=def.nodes[i];if(16777216&nodeDef.flags)for(var embeddedViews=asElementData(view,i).viewContainer._embeddedViews,k=0;k<embeddedViews.length;k++)callViewAction(embeddedViews[k],action);else 0==(16777216&nodeDef.childFlags)&&(i+=nodeDef.childCount)}}function callViewAction(view,action){var viewState=view.state;switch(action){case ViewAction.CheckNoChanges:0==(128&viewState)&&(12==(12&viewState)?checkNoChangesView(view):64&viewState&&execProjectedViewsAction(view,ViewAction.CheckNoChangesProjectedViews));break;case ViewAction.CheckNoChangesProjectedViews:0==(128&viewState)&&(32&viewState?checkNoChangesView(view):64&viewState&&execProjectedViewsAction(view,action));break;case ViewAction.CheckAndUpdate:0==(128&viewState)&&(12==(12&viewState)?checkAndUpdateView(view):64&viewState&&execProjectedViewsAction(view,ViewAction.CheckAndUpdateProjectedViews));break;case ViewAction.CheckAndUpdateProjectedViews:0==(128&viewState)&&(32&viewState?checkAndUpdateView(view):64&viewState&&execProjectedViewsAction(view,action));break;case ViewAction.Destroy:destroyView(view);break;case ViewAction.CreateViewNodes:createViewNodes(view)}}function execProjectedViewsAction(view,action){execEmbeddedViewsAction(view,action),execComponentViewsAction(view,action)}function execQueriesAction(view,queryFlags,staticDynamicQueryFlag,checkType){if(view.def.nodeFlags&queryFlags&&view.def.nodeFlags&staticDynamicQueryFlag)for(var nodeCount=view.def.nodes.length,i=0;i<nodeCount;i++){var nodeDef=view.def.nodes[i];if(nodeDef.flags&queryFlags&&nodeDef.flags&staticDynamicQueryFlag)switch(Services.setCurrentNode(view,nodeDef.nodeIndex),checkType){case 0:checkAndUpdateQuery(view,nodeDef);break;case 1:checkNoChangesQuery(view,nodeDef)}nodeDef.childFlags&queryFlags&&nodeDef.childFlags&staticDynamicQueryFlag||(i+=nodeDef.childCount)}}function initServicesIfNeeded(){if(!initialized){initialized=!0;var services=isDevMode()?createDebugServices():createProdServices();Services.setCurrentNode=services.setCurrentNode,Services.createRootView=services.createRootView,Services.createEmbeddedView=services.createEmbeddedView,Services.createComponentView=services.createComponentView,Services.createNgModuleRef=services.createNgModuleRef,Services.overrideProvider=services.overrideProvider,Services.overrideComponentView=services.overrideComponentView,Services.clearOverrides=services.clearOverrides,Services.checkAndUpdateView=services.checkAndUpdateView,Services.checkNoChangesView=services.checkNoChangesView,Services.destroyView=services.destroyView,Services.resolveDep=resolveDep,Services.createDebugContext=services.createDebugContext,Services.handleEvent=services.handleEvent,Services.updateDirectives=services.updateDirectives,Services.updateRenderer=services.updateRenderer,Services.dirtyParentQueries=dirtyParentQueries}}function createProdServices(){return{setCurrentNode:function(){},createRootView:createProdRootView,createEmbeddedView:createEmbeddedView,createComponentView:createComponentView,createNgModuleRef:createNgModuleRef,overrideProvider:NOOP,overrideComponentView:NOOP,clearOverrides:NOOP,checkAndUpdateView:checkAndUpdateView,checkNoChangesView:checkNoChangesView,destroyView:destroyView,
createDebugContext:function(view,nodeIndex){return new DebugContext_(view,nodeIndex)},handleEvent:function(view,nodeIndex,eventName,event){return view.def.handleEvent(view,nodeIndex,eventName,event)},updateDirectives:function(view,checkType){return view.def.updateDirectives(0===checkType?prodCheckAndUpdateNode:prodCheckNoChangesNode,view)},updateRenderer:function(view,checkType){return view.def.updateRenderer(0===checkType?prodCheckAndUpdateNode:prodCheckNoChangesNode,view)}}}function createDebugServices(){return{setCurrentNode:debugSetCurrentNode,createRootView:debugCreateRootView,createEmbeddedView:debugCreateEmbeddedView,createComponentView:debugCreateComponentView,createNgModuleRef:debugCreateNgModuleRef,overrideProvider:debugOverrideProvider,overrideComponentView:debugOverrideComponentView,clearOverrides:debugClearOverrides,checkAndUpdateView:debugCheckAndUpdateView,checkNoChangesView:debugCheckNoChangesView,destroyView:debugDestroyView,createDebugContext:function(view,nodeIndex){return new DebugContext_(view,nodeIndex)},handleEvent:debugHandleEvent,updateDirectives:debugUpdateDirectives,updateRenderer:debugUpdateRenderer}}function createProdRootView(elInjector,projectableNodes,rootSelectorOrNode,def,ngModule,context){return createRootView(createRootData(elInjector,ngModule,ngModule.injector.get(RendererFactory2),projectableNodes,rootSelectorOrNode),def,context)}function debugCreateRootView(elInjector,projectableNodes,rootSelectorOrNode,def,ngModule,context){var rendererFactory=ngModule.injector.get(RendererFactory2),root=createRootData(elInjector,ngModule,new DebugRendererFactory2(rendererFactory),projectableNodes,rootSelectorOrNode),defWithOverride=applyProviderOverridesToView(def);return callWithDebugContext(DebugAction.create,createRootView,null,[root,defWithOverride,context])}function createRootData(elInjector,ngModule,rendererFactory,projectableNodes,rootSelectorOrNode){var sanitizer=ngModule.injector.get(Sanitizer),errorHandler=ngModule.injector.get(ErrorHandler);return{ngModule:ngModule,injector:elInjector,projectableNodes:projectableNodes,selectorOrNode:rootSelectorOrNode,sanitizer:sanitizer,rendererFactory:rendererFactory,renderer:rendererFactory.createRenderer(null,null),errorHandler:errorHandler}}function debugCreateEmbeddedView(parentView,anchorDef,viewDef$$1,context){var defWithOverride=applyProviderOverridesToView(viewDef$$1);return callWithDebugContext(DebugAction.create,createEmbeddedView,null,[parentView,anchorDef,defWithOverride,context])}function debugCreateComponentView(parentView,nodeDef,viewDef$$1,hostElement){var overrideComponentView=viewDefOverrides.get(nodeDef.element.componentProvider.provider.token);return viewDef$$1=overrideComponentView||applyProviderOverridesToView(viewDef$$1),callWithDebugContext(DebugAction.create,createComponentView,null,[parentView,nodeDef,viewDef$$1,hostElement])}function debugCreateNgModuleRef(moduleType,parentInjector,bootstrapComponents,def){return createNgModuleRef(moduleType,parentInjector,bootstrapComponents,applyProviderOverridesToNgModule(def))}function debugOverrideProvider(override){providerOverrides.set(override.token,override)}function debugOverrideComponentView(comp,compFactory){var hostViewDef=resolveDefinition(getComponentViewDefinitionFactory(compFactory)),compViewDef=resolveDefinition(hostViewDef.nodes[0].element.componentView);viewDefOverrides.set(comp,compViewDef)}function debugClearOverrides(){providerOverrides.clear(),viewDefOverrides.clear()}function applyProviderOverridesToView(def){if(0===providerOverrides.size)return def;var elementIndicesWithOverwrittenProviders=function(def){for(var elIndicesWithOverwrittenProviders=[],lastElementDef=null,i=0;i<def.nodes.length;i++){var nodeDef=def.nodes[i];1&nodeDef.flags&&(lastElementDef=nodeDef),lastElementDef&&3840&nodeDef.flags&&providerOverrides.has(nodeDef.provider.token)&&(elIndicesWithOverwrittenProviders.push(lastElementDef.nodeIndex),lastElementDef=null)}return elIndicesWithOverwrittenProviders}(def);if(0===elementIndicesWithOverwrittenProviders.length)return def;def=def.factory(function(){return NOOP});for(var i=0;i<elementIndicesWithOverwrittenProviders.length;i++)!function(viewDef$$1,elIndex){for(var i=elIndex+1;i<viewDef$$1.nodes.length;i++){var nodeDef=viewDef$$1.nodes[i];if(1&nodeDef.flags)return;if(3840&nodeDef.flags){var provider=nodeDef.provider,override=providerOverrides.get(provider.token);override&&(nodeDef.flags=-3841&nodeDef.flags|override.flags,provider.deps=splitDepsDsl(override.deps),provider.value=override.value)}}}(def,elementIndicesWithOverwrittenProviders[i]);return def}function applyProviderOverridesToNgModule(def){var _a=function(def){var hasOverrides=!1,hasDeprecatedOverrides=!1;return 0===providerOverrides.size?{hasOverrides:hasOverrides,hasDeprecatedOverrides:hasDeprecatedOverrides}:(def.providers.forEach(function(node){var override=providerOverrides.get(node.token);3840&node.flags&&override&&(hasOverrides=!0,hasDeprecatedOverrides=hasDeprecatedOverrides||override.deprecatedBehavior)}),{hasOverrides:hasOverrides,hasDeprecatedOverrides:hasDeprecatedOverrides})}(def),hasOverrides=_a.hasOverrides,hasDeprecatedOverrides=_a.hasDeprecatedOverrides;return hasOverrides?(def=def.factory(function(){return NOOP}),function(def){for(var i=0;i<def.providers.length;i++){var provider=def.providers[i];hasDeprecatedOverrides&&(provider.flags|=4096);var override=providerOverrides.get(provider.token);override&&(provider.flags=-3841&provider.flags|override.flags,provider.deps=splitDepsDsl(override.deps),provider.value=override.value)}}(def),def):def}function prodCheckAndUpdateNode(view,checkIndex,argStyle,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){var nodeDef=view.def.nodes[checkIndex];return checkAndUpdateNode(view,nodeDef,argStyle,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9),224&nodeDef.flags?asPureExpressionData(view,checkIndex).value:void 0}function prodCheckNoChangesNode(view,checkIndex,argStyle,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9){var nodeDef=view.def.nodes[checkIndex];return checkNoChangesNode(view,nodeDef,argStyle,v0,v1,v2,v3,v4,v5,v6,v7,v8,v9),224&nodeDef.flags?asPureExpressionData(view,checkIndex).value:void 0}function debugCheckAndUpdateView(view){return callWithDebugContext(DebugAction.detectChanges,checkAndUpdateView,null,[view])}function debugCheckNoChangesView(view){return callWithDebugContext(DebugAction.checkNoChanges,checkNoChangesView,null,[view])}function debugDestroyView(view){return callWithDebugContext(DebugAction.destroy,destroyView,null,[view])}function debugSetCurrentNode(view,nodeIndex){_currentView=view,_currentNodeIndex=nodeIndex}function debugHandleEvent(view,nodeIndex,eventName,event){return debugSetCurrentNode(view,nodeIndex),callWithDebugContext(DebugAction.handleEvent,view.def.handleEvent,null,[view,nodeIndex,eventName,event])}function debugUpdateDirectives(view,checkType){function debugCheckDirectivesFn(view,nodeIndex,argStyle){for(var values=[],_i=3;_i<arguments.length;_i++)values[_i-3]=arguments[_i];var nodeDef=view.def.nodes[nodeIndex];return 0===checkType?debugCheckAndUpdateNode(view,nodeDef,argStyle,values):debugCheckNoChangesNode(view,nodeDef,argStyle,values),16384&nodeDef.flags&&debugSetCurrentNode(view,nextDirectiveWithBinding(view,nodeIndex)),224&nodeDef.flags?asPureExpressionData(view,nodeDef.nodeIndex).value:void 0}if(128&view.state)throw viewDestroyedError(DebugAction[_currentAction]);return debugSetCurrentNode(view,nextDirectiveWithBinding(view,0)),view.def.updateDirectives(debugCheckDirectivesFn,view)}function debugUpdateRenderer(view,checkType){function debugCheckRenderNodeFn(view,nodeIndex,argStyle){for(var values=[],_i=3;_i<arguments.length;_i++)values[_i-3]=arguments[_i];var nodeDef=view.def.nodes[nodeIndex];return 0===checkType?debugCheckAndUpdateNode(view,nodeDef,argStyle,values):debugCheckNoChangesNode(view,nodeDef,argStyle,values),3&nodeDef.flags&&debugSetCurrentNode(view,nextRenderNodeWithBinding(view,nodeIndex)),224&nodeDef.flags?asPureExpressionData(view,nodeDef.nodeIndex).value:void 0}if(128&view.state)throw viewDestroyedError(DebugAction[_currentAction]);return debugSetCurrentNode(view,nextRenderNodeWithBinding(view,0)),view.def.updateRenderer(debugCheckRenderNodeFn,view)}function debugCheckAndUpdateNode(view,nodeDef,argStyle,givenValues){if(checkAndUpdateNode.apply(void 0,[view,nodeDef,argStyle].concat(givenValues))){var values=1===argStyle?givenValues[0]:givenValues;if(16384&nodeDef.flags){for(var bindingValues={},i=0;i<nodeDef.bindings.length;i++){var binding=nodeDef.bindings[i],value=values[i];8&binding.flags&&(bindingValues[normalizeDebugBindingName(binding.nonMinifiedName)]=normalizeDebugBindingValue(value))}var elDef=nodeDef.parent,el=asElementData(view,elDef.nodeIndex).renderElement;if(elDef.element.name)for(var attr in bindingValues){var value=bindingValues[attr];null!=value?view.renderer.setAttribute(el,attr,value):view.renderer.removeAttribute(el,attr)}else view.renderer.setValue(el,"bindings="+JSON.stringify(bindingValues,null,2))}}}function debugCheckNoChangesNode(view,nodeDef,argStyle,values){checkNoChangesNode.apply(void 0,[view,nodeDef,argStyle].concat(values))}function normalizeDebugBindingName(name){return"ng-reflect-"+(name=camelCaseToDashCase(name.replace(/[$@]/g,"_")))}function camelCaseToDashCase(input){return input.replace(CAMEL_CASE_REGEXP,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];return"-"+m[1].toLowerCase()})}function normalizeDebugBindingValue(value){try{return null!=value?value.toString().slice(0,30):value}catch(e){return"[ERROR] Exception while trying to serialize the value"}}function nextDirectiveWithBinding(view,nodeIndex){for(var i=nodeIndex;i<view.def.nodes.length;i++){var nodeDef=view.def.nodes[i];if(16384&nodeDef.flags&&nodeDef.bindings&&nodeDef.bindings.length)return i}return null}function nextRenderNodeWithBinding(view,nodeIndex){for(var i=nodeIndex;i<view.def.nodes.length;i++){var nodeDef=view.def.nodes[i];if(3&nodeDef.flags&&nodeDef.bindings&&nodeDef.bindings.length)return i}return null}function getRenderNodeIndex(viewDef$$1,nodeIndex){for(var renderNodeIndex=-1,i=0;i<=nodeIndex;i++){3&viewDef$$1.nodes[i].flags&&renderNodeIndex++}return renderNodeIndex}function findHostElement(view){for(;view&&!isComponentView(view);)view=view.parent;return view.parent?asElementData(view.parent,viewParentEl(view).nodeIndex):null}function collectReferences(view,nodeDef,references){for(var refName in nodeDef.references)references[refName]=getQueryValue(view,nodeDef,nodeDef.references[refName])}function callWithDebugContext(action,fn,self,args){var oldAction=_currentAction,oldView=_currentView,oldNodeIndex=_currentNodeIndex;try{_currentAction=action;var result=fn.apply(self,args);return _currentView=oldView,_currentNodeIndex=oldNodeIndex,_currentAction=oldAction,result}catch(e){if(isViewDebugError(e)||!_currentView)throw e;throw viewWrappedDebugError(e,getCurrentDebugContext())}}function getCurrentDebugContext(){return _currentView?new DebugContext_(_currentView,_currentNodeIndex):null}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function stringifyValueForError(value){return"string"==typeof value?'"'+value+'"':""+value}function assertNotNull$1(actual,name){assertNotEqual(actual,null,name)}function assertNotEqual(actual,expected,name){actual==expected&&assertThrow(actual,expected,name,"!=")}function assertThrow(actual,expected,name,operator,serializer){throw void 0===serializer&&(serializer=stringifyValueForError),new Error("ASSERT: expected "+name+" "+operator+" "+serializer(expected)+" but was "+serializer(actual)+"!")}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function isParseSourceSpan(value){return value&&!!value.start}function spanOf(span){if(span)return isParseSourceSpan(span)?{start:span.start.offset,end:span.end.offset}:span.endSourceSpan?{start:span.sourceSpan.start.offset,end:span.endSourceSpan.end.offset}:span.children&&span.children.length?{start:span.sourceSpan.start.offset,end:spanOf(span.children[span.children.length-1]).end}:{start:span.sourceSpan.start.offset,end:span.sourceSpan.end.offset}}function inSpan(position,span,exclusive){return null!=span&&(exclusive?position>=span.start&&position<span.end:position>=span.start&&position<=span.end)}function offsetSpan(span,amount){return{start:span.start+amount,end:span.end+amount}}function isNarrower(spanA,spanB){return spanA.start>=spanB.start&&spanA.end<=spanB.end}function hasTemplateReference(type){if(type.diDeps)for(var _i=0,_a=type.diDeps;_i<_a.length;_i++){var diDep=_a[_i];if(diDep.token&&diDep.token.identifier&&"TemplateRef"==identifierName(diDep.token.identifier))return!0}return!1}function getSelectors(info){var map=new Map;return{selectors:flatten(info.directives.map(function(directive$$1){var selectors=CssSelector.parse(directive$$1.selector);return selectors.forEach(function(selector){return map.set(selector,directive$$1)}),selectors})),map:map}}function flatten(a){return(_a=[]).concat.apply(_a,a);var _a}function removeSuffix(value,suffix){return value.endsWith(suffix)?value.substring(0,value.length-suffix.length):value}function uniqueByName(elements){if(elements){for(var result=[],set=new Set,_i=0,elements_1=elements;_i<elements_1.length;_i++){var element=elements_1[_i];set.has(element.name)||(set.add(element.name),result.push(element))}return result}}function diagnosticInfoFromTemplateInfo(info){return{fileName:info.fileName,offset:info.template.span.start,query:info.template.query,members:info.template.members,htmlAst:info.htmlAst,templateAst:info.templateAst}}function findTemplateAstAt(ast,position,allowWidening){void 0===allowWidening&&(allowWidening=!1);var path$$1=[];return templateVisitAll(new(function(_super){function class_1(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(class_1,_super),class_1.prototype.visit=function(ast,context){var span=spanOf(ast);if(!inSpan(position,span))return!0;var len=path$$1.length;(!len||allowWidening||isNarrower(span,spanOf(path$$1[len-1])))&&path$$1.push(ast)},class_1.prototype.visitEmbeddedTemplate=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.directives),visit(ast.children)})},class_1.prototype.visitElement=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.inputs),visit(ast.outputs),visit(ast.references),visit(ast.directives),visit(ast.children)})},class_1.prototype.visitDirective=function(ast,context){var result=this.visitChildren(context,function(visit){visit(ast.inputs)});return path$$1[path$$1.length-1]==ast&&path$$1.pop(),result},class_1}(RecursiveTemplateAstVisitor)),ast),new AstPath(path$$1,position)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function findAstAt(ast,position,excludeEmpty){void 0===excludeEmpty&&(excludeEmpty=!1);var path$$1=[],visitor=new(function(_super){function class_1(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(class_1,_super),class_1.prototype.visit=function(ast){(!excludeEmpty||ast.span.start<ast.span.end)&&inSpan(position,ast.span)&&(path$$1.push(ast),visitAstChildren(ast,this))},class_1}(NullAstVisitor));return ast instanceof ASTWithSource&&(ast=ast.ast),visitor.visit(ast),new AstPath(path$$1,position)}function getExpressionCompletions(scope,ast,position,query){function getType(ast){return new language_services_4(scope,query,{}).getType(ast)}var path$$1=findAstAt(ast,position);if(!path$$1.empty){var tail=path$$1.tail,result=scope;return tail.visit({visitBinary:function(ast){},visitChain:function(ast){},visitConditional:function(ast){},visitFunctionCall:function(ast){},visitImplicitReceiver:function(ast){},visitInterpolation:function(ast){result=void 0},visitKeyedRead:function(ast){},visitKeyedWrite:function(ast){},visitLiteralArray:function(ast){},visitLiteralMap:function(ast){},visitLiteralPrimitive:function(ast){},visitMethodCall:function(ast){},visitPipe:function(ast){position>=ast.exp.span.end&&(!ast.args||!ast.args.length||position<ast.args[0].span.start)&&(result=query.getPipes())},visitPrefixNot:function(ast){},visitNonNullAssert:function(ast){},visitPropertyRead:function(ast){var receiverType=getType(ast.receiver);result=receiverType?receiverType.members():scope},visitPropertyWrite:function(ast){var receiverType=getType(ast.receiver);result=receiverType?receiverType.members():scope},visitQuote:function(ast){result=query.getBuiltinType(language_services_7.Any).members()},visitSafeMethodCall:function(ast){var receiverType=getType(ast.receiver);result=receiverType?receiverType.members():scope},visitSafePropertyRead:function(ast){var receiverType=getType(ast.receiver);result=receiverType?receiverType.members():scope}}),result&&result.values()}}function getExpressionSymbol(scope,ast,position,query){function getType(ast){return new language_services_4(scope,query,{}).getType(ast)}var path$$1=findAstAt(ast,position,!0);if(!path$$1.empty){var tail=path$$1.tail,symbol=void 0,span=void 0;return tail.visit({visitBinary:function(ast){},visitChain:function(ast){},visitConditional:function(ast){},visitFunctionCall:function(ast){},visitImplicitReceiver:function(ast){},visitInterpolation:function(ast){},visitKeyedRead:function(ast){},visitKeyedWrite:function(ast){},visitLiteralArray:function(ast){},visitLiteralMap:function(ast){},visitLiteralPrimitive:function(ast){},visitMethodCall:function(ast){var receiverType=getType(ast.receiver);symbol=receiverType&&receiverType.members().get(ast.name),span=ast.span},visitPipe:function(ast){if(position>=ast.exp.span.end&&(!ast.args||!ast.args.length||position<ast.args[0].span.start)){var pipes=query.getPipes();pipes&&(symbol=pipes.get(ast.name),span=ast.span)}},visitPrefixNot:function(ast){},visitNonNullAssert:function(ast){},visitPropertyRead:function(ast){var receiverType=getType(ast.receiver);symbol=receiverType&&receiverType.members().get(ast.name),span=ast.span},visitPropertyWrite:function(ast){var receiverType=getType(ast.receiver);symbol=receiverType&&receiverType.members().get(ast.name),span=ast.span},visitQuote:function(ast){},visitSafeMethodCall:function(ast){var receiverType=getType(ast.receiver);symbol=receiverType&&receiverType.members().get(ast.name),span=ast.span},visitSafePropertyRead:function(ast){var receiverType=getType(ast.receiver);symbol=receiverType&&receiverType.members().get(ast.name),span=ast.span}}),symbol&&span?{symbol:symbol,span:span}:void 0}}function elementNames(){return Object.keys(elements).sort().map(function(v){return v.toLowerCase()})}function compose(indexes){var result={};if(indexes)for(var _i=0,indexes_1=indexes;_i<indexes_1.length;_i++){var index=indexes_1[_i],group=groups[index];for(var name_1 in group)group.hasOwnProperty(name_1)&&(result[name_1]=values[group[name_1]])}return result}function attributeNames(element){return Object.keys(compose(elements[element.toUpperCase()]||defaultAttributes)).sort()}function eventNames(elementName){return SchemaInformation.instance.eventsOf(elementName)}function propertyNames(elementName){return SchemaInformation.instance.propertiesOf(elementName)}function getTemplateCompletions(templateInfo){var result=void 0,htmlAst=templateInfo.htmlAst,template=(templateInfo.templateAst,templateInfo.template);if(null!=templateInfo.position){var templatePosition_1=templateInfo.position-template.span.start,path_1=findNode(htmlAst,templatePosition_1),mostSpecific=path_1.tail;if(path_1.empty||!mostSpecific)result=elementCompletions(templateInfo,path_1);else{var astPosition_1=templatePosition_1-mostSpecific.sourceSpan.start.offset;mostSpecific.visit({visitElement:function(ast){var startTagSpan=spanOf(ast.sourceSpan),tagLen=ast.name.length;templatePosition_1<=startTagSpan.start+tagLen+1?result=elementCompletions(templateInfo,path_1):templatePosition_1<startTagSpan.end&&(result=attributeCompletions(templateInfo,path_1))},visitAttribute:function(ast){ast.valueSpan&&inSpan(templatePosition_1,spanOf(ast.valueSpan))?ast.valueSpan&&inSpan(templatePosition_1,spanOf(ast.valueSpan))&&(result=attributeValueCompletions(templateInfo,templatePosition_1,ast)):result=attributeCompletions(templateInfo,path_1)},visitText:function(ast){if(result=entityCompletions(getSourceText(template,spanOf(ast)),astPosition_1))return result;if(result=interpolationCompletions(templateInfo,templatePosition_1))return result;var element=path_1.first(Element);if(element){getHtmlTagDefinition(element.name).contentType===TagContentType.PARSABLE_DATA&&((result=voidElementAttributeCompletions(templateInfo,path_1))||(result=elementCompletions(templateInfo,path_1)))}else(result=voidElementAttributeCompletions(templateInfo,path_1))||(result=elementCompletions(templateInfo,path_1))},visitComment:function(ast){},visitExpansion:function(ast){},visitExpansionCase:function(ast){}},null)}}return result}function attributeCompletions(info,path$$1){var item=path$$1.tail instanceof Element?path$$1.tail:path$$1.parentOf(path$$1.tail);if(item instanceof Element)return attributeCompletionsForElement(info,item.name,item)}function attributeCompletionsForElement(info,elementName,element){return getAttributeInfosForElement(info,elementName,element).map(function(attr){return{kind:attr.fromHtml?"html attribute":"attribute",name:nameOfAttr(attr),sort:attr.name}})}function getAttributeInfosForElement(info,elementName,element){var attributes=[],htmlAttributes=attributeNames(elementName)||[];htmlAttributes&&attributes.push.apply(attributes,htmlAttributes.map(function(name){return{name:name,fromHtml:!0}}));var htmlProperties=propertyNames(elementName);htmlProperties&&attributes.push.apply(attributes,htmlProperties.map(function(name){return{name:name,input:!0}}));var htmlEvents=eventNames(elementName);htmlEvents&&attributes.push.apply(attributes,htmlEvents.map(function(name){return{name:name,output:!0}}));var _a=getSelectors(info),selectors=_a.selectors,selectorMap=_a.map;if(selectors&&selectors.length){var applicableSelectors=selectors.filter(function(selector){return!selector.element||selector.element==elementName}),selectorAndAttributeNames=applicableSelectors.map(function(selector){return{selector:selector,attrs:selector.attrs.filter(function(a){return!!a})}}),attrs_1=flatten(selectorAndAttributeNames.map(function(selectorAndAttr){var directive$$1=selectorMap.get(selectorAndAttr.selector);return selectorAndAttr.attrs.map(function(name){return{name:name,input:name in directive$$1.inputs,output:name in directive$$1.outputs}})}));selectorAndAttributeNames.forEach(function(selectorAndAttr){var selector=selectorAndAttr.selector,directive$$1=selectorMap.get(selector);directive$$1&&hasTemplateReference(directive$$1.type)&&selector.attrs.length&&selector.attrs[0]&&attrs_1.push({name:selector.attrs[0],template:!0})});var elementSelector=createElementCssSelector(element?element:new Element(elementName,[],[],null,null,null)),matcher=new SelectorMatcher;matcher.addSelectables(selectors),matcher.match(elementSelector,function(selector){var directive$$1=selectorMap.get(selector);directive$$1&&(attrs_1.push.apply(attrs_1,Object.keys(directive$$1.inputs).map(function(name){return{name:name,input:!0}})),attrs_1.push.apply(attrs_1,Object.keys(directive$$1.outputs).map(function(name){return{name:name,output:!0}})))}),attrs_1=foldAttrs(attrs_1),attributes.push.apply(attributes,flatten(attrs_1.map(expandedAttr)))}return attributes}function attributeValueCompletions(info,position,attr){var path$$1=findTemplateAstAt(info.templateAst,position),mostSpecific=path$$1.tail,dinfo=diagnosticInfoFromTemplateInfo(info);if(mostSpecific){var visitor=new ExpressionVisitor(info,position,attr,function(){return language_services_2(dinfo,path$$1,!1)});if(mostSpecific.visit(visitor,null),!visitor.result||!visitor.result.length){var widerPath_1=findTemplateAstAt(info.templateAst,position,!0);if(widerPath_1.tail){var widerVisitor=new ExpressionVisitor(info,position,attr,function(){return language_services_2(dinfo,widerPath_1,!1)});return widerPath_1.tail.visit(widerVisitor,null),widerVisitor.result}}return visitor.result}}function elementCompletions(info,path$$1){var htmlNames=elementNames().filter(function(name){return!(name in hiddenHtmlElements)}),directiveElements=getSelectors(info).selectors.map(function(selector){return selector.element}).filter(function(name){return!!name}),components=directiveElements.map(function(name){return{kind:"component",name:name,sort:name}});return uniqueByName(htmlNames.map(function(name){return{kind:"element",name:name,sort:name}}).concat(components))}function entityCompletions(value,position){for(var found,re=/&[A-Za-z]*;?(?!\d)/g,result=void 0;found=re.exec(value);){var len=found[0].length;if(position>=found.index&&position<found.index+len){result=Object.keys(NAMED_ENTITIES).map(function(name){return{kind:"entity",name:"&"+name+";",sort:name}});break}}return result}function interpolationCompletions(info,position){var templatePath=findTemplateAstAt(info.templateAst,position),mostSpecific=templatePath.tail;if(mostSpecific){var visitor=new ExpressionVisitor(info,position,void 0,function(){return language_services_2(diagnosticInfoFromTemplateInfo(info),templatePath,!1)});return mostSpecific.visit(visitor,null),uniqueByName(visitor.result)}}function voidElementAttributeCompletions(info,path$$1){var tail=path$$1.tail;if(tail instanceof Text){var match=tail.value.match(/<(\w(\w|\d|-)*:)?(\w(\w|\d|-)*)\s/);if(match&&path$$1.position>=(match.index||0)+match[0].length+tail.sourceSpan.start.offset)return attributeCompletionsForElement(info,match[3])}}function getSourceText(template,span){return template.source.substring(span.start,span.end)}function nameOfAttr(attr){var name=attr.name;attr.output&&(name=removeSuffix(name,"Events"),name=removeSuffix(name,"Changed"));var result=[name];return attr.input&&(result.unshift("["),result.push("]")),attr.output&&(result.unshift("("),result.push(")")),attr.template&&result.unshift("*"),result.join("")}function createElementCssSelector(element){var cssSelector=new CssSelector,elNameNoNs=splitNsName(element.name)[1];cssSelector.setElement(elNameNoNs);for(var _i=0,_a=element.attrs;_i<_a.length;_i++){var attr=_a[_i];if(!attr.name.match(templateAttr)){var _b=splitNsName(attr.name),attrNameNoNs=(_b[0],_b[1]);if(cssSelector.addAttribute(attrNameNoNs,attr.value),"class"==attr.name.toLowerCase()){attr.value.split(/s+/g).forEach(function(className){return cssSelector.addClassName(className)})}}}return cssSelector}function foldAttrs(attrs){var inputOutput=new Map,templates=new Map,result=[];return attrs.forEach(function(attr){if(attr.fromHtml)return attr;if(attr.template){var duplicate=templates.get(attr.name);duplicate||(result.push({name:attr.name,template:!0}),templates.set(attr.name,attr))}if(attr.input||attr.output){var duplicate=inputOutput.get(attr.name);if(duplicate)duplicate.input=duplicate.input||attr.input,duplicate.output=duplicate.output||attr.output;else{var cloneAttr={name:attr.name};attr.input&&(cloneAttr.input=!0),attr.output&&(cloneAttr.output=!0),result.push(cloneAttr),inputOutput.set(attr.name,cloneAttr)}}}),result}function expandedAttr(attr){return attr.input&&attr.output?[attr,{name:attr.name,input:!0,output:!1},{name:attr.name,input:!1,output:!0}]:[attr]}function lowerName(name){return name&&name[0].toLowerCase()+name.substr(1)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function locateSymbol(info){if(info.position){var templatePosition=info.position-info.template.span.start,path$$1=findTemplateAstAt(info.templateAst,templatePosition);if(path$$1.tail){var symbol_1=void 0,span_1=void 0,attributeValueSymbol_1=function(ast,inEvent){void 0===inEvent&&(inEvent=!1);var attribute=findAttribute(info);if(attribute&&inSpan(templatePosition,spanOf(attribute.valueSpan))){var dinfo=diagnosticInfoFromTemplateInfo(info),scope=language_services_2(dinfo,path$$1,inEvent);if(attribute.valueSpan){var expressionOffset=attribute.valueSpan.start.offset+1,result=getExpressionSymbol(scope,ast,templatePosition-expressionOffset,info.template.query);result&&(symbol_1=result.symbol,span_1=offsetSpan(result.span,expressionOffset))}return!0}return!1};if(path$$1.tail.visit({visitNgContent:function(ast){},visitEmbeddedTemplate:function(ast){},visitElement:function(ast){var component=ast.directives.find(function(d){return d.directive.isComponent});if(component)symbol_1=info.template.query.getTypeSymbol(component.directive.type.reference),symbol_1=symbol_1&&new OverrideKindSymbol(symbol_1,"component"),span_1=spanOf(ast);else{var directive$$1=ast.directives.find(function(d){return null!=d.directive.selector&&d.directive.selector.indexOf(ast.name)>=0});directive$$1&&(symbol_1=info.template.query.getTypeSymbol(directive$$1.directive.type.reference),symbol_1=symbol_1&&new OverrideKindSymbol(symbol_1,"directive"),span_1=spanOf(ast))}},visitReference:function(ast){symbol_1=ast.value&&info.template.query.getTypeSymbol(tokenReference(ast.value)),span_1=spanOf(ast)},visitVariable:function(ast){},visitEvent:function(ast){attributeValueSymbol_1(ast.handler,!0)||(symbol_1=findOutputBinding(info,path$$1,ast),symbol_1=symbol_1&&new OverrideKindSymbol(symbol_1,"event"),span_1=spanOf(ast))},visitElementProperty:function(ast){attributeValueSymbol_1(ast.value)},visitAttr:function(ast){},visitBoundText:function(ast){var expressionPosition=templatePosition-ast.sourceSpan.start.offset;if(inSpan(expressionPosition,ast.value.span)){var dinfo=diagnosticInfoFromTemplateInfo(info),scope=language_services_2(dinfo,path$$1,!1),result=getExpressionSymbol(scope,ast.value,expressionPosition,info.template.query);result&&(symbol_1=result.symbol,span_1=offsetSpan(result.span,ast.sourceSpan.start.offset))}},visitText:function(ast){},visitDirective:function(ast){symbol_1=info.template.query.getTypeSymbol(ast.directive.type.reference),span_1=spanOf(ast)},visitDirectiveProperty:function(ast){attributeValueSymbol_1(ast.value)||(symbol_1=findInputBinding(info,path$$1,ast),span_1=spanOf(ast))}},null),symbol_1&&span_1)return{symbol:symbol_1,span:offsetSpan(span_1,info.template.span.start)}}}}function findAttribute(info){if(info.position){var templatePosition=info.position-info.template.span.start;return findNode(info.htmlAst,templatePosition).first(Attribute$1)}}function findInputBinding(info,path$$1,binding){var element=path$$1.first(ElementAst);if(element)for(var _i=0,_a=element.directives;_i<_a.length;_i++){var directive$$1=_a[_i],invertedInput=invertMap(directive$$1.directive.inputs),fieldName=invertedInput[binding.templateName];if(fieldName){var classSymbol=info.template.query.getTypeSymbol(directive$$1.directive.type.reference);if(classSymbol)return classSymbol.members().get(fieldName)}}}function findOutputBinding(info,path$$1,binding){var element=path$$1.first(ElementAst);if(element)for(var _i=0,_a=element.directives;_i<_a.length;_i++){var directive$$1=_a[_i],invertedOutputs=invertMap(directive$$1.directive.outputs),fieldName=invertedOutputs[binding.name];if(fieldName){var classSymbol=info.template.query.getTypeSymbol(directive$$1.directive.type.reference);if(classSymbol)return classSymbol.members().get(fieldName)}}}function invertMap(obj){for(var result={},_i=0,_a=Object.keys(obj);_i<_a.length;_i++){var name_1=_a[_i];result[obj[name_1]]=name_1}return result}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function getDefinition(info){var result=locateSymbol(info);return result&&result.symbol.definition}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function getTemplateDiagnostics(fileName,astProvider,templates){for(var results=[],_i=0,templates_1=templates;_i<templates_1.length;_i++){var template=templates_1[_i];!function(template){var ast=astProvider.getTemplateAst(template,fileName);if(ast){if(ast.parseErrors&&ast.parseErrors.length)results.push.apply(results,ast.parseErrors.map(function(e){return{kind:DiagnosticKind.Error,span:offsetSpan(spanOf(e.span),template.span.start),message:e.msg}}));else if(ast.templateAst&&ast.htmlAst){var info={templateAst:ast.templateAst,htmlAst:ast.htmlAst,offset:template.span.start,query:template.query,members:template.members},expressionDiagnostics=language_services_3(info);results.push.apply(results,expressionDiagnostics)}ast.errors&&results.push.apply(results,ast.errors.map(function(e){return{kind:e.kind,span:e.span||template.span,message:e.message}}))}}(template)}return results}function getDeclarationDiagnostics(declarations,modules){for(var results=[],directives=void 0,_i=0,declarations_1=declarations;_i<declarations_1.length;_i++){var declaration=declarations_1[_i];!function(declaration){for(var report=function(message,span){results.push({kind:DiagnosticKind.Error,span:span||declaration.declarationSpan,message:message})},_i=0,_a=declaration.errors;_i<_a.length;_i++){var error=_a[_i];report(error.message,error.span)}if(declaration.metadata)if(declaration.metadata.isComponent){modules.ngModuleByPipeOrDirective.has(declaration.type)||report("Component '"+declaration.type.name+"' is not included in a module and will not be available inside a template. Consider adding it to a NgModule declaration");var _b=declaration.metadata.template,template=_b.template,templateUrl=_b.templateUrl;null!==template||templateUrl?template&&templateUrl&&report("Component '"+declaration.type.name+"' must not have both template and templateUrl"):report("Component '"+declaration.type.name+"' must have a template or templateUrl")}else directives||(directives=new Set,modules.ngModules.forEach(function(module){module.declaredDirectives.forEach(function(directive$$1){directives.add(directive$$1.reference)})})),directives.has(declaration.type)||report("Directive '"+declaration.type.name+"' is not included in a module and will not be available inside a template. Consider adding it to a NgModule declaration")}(declaration)}return results}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function getHover(info){var result=locateSymbol(info);if(result)return{text:hoverTextOf(result.symbol),span:result.span}}function hoverTextOf(symbol){var result=[{text:symbol.kind},{text:" "},{text:symbol.name,language:symbol.language}],container=symbol.container;return container&&result.push({text:" of "},{text:container.name,language:container.language}),result}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createLanguageService(host){return new LanguageServiceImpl(host)}function removeMissing(values){return values.filter(function(e){return!!e})}function uniqueBySpan(elements){if(elements){for(var result=[],map=new Map,_i=0,elements_1=elements;_i<elements_1.length;_i++){var element=elements_1[_i],span=element.span,set=map.get(span.start);set||(set=new Set,map.set(span.start,set)),set.has(span.end)||(set.add(span.end),result.push(element))}return result}}function findSuitableDefaultModule(modules){for(var result=void 0,resultSize=0,_i=0,_a=modules.ngModules;_i<_a.length;_i++){var module_1=_a[_i],moduleSize=module_1.transitiveModule.directives.length;moduleSize>resultSize&&(result=module_1,resultSize=moduleSize)}return result}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createLanguageServiceFromTypescript(host,service){var ngHost=new TypeScriptServiceHost(host,service),ngServer=createLanguageService(ngHost);return ngHost.setSite(ngServer),ngServer}function findTsConfig(fileName){for(var dir=path.dirname(fileName);fs.existsSync(dir);){var candidate=path.join(dir,"tsconfig.json");if(fs.existsSync(candidate))return candidate;var parentDir=path.dirname(dir);if(parentDir===dir)break;dir=parentDir}}function spanOf$1(node){return{start:node.getStart(),end:node.getEnd()}}function shrink(span,offset){return null==offset&&(offset=1),{start:span.start+offset,end:span.end-offset}}function spanAt(sourceFile,line,column){if(null!=line&&null!=column){var position_1=ts.getPositionOfLineAndCharacter(sourceFile,line,column),findChild=function findChild(node){if(node.kind>ts.SyntaxKind.LastToken&&node.pos<=position_1&&node.end>position_1){return ts.forEachChild(node,findChild)||node}},node=ts.forEachChild(sourceFile,findChild);if(node)return{start:node.getStart(),end:node.getEnd()}}}function convertChain(chain){return{message:chain.message,next:chain.next?convertChain(chain.next):void 0}}function errorToDiagnosticWithChain(error,span){return{message:error.chain?convertChain(error.chain):error.message,span:span}}function getExternalFiles(project){var host=projectHostMap.get(project);if(host)return host.getTemplateReferences()}function angularOnlyFilter(ls){return{cleanupSemanticCache:function(){return ls.cleanupSemanticCache()},getSyntacticDiagnostics:function(fileName){return[]},getSemanticDiagnostics:function(fileName){return[]},getCompilerOptionsDiagnostics:function(){return[]},getSyntacticClassifications:function(fileName,span){return[]},getSemanticClassifications:function(fileName,span){return[]},getEncodedSyntacticClassifications:function(fileName,span){return{undefined:void 0}},getEncodedSemanticClassifications:function(fileName,span){},getCompletionsAtPosition:function(fileName,position){},getCompletionEntryDetails:function(fileName,position,entryName){},getCompletionEntrySymbol:function(fileName,position,entryName){},getQuickInfoAtPosition:function(fileName,position){},getNameOrDottedNameSpan:function(fileName,startPos,endPos){},getBreakpointStatementAtPosition:function(fileName,position){},getSignatureHelpItems:function(fileName,position){},getRenameInfo:function(fileName,position){},findRenameLocations:function(fileName,position,findInStrings,findInComments){return[]},getDefinitionAtPosition:function(fileName,position){return[]},getTypeDefinitionAtPosition:function(fileName,position){return[]},getImplementationAtPosition:function(fileName,position){return[]},getReferencesAtPosition:function(fileName,position){return[]},findReferences:function(fileName,position){return[]},getDocumentHighlights:function(fileName,position,filesToSearch){return[]},getOccurrencesAtPosition:function(fileName,position){return[]},getNavigateToItems:function(searchValue){return[]},getNavigationBarItems:function(fileName){return[]},getNavigationTree:function(fileName){},getOutliningSpans:function(fileName){return[]},getTodoComments:function(fileName,descriptors){return[]},getBraceMatchingAtPosition:function(fileName,position){return[]},getIndentationAtPosition:function(fileName,position,options){},getFormattingEditsForRange:function(fileName,start,end,options){return[]},getFormattingEditsForDocument:function(fileName,options){return[]},getFormattingEditsAfterKeystroke:function(fileName,position,key,options){return[]},getDocCommentTemplateAtPosition:function(fileName,position){},isValidBraceCompletionAtPosition:function(fileName,position,openingBrace){},getSpanOfEnclosingComment:function(fileName,position,onlyMultiLine){},getCodeFixesAtPosition:function(fileName,start,end,errorCodes){return[]},applyCodeActionCommand:function(action){return Promise.resolve(void 0)},getEmitOutput:function(fileName){},getProgram:function(){return ls.getProgram()},dispose:function(){return ls.dispose()},getApplicableRefactors:function(fileName,positionOrRaneg){return[]},getEditsForRefactor:function(fileName,formatOptions,positionOrRange,refactorName,actionName){}}}function create(info){function tryCall(fileName,callback){if(!fileName||oldLS.getProgram().getSourceFile(fileName))try{return callback()}catch(e){return}}function tryFilenameCall(m){return function(fileName){return tryCall(fileName,function(){return m.call(ls,fileName)})}}function tryFilenameOneCall(m){return function(fileName,p){return tryCall(fileName,function(){return m.call(ls,fileName,p)})}}function tryFilenameTwoCall(m){return function(fileName,p1,p2){return tryCall(fileName,function(){return m.call(ls,fileName,p1,p2)})}}function tryFilenameThreeCall(m){return function(fileName,p1,p2,p3){return tryCall(fileName,function(){return m.call(ls,fileName,p1,p2,p3)})}}function tryFilenameFourCall(m){return function(fileName,p1,p2,p3,p4){return tryCall(fileName,function(){return m.call(ls,fileName,p1,p2,p3,p4)})}}function completionToEntry(c){return{kind:c.kind,name:c.name,sortText:c.sort,kindModifiers:""}}function diagnosticChainToDiagnosticChain(chain){return{messageText:chain.message,category:ts.DiagnosticCategory.Error,code:0,next:chain.next?diagnosticChainToDiagnosticChain(chain.next):void 0}}function diagnosticMessageToDiagnosticMessageText(message){return"string"==typeof message?message:diagnosticChainToDiagnosticChain(message)}function diagnosticToDiagnostic(d,file){return{file:file,start:d.span.start,length:d.span.end-d.span.start,messageText:diagnosticMessageToDiagnosticMessageText(d.message),category:ts.DiagnosticCategory.Error,code:0,source:"ng"}}function tryOperation(attempting,callback){try{return callback()}catch(e){return info.project.projectService.logger.info("Failed to "+attempting+": "+e.toString()),info.project.projectService.logger.info("Stack trace: "+e.stack),null}}var proxy=Object.create(null),oldLS=info.languageService;angularOnlyResults&&(oldLS=angularOnlyFilter(oldLS)),oldLS=function(ls){return{cleanupSemanticCache:function(){return ls.cleanupSemanticCache()},getSyntacticDiagnostics:tryFilenameCall(ls.getSyntacticDiagnostics),getSemanticDiagnostics:tryFilenameCall(ls.getSemanticDiagnostics),getCompilerOptionsDiagnostics:function(){return ls.getCompilerOptionsDiagnostics()},getSyntacticClassifications:tryFilenameOneCall(ls.getSemanticClassifications),getSemanticClassifications:tryFilenameOneCall(ls.getSemanticClassifications),getEncodedSyntacticClassifications:tryFilenameOneCall(ls.getEncodedSyntacticClassifications),getEncodedSemanticClassifications:tryFilenameOneCall(ls.getEncodedSemanticClassifications),getCompletionsAtPosition:tryFilenameTwoCall(ls.getCompletionsAtPosition),getCompletionEntryDetails:tryFilenameFourCall(ls.getCompletionEntryDetails),getCompletionEntrySymbol:tryFilenameThreeCall(ls.getCompletionEntrySymbol),getQuickInfoAtPosition:tryFilenameOneCall(ls.getQuickInfoAtPosition),getNameOrDottedNameSpan:tryFilenameTwoCall(ls.getNameOrDottedNameSpan),getBreakpointStatementAtPosition:tryFilenameOneCall(ls.getBreakpointStatementAtPosition),getSignatureHelpItems:tryFilenameOneCall(ls.getSignatureHelpItems),getRenameInfo:tryFilenameOneCall(ls.getRenameInfo),findRenameLocations:tryFilenameThreeCall(ls.findRenameLocations),getDefinitionAtPosition:tryFilenameOneCall(ls.getDefinitionAtPosition),getTypeDefinitionAtPosition:tryFilenameOneCall(ls.getTypeDefinitionAtPosition),getImplementationAtPosition:tryFilenameOneCall(ls.getImplementationAtPosition),getReferencesAtPosition:tryFilenameOneCall(ls.getReferencesAtPosition),findReferences:tryFilenameOneCall(ls.findReferences),getDocumentHighlights:tryFilenameTwoCall(ls.getDocumentHighlights),getOccurrencesAtPosition:tryFilenameOneCall(ls.getOccurrencesAtPosition),getNavigateToItems:function(searchValue,maxResultCount,fileName,excludeDtsFiles){return tryCall(fileName,function(){return ls.getNavigateToItems(searchValue,maxResultCount,fileName,excludeDtsFiles)})},getNavigationBarItems:tryFilenameCall(ls.getNavigationBarItems),getNavigationTree:tryFilenameCall(ls.getNavigationTree),getOutliningSpans:tryFilenameCall(ls.getOutliningSpans),getTodoComments:tryFilenameOneCall(ls.getTodoComments),getBraceMatchingAtPosition:tryFilenameOneCall(ls.getBraceMatchingAtPosition),getIndentationAtPosition:tryFilenameTwoCall(ls.getIndentationAtPosition),getFormattingEditsForRange:tryFilenameThreeCall(ls.getFormattingEditsForRange),getFormattingEditsForDocument:tryFilenameOneCall(ls.getFormattingEditsForDocument),getFormattingEditsAfterKeystroke:tryFilenameThreeCall(ls.getFormattingEditsAfterKeystroke),getDocCommentTemplateAtPosition:tryFilenameOneCall(ls.getDocCommentTemplateAtPosition),isValidBraceCompletionAtPosition:tryFilenameTwoCall(ls.isValidBraceCompletionAtPosition),getSpanOfEnclosingComment:tryFilenameTwoCall(ls.getSpanOfEnclosingComment),getCodeFixesAtPosition:tryFilenameFourCall(ls.getCodeFixesAtPosition),applyCodeActionCommand:function(action){return tryCall(void 0,function(){return ls.applyCodeActionCommand(action)})},getEmitOutput:tryFilenameCall(ls.getEmitOutput),getProgram:function(){return ls.getProgram()},dispose:function(){return ls.dispose()},getApplicableRefactors:tryFilenameOneCall(ls.getApplicableRefactors),getEditsForRefactor:tryFilenameFourCall(ls.getEditsForRefactor)}}(oldLS);for(var k in oldLS)!function(k){proxy[k]=function(){return oldLS[k].apply(oldLS,arguments)}}(k);var serviceHost=new TypeScriptServiceHost(info.languageServiceHost,info.languageService),ls=createLanguageService(serviceHost);return serviceHost.setSite(ls),projectHostMap.set(info.project,serviceHost),proxy.getCompletionsAtPosition=function(fileName,position,options){var base=oldLS.getCompletionsAtPosition(fileName,position,options)||{isGlobalCompletion:!1,isMemberCompletion:!1,isNewIdentifierLocation:!1,entries:[]};return tryOperation("get completions",function(){var results=ls.getCompletionsAt(fileName,position);if(results&&results.length){void 0===base&&(base={isGlobalCompletion:!1,isMemberCompletion:!1,isNewIdentifierLocation:!1,entries:[]});for(var _i=0,results_1=results;_i<results_1.length;_i++){var entry=results_1[_i];base.entries.push(completionToEntry(entry))}}}),base},proxy.getQuickInfoAtPosition=function(fileName,position){var base=oldLS.getQuickInfoAtPosition(fileName,position);return tryOperation("get quick info",function(){var ours=ls.getHoverAt(fileName,position);if(ours){for(var displayParts=[],_i=0,_a=ours.text;_i<_a.length;_i++){var part=_a[_i];displayParts.push({kind:part.language||"angular",text:part.text})}var tags=base&&base.tags;base={displayParts:displayParts,documentation:[],kind:"angular",kindModifiers:"what does this do?",textSpan:{start:ours.span.start,length:ours.span.end-ours.span.start}},tags&&(base.tags=tags)}}),base},proxy.getSemanticDiagnostics=function(fileName){var result=oldLS.getSemanticDiagnostics(fileName),base=result||[];return tryOperation("get diagnostics",function(){info.project.projectService.logger.info("Computing Angular semantic diagnostics...");var ours=ls.getDiagnostics(fileName);if(ours&&ours.length){var file_1=oldLS.getProgram().getSourceFile(fileName);base.push.apply(base,ours.map(function(d){return diagnosticToDiagnostic(d,file_1)}))}}),base},proxy.getDefinitionAtPosition=function(fileName,position){var base=oldLS.getDefinitionAtPosition(fileName,position);return base&&base.length?base:tryOperation("get definition",function(){var ours=ls.getDefinitionAt(fileName,position);if(ours&&ours.length){base=base||[];for(var _i=0,ours_1=ours;_i<ours_1.length;_i++){var loc=ours_1[_i];base.push({fileName:loc.fileName,textSpan:{start:loc.span.start,length:loc.span.end-loc.span.start},name:"",kind:"definition",containerName:loc.fileName,containerKind:"file"})}}return base})||[]},proxy}var fs__default="default"in fs?fs.default:fs,path__default="default"in path?path.default:path,ts__default="default"in ts?ts.default:ts,extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])},__assign=Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)Object.prototype.hasOwnProperty.call(s,p)&&(t[p]=s[p])}return t},createInject=makeMetadataFactory("Inject",function(token){return{token:token}}),createInjectionToken=makeMetadataFactory("InjectionToken",function(desc){return{_desc:desc}}),createAttribute=makeMetadataFactory("Attribute",function(attributeName){return{attributeName:attributeName}}),createContentChildren=makeMetadataFactory("ContentChildren",function(selector,data){return void 0===data&&(data={}),__assign({selector:selector,first:!1,isViewQuery:!1,descendants:!1},data)}),createContentChild=makeMetadataFactory("ContentChild",function(selector,data){return void 0===data&&(data={}),__assign({selector:selector,first:!0,isViewQuery:!1,descendants:!0},data)}),createViewChildren=makeMetadataFactory("ViewChildren",function(selector,data){return void 0===data&&(data={}),__assign({selector:selector,first:!1,isViewQuery:!0,descendants:!0},data)}),createViewChild=makeMetadataFactory("ViewChild",function(selector,data){return __assign({selector:selector,first:!0,isViewQuery:!0,descendants:!0},data)}),createDirective=makeMetadataFactory("Directive",function(dir){return void 0===dir&&(dir={}),dir}),ViewEncapsulation={Emulated:0,Native:1,None:2};ViewEncapsulation[ViewEncapsulation.Emulated]="Emulated",ViewEncapsulation[ViewEncapsulation.Native]="Native",ViewEncapsulation[ViewEncapsulation.None]="None";var ChangeDetectionStrategy={OnPush:0,Default:1};ChangeDetectionStrategy[ChangeDetectionStrategy.OnPush]="OnPush",ChangeDetectionStrategy[ChangeDetectionStrategy.Default]="Default";var createComponent=makeMetadataFactory("Component",function(c){return void 0===c&&(c={}),__assign({changeDetection:ChangeDetectionStrategy.Default},c)}),createPipe=makeMetadataFactory("Pipe",function(p){return __assign({pure:!0},p)}),createInput=makeMetadataFactory("Input",function(bindingPropertyName){return{bindingPropertyName:bindingPropertyName}}),createOutput=makeMetadataFactory("Output",function(bindingPropertyName){return{bindingPropertyName:bindingPropertyName}}),createHostBinding=makeMetadataFactory("HostBinding",function(hostPropertyName){return{hostPropertyName:hostPropertyName}}),createHostListener=makeMetadataFactory("HostListener",function(eventName,args){return{eventName:eventName,args:args}}),createNgModule=makeMetadataFactory("NgModule",function(ngModule){return ngModule}),CUSTOM_ELEMENTS_SCHEMA={name:"custom-elements"},NO_ERRORS_SCHEMA={name:"no-errors-schema"},createOptional=makeMetadataFactory("Optional"),createInjectable=makeMetadataFactory("Injectable"),createSelf=makeMetadataFactory("Self"),createSkipSelf=makeMetadataFactory("SkipSelf"),createHost=makeMetadataFactory("Host"),Type=Function,SecurityContext={NONE:0,HTML:1,STYLE:2,SCRIPT:3,URL:4,RESOURCE_URL:5};SecurityContext[SecurityContext.NONE]="NONE",SecurityContext[SecurityContext.HTML]="HTML",SecurityContext[SecurityContext.STYLE]="STYLE",SecurityContext[SecurityContext.SCRIPT]="SCRIPT",SecurityContext[SecurityContext.URL]="URL",SecurityContext[SecurityContext.RESOURCE_URL]="RESOURCE_URL";var NodeFlags={None:0,TypeElement:1,TypeText:2,ProjectedTemplate:4,CatRenderNode:3,TypeNgContent:8,TypePipe:16,TypePureArray:32,TypePureObject:64,TypePurePipe:128,CatPureExpression:224,TypeValueProvider:256,TypeClassProvider:512,TypeFactoryProvider:1024,TypeUseExistingProvider:2048,LazyProvider:4096,PrivateProvider:8192,TypeDirective:16384,Component:32768,CatProviderNoDirective:3840,CatProvider:20224,OnInit:65536,OnDestroy:131072,DoCheck:262144,OnChanges:524288,AfterContentInit:1048576,AfterContentChecked:2097152,AfterViewInit:4194304,AfterViewChecked:8388608,EmbeddedViews:16777216,ComponentView:33554432,TypeContentQuery:67108864,TypeViewQuery:134217728,StaticQuery:268435456,DynamicQuery:536870912,CatQuery:201326592,Types:201347067},DepFlags={None:0,SkipSelf:1,Optional:2,Value:8},ArgumentType={Inline:0,Dynamic:1},BindingFlags={TypeElementAttribute:1,TypeElementClass:2,TypeElementStyle:4,TypeProperty:8,SyntheticProperty:16,SyntheticHostProperty:32,CatSyntheticProperty:48,Types:15},QueryBindingType={First:0,All:1},QueryValueType={ElementRef:0,RenderElement:1,TemplateRef:2,ViewContainerRef:3,Provider:4},ViewFlags={None:0,OnPush:2},MissingTranslationStrategy={Error:0,Warning:1,Ignore:2};MissingTranslationStrategy[MissingTranslationStrategy.Error]="Error",MissingTranslationStrategy[MissingTranslationStrategy.Warning]="Warning",MissingTranslationStrategy[MissingTranslationStrategy.Ignore]="Ignore";var core=Object.freeze({Inject:Inject,createInject:createInject,createInjectionToken:createInjectionToken,Attribute:Attribute,createAttribute:createAttribute,Query:Query,createContentChildren:createContentChildren,createContentChild:createContentChild,createViewChildren:createViewChildren,createViewChild:createViewChild,Directive:Directive,createDirective:createDirective,Component:Component,ViewEncapsulation:ViewEncapsulation,ChangeDetectionStrategy:ChangeDetectionStrategy,createComponent:createComponent,Pipe:Pipe,createPipe:createPipe,Input:Input,createInput:createInput,Output:Output,createOutput:createOutput,HostBinding:HostBinding,createHostBinding:createHostBinding,HostListener:HostListener,createHostListener:createHostListener,NgModule:NgModule,createNgModule:createNgModule,ModuleWithProviders:ModuleWithProviders,SchemaMetadata:SchemaMetadata,CUSTOM_ELEMENTS_SCHEMA:CUSTOM_ELEMENTS_SCHEMA,NO_ERRORS_SCHEMA:NO_ERRORS_SCHEMA,createOptional:createOptional,createInjectable:createInjectable,createSelf:createSelf,createSkipSelf:createSkipSelf,createHost:createHost,Type:Type,SecurityContext:SecurityContext,NodeFlags:NodeFlags,DepFlags:DepFlags,ArgumentType:ArgumentType,BindingFlags:BindingFlags,QueryBindingType:QueryBindingType,QueryValueType:QueryValueType,ViewFlags:ViewFlags,MissingTranslationStrategy:MissingTranslationStrategy,MetadataFactory:MetadataFactory,Route:Route}),DASH_CASE_REGEXP=/-+([a-z0-9])/g,ValueTransformer=function(){function ValueTransformer(){}return ValueTransformer.prototype.visitArray=function(arr,context){var _this=this;return arr.map(function(value){return visitValue(value,_this,context)})},ValueTransformer.prototype.visitStringMap=function(map,context){var _this=this,result={};return Object.keys(map).forEach(function(key){result[key]=visitValue(map[key],_this,context)}),result},ValueTransformer.prototype.visitPrimitive=function(value,context){return value},ValueTransformer.prototype.visitOther=function(value,context){return value},ValueTransformer}(),SyncAsync={assertSync:function(value){if(isPromise(value))throw new Error("Illegal state: value cannot be a promise");return value},then:function(value,cb){return isPromise(value)?value.then(cb):cb(value)},all:function(syncAsyncValues){return syncAsyncValues.some(isPromise)?Promise.all(syncAsyncValues):syncAsyncValues}},ERROR_SYNTAX_ERROR="ngSyntaxError",ERROR_PARSE_ERRORS="ngParseErrors",STRING_MAP_PROTO=Object.getPrototypeOf({}),Version=function(){function Version(full){this.full=full;var splits=full.split(".");this.major=splits[0],this.minor=splits[1],this.patch=splits.slice(2).join(".")}return Version}(),VERSION$1=new Version("5.2.11"),TextAst=function(){function TextAst(value,ngContentIndex,sourceSpan){this.value=value,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return TextAst.prototype.visit=function(visitor,context){return visitor.visitText(this,context)},TextAst}(),BoundTextAst=function(){function BoundTextAst(value,ngContentIndex,sourceSpan){this.value=value,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return BoundTextAst.prototype.visit=function(visitor,context){return visitor.visitBoundText(this,context)},BoundTextAst}(),AttrAst=function(){function AttrAst(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return AttrAst.prototype.visit=function(visitor,context){return visitor.visitAttr(this,context)},AttrAst}(),BoundElementPropertyAst=function(){function BoundElementPropertyAst(name,type,securityContext,value,unit,sourceSpan){this.name=name,this.type=type,this.securityContext=securityContext,this.value=value,this.unit=unit,this.sourceSpan=sourceSpan,this.isAnimation=this.type===PropertyBindingType.Animation}return BoundElementPropertyAst.prototype.visit=function(visitor,context){return visitor.visitElementProperty(this,context)},BoundElementPropertyAst}(),BoundEventAst=function(){function BoundEventAst(name,target,phase,handler,sourceSpan){this.name=name,this.target=target,this.phase=phase,this.handler=handler,this.sourceSpan=sourceSpan,this.fullName=BoundEventAst.calcFullName(this.name,this.target,this.phase),this.isAnimation=!!this.phase}return BoundEventAst.calcFullName=function(name,target,phase){return target?target+":"+name:phase?"@"+name+"."+phase:name},BoundEventAst.prototype.visit=function(visitor,context){return visitor.visitEvent(this,context)},BoundEventAst}(),ReferenceAst=function(){function ReferenceAst(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return ReferenceAst.prototype.visit=function(visitor,context){return visitor.visitReference(this,context)},ReferenceAst}(),VariableAst=function(){function VariableAst(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return VariableAst.prototype.visit=function(visitor,context){return visitor.visitVariable(this,context)},VariableAst}(),ElementAst=function(){function ElementAst(name,attrs,inputs,outputs,references,directives,providers,hasViewContainer,queryMatches,children,ngContentIndex,sourceSpan,endSourceSpan){this.name=name,this.attrs=attrs,this.inputs=inputs,this.outputs=outputs,this.references=references,this.directives=directives,this.providers=providers,this.hasViewContainer=hasViewContainer,this.queryMatches=queryMatches,this.children=children,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan,this.endSourceSpan=endSourceSpan}return ElementAst.prototype.visit=function(visitor,context){return visitor.visitElement(this,context)},ElementAst}(),EmbeddedTemplateAst=function(){function EmbeddedTemplateAst(attrs,outputs,references,variables,directives,providers,hasViewContainer,queryMatches,children,ngContentIndex,sourceSpan){this.attrs=attrs,this.outputs=outputs,this.references=references,this.variables=variables,this.directives=directives,this.providers=providers,this.hasViewContainer=hasViewContainer,this.queryMatches=queryMatches,this.children=children,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return EmbeddedTemplateAst.prototype.visit=function(visitor,context){return visitor.visitEmbeddedTemplate(this,context)},EmbeddedTemplateAst}(),BoundDirectivePropertyAst=function(){function BoundDirectivePropertyAst(directiveName,templateName,value,sourceSpan){this.directiveName=directiveName,this.templateName=templateName,this.value=value,this.sourceSpan=sourceSpan}return BoundDirectivePropertyAst.prototype.visit=function(visitor,context){return visitor.visitDirectiveProperty(this,context)},BoundDirectivePropertyAst}(),DirectiveAst=function(){function DirectiveAst(directive,inputs,hostProperties,hostEvents,contentQueryStartId,sourceSpan){this.directive=directive,this.inputs=inputs,this.hostProperties=hostProperties,this.hostEvents=hostEvents,this.contentQueryStartId=contentQueryStartId,this.sourceSpan=sourceSpan}return DirectiveAst.prototype.visit=function(visitor,context){return visitor.visitDirective(this,context)},DirectiveAst}(),ProviderAst=function(){function ProviderAst(token,multiProvider,eager,providers,providerType,lifecycleHooks,sourceSpan){this.token=token,this.multiProvider=multiProvider,this.eager=eager,this.providers=providers,this.providerType=providerType,this.lifecycleHooks=lifecycleHooks,this.sourceSpan=sourceSpan}return ProviderAst.prototype.visit=function(visitor,context){return null},ProviderAst}(),ProviderAstType={PublicService:0,PrivateService:1,Component:2,Directive:3,Builtin:4};ProviderAstType[ProviderAstType.PublicService]="PublicService",ProviderAstType[ProviderAstType.PrivateService]="PrivateService",ProviderAstType[ProviderAstType.Component]="Component",ProviderAstType[ProviderAstType.Directive]="Directive",ProviderAstType[ProviderAstType.Builtin]="Builtin";var NgContentAst=function(){function NgContentAst(index,ngContentIndex,sourceSpan){this.index=index,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return NgContentAst.prototype.visit=function(visitor,context){return visitor.visitNgContent(this,context)},NgContentAst}(),PropertyBindingType={Property:0,Attribute:1,Class:2,Style:3,Animation:4};PropertyBindingType[PropertyBindingType.Property]="Property",PropertyBindingType[PropertyBindingType.Attribute]="Attribute",PropertyBindingType[PropertyBindingType.Class]="Class",PropertyBindingType[PropertyBindingType.Style]="Style",PropertyBindingType[PropertyBindingType.Animation]="Animation";var NullTemplateVisitor=function(){function NullTemplateVisitor(){}return NullTemplateVisitor.prototype.visitNgContent=function(ast,context){},NullTemplateVisitor.prototype.visitEmbeddedTemplate=function(ast,context){},NullTemplateVisitor.prototype.visitElement=function(ast,context){},NullTemplateVisitor.prototype.visitReference=function(ast,context){},NullTemplateVisitor.prototype.visitVariable=function(ast,context){},NullTemplateVisitor.prototype.visitEvent=function(ast,context){},NullTemplateVisitor.prototype.visitElementProperty=function(ast,context){},NullTemplateVisitor.prototype.visitAttr=function(ast,context){},NullTemplateVisitor.prototype.visitBoundText=function(ast,context){},NullTemplateVisitor.prototype.visitText=function(ast,context){},NullTemplateVisitor.prototype.visitDirective=function(ast,context){},NullTemplateVisitor.prototype.visitDirectiveProperty=function(ast,context){},NullTemplateVisitor}(),RecursiveTemplateAstVisitor=function(_super){function RecursiveTemplateAstVisitor(){return _super.call(this)||this}return __extends(RecursiveTemplateAstVisitor,_super),RecursiveTemplateAstVisitor.prototype.visitEmbeddedTemplate=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.references),visit(ast.variables),visit(ast.directives),visit(ast.providers),visit(ast.children)})},RecursiveTemplateAstVisitor.prototype.visitElement=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.inputs),visit(ast.outputs),visit(ast.references),visit(ast.directives),visit(ast.providers),visit(ast.children)})},RecursiveTemplateAstVisitor.prototype.visitDirective=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.inputs),visit(ast.hostProperties),visit(ast.hostEvents)})},RecursiveTemplateAstVisitor.prototype.visitChildren=function(context,cb){function visit(children){children&&children.length&&results.push(templateVisitAll(t,children,context))}var results=[],t=this;return cb(visit),[].concat.apply([],results)},RecursiveTemplateAstVisitor}(NullTemplateVisitor),CompilerConfig=function(){function CompilerConfig(_a){var _b=void 0===_a?{}:_a,_c=_b.defaultEncapsulation,defaultEncapsulation=void 0===_c?ViewEncapsulation.Emulated:_c,_d=_b.useJit,useJit=void 0===_d||_d,_e=_b.jitDevMode,jitDevMode=void 0!==_e&&_e,_f=_b.missingTranslation,missingTranslation=void 0===_f?null:_f,enableLegacyTemplate=_b.enableLegacyTemplate,preserveWhitespaces=_b.preserveWhitespaces,strictInjectionParameters=_b.strictInjectionParameters;this.defaultEncapsulation=defaultEncapsulation,this.useJit=!!useJit,this.jitDevMode=!!jitDevMode,this.missingTranslation=missingTranslation,this.enableLegacyTemplate=!0===enableLegacyTemplate,this.preserveWhitespaces=preserveWhitespacesDefault(noUndefined(preserveWhitespaces)),this.strictInjectionParameters=!0===strictInjectionParameters}return CompilerConfig}(),StaticSymbol=function(){function StaticSymbol(filePath,name,members){this.filePath=filePath,this.name=name,this.members=members}return StaticSymbol.prototype.assertNoMembers=function(){if(this.members.length)throw new Error("Illegal state: symbol without members expected, but got "+JSON.stringify(this)+".")},StaticSymbol}(),StaticSymbolCache=function(){function StaticSymbolCache(){this.cache=new Map}return StaticSymbolCache.prototype.get=function(declarationFile,name,members){members=members||[];var memberSuffix=members.length?"."+members.join("."):"",key='"'+declarationFile+'".'+name+memberSuffix,result=this.cache.get(key);return result||(result=new StaticSymbol(declarationFile,name,members),this.cache.set(key,result)),result},StaticSymbolCache}(),HOST_REG_EXP=/^(?:(?:\[([^\]]+)\])|(?:\(([^\)]+)\)))|(\@[-\w]+)$/,_anonymousTypeIndex=0,CompileSummaryKind={Pipe:0,Directive:1,NgModule:2,Injectable:3};CompileSummaryKind[CompileSummaryKind.Pipe]="Pipe",CompileSummaryKind[CompileSummaryKind.Directive]="Directive",CompileSummaryKind[CompileSummaryKind.NgModule]="NgModule",CompileSummaryKind[CompileSummaryKind.Injectable]="Injectable";var CompileStylesheetMetadata=function(){function CompileStylesheetMetadata(_a){var _b=void 0===_a?{}:_a,moduleUrl=_b.moduleUrl,styles=_b.styles,styleUrls=_b.styleUrls;this.moduleUrl=moduleUrl||null,this.styles=_normalizeArray(styles),this.styleUrls=_normalizeArray(styleUrls)}return CompileStylesheetMetadata}(),CompileTemplateMetadata=function(){function CompileTemplateMetadata(_a){var encapsulation=_a.encapsulation,template=_a.template,templateUrl=_a.templateUrl,htmlAst=_a.htmlAst,styles=_a.styles,styleUrls=_a.styleUrls,externalStylesheets=_a.externalStylesheets,animations=_a.animations,ngContentSelectors=_a.ngContentSelectors,interpolation=_a.interpolation,isInline=_a.isInline,preserveWhitespaces=_a.preserveWhitespaces;if(this.encapsulation=encapsulation,this.template=template,this.templateUrl=templateUrl,this.htmlAst=htmlAst,this.styles=_normalizeArray(styles),this.styleUrls=_normalizeArray(styleUrls),this.externalStylesheets=_normalizeArray(externalStylesheets),this.animations=animations?flatten$1(animations):[],this.ngContentSelectors=ngContentSelectors||[],interpolation&&2!=interpolation.length)throw new Error("'interpolation' should have a start and an end symbol.");this.interpolation=interpolation,this.isInline=isInline,this.preserveWhitespaces=preserveWhitespaces}return CompileTemplateMetadata.prototype.toSummary=function(){return{ngContentSelectors:this.ngContentSelectors,encapsulation:this.encapsulation}},CompileTemplateMetadata}(),CompileDirectiveMetadata=function(){function CompileDirectiveMetadata(_a){var isHost=_a.isHost,type=_a.type,isComponent=_a.isComponent,selector=_a.selector,exportAs=_a.exportAs,changeDetection=_a.changeDetection,inputs=_a.inputs,outputs=_a.outputs,hostListeners=_a.hostListeners,hostProperties=_a.hostProperties,hostAttributes=_a.hostAttributes,providers=_a.providers,viewProviders=_a.viewProviders,queries=_a.queries,guards=_a.guards,viewQueries=_a.viewQueries,entryComponents=_a.entryComponents,template=_a.template,componentViewType=_a.componentViewType,rendererType=_a.rendererType,componentFactory=_a.componentFactory;this.isHost=!!isHost,this.type=type,this.isComponent=isComponent,this.selector=selector,this.exportAs=exportAs,this.changeDetection=changeDetection,this.inputs=inputs,this.outputs=outputs,this.hostListeners=hostListeners,this.hostProperties=hostProperties,this.hostAttributes=hostAttributes,this.providers=_normalizeArray(providers),this.viewProviders=_normalizeArray(viewProviders),this.queries=_normalizeArray(queries),this.guards=guards,this.viewQueries=_normalizeArray(viewQueries),this.entryComponents=_normalizeArray(entryComponents),this.template=template,this.componentViewType=componentViewType,this.rendererType=rendererType,this.componentFactory=componentFactory}return CompileDirectiveMetadata.create=function(_a){
var isHost=_a.isHost,type=_a.type,isComponent=_a.isComponent,selector=_a.selector,exportAs=_a.exportAs,changeDetection=_a.changeDetection,inputs=_a.inputs,outputs=_a.outputs,host=_a.host,providers=_a.providers,viewProviders=_a.viewProviders,queries=_a.queries,guards=_a.guards,viewQueries=_a.viewQueries,entryComponents=_a.entryComponents,template=_a.template,componentViewType=_a.componentViewType,rendererType=_a.rendererType,componentFactory=_a.componentFactory,hostListeners={},hostProperties={},hostAttributes={};null!=host&&Object.keys(host).forEach(function(key){var value=host[key],matches=key.match(HOST_REG_EXP);null===matches?hostAttributes[key]=value:null!=matches[1]?hostProperties[matches[1]]=value:null!=matches[2]&&(hostListeners[matches[2]]=value)});var inputsMap={};null!=inputs&&inputs.forEach(function(bindConfig){var parts=splitAtColon(bindConfig,[bindConfig,bindConfig]);inputsMap[parts[0]]=parts[1]});var outputsMap={};return null!=outputs&&outputs.forEach(function(bindConfig){var parts=splitAtColon(bindConfig,[bindConfig,bindConfig]);outputsMap[parts[0]]=parts[1]}),new CompileDirectiveMetadata({isHost:isHost,type:type,isComponent:!!isComponent,selector:selector,exportAs:exportAs,changeDetection:changeDetection,inputs:inputsMap,outputs:outputsMap,hostListeners:hostListeners,hostProperties:hostProperties,hostAttributes:hostAttributes,providers:providers,viewProviders:viewProviders,queries:queries,guards:guards,viewQueries:viewQueries,entryComponents:entryComponents,template:template,componentViewType:componentViewType,rendererType:rendererType,componentFactory:componentFactory})},CompileDirectiveMetadata.prototype.toSummary=function(){return{summaryKind:CompileSummaryKind.Directive,type:this.type,isComponent:this.isComponent,selector:this.selector,exportAs:this.exportAs,inputs:this.inputs,outputs:this.outputs,hostListeners:this.hostListeners,hostProperties:this.hostProperties,hostAttributes:this.hostAttributes,providers:this.providers,viewProviders:this.viewProviders,queries:this.queries,guards:this.guards,viewQueries:this.viewQueries,entryComponents:this.entryComponents,changeDetection:this.changeDetection,template:this.template&&this.template.toSummary(),componentViewType:this.componentViewType,rendererType:this.rendererType,componentFactory:this.componentFactory}},CompileDirectiveMetadata}(),CompilePipeMetadata=function(){function CompilePipeMetadata(_a){var type=_a.type,name=_a.name,pure=_a.pure;this.type=type,this.name=name,this.pure=!!pure}return CompilePipeMetadata.prototype.toSummary=function(){return{summaryKind:CompileSummaryKind.Pipe,type:this.type,name:this.name,pure:this.pure}},CompilePipeMetadata}(),CompileNgModuleMetadata=function(){function CompileNgModuleMetadata(_a){var type=_a.type,providers=_a.providers,declaredDirectives=_a.declaredDirectives,exportedDirectives=_a.exportedDirectives,declaredPipes=_a.declaredPipes,exportedPipes=_a.exportedPipes,entryComponents=_a.entryComponents,bootstrapComponents=_a.bootstrapComponents,importedModules=_a.importedModules,exportedModules=_a.exportedModules,schemas=_a.schemas,transitiveModule=_a.transitiveModule,id=_a.id;this.type=type||null,this.declaredDirectives=_normalizeArray(declaredDirectives),this.exportedDirectives=_normalizeArray(exportedDirectives),this.declaredPipes=_normalizeArray(declaredPipes),this.exportedPipes=_normalizeArray(exportedPipes),this.providers=_normalizeArray(providers),this.entryComponents=_normalizeArray(entryComponents),this.bootstrapComponents=_normalizeArray(bootstrapComponents),this.importedModules=_normalizeArray(importedModules),this.exportedModules=_normalizeArray(exportedModules),this.schemas=_normalizeArray(schemas),this.id=id||null,this.transitiveModule=transitiveModule||null}return CompileNgModuleMetadata.prototype.toSummary=function(){var module=this.transitiveModule;return{summaryKind:CompileSummaryKind.NgModule,type:this.type,entryComponents:module.entryComponents,providers:module.providers,modules:module.modules,exportedDirectives:module.exportedDirectives,exportedPipes:module.exportedPipes}},CompileNgModuleMetadata}(),TransitiveCompileNgModuleMetadata=function(){function TransitiveCompileNgModuleMetadata(){this.directivesSet=new Set,this.directives=[],this.exportedDirectivesSet=new Set,this.exportedDirectives=[],this.pipesSet=new Set,this.pipes=[],this.exportedPipesSet=new Set,this.exportedPipes=[],this.modulesSet=new Set,this.modules=[],this.entryComponentsSet=new Set,this.entryComponents=[],this.providers=[]}return TransitiveCompileNgModuleMetadata.prototype.addProvider=function(provider,module){this.providers.push({provider:provider,module:module})},TransitiveCompileNgModuleMetadata.prototype.addDirective=function(id){this.directivesSet.has(id.reference)||(this.directivesSet.add(id.reference),this.directives.push(id))},TransitiveCompileNgModuleMetadata.prototype.addExportedDirective=function(id){this.exportedDirectivesSet.has(id.reference)||(this.exportedDirectivesSet.add(id.reference),this.exportedDirectives.push(id))},TransitiveCompileNgModuleMetadata.prototype.addPipe=function(id){this.pipesSet.has(id.reference)||(this.pipesSet.add(id.reference),this.pipes.push(id))},TransitiveCompileNgModuleMetadata.prototype.addExportedPipe=function(id){this.exportedPipesSet.has(id.reference)||(this.exportedPipesSet.add(id.reference),this.exportedPipes.push(id))},TransitiveCompileNgModuleMetadata.prototype.addModule=function(id){this.modulesSet.has(id.reference)||(this.modulesSet.add(id.reference),this.modules.push(id))},TransitiveCompileNgModuleMetadata.prototype.addEntryComponent=function(ec){this.entryComponentsSet.has(ec.componentType)||(this.entryComponentsSet.add(ec.componentType),this.entryComponents.push(ec))},TransitiveCompileNgModuleMetadata}(),ProviderMeta=function(){function ProviderMeta(token,_a){var useClass=_a.useClass,useValue=_a.useValue,useExisting=_a.useExisting,useFactory=_a.useFactory,deps=_a.deps,multi=_a.multi;this.token=token,this.useClass=useClass||null,this.useValue=useValue,this.useExisting=useExisting,this.useFactory=useFactory||null,this.dependencies=deps||null,this.multi=!!multi}return ProviderMeta}(),AstPath=function(){function AstPath(path$$1,position){void 0===position&&(position=-1),this.path=path$$1,this.position=position}return Object.defineProperty(AstPath.prototype,"empty",{get:function(){return!this.path||!this.path.length},enumerable:!0,configurable:!0}),Object.defineProperty(AstPath.prototype,"head",{get:function(){return this.path[0]},enumerable:!0,configurable:!0}),Object.defineProperty(AstPath.prototype,"tail",{get:function(){return this.path[this.path.length-1]},enumerable:!0,configurable:!0}),AstPath.prototype.parentOf=function(node){return node&&this.path[this.path.indexOf(node)-1]},AstPath.prototype.childOf=function(node){return this.path[this.path.indexOf(node)+1]},AstPath.prototype.first=function(ctor){for(var i=this.path.length-1;i>=0;i--){var item=this.path[i];if(item instanceof ctor)return item}},AstPath.prototype.push=function(node){this.path.push(node)},AstPath.prototype.pop=function(){return this.path.pop()},AstPath}(),Text=function(){function Text(value,sourceSpan){this.value=value,this.sourceSpan=sourceSpan}return Text.prototype.visit=function(visitor,context){return visitor.visitText(this,context)},Text}(),Expansion=function(){function Expansion(switchValue,type,cases,sourceSpan,switchValueSourceSpan){this.switchValue=switchValue,this.type=type,this.cases=cases,this.sourceSpan=sourceSpan,this.switchValueSourceSpan=switchValueSourceSpan}return Expansion.prototype.visit=function(visitor,context){return visitor.visitExpansion(this,context)},Expansion}(),ExpansionCase=function(){function ExpansionCase(value,expression,sourceSpan,valueSourceSpan,expSourceSpan){this.value=value,this.expression=expression,this.sourceSpan=sourceSpan,this.valueSourceSpan=valueSourceSpan,this.expSourceSpan=expSourceSpan}return ExpansionCase.prototype.visit=function(visitor,context){return visitor.visitExpansionCase(this,context)},ExpansionCase}(),Attribute$1=function(){function Attribute(name,value,sourceSpan,valueSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan,this.valueSpan=valueSpan}return Attribute.prototype.visit=function(visitor,context){return visitor.visitAttribute(this,context)},Attribute}(),Element=function(){function Element(name,attrs,children,sourceSpan,startSourceSpan,endSourceSpan){void 0===startSourceSpan&&(startSourceSpan=null),void 0===endSourceSpan&&(endSourceSpan=null),this.name=name,this.attrs=attrs,this.children=children,this.sourceSpan=sourceSpan,this.startSourceSpan=startSourceSpan,this.endSourceSpan=endSourceSpan}return Element.prototype.visit=function(visitor,context){return visitor.visitElement(this,context)},Element}(),Comment=function(){function Comment(value,sourceSpan){this.value=value,this.sourceSpan=sourceSpan}return Comment.prototype.visit=function(visitor,context){return visitor.visitComment(this,context)},Comment}(),RecursiveVisitor=function(){function RecursiveVisitor(){}return RecursiveVisitor.prototype.visitElement=function(ast,context){this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.children)})},RecursiveVisitor.prototype.visitAttribute=function(ast,context){},RecursiveVisitor.prototype.visitText=function(ast,context){},RecursiveVisitor.prototype.visitComment=function(ast,context){},RecursiveVisitor.prototype.visitExpansion=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.cases)})},RecursiveVisitor.prototype.visitExpansionCase=function(ast,context){},RecursiveVisitor.prototype.visitChildren=function(context,cb){function visit(children){children&&results.push(visitAll(t,children,context))}var results=[],t=this;return cb(visit),[].concat.apply([],results)},RecursiveVisitor}(),INTERPOLATION_BLACKLIST_REGEXPS=[/^\s*$/,/[<>]/,/^[{}]$/,/&(#|[a-z])/i,/^\/\//],InterpolationConfig=function(){function InterpolationConfig(start,end){this.start=start,this.end=end}return InterpolationConfig.fromArray=function(markers){return markers?(assertInterpolationSymbols("interpolation",markers),new InterpolationConfig(markers[0],markers[1])):DEFAULT_INTERPOLATION_CONFIG},InterpolationConfig}(),DEFAULT_INTERPOLATION_CONFIG=new InterpolationConfig("{{","}}"),StyleWithImports=function(){function StyleWithImports(style,styleUrls){this.style=style,this.styleUrls=styleUrls}return StyleWithImports}(),CSS_IMPORT_REGEXP=/@import\s+(?:url\()?\s*(?:(?:['"]([^'"]*))|([^;\)\s]*))[^;]*;?/g,CSS_STRIPPABLE_COMMENT_REGEXP=/\/\*(?!#\s*(?:sourceURL|sourceMappingURL)=)[\s\S]+?\*\//g,URL_WITH_SCHEMA_REGEXP=/^([^:\/?#]+):/,TagContentType={RAW_TEXT:0,ESCAPABLE_RAW_TEXT:1,PARSABLE_DATA:2};TagContentType[TagContentType.RAW_TEXT]="RAW_TEXT",TagContentType[TagContentType.ESCAPABLE_RAW_TEXT]="ESCAPABLE_RAW_TEXT",TagContentType[TagContentType.PARSABLE_DATA]="PARSABLE_DATA";var NAMED_ENTITIES={Aacute:"Á",aacute:"á",Acirc:"Â",acirc:"â",acute:"´",AElig:"Æ",aelig:"æ",Agrave:"À",agrave:"à",alefsym:"ℵ",Alpha:"Α",alpha:"α",amp:"&",and:"∧",ang:"∠",apos:"'",Aring:"Å",aring:"å",asymp:"≈",Atilde:"Ã",atilde:"ã",Auml:"Ä",auml:"ä",bdquo:"„",Beta:"Β",beta:"β",brvbar:"¦",bull:"•",cap:"∩",Ccedil:"Ç",ccedil:"ç",cedil:"¸",cent:"¢",Chi:"Χ",chi:"χ",circ:"ˆ",clubs:"♣",cong:"≅",copy:"©",crarr:"↵",cup:"∪",curren:"¤",dagger:"†",Dagger:"‡",darr:"↓",dArr:"⇓",deg:"°",Delta:"Δ",delta:"δ",diams:"♦",divide:"÷",Eacute:"É",eacute:"é",Ecirc:"Ê",ecirc:"ê",Egrave:"È",egrave:"è",empty:"∅",emsp:" ",ensp:" ",Epsilon:"Ε",epsilon:"ε",equiv:"≡",Eta:"Η",eta:"η",ETH:"Ð",eth:"ð",Euml:"Ë",euml:"ë",euro:"€",exist:"∃",fnof:"ƒ",forall:"∀",frac12:"½",frac14:"¼",frac34:"¾",frasl:"⁄",Gamma:"Γ",gamma:"γ",ge:"≥",gt:">",harr:"↔",hArr:"⇔",hearts:"♥",hellip:"…",Iacute:"Í",iacute:"í",Icirc:"Î",icirc:"î",iexcl:"¡",Igrave:"Ì",igrave:"ì",image:"ℑ",infin:"∞",int:"∫",Iota:"Ι",iota:"ι",iquest:"¿",isin:"∈",Iuml:"Ï",iuml:"ï",Kappa:"Κ",kappa:"κ",Lambda:"Λ",lambda:"λ",lang:"⟨",laquo:"«",larr:"←",lArr:"⇐",lceil:"⌈",ldquo:"“",le:"≤",lfloor:"⌊",lowast:"∗",loz:"◊",lrm:"‎",lsaquo:"‹",lsquo:"‘",lt:"<",macr:"¯",mdash:"—",micro:"µ",middot:"·",minus:"−",Mu:"Μ",mu:"μ",nabla:"∇",nbsp:" ",ndash:"–",ne:"≠",ni:"∋",not:"¬",notin:"∉",nsub:"⊄",Ntilde:"Ñ",ntilde:"ñ",Nu:"Ν",nu:"ν",Oacute:"Ó",oacute:"ó",Ocirc:"Ô",ocirc:"ô",OElig:"Œ",oelig:"œ",Ograve:"Ò",ograve:"ò",oline:"‾",Omega:"Ω",omega:"ω",Omicron:"Ο",omicron:"ο",oplus:"⊕",or:"∨",ordf:"ª",ordm:"º",Oslash:"Ø",oslash:"ø",Otilde:"Õ",otilde:"õ",otimes:"⊗",Ouml:"Ö",ouml:"ö",para:"¶",permil:"‰",perp:"⊥",Phi:"Φ",phi:"φ",Pi:"Π",pi:"π",piv:"ϖ",plusmn:"±",pound:"£",prime:"′",Prime:"″",prod:"∏",prop:"∝",Psi:"Ψ",psi:"ψ",quot:'"',radic:"√",rang:"⟩",raquo:"»",rarr:"→",rArr:"⇒",rceil:"⌉",rdquo:"”",real:"ℜ",reg:"®",rfloor:"⌋",Rho:"Ρ",rho:"ρ",rlm:"‏",rsaquo:"›",rsquo:"’",sbquo:"‚",Scaron:"Š",scaron:"š",sdot:"⋅",sect:"§",shy:"­",Sigma:"Σ",sigma:"σ",sigmaf:"ς",sim:"∼",spades:"♠",sub:"⊂",sube:"⊆",sum:"∑",sup:"⊃",sup1:"¹",sup2:"²",sup3:"³",supe:"⊇",szlig:"ß",Tau:"Τ",tau:"τ",there4:"∴",Theta:"Θ",theta:"θ",thetasym:"ϑ",thinsp:" ",THORN:"Þ",thorn:"þ",tilde:"˜",times:"×",trade:"™",Uacute:"Ú",uacute:"ú",uarr:"↑",uArr:"⇑",Ucirc:"Û",ucirc:"û",Ugrave:"Ù",ugrave:"ù",uml:"¨",upsih:"ϒ",Upsilon:"Υ",upsilon:"υ",Uuml:"Ü",uuml:"ü",weierp:"℘",Xi:"Ξ",xi:"ξ",Yacute:"Ý",yacute:"ý",yen:"¥",yuml:"ÿ",Yuml:"Ÿ",Zeta:"Ζ",zeta:"ζ",zwj:"‍",zwnj:"‌"},NGSP_UNICODE="";NAMED_ENTITIES.ngsp=NGSP_UNICODE;/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var NG_CONTENT_SELECT_ATTR="select",LINK_ELEMENT="link",LINK_STYLE_REL_ATTR="rel",LINK_STYLE_HREF_ATTR="href",LINK_STYLE_REL_VALUE="stylesheet",STYLE_ELEMENT="style",SCRIPT_ELEMENT="script",NG_NON_BINDABLE_ATTR="ngNonBindable",NG_PROJECT_AS="ngProjectAs",PreparsedElementType={NG_CONTENT:0,STYLE:1,STYLESHEET:2,SCRIPT:3,OTHER:4};PreparsedElementType[PreparsedElementType.NG_CONTENT]="NG_CONTENT",PreparsedElementType[PreparsedElementType.STYLE]="STYLE",PreparsedElementType[PreparsedElementType.STYLESHEET]="STYLESHEET",PreparsedElementType[PreparsedElementType.SCRIPT]="SCRIPT",PreparsedElementType[PreparsedElementType.OTHER]="OTHER";var PreparsedElement=function(){function PreparsedElement(type,selectAttr,hrefAttr,nonBindable,projectAs){this.type=type,this.selectAttr=selectAttr,this.hrefAttr=hrefAttr,this.nonBindable=nonBindable,this.projectAs=projectAs}return PreparsedElement}(),DirectiveNormalizer=function(){function DirectiveNormalizer(_resourceLoader,_urlResolver,_htmlParser,_config){this._resourceLoader=_resourceLoader,this._urlResolver=_urlResolver,this._htmlParser=_htmlParser,this._config=_config,this._resourceLoaderCache=new Map}return DirectiveNormalizer.prototype.clearCache=function(){this._resourceLoaderCache.clear()},DirectiveNormalizer.prototype.clearCacheFor=function(normalizedDirective){var _this=this;if(normalizedDirective.isComponent){var template=normalizedDirective.template;this._resourceLoaderCache.delete(template.templateUrl),template.externalStylesheets.forEach(function(stylesheet){_this._resourceLoaderCache.delete(stylesheet.moduleUrl)})}},DirectiveNormalizer.prototype._fetch=function(url){var result=this._resourceLoaderCache.get(url);return result||(result=this._resourceLoader.get(url),this._resourceLoaderCache.set(url,result)),result},DirectiveNormalizer.prototype.normalizeTemplate=function(prenormData){var _this=this;if(isDefined(prenormData.template)){if(isDefined(prenormData.templateUrl))throw syntaxError("'"+stringify(prenormData.componentType)+"' component cannot define both template and templateUrl");if("string"!=typeof prenormData.template)throw syntaxError("The template specified for component "+stringify(prenormData.componentType)+" is not a string")}else{if(!isDefined(prenormData.templateUrl))throw syntaxError("No template specified for component "+stringify(prenormData.componentType));if("string"!=typeof prenormData.templateUrl)throw syntaxError("The templateUrl specified for component "+stringify(prenormData.componentType)+" is not a string")}if(isDefined(prenormData.preserveWhitespaces)&&"boolean"!=typeof prenormData.preserveWhitespaces)throw syntaxError("The preserveWhitespaces option for component "+stringify(prenormData.componentType)+" must be a boolean");return SyncAsync.then(this._preParseTemplate(prenormData),function(preparsedTemplate){return _this._normalizeTemplateMetadata(prenormData,preparsedTemplate)})},DirectiveNormalizer.prototype._preParseTemplate=function(prenomData){var template,templateUrl,_this=this;return null!=prenomData.template?(template=prenomData.template,templateUrl=prenomData.moduleUrl):(templateUrl=this._urlResolver.resolve(prenomData.moduleUrl,prenomData.templateUrl),template=this._fetch(templateUrl)),SyncAsync.then(template,function(template){return _this._preparseLoadedTemplate(prenomData,template,templateUrl)})},DirectiveNormalizer.prototype._preparseLoadedTemplate=function(prenormData,template,templateAbsUrl){var isInline=!!prenormData.template,interpolationConfig=InterpolationConfig.fromArray(prenormData.interpolation),rootNodesAndErrors=this._htmlParser.parse(template,templateSourceUrl({reference:prenormData.ngModuleType},{type:{reference:prenormData.componentType}},{isInline:isInline,templateUrl:templateAbsUrl}),!0,interpolationConfig);if(rootNodesAndErrors.errors.length>0){throw syntaxError("Template parse errors:\n"+rootNodesAndErrors.errors.join("\n"))}var templateMetadataStyles=this._normalizeStylesheet(new CompileStylesheetMetadata({styles:prenormData.styles,moduleUrl:prenormData.moduleUrl})),visitor=new TemplatePreparseVisitor;visitAll(visitor,rootNodesAndErrors.rootNodes);var templateStyles=this._normalizeStylesheet(new CompileStylesheetMetadata({styles:visitor.styles,styleUrls:visitor.styleUrls,moduleUrl:templateAbsUrl}));return{template:template,templateUrl:templateAbsUrl,isInline:isInline,htmlAst:rootNodesAndErrors,styles:templateMetadataStyles.styles.concat(templateStyles.styles),inlineStyleUrls:templateMetadataStyles.styleUrls.concat(templateStyles.styleUrls),styleUrls:this._normalizeStylesheet(new CompileStylesheetMetadata({styleUrls:prenormData.styleUrls,moduleUrl:prenormData.moduleUrl})).styleUrls,ngContentSelectors:visitor.ngContentSelectors}},DirectiveNormalizer.prototype._normalizeTemplateMetadata=function(prenormData,preparsedTemplate){var _this=this;return SyncAsync.then(this._loadMissingExternalStylesheets(preparsedTemplate.styleUrls.concat(preparsedTemplate.inlineStyleUrls)),function(externalStylesheets){return _this._normalizeLoadedTemplateMetadata(prenormData,preparsedTemplate,externalStylesheets)})},DirectiveNormalizer.prototype._normalizeLoadedTemplateMetadata=function(prenormData,preparsedTemplate,stylesheets){var _this=this,styles=preparsedTemplate.styles.slice();this._inlineStyles(preparsedTemplate.inlineStyleUrls,stylesheets,styles);var styleUrls=preparsedTemplate.styleUrls,externalStylesheets=styleUrls.map(function(styleUrl){var stylesheet=stylesheets.get(styleUrl),styles=stylesheet.styles.slice();return _this._inlineStyles(stylesheet.styleUrls,stylesheets,styles),new CompileStylesheetMetadata({moduleUrl:styleUrl,styles:styles})}),encapsulation=prenormData.encapsulation;return null==encapsulation&&(encapsulation=this._config.defaultEncapsulation),encapsulation===ViewEncapsulation.Emulated&&0===styles.length&&0===styleUrls.length&&(encapsulation=ViewEncapsulation.None),new CompileTemplateMetadata({encapsulation:encapsulation,template:preparsedTemplate.template,templateUrl:preparsedTemplate.templateUrl,htmlAst:preparsedTemplate.htmlAst,styles:styles,styleUrls:styleUrls,ngContentSelectors:preparsedTemplate.ngContentSelectors,animations:prenormData.animations,interpolation:prenormData.interpolation,isInline:preparsedTemplate.isInline,externalStylesheets:externalStylesheets,preserveWhitespaces:preserveWhitespacesDefault(prenormData.preserveWhitespaces,this._config.preserveWhitespaces)})},DirectiveNormalizer.prototype._inlineStyles=function(styleUrls,stylesheets,targetStyles){var _this=this;styleUrls.forEach(function(styleUrl){var stylesheet=stylesheets.get(styleUrl);stylesheet.styles.forEach(function(style){return targetStyles.push(style)}),_this._inlineStyles(stylesheet.styleUrls,stylesheets,targetStyles)})},DirectiveNormalizer.prototype._loadMissingExternalStylesheets=function(styleUrls,loadedStylesheets){var _this=this;return void 0===loadedStylesheets&&(loadedStylesheets=new Map),SyncAsync.then(SyncAsync.all(styleUrls.filter(function(styleUrl){return!loadedStylesheets.has(styleUrl)}).map(function(styleUrl){return SyncAsync.then(_this._fetch(styleUrl),function(loadedStyle){var stylesheet=_this._normalizeStylesheet(new CompileStylesheetMetadata({styles:[loadedStyle],moduleUrl:styleUrl}));return loadedStylesheets.set(styleUrl,stylesheet),_this._loadMissingExternalStylesheets(stylesheet.styleUrls,loadedStylesheets)})})),function(_){return loadedStylesheets})},DirectiveNormalizer.prototype._normalizeStylesheet=function(stylesheet){var _this=this,moduleUrl=stylesheet.moduleUrl,allStyleUrls=stylesheet.styleUrls.filter(isStyleUrlResolvable).map(function(url){return _this._urlResolver.resolve(moduleUrl,url)}),allStyles=stylesheet.styles.map(function(style){var styleWithImports=extractStyleUrls(_this._urlResolver,moduleUrl,style);return allStyleUrls.push.apply(allStyleUrls,styleWithImports.styleUrls),styleWithImports.style});return new CompileStylesheetMetadata({styles:allStyles,styleUrls:allStyleUrls,moduleUrl:moduleUrl})},DirectiveNormalizer}(),TemplatePreparseVisitor=function(){function TemplatePreparseVisitor(){this.ngContentSelectors=[],this.styles=[],this.styleUrls=[],this.ngNonBindableStackCount=0}return TemplatePreparseVisitor.prototype.visitElement=function(ast,context){var preparsedElement=preparseElement(ast);switch(preparsedElement.type){case PreparsedElementType.NG_CONTENT:0===this.ngNonBindableStackCount&&this.ngContentSelectors.push(preparsedElement.selectAttr);break;case PreparsedElementType.STYLE:var textContent_1="";ast.children.forEach(function(child){child instanceof Text&&(textContent_1+=child.value)}),this.styles.push(textContent_1);break;case PreparsedElementType.STYLESHEET:this.styleUrls.push(preparsedElement.hrefAttr)}return preparsedElement.nonBindable&&this.ngNonBindableStackCount++,visitAll(this,ast.children),preparsedElement.nonBindable&&this.ngNonBindableStackCount--,null},TemplatePreparseVisitor.prototype.visitExpansion=function(ast,context){visitAll(this,ast.cases)},TemplatePreparseVisitor.prototype.visitExpansionCase=function(ast,context){visitAll(this,ast.expression)},TemplatePreparseVisitor.prototype.visitComment=function(ast,context){return null},TemplatePreparseVisitor.prototype.visitAttribute=function(ast,context){return null},TemplatePreparseVisitor.prototype.visitText=function(ast,context){return null},TemplatePreparseVisitor}(),QUERY_METADATA_IDENTIFIERS=[createViewChild,createViewChildren,createContentChild,createContentChildren],DirectiveResolver=function(){function DirectiveResolver(_reflector){this._reflector=_reflector}return DirectiveResolver.prototype.isDirective=function(type){var typeMetadata=this._reflector.annotations(resolveForwardRef(type));return typeMetadata&&typeMetadata.some(isDirectiveMetadata)},DirectiveResolver.prototype.resolve=function(type,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var typeMetadata=this._reflector.annotations(resolveForwardRef(type));if(typeMetadata){var metadata=findLast(typeMetadata,isDirectiveMetadata);if(metadata){var propertyMetadata=this._reflector.propMetadata(type),guards=this._reflector.guards(type);return this._mergeWithPropertyMetadata(metadata,propertyMetadata,guards,type)}}if(throwIfNotFound)throw new Error("No Directive annotation found on "+stringify(type));return null},DirectiveResolver.prototype._mergeWithPropertyMetadata=function(dm,propertyMetadata,guards,directiveType){var inputs=[],outputs=[],host={},queries={};return Object.keys(propertyMetadata).forEach(function(propName){var input=findLast(propertyMetadata[propName],function(a){return createInput.isTypeOf(a)});input&&(input.bindingPropertyName?inputs.push(propName+": "+input.bindingPropertyName):inputs.push(propName));var output=findLast(propertyMetadata[propName],function(a){return createOutput.isTypeOf(a)});output&&(output.bindingPropertyName?outputs.push(propName+": "+output.bindingPropertyName):outputs.push(propName)),propertyMetadata[propName].filter(function(a){return createHostBinding.isTypeOf(a)}).forEach(function(hostBinding){if(hostBinding.hostPropertyName){var startWith=hostBinding.hostPropertyName[0];if("("===startWith)throw new Error("@HostBinding can not bind to events. Use @HostListener instead.");if("["===startWith)throw new Error("@HostBinding parameter should be a property name, 'class.<name>', or 'attr.<name>'.");host["["+hostBinding.hostPropertyName+"]"]=propName}else host["["+propName+"]"]=propName}),propertyMetadata[propName].filter(function(a){return createHostListener.isTypeOf(a)}).forEach(function(hostListener){var args=hostListener.args||[];host["("+hostListener.eventName+")"]=propName+"("+args.join(",")+")"});var query=findLast(propertyMetadata[propName],function(a){return QUERY_METADATA_IDENTIFIERS.some(function(i){return i.isTypeOf(a)})});query&&(queries[propName]=query)}),this._merge(dm,inputs,outputs,host,queries,guards,directiveType)},DirectiveResolver.prototype._extractPublicName=function(def){return splitAtColon(def,[null,def])[1].trim()},DirectiveResolver.prototype._dedupeBindings=function(bindings){for(var names=new Set,publicNames=new Set,reversedResult=[],i=bindings.length-1;i>=0;i--){var binding=bindings[i],name_1=this._extractPublicName(binding);publicNames.add(name_1),names.has(name_1)||(names.add(name_1),reversedResult.push(binding))}return reversedResult.reverse()},DirectiveResolver.prototype._merge=function(directive,inputs,outputs,host,queries,guards,directiveType){var mergedInputs=this._dedupeBindings(directive.inputs?directive.inputs.concat(inputs):inputs),mergedOutputs=this._dedupeBindings(directive.outputs?directive.outputs.concat(outputs):outputs),mergedHost=directive.host?__assign({},directive.host,host):host,mergedQueries=directive.queries?__assign({},directive.queries,queries):queries;if(createComponent.isTypeOf(directive)){var comp=directive;return createComponent({selector:comp.selector,inputs:mergedInputs,outputs:mergedOutputs,host:mergedHost,exportAs:comp.exportAs,moduleId:comp.moduleId,queries:mergedQueries,changeDetection:comp.changeDetection,providers:comp.providers,viewProviders:comp.viewProviders,entryComponents:comp.entryComponents,template:comp.template,templateUrl:comp.templateUrl,styles:comp.styles,styleUrls:comp.styleUrls,encapsulation:comp.encapsulation,animations:comp.animations,interpolation:comp.interpolation,preserveWhitespaces:directive.preserveWhitespaces})}return createDirective({selector:directive.selector,inputs:mergedInputs,outputs:mergedOutputs,host:mergedHost,exportAs:directive.exportAs,queries:mergedQueries,providers:directive.providers,guards:guards})},DirectiveResolver}(),$EOF=0,$TAB=9,$LF=10,$VTAB=11,$FF=12,$CR=13,$SPACE=32,$DQ=34,$$=36,$SQ=39,$PLUS=43,$MINUS=45,$SLASH=47,$SEMICOLON=59,$EQ=61,$GT=62,$0=48,$9=57,$A=65,$E=69,$F=70,$Z=90,$_=95,$a=97,$e=101,$f=102,$n=110,$r=114,$t=116,$v=118,$z=122,$LBRACE=123,$NBSP=160,$BT=96,TokenType={Character:0,Identifier:1,Keyword:2,String:3,Operator:4,Number:5,Error:6};TokenType[TokenType.Character]="Character",TokenType[TokenType.Identifier]="Identifier",TokenType[TokenType.Keyword]="Keyword",TokenType[TokenType.String]="String",TokenType[TokenType.Operator]="Operator",TokenType[TokenType.Number]="Number",TokenType[TokenType.Error]="Error";var KEYWORDS=["var","let","as","null","undefined","true","false","if","else","this"],Lexer=function(){function Lexer(){}return Lexer.prototype.tokenize=function(text){for(var scanner=new _Scanner(text),tokens=[],token=scanner.scanToken();null!=token;)tokens.push(token),token=scanner.scanToken();return tokens},Lexer}(),Token=function(){function Token(index,type,numValue,strValue){this.index=index,this.type=type,this.numValue=numValue,this.strValue=strValue}return Token.prototype.isCharacter=function(code){return this.type==TokenType.Character&&this.numValue==code},Token.prototype.isNumber=function(){return this.type==TokenType.Number},Token.prototype.isString=function(){return this.type==TokenType.String},Token.prototype.isOperator=function(operater){return this.type==TokenType.Operator&&this.strValue==operater},Token.prototype.isIdentifier=function(){return this.type==TokenType.Identifier},Token.prototype.isKeyword=function(){return this.type==TokenType.Keyword},Token.prototype.isKeywordLet=function(){return this.type==TokenType.Keyword&&"let"==this.strValue},Token.prototype.isKeywordAs=function(){return this.type==TokenType.Keyword&&"as"==this.strValue},Token.prototype.isKeywordNull=function(){return this.type==TokenType.Keyword&&"null"==this.strValue},Token.prototype.isKeywordUndefined=function(){return this.type==TokenType.Keyword&&"undefined"==this.strValue},Token.prototype.isKeywordTrue=function(){return this.type==TokenType.Keyword&&"true"==this.strValue},Token.prototype.isKeywordFalse=function(){return this.type==TokenType.Keyword&&"false"==this.strValue},Token.prototype.isKeywordThis=function(){return this.type==TokenType.Keyword&&"this"==this.strValue},Token.prototype.isError=function(){return this.type==TokenType.Error},Token.prototype.toNumber=function(){return this.type==TokenType.Number?this.numValue:-1},Token.prototype.toString=function(){switch(this.type){case TokenType.Character:case TokenType.Identifier:case TokenType.Keyword:case TokenType.Operator:case TokenType.String:case TokenType.Error:return this.strValue;case TokenType.Number:return this.numValue.toString();default:return null}},Token}(),EOF=new Token(-1,TokenType.Character,0,""),_Scanner=function(){function _Scanner(input){this.input=input,this.peek=0,this.index=-1,this.length=input.length,this.advance()}return _Scanner.prototype.advance=function(){this.peek=++this.index>=this.length?$EOF:this.input.charCodeAt(this.index)},_Scanner.prototype.scanToken=function(){for(var input=this.input,length=this.length,peek=this.peek,index=this.index;peek<=$SPACE;){if(++index>=length){peek=$EOF;break}peek=input.charCodeAt(index)}if(this.peek=peek,this.index=index,index>=length)return null;if(isIdentifierStart(peek))return this.scanIdentifier();if(isDigit(peek))return this.scanNumber(index);var start=index;switch(peek){case 46:return this.advance(),isDigit(this.peek)?this.scanNumber(start):newCharacterToken(start,46);case 40:case 41:case $LBRACE:case 125:case 91:case 93:case 44:case 58:case $SEMICOLON:return this.scanCharacter(start,peek);case $SQ:case $DQ:return this.scanString();case 35:case $PLUS:case $MINUS:case 42:case $SLASH:case 37:case 94:return this.scanOperator(start,String.fromCharCode(peek));case 63:return this.scanComplexOperator(start,"?",46,".");case 60:case $GT:return this.scanComplexOperator(start,String.fromCharCode(peek),$EQ,"=");case 33:case $EQ:return this.scanComplexOperator(start,String.fromCharCode(peek),$EQ,"=",$EQ,"=");case 38:return this.scanComplexOperator(start,"&",38,"&");case 124:return this.scanComplexOperator(start,"|",124,"|");case $NBSP:for(;isWhitespace(this.peek);)this.advance();return this.scanToken()}return this.advance(),this.error("Unexpected character ["+String.fromCharCode(peek)+"]",0)},_Scanner.prototype.scanCharacter=function(start,code){return this.advance(),newCharacterToken(start,code)},_Scanner.prototype.scanOperator=function(start,str){return this.advance(),newOperatorToken(start,str)},_Scanner.prototype.scanComplexOperator=function(start,one,twoCode,two,threeCode,three){this.advance();var str=one;return this.peek==twoCode&&(this.advance(),str+=two),null!=threeCode&&this.peek==threeCode&&(this.advance(),str+=three),newOperatorToken(start,str)},_Scanner.prototype.scanIdentifier=function(){var start=this.index;for(this.advance();isIdentifierPart(this.peek);)this.advance();var str=this.input.substring(start,this.index);return KEYWORDS.indexOf(str)>-1?newKeywordToken(start,str):newIdentifierToken(start,str)},_Scanner.prototype.scanNumber=function(start){var simple=this.index===start;for(this.advance();;){if(isDigit(this.peek));else if(46==this.peek)simple=!1;else{if(!isExponentStart(this.peek))break;if(this.advance(),isExponentSign(this.peek)&&this.advance(),!isDigit(this.peek))return this.error("Invalid exponent",-1);simple=!1}this.advance()}var str=this.input.substring(start,this.index);return newNumberToken(start,simple?parseIntAutoRadix(str):parseFloat(str))},_Scanner.prototype.scanString=function(){var start=this.index,quote=this.peek;this.advance();for(var buffer="",marker=this.index,input=this.input;this.peek!=quote;)if(92==this.peek){buffer+=input.substring(marker,this.index),this.advance();var unescapedCode=void 0;if(this.peek=this.peek,117==this.peek){var hex=input.substring(this.index+1,this.index+5);if(!/^[0-9a-f]+$/i.test(hex))return this.error("Invalid unicode escape [\\u"+hex+"]",0);unescapedCode=parseInt(hex,16);for(var i=0;i<5;i++)this.advance()}else unescapedCode=unescape(this.peek),this.advance();buffer+=String.fromCharCode(unescapedCode),marker=this.index}else{if(this.peek==$EOF)return this.error("Unterminated quote",0);this.advance()}var last=input.substring(marker,this.index);return this.advance(),newStringToken(start,buffer+last)},_Scanner.prototype.error=function(message,offset){var position=this.index+offset;return newErrorToken(position,"Lexer Error: "+message+" at column "+position+" in expression ["+this.input+"]")},_Scanner}(),ParserError=function(){function ParserError(message,input,errLocation,ctxLocation){this.input=input,this.errLocation=errLocation,this.ctxLocation=ctxLocation,this.message="Parser Error: "+message+" "+errLocation+" ["+input+"] in "+ctxLocation}return ParserError}(),ParseSpan=function(){function ParseSpan(start,end){this.start=start,this.end=end}return ParseSpan}(),AST=function(){function AST(span){this.span=span}return AST.prototype.visit=function(visitor,context){return void 0===context&&(context=null),null},AST.prototype.toString=function(){return"AST"},AST}(),Quote=function(_super){function Quote(span,prefix,uninterpretedExpression,location){var _this=_super.call(this,span)||this;return _this.prefix=prefix,_this.uninterpretedExpression=uninterpretedExpression,_this.location=location,_this}return __extends(Quote,_super),Quote.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitQuote(this,context)},Quote.prototype.toString=function(){return"Quote"},Quote}(AST),EmptyExpr=function(_super){function EmptyExpr(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(EmptyExpr,_super),EmptyExpr.prototype.visit=function(visitor,context){void 0===context&&(context=null)},EmptyExpr}(AST),ImplicitReceiver=function(_super){function ImplicitReceiver(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ImplicitReceiver,_super),ImplicitReceiver.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitImplicitReceiver(this,context)},ImplicitReceiver}(AST),Chain=function(_super){function Chain(span,expressions){var _this=_super.call(this,span)||this;return _this.expressions=expressions,_this}return __extends(Chain,_super),Chain.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitChain(this,context)},Chain}(AST),Conditional=function(_super){function Conditional(span,condition,trueExp,falseExp){var _this=_super.call(this,span)||this;return _this.condition=condition,_this.trueExp=trueExp,_this.falseExp=falseExp,_this}return __extends(Conditional,_super),Conditional.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitConditional(this,context)},Conditional}(AST),PropertyRead=function(_super){function PropertyRead(span,receiver,name){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this}return __extends(PropertyRead,_super),PropertyRead.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPropertyRead(this,context)},PropertyRead}(AST),PropertyWrite=function(_super){function PropertyWrite(span,receiver,name,value){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this.value=value,_this}return __extends(PropertyWrite,_super),PropertyWrite.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPropertyWrite(this,context)},PropertyWrite}(AST),SafePropertyRead=function(_super){function SafePropertyRead(span,receiver,name){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this}return __extends(SafePropertyRead,_super),SafePropertyRead.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitSafePropertyRead(this,context)},SafePropertyRead}(AST),KeyedRead=function(_super){function KeyedRead(span,obj,key){var _this=_super.call(this,span)||this;return _this.obj=obj,_this.key=key,_this}return __extends(KeyedRead,_super),KeyedRead.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitKeyedRead(this,context)},KeyedRead}(AST),KeyedWrite=function(_super){function KeyedWrite(span,obj,key,value){var _this=_super.call(this,span)||this;return _this.obj=obj,_this.key=key,_this.value=value,_this}return __extends(KeyedWrite,_super),KeyedWrite.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitKeyedWrite(this,context)},KeyedWrite}(AST),BindingPipe=function(_super){function BindingPipe(span,exp,name,args){var _this=_super.call(this,span)||this;return _this.exp=exp,_this.name=name,_this.args=args,_this}return __extends(BindingPipe,_super),BindingPipe.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPipe(this,context)},BindingPipe}(AST),LiteralPrimitive=function(_super){function LiteralPrimitive(span,value){var _this=_super.call(this,span)||this;return _this.value=value,_this}return __extends(LiteralPrimitive,_super),LiteralPrimitive.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitLiteralPrimitive(this,context)},LiteralPrimitive}(AST),LiteralArray=function(_super){function LiteralArray(span,expressions){var _this=_super.call(this,span)||this;return _this.expressions=expressions,_this}return __extends(LiteralArray,_super),LiteralArray.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitLiteralArray(this,context)},LiteralArray}(AST),LiteralMap=function(_super){function LiteralMap(span,keys,values){var _this=_super.call(this,span)||this;return _this.keys=keys,_this.values=values,_this}return __extends(LiteralMap,_super),LiteralMap.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitLiteralMap(this,context)},LiteralMap}(AST),Interpolation=function(_super){function Interpolation(span,strings,expressions){var _this=_super.call(this,span)||this;return _this.strings=strings,_this.expressions=expressions,_this}return __extends(Interpolation,_super),Interpolation.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitInterpolation(this,context)},Interpolation}(AST),Binary=function(_super){function Binary(span,operation,left,right){var _this=_super.call(this,span)||this;return _this.operation=operation,_this.left=left,_this.right=right,_this}return __extends(Binary,_super),Binary.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitBinary(this,context)},Binary}(AST),PrefixNot=function(_super){function PrefixNot(span,expression){var _this=_super.call(this,span)||this;return _this.expression=expression,_this}return __extends(PrefixNot,_super),PrefixNot.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPrefixNot(this,context)},PrefixNot}(AST),NonNullAssert=function(_super){function NonNullAssert(span,expression){var _this=_super.call(this,span)||this;return _this.expression=expression,_this}return __extends(NonNullAssert,_super),NonNullAssert.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitNonNullAssert(this,context)},NonNullAssert}(AST),MethodCall=function(_super){function MethodCall(span,receiver,name,args){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this.args=args,_this}return __extends(MethodCall,_super),MethodCall.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitMethodCall(this,context)},MethodCall}(AST),SafeMethodCall=function(_super){function SafeMethodCall(span,receiver,name,args){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this.args=args,_this}return __extends(SafeMethodCall,_super),SafeMethodCall.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitSafeMethodCall(this,context)},SafeMethodCall}(AST),FunctionCall=function(_super){function FunctionCall(span,target,args){var _this=_super.call(this,span)||this;return _this.target=target,_this.args=args,_this}return __extends(FunctionCall,_super),FunctionCall.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitFunctionCall(this,context)},FunctionCall}(AST),ASTWithSource=function(_super){function ASTWithSource(ast,source,location,errors){var _this=_super.call(this,new ParseSpan(0,null==source?0:source.length))||this;return _this.ast=ast,_this.source=source,_this.location=location,_this.errors=errors,_this}return __extends(ASTWithSource,_super),ASTWithSource.prototype.visit=function(visitor,context){return void 0===context&&(context=null),this.ast.visit(visitor,context)},ASTWithSource.prototype.toString=function(){return this.source+" in "+this.location},ASTWithSource}(AST),TemplateBinding=function(){function TemplateBinding(span,key,keyIsVar,name,expression){this.span=span,this.key=key,this.keyIsVar=keyIsVar,this.name=name,this.expression=expression}return TemplateBinding}(),NullAstVisitor=function(){function NullAstVisitor(){}return NullAstVisitor.prototype.visitBinary=function(ast,context){},NullAstVisitor.prototype.visitChain=function(ast,context){},NullAstVisitor.prototype.visitConditional=function(ast,context){},NullAstVisitor.prototype.visitFunctionCall=function(ast,context){},NullAstVisitor.prototype.visitImplicitReceiver=function(ast,context){},NullAstVisitor.prototype.visitInterpolation=function(ast,context){},NullAstVisitor.prototype.visitKeyedRead=function(ast,context){},NullAstVisitor.prototype.visitKeyedWrite=function(ast,context){},NullAstVisitor.prototype.visitLiteralArray=function(ast,context){},NullAstVisitor.prototype.visitLiteralMap=function(ast,context){},NullAstVisitor.prototype.visitLiteralPrimitive=function(ast,context){},NullAstVisitor.prototype.visitMethodCall=function(ast,context){},NullAstVisitor.prototype.visitPipe=function(ast,context){},NullAstVisitor.prototype.visitPrefixNot=function(ast,context){},NullAstVisitor.prototype.visitNonNullAssert=function(ast,context){},NullAstVisitor.prototype.visitPropertyRead=function(ast,context){},NullAstVisitor.prototype.visitPropertyWrite=function(ast,context){},NullAstVisitor.prototype.visitQuote=function(ast,context){},NullAstVisitor.prototype.visitSafeMethodCall=function(ast,context){},NullAstVisitor.prototype.visitSafePropertyRead=function(ast,context){},NullAstVisitor}(),RecursiveAstVisitor=function(){function RecursiveAstVisitor(){}return RecursiveAstVisitor.prototype.visitBinary=function(ast,context){return ast.left.visit(this),ast.right.visit(this),null},RecursiveAstVisitor.prototype.visitChain=function(ast,context){return this.visitAll(ast.expressions,context)},RecursiveAstVisitor.prototype.visitConditional=function(ast,context){return ast.condition.visit(this),ast.trueExp.visit(this),ast.falseExp.visit(this),null},RecursiveAstVisitor.prototype.visitPipe=function(ast,context){return ast.exp.visit(this),this.visitAll(ast.args,context),null},RecursiveAstVisitor.prototype.visitFunctionCall=function(ast,context){return ast.target.visit(this),this.visitAll(ast.args,context),null},RecursiveAstVisitor.prototype.visitImplicitReceiver=function(ast,context){return null},RecursiveAstVisitor.prototype.visitInterpolation=function(ast,context){return this.visitAll(ast.expressions,context)},RecursiveAstVisitor.prototype.visitKeyedRead=function(ast,context){return ast.obj.visit(this),ast.key.visit(this),null},RecursiveAstVisitor.prototype.visitKeyedWrite=function(ast,context){return ast.obj.visit(this),ast.key.visit(this),ast.value.visit(this),null},RecursiveAstVisitor.prototype.visitLiteralArray=function(ast,context){return this.visitAll(ast.expressions,context)},RecursiveAstVisitor.prototype.visitLiteralMap=function(ast,context){return this.visitAll(ast.values,context)},RecursiveAstVisitor.prototype.visitLiteralPrimitive=function(ast,context){return null},RecursiveAstVisitor.prototype.visitMethodCall=function(ast,context){return ast.receiver.visit(this),this.visitAll(ast.args,context)},RecursiveAstVisitor.prototype.visitPrefixNot=function(ast,context){
return ast.expression.visit(this),null},RecursiveAstVisitor.prototype.visitNonNullAssert=function(ast,context){return ast.expression.visit(this),null},RecursiveAstVisitor.prototype.visitPropertyRead=function(ast,context){return ast.receiver.visit(this),null},RecursiveAstVisitor.prototype.visitPropertyWrite=function(ast,context){return ast.receiver.visit(this),ast.value.visit(this),null},RecursiveAstVisitor.prototype.visitSafePropertyRead=function(ast,context){return ast.receiver.visit(this),null},RecursiveAstVisitor.prototype.visitSafeMethodCall=function(ast,context){return ast.receiver.visit(this),this.visitAll(ast.args,context)},RecursiveAstVisitor.prototype.visitAll=function(asts,context){var _this=this;return asts.forEach(function(ast){return ast.visit(_this,context)}),null},RecursiveAstVisitor.prototype.visitQuote=function(ast,context){return null},RecursiveAstVisitor}(),AstTransformer=function(){function AstTransformer(){}return AstTransformer.prototype.visitImplicitReceiver=function(ast,context){return ast},AstTransformer.prototype.visitInterpolation=function(ast,context){return new Interpolation(ast.span,ast.strings,this.visitAll(ast.expressions))},AstTransformer.prototype.visitLiteralPrimitive=function(ast,context){return new LiteralPrimitive(ast.span,ast.value)},AstTransformer.prototype.visitPropertyRead=function(ast,context){return new PropertyRead(ast.span,ast.receiver.visit(this),ast.name)},AstTransformer.prototype.visitPropertyWrite=function(ast,context){return new PropertyWrite(ast.span,ast.receiver.visit(this),ast.name,ast.value.visit(this))},AstTransformer.prototype.visitSafePropertyRead=function(ast,context){return new SafePropertyRead(ast.span,ast.receiver.visit(this),ast.name)},AstTransformer.prototype.visitMethodCall=function(ast,context){return new MethodCall(ast.span,ast.receiver.visit(this),ast.name,this.visitAll(ast.args))},AstTransformer.prototype.visitSafeMethodCall=function(ast,context){return new SafeMethodCall(ast.span,ast.receiver.visit(this),ast.name,this.visitAll(ast.args))},AstTransformer.prototype.visitFunctionCall=function(ast,context){return new FunctionCall(ast.span,ast.target.visit(this),this.visitAll(ast.args))},AstTransformer.prototype.visitLiteralArray=function(ast,context){return new LiteralArray(ast.span,this.visitAll(ast.expressions))},AstTransformer.prototype.visitLiteralMap=function(ast,context){return new LiteralMap(ast.span,ast.keys,this.visitAll(ast.values))},AstTransformer.prototype.visitBinary=function(ast,context){return new Binary(ast.span,ast.operation,ast.left.visit(this),ast.right.visit(this))},AstTransformer.prototype.visitPrefixNot=function(ast,context){return new PrefixNot(ast.span,ast.expression.visit(this))},AstTransformer.prototype.visitNonNullAssert=function(ast,context){return new NonNullAssert(ast.span,ast.expression.visit(this))},AstTransformer.prototype.visitConditional=function(ast,context){return new Conditional(ast.span,ast.condition.visit(this),ast.trueExp.visit(this),ast.falseExp.visit(this))},AstTransformer.prototype.visitPipe=function(ast,context){return new BindingPipe(ast.span,ast.exp.visit(this),ast.name,this.visitAll(ast.args))},AstTransformer.prototype.visitKeyedRead=function(ast,context){return new KeyedRead(ast.span,ast.obj.visit(this),ast.key.visit(this))},AstTransformer.prototype.visitKeyedWrite=function(ast,context){return new KeyedWrite(ast.span,ast.obj.visit(this),ast.key.visit(this),ast.value.visit(this))},AstTransformer.prototype.visitAll=function(asts){for(var res=new Array(asts.length),i=0;i<asts.length;++i)res[i]=asts[i].visit(this);return res},AstTransformer.prototype.visitChain=function(ast,context){return new Chain(ast.span,this.visitAll(ast.expressions))},AstTransformer.prototype.visitQuote=function(ast,context){return new Quote(ast.span,ast.prefix,ast.uninterpretedExpression,ast.location)},AstTransformer}(),SplitInterpolation=function(){function SplitInterpolation(strings,expressions,offsets){this.strings=strings,this.expressions=expressions,this.offsets=offsets}return SplitInterpolation}(),TemplateBindingParseResult=function(){function TemplateBindingParseResult(templateBindings,warnings,errors){this.templateBindings=templateBindings,this.warnings=warnings,this.errors=errors}return TemplateBindingParseResult}(),Parser=function(){function Parser(_lexer){this._lexer=_lexer,this.errors=[]}return Parser.prototype.parseAction=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),this._checkNoInterpolation(input,location,interpolationConfig);var sourceToLex=this._stripComments(input),tokens=this._lexer.tokenize(this._stripComments(input)),ast=new _ParseAST(input,location,tokens,sourceToLex.length,!0,this.errors,input.length-sourceToLex.length).parseChain();return new ASTWithSource(ast,input,location,this.errors)},Parser.prototype.parseBinding=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var ast=this._parseBindingAst(input,location,interpolationConfig);return new ASTWithSource(ast,input,location,this.errors)},Parser.prototype.parseSimpleBinding=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var ast=this._parseBindingAst(input,location,interpolationConfig),errors=SimpleExpressionChecker.check(ast);return errors.length>0&&this._reportError("Host binding expression cannot contain "+errors.join(" "),input,location),new ASTWithSource(ast,input,location,this.errors)},Parser.prototype._reportError=function(message,input,errLocation,ctxLocation){this.errors.push(new ParserError(message,input,errLocation,ctxLocation))},Parser.prototype._parseBindingAst=function(input,location,interpolationConfig){var quote=this._parseQuote(input,location);if(null!=quote)return quote;this._checkNoInterpolation(input,location,interpolationConfig);var sourceToLex=this._stripComments(input),tokens=this._lexer.tokenize(sourceToLex);return new _ParseAST(input,location,tokens,sourceToLex.length,!1,this.errors,input.length-sourceToLex.length).parseChain()},Parser.prototype._parseQuote=function(input,location){if(null==input)return null;var prefixSeparatorIndex=input.indexOf(":");if(-1==prefixSeparatorIndex)return null;var prefix=input.substring(0,prefixSeparatorIndex).trim();if(!isIdentifier(prefix))return null;var uninterpretedExpression=input.substring(prefixSeparatorIndex+1);return new Quote(new ParseSpan(0,input.length),prefix,uninterpretedExpression,location)},Parser.prototype.parseTemplateBindings=function(prefixToken,input,location){var tokens=this._lexer.tokenize(input);if(prefixToken){var prefixTokens=this._lexer.tokenize(prefixToken).map(function(t){return t.index=0,t});tokens.unshift.apply(tokens,prefixTokens)}return new _ParseAST(input,location,tokens,input.length,!1,this.errors,0).parseTemplateBindings()},Parser.prototype.parseInterpolation=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var split=this.splitInterpolation(input,location,interpolationConfig);if(null==split)return null;for(var expressions=[],i=0;i<split.expressions.length;++i){var expressionText=split.expressions[i],sourceToLex=this._stripComments(expressionText),tokens=this._lexer.tokenize(sourceToLex),ast=new _ParseAST(input,location,tokens,sourceToLex.length,!1,this.errors,split.offsets[i]+(expressionText.length-sourceToLex.length)).parseChain();expressions.push(ast)}return new ASTWithSource(new Interpolation(new ParseSpan(0,null==input?0:input.length),split.strings,expressions),input,location,this.errors)},Parser.prototype.splitInterpolation=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var regexp=_createInterpolateRegExp(interpolationConfig),parts=input.split(regexp);if(parts.length<=1)return null;for(var strings=[],expressions=[],offsets=[],offset=0,i=0;i<parts.length;i++){var part=parts[i];i%2==0?(strings.push(part),offset+=part.length):part.trim().length>0?(offset+=interpolationConfig.start.length,expressions.push(part),offsets.push(offset),offset+=part.length+interpolationConfig.end.length):(this._reportError("Blank expressions are not allowed in interpolated strings",input,"at column "+this._findInterpolationErrorColumn(parts,i,interpolationConfig)+" in",location),expressions.push("$implict"),offsets.push(offset))}return new SplitInterpolation(strings,expressions,offsets)},Parser.prototype.wrapLiteralPrimitive=function(input,location){return new ASTWithSource(new LiteralPrimitive(new ParseSpan(0,null==input?0:input.length),input),input,location,this.errors)},Parser.prototype._stripComments=function(input){var i=this._commentStart(input);return null!=i?input.substring(0,i).trim():input},Parser.prototype._commentStart=function(input){for(var outerQuote=null,i=0;i<input.length-1;i++){var char=input.charCodeAt(i),nextChar=input.charCodeAt(i+1);if(char===$SLASH&&nextChar==$SLASH&&null==outerQuote)return i;outerQuote===char?outerQuote=null:null==outerQuote&&isQuote(char)&&(outerQuote=char)}return null},Parser.prototype._checkNoInterpolation=function(input,location,interpolationConfig){var regexp=_createInterpolateRegExp(interpolationConfig),parts=input.split(regexp);parts.length>1&&this._reportError("Got interpolation ("+interpolationConfig.start+interpolationConfig.end+") where expression was expected",input,"at column "+this._findInterpolationErrorColumn(parts,1,interpolationConfig)+" in",location)},Parser.prototype._findInterpolationErrorColumn=function(parts,partInErrIdx,interpolationConfig){for(var errLocation="",j=0;j<partInErrIdx;j++)errLocation+=j%2==0?parts[j]:""+interpolationConfig.start+parts[j]+interpolationConfig.end;return errLocation.length},Parser}(),_ParseAST=function(){function _ParseAST(input,location,tokens,inputLength,parseAction,errors,offset){this.input=input,this.location=location,this.tokens=tokens,this.inputLength=inputLength,this.parseAction=parseAction,this.errors=errors,this.offset=offset,this.rparensExpected=0,this.rbracketsExpected=0,this.rbracesExpected=0,this.index=0}return _ParseAST.prototype.peek=function(offset){var i=this.index+offset;return i<this.tokens.length?this.tokens[i]:EOF},Object.defineProperty(_ParseAST.prototype,"next",{get:function(){return this.peek(0)},enumerable:!0,configurable:!0}),Object.defineProperty(_ParseAST.prototype,"inputIndex",{get:function(){return this.index<this.tokens.length?this.next.index+this.offset:this.inputLength+this.offset},enumerable:!0,configurable:!0}),_ParseAST.prototype.span=function(start){return new ParseSpan(start,this.inputIndex)},_ParseAST.prototype.advance=function(){this.index++},_ParseAST.prototype.optionalCharacter=function(code){return!!this.next.isCharacter(code)&&(this.advance(),!0)},_ParseAST.prototype.peekKeywordLet=function(){return this.next.isKeywordLet()},_ParseAST.prototype.peekKeywordAs=function(){return this.next.isKeywordAs()},_ParseAST.prototype.expectCharacter=function(code){this.optionalCharacter(code)||this.error("Missing expected "+String.fromCharCode(code))},_ParseAST.prototype.optionalOperator=function(op){return!!this.next.isOperator(op)&&(this.advance(),!0)},_ParseAST.prototype.expectOperator=function(operator){this.optionalOperator(operator)||this.error("Missing expected operator "+operator)},_ParseAST.prototype.expectIdentifierOrKeyword=function(){var n=this.next;return n.isIdentifier()||n.isKeyword()?(this.advance(),n.toString()):(this.error("Unexpected token "+n+", expected identifier or keyword"),"")},_ParseAST.prototype.expectIdentifierOrKeywordOrString=function(){var n=this.next;return n.isIdentifier()||n.isKeyword()||n.isString()?(this.advance(),n.toString()):(this.error("Unexpected token "+n+", expected identifier, keyword, or string"),"")},_ParseAST.prototype.parseChain=function(){for(var exprs=[],start=this.inputIndex;this.index<this.tokens.length;){var expr=this.parsePipe();if(exprs.push(expr),this.optionalCharacter($SEMICOLON))for(this.parseAction||this.error("Binding expression cannot contain chained expression");this.optionalCharacter($SEMICOLON););else this.index<this.tokens.length&&this.error("Unexpected token '"+this.next+"'")}return 0==exprs.length?new EmptyExpr(this.span(start)):1==exprs.length?exprs[0]:new Chain(this.span(start),exprs)},_ParseAST.prototype.parsePipe=function(){var result=this.parseExpression();if(this.optionalOperator("|")){this.parseAction&&this.error("Cannot have a pipe in an action expression");do{for(var name_1=this.expectIdentifierOrKeyword(),args=[];this.optionalCharacter(58);)args.push(this.parseExpression());result=new BindingPipe(this.span(result.span.start),result,name_1,args)}while(this.optionalOperator("|"))}return result},_ParseAST.prototype.parseExpression=function(){return this.parseConditional()},_ParseAST.prototype.parseConditional=function(){var start=this.inputIndex,result=this.parseLogicalOr();if(this.optionalOperator("?")){var yes=this.parsePipe(),no=void 0;if(this.optionalCharacter(58))no=this.parsePipe();else{var end=this.inputIndex,expression=this.input.substring(start,end);this.error("Conditional expression "+expression+" requires all 3 expressions"),no=new EmptyExpr(this.span(start))}return new Conditional(this.span(start),result,yes,no)}return result},_ParseAST.prototype.parseLogicalOr=function(){for(var result=this.parseLogicalAnd();this.optionalOperator("||");){var right=this.parseLogicalAnd();result=new Binary(this.span(result.span.start),"||",result,right)}return result},_ParseAST.prototype.parseLogicalAnd=function(){for(var result=this.parseEquality();this.optionalOperator("&&");){var right=this.parseEquality();result=new Binary(this.span(result.span.start),"&&",result,right)}return result},_ParseAST.prototype.parseEquality=function(){for(var result=this.parseRelational();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"==":case"===":case"!=":case"!==":this.advance();var right=this.parseRelational();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parseRelational=function(){for(var result=this.parseAdditive();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"<":case">":case"<=":case">=":this.advance();var right=this.parseAdditive();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parseAdditive=function(){for(var result=this.parseMultiplicative();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"+":case"-":this.advance();var right=this.parseMultiplicative();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parseMultiplicative=function(){for(var result=this.parsePrefix();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"*":case"%":case"/":this.advance();var right=this.parsePrefix();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parsePrefix=function(){if(this.next.type==TokenType.Operator){var start=this.inputIndex,operator=this.next.strValue,result=void 0;switch(operator){case"+":return this.advance(),result=this.parsePrefix(),new Binary(this.span(start),"-",result,new LiteralPrimitive(new ParseSpan(start,start),0));case"-":return this.advance(),result=this.parsePrefix(),new Binary(this.span(start),operator,new LiteralPrimitive(new ParseSpan(start,start),0),result);case"!":return this.advance(),result=this.parsePrefix(),new PrefixNot(this.span(start),result)}}return this.parseCallChain()},_ParseAST.prototype.parseCallChain=function(){for(var result=this.parsePrimary();;)if(this.optionalCharacter(46))result=this.parseAccessMemberOrMethodCall(result,!1);else if(this.optionalOperator("?."))result=this.parseAccessMemberOrMethodCall(result,!0);else if(this.optionalCharacter(91)){this.rbracketsExpected++;var key=this.parsePipe();if(this.rbracketsExpected--,this.expectCharacter(93),this.optionalOperator("=")){var value=this.parseConditional();result=new KeyedWrite(this.span(result.span.start),result,key,value)}else result=new KeyedRead(this.span(result.span.start),result,key)}else if(this.optionalCharacter(40)){this.rparensExpected++;var args=this.parseCallArguments();this.rparensExpected--,this.expectCharacter(41),result=new FunctionCall(this.span(result.span.start),result,args)}else{if(!this.optionalOperator("!"))return result;result=new NonNullAssert(this.span(result.span.start),result)}},_ParseAST.prototype.parsePrimary=function(){var start=this.inputIndex;if(this.optionalCharacter(40)){this.rparensExpected++;var result=this.parsePipe();return this.rparensExpected--,this.expectCharacter(41),result}if(this.next.isKeywordNull())return this.advance(),new LiteralPrimitive(this.span(start),null);if(this.next.isKeywordUndefined())return this.advance(),new LiteralPrimitive(this.span(start),void 0);if(this.next.isKeywordTrue())return this.advance(),new LiteralPrimitive(this.span(start),!0);if(this.next.isKeywordFalse())return this.advance(),new LiteralPrimitive(this.span(start),!1);if(this.next.isKeywordThis())return this.advance(),new ImplicitReceiver(this.span(start));if(this.optionalCharacter(91)){this.rbracketsExpected++;var elements=this.parseExpressionList(93);return this.rbracketsExpected--,this.expectCharacter(93),new LiteralArray(this.span(start),elements)}if(this.next.isCharacter($LBRACE))return this.parseLiteralMap();if(this.next.isIdentifier())return this.parseAccessMemberOrMethodCall(new ImplicitReceiver(this.span(start)),!1);if(this.next.isNumber()){var value=this.next.toNumber();return this.advance(),new LiteralPrimitive(this.span(start),value)}if(this.next.isString()){var literalValue=this.next.toString();return this.advance(),new LiteralPrimitive(this.span(start),literalValue)}return this.index>=this.tokens.length?(this.error("Unexpected end of expression: "+this.input),new EmptyExpr(this.span(start))):(this.error("Unexpected token "+this.next),new EmptyExpr(this.span(start)))},_ParseAST.prototype.parseExpressionList=function(terminator){var result=[];if(!this.next.isCharacter(terminator))do{result.push(this.parsePipe())}while(this.optionalCharacter(44));return result},_ParseAST.prototype.parseLiteralMap=function(){var keys=[],values=[],start=this.inputIndex;if(this.expectCharacter($LBRACE),!this.optionalCharacter(125)){this.rbracesExpected++;do{var quoted=this.next.isString(),key=this.expectIdentifierOrKeywordOrString();keys.push({key:key,quoted:quoted}),this.expectCharacter(58),values.push(this.parsePipe())}while(this.optionalCharacter(44));this.rbracesExpected--,this.expectCharacter(125)}return new LiteralMap(this.span(start),keys,values)},_ParseAST.prototype.parseAccessMemberOrMethodCall=function(receiver,isSafe){void 0===isSafe&&(isSafe=!1);var start=receiver.span.start,id=this.expectIdentifierOrKeyword();if(this.optionalCharacter(40)){this.rparensExpected++;var args=this.parseCallArguments();this.expectCharacter(41),this.rparensExpected--;var span=this.span(start);return isSafe?new SafeMethodCall(span,receiver,id,args):new MethodCall(span,receiver,id,args)}if(isSafe)return this.optionalOperator("=")?(this.error("The '?.' operator cannot be used in the assignment"),new EmptyExpr(this.span(start))):new SafePropertyRead(this.span(start),receiver,id);if(this.optionalOperator("=")){if(!this.parseAction)return this.error("Bindings cannot contain assignments"),new EmptyExpr(this.span(start));var value=this.parseConditional();return new PropertyWrite(this.span(start),receiver,id,value)}return new PropertyRead(this.span(start),receiver,id)},_ParseAST.prototype.parseCallArguments=function(){if(this.next.isCharacter(41))return[];var positionals=[];do{positionals.push(this.parsePipe())}while(this.optionalCharacter(44));return positionals},_ParseAST.prototype.expectTemplateBindingKey=function(){var result="",operatorFound=!1;do{result+=this.expectIdentifierOrKeywordOrString(),(operatorFound=this.optionalOperator("-"))&&(result+="-")}while(operatorFound);return result.toString()},_ParseAST.prototype.parseTemplateBindings=function(){for(var bindings=[],prefix=null,warnings=[];this.index<this.tokens.length;){var start=this.inputIndex,keyIsVar=this.peekKeywordLet();keyIsVar&&this.advance();var rawKey=this.expectTemplateBindingKey(),key=rawKey;keyIsVar||(null==prefix?prefix=key:key=prefix+key[0].toUpperCase()+key.substring(1)),this.optionalCharacter(58);var name_2=null,expression=null;if(keyIsVar)name_2=this.optionalOperator("=")?this.expectTemplateBindingKey():"$implicit";else if(this.peekKeywordAs()){var letStart=this.inputIndex;this.advance(),name_2=rawKey,key=this.expectTemplateBindingKey(),keyIsVar=!0}else if(this.next!==EOF&&!this.peekKeywordLet()){var start_1=this.inputIndex,ast=this.parsePipe(),source=this.input.substring(start_1-this.offset,this.inputIndex-this.offset);expression=new ASTWithSource(ast,source,this.location,this.errors)}if(bindings.push(new TemplateBinding(this.span(start),key,keyIsVar,name_2,expression)),this.peekKeywordAs()&&!keyIsVar){var letStart=this.inputIndex;this.advance();var letName=this.expectTemplateBindingKey();bindings.push(new TemplateBinding(this.span(letStart),letName,!0,key,null))}this.optionalCharacter($SEMICOLON)||this.optionalCharacter(44)}return new TemplateBindingParseResult(bindings,warnings,this.errors)},_ParseAST.prototype.error=function(message,index){void 0===index&&(index=null),this.errors.push(new ParserError(message,this.input,this.locationText(index),this.location)),this.skip()},_ParseAST.prototype.locationText=function(index){return void 0===index&&(index=null),null==index&&(index=this.index),index<this.tokens.length?"at column "+(this.tokens[index].index+1)+" in":"at the end of the expression"},_ParseAST.prototype.skip=function(){for(var n=this.next;this.index<this.tokens.length&&!n.isCharacter($SEMICOLON)&&(this.rparensExpected<=0||!n.isCharacter(41))&&(this.rbracesExpected<=0||!n.isCharacter(125))&&(this.rbracketsExpected<=0||!n.isCharacter(93));)this.next.isError()&&this.errors.push(new ParserError(this.next.toString(),this.input,this.locationText(),this.location)),this.advance(),n=this.next},_ParseAST}(),SimpleExpressionChecker=function(){function SimpleExpressionChecker(){this.errors=[]}return SimpleExpressionChecker.check=function(ast){var s=new SimpleExpressionChecker;return ast.visit(s),s.errors},SimpleExpressionChecker.prototype.visitImplicitReceiver=function(ast,context){},SimpleExpressionChecker.prototype.visitInterpolation=function(ast,context){},SimpleExpressionChecker.prototype.visitLiteralPrimitive=function(ast,context){},SimpleExpressionChecker.prototype.visitPropertyRead=function(ast,context){},SimpleExpressionChecker.prototype.visitPropertyWrite=function(ast,context){},SimpleExpressionChecker.prototype.visitSafePropertyRead=function(ast,context){},SimpleExpressionChecker.prototype.visitMethodCall=function(ast,context){},SimpleExpressionChecker.prototype.visitSafeMethodCall=function(ast,context){},SimpleExpressionChecker.prototype.visitFunctionCall=function(ast,context){},SimpleExpressionChecker.prototype.visitLiteralArray=function(ast,context){this.visitAll(ast.expressions)},SimpleExpressionChecker.prototype.visitLiteralMap=function(ast,context){this.visitAll(ast.values)},SimpleExpressionChecker.prototype.visitBinary=function(ast,context){},SimpleExpressionChecker.prototype.visitPrefixNot=function(ast,context){},SimpleExpressionChecker.prototype.visitNonNullAssert=function(ast,context){},SimpleExpressionChecker.prototype.visitConditional=function(ast,context){},SimpleExpressionChecker.prototype.visitPipe=function(ast,context){this.errors.push("pipes")},SimpleExpressionChecker.prototype.visitKeyedRead=function(ast,context){},SimpleExpressionChecker.prototype.visitKeyedWrite=function(ast,context){},SimpleExpressionChecker.prototype.visitAll=function(asts){var _this=this;return asts.map(function(node){return node.visit(_this)})},SimpleExpressionChecker.prototype.visitChain=function(ast,context){},SimpleExpressionChecker.prototype.visitQuote=function(ast,context){},SimpleExpressionChecker}(),ParseLocation=function(){function ParseLocation(file,offset,line,col){this.file=file,this.offset=offset,this.line=line,this.col=col}return ParseLocation.prototype.toString=function(){return null!=this.offset?this.file.url+"@"+this.line+":"+this.col:this.file.url},ParseLocation.prototype.moveBy=function(delta){for(var source=this.file.content,len=source.length,offset=this.offset,line=this.line,col=this.col;offset>0&&delta<0;){offset--,delta++;var ch=source.charCodeAt(offset);if(ch==$LF){line--;var priorLine=source.substr(0,offset-1).lastIndexOf(String.fromCharCode($LF));col=priorLine>0?offset-priorLine:offset}else col--}for(;offset<len&&delta>0;){var ch=source.charCodeAt(offset);offset++,delta--,ch==$LF?(line++,col=0):col++}return new ParseLocation(this.file,offset,line,col)},ParseLocation.prototype.getContext=function(maxChars,maxLines){var content=this.file.content,startOffset=this.offset;if(null!=startOffset){startOffset>content.length-1&&(startOffset=content.length-1);for(var endOffset=startOffset,ctxChars=0,ctxLines=0;ctxChars<maxChars&&startOffset>0&&(startOffset--,ctxChars++,"\n"!=content[startOffset]||++ctxLines!=maxLines););for(ctxChars=0,ctxLines=0;ctxChars<maxChars&&endOffset<content.length-1&&(endOffset++,ctxChars++,"\n"!=content[endOffset]||++ctxLines!=maxLines););return{before:content.substring(startOffset,this.offset),after:content.substring(this.offset,endOffset+1)}}return null},ParseLocation}(),ParseSourceFile=function(){function ParseSourceFile(content,url){this.content=content,this.url=url}return ParseSourceFile}(),ParseSourceSpan=function(){function ParseSourceSpan(start,end,details){void 0===details&&(details=null),this.start=start,this.end=end,this.details=details}return ParseSourceSpan.prototype.toString=function(){return this.start.file.content.substring(this.start.offset,this.end.offset)},ParseSourceSpan}(),ParseErrorLevel={WARNING:0,ERROR:1};ParseErrorLevel[ParseErrorLevel.WARNING]="WARNING",ParseErrorLevel[ParseErrorLevel.ERROR]="ERROR";var ParseError=function(){function ParseError(span,msg,level){void 0===level&&(level=ParseErrorLevel.ERROR),this.span=span,this.msg=msg,this.level=level}return ParseError.prototype.contextualMessage=function(){var ctx=this.span.start.getContext(100,3);return ctx?this.msg+' ("'+ctx.before+"["+ParseErrorLevel[this.level]+" ->]"+ctx.after+'")':this.msg},ParseError.prototype.toString=function(){var details=this.span.details?", "+this.span.details:"";return this.contextualMessage()+": "+this.span.start+details},ParseError}(),TokenType$1={TAG_OPEN_START:0,TAG_OPEN_END:1,TAG_OPEN_END_VOID:2,TAG_CLOSE:3,TEXT:4,ESCAPABLE_RAW_TEXT:5,RAW_TEXT:6,COMMENT_START:7,COMMENT_END:8,CDATA_START:9,CDATA_END:10,ATTR_NAME:11,ATTR_VALUE:12,DOC_TYPE:13,EXPANSION_FORM_START:14,EXPANSION_CASE_VALUE:15,EXPANSION_CASE_EXP_START:16,EXPANSION_CASE_EXP_END:17,EXPANSION_FORM_END:18,EOF:19};TokenType$1[TokenType$1.TAG_OPEN_START]="TAG_OPEN_START",TokenType$1[TokenType$1.TAG_OPEN_END]="TAG_OPEN_END",TokenType$1[TokenType$1.TAG_OPEN_END_VOID]="TAG_OPEN_END_VOID",TokenType$1[TokenType$1.TAG_CLOSE]="TAG_CLOSE",TokenType$1[TokenType$1.TEXT]="TEXT",TokenType$1[TokenType$1.ESCAPABLE_RAW_TEXT]="ESCAPABLE_RAW_TEXT",TokenType$1[TokenType$1.RAW_TEXT]="RAW_TEXT",TokenType$1[TokenType$1.COMMENT_START]="COMMENT_START",TokenType$1[TokenType$1.COMMENT_END]="COMMENT_END",TokenType$1[TokenType$1.CDATA_START]="CDATA_START",TokenType$1[TokenType$1.CDATA_END]="CDATA_END",TokenType$1[TokenType$1.ATTR_NAME]="ATTR_NAME",TokenType$1[TokenType$1.ATTR_VALUE]="ATTR_VALUE",TokenType$1[TokenType$1.DOC_TYPE]="DOC_TYPE",TokenType$1[TokenType$1.EXPANSION_FORM_START]="EXPANSION_FORM_START",TokenType$1[TokenType$1.EXPANSION_CASE_VALUE]="EXPANSION_CASE_VALUE",TokenType$1[TokenType$1.EXPANSION_CASE_EXP_START]="EXPANSION_CASE_EXP_START",TokenType$1[TokenType$1.EXPANSION_CASE_EXP_END]="EXPANSION_CASE_EXP_END",TokenType$1[TokenType$1.EXPANSION_FORM_END]="EXPANSION_FORM_END",TokenType$1[TokenType$1.EOF]="EOF";var Token$1=function(){function Token(type,parts,sourceSpan){this.type=type,this.parts=parts,this.sourceSpan=sourceSpan}return Token}(),TokenError=function(_super){function TokenError(errorMsg,tokenType,span){var _this=_super.call(this,span,errorMsg)||this;return _this.tokenType=tokenType,_this}return __extends(TokenError,_super),TokenError}(ParseError),TokenizeResult=function(){function TokenizeResult(tokens,errors){this.tokens=tokens,this.errors=errors}return TokenizeResult}(),_CR_OR_CRLF_REGEXP=/\r\n?/g,_ControlFlowError=function(){function _ControlFlowError(error){this.error=error}return _ControlFlowError}(),_Tokenizer=function(){function _Tokenizer(_file,_getTagDefinition,_tokenizeIcu,_interpolationConfig){void 0===_interpolationConfig&&(_interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),this._file=_file,this._getTagDefinition=_getTagDefinition,this._tokenizeIcu=_tokenizeIcu,this._interpolationConfig=_interpolationConfig,this._peek=-1,this._nextPeek=-1,this._index=-1,this._line=0,this._column=-1,this._expansionCaseStack=[],this._inInterpolation=!1,this.tokens=[],this.errors=[],this._input=_file.content,this._length=_file.content.length,this._advance()}return _Tokenizer.prototype._processCarriageReturns=function(content){return content.replace(_CR_OR_CRLF_REGEXP,"\n")},_Tokenizer.prototype.tokenize=function(){for(;this._peek!==$EOF;){var start=this._getLocation();try{this._attemptCharCode(60)?this._attemptCharCode(33)?this._attemptCharCode(91)?this._consumeCdata(start):this._attemptCharCode($MINUS)?this._consumeComment(start):this._consumeDocType(start):this._attemptCharCode($SLASH)?this._consumeTagClose(start):this._consumeTagOpen(start):this._tokenizeIcu&&this._tokenizeExpansionForm()||this._consumeText()}catch(e){if(!(e instanceof _ControlFlowError))throw e;this.errors.push(e.error)}}return this._beginToken(TokenType$1.EOF),this._endToken([]),new TokenizeResult(mergeTextTokens(this.tokens),this.errors)},_Tokenizer.prototype._tokenizeExpansionForm=function(){if(isExpansionFormStart(this._input,this._index,this._interpolationConfig))return this._consumeExpansionFormStart(),!0;if(isExpansionCaseStart(this._peek)&&this._isInExpansionForm())return this._consumeExpansionCaseStart(),!0;if(125===this._peek){if(this._isInExpansionCase())return this._consumeExpansionCaseEnd(),!0;if(this._isInExpansionForm())return this._consumeExpansionFormEnd(),!0}return!1},_Tokenizer.prototype._getLocation=function(){return new ParseLocation(this._file,this._index,this._line,this._column)},_Tokenizer.prototype._getSpan=function(start,end){return void 0===start&&(start=this._getLocation()),void 0===end&&(end=this._getLocation()),new ParseSourceSpan(start,end)},_Tokenizer.prototype._beginToken=function(type,start){void 0===start&&(start=this._getLocation()),this._currentTokenStart=start,this._currentTokenType=type},_Tokenizer.prototype._endToken=function(parts,end){void 0===end&&(end=this._getLocation());var token=new Token$1(this._currentTokenType,parts,new ParseSourceSpan(this._currentTokenStart,end));return this.tokens.push(token),this._currentTokenStart=null,this._currentTokenType=null,token},_Tokenizer.prototype._createError=function(msg,span){this._isInExpansionForm()&&(msg+=' (Do you have an unescaped "{" in your template? Use "{{ \'{\' }}") to escape it.)');var error=new TokenError(msg,this._currentTokenType,span);return this._currentTokenStart=null,this._currentTokenType=null,new _ControlFlowError(error)},_Tokenizer.prototype._advance=function(){if(this._index>=this._length)throw this._createError(_unexpectedCharacterErrorMsg($EOF),this._getSpan());this._peek===$LF?(this._line++,
this._column=0):this._peek!==$LF&&this._peek!==$CR&&this._column++,this._index++,this._peek=this._index>=this._length?$EOF:this._input.charCodeAt(this._index),this._nextPeek=this._index+1>=this._length?$EOF:this._input.charCodeAt(this._index+1)},_Tokenizer.prototype._attemptCharCode=function(charCode){return this._peek===charCode&&(this._advance(),!0)},_Tokenizer.prototype._attemptCharCodeCaseInsensitive=function(charCode){return!!compareCharCodeCaseInsensitive(this._peek,charCode)&&(this._advance(),!0)},_Tokenizer.prototype._requireCharCode=function(charCode){var location=this._getLocation();if(!this._attemptCharCode(charCode))throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan(location,location))},_Tokenizer.prototype._attemptStr=function(chars){var len=chars.length;if(this._index+len>this._length)return!1;for(var initialPosition=this._savePosition(),i=0;i<len;i++)if(!this._attemptCharCode(chars.charCodeAt(i)))return this._restorePosition(initialPosition),!1;return!0},_Tokenizer.prototype._attemptStrCaseInsensitive=function(chars){for(var i=0;i<chars.length;i++)if(!this._attemptCharCodeCaseInsensitive(chars.charCodeAt(i)))return!1;return!0},_Tokenizer.prototype._requireStr=function(chars){var location=this._getLocation();if(!this._attemptStr(chars))throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan(location))},_Tokenizer.prototype._attemptCharCodeUntilFn=function(predicate){for(;!predicate(this._peek);)this._advance()},_Tokenizer.prototype._requireCharCodeUntilFn=function(predicate,len){var start=this._getLocation();if(this._attemptCharCodeUntilFn(predicate),this._index-start.offset<len)throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan(start,start))},_Tokenizer.prototype._attemptUntilChar=function(char){for(;this._peek!==char;)this._advance()},_Tokenizer.prototype._readChar=function(decodeEntities){if(decodeEntities&&38===this._peek)return this._decodeEntity();var index=this._index;return this._advance(),this._input[index]},_Tokenizer.prototype._decodeEntity=function(){var start=this._getLocation();if(this._advance(),!this._attemptCharCode(35)){var startPosition=this._savePosition();if(this._attemptCharCodeUntilFn(isNamedEntityEnd),this._peek!=$SEMICOLON)return this._restorePosition(startPosition),"&";this._advance();var name_1=this._input.substring(start.offset+1,this._index-1),char=NAMED_ENTITIES[name_1];if(!char)throw this._createError(_unknownEntityErrorMsg(name_1),this._getSpan(start));return char}var isHex=this._attemptCharCode(120)||this._attemptCharCode(88),numberStart=this._getLocation().offset;if(this._attemptCharCodeUntilFn(isDigitEntityEnd),this._peek!=$SEMICOLON)throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan());this._advance();var strNum=this._input.substring(numberStart,this._index-1);try{var charCode=parseInt(strNum,isHex?16:10);return String.fromCharCode(charCode)}catch(e){var entity=this._input.substring(start.offset+1,this._index-1);throw this._createError(_unknownEntityErrorMsg(entity),this._getSpan(start))}},_Tokenizer.prototype._consumeRawText=function(decodeEntities,firstCharOfEnd,attemptEndRest){var tagCloseStart,textStart=this._getLocation();this._beginToken(decodeEntities?TokenType$1.ESCAPABLE_RAW_TEXT:TokenType$1.RAW_TEXT,textStart);for(var parts=[];;){if(tagCloseStart=this._getLocation(),this._attemptCharCode(firstCharOfEnd)&&attemptEndRest())break;for(this._index>tagCloseStart.offset&&parts.push(this._input.substring(tagCloseStart.offset,this._index));this._peek!==firstCharOfEnd;)parts.push(this._readChar(decodeEntities))}return this._endToken([this._processCarriageReturns(parts.join(""))],tagCloseStart)},_Tokenizer.prototype._consumeComment=function(start){var _this=this;this._beginToken(TokenType$1.COMMENT_START,start),this._requireCharCode($MINUS),this._endToken([]);var textToken=this._consumeRawText(!1,$MINUS,function(){return _this._attemptStr("->")});this._beginToken(TokenType$1.COMMENT_END,textToken.sourceSpan.end),this._endToken([])},_Tokenizer.prototype._consumeCdata=function(start){var _this=this;this._beginToken(TokenType$1.CDATA_START,start),this._requireStr("CDATA["),this._endToken([]);var textToken=this._consumeRawText(!1,93,function(){return _this._attemptStr("]>")});this._beginToken(TokenType$1.CDATA_END,textToken.sourceSpan.end),this._endToken([])},_Tokenizer.prototype._consumeDocType=function(start){this._beginToken(TokenType$1.DOC_TYPE,start),this._attemptUntilChar($GT),this._advance(),this._endToken([this._input.substring(start.offset+2,this._index-1)])},_Tokenizer.prototype._consumePrefixAndName=function(){for(var nameOrPrefixStart=this._index,prefix=null;58!==this._peek&&!isPrefixEnd(this._peek);)this._advance();var nameStart;return 58===this._peek?(this._advance(),prefix=this._input.substring(nameOrPrefixStart,this._index-1),nameStart=this._index):nameStart=nameOrPrefixStart,this._requireCharCodeUntilFn(isNameEnd,this._index===nameStart?1:0),[prefix,this._input.substring(nameStart,this._index)]},_Tokenizer.prototype._consumeTagOpen=function(start){var tagName,lowercaseTagName,savedPos=this._savePosition();try{if(!isAsciiLetter(this._peek))throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan());var nameStart=this._index;for(this._consumeTagOpenStart(start),tagName=this._input.substring(nameStart,this._index),lowercaseTagName=tagName.toLowerCase(),this._attemptCharCodeUntilFn(isNotWhitespace);this._peek!==$SLASH&&this._peek!==$GT;)this._consumeAttributeName(),this._attemptCharCodeUntilFn(isNotWhitespace),this._attemptCharCode($EQ)&&(this._attemptCharCodeUntilFn(isNotWhitespace),this._consumeAttributeValue()),this._attemptCharCodeUntilFn(isNotWhitespace);this._consumeTagOpenEnd()}catch(e){if(e instanceof _ControlFlowError)return this._restorePosition(savedPos),this._beginToken(TokenType$1.TEXT,start),void this._endToken(["<"]);throw e}var contentTokenType=this._getTagDefinition(tagName).contentType;contentTokenType===TagContentType.RAW_TEXT?this._consumeRawTextWithTagClose(lowercaseTagName,!1):contentTokenType===TagContentType.ESCAPABLE_RAW_TEXT&&this._consumeRawTextWithTagClose(lowercaseTagName,!0)},_Tokenizer.prototype._consumeRawTextWithTagClose=function(lowercaseTagName,decodeEntities){var _this=this,textToken=this._consumeRawText(decodeEntities,60,function(){return!!_this._attemptCharCode($SLASH)&&(_this._attemptCharCodeUntilFn(isNotWhitespace),!!_this._attemptStrCaseInsensitive(lowercaseTagName)&&(_this._attemptCharCodeUntilFn(isNotWhitespace),_this._attemptCharCode($GT)))});this._beginToken(TokenType$1.TAG_CLOSE,textToken.sourceSpan.end),this._endToken([null,lowercaseTagName])},_Tokenizer.prototype._consumeTagOpenStart=function(start){this._beginToken(TokenType$1.TAG_OPEN_START,start);var parts=this._consumePrefixAndName();this._endToken(parts)},_Tokenizer.prototype._consumeAttributeName=function(){this._beginToken(TokenType$1.ATTR_NAME);var prefixAndName=this._consumePrefixAndName();this._endToken(prefixAndName)},_Tokenizer.prototype._consumeAttributeValue=function(){this._beginToken(TokenType$1.ATTR_VALUE);var value;if(this._peek===$SQ||this._peek===$DQ){var quoteChar=this._peek;this._advance();for(var parts=[];this._peek!==quoteChar;)parts.push(this._readChar(!0));value=parts.join(""),this._advance()}else{var valueStart=this._index;this._requireCharCodeUntilFn(isNameEnd,1),value=this._input.substring(valueStart,this._index)}this._endToken([this._processCarriageReturns(value)])},_Tokenizer.prototype._consumeTagOpenEnd=function(){var tokenType=this._attemptCharCode($SLASH)?TokenType$1.TAG_OPEN_END_VOID:TokenType$1.TAG_OPEN_END;this._beginToken(tokenType),this._requireCharCode($GT),this._endToken([])},_Tokenizer.prototype._consumeTagClose=function(start){this._beginToken(TokenType$1.TAG_CLOSE,start),this._attemptCharCodeUntilFn(isNotWhitespace);var prefixAndName=this._consumePrefixAndName();this._attemptCharCodeUntilFn(isNotWhitespace),this._requireCharCode($GT),this._endToken(prefixAndName)},_Tokenizer.prototype._consumeExpansionFormStart=function(){this._beginToken(TokenType$1.EXPANSION_FORM_START,this._getLocation()),this._requireCharCode($LBRACE),this._endToken([]),this._expansionCaseStack.push(TokenType$1.EXPANSION_FORM_START),this._beginToken(TokenType$1.RAW_TEXT,this._getLocation());var condition=this._readUntil(44);this._endToken([condition],this._getLocation()),this._requireCharCode(44),this._attemptCharCodeUntilFn(isNotWhitespace),this._beginToken(TokenType$1.RAW_TEXT,this._getLocation());var type=this._readUntil(44);this._endToken([type],this._getLocation()),this._requireCharCode(44),this._attemptCharCodeUntilFn(isNotWhitespace)},_Tokenizer.prototype._consumeExpansionCaseStart=function(){this._beginToken(TokenType$1.EXPANSION_CASE_VALUE,this._getLocation());var value=this._readUntil($LBRACE).trim();this._endToken([value],this._getLocation()),this._attemptCharCodeUntilFn(isNotWhitespace),this._beginToken(TokenType$1.EXPANSION_CASE_EXP_START,this._getLocation()),this._requireCharCode($LBRACE),this._endToken([],this._getLocation()),this._attemptCharCodeUntilFn(isNotWhitespace),this._expansionCaseStack.push(TokenType$1.EXPANSION_CASE_EXP_START)},_Tokenizer.prototype._consumeExpansionCaseEnd=function(){this._beginToken(TokenType$1.EXPANSION_CASE_EXP_END,this._getLocation()),this._requireCharCode(125),this._endToken([],this._getLocation()),this._attemptCharCodeUntilFn(isNotWhitespace),this._expansionCaseStack.pop()},_Tokenizer.prototype._consumeExpansionFormEnd=function(){this._beginToken(TokenType$1.EXPANSION_FORM_END,this._getLocation()),this._requireCharCode(125),this._endToken([]),this._expansionCaseStack.pop()},_Tokenizer.prototype._consumeText=function(){var start=this._getLocation();this._beginToken(TokenType$1.TEXT,start);var parts=[];do{this._interpolationConfig&&this._attemptStr(this._interpolationConfig.start)?(parts.push(this._interpolationConfig.start),this._inInterpolation=!0):this._interpolationConfig&&this._inInterpolation&&this._attemptStr(this._interpolationConfig.end)?(parts.push(this._interpolationConfig.end),this._inInterpolation=!1):parts.push(this._readChar(!0))}while(!this._isTextEnd());this._endToken([this._processCarriageReturns(parts.join(""))])},_Tokenizer.prototype._isTextEnd=function(){if(60===this._peek||this._peek===$EOF)return!0;if(this._tokenizeIcu&&!this._inInterpolation){if(isExpansionFormStart(this._input,this._index,this._interpolationConfig))return!0;if(125===this._peek&&this._isInExpansionCase())return!0}return!1},_Tokenizer.prototype._savePosition=function(){return[this._peek,this._index,this._column,this._line,this.tokens.length]},_Tokenizer.prototype._readUntil=function(char){var start=this._index;return this._attemptUntilChar(char),this._input.substring(start,this._index)},_Tokenizer.prototype._restorePosition=function(position){this._peek=position[0],this._index=position[1],this._column=position[2],this._line=position[3];var nbTokens=position[4];nbTokens<this.tokens.length&&(this.tokens=this.tokens.slice(0,nbTokens))},_Tokenizer.prototype._isInExpansionCase=function(){return this._expansionCaseStack.length>0&&this._expansionCaseStack[this._expansionCaseStack.length-1]===TokenType$1.EXPANSION_CASE_EXP_START},_Tokenizer.prototype._isInExpansionForm=function(){return this._expansionCaseStack.length>0&&this._expansionCaseStack[this._expansionCaseStack.length-1]===TokenType$1.EXPANSION_FORM_START},_Tokenizer}(),TreeError=function(_super){function TreeError(elementName,span,msg){var _this=_super.call(this,span,msg)||this;return _this.elementName=elementName,_this}return __extends(TreeError,_super),TreeError.create=function(elementName,span,msg){return new TreeError(elementName,span,msg)},TreeError}(ParseError),ParseTreeResult=function(){function ParseTreeResult(rootNodes,errors){this.rootNodes=rootNodes,this.errors=errors}return ParseTreeResult}(),Parser$1=function(){function Parser(getTagDefinition){this.getTagDefinition=getTagDefinition}return Parser.prototype.parse=function(source,url,parseExpansionForms,interpolationConfig){void 0===parseExpansionForms&&(parseExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var tokensAndErrors=tokenize(source,url,this.getTagDefinition,parseExpansionForms,interpolationConfig),treeAndErrors=new _TreeBuilder(tokensAndErrors.tokens,this.getTagDefinition).build();return new ParseTreeResult(treeAndErrors.rootNodes,tokensAndErrors.errors.concat(treeAndErrors.errors))},Parser}(),_TreeBuilder=function(){function _TreeBuilder(tokens,getTagDefinition){this.tokens=tokens,this.getTagDefinition=getTagDefinition,this._index=-1,this._rootNodes=[],this._errors=[],this._elementStack=[],this._advance()}return _TreeBuilder.prototype.build=function(){for(;this._peek.type!==TokenType$1.EOF;)this._peek.type===TokenType$1.TAG_OPEN_START?this._consumeStartTag(this._advance()):this._peek.type===TokenType$1.TAG_CLOSE?this._consumeEndTag(this._advance()):this._peek.type===TokenType$1.CDATA_START?(this._closeVoidElement(),this._consumeCdata(this._advance())):this._peek.type===TokenType$1.COMMENT_START?(this._closeVoidElement(),this._consumeComment(this._advance())):this._peek.type===TokenType$1.TEXT||this._peek.type===TokenType$1.RAW_TEXT||this._peek.type===TokenType$1.ESCAPABLE_RAW_TEXT?(this._closeVoidElement(),this._consumeText(this._advance())):this._peek.type===TokenType$1.EXPANSION_FORM_START?this._consumeExpansion(this._advance()):this._advance();return new ParseTreeResult(this._rootNodes,this._errors)},_TreeBuilder.prototype._advance=function(){var prev=this._peek;return this._index<this.tokens.length-1&&this._index++,this._peek=this.tokens[this._index],prev},_TreeBuilder.prototype._advanceIf=function(type){return this._peek.type===type?this._advance():null},_TreeBuilder.prototype._consumeCdata=function(startToken){this._consumeText(this._advance()),this._advanceIf(TokenType$1.CDATA_END)},_TreeBuilder.prototype._consumeComment=function(token){var text=this._advanceIf(TokenType$1.RAW_TEXT);this._advanceIf(TokenType$1.COMMENT_END);var value=null!=text?text.parts[0].trim():null;this._addToParent(new Comment(value,token.sourceSpan))},_TreeBuilder.prototype._consumeExpansion=function(token){for(var switchValue=this._advance(),type=this._advance(),cases=[];this._peek.type===TokenType$1.EXPANSION_CASE_VALUE;){var expCase=this._parseExpansionCase();if(!expCase)return;cases.push(expCase)}if(this._peek.type!==TokenType$1.EXPANSION_FORM_END)return void this._errors.push(TreeError.create(null,this._peek.sourceSpan,"Invalid ICU message. Missing '}'."));var sourceSpan=new ParseSourceSpan(token.sourceSpan.start,this._peek.sourceSpan.end);this._addToParent(new Expansion(switchValue.parts[0],type.parts[0],cases,sourceSpan,switchValue.sourceSpan)),this._advance()},_TreeBuilder.prototype._parseExpansionCase=function(){var value=this._advance();if(this._peek.type!==TokenType$1.EXPANSION_CASE_EXP_START)return this._errors.push(TreeError.create(null,this._peek.sourceSpan,"Invalid ICU message. Missing '{'.")),null;var start=this._advance(),exp=this._collectExpansionExpTokens(start);if(!exp)return null;var end=this._advance();exp.push(new Token$1(TokenType$1.EOF,[],end.sourceSpan));var parsedExp=new _TreeBuilder(exp,this.getTagDefinition).build();if(parsedExp.errors.length>0)return this._errors=this._errors.concat(parsedExp.errors),null;var sourceSpan=new ParseSourceSpan(value.sourceSpan.start,end.sourceSpan.end),expSourceSpan=new ParseSourceSpan(start.sourceSpan.start,end.sourceSpan.end);return new ExpansionCase(value.parts[0],parsedExp.rootNodes,sourceSpan,value.sourceSpan,expSourceSpan)},_TreeBuilder.prototype._collectExpansionExpTokens=function(start){for(var exp=[],expansionFormStack=[TokenType$1.EXPANSION_CASE_EXP_START];;){if(this._peek.type!==TokenType$1.EXPANSION_FORM_START&&this._peek.type!==TokenType$1.EXPANSION_CASE_EXP_START||expansionFormStack.push(this._peek.type),this._peek.type===TokenType$1.EXPANSION_CASE_EXP_END){if(!lastOnStack(expansionFormStack,TokenType$1.EXPANSION_CASE_EXP_START))return this._errors.push(TreeError.create(null,start.sourceSpan,"Invalid ICU message. Missing '}'.")),null;if(expansionFormStack.pop(),0==expansionFormStack.length)return exp}if(this._peek.type===TokenType$1.EXPANSION_FORM_END){if(!lastOnStack(expansionFormStack,TokenType$1.EXPANSION_FORM_START))return this._errors.push(TreeError.create(null,start.sourceSpan,"Invalid ICU message. Missing '}'.")),null;expansionFormStack.pop()}if(this._peek.type===TokenType$1.EOF)return this._errors.push(TreeError.create(null,start.sourceSpan,"Invalid ICU message. Missing '}'.")),null;exp.push(this._advance())}},_TreeBuilder.prototype._consumeText=function(token){var text=token.parts[0];if(text.length>0&&"\n"==text[0]){var parent_1=this._getParentElement();null!=parent_1&&0==parent_1.children.length&&this.getTagDefinition(parent_1.name).ignoreFirstLf&&(text=text.substring(1))}text.length>0&&this._addToParent(new Text(text,token.sourceSpan))},_TreeBuilder.prototype._closeVoidElement=function(){var el=this._getParentElement();el&&this.getTagDefinition(el.name).isVoid&&this._elementStack.pop()},_TreeBuilder.prototype._consumeStartTag=function(startTagToken){for(var prefix=startTagToken.parts[0],name=startTagToken.parts[1],attrs=[];this._peek.type===TokenType$1.ATTR_NAME;)attrs.push(this._consumeAttr(this._advance()));var fullName=this._getElementFullName(prefix,name,this._getParentElement()),selfClosing=!1;if(this._peek.type===TokenType$1.TAG_OPEN_END_VOID){this._advance(),selfClosing=!0;var tagDef=this.getTagDefinition(fullName);tagDef.canSelfClose||null!==getNsPrefix(fullName)||tagDef.isVoid||this._errors.push(TreeError.create(fullName,startTagToken.sourceSpan,'Only void and foreign elements can be self closed "'+startTagToken.parts[1]+'"'))}else this._peek.type===TokenType$1.TAG_OPEN_END&&(this._advance(),selfClosing=!1);var end=this._peek.sourceSpan.start,span=new ParseSourceSpan(startTagToken.sourceSpan.start,end),el=new Element(fullName,attrs,[],span,span,void 0);this._pushElement(el),selfClosing&&(this._popElement(fullName),el.endSourceSpan=span)},_TreeBuilder.prototype._pushElement=function(el){var parentEl=this._getParentElement();parentEl&&this.getTagDefinition(parentEl.name).isClosedByChild(el.name)&&this._elementStack.pop();var tagDef=this.getTagDefinition(el.name),_a=this._getParentElementSkippingContainers(),parent=_a.parent,container=_a.container;if(parent&&tagDef.requireExtraParent(parent.name)){var newParent=new Element(tagDef.parentToAdd,[],[],el.sourceSpan,el.startSourceSpan,el.endSourceSpan);this._insertBeforeContainer(parent,container,newParent)}this._addToParent(el),this._elementStack.push(el)},_TreeBuilder.prototype._consumeEndTag=function(endTagToken){var fullName=this._getElementFullName(endTagToken.parts[0],endTagToken.parts[1],this._getParentElement());if(this._getParentElement()&&(this._getParentElement().endSourceSpan=endTagToken.sourceSpan),this.getTagDefinition(fullName).isVoid)this._errors.push(TreeError.create(fullName,endTagToken.sourceSpan,'Void elements do not have end tags "'+endTagToken.parts[1]+'"'));else if(!this._popElement(fullName)){var errMsg='Unexpected closing tag "'+fullName+'". It may happen when the tag has already been closed by another tag. For more info see https://www.w3.org/TR/html5/syntax.html#closing-elements-that-have-implied-end-tags';this._errors.push(TreeError.create(fullName,endTagToken.sourceSpan,errMsg))}},_TreeBuilder.prototype._popElement=function(fullName){for(var stackIndex=this._elementStack.length-1;stackIndex>=0;stackIndex--){var el=this._elementStack[stackIndex];if(el.name==fullName)return this._elementStack.splice(stackIndex,this._elementStack.length-stackIndex),!0;if(!this.getTagDefinition(el.name).closedByParent)return!1}return!1},_TreeBuilder.prototype._consumeAttr=function(attrName){var fullName=mergeNsAndName(attrName.parts[0],attrName.parts[1]),end=attrName.sourceSpan.end,value="",valueSpan=void 0;if(this._peek.type===TokenType$1.ATTR_VALUE){var valueToken=this._advance();value=valueToken.parts[0],end=valueToken.sourceSpan.end,valueSpan=valueToken.sourceSpan}return new Attribute$1(fullName,value,new ParseSourceSpan(attrName.sourceSpan.start,end),valueSpan)},_TreeBuilder.prototype._getParentElement=function(){return this._elementStack.length>0?this._elementStack[this._elementStack.length-1]:null},_TreeBuilder.prototype._getParentElementSkippingContainers=function(){for(var container=null,i=this._elementStack.length-1;i>=0;i--){if(!isNgContainer(this._elementStack[i].name))return{parent:this._elementStack[i],container:container};container=this._elementStack[i]}return{parent:null,container:container}},_TreeBuilder.prototype._addToParent=function(node){var parent=this._getParentElement();null!=parent?parent.children.push(node):this._rootNodes.push(node)},_TreeBuilder.prototype._insertBeforeContainer=function(parent,container,node){if(container){if(parent){var index=parent.children.indexOf(container);parent.children[index]=node}else this._rootNodes.push(node);node.children.push(container),this._elementStack.splice(this._elementStack.indexOf(container),0,node)}else this._addToParent(node),this._elementStack.push(node)},_TreeBuilder.prototype._getElementFullName=function(prefix,localName,parentElement){return null==prefix&&null==(prefix=this.getTagDefinition(localName).implicitNamespacePrefix)&&null!=parentElement&&(prefix=getNsPrefix(parentElement.name)),mergeNsAndName(prefix,localName)},_TreeBuilder}(),_SerializerVisitor=function(){function _SerializerVisitor(){}return _SerializerVisitor.prototype.visitText=function(text,context){return text.value},_SerializerVisitor.prototype.visitContainer=function(container,context){var _this=this;return"["+container.children.map(function(child){return child.visit(_this)}).join(", ")+"]"},_SerializerVisitor.prototype.visitIcu=function(icu,context){var _this=this,strCases=Object.keys(icu.cases).map(function(k){return k+" {"+icu.cases[k].visit(_this)+"}"});return"{"+icu.expression+", "+icu.type+", "+strCases.join(", ")+"}"},_SerializerVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this;return ph.isVoid?'<ph tag name="'+ph.startName+'"/>':'<ph tag name="'+ph.startName+'">'+ph.children.map(function(child){return child.visit(_this)}).join(", ")+'</ph name="'+ph.closeName+'">'},_SerializerVisitor.prototype.visitPlaceholder=function(ph,context){return ph.value?'<ph name="'+ph.name+'">'+ph.value+"</ph>":'<ph name="'+ph.name+'"/>'},_SerializerVisitor.prototype.visitIcuPlaceholder=function(ph,context){return'<ph icu name="'+ph.name+'">'+ph.value.visit(this)+"</ph>"},_SerializerVisitor}(),serializerVisitor=new _SerializerVisitor,_SerializerIgnoreIcuExpVisitor=function(_super){function _SerializerIgnoreIcuExpVisitor(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(_SerializerIgnoreIcuExpVisitor,_super),_SerializerIgnoreIcuExpVisitor.prototype.visitIcu=function(icu,context){var _this=this,strCases=Object.keys(icu.cases).map(function(k){return k+" {"+icu.cases[k].visit(_this)+"}"});return"{"+icu.type+", "+strCases.join(", ")+"}"},_SerializerIgnoreIcuExpVisitor}(_SerializerVisitor),Endian={Little:0,Big:1};Endian[Endian.Little]="Little",Endian[Endian.Big]="Big";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var Message=function(){function Message(nodes,placeholders,placeholderToMessage,meaning,description,id){this.nodes=nodes,this.placeholders=placeholders,this.placeholderToMessage=placeholderToMessage,this.meaning=meaning,this.description=description,this.id=id,nodes.length?this.sources=[{filePath:nodes[0].sourceSpan.start.file.url,startLine:nodes[0].sourceSpan.start.line+1,startCol:nodes[0].sourceSpan.start.col+1,endLine:nodes[nodes.length-1].sourceSpan.end.line+1,endCol:nodes[0].sourceSpan.start.col+1}]:this.sources=[]}return Message}(),Text$1=function(){function Text(value,sourceSpan){this.value=value,this.sourceSpan=sourceSpan}return Text.prototype.visit=function(visitor,context){return visitor.visitText(this,context)},Text}(),Container=function(){function Container(children,sourceSpan){this.children=children,this.sourceSpan=sourceSpan}return Container.prototype.visit=function(visitor,context){return visitor.visitContainer(this,context)},Container}(),Icu=function(){function Icu(expression,type,cases,sourceSpan){this.expression=expression,this.type=type,this.cases=cases,this.sourceSpan=sourceSpan}return Icu.prototype.visit=function(visitor,context){return visitor.visitIcu(this,context)},Icu}(),TagPlaceholder=function(){function TagPlaceholder(tag,attrs,startName,closeName,children,isVoid,sourceSpan){this.tag=tag,this.attrs=attrs,this.startName=startName,this.closeName=closeName,this.children=children,this.isVoid=isVoid,this.sourceSpan=sourceSpan}return TagPlaceholder.prototype.visit=function(visitor,context){return visitor.visitTagPlaceholder(this,context)},TagPlaceholder}(),Placeholder=function(){function Placeholder(value,name,sourceSpan){this.value=value,this.name=name,this.sourceSpan=sourceSpan}return Placeholder.prototype.visit=function(visitor,context){return visitor.visitPlaceholder(this,context)},Placeholder}(),IcuPlaceholder=function(){function IcuPlaceholder(value,name,sourceSpan){this.value=value,this.name=name,this.sourceSpan=sourceSpan}return IcuPlaceholder.prototype.visit=function(visitor,context){return visitor.visitIcuPlaceholder(this,context)},IcuPlaceholder}(),CloneVisitor=function(){function CloneVisitor(){}return CloneVisitor.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},CloneVisitor.prototype.visitContainer=function(container,context){var _this=this,children=container.children.map(function(n){return n.visit(_this,context)});return new Container(children,container.sourceSpan)},CloneVisitor.prototype.visitIcu=function(icu,context){var _this=this,cases={};Object.keys(icu.cases).forEach(function(key){return cases[key]=icu.cases[key].visit(_this,context)});var msg=new Icu(icu.expression,icu.type,cases,icu.sourceSpan);return msg.expressionPlaceholder=icu.expressionPlaceholder,msg},CloneVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this,children=ph.children.map(function(n){return n.visit(_this,context)});return new TagPlaceholder(ph.tag,ph.attrs,ph.startName,ph.closeName,children,ph.isVoid,ph.sourceSpan)},CloneVisitor.prototype.visitPlaceholder=function(ph,context){return new Placeholder(ph.value,ph.name,ph.sourceSpan)},CloneVisitor.prototype.visitIcuPlaceholder=function(ph,context){return new IcuPlaceholder(ph.value,ph.name,ph.sourceSpan)},CloneVisitor}(),RecurseVisitor=function(){function RecurseVisitor(){}return RecurseVisitor.prototype.visitText=function(text,context){},RecurseVisitor.prototype.visitContainer=function(container,context){var _this=this;container.children.forEach(function(child){return child.visit(_this)})},RecurseVisitor.prototype.visitIcu=function(icu,context){var _this=this;Object.keys(icu.cases).forEach(function(k){icu.cases[k].visit(_this)})},RecurseVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this;ph.children.forEach(function(child){return child.visit(_this)})},RecurseVisitor.prototype.visitPlaceholder=function(ph,context){},RecurseVisitor.prototype.visitIcuPlaceholder=function(ph,context){},RecurseVisitor}(),HtmlTagDefinition=function(){function HtmlTagDefinition(_a){var _b=void 0===_a?{}:_a,closedByChildren=_b.closedByChildren,requiredParents=_b.requiredParents,implicitNamespacePrefix=_b.implicitNamespacePrefix,_c=_b.contentType,contentType=void 0===_c?TagContentType.PARSABLE_DATA:_c,_d=_b.closedByParent,closedByParent=void 0!==_d&&_d,_e=_b.isVoid,isVoid=void 0!==_e&&_e,_f=_b.ignoreFirstLf,ignoreFirstLf=void 0!==_f&&_f,_this=this;this.closedByChildren={},this.closedByParent=!1,this.canSelfClose=!1,closedByChildren&&closedByChildren.length>0&&closedByChildren.forEach(function(tagName){return _this.closedByChildren[tagName]=!0}),this.isVoid=isVoid,this.closedByParent=closedByParent||isVoid,requiredParents&&requiredParents.length>0&&(this.requiredParents={},this.parentToAdd=requiredParents[0],requiredParents.forEach(function(tagName){return _this.requiredParents[tagName]=!0})),this.implicitNamespacePrefix=implicitNamespacePrefix||null,this.contentType=contentType,this.ignoreFirstLf=ignoreFirstLf}return HtmlTagDefinition.prototype.requireExtraParent=function(currentParent){if(!this.requiredParents)return!1;if(!currentParent)return!0;var lcParent=currentParent.toLowerCase();return!("template"===lcParent||"ng-template"===currentParent)&&1!=this.requiredParents[lcParent]},HtmlTagDefinition.prototype.isClosedByChild=function(name){return this.isVoid||name.toLowerCase()in this.closedByChildren},HtmlTagDefinition}(),TAG_DEFINITIONS={base:new HtmlTagDefinition({isVoid:!0}),meta:new HtmlTagDefinition({isVoid:!0}),area:new HtmlTagDefinition({isVoid:!0}),embed:new HtmlTagDefinition({isVoid:!0}),link:new HtmlTagDefinition({isVoid:!0}),img:new HtmlTagDefinition({isVoid:!0}),input:new HtmlTagDefinition({isVoid:!0}),param:new HtmlTagDefinition({isVoid:!0}),hr:new HtmlTagDefinition({isVoid:!0}),br:new HtmlTagDefinition({isVoid:!0}),source:new HtmlTagDefinition({isVoid:!0}),track:new HtmlTagDefinition({isVoid:!0}),wbr:new HtmlTagDefinition({isVoid:!0}),p:new HtmlTagDefinition({closedByChildren:["address","article","aside","blockquote","div","dl","fieldset","footer","form","h1","h2","h3","h4","h5","h6","header","hgroup","hr","main","nav","ol","p","pre","section","table","ul"],closedByParent:!0}),thead:new HtmlTagDefinition({closedByChildren:["tbody","tfoot"]}),tbody:new HtmlTagDefinition({closedByChildren:["tbody","tfoot"],closedByParent:!0}),tfoot:new HtmlTagDefinition({closedByChildren:["tbody"],closedByParent:!0}),tr:new HtmlTagDefinition({closedByChildren:["tr"],requiredParents:["tbody","tfoot","thead"],closedByParent:!0}),td:new HtmlTagDefinition({closedByChildren:["td","th"],closedByParent:!0}),th:new HtmlTagDefinition({closedByChildren:["td","th"],closedByParent:!0}),col:new HtmlTagDefinition({requiredParents:["colgroup"],isVoid:!0}),svg:new HtmlTagDefinition({implicitNamespacePrefix:"svg"}),math:new HtmlTagDefinition({implicitNamespacePrefix:"math"}),li:new HtmlTagDefinition({closedByChildren:["li"],closedByParent:!0}),dt:new HtmlTagDefinition({closedByChildren:["dt","dd"]}),dd:new HtmlTagDefinition({closedByChildren:["dt","dd"],closedByParent:!0}),rb:new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:!0}),rt:new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:!0}),rtc:new HtmlTagDefinition({closedByChildren:["rb","rtc","rp"],closedByParent:!0}),rp:new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:!0}),optgroup:new HtmlTagDefinition({closedByChildren:["optgroup"],closedByParent:!0}),option:new HtmlTagDefinition({closedByChildren:["option","optgroup"],closedByParent:!0}),pre:new HtmlTagDefinition({ignoreFirstLf:!0}),listing:new HtmlTagDefinition({ignoreFirstLf:!0}),style:new HtmlTagDefinition({contentType:TagContentType.RAW_TEXT}),script:new HtmlTagDefinition({contentType:TagContentType.RAW_TEXT}),title:new HtmlTagDefinition({contentType:TagContentType.ESCAPABLE_RAW_TEXT}),textarea:new HtmlTagDefinition({contentType:TagContentType.ESCAPABLE_RAW_TEXT,ignoreFirstLf:!0})},_DEFAULT_TAG_DEFINITION=new HtmlTagDefinition,TAG_TO_PLACEHOLDER_NAMES={A:"LINK",B:"BOLD_TEXT",BR:"LINE_BREAK",EM:"EMPHASISED_TEXT",H1:"HEADING_LEVEL1",H2:"HEADING_LEVEL2",H3:"HEADING_LEVEL3",H4:"HEADING_LEVEL4",H5:"HEADING_LEVEL5",H6:"HEADING_LEVEL6",HR:"HORIZONTAL_RULE",I:"ITALIC_TEXT",LI:"LIST_ITEM",LINK:"MEDIA_LINK",OL:"ORDERED_LIST",P:"PARAGRAPH",Q:"QUOTATION",S:"STRIKETHROUGH_TEXT",SMALL:"SMALL_TEXT",SUB:"SUBSTRIPT",SUP:"SUPERSCRIPT",TBODY:"TABLE_BODY",TD:"TABLE_CELL",TFOOT:"TABLE_FOOTER",TH:"TABLE_HEADER_CELL",THEAD:"TABLE_HEADER",TR:"TABLE_ROW",TT:"MONOSPACED_TEXT",U:"UNDERLINED_TEXT",UL:"UNORDERED_LIST"},PlaceholderRegistry=function(){function PlaceholderRegistry(){this._placeHolderNameCounts={},this._signatureToName={}}return PlaceholderRegistry.prototype.getStartTagPlaceholderName=function(tag,attrs,isVoid){var signature=this._hashTag(tag,attrs,isVoid);if(this._signatureToName[signature])return this._signatureToName[signature];var upperTag=tag.toUpperCase(),baseName=TAG_TO_PLACEHOLDER_NAMES[upperTag]||"TAG_"+upperTag,name=this._generateUniqueName(isVoid?baseName:"START_"+baseName);return this._signatureToName[signature]=name,name},PlaceholderRegistry.prototype.getCloseTagPlaceholderName=function(tag){var signature=this._hashClosingTag(tag);if(this._signatureToName[signature])return this._signatureToName[signature];var upperTag=tag.toUpperCase(),baseName=TAG_TO_PLACEHOLDER_NAMES[upperTag]||"TAG_"+upperTag,name=this._generateUniqueName("CLOSE_"+baseName);return this._signatureToName[signature]=name,name},PlaceholderRegistry.prototype.getPlaceholderName=function(name,content){var upperName=name.toUpperCase(),signature="PH: "+upperName+"="+content;if(this._signatureToName[signature])return this._signatureToName[signature];var uniqueName=this._generateUniqueName(upperName);return this._signatureToName[signature]=uniqueName,uniqueName},PlaceholderRegistry.prototype.getUniquePlaceholder=function(name){return this._generateUniqueName(name.toUpperCase())},PlaceholderRegistry.prototype._hashTag=function(tag,attrs,isVoid){return"<"+tag+Object.keys(attrs).sort().map(function(name){return" "+name+"="+attrs[name]}).join("")+(isVoid?"/>":"></"+tag+">")},PlaceholderRegistry.prototype._hashClosingTag=function(tag){return this._hashTag("/"+tag,{},!1)},PlaceholderRegistry.prototype._generateUniqueName=function(base){if(!this._placeHolderNameCounts.hasOwnProperty(base))return this._placeHolderNameCounts[base]=1,base;var id=this._placeHolderNameCounts[base];return this._placeHolderNameCounts[base]=id+1,base+"_"+id},PlaceholderRegistry}(),_expParser=new Parser(new Lexer),_I18nVisitor=function(){function _I18nVisitor(_expressionParser,_interpolationConfig){this._expressionParser=_expressionParser,this._interpolationConfig=_interpolationConfig}return _I18nVisitor.prototype.toI18nMessage=function(nodes,meaning,description,id){this._isIcu=1==nodes.length&&nodes[0]instanceof Expansion,this._icuDepth=0,this._placeholderRegistry=new PlaceholderRegistry,this._placeholderToContent={},this._placeholderToMessage={};var i18nodes=visitAll(this,nodes,{});return new Message(i18nodes,this._placeholderToContent,this._placeholderToMessage,meaning,description,id)},_I18nVisitor.prototype.visitElement=function(el,context){var children=visitAll(this,el.children),attrs={};el.attrs.forEach(function(attr){attrs[attr.name]=attr.value});var isVoid=getHtmlTagDefinition(el.name).isVoid,startPhName=this._placeholderRegistry.getStartTagPlaceholderName(el.name,attrs,isVoid);this._placeholderToContent[startPhName]=el.sourceSpan.toString();var closePhName="";return isVoid||(closePhName=this._placeholderRegistry.getCloseTagPlaceholderName(el.name),this._placeholderToContent[closePhName]="</"+el.name+">"),new TagPlaceholder(el.name,attrs,startPhName,closePhName,children,isVoid,el.sourceSpan)},_I18nVisitor.prototype.visitAttribute=function(attribute,context){return this._visitTextWithInterpolation(attribute.value,attribute.sourceSpan)},_I18nVisitor.prototype.visitText=function(text,context){return this._visitTextWithInterpolation(text.value,text.sourceSpan)},_I18nVisitor.prototype.visitComment=function(comment,context){return null},_I18nVisitor.prototype.visitExpansion=function(icu,context){var _this=this;this._icuDepth++;var i18nIcuCases={},i18nIcu=new Icu(icu.switchValue,icu.type,i18nIcuCases,icu.sourceSpan);if(icu.cases.forEach(function(caze){i18nIcuCases[caze.value]=new Container(caze.expression.map(function(node){return node.visit(_this,{})}),caze.expSourceSpan)}),this._icuDepth--,this._isIcu||this._icuDepth>0){var expPh=this._placeholderRegistry.getUniquePlaceholder("VAR_"+icu.type);return i18nIcu.expressionPlaceholder=expPh,this._placeholderToContent[expPh]=icu.switchValue,i18nIcu}var phName=this._placeholderRegistry.getPlaceholderName("ICU",icu.sourceSpan.toString()),visitor=new _I18nVisitor(this._expressionParser,this._interpolationConfig);return this._placeholderToMessage[phName]=visitor.toI18nMessage([icu],"","",""),new IcuPlaceholder(i18nIcu,phName,icu.sourceSpan)},_I18nVisitor.prototype.visitExpansionCase=function(icuCase,context){throw new Error("Unreachable code")},_I18nVisitor.prototype._visitTextWithInterpolation=function(text,sourceSpan){var splitInterpolation=this._expressionParser.splitInterpolation(text,sourceSpan.start.toString(),this._interpolationConfig);if(!splitInterpolation)return new Text$1(text,sourceSpan);for(var nodes=[],container=new Container(nodes,sourceSpan),_a=this._interpolationConfig,sDelimiter=_a.start,eDelimiter=_a.end,i=0;i<splitInterpolation.strings.length-1;i++){var expression=splitInterpolation.expressions[i],baseName=_extractPlaceholderName(expression)||"INTERPOLATION",phName=this._placeholderRegistry.getPlaceholderName(baseName,expression);splitInterpolation.strings[i].length&&nodes.push(new Text$1(splitInterpolation.strings[i],sourceSpan)),nodes.push(new Placeholder(expression,phName,sourceSpan)),this._placeholderToContent[phName]=sDelimiter+expression+eDelimiter}var lastStringIdx=splitInterpolation.strings.length-1;return splitInterpolation.strings[lastStringIdx].length&&nodes.push(new Text$1(splitInterpolation.strings[lastStringIdx],sourceSpan)),container},_I18nVisitor}(),_CUSTOM_PH_EXP=/\/\/[\s\S]*i18n[\s\S]*\([\s\S]*ph[\s\S]*=[\s\S]*("|')([\s\S]*?)\1[\s\S]*\)/g,I18nError=function(_super){function I18nError(span,msg){return _super.call(this,span,msg)||this}return __extends(I18nError,_super),I18nError}(ParseError),_I18N_ATTR="i18n",_I18N_COMMENT_PREFIX_REGEXP=/^i18n:?/,MEANING_SEPARATOR="|",ID_SEPARATOR="@@",i18nCommentsWarned=!1,ExtractionResult=function(){function ExtractionResult(messages,errors){this.messages=messages,this.errors=errors}return ExtractionResult}(),_VisitorMode={Extract:0,Merge:1};_VisitorMode[_VisitorMode.Extract]="Extract",_VisitorMode[_VisitorMode.Merge]="Merge";var _Visitor=function(){function _Visitor(_implicitTags,_implicitAttrs){this._implicitTags=_implicitTags,this._implicitAttrs=_implicitAttrs}return _Visitor.prototype.extract=function(nodes,interpolationConfig){var _this=this;return this._init(_VisitorMode.Extract,interpolationConfig),nodes.forEach(function(node){return node.visit(_this,null)}),this._inI18nBlock&&this._reportError(nodes[nodes.length-1],"Unclosed block"),new ExtractionResult(this._messages,this._errors)},_Visitor.prototype.merge=function(nodes,translations,interpolationConfig){this._init(_VisitorMode.Merge,interpolationConfig),this._translations=translations;var wrapper=new Element("wrapper",[],nodes,void 0,void 0,void 0),translatedNode=wrapper.visit(this,null);return this._inI18nBlock&&this._reportError(nodes[nodes.length-1],"Unclosed block"),new ParseTreeResult(translatedNode.children,this._errors)},_Visitor.prototype.visitExpansionCase=function(icuCase,context){var expression=visitAll(this,icuCase.expression,context);if(this._mode===_VisitorMode.Merge)return new ExpansionCase(icuCase.value,expression,icuCase.sourceSpan,icuCase.valueSourceSpan,icuCase.expSourceSpan)},_Visitor.prototype.visitExpansion=function(icu,context){this._mayBeAddBlockChildren(icu);var wasInIcu=this._inIcu;this._inIcu||(this._isInTranslatableSection&&this._addMessage([icu]),this._inIcu=!0);var cases=visitAll(this,icu.cases,context);return this._mode===_VisitorMode.Merge&&(icu=new Expansion(icu.switchValue,icu.type,cases,icu.sourceSpan,icu.switchValueSourceSpan)),this._inIcu=wasInIcu,icu},_Visitor.prototype.visitComment=function(comment,context){var isOpening=_isOpeningComment(comment);if(isOpening&&this._isInTranslatableSection)return void this._reportError(comment,"Could not start a block inside a translatable section");var isClosing=_isClosingComment(comment);if(isClosing&&!this._inI18nBlock)return void this._reportError(comment,"Trying to close an unopened block");if(!this._inI18nNode&&!this._inIcu)if(this._inI18nBlock){if(isClosing){if(this._depth==this._blockStartDepth){this._closeTranslatableSection(comment,this._blockChildren),this._inI18nBlock=!1;var message=this._addMessage(this._blockChildren,this._blockMeaningAndDesc),nodes=this._translateMessage(comment,message);return visitAll(this,nodes)}return void this._reportError(comment,"I18N blocks should not cross element boundaries")}}else if(isOpening){if(!i18nCommentsWarned&&console&&console.warn){i18nCommentsWarned=!0;var details=comment.sourceSpan.details?", "+comment.sourceSpan.details:"";console.warn("I18n comments are deprecated, use an <ng-container> element instead ("+comment.sourceSpan.start+details+")")}this._inI18nBlock=!0,this._blockStartDepth=this._depth,this._blockChildren=[],this._blockMeaningAndDesc=comment.value.replace(_I18N_COMMENT_PREFIX_REGEXP,"").trim(),this._openTranslatableSection(comment)}},_Visitor.prototype.visitText=function(text,context){return this._isInTranslatableSection&&this._mayBeAddBlockChildren(text),text},_Visitor.prototype.visitElement=function(el,context){var _this=this;this._mayBeAddBlockChildren(el),this._depth++;var wasInI18nNode=this._inI18nNode,wasInImplicitNode=this._inImplicitNode,childNodes=[],translatedChildNodes=void 0,i18nAttr=_getI18nAttr(el),i18nMeta=i18nAttr?i18nAttr.value:"",isImplicit=this._implicitTags.some(function(tag){return el.name===tag})&&!this._inIcu&&!this._isInTranslatableSection,isTopLevelImplicit=!wasInImplicitNode&&isImplicit;if(this._inImplicitNode=wasInImplicitNode||isImplicit,this._isInTranslatableSection||this._inIcu)(i18nAttr||isTopLevelImplicit)&&this._reportError(el,"Could not mark an element as translatable inside a translatable section"),this._mode==_VisitorMode.Extract&&visitAll(this,el.children);else{if(i18nAttr||isTopLevelImplicit){this._inI18nNode=!0;var message=this._addMessage(el.children,i18nMeta);translatedChildNodes=this._translateMessage(el,message)}if(this._mode==_VisitorMode.Extract){var isTranslatable=i18nAttr||isTopLevelImplicit;isTranslatable&&this._openTranslatableSection(el),visitAll(this,el.children),isTranslatable&&this._closeTranslatableSection(el,el.children)}}if(this._mode===_VisitorMode.Merge){(translatedChildNodes||el.children).forEach(function(child){var visited=child.visit(_this,context);visited&&!_this._isInTranslatableSection&&(childNodes=childNodes.concat(visited))})}if(this._visitAttributesOf(el),this._depth--,this._inI18nNode=wasInI18nNode,this._inImplicitNode=wasInImplicitNode,this._mode===_VisitorMode.Merge){var translatedAttrs=this._translateAttributes(el);return new Element(el.name,translatedAttrs,childNodes,el.sourceSpan,el.startSourceSpan,el.endSourceSpan)}return null},_Visitor.prototype.visitAttribute=function(attribute,context){throw new Error("unreachable code")},_Visitor.prototype._init=function(mode,interpolationConfig){this._mode=mode,this._inI18nBlock=!1,this._inI18nNode=!1,this._depth=0,this._inIcu=!1,this._msgCountAtSectionStart=void 0,this._errors=[],this._messages=[],this._inImplicitNode=!1,this._createI18nMessage=createI18nMessageFactory(interpolationConfig)},_Visitor.prototype._visitAttributesOf=function(el){var _this=this,explicitAttrNameToValue={},implicitAttrNames=this._implicitAttrs[el.name]||[];el.attrs.filter(function(attr){return attr.name.startsWith("i18n-")}).forEach(function(attr){return explicitAttrNameToValue[attr.name.slice("i18n-".length)]=attr.value}),el.attrs.forEach(function(attr){attr.name in explicitAttrNameToValue?_this._addMessage([attr],explicitAttrNameToValue[attr.name]):implicitAttrNames.some(function(name){return attr.name===name})&&_this._addMessage([attr])})},_Visitor.prototype._addMessage=function(ast,msgMeta){if(0==ast.length||1==ast.length&&ast[0]instanceof Attribute$1&&!ast[0].value)return null;var _a=_parseMessageMeta(msgMeta),meaning=_a.meaning,description=_a.description,id=_a.id,message=this._createI18nMessage(ast,meaning,description,id);return this._messages.push(message),message},_Visitor.prototype._translateMessage=function(el,message){if(message&&this._mode===_VisitorMode.Merge){var nodes=this._translations.get(message);if(nodes)return nodes;this._reportError(el,'Translation unavailable for message id="'+this._translations.digest(message)+'"')}return[]},_Visitor.prototype._translateAttributes=function(el){var _this=this,attributes=el.attrs,i18nParsedMessageMeta={};attributes.forEach(function(attr){attr.name.startsWith("i18n-")&&(i18nParsedMessageMeta[attr.name.slice("i18n-".length)]=_parseMessageMeta(attr.value))});var translatedAttributes=[];return attributes.forEach(function(attr){if(attr.name!==_I18N_ATTR&&!attr.name.startsWith("i18n-"))if(attr.value&&""!=attr.value&&i18nParsedMessageMeta.hasOwnProperty(attr.name)){var _a=i18nParsedMessageMeta[attr.name],meaning=_a.meaning,description=_a.description,id=_a.id,message=_this._createI18nMessage([attr],meaning,description,id),nodes=_this._translations.get(message);if(nodes)if(0==nodes.length)translatedAttributes.push(new Attribute$1(attr.name,"",attr.sourceSpan));else if(nodes[0]instanceof Text){var value=nodes[0].value;translatedAttributes.push(new Attribute$1(attr.name,value,attr.sourceSpan))}else _this._reportError(el,'Unexpected translation for attribute "'+attr.name+'" (id="'+(id||_this._translations.digest(message))+'")');else _this._reportError(el,'Translation unavailable for attribute "'+attr.name+'" (id="'+(id||_this._translations.digest(message))+'")')}else translatedAttributes.push(attr)}),translatedAttributes},_Visitor.prototype._mayBeAddBlockChildren=function(node){this._inI18nBlock&&!this._inIcu&&this._depth==this._blockStartDepth&&this._blockChildren.push(node)},_Visitor.prototype._openTranslatableSection=function(node){this._isInTranslatableSection?this._reportError(node,"Unexpected section start"):this._msgCountAtSectionStart=this._messages.length},Object.defineProperty(_Visitor.prototype,"_isInTranslatableSection",{get:function(){return void 0!==this._msgCountAtSectionStart},enumerable:!0,configurable:!0}),_Visitor.prototype._closeTranslatableSection=function(node,directChildren){if(!this._isInTranslatableSection)return void this._reportError(node,"Unexpected section end");var startIndex=this._msgCountAtSectionStart;if(1==directChildren.reduce(function(count,node){return count+(node instanceof Comment?0:1)},0))for(var i=this._messages.length-1;i>=startIndex;i--){var ast=this._messages[i].nodes;if(!(1==ast.length&&ast[0]instanceof Text$1)){this._messages.splice(i,1);break}}this._msgCountAtSectionStart=void 0},_Visitor.prototype._reportError=function(node,msg){this._errors.push(new I18nError(node.sourceSpan,msg))},_Visitor}(),XmlTagDefinition=function(){function XmlTagDefinition(){this.closedByParent=!1,this.contentType=TagContentType.PARSABLE_DATA,this.isVoid=!1,this.ignoreFirstLf=!1,this.canSelfClose=!0}return XmlTagDefinition.prototype.requireExtraParent=function(currentParent){return!1},XmlTagDefinition.prototype.isClosedByChild=function(name){return!1},XmlTagDefinition}(),_TAG_DEFINITION=new XmlTagDefinition,XmlParser=function(_super){function XmlParser(){return _super.call(this,getXmlTagDefinition)||this}return __extends(XmlParser,_super),XmlParser.prototype.parse=function(source,url,parseExpansionForms){return void 0===parseExpansionForms&&(parseExpansionForms=!1),_super.prototype.parse.call(this,source,url,parseExpansionForms)},XmlParser}(Parser$1),Serializer=function(){function Serializer(){}return Serializer.prototype.createNameMapper=function(message){return null},Serializer}(),SimplePlaceholderMapper=function(_super){function SimplePlaceholderMapper(message,mapName){var _this=_super.call(this)||this;return _this.mapName=mapName,_this.internalToPublic={},_this.publicToNextId={},_this.publicToInternal={},message.nodes.forEach(function(node){return node.visit(_this)}),_this}return __extends(SimplePlaceholderMapper,_super),SimplePlaceholderMapper.prototype.toPublicName=function(internalName){return this.internalToPublic.hasOwnProperty(internalName)?this.internalToPublic[internalName]:null},SimplePlaceholderMapper.prototype.toInternalName=function(publicName){return this.publicToInternal.hasOwnProperty(publicName)?this.publicToInternal[publicName]:null},SimplePlaceholderMapper.prototype.visitText=function(text,context){return null},SimplePlaceholderMapper.prototype.visitTagPlaceholder=function(ph,context){this.visitPlaceholderName(ph.startName),_super.prototype.visitTagPlaceholder.call(this,ph,context),this.visitPlaceholderName(ph.closeName)},SimplePlaceholderMapper.prototype.visitPlaceholder=function(ph,context){this.visitPlaceholderName(ph.name)},SimplePlaceholderMapper.prototype.visitIcuPlaceholder=function(ph,context){this.visitPlaceholderName(ph.name)},SimplePlaceholderMapper.prototype.visitPlaceholderName=function(internalName){if(internalName&&!this.internalToPublic.hasOwnProperty(internalName)){var publicName=this.mapName(internalName);if(this.publicToInternal.hasOwnProperty(publicName)){var nextId=this.publicToNextId[publicName];this.publicToNextId[publicName]=nextId+1,publicName=publicName+"_"+nextId}else this.publicToNextId[publicName]=1;this.internalToPublic[internalName]=publicName,this.publicToInternal[publicName]=internalName}},SimplePlaceholderMapper}(RecurseVisitor),_Visitor$1=function(){function _Visitor(){}return _Visitor.prototype.visitTag=function(tag){var _this=this,strAttrs=this._serializeAttributes(tag.attrs);if(0==tag.children.length)return"<"+tag.name+strAttrs+"/>";var strChildren=tag.children.map(function(node){return node.visit(_this)});return"<"+tag.name+strAttrs+">"+strChildren.join("")+"</"+tag.name+">"},_Visitor.prototype.visitText=function(text){return text.value},_Visitor.prototype.visitDeclaration=function(decl){return"<?xml"+this._serializeAttributes(decl.attrs)+" ?>"},_Visitor.prototype._serializeAttributes=function(attrs){var strAttrs=Object.keys(attrs).map(function(name){return name+'="'+attrs[name]+'"'}).join(" ");return strAttrs.length>0?" "+strAttrs:""},_Visitor.prototype.visitDoctype=function(doctype){return"<!DOCTYPE "+doctype.rootTag+" [\n"+doctype.dtd+"\n]>"},_Visitor}(),_visitor=new _Visitor$1,Declaration=function(){function Declaration(unescapedAttrs){var _this=this;this.attrs={},Object.keys(unescapedAttrs).forEach(function(k){_this.attrs[k]=escapeXml(unescapedAttrs[k])})}return Declaration.prototype.visit=function(visitor){return visitor.visitDeclaration(this)},Declaration}(),Doctype=function(){function Doctype(rootTag,dtd){this.rootTag=rootTag,this.dtd=dtd}return Doctype.prototype.visit=function(visitor){return visitor.visitDoctype(this)},Doctype}(),Tag=function(){function Tag(name,unescapedAttrs,children){void 0===unescapedAttrs&&(unescapedAttrs={}),void 0===children&&(children=[]);var _this=this;this.name=name,this.children=children,this.attrs={},Object.keys(unescapedAttrs).forEach(function(k){_this.attrs[k]=escapeXml(unescapedAttrs[k])})}return Tag.prototype.visit=function(visitor){return visitor.visitTag(this)},Tag}(),Text$2=function(){function Text(unescapedValue){this.value=escapeXml(unescapedValue)}return Text.prototype.visit=function(visitor){return visitor.visitText(this)},Text}(),CR=function(_super){function CR(ws){return void 0===ws&&(ws=0),_super.call(this,"\n"+new Array(ws+1).join(" "))||this}return __extends(CR,_super),CR}(Text$2),_ESCAPED_CHARS=[[/&/g,"&amp;"],[/"/g,"&quot;"],[/'/g,"&apos;"],[/</g,"&lt;"],[/>/g,"&gt;"]],Xliff=function(_super){function Xliff(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xliff,_super),Xliff.prototype.write=function(messages,locale){var visitor=new _WriteVisitor,transUnits=[];messages.forEach(function(message){var contextTags=[];message.sources.forEach(function(source){var contextGroupTag=new Tag("context-group",{purpose:"location"});contextGroupTag.children.push(new CR(10),new Tag("context",{"context-type":"sourcefile"},[new Text$2(source.filePath)]),new CR(10),new Tag("context",{"context-type":"linenumber"},[new Text$2(""+source.startLine)]),new CR(8)),contextTags.push(new CR(8),contextGroupTag)});var transUnit=new Tag("trans-unit",{id:message.id,datatype:"html"});(_a=transUnit.children).push.apply(_a,[new CR(8),new Tag("source",{},visitor.serialize(message.nodes))].concat(contextTags)),message.description&&transUnit.children.push(new CR(8),new Tag("note",{priority:"1",from:"description"},[new Text$2(message.description)])),message.meaning&&transUnit.children.push(new CR(8),new Tag("note",{priority:"1",from:"meaning"},[new Text$2(message.meaning)])),transUnit.children.push(new CR(6)),transUnits.push(new CR(6),transUnit);var _a});var body=new Tag("body",{},transUnits.concat([new CR(4)])),file=new Tag("file",{"source-language":locale||"en",datatype:"plaintext",original:"ng2.template"},[new CR(4),body,new CR(2)]),xliff=new Tag("xliff",{version:"1.2",xmlns:"urn:oasis:names:tc:xliff:document:1.2"},[new CR(2),file,new CR]);return serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,xliff,new CR])},Xliff.prototype.load=function(content,url){var xliffParser=new XliffParser,_a=xliffParser.parse(content,url),locale=_a.locale,msgIdToHtml=_a.msgIdToHtml,errors=_a.errors,i18nNodesByMsgId={},converter=new XmlToI18n;if(Object.keys(msgIdToHtml).forEach(function(msgId){var _a=converter.convert(msgIdToHtml[msgId],url),i18nNodes=_a.i18nNodes,e=_a.errors;errors.push.apply(errors,e),i18nNodesByMsgId[msgId]=i18nNodes}),errors.length)throw new Error("xliff parse errors:\n"+errors.join("\n"));return{locale:locale,i18nNodesByMsgId:i18nNodesByMsgId}},Xliff.prototype.digest=function(message){return digest(message)},Xliff}(Serializer),_WriteVisitor=function(){function _WriteVisitor(){}return _WriteVisitor.prototype.visitText=function(text,context){return[new Text$2(text.value)]},_WriteVisitor.prototype.visitContainer=function(container,context){var _this=this,nodes=[];return container.children.forEach(function(node){return nodes.push.apply(nodes,node.visit(_this))}),nodes},_WriteVisitor.prototype.visitIcu=function(icu,context){var _this=this,nodes=[new Text$2("{"+icu.expressionPlaceholder+", "+icu.type+", ")];return Object.keys(icu.cases).forEach(function(c){nodes.push.apply(nodes,[new Text$2(c+" {")].concat(icu.cases[c].visit(_this),[new Text$2("} ")]))}),nodes.push(new Text$2("}")),nodes},_WriteVisitor.prototype.visitTagPlaceholder=function(ph,context){var ctype=getCtypeForTag(ph.tag);if(ph.isVoid)return[new Tag("x",{id:ph.startName,ctype:ctype,"equiv-text":"<"+ph.tag+"/>"})];var startTagPh=new Tag("x",{id:ph.startName,ctype:ctype,"equiv-text":"<"+ph.tag+">"}),closeTagPh=new Tag("x",{id:ph.closeName,ctype:ctype,"equiv-text":"</"+ph.tag+">"});return[startTagPh].concat(this.serialize(ph.children),[closeTagPh])},_WriteVisitor.prototype.visitPlaceholder=function(ph,context){return[new Tag("x",{id:ph.name,"equiv-text":"{{"+ph.value+"}}"})]},_WriteVisitor.prototype.visitIcuPlaceholder=function(ph,context){var equivText="{"+ph.value.expression+", "+ph.value.type+", "+Object.keys(ph.value.cases).map(function(value){return value+" {...}"}).join(" ")+"}";return[new Tag("x",{id:ph.name,"equiv-text":equivText})]},_WriteVisitor.prototype.serialize=function(nodes){var _this=this
;return[].concat.apply([],nodes.map(function(node){return node.visit(_this)}))},_WriteVisitor}(),XliffParser=function(){function XliffParser(){this._locale=null}return XliffParser.prototype.parse=function(xliff,url){this._unitMlString=null,this._msgIdToHtml={};var xml=(new XmlParser).parse(xliff,url,!1);return this._errors=xml.errors,visitAll(this,xml.rootNodes,null),{msgIdToHtml:this._msgIdToHtml,errors:this._errors,locale:this._locale}},XliffParser.prototype.visitElement=function(element,context){switch(element.name){case"trans-unit":this._unitMlString=null;var idAttr=element.attrs.find(function(attr){return"id"===attr.name});if(idAttr){var id=idAttr.value;this._msgIdToHtml.hasOwnProperty(id)?this._addError(element,"Duplicated translations for msg "+id):(visitAll(this,element.children,null),"string"==typeof this._unitMlString?this._msgIdToHtml[id]=this._unitMlString:this._addError(element,"Message "+id+" misses a translation"))}else this._addError(element,'<trans-unit> misses the "id" attribute');break;case"source":case"seg-source":break;case"target":var innerTextStart=element.startSourceSpan.end.offset,innerTextEnd=element.endSourceSpan.start.offset,content=element.startSourceSpan.start.file.content,innerText=content.slice(innerTextStart,innerTextEnd);this._unitMlString=innerText;break;case"file":var localeAttr=element.attrs.find(function(attr){return"target-language"===attr.name});localeAttr&&(this._locale=localeAttr.value),visitAll(this,element.children,null);break;default:visitAll(this,element.children,null)}},XliffParser.prototype.visitAttribute=function(attribute,context){},XliffParser.prototype.visitText=function(text,context){},XliffParser.prototype.visitComment=function(comment,context){},XliffParser.prototype.visitExpansion=function(expansion,context){},XliffParser.prototype.visitExpansionCase=function(expansionCase,context){},XliffParser.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XliffParser}(),XmlToI18n=function(){function XmlToI18n(){}return XmlToI18n.prototype.convert=function(message,url){var xmlIcu=(new XmlParser).parse(message,url,!0);return this._errors=xmlIcu.errors,{i18nNodes:this._errors.length>0||0==xmlIcu.rootNodes.length?[]:[].concat.apply([],visitAll(this,xmlIcu.rootNodes)),errors:this._errors}},XmlToI18n.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},XmlToI18n.prototype.visitElement=function(el,context){if("x"===el.name){var nameAttr=el.attrs.find(function(attr){return"id"===attr.name});return nameAttr?new Placeholder("",nameAttr.value,el.sourceSpan):(this._addError(el,'<x> misses the "id" attribute'),null)}return"mrk"===el.name?[].concat.apply([],visitAll(this,el.children)):(this._addError(el,"Unexpected tag"),null)},XmlToI18n.prototype.visitExpansion=function(icu,context){var caseMap={};return visitAll(this,icu.cases).forEach(function(c){caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)}),new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)},XmlToI18n.prototype.visitExpansionCase=function(icuCase,context){return{value:icuCase.value,nodes:visitAll(this,icuCase.expression)}},XmlToI18n.prototype.visitComment=function(comment,context){},XmlToI18n.prototype.visitAttribute=function(attribute,context){},XmlToI18n.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XmlToI18n}(),Xliff2=function(_super){function Xliff2(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xliff2,_super),Xliff2.prototype.write=function(messages,locale){var visitor=new _WriteVisitor$1,units=[];messages.forEach(function(message){var unit=new Tag("unit",{id:message.id}),notes=new Tag("notes");(message.description||message.meaning)&&(message.description&&notes.children.push(new CR(8),new Tag("note",{category:"description"},[new Text$2(message.description)])),message.meaning&&notes.children.push(new CR(8),new Tag("note",{category:"meaning"},[new Text$2(message.meaning)]))),message.sources.forEach(function(source){notes.children.push(new CR(8),new Tag("note",{category:"location"},[new Text$2(source.filePath+":"+source.startLine+(source.endLine!==source.startLine?","+source.endLine:""))]))}),notes.children.push(new CR(6)),unit.children.push(new CR(6),notes);var segment=new Tag("segment");segment.children.push(new CR(8),new Tag("source",{},visitor.serialize(message.nodes)),new CR(6)),unit.children.push(new CR(6),segment,new CR(4)),units.push(new CR(4),unit)});var file=new Tag("file",{original:"ng.template",id:"ngi18n"},units.concat([new CR(2)])),xliff=new Tag("xliff",{version:"2.0",xmlns:"urn:oasis:names:tc:xliff:document:2.0",srcLang:locale||"en"},[new CR(2),file,new CR]);return serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,xliff,new CR])},Xliff2.prototype.load=function(content,url){var xliff2Parser=new Xliff2Parser,_a=xliff2Parser.parse(content,url),locale=_a.locale,msgIdToHtml=_a.msgIdToHtml,errors=_a.errors,i18nNodesByMsgId={},converter=new XmlToI18n$1;if(Object.keys(msgIdToHtml).forEach(function(msgId){var _a=converter.convert(msgIdToHtml[msgId],url),i18nNodes=_a.i18nNodes,e=_a.errors;errors.push.apply(errors,e),i18nNodesByMsgId[msgId]=i18nNodes}),errors.length)throw new Error("xliff2 parse errors:\n"+errors.join("\n"));return{locale:locale,i18nNodesByMsgId:i18nNodesByMsgId}},Xliff2.prototype.digest=function(message){return decimalDigest(message)},Xliff2}(Serializer),_WriteVisitor$1=function(){function _WriteVisitor(){}return _WriteVisitor.prototype.visitText=function(text,context){return[new Text$2(text.value)]},_WriteVisitor.prototype.visitContainer=function(container,context){var _this=this,nodes=[];return container.children.forEach(function(node){return nodes.push.apply(nodes,node.visit(_this))}),nodes},_WriteVisitor.prototype.visitIcu=function(icu,context){var _this=this,nodes=[new Text$2("{"+icu.expressionPlaceholder+", "+icu.type+", ")];return Object.keys(icu.cases).forEach(function(c){nodes.push.apply(nodes,[new Text$2(c+" {")].concat(icu.cases[c].visit(_this),[new Text$2("} ")]))}),nodes.push(new Text$2("}")),nodes},_WriteVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this,type=getTypeForTag(ph.tag);if(ph.isVoid){return[new Tag("ph",{id:(this._nextPlaceholderId++).toString(),equiv:ph.startName,type:type,disp:"<"+ph.tag+"/>"})]}var tagPc=new Tag("pc",{id:(this._nextPlaceholderId++).toString(),equivStart:ph.startName,equivEnd:ph.closeName,type:type,dispStart:"<"+ph.tag+">",dispEnd:"</"+ph.tag+">"}),nodes=[].concat.apply([],ph.children.map(function(node){return node.visit(_this)}));return nodes.length?nodes.forEach(function(node){return tagPc.children.push(node)}):tagPc.children.push(new Text$2("")),[tagPc]},_WriteVisitor.prototype.visitPlaceholder=function(ph,context){var idStr=(this._nextPlaceholderId++).toString();return[new Tag("ph",{id:idStr,equiv:ph.name,disp:"{{"+ph.value+"}}"})]},_WriteVisitor.prototype.visitIcuPlaceholder=function(ph,context){var cases=Object.keys(ph.value.cases).map(function(value){return value+" {...}"}).join(" "),idStr=(this._nextPlaceholderId++).toString();return[new Tag("ph",{id:idStr,equiv:ph.name,disp:"{"+ph.value.expression+", "+ph.value.type+", "+cases+"}"})]},_WriteVisitor.prototype.serialize=function(nodes){var _this=this;return this._nextPlaceholderId=0,[].concat.apply([],nodes.map(function(node){return node.visit(_this)}))},_WriteVisitor}(),Xliff2Parser=function(){function Xliff2Parser(){this._locale=null}return Xliff2Parser.prototype.parse=function(xliff,url){this._unitMlString=null,this._msgIdToHtml={};var xml=(new XmlParser).parse(xliff,url,!1);return this._errors=xml.errors,visitAll(this,xml.rootNodes,null),{msgIdToHtml:this._msgIdToHtml,errors:this._errors,locale:this._locale}},Xliff2Parser.prototype.visitElement=function(element,context){switch(element.name){case"unit":this._unitMlString=null;var idAttr=element.attrs.find(function(attr){return"id"===attr.name});if(idAttr){var id=idAttr.value;this._msgIdToHtml.hasOwnProperty(id)?this._addError(element,"Duplicated translations for msg "+id):(visitAll(this,element.children,null),"string"==typeof this._unitMlString?this._msgIdToHtml[id]=this._unitMlString:this._addError(element,"Message "+id+" misses a translation"))}else this._addError(element,'<unit> misses the "id" attribute');break;case"source":break;case"target":var innerTextStart=element.startSourceSpan.end.offset,innerTextEnd=element.endSourceSpan.start.offset,content=element.startSourceSpan.start.file.content,innerText=content.slice(innerTextStart,innerTextEnd);this._unitMlString=innerText;break;case"xliff":var localeAttr=element.attrs.find(function(attr){return"trgLang"===attr.name});localeAttr&&(this._locale=localeAttr.value);var versionAttr=element.attrs.find(function(attr){return"version"===attr.name});if(versionAttr){var version=versionAttr.value;"2.0"!==version?this._addError(element,"The XLIFF file version "+version+" is not compatible with XLIFF 2.0 serializer"):visitAll(this,element.children,null)}break;default:visitAll(this,element.children,null)}},Xliff2Parser.prototype.visitAttribute=function(attribute,context){},Xliff2Parser.prototype.visitText=function(text,context){},Xliff2Parser.prototype.visitComment=function(comment,context){},Xliff2Parser.prototype.visitExpansion=function(expansion,context){},Xliff2Parser.prototype.visitExpansionCase=function(expansionCase,context){},Xliff2Parser.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},Xliff2Parser}(),XmlToI18n$1=function(){function XmlToI18n(){}return XmlToI18n.prototype.convert=function(message,url){var xmlIcu=(new XmlParser).parse(message,url,!0);return this._errors=xmlIcu.errors,{i18nNodes:this._errors.length>0||0==xmlIcu.rootNodes.length?[]:[].concat.apply([],visitAll(this,xmlIcu.rootNodes)),errors:this._errors}},XmlToI18n.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},XmlToI18n.prototype.visitElement=function(el,context){var _this=this;switch(el.name){case"ph":var nameAttr=el.attrs.find(function(attr){return"equiv"===attr.name});if(nameAttr)return[new Placeholder("",nameAttr.value,el.sourceSpan)];this._addError(el,'<ph> misses the "equiv" attribute');break;case"pc":var startAttr=el.attrs.find(function(attr){return"equivStart"===attr.name}),endAttr=el.attrs.find(function(attr){return"equivEnd"===attr.name});if(startAttr){if(endAttr){var startId=startAttr.value,endId=endAttr.value,nodes=[];return nodes.concat.apply(nodes,[new Placeholder("",startId,el.sourceSpan)].concat(el.children.map(function(node){return node.visit(_this,null)}),[new Placeholder("",endId,el.sourceSpan)]))}this._addError(el,'<ph> misses the "equivEnd" attribute')}else this._addError(el,'<ph> misses the "equivStart" attribute');break;case"mrk":return[].concat.apply([],visitAll(this,el.children));default:this._addError(el,"Unexpected tag")}return null},XmlToI18n.prototype.visitExpansion=function(icu,context){var caseMap={};return visitAll(this,icu.cases).forEach(function(c){caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)}),new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)},XmlToI18n.prototype.visitExpansionCase=function(icuCase,context){return{value:icuCase.value,nodes:[].concat.apply([],visitAll(this,icuCase.expression))}},XmlToI18n.prototype.visitComment=function(comment,context){},XmlToI18n.prototype.visitAttribute=function(attribute,context){},XmlToI18n.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XmlToI18n}(),Xmb=function(_super){function Xmb(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xmb,_super),Xmb.prototype.write=function(messages,locale){var exampleVisitor=new ExampleVisitor,visitor=new _Visitor$2,rootNode=new Tag("messagebundle");return messages.forEach(function(message){var attrs={id:message.id};message.description&&(attrs.desc=message.description),message.meaning&&(attrs.meaning=message.meaning);var sourceTags=[];message.sources.forEach(function(source){sourceTags.push(new Tag("source",{},[new Text$2(source.filePath+":"+source.startLine+(source.endLine!==source.startLine?","+source.endLine:""))]))}),rootNode.children.push(new CR(2),new Tag("msg",attrs,sourceTags.concat(visitor.serialize(message.nodes))))}),rootNode.children.push(new CR),serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,new Doctype("messagebundle",'<!ELEMENT messagebundle (msg)*>\n<!ATTLIST messagebundle class CDATA #IMPLIED>\n\n<!ELEMENT msg (#PCDATA|ph|source)*>\n<!ATTLIST msg id CDATA #IMPLIED>\n<!ATTLIST msg seq CDATA #IMPLIED>\n<!ATTLIST msg name CDATA #IMPLIED>\n<!ATTLIST msg desc CDATA #IMPLIED>\n<!ATTLIST msg meaning CDATA #IMPLIED>\n<!ATTLIST msg obsolete (obsolete) #IMPLIED>\n<!ATTLIST msg xml:space (default|preserve) "default">\n<!ATTLIST msg is_hidden CDATA #IMPLIED>\n\n<!ELEMENT source (#PCDATA)>\n\n<!ELEMENT ph (#PCDATA|ex)*>\n<!ATTLIST ph name CDATA #REQUIRED>\n\n<!ELEMENT ex (#PCDATA)>'),new CR,exampleVisitor.addDefaultExamples(rootNode),new CR])},Xmb.prototype.load=function(content,url){throw new Error("Unsupported")},Xmb.prototype.digest=function(message){return digest$1(message)},Xmb.prototype.createNameMapper=function(message){return new SimplePlaceholderMapper(message,toPublicName)},Xmb}(Serializer),_Visitor$2=function(){function _Visitor(){}return _Visitor.prototype.visitText=function(text,context){return[new Text$2(text.value)]},_Visitor.prototype.visitContainer=function(container,context){var _this=this,nodes=[];return container.children.forEach(function(node){return nodes.push.apply(nodes,node.visit(_this))}),nodes},_Visitor.prototype.visitIcu=function(icu,context){var _this=this,nodes=[new Text$2("{"+icu.expressionPlaceholder+", "+icu.type+", ")];return Object.keys(icu.cases).forEach(function(c){nodes.push.apply(nodes,[new Text$2(c+" {")].concat(icu.cases[c].visit(_this),[new Text$2("} ")]))}),nodes.push(new Text$2("}")),nodes},_Visitor.prototype.visitTagPlaceholder=function(ph,context){var startEx=new Tag("ex",{},[new Text$2("<"+ph.tag+">")]),startTagPh=new Tag("ph",{name:ph.startName},[startEx]);if(ph.isVoid)return[startTagPh];var closeEx=new Tag("ex",{},[new Text$2("</"+ph.tag+">")]),closeTagPh=new Tag("ph",{name:ph.closeName},[closeEx]);return[startTagPh].concat(this.serialize(ph.children),[closeTagPh])},_Visitor.prototype.visitPlaceholder=function(ph,context){var exTag=new Tag("ex",{},[new Text$2("{{"+ph.value+"}}")]);return[new Tag("ph",{name:ph.name},[exTag])]},_Visitor.prototype.visitIcuPlaceholder=function(ph,context){var exTag=new Tag("ex",{},[new Text$2("{"+ph.value.expression+", "+ph.value.type+", "+Object.keys(ph.value.cases).map(function(value){return value+" {...}"}).join(" ")+"}")]);return[new Tag("ph",{name:ph.name},[exTag])]},_Visitor.prototype.serialize=function(nodes){var _this=this;return[].concat.apply([],nodes.map(function(node){return node.visit(_this)}))},_Visitor}(),ExampleVisitor=function(){function ExampleVisitor(){}return ExampleVisitor.prototype.addDefaultExamples=function(node){return node.visit(this),node},ExampleVisitor.prototype.visitTag=function(tag){var _this=this;if("ph"===tag.name){if(!tag.children||0==tag.children.length){var exText=new Text$2(tag.attrs.name||"...");tag.children=[new Tag("ex",{},[exText])]}}else tag.children&&tag.children.forEach(function(node){return node.visit(_this)})},ExampleVisitor.prototype.visitText=function(text){},ExampleVisitor.prototype.visitDeclaration=function(decl){},ExampleVisitor.prototype.visitDoctype=function(doctype){},ExampleVisitor}(),Xtb=function(_super){function Xtb(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xtb,_super),Xtb.prototype.write=function(messages,locale){throw new Error("Unsupported")},Xtb.prototype.load=function(content,url){var xtbParser=new XtbParser,_a=xtbParser.parse(content,url),locale=_a.locale,msgIdToHtml=_a.msgIdToHtml,errors=_a.errors,i18nNodesByMsgId={},converter=new XmlToI18n$2;if(Object.keys(msgIdToHtml).forEach(function(msgId){createLazyProperty(i18nNodesByMsgId,msgId,function(){var _a=converter.convert(msgIdToHtml[msgId],url),i18nNodes=_a.i18nNodes,errors=_a.errors;if(errors.length)throw new Error("xtb parse errors:\n"+errors.join("\n"));return i18nNodes})}),errors.length)throw new Error("xtb parse errors:\n"+errors.join("\n"));return{locale:locale,i18nNodesByMsgId:i18nNodesByMsgId}},Xtb.prototype.digest=function(message){return digest$1(message)},Xtb.prototype.createNameMapper=function(message){return new SimplePlaceholderMapper(message,toPublicName)},Xtb}(Serializer),XtbParser=function(){function XtbParser(){this._locale=null}return XtbParser.prototype.parse=function(xtb,url){this._bundleDepth=0,this._msgIdToHtml={};var xml=(new XmlParser).parse(xtb,url,!1);return this._errors=xml.errors,visitAll(this,xml.rootNodes),{msgIdToHtml:this._msgIdToHtml,errors:this._errors,locale:this._locale}},XtbParser.prototype.visitElement=function(element,context){switch(element.name){case"translationbundle":this._bundleDepth++,this._bundleDepth>1&&this._addError(element,"<translationbundle> elements can not be nested");var langAttr=element.attrs.find(function(attr){return"lang"===attr.name});langAttr&&(this._locale=langAttr.value),visitAll(this,element.children,null),this._bundleDepth--;break;case"translation":var idAttr=element.attrs.find(function(attr){return"id"===attr.name});if(idAttr){var id=idAttr.value;if(this._msgIdToHtml.hasOwnProperty(id))this._addError(element,"Duplicated translations for msg "+id);else{var innerTextStart=element.startSourceSpan.end.offset,innerTextEnd=element.endSourceSpan.start.offset,content=element.startSourceSpan.start.file.content,innerText=content.slice(innerTextStart,innerTextEnd);this._msgIdToHtml[id]=innerText}}else this._addError(element,'<translation> misses the "id" attribute');break;default:this._addError(element,"Unexpected tag")}},XtbParser.prototype.visitAttribute=function(attribute,context){},XtbParser.prototype.visitText=function(text,context){},XtbParser.prototype.visitComment=function(comment,context){},XtbParser.prototype.visitExpansion=function(expansion,context){},XtbParser.prototype.visitExpansionCase=function(expansionCase,context){},XtbParser.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XtbParser}(),XmlToI18n$2=function(){function XmlToI18n(){}return XmlToI18n.prototype.convert=function(message,url){var xmlIcu=(new XmlParser).parse(message,url,!0);return this._errors=xmlIcu.errors,{i18nNodes:this._errors.length>0||0==xmlIcu.rootNodes.length?[]:visitAll(this,xmlIcu.rootNodes),errors:this._errors}},XmlToI18n.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},XmlToI18n.prototype.visitExpansion=function(icu,context){var caseMap={};return visitAll(this,icu.cases).forEach(function(c){caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)}),new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)},XmlToI18n.prototype.visitExpansionCase=function(icuCase,context){return{value:icuCase.value,nodes:visitAll(this,icuCase.expression)}},XmlToI18n.prototype.visitElement=function(el,context){if("ph"===el.name){var nameAttr=el.attrs.find(function(attr){return"name"===attr.name});if(nameAttr)return new Placeholder("",nameAttr.value,el.sourceSpan);this._addError(el,'<ph> misses the "name" attribute')}else this._addError(el,"Unexpected tag");return null},XmlToI18n.prototype.visitComment=function(comment,context){},XmlToI18n.prototype.visitAttribute=function(attribute,context){},XmlToI18n.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XmlToI18n}(),HtmlParser=function(_super){function HtmlParser(){return _super.call(this,getHtmlTagDefinition)||this}return __extends(HtmlParser,_super),HtmlParser.prototype.parse=function(source,url,parseExpansionForms,interpolationConfig){return void 0===parseExpansionForms&&(parseExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),_super.prototype.parse.call(this,source,url,parseExpansionForms,interpolationConfig)},HtmlParser}(Parser$1),TranslationBundle=function(){function TranslationBundle(_i18nNodesByMsgId,locale,digest,mapperFactory,missingTranslationStrategy,console){void 0===_i18nNodesByMsgId&&(_i18nNodesByMsgId={}),void 0===missingTranslationStrategy&&(missingTranslationStrategy=MissingTranslationStrategy.Warning),this._i18nNodesByMsgId=_i18nNodesByMsgId,this.digest=digest,this.mapperFactory=mapperFactory,this._i18nToHtml=new I18nToHtmlVisitor(_i18nNodesByMsgId,locale,digest,mapperFactory,missingTranslationStrategy,console)}return TranslationBundle.load=function(content,url,serializer,missingTranslationStrategy,console){var _a=serializer.load(content,url),locale=_a.locale;return new TranslationBundle(_a.i18nNodesByMsgId,locale,function(m){return serializer.digest(m)},function(m){return serializer.createNameMapper(m)},missingTranslationStrategy,console)},TranslationBundle.prototype.get=function(srcMsg){var html=this._i18nToHtml.convert(srcMsg);if(html.errors.length)throw new Error(html.errors.join("\n"));return html.nodes},TranslationBundle.prototype.has=function(srcMsg){return this.digest(srcMsg)in this._i18nNodesByMsgId},TranslationBundle}(),I18nToHtmlVisitor=function(){function I18nToHtmlVisitor(_i18nNodesByMsgId,_locale,_digest,_mapperFactory,_missingTranslationStrategy,_console){void 0===_i18nNodesByMsgId&&(_i18nNodesByMsgId={}),this._i18nNodesByMsgId=_i18nNodesByMsgId,this._locale=_locale,this._digest=_digest,this._mapperFactory=_mapperFactory,this._missingTranslationStrategy=_missingTranslationStrategy,this._console=_console,this._contextStack=[],this._errors=[]}return I18nToHtmlVisitor.prototype.convert=function(srcMsg){this._contextStack.length=0,this._errors.length=0;var text=this._convertToText(srcMsg),url=srcMsg.nodes[0].sourceSpan.start.file.url,html=(new HtmlParser).parse(text,url,!0);return{nodes:html.rootNodes,errors:this._errors.concat(html.errors)}},I18nToHtmlVisitor.prototype.visitText=function(text,context){return escapeXml(text.value)},I18nToHtmlVisitor.prototype.visitContainer=function(container,context){var _this=this;return container.children.map(function(n){return n.visit(_this)}).join("")},I18nToHtmlVisitor.prototype.visitIcu=function(icu,context){var _this=this,cases=Object.keys(icu.cases).map(function(k){return k+" {"+icu.cases[k].visit(_this)+"}"});return"{"+(this._srcMsg.placeholders.hasOwnProperty(icu.expression)?this._srcMsg.placeholders[icu.expression]:icu.expression)+", "+icu.type+", "+cases.join(" ")+"}"},I18nToHtmlVisitor.prototype.visitPlaceholder=function(ph,context){var phName=this._mapper(ph.name);return this._srcMsg.placeholders.hasOwnProperty(phName)?this._srcMsg.placeholders[phName]:this._srcMsg.placeholderToMessage.hasOwnProperty(phName)?this._convertToText(this._srcMsg.placeholderToMessage[phName]):(this._addError(ph,'Unknown placeholder "'+ph.name+'"'),"")},I18nToHtmlVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this,tag=""+ph.tag,attrs=Object.keys(ph.attrs).map(function(name){return name+'="'+ph.attrs[name]+'"'}).join(" ");return ph.isVoid?"<"+tag+" "+attrs+"/>":"<"+tag+" "+attrs+">"+ph.children.map(function(c){return c.visit(_this)}).join("")+"</"+tag+">"},I18nToHtmlVisitor.prototype.visitIcuPlaceholder=function(ph,context){return this._convertToText(this._srcMsg.placeholderToMessage[ph.name])},I18nToHtmlVisitor.prototype._convertToText=function(srcMsg){var nodes,_this=this,id=this._digest(srcMsg),mapper=this._mapperFactory?this._mapperFactory(srcMsg):null;if(this._contextStack.push({msg:this._srcMsg,mapper:this._mapper}),this._srcMsg=srcMsg,this._i18nNodesByMsgId.hasOwnProperty(id))nodes=this._i18nNodesByMsgId[id],this._mapper=function(name){return mapper?mapper.toInternalName(name):name};else{if(this._missingTranslationStrategy===MissingTranslationStrategy.Error){var ctx=this._locale?' for locale "'+this._locale+'"':"";this._addError(srcMsg.nodes[0],'Missing translation for message "'+id+'"'+ctx)}else if(this._console&&this._missingTranslationStrategy===MissingTranslationStrategy.Warning){var ctx=this._locale?' for locale "'+this._locale+'"':"";this._console.warn('Missing translation for message "'+id+'"'+ctx)}nodes=srcMsg.nodes,this._mapper=function(name){return name}}var text=nodes.map(function(node){return node.visit(_this)}).join(""),context=this._contextStack.pop();return this._srcMsg=context.msg,this._mapper=context.mapper,text},I18nToHtmlVisitor.prototype._addError=function(el,msg){this._errors.push(new I18nError(el.sourceSpan,msg))},I18nToHtmlVisitor}(),I18NHtmlParser=function(){function I18NHtmlParser(_htmlParser,translations,translationsFormat,missingTranslation,console){if(void 0===missingTranslation&&(missingTranslation=MissingTranslationStrategy.Warning),this._htmlParser=_htmlParser,translations){var serializer=createSerializer(translationsFormat);this._translationBundle=TranslationBundle.load(translations,"i18n",serializer,missingTranslation,console)}else this._translationBundle=new TranslationBundle({},null,digest,void 0,missingTranslation,console)}return I18NHtmlParser.prototype.parse=function(source,url,parseExpansionForms,interpolationConfig){void 0===parseExpansionForms&&(parseExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var parseResult=this._htmlParser.parse(source,url,parseExpansionForms,interpolationConfig);return parseResult.errors.length?new ParseTreeResult(parseResult.rootNodes,parseResult.errors):mergeTranslations(parseResult.rootNodes,this._translationBundle,interpolationConfig,[],{})},I18NHtmlParser}(),STRIP_SRC_FILE_SUFFIXES=/(\.ts|\.d\.ts|\.js|\.jsx|\.tsx)$/,GENERATED_FILE=/\.ngfactory\.|\.ngsummary\./,JIT_SUMMARY_FILE=/\.ngsummary\./,JIT_SUMMARY_NAME=/NgSummary$/,LOWERED_SYMBOL=/\u0275\d+/,CORE="@angular/core",Identifiers=function(){function Identifiers(){}return Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS={name:"ANALYZE_FOR_ENTRY_COMPONENTS",moduleName:CORE},Identifiers.ElementRef={name:"ElementRef",moduleName:CORE},Identifiers.NgModuleRef={name:"NgModuleRef",moduleName:CORE},Identifiers.ViewContainerRef={name:"ViewContainerRef",moduleName:CORE},Identifiers.ChangeDetectorRef={name:"ChangeDetectorRef",moduleName:CORE},Identifiers.QueryList={name:"QueryList",moduleName:CORE},Identifiers.TemplateRef={name:"TemplateRef",moduleName:CORE},Identifiers.CodegenComponentFactoryResolver={name:"ɵCodegenComponentFactoryResolver",moduleName:CORE},Identifiers.ComponentFactoryResolver={name:"ComponentFactoryResolver",moduleName:CORE},Identifiers.ComponentFactory={name:"ComponentFactory",moduleName:CORE},Identifiers.ComponentRef={name:"ComponentRef",moduleName:CORE},Identifiers.NgModuleFactory={name:"NgModuleFactory",moduleName:CORE},Identifiers.createModuleFactory={name:"ɵcmf",moduleName:CORE},Identifiers.moduleDef={name:"ɵmod",moduleName:CORE},Identifiers.moduleProviderDef={name:"ɵmpd",moduleName:CORE},Identifiers.RegisterModuleFactoryFn={name:"ɵregisterModuleFactory",moduleName:CORE},Identifiers.Injector={name:"Injector",moduleName:CORE},Identifiers.ViewEncapsulation={name:"ViewEncapsulation",moduleName:CORE},Identifiers.ChangeDetectionStrategy={name:"ChangeDetectionStrategy",moduleName:CORE},Identifiers.SecurityContext={name:"SecurityContext",moduleName:CORE},Identifiers.LOCALE_ID={name:"LOCALE_ID",moduleName:CORE},Identifiers.TRANSLATIONS_FORMAT={name:"TRANSLATIONS_FORMAT",moduleName:CORE},Identifiers.inlineInterpolate={name:"ɵinlineInterpolate",moduleName:CORE},Identifiers.interpolate={name:"ɵinterpolate",moduleName:CORE},Identifiers.EMPTY_ARRAY={name:"ɵEMPTY_ARRAY",moduleName:CORE},Identifiers.EMPTY_MAP={name:"ɵEMPTY_MAP",moduleName:CORE},Identifiers.Renderer={name:"Renderer",moduleName:CORE},Identifiers.viewDef={name:"ɵvid",moduleName:CORE},Identifiers.elementDef={name:"ɵeld",moduleName:CORE},Identifiers.anchorDef={name:"ɵand",moduleName:CORE},Identifiers.textDef={name:"ɵted",moduleName:CORE},Identifiers.directiveDef={name:"ɵdid",moduleName:CORE},Identifiers.providerDef={name:"ɵprd",moduleName:CORE},Identifiers.queryDef={name:"ɵqud",moduleName:CORE},Identifiers.pureArrayDef={name:"ɵpad",moduleName:CORE},Identifiers.pureObjectDef={name:"ɵpod",moduleName:CORE},Identifiers.purePipeDef={name:"ɵppd",moduleName:CORE},Identifiers.pipeDef={name:"ɵpid",moduleName:CORE},Identifiers.nodeValue={name:"ɵnov",moduleName:CORE},Identifiers.ngContentDef={name:"ɵncd",moduleName:CORE},Identifiers.unwrapValue={name:"ɵunv",moduleName:CORE},Identifiers.createRendererType2={name:"ɵcrt",moduleName:CORE},Identifiers.RendererType2={name:"RendererType2",moduleName:CORE},Identifiers.ViewDefinition={name:"ɵViewDefinition",moduleName:CORE},Identifiers.createComponentFactory={name:"ɵccf",moduleName:CORE},Identifiers}(),LifecycleHooks={OnInit:0,OnDestroy:1,DoCheck:2,OnChanges:3,AfterContentInit:4,AfterContentChecked:5,AfterViewInit:6,AfterViewChecked:7};LifecycleHooks[LifecycleHooks.OnInit]="OnInit",LifecycleHooks[LifecycleHooks.OnDestroy]="OnDestroy",LifecycleHooks[LifecycleHooks.DoCheck]="DoCheck",LifecycleHooks[LifecycleHooks.OnChanges]="OnChanges",LifecycleHooks[LifecycleHooks.AfterContentInit]="AfterContentInit",LifecycleHooks[LifecycleHooks.AfterContentChecked]="AfterContentChecked",LifecycleHooks[LifecycleHooks.AfterViewInit]="AfterViewInit",LifecycleHooks[LifecycleHooks.AfterViewChecked]="AfterViewChecked";var LIFECYCLE_HOOKS_VALUES=[LifecycleHooks.OnInit,LifecycleHooks.OnDestroy,LifecycleHooks.DoCheck,LifecycleHooks.OnChanges,LifecycleHooks.AfterContentInit,LifecycleHooks.AfterContentChecked,LifecycleHooks.AfterViewInit,LifecycleHooks.AfterViewChecked],_SELECTOR_REGEXP=new RegExp("(\\:not\\()|([-\\w]+)|(?:\\.([-\\w]+))|(?:\\[([-.\\w*]+)(?:=([\"']?)([^\\]\"']*)\\5)?\\])|(\\))|(\\s*,\\s*)","g"),CssSelector=function(){function CssSelector(){this.element=null,this.classNames=[],this.attrs=[],this.notSelectors=[]}return CssSelector.parse=function(selector){var match,results=[],_addResult=function(res,cssSel){cssSel.notSelectors.length>0&&!cssSel.element&&0==cssSel.classNames.length&&0==cssSel.attrs.length&&(cssSel.element="*"),res.push(cssSel)},cssSelector=new CssSelector,current=cssSelector,inNot=!1;for(_SELECTOR_REGEXP.lastIndex=0;match=_SELECTOR_REGEXP.exec(selector);){if(match[1]){if(inNot)throw new Error("Nesting :not is not allowed in a selector");inNot=!0,current=new CssSelector,cssSelector.notSelectors.push(current)}if(match[2]&&current.setElement(match[2]),match[3]&&current.addClassName(match[3]),match[4]&&current.addAttribute(match[4],match[6]),match[7]&&(inNot=!1,current=cssSelector),match[8]){if(inNot)throw new Error("Multiple selectors in :not are not supported");_addResult(results,cssSelector),cssSelector=current=new CssSelector}}return _addResult(results,cssSelector),results},CssSelector.prototype.isElementSelector=function(){return this.hasElementSelector()&&0==this.classNames.length&&0==this.attrs.length&&0===this.notSelectors.length},CssSelector.prototype.hasElementSelector=function(){return!!this.element},CssSelector.prototype.setElement=function(element){void 0===element&&(element=null),this.element=element},CssSelector.prototype.getMatchingElementTemplate=function(){for(var tagName=this.element||"div",classAttr=this.classNames.length>0?' class="'+this.classNames.join(" ")+'"':"",attrs="",i=0;i<this.attrs.length;i+=2){attrs+=" "+this.attrs[i]+(""!==this.attrs[i+1]?'="'+this.attrs[i+1]+'"':"")}return getHtmlTagDefinition(tagName).isVoid?"<"+tagName+classAttr+attrs+"/>":"<"+tagName+classAttr+attrs+"></"+tagName+">"},CssSelector.prototype.addAttribute=function(name,value){void 0===value&&(value=""),this.attrs.push(name,value&&value.toLowerCase()||"")},CssSelector.prototype.addClassName=function(name){this.classNames.push(name.toLowerCase())},CssSelector.prototype.toString=function(){var res=this.element||""
;if(this.classNames&&this.classNames.forEach(function(klass){return res+="."+klass}),this.attrs)for(var i=0;i<this.attrs.length;i+=2){var name_1=this.attrs[i],value=this.attrs[i+1];res+="["+name_1+(value?"="+value:"")+"]"}return this.notSelectors.forEach(function(notSelector){return res+=":not("+notSelector+")"}),res},CssSelector}(),SelectorMatcher=function(){function SelectorMatcher(){this._elementMap=new Map,this._elementPartialMap=new Map,this._classMap=new Map,this._classPartialMap=new Map,this._attrValueMap=new Map,this._attrValuePartialMap=new Map,this._listContexts=[]}return SelectorMatcher.createNotMatcher=function(notSelectors){var notMatcher=new SelectorMatcher;return notMatcher.addSelectables(notSelectors,null),notMatcher},SelectorMatcher.prototype.addSelectables=function(cssSelectors,callbackCtxt){var listContext=null;cssSelectors.length>1&&(listContext=new SelectorListContext(cssSelectors),this._listContexts.push(listContext));for(var i=0;i<cssSelectors.length;i++)this._addSelectable(cssSelectors[i],callbackCtxt,listContext)},SelectorMatcher.prototype._addSelectable=function(cssSelector,callbackCtxt,listContext){var matcher=this,element=cssSelector.element,classNames=cssSelector.classNames,attrs=cssSelector.attrs,selectable=new SelectorContext(cssSelector,callbackCtxt,listContext);if(element){var isTerminal=0===attrs.length&&0===classNames.length;isTerminal?this._addTerminal(matcher._elementMap,element,selectable):matcher=this._addPartial(matcher._elementPartialMap,element)}if(classNames)for(var i=0;i<classNames.length;i++){var isTerminal=0===attrs.length&&i===classNames.length-1,className=classNames[i];isTerminal?this._addTerminal(matcher._classMap,className,selectable):matcher=this._addPartial(matcher._classPartialMap,className)}if(attrs)for(var i=0;i<attrs.length;i+=2){var isTerminal=i===attrs.length-2,name_2=attrs[i],value=attrs[i+1];if(isTerminal){var terminalMap=matcher._attrValueMap,terminalValuesMap=terminalMap.get(name_2);terminalValuesMap||(terminalValuesMap=new Map,terminalMap.set(name_2,terminalValuesMap)),this._addTerminal(terminalValuesMap,value,selectable)}else{var partialMap=matcher._attrValuePartialMap,partialValuesMap=partialMap.get(name_2);partialValuesMap||(partialValuesMap=new Map,partialMap.set(name_2,partialValuesMap)),matcher=this._addPartial(partialValuesMap,value)}}},SelectorMatcher.prototype._addTerminal=function(map,name,selectable){var terminalList=map.get(name);terminalList||(terminalList=[],map.set(name,terminalList)),terminalList.push(selectable)},SelectorMatcher.prototype._addPartial=function(map,name){var matcher=map.get(name);return matcher||(matcher=new SelectorMatcher,map.set(name,matcher)),matcher},SelectorMatcher.prototype.match=function(cssSelector,matchedCallback){for(var result=!1,element=cssSelector.element,classNames=cssSelector.classNames,attrs=cssSelector.attrs,i=0;i<this._listContexts.length;i++)this._listContexts[i].alreadyMatched=!1;if(result=this._matchTerminal(this._elementMap,element,cssSelector,matchedCallback)||result,result=this._matchPartial(this._elementPartialMap,element,cssSelector,matchedCallback)||result,classNames)for(var i=0;i<classNames.length;i++){var className=classNames[i];result=this._matchTerminal(this._classMap,className,cssSelector,matchedCallback)||result,result=this._matchPartial(this._classPartialMap,className,cssSelector,matchedCallback)||result}if(attrs)for(var i=0;i<attrs.length;i+=2){var name_3=attrs[i],value=attrs[i+1],terminalValuesMap=this._attrValueMap.get(name_3);value&&(result=this._matchTerminal(terminalValuesMap,"",cssSelector,matchedCallback)||result),result=this._matchTerminal(terminalValuesMap,value,cssSelector,matchedCallback)||result;var partialValuesMap=this._attrValuePartialMap.get(name_3);value&&(result=this._matchPartial(partialValuesMap,"",cssSelector,matchedCallback)||result),result=this._matchPartial(partialValuesMap,value,cssSelector,matchedCallback)||result}return result},SelectorMatcher.prototype._matchTerminal=function(map,name,cssSelector,matchedCallback){if(!map||"string"!=typeof name)return!1;var selectables=map.get(name)||[],starSelectables=map.get("*");if(starSelectables&&(selectables=selectables.concat(starSelectables)),0===selectables.length)return!1;for(var selectable,result=!1,i=0;i<selectables.length;i++)selectable=selectables[i],result=selectable.finalize(cssSelector,matchedCallback)||result;return result},SelectorMatcher.prototype._matchPartial=function(map,name,cssSelector,matchedCallback){if(!map||"string"!=typeof name)return!1;var nestedSelector=map.get(name);return!!nestedSelector&&nestedSelector.match(cssSelector,matchedCallback)},SelectorMatcher}(),SelectorListContext=function(){function SelectorListContext(selectors){this.selectors=selectors,this.alreadyMatched=!1}return SelectorListContext}(),SelectorContext=function(){function SelectorContext(selector,cbContext,listContext){this.selector=selector,this.cbContext=cbContext,this.listContext=listContext,this.notSelectors=selector.notSelectors}return SelectorContext.prototype.finalize=function(cssSelector,callback){var result=!0;if(this.notSelectors.length>0&&(!this.listContext||!this.listContext.alreadyMatched)){result=!SelectorMatcher.createNotMatcher(this.notSelectors).match(cssSelector,null)}return!result||!callback||this.listContext&&this.listContext.alreadyMatched||(this.listContext&&(this.listContext.alreadyMatched=!0),callback(this.selector,this.cbContext)),result},SelectorContext}(),ERROR_COMPONENT_TYPE="ngComponentType",CompileMetadataResolver=function(){function CompileMetadataResolver(_config,_htmlParser,_ngModuleResolver,_directiveResolver,_pipeResolver,_summaryResolver,_schemaRegistry,_directiveNormalizer,_console,_staticSymbolCache,_reflector,_errorCollector){this._config=_config,this._htmlParser=_htmlParser,this._ngModuleResolver=_ngModuleResolver,this._directiveResolver=_directiveResolver,this._pipeResolver=_pipeResolver,this._summaryResolver=_summaryResolver,this._schemaRegistry=_schemaRegistry,this._directiveNormalizer=_directiveNormalizer,this._console=_console,this._staticSymbolCache=_staticSymbolCache,this._reflector=_reflector,this._errorCollector=_errorCollector,this._nonNormalizedDirectiveCache=new Map,this._directiveCache=new Map,this._summaryCache=new Map,this._pipeCache=new Map,this._ngModuleCache=new Map,this._ngModuleOfTypes=new Map}return CompileMetadataResolver.prototype.getReflector=function(){return this._reflector},CompileMetadataResolver.prototype.clearCacheFor=function(type){var dirMeta=this._directiveCache.get(type);this._directiveCache.delete(type),this._nonNormalizedDirectiveCache.delete(type),this._summaryCache.delete(type),this._pipeCache.delete(type),this._ngModuleOfTypes.delete(type),this._ngModuleCache.clear(),dirMeta&&this._directiveNormalizer.clearCacheFor(dirMeta)},CompileMetadataResolver.prototype.clearCache=function(){this._directiveCache.clear(),this._nonNormalizedDirectiveCache.clear(),this._summaryCache.clear(),this._pipeCache.clear(),this._ngModuleCache.clear(),this._ngModuleOfTypes.clear(),this._directiveNormalizer.clearCache()},CompileMetadataResolver.prototype._createProxyClass=function(baseType,name){var delegate=null,proxyClass=function(){if(!delegate)throw new Error("Illegal state: Class "+name+" for type "+stringify(baseType)+" is not compiled yet!");return delegate.apply(this,arguments)};return proxyClass.setDelegate=function(d){delegate=d,proxyClass.prototype=d.prototype},proxyClass.overriddenName=name,proxyClass},CompileMetadataResolver.prototype.getGeneratedClass=function(dirType,name){return dirType instanceof StaticSymbol?this._staticSymbolCache.get(ngfactoryFilePath(dirType.filePath),name):this._createProxyClass(dirType,name)},CompileMetadataResolver.prototype.getComponentViewClass=function(dirType){return this.getGeneratedClass(dirType,viewClassName(dirType,0))},CompileMetadataResolver.prototype.getHostComponentViewClass=function(dirType){return this.getGeneratedClass(dirType,hostViewClassName(dirType))},CompileMetadataResolver.prototype.getHostComponentType=function(dirType){var name=identifierName({reference:dirType})+"_Host";if(dirType instanceof StaticSymbol)return this._staticSymbolCache.get(dirType.filePath,name);var HostClass=function(){};return HostClass.overriddenName=name,HostClass},CompileMetadataResolver.prototype.getRendererType=function(dirType){return dirType instanceof StaticSymbol?this._staticSymbolCache.get(ngfactoryFilePath(dirType.filePath),rendererTypeName(dirType)):{}},CompileMetadataResolver.prototype.getComponentFactory=function(selector,dirType,inputs,outputs){if(dirType instanceof StaticSymbol)return this._staticSymbolCache.get(ngfactoryFilePath(dirType.filePath),componentFactoryName(dirType));var hostView=this.getHostComponentViewClass(dirType);return this._reflector.resolveExternalReference(Identifiers.createComponentFactory)(selector,dirType,hostView,inputs,outputs,[])},CompileMetadataResolver.prototype.initComponentFactory=function(factory,ngContentSelectors){factory instanceof StaticSymbol||(_a=factory.ngContentSelectors).push.apply(_a,ngContentSelectors);var _a},CompileMetadataResolver.prototype._loadSummary=function(type,kind){var typeSummary=this._summaryCache.get(type);if(!typeSummary){var summary=this._summaryResolver.resolveSummary(type);typeSummary=summary?summary.type:null,this._summaryCache.set(type,typeSummary||null)}return typeSummary&&typeSummary.summaryKind===kind?typeSummary:null},CompileMetadataResolver.prototype.getHostComponentMetadata=function(compMeta,hostViewType){var hostType=this.getHostComponentType(compMeta.type.reference);hostViewType||(hostViewType=this.getHostComponentViewClass(hostType));var template=CssSelector.parse(compMeta.selector)[0].getMatchingElementTemplate(),htmlAst=this._htmlParser.parse(template,"");return CompileDirectiveMetadata.create({isHost:!0,type:{reference:hostType,diDeps:[],lifecycleHooks:[]},template:new CompileTemplateMetadata({encapsulation:ViewEncapsulation.None,template:template,templateUrl:"",htmlAst:htmlAst,styles:[],styleUrls:[],ngContentSelectors:[],animations:[],isInline:!0,externalStylesheets:[],interpolation:null,preserveWhitespaces:!1}),exportAs:null,changeDetection:ChangeDetectionStrategy.Default,inputs:[],outputs:[],host:{},isComponent:!0,selector:"*",providers:[],viewProviders:[],queries:[],guards:{},viewQueries:[],componentViewType:hostViewType,rendererType:{id:"__Host__",encapsulation:ViewEncapsulation.None,styles:[],data:{}},entryComponents:[],componentFactory:null})},CompileMetadataResolver.prototype.loadDirectiveMetadata=function(ngModuleType,directiveType,isSync){var _this=this;if(this._directiveCache.has(directiveType))return null;directiveType=resolveForwardRef(directiveType);var _a=this.getNonNormalizedDirectiveMetadata(directiveType),annotation=_a.annotation,metadata=_a.metadata,createDirectiveMetadata=function(templateMetadata){var normalizedDirMeta=new CompileDirectiveMetadata({isHost:!1,type:metadata.type,isComponent:metadata.isComponent,selector:metadata.selector,exportAs:metadata.exportAs,changeDetection:metadata.changeDetection,inputs:metadata.inputs,outputs:metadata.outputs,hostListeners:metadata.hostListeners,hostProperties:metadata.hostProperties,hostAttributes:metadata.hostAttributes,providers:metadata.providers,viewProviders:metadata.viewProviders,queries:metadata.queries,guards:metadata.guards,viewQueries:metadata.viewQueries,entryComponents:metadata.entryComponents,componentViewType:metadata.componentViewType,rendererType:metadata.rendererType,componentFactory:metadata.componentFactory,template:templateMetadata});return templateMetadata&&_this.initComponentFactory(metadata.componentFactory,templateMetadata.ngContentSelectors),_this._directiveCache.set(directiveType,normalizedDirMeta),_this._summaryCache.set(directiveType,normalizedDirMeta.toSummary()),null};if(metadata.isComponent){var template=metadata.template,templateMeta=this._directiveNormalizer.normalizeTemplate({ngModuleType:ngModuleType,componentType:directiveType,moduleUrl:this._reflector.componentModuleUrl(directiveType,annotation),encapsulation:template.encapsulation,template:template.template,templateUrl:template.templateUrl,styles:template.styles,styleUrls:template.styleUrls,animations:template.animations,interpolation:template.interpolation,preserveWhitespaces:template.preserveWhitespaces});return isPromise(templateMeta)&&isSync?(this._reportError(componentStillLoadingError(directiveType),directiveType),null):SyncAsync.then(templateMeta,createDirectiveMetadata)}return createDirectiveMetadata(null),null},CompileMetadataResolver.prototype.getNonNormalizedDirectiveMetadata=function(directiveType){var _this=this;if(!(directiveType=resolveForwardRef(directiveType)))return null;var cacheEntry=this._nonNormalizedDirectiveCache.get(directiveType);if(cacheEntry)return cacheEntry;var dirMeta=this._directiveResolver.resolve(directiveType,!1);if(!dirMeta)return null;var nonNormalizedTemplateMetadata=void 0;if(createComponent.isTypeOf(dirMeta)){var compMeta=dirMeta;assertArrayOfStrings("styles",compMeta.styles),assertArrayOfStrings("styleUrls",compMeta.styleUrls),assertInterpolationSymbols("interpolation",compMeta.interpolation);var animations=compMeta.animations;nonNormalizedTemplateMetadata=new CompileTemplateMetadata({encapsulation:noUndefined(compMeta.encapsulation),template:noUndefined(compMeta.template),templateUrl:noUndefined(compMeta.templateUrl),htmlAst:null,styles:compMeta.styles||[],styleUrls:compMeta.styleUrls||[],animations:animations||[],interpolation:noUndefined(compMeta.interpolation),isInline:!!compMeta.template,externalStylesheets:[],ngContentSelectors:[],preserveWhitespaces:noUndefined(dirMeta.preserveWhitespaces)})}var changeDetectionStrategy=null,viewProviders=[],entryComponentMetadata=[],selector=dirMeta.selector;if(createComponent.isTypeOf(dirMeta)){var compMeta=dirMeta;changeDetectionStrategy=compMeta.changeDetection,compMeta.viewProviders&&(viewProviders=this._getProvidersMetadata(compMeta.viewProviders,entryComponentMetadata,'viewProviders for "'+stringifyType(directiveType)+'"',[],directiveType)),compMeta.entryComponents&&(entryComponentMetadata=flattenAndDedupeArray(compMeta.entryComponents).map(function(type){return _this._getEntryComponentMetadata(type)}).concat(entryComponentMetadata)),selector||(selector=this._schemaRegistry.getDefaultComponentElementName())}else selector||(this._reportError(syntaxError("Directive "+stringifyType(directiveType)+" has no selector, please add it!"),directiveType),selector="error");var providers=[];null!=dirMeta.providers&&(providers=this._getProvidersMetadata(dirMeta.providers,entryComponentMetadata,'providers for "'+stringifyType(directiveType)+'"',[],directiveType));var queries=[],viewQueries=[];null!=dirMeta.queries&&(queries=this._getQueriesMetadata(dirMeta.queries,!1,directiveType),viewQueries=this._getQueriesMetadata(dirMeta.queries,!0,directiveType));var metadata=CompileDirectiveMetadata.create({isHost:!1,selector:selector,exportAs:noUndefined(dirMeta.exportAs),isComponent:!!nonNormalizedTemplateMetadata,type:this._getTypeMetadata(directiveType),template:nonNormalizedTemplateMetadata,changeDetection:changeDetectionStrategy,inputs:dirMeta.inputs||[],outputs:dirMeta.outputs||[],host:dirMeta.host||{},providers:providers||[],viewProviders:viewProviders||[],queries:queries||[],guards:dirMeta.guards||{},viewQueries:viewQueries||[],entryComponents:entryComponentMetadata,componentViewType:nonNormalizedTemplateMetadata?this.getComponentViewClass(directiveType):null,rendererType:nonNormalizedTemplateMetadata?this.getRendererType(directiveType):null,componentFactory:null});return nonNormalizedTemplateMetadata&&(metadata.componentFactory=this.getComponentFactory(selector,directiveType,metadata.inputs,metadata.outputs)),cacheEntry={metadata:metadata,annotation:dirMeta},this._nonNormalizedDirectiveCache.set(directiveType,cacheEntry),cacheEntry},CompileMetadataResolver.prototype.getDirectiveMetadata=function(directiveType){var dirMeta=this._directiveCache.get(directiveType);return dirMeta||this._reportError(syntaxError("Illegal state: getDirectiveMetadata can only be called after loadNgModuleDirectiveAndPipeMetadata for a module that declares it. Directive "+stringifyType(directiveType)+"."),directiveType),dirMeta},CompileMetadataResolver.prototype.getDirectiveSummary=function(dirType){var dirSummary=this._loadSummary(dirType,CompileSummaryKind.Directive);return dirSummary||this._reportError(syntaxError("Illegal state: Could not load the summary for directive "+stringifyType(dirType)+"."),dirType),dirSummary},CompileMetadataResolver.prototype.isDirective=function(type){return!!this._loadSummary(type,CompileSummaryKind.Directive)||this._directiveResolver.isDirective(type)},CompileMetadataResolver.prototype.isPipe=function(type){return!!this._loadSummary(type,CompileSummaryKind.Pipe)||this._pipeResolver.isPipe(type)},CompileMetadataResolver.prototype.isNgModule=function(type){return!!this._loadSummary(type,CompileSummaryKind.NgModule)||this._ngModuleResolver.isNgModule(type)},CompileMetadataResolver.prototype.getNgModuleSummary=function(moduleType,alreadyCollecting){void 0===alreadyCollecting&&(alreadyCollecting=null);var moduleSummary=this._loadSummary(moduleType,CompileSummaryKind.NgModule);if(!moduleSummary){var moduleMeta=this.getNgModuleMetadata(moduleType,!1,alreadyCollecting);moduleSummary=moduleMeta?moduleMeta.toSummary():null,moduleSummary&&this._summaryCache.set(moduleType,moduleSummary)}return moduleSummary},CompileMetadataResolver.prototype.loadNgModuleDirectiveAndPipeMetadata=function(moduleType,isSync,throwIfNotFound){var _this=this;void 0===throwIfNotFound&&(throwIfNotFound=!0);var ngModule=this.getNgModuleMetadata(moduleType,throwIfNotFound),loading=[];return ngModule&&(ngModule.declaredDirectives.forEach(function(id){var promise=_this.loadDirectiveMetadata(moduleType,id.reference,isSync);promise&&loading.push(promise)}),ngModule.declaredPipes.forEach(function(id){return _this._loadPipeMetadata(id.reference)})),Promise.all(loading)},CompileMetadataResolver.prototype.getNgModuleMetadata=function(moduleType,throwIfNotFound,alreadyCollecting){var _this=this;void 0===throwIfNotFound&&(throwIfNotFound=!0),void 0===alreadyCollecting&&(alreadyCollecting=null),moduleType=resolveForwardRef(moduleType);var compileMeta=this._ngModuleCache.get(moduleType);if(compileMeta)return compileMeta;var meta=this._ngModuleResolver.resolve(moduleType,throwIfNotFound);if(!meta)return null;var declaredDirectives=[],exportedNonModuleIdentifiers=[],declaredPipes=[],importedModules=[],exportedModules=[],providers=[],entryComponents=[],bootstrapComponents=[],schemas=[];meta.imports&&flattenAndDedupeArray(meta.imports).forEach(function(importedType){var importedModuleType=void 0;if(isValidType(importedType))importedModuleType=importedType;else if(importedType&&importedType.ngModule){var moduleWithProviders=importedType;importedModuleType=moduleWithProviders.ngModule,moduleWithProviders.providers&&providers.push.apply(providers,_this._getProvidersMetadata(moduleWithProviders.providers,entryComponents,"provider for the NgModule '"+stringifyType(importedModuleType)+"'",[],importedType))}if(!importedModuleType)return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(importedType)+"' imported by the module '"+stringifyType(moduleType)+"'"),moduleType);if(!_this._checkSelfImport(moduleType,importedModuleType)){if(alreadyCollecting||(alreadyCollecting=new Set),alreadyCollecting.has(importedModuleType))return void _this._reportError(syntaxError(_this._getTypeDescriptor(importedModuleType)+" '"+stringifyType(importedType)+"' is imported recursively by the module '"+stringifyType(moduleType)+"'."),moduleType);alreadyCollecting.add(importedModuleType);var importedModuleSummary=_this.getNgModuleSummary(importedModuleType,alreadyCollecting);if(alreadyCollecting.delete(importedModuleType),!importedModuleSummary)return void _this._reportError(syntaxError("Unexpected "+_this._getTypeDescriptor(importedType)+" '"+stringifyType(importedType)+"' imported by the module '"+stringifyType(moduleType)+"'. Please add a @NgModule annotation."),moduleType);importedModules.push(importedModuleSummary)}}),meta.exports&&flattenAndDedupeArray(meta.exports).forEach(function(exportedType){if(!isValidType(exportedType))return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(exportedType)+"' exported by the module '"+stringifyType(moduleType)+"'"),moduleType);if(alreadyCollecting||(alreadyCollecting=new Set),alreadyCollecting.has(exportedType))return void _this._reportError(syntaxError(_this._getTypeDescriptor(exportedType)+" '"+stringify(exportedType)+"' is exported recursively by the module '"+stringifyType(moduleType)+"'"),moduleType);alreadyCollecting.add(exportedType);var exportedModuleSummary=_this.getNgModuleSummary(exportedType,alreadyCollecting);alreadyCollecting.delete(exportedType),exportedModuleSummary?exportedModules.push(exportedModuleSummary):exportedNonModuleIdentifiers.push(_this._getIdentifierMetadata(exportedType))});var transitiveModule=this._getTransitiveNgModuleMetadata(importedModules,exportedModules);meta.declarations&&flattenAndDedupeArray(meta.declarations).forEach(function(declaredType){if(!isValidType(declaredType))return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(declaredType)+"' declared by the module '"+stringifyType(moduleType)+"'"),moduleType);var declaredIdentifier=_this._getIdentifierMetadata(declaredType);if(_this.isDirective(declaredType))transitiveModule.addDirective(declaredIdentifier),declaredDirectives.push(declaredIdentifier),_this._addTypeToModule(declaredType,moduleType);else{if(!_this.isPipe(declaredType))return void _this._reportError(syntaxError("Unexpected "+_this._getTypeDescriptor(declaredType)+" '"+stringifyType(declaredType)+"' declared by the module '"+stringifyType(moduleType)+"'. Please add a @Pipe/@Directive/@Component annotation."),moduleType);transitiveModule.addPipe(declaredIdentifier),transitiveModule.pipes.push(declaredIdentifier),declaredPipes.push(declaredIdentifier),_this._addTypeToModule(declaredType,moduleType)}});var exportedDirectives=[],exportedPipes=[];return exportedNonModuleIdentifiers.forEach(function(exportedId){if(transitiveModule.directivesSet.has(exportedId.reference))exportedDirectives.push(exportedId),transitiveModule.addExportedDirective(exportedId);else{if(!transitiveModule.pipesSet.has(exportedId.reference))return void _this._reportError(syntaxError("Can't export "+_this._getTypeDescriptor(exportedId.reference)+" "+stringifyType(exportedId.reference)+" from "+stringifyType(moduleType)+" as it was neither declared nor imported!"),moduleType);exportedPipes.push(exportedId),transitiveModule.addExportedPipe(exportedId)}}),meta.providers&&providers.push.apply(providers,this._getProvidersMetadata(meta.providers,entryComponents,"provider for the NgModule '"+stringifyType(moduleType)+"'",[],moduleType)),meta.entryComponents&&entryComponents.push.apply(entryComponents,flattenAndDedupeArray(meta.entryComponents).map(function(type){return _this._getEntryComponentMetadata(type)})),meta.bootstrap&&flattenAndDedupeArray(meta.bootstrap).forEach(function(type){if(!isValidType(type))return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(type)+"' used in the bootstrap property of module '"+stringifyType(moduleType)+"'"),moduleType);bootstrapComponents.push(_this._getIdentifierMetadata(type))}),entryComponents.push.apply(entryComponents,bootstrapComponents.map(function(type){return _this._getEntryComponentMetadata(type.reference)})),meta.schemas&&schemas.push.apply(schemas,flattenAndDedupeArray(meta.schemas)),compileMeta=new CompileNgModuleMetadata({type:this._getTypeMetadata(moduleType),providers:providers,entryComponents:entryComponents,bootstrapComponents:bootstrapComponents,schemas:schemas,declaredDirectives:declaredDirectives,exportedDirectives:exportedDirectives,declaredPipes:declaredPipes,exportedPipes:exportedPipes,importedModules:importedModules,exportedModules:exportedModules,transitiveModule:transitiveModule,id:meta.id||null}),entryComponents.forEach(function(id){return transitiveModule.addEntryComponent(id)}),providers.forEach(function(provider){return transitiveModule.addProvider(provider,compileMeta.type)}),transitiveModule.addModule(compileMeta.type),this._ngModuleCache.set(moduleType,compileMeta),compileMeta},CompileMetadataResolver.prototype._checkSelfImport=function(moduleType,importedModuleType){return moduleType===importedModuleType&&(this._reportError(syntaxError("'"+stringifyType(moduleType)+"' module can't import itself"),moduleType),!0)},CompileMetadataResolver.prototype._getTypeDescriptor=function(type){if(isValidType(type)){if(this.isDirective(type))return"directive";if(this.isPipe(type))return"pipe";if(this.isNgModule(type))return"module"}return type.provide?"provider":"value"},CompileMetadataResolver.prototype._addTypeToModule=function(type,moduleType){var oldModule=this._ngModuleOfTypes.get(type);if(oldModule&&oldModule!==moduleType)return void this._reportError(syntaxError("Type "+stringifyType(type)+" is part of the declarations of 2 modules: "+stringifyType(oldModule)+" and "+stringifyType(moduleType)+"! Please consider moving "+stringifyType(type)+" to a higher module that imports "+stringifyType(oldModule)+" and "+stringifyType(moduleType)+". You can also create a new NgModule that exports and includes "+stringifyType(type)+" then import that NgModule in "+stringifyType(oldModule)+" and "+stringifyType(moduleType)+"."),moduleType);this._ngModuleOfTypes.set(type,moduleType)},CompileMetadataResolver.prototype._getTransitiveNgModuleMetadata=function(importedModules,exportedModules){var result=new TransitiveCompileNgModuleMetadata,modulesByToken=new Map;return importedModules.concat(exportedModules).forEach(function(modSummary){modSummary.modules.forEach(function(mod){return result.addModule(mod)}),modSummary.entryComponents.forEach(function(comp){return result.addEntryComponent(comp)});var addedTokens=new Set;modSummary.providers.forEach(function(entry){var tokenRef=tokenReference(entry.provider.token),prevModules=modulesByToken.get(tokenRef);prevModules||(prevModules=new Set,modulesByToken.set(tokenRef,prevModules));var moduleRef=entry.module.reference;!addedTokens.has(tokenRef)&&prevModules.has(moduleRef)||(prevModules.add(moduleRef),addedTokens.add(tokenRef),result.addProvider(entry.provider,entry.module))})}),exportedModules.forEach(function(modSummary){modSummary.exportedDirectives.forEach(function(id){return result.addExportedDirective(id)}),modSummary.exportedPipes.forEach(function(id){return result.addExportedPipe(id)})}),importedModules.forEach(function(modSummary){modSummary.exportedDirectives.forEach(function(id){return result.addDirective(id)}),modSummary.exportedPipes.forEach(function(id){return result.addPipe(id)})}),result},CompileMetadataResolver.prototype._getIdentifierMetadata=function(type){return type=resolveForwardRef(type),{reference:type}},CompileMetadataResolver.prototype.isInjectable=function(type){return this._reflector.annotations(type).some(function(ann){return createInjectable.isTypeOf(ann)})},CompileMetadataResolver.prototype.getInjectableSummary=function(type){return{summaryKind:CompileSummaryKind.Injectable,type:this._getTypeMetadata(type,null,!1)}},CompileMetadataResolver.prototype._getInjectableMetadata=function(type,dependencies){void 0===dependencies&&(dependencies=null);var typeSummary=this._loadSummary(type,CompileSummaryKind.Injectable);return typeSummary?typeSummary.type:this._getTypeMetadata(type,dependencies)},CompileMetadataResolver.prototype._getTypeMetadata=function(type,dependencies,throwOnUnknownDeps){void 0===dependencies&&(dependencies=null),void 0===throwOnUnknownDeps&&(throwOnUnknownDeps=!0);var identifier=this._getIdentifierMetadata(type);return{reference:identifier.reference,diDeps:this._getDependenciesMetadata(identifier.reference,dependencies,throwOnUnknownDeps),lifecycleHooks:getAllLifecycleHooks(this._reflector,identifier.reference)}},CompileMetadataResolver.prototype._getFactoryMetadata=function(factory,dependencies){return void 0===dependencies&&(dependencies=null),factory=resolveForwardRef(factory),{reference:factory,diDeps:this._getDependenciesMetadata(factory,dependencies)}},CompileMetadataResolver.prototype.getPipeMetadata=function(pipeType){var pipeMeta=this._pipeCache.get(pipeType);return pipeMeta||this._reportError(syntaxError("Illegal state: getPipeMetadata can only be called after loadNgModuleDirectiveAndPipeMetadata for a module that declares it. Pipe "+stringifyType(pipeType)+"."),pipeType),pipeMeta||null},CompileMetadataResolver.prototype.getPipeSummary=function(pipeType){var pipeSummary=this._loadSummary(pipeType,CompileSummaryKind.Pipe);return pipeSummary||this._reportError(syntaxError("Illegal state: Could not load the summary for pipe "+stringifyType(pipeType)+"."),pipeType),pipeSummary},CompileMetadataResolver.prototype.getOrLoadPipeMetadata=function(pipeType){var pipeMeta=this._pipeCache.get(pipeType);return pipeMeta||(pipeMeta=this._loadPipeMetadata(pipeType)),pipeMeta},CompileMetadataResolver.prototype._loadPipeMetadata=function(pipeType){pipeType=resolveForwardRef(pipeType);var pipeAnnotation=this._pipeResolver.resolve(pipeType),pipeMeta=new CompilePipeMetadata({type:this._getTypeMetadata(pipeType),name:pipeAnnotation.name,pure:!!pipeAnnotation.pure});return this._pipeCache.set(pipeType,pipeMeta),this._summaryCache.set(pipeType,pipeMeta.toSummary()),pipeMeta},CompileMetadataResolver.prototype._getDependenciesMetadata=function(typeOrFunc,dependencies,throwOnUnknownDeps){var _this=this;void 0===throwOnUnknownDeps&&(throwOnUnknownDeps=!0);var hasUnknownDeps=!1,params=dependencies||this._reflector.parameters(typeOrFunc)||[],dependenciesMetadata=params.map(function(param){var isAttribute=!1,isHost=!1,isSelf=!1,isSkipSelf=!1,isOptional=!1,token=null;return Array.isArray(param)?param.forEach(function(paramEntry){createHost.isTypeOf(paramEntry)?isHost=!0:createSelf.isTypeOf(paramEntry)?isSelf=!0:createSkipSelf.isTypeOf(paramEntry)?isSkipSelf=!0:createOptional.isTypeOf(paramEntry)?isOptional=!0:createAttribute.isTypeOf(paramEntry)?(isAttribute=!0,token=paramEntry.attributeName):createInject.isTypeOf(paramEntry)?token=paramEntry.token:createInjectionToken.isTypeOf(paramEntry)||paramEntry instanceof StaticSymbol?token=paramEntry:isValidType(paramEntry)&&null==token&&(token=paramEntry)}):token=param,null==token?(hasUnknownDeps=!0,null):{isAttribute:isAttribute,isHost:isHost,isSelf:isSelf,isSkipSelf:isSkipSelf,isOptional:isOptional,token:_this._getTokenMetadata(token)}});if(hasUnknownDeps){var depsTokens=dependenciesMetadata.map(function(dep){return dep?stringifyType(dep.token):"?"}).join(", "),message="Can't resolve all parameters for "+stringifyType(typeOrFunc)+": ("+depsTokens+").";throwOnUnknownDeps||this._config.strictInjectionParameters?this._reportError(syntaxError(message),typeOrFunc):this._console.warn("Warning: "+message+" This will become an error in Angular v6.x")}return dependenciesMetadata},CompileMetadataResolver.prototype._getTokenMetadata=function(token){token=resolveForwardRef(token);return"string"==typeof token?{value:token}:{identifier:{reference:token}}},CompileMetadataResolver.prototype._getProvidersMetadata=function(providers,targetEntryComponents,debugInfo,compileProviders,type){var _this=this;return void 0===compileProviders&&(compileProviders=[]),providers.forEach(function(provider,providerIdx){if(Array.isArray(provider))_this._getProvidersMetadata(provider,targetEntryComponents,debugInfo,compileProviders);else{provider=resolveForwardRef(provider);var providerMeta=void 0;if(provider&&"object"==typeof provider&&provider.hasOwnProperty("provide"))_this._validateProvider(provider),providerMeta=new ProviderMeta(provider.provide,provider);else{if(!isValidType(provider)){
if(void 0===provider)return void _this._reportError(syntaxError("Encountered undefined provider! Usually this means you have a circular dependencies (might be caused by using 'barrel' index.ts files."));var providersInfo=providers.reduce(function(soFar,seenProvider,seenProviderIdx){return seenProviderIdx<providerIdx?soFar.push(""+stringifyType(seenProvider)):seenProviderIdx==providerIdx?soFar.push("?"+stringifyType(seenProvider)+"?"):seenProviderIdx==providerIdx+1&&soFar.push("..."),soFar},[]).join(", ");return void _this._reportError(syntaxError("Invalid "+(debugInfo||"provider")+" - only instances of Provider and Type are allowed, got: ["+providersInfo+"]"),type)}providerMeta=new ProviderMeta(provider,{useClass:provider})}providerMeta.token===_this._reflector.resolveExternalReference(Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS)?targetEntryComponents.push.apply(targetEntryComponents,_this._getEntryComponentsFromProvider(providerMeta,type)):compileProviders.push(_this.getProviderMetadata(providerMeta))}}),compileProviders},CompileMetadataResolver.prototype._validateProvider=function(provider){provider.hasOwnProperty("useClass")&&null==provider.useClass&&this._reportError(syntaxError("Invalid provider for "+stringifyType(provider.provide)+". useClass cannot be "+provider.useClass+".\n           Usually it happens when:\n           1. There's a circular dependency (might be caused by using index.ts (barrel) files).\n           2. Class was used before it was declared. Use forwardRef in this case."))},CompileMetadataResolver.prototype._getEntryComponentsFromProvider=function(provider,type){var _this=this,components=[],collectedIdentifiers=[];return provider.useFactory||provider.useExisting||provider.useClass?(this._reportError(syntaxError("The ANALYZE_FOR_ENTRY_COMPONENTS token only supports useValue!"),type),[]):provider.multi?(extractIdentifiers(provider.useValue,collectedIdentifiers),collectedIdentifiers.forEach(function(identifier){var entry=_this._getEntryComponentMetadata(identifier.reference,!1);entry&&components.push(entry)}),components):(this._reportError(syntaxError("The ANALYZE_FOR_ENTRY_COMPONENTS token only supports 'multi = true'!"),type),[])},CompileMetadataResolver.prototype._getEntryComponentMetadata=function(dirType,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var dirMeta=this.getNonNormalizedDirectiveMetadata(dirType);if(dirMeta&&dirMeta.metadata.isComponent)return{componentType:dirType,componentFactory:dirMeta.metadata.componentFactory};var dirSummary=this._loadSummary(dirType,CompileSummaryKind.Directive);if(dirSummary&&dirSummary.isComponent)return{componentType:dirType,componentFactory:dirSummary.componentFactory};if(throwIfNotFound)throw syntaxError(dirType.name+" cannot be used as an entry component.");return null},CompileMetadataResolver.prototype.getProviderMetadata=function(provider){var compileDeps=void 0,compileTypeMetadata=null,compileFactoryMetadata=null,token=this._getTokenMetadata(provider.token);return provider.useClass?(compileTypeMetadata=this._getInjectableMetadata(provider.useClass,provider.dependencies),compileDeps=compileTypeMetadata.diDeps,provider.token===provider.useClass&&(token={identifier:compileTypeMetadata})):provider.useFactory&&(compileFactoryMetadata=this._getFactoryMetadata(provider.useFactory,provider.dependencies),compileDeps=compileFactoryMetadata.diDeps),{token:token,useClass:compileTypeMetadata,useValue:provider.useValue,useFactory:compileFactoryMetadata,useExisting:provider.useExisting?this._getTokenMetadata(provider.useExisting):void 0,deps:compileDeps,multi:provider.multi}},CompileMetadataResolver.prototype._getQueriesMetadata=function(queries,isViewQuery,directiveType){var _this=this,res=[];return Object.keys(queries).forEach(function(propertyName){var query=queries[propertyName];query.isViewQuery===isViewQuery&&res.push(_this._getQueryMetadata(query,propertyName,directiveType))}),res},CompileMetadataResolver.prototype._queryVarBindings=function(selector){return selector.split(/\s*,\s*/)},CompileMetadataResolver.prototype._getQueryMetadata=function(q,propertyName,typeOrFunc){var selectors,_this=this;return"string"==typeof q.selector?selectors=this._queryVarBindings(q.selector).map(function(varName){return _this._getTokenMetadata(varName)}):q.selector?selectors=[this._getTokenMetadata(q.selector)]:(this._reportError(syntaxError("Can't construct a query for the property \""+propertyName+'" of "'+stringifyType(typeOrFunc)+"\" since the query selector wasn't defined."),typeOrFunc),selectors=[]),{selectors:selectors,first:q.first,descendants:q.descendants,propertyName:propertyName,read:q.read?this._getTokenMetadata(q.read):null}},CompileMetadataResolver.prototype._reportError=function(error,type,otherType){if(!this._errorCollector)throw error;this._errorCollector(error,type),otherType&&this._errorCollector(error,otherType)},CompileMetadataResolver}(),_CompileValueConverter=function(_super){function _CompileValueConverter(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(_CompileValueConverter,_super),_CompileValueConverter.prototype.visitOther=function(value,targetIdentifiers){targetIdentifiers.push({reference:value})},_CompileValueConverter}(ValueTransformer),TypeModifier={Const:0};TypeModifier[TypeModifier.Const]="Const";var Type$1=function(){function Type(modifiers){void 0===modifiers&&(modifiers=null),this.modifiers=modifiers,modifiers||(this.modifiers=[])}return Type.prototype.hasModifier=function(modifier){return-1!==this.modifiers.indexOf(modifier)},Type}(),BuiltinTypeName={Dynamic:0,Bool:1,String:2,Int:3,Number:4,Function:5,Inferred:6};BuiltinTypeName[BuiltinTypeName.Dynamic]="Dynamic",BuiltinTypeName[BuiltinTypeName.Bool]="Bool",BuiltinTypeName[BuiltinTypeName.String]="String",BuiltinTypeName[BuiltinTypeName.Int]="Int",BuiltinTypeName[BuiltinTypeName.Number]="Number",BuiltinTypeName[BuiltinTypeName.Function]="Function",BuiltinTypeName[BuiltinTypeName.Inferred]="Inferred";var BuiltinType=function(_super){function BuiltinType(name,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.name=name,_this}return __extends(BuiltinType,_super),BuiltinType.prototype.visitType=function(visitor,context){return visitor.visitBuiltintType(this,context)},BuiltinType}(Type$1),ExpressionType=function(_super){function ExpressionType(value,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.value=value,_this}return __extends(ExpressionType,_super),ExpressionType.prototype.visitType=function(visitor,context){return visitor.visitExpressionType(this,context)},ExpressionType}(Type$1),ArrayType=function(_super){function ArrayType(of,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.of=of,_this}return __extends(ArrayType,_super),ArrayType.prototype.visitType=function(visitor,context){return visitor.visitArrayType(this,context)},ArrayType}(Type$1),MapType=function(_super){function MapType(valueType,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.valueType=valueType||null,_this}return __extends(MapType,_super),MapType.prototype.visitType=function(visitor,context){return visitor.visitMapType(this,context)},MapType}(Type$1),DYNAMIC_TYPE=new BuiltinType(BuiltinTypeName.Dynamic),INFERRED_TYPE=new BuiltinType(BuiltinTypeName.Inferred),BOOL_TYPE=new BuiltinType(BuiltinTypeName.Bool),BinaryOperator=(new BuiltinType(BuiltinTypeName.Int),new BuiltinType(BuiltinTypeName.Number),new BuiltinType(BuiltinTypeName.String),new BuiltinType(BuiltinTypeName.Function),{Equals:0,NotEquals:1,Identical:2,NotIdentical:3,Minus:4,Plus:5,Divide:6,Multiply:7,Modulo:8,And:9,Or:10,Lower:11,LowerEquals:12,Bigger:13,BiggerEquals:14});BinaryOperator[BinaryOperator.Equals]="Equals",BinaryOperator[BinaryOperator.NotEquals]="NotEquals",BinaryOperator[BinaryOperator.Identical]="Identical",BinaryOperator[BinaryOperator.NotIdentical]="NotIdentical",BinaryOperator[BinaryOperator.Minus]="Minus",BinaryOperator[BinaryOperator.Plus]="Plus",BinaryOperator[BinaryOperator.Divide]="Divide",BinaryOperator[BinaryOperator.Multiply]="Multiply",BinaryOperator[BinaryOperator.Modulo]="Modulo",BinaryOperator[BinaryOperator.And]="And",BinaryOperator[BinaryOperator.Or]="Or",BinaryOperator[BinaryOperator.Lower]="Lower",BinaryOperator[BinaryOperator.LowerEquals]="LowerEquals",BinaryOperator[BinaryOperator.Bigger]="Bigger",BinaryOperator[BinaryOperator.BiggerEquals]="BiggerEquals";var Expression=function(){function Expression(type,sourceSpan){this.type=type||null,this.sourceSpan=sourceSpan||null}return Expression.prototype.prop=function(name,sourceSpan){return new ReadPropExpr(this,name,null,sourceSpan)},Expression.prototype.key=function(index,type,sourceSpan){return new ReadKeyExpr(this,index,type,sourceSpan)},Expression.prototype.callMethod=function(name,params,sourceSpan){return new InvokeMethodExpr(this,name,params,null,sourceSpan)},Expression.prototype.callFn=function(params,sourceSpan){return new InvokeFunctionExpr(this,params,null,sourceSpan)},Expression.prototype.instantiate=function(params,type,sourceSpan){return new InstantiateExpr(this,params,type,sourceSpan)},Expression.prototype.conditional=function(trueCase,falseCase,sourceSpan){return void 0===falseCase&&(falseCase=null),new ConditionalExpr(this,trueCase,falseCase,null,sourceSpan)},Expression.prototype.equals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Equals,this,rhs,null,sourceSpan)},Expression.prototype.notEquals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.NotEquals,this,rhs,null,sourceSpan)},Expression.prototype.identical=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Identical,this,rhs,null,sourceSpan)},Expression.prototype.notIdentical=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.NotIdentical,this,rhs,null,sourceSpan)},Expression.prototype.minus=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Minus,this,rhs,null,sourceSpan)},Expression.prototype.plus=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Plus,this,rhs,null,sourceSpan)},Expression.prototype.divide=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Divide,this,rhs,null,sourceSpan)},Expression.prototype.multiply=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Multiply,this,rhs,null,sourceSpan)},Expression.prototype.modulo=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Modulo,this,rhs,null,sourceSpan)},Expression.prototype.and=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.And,this,rhs,null,sourceSpan)},Expression.prototype.or=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Or,this,rhs,null,sourceSpan)},Expression.prototype.lower=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Lower,this,rhs,null,sourceSpan)},Expression.prototype.lowerEquals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.LowerEquals,this,rhs,null,sourceSpan)},Expression.prototype.bigger=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Bigger,this,rhs,null,sourceSpan)},Expression.prototype.biggerEquals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.BiggerEquals,this,rhs,null,sourceSpan)},Expression.prototype.isBlank=function(sourceSpan){return this.equals(TYPED_NULL_EXPR,sourceSpan)},Expression.prototype.cast=function(type,sourceSpan){return new CastExpr(this,type,sourceSpan)},Expression.prototype.toStmt=function(){return new ExpressionStatement(this,null)},Expression}(),BuiltinVar={This:0,Super:1,CatchError:2,CatchStack:3};BuiltinVar[BuiltinVar.This]="This",BuiltinVar[BuiltinVar.Super]="Super",BuiltinVar[BuiltinVar.CatchError]="CatchError",BuiltinVar[BuiltinVar.CatchStack]="CatchStack";var ReadVarExpr=function(_super){function ReadVarExpr(name,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return"string"==typeof name?(_this.name=name,_this.builtin=null):(_this.name=null,_this.builtin=name),_this}return __extends(ReadVarExpr,_super),ReadVarExpr.prototype.isEquivalent=function(e){return e instanceof ReadVarExpr&&this.name===e.name&&this.builtin===e.builtin},ReadVarExpr.prototype.visitExpression=function(visitor,context){return visitor.visitReadVarExpr(this,context)},ReadVarExpr.prototype.set=function(value){if(!this.name)throw new Error("Built in variable "+this.builtin+" can not be assigned to.");return new WriteVarExpr(this.name,value,null,this.sourceSpan)},ReadVarExpr}(Expression),WriteVarExpr=function(_super){function WriteVarExpr(name,value,type,sourceSpan){var _this=_super.call(this,type||value.type,sourceSpan)||this;return _this.name=name,_this.value=value,_this}return __extends(WriteVarExpr,_super),WriteVarExpr.prototype.isEquivalent=function(e){return e instanceof WriteVarExpr&&this.name===e.name&&this.value.isEquivalent(e.value)},WriteVarExpr.prototype.visitExpression=function(visitor,context){return visitor.visitWriteVarExpr(this,context)},WriteVarExpr.prototype.toDeclStmt=function(type,modifiers){return new DeclareVarStmt(this.name,this.value,type,modifiers,this.sourceSpan)},WriteVarExpr}(Expression),WriteKeyExpr=function(_super){function WriteKeyExpr(receiver,index,value,type,sourceSpan){var _this=_super.call(this,type||value.type,sourceSpan)||this;return _this.receiver=receiver,_this.index=index,_this.value=value,_this}return __extends(WriteKeyExpr,_super),WriteKeyExpr.prototype.isEquivalent=function(e){return e instanceof WriteKeyExpr&&this.receiver.isEquivalent(e.receiver)&&this.index.isEquivalent(e.index)&&this.value.isEquivalent(e.value)},WriteKeyExpr.prototype.visitExpression=function(visitor,context){return visitor.visitWriteKeyExpr(this,context)},WriteKeyExpr}(Expression),WritePropExpr=function(_super){function WritePropExpr(receiver,name,value,type,sourceSpan){var _this=_super.call(this,type||value.type,sourceSpan)||this;return _this.receiver=receiver,_this.name=name,_this.value=value,_this}return __extends(WritePropExpr,_super),WritePropExpr.prototype.isEquivalent=function(e){return e instanceof WritePropExpr&&this.receiver.isEquivalent(e.receiver)&&this.name===e.name&&this.value.isEquivalent(e.value)},WritePropExpr.prototype.visitExpression=function(visitor,context){return visitor.visitWritePropExpr(this,context)},WritePropExpr}(Expression),BuiltinMethod={ConcatArray:0,SubscribeObservable:1,Bind:2};BuiltinMethod[BuiltinMethod.ConcatArray]="ConcatArray",BuiltinMethod[BuiltinMethod.SubscribeObservable]="SubscribeObservable",BuiltinMethod[BuiltinMethod.Bind]="Bind";var InvokeMethodExpr=function(_super){function InvokeMethodExpr(receiver,method,args,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.receiver=receiver,_this.args=args,"string"==typeof method?(_this.name=method,_this.builtin=null):(_this.name=null,_this.builtin=method),_this}return __extends(InvokeMethodExpr,_super),InvokeMethodExpr.prototype.isEquivalent=function(e){return e instanceof InvokeMethodExpr&&this.receiver.isEquivalent(e.receiver)&&this.name===e.name&&this.builtin===e.builtin&&areAllEquivalent(this.args,e.args)},InvokeMethodExpr.prototype.visitExpression=function(visitor,context){return visitor.visitInvokeMethodExpr(this,context)},InvokeMethodExpr}(Expression),InvokeFunctionExpr=function(_super){function InvokeFunctionExpr(fn,args,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.fn=fn,_this.args=args,_this}return __extends(InvokeFunctionExpr,_super),InvokeFunctionExpr.prototype.isEquivalent=function(e){return e instanceof InvokeFunctionExpr&&this.fn.isEquivalent(e.fn)&&areAllEquivalent(this.args,e.args)},InvokeFunctionExpr.prototype.visitExpression=function(visitor,context){return visitor.visitInvokeFunctionExpr(this,context)},InvokeFunctionExpr}(Expression),InstantiateExpr=function(_super){function InstantiateExpr(classExpr,args,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.classExpr=classExpr,_this.args=args,_this}return __extends(InstantiateExpr,_super),InstantiateExpr.prototype.isEquivalent=function(e){return e instanceof InstantiateExpr&&this.classExpr.isEquivalent(e.classExpr)&&areAllEquivalent(this.args,e.args)},InstantiateExpr.prototype.visitExpression=function(visitor,context){return visitor.visitInstantiateExpr(this,context)},InstantiateExpr}(Expression),LiteralExpr=function(_super){function LiteralExpr(value,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.value=value,_this}return __extends(LiteralExpr,_super),LiteralExpr.prototype.isEquivalent=function(e){return e instanceof LiteralExpr&&this.value===e.value},LiteralExpr.prototype.visitExpression=function(visitor,context){return visitor.visitLiteralExpr(this,context)},LiteralExpr}(Expression),ExternalExpr=function(_super){function ExternalExpr(value,type,typeParams,sourceSpan){void 0===typeParams&&(typeParams=null);var _this=_super.call(this,type,sourceSpan)||this;return _this.value=value,_this.typeParams=typeParams,_this}return __extends(ExternalExpr,_super),ExternalExpr.prototype.isEquivalent=function(e){return e instanceof ExternalExpr&&this.value.name===e.value.name&&this.value.moduleName===e.value.moduleName&&this.value.runtime===e.value.runtime},ExternalExpr.prototype.visitExpression=function(visitor,context){return visitor.visitExternalExpr(this,context)},ExternalExpr}(Expression),ExternalReference=function(){function ExternalReference(moduleName,name,runtime){this.moduleName=moduleName,this.name=name,this.runtime=runtime}return ExternalReference}(),ConditionalExpr=function(_super){function ConditionalExpr(condition,trueCase,falseCase,type,sourceSpan){void 0===falseCase&&(falseCase=null);var _this=_super.call(this,type||trueCase.type,sourceSpan)||this;return _this.condition=condition,_this.falseCase=falseCase,_this.trueCase=trueCase,_this}return __extends(ConditionalExpr,_super),ConditionalExpr.prototype.isEquivalent=function(e){return e instanceof ConditionalExpr&&this.condition.isEquivalent(e.condition)&&this.trueCase.isEquivalent(e.trueCase)&&nullSafeIsEquivalent(this.falseCase,e.falseCase)},ConditionalExpr.prototype.visitExpression=function(visitor,context){return visitor.visitConditionalExpr(this,context)},ConditionalExpr}(Expression),NotExpr=function(_super){function NotExpr(condition,sourceSpan){var _this=_super.call(this,BOOL_TYPE,sourceSpan)||this;return _this.condition=condition,_this}return __extends(NotExpr,_super),NotExpr.prototype.isEquivalent=function(e){return e instanceof NotExpr&&this.condition.isEquivalent(e.condition)},NotExpr.prototype.visitExpression=function(visitor,context){return visitor.visitNotExpr(this,context)},NotExpr}(Expression),AssertNotNull=function(_super){function AssertNotNull(condition,sourceSpan){var _this=_super.call(this,condition.type,sourceSpan)||this;return _this.condition=condition,_this}return __extends(AssertNotNull,_super),AssertNotNull.prototype.isEquivalent=function(e){return e instanceof AssertNotNull&&this.condition.isEquivalent(e.condition)},AssertNotNull.prototype.visitExpression=function(visitor,context){return visitor.visitAssertNotNullExpr(this,context)},AssertNotNull}(Expression),CastExpr=function(_super){function CastExpr(value,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.value=value,_this}return __extends(CastExpr,_super),CastExpr.prototype.isEquivalent=function(e){return e instanceof CastExpr&&this.value.isEquivalent(e.value)},CastExpr.prototype.visitExpression=function(visitor,context){return visitor.visitCastExpr(this,context)},CastExpr}(Expression),FnParam=function(){function FnParam(name,type){void 0===type&&(type=null),this.name=name,this.type=type}return FnParam.prototype.isEquivalent=function(param){return this.name===param.name},FnParam}(),FunctionExpr=function(_super){function FunctionExpr(params,statements,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.params=params,_this.statements=statements,_this}return __extends(FunctionExpr,_super),FunctionExpr.prototype.isEquivalent=function(e){return e instanceof FunctionExpr&&areAllEquivalent(this.params,e.params)&&areAllEquivalent(this.statements,e.statements)},FunctionExpr.prototype.visitExpression=function(visitor,context){return visitor.visitFunctionExpr(this,context)},FunctionExpr.prototype.toDeclStmt=function(name,modifiers){return void 0===modifiers&&(modifiers=null),new DeclareFunctionStmt(name,this.params,this.statements,this.type,modifiers,this.sourceSpan)},FunctionExpr}(Expression),BinaryOperatorExpr=function(_super){function BinaryOperatorExpr(operator,lhs,rhs,type,sourceSpan){var _this=_super.call(this,type||lhs.type,sourceSpan)||this;return _this.operator=operator,_this.rhs=rhs,_this.lhs=lhs,_this}return __extends(BinaryOperatorExpr,_super),BinaryOperatorExpr.prototype.isEquivalent=function(e){return e instanceof BinaryOperatorExpr&&this.operator===e.operator&&this.lhs.isEquivalent(e.lhs)&&this.rhs.isEquivalent(e.rhs)},BinaryOperatorExpr.prototype.visitExpression=function(visitor,context){return visitor.visitBinaryOperatorExpr(this,context)},BinaryOperatorExpr}(Expression),ReadPropExpr=function(_super){function ReadPropExpr(receiver,name,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.receiver=receiver,_this.name=name,_this}return __extends(ReadPropExpr,_super),ReadPropExpr.prototype.isEquivalent=function(e){return e instanceof ReadPropExpr&&this.receiver.isEquivalent(e.receiver)&&this.name===e.name},ReadPropExpr.prototype.visitExpression=function(visitor,context){return visitor.visitReadPropExpr(this,context)},ReadPropExpr.prototype.set=function(value){return new WritePropExpr(this.receiver,this.name,value,null,this.sourceSpan)},ReadPropExpr}(Expression),ReadKeyExpr=function(_super){function ReadKeyExpr(receiver,index,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.receiver=receiver,_this.index=index,_this}return __extends(ReadKeyExpr,_super),ReadKeyExpr.prototype.isEquivalent=function(e){return e instanceof ReadKeyExpr&&this.receiver.isEquivalent(e.receiver)&&this.index.isEquivalent(e.index)},ReadKeyExpr.prototype.visitExpression=function(visitor,context){return visitor.visitReadKeyExpr(this,context)},ReadKeyExpr.prototype.set=function(value){return new WriteKeyExpr(this.receiver,this.index,value,null,this.sourceSpan)},ReadKeyExpr}(Expression),LiteralArrayExpr=function(_super){function LiteralArrayExpr(entries,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.entries=entries,_this}return __extends(LiteralArrayExpr,_super),LiteralArrayExpr.prototype.isEquivalent=function(e){return e instanceof LiteralArrayExpr&&areAllEquivalent(this.entries,e.entries)},LiteralArrayExpr.prototype.visitExpression=function(visitor,context){return visitor.visitLiteralArrayExpr(this,context)},LiteralArrayExpr}(Expression),LiteralMapEntry=function(){function LiteralMapEntry(key,value,quoted){this.key=key,this.value=value,this.quoted=quoted}return LiteralMapEntry.prototype.isEquivalent=function(e){return this.key===e.key&&this.value.isEquivalent(e.value)},LiteralMapEntry}(),LiteralMapExpr=function(_super){function LiteralMapExpr(entries,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.entries=entries,_this.valueType=null,type&&(_this.valueType=type.valueType),_this}return __extends(LiteralMapExpr,_super),LiteralMapExpr.prototype.isEquivalent=function(e){return e instanceof LiteralMapExpr&&areAllEquivalent(this.entries,e.entries)},LiteralMapExpr.prototype.visitExpression=function(visitor,context){return visitor.visitLiteralMapExpr(this,context)},LiteralMapExpr}(Expression),CommaExpr=function(_super){function CommaExpr(parts,sourceSpan){var _this=_super.call(this,parts[parts.length-1].type,sourceSpan)||this;return _this.parts=parts,_this}return __extends(CommaExpr,_super),CommaExpr.prototype.isEquivalent=function(e){return e instanceof CommaExpr&&areAllEquivalent(this.parts,e.parts)},CommaExpr.prototype.visitExpression=function(visitor,context){return visitor.visitCommaExpr(this,context)},CommaExpr}(Expression),NULL_EXPR=(new ReadVarExpr(BuiltinVar.This,null,null),new ReadVarExpr(BuiltinVar.Super,null,null),new ReadVarExpr(BuiltinVar.CatchError,null,null),new ReadVarExpr(BuiltinVar.CatchStack,null,null),new LiteralExpr(null,null,null)),TYPED_NULL_EXPR=new LiteralExpr(null,INFERRED_TYPE,null),StmtModifier={Final:0,Private:1,Exported:2};StmtModifier[StmtModifier.Final]="Final",StmtModifier[StmtModifier.Private]="Private",StmtModifier[StmtModifier.Exported]="Exported";var Statement=function(){function Statement(modifiers,sourceSpan){this.modifiers=modifiers||[],this.sourceSpan=sourceSpan||null}return Statement.prototype.hasModifier=function(modifier){return-1!==this.modifiers.indexOf(modifier)},Statement}(),DeclareVarStmt=function(_super){function DeclareVarStmt(name,value,type,modifiers,sourceSpan){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers,sourceSpan)||this;return _this.name=name,_this.value=value,_this.type=type||value.type,_this}return __extends(DeclareVarStmt,_super),DeclareVarStmt.prototype.isEquivalent=function(stmt){return stmt instanceof DeclareVarStmt&&this.name===stmt.name&&this.value.isEquivalent(stmt.value)},DeclareVarStmt.prototype.visitStatement=function(visitor,context){return visitor.visitDeclareVarStmt(this,context)},DeclareVarStmt}(Statement),DeclareFunctionStmt=function(_super){function DeclareFunctionStmt(name,params,statements,type,modifiers,sourceSpan){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers,sourceSpan)||this;return _this.name=name,_this.params=params,_this.statements=statements,_this.type=type||null,_this}return __extends(DeclareFunctionStmt,_super),DeclareFunctionStmt.prototype.isEquivalent=function(stmt){return stmt instanceof DeclareFunctionStmt&&areAllEquivalent(this.params,stmt.params)&&areAllEquivalent(this.statements,stmt.statements)},DeclareFunctionStmt.prototype.visitStatement=function(visitor,context){return visitor.visitDeclareFunctionStmt(this,context)},DeclareFunctionStmt}(Statement),ExpressionStatement=function(_super){function ExpressionStatement(expr,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.expr=expr,_this}return __extends(ExpressionStatement,_super),ExpressionStatement.prototype.isEquivalent=function(stmt){return stmt instanceof ExpressionStatement&&this.expr.isEquivalent(stmt.expr)},ExpressionStatement.prototype.visitStatement=function(visitor,context){return visitor.visitExpressionStmt(this,context)},ExpressionStatement}(Statement),ReturnStatement=function(_super){function ReturnStatement(value,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.value=value,_this}return __extends(ReturnStatement,_super),ReturnStatement.prototype.isEquivalent=function(stmt){return stmt instanceof ReturnStatement&&this.value.isEquivalent(stmt.value)},ReturnStatement.prototype.visitStatement=function(visitor,context){return visitor.visitReturnStmt(this,context)},ReturnStatement}(Statement),AbstractClassPart=function(){function AbstractClassPart(type,modifiers){this.modifiers=modifiers,modifiers||(this.modifiers=[]),this.type=type||null}return AbstractClassPart.prototype.hasModifier=function(modifier){return-1!==this.modifiers.indexOf(modifier)},AbstractClassPart}(),ClassMethod=(function(_super){function ClassField(name,type,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,type,modifiers)||this;return _this.name=name,_this}__extends(ClassField,_super),ClassField.prototype.isEquivalent=function(f){return this.name===f.name}}(AbstractClassPart),function(_super){function ClassMethod(name,params,body,type,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,type,modifiers)||this;return _this.name=name,_this.params=params,_this.body=body,_this}return __extends(ClassMethod,_super),ClassMethod.prototype.isEquivalent=function(m){return this.name===m.name&&areAllEquivalent(this.body,m.body)},ClassMethod}(AbstractClassPart)),ClassGetter=function(_super){function ClassGetter(name,body,type,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,type,modifiers)||this;return _this.name=name,_this.body=body,_this}return __extends(ClassGetter,_super),ClassGetter.prototype.isEquivalent=function(m){return this.name===m.name&&areAllEquivalent(this.body,m.body)},ClassGetter}(AbstractClassPart),ClassStmt=function(_super){function ClassStmt(name,parent,fields,getters,constructorMethod,methods,modifiers,sourceSpan){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers,sourceSpan)||this;return _this.name=name,_this.parent=parent,_this.fields=fields,_this.getters=getters,_this.constructorMethod=constructorMethod,_this.methods=methods,_this}return __extends(ClassStmt,_super),ClassStmt.prototype.isEquivalent=function(stmt){return stmt instanceof ClassStmt&&this.name===stmt.name&&nullSafeIsEquivalent(this.parent,stmt.parent)&&areAllEquivalent(this.fields,stmt.fields)&&areAllEquivalent(this.getters,stmt.getters)&&this.constructorMethod.isEquivalent(stmt.constructorMethod)&&areAllEquivalent(this.methods,stmt.methods)},ClassStmt.prototype.visitStatement=function(visitor,context){return visitor.visitDeclareClassStmt(this,context)},ClassStmt}(Statement),IfStmt=function(_super){function IfStmt(condition,trueCase,falseCase,sourceSpan){void 0===falseCase&&(falseCase=[]);var _this=_super.call(this,null,sourceSpan)||this;return _this.condition=condition,_this.trueCase=trueCase,_this.falseCase=falseCase,_this}return __extends(IfStmt,_super),IfStmt.prototype.isEquivalent=function(stmt){return stmt instanceof IfStmt&&this.condition.isEquivalent(stmt.condition)&&areAllEquivalent(this.trueCase,stmt.trueCase)&&areAllEquivalent(this.falseCase,stmt.falseCase)},IfStmt.prototype.visitStatement=function(visitor,context){return visitor.visitIfStmt(this,context)},IfStmt}(Statement),CommentStmt=function(_super){function CommentStmt(comment,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.comment=comment,_this}return __extends(CommentStmt,_super),CommentStmt.prototype.isEquivalent=function(stmt){return stmt instanceof CommentStmt},CommentStmt.prototype.visitStatement=function(visitor,context){return visitor.visitCommentStmt(this,context)},CommentStmt}(Statement),TryCatchStmt=function(_super){function TryCatchStmt(bodyStmts,catchStmts,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.bodyStmts=bodyStmts,_this.catchStmts=catchStmts,_this}return __extends(TryCatchStmt,_super),TryCatchStmt.prototype.isEquivalent=function(stmt){return stmt instanceof TryCatchStmt&&areAllEquivalent(this.bodyStmts,stmt.bodyStmts)&&areAllEquivalent(this.catchStmts,stmt.catchStmts)},TryCatchStmt.prototype.visitStatement=function(visitor,context){return visitor.visitTryCatchStmt(this,context)},TryCatchStmt}(Statement),ThrowStmt=function(_super){function ThrowStmt(error,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.error=error,_this}return __extends(ThrowStmt,_super),ThrowStmt.prototype.isEquivalent=function(stmt){return stmt instanceof TryCatchStmt&&this.error.isEquivalent(stmt.error)},ThrowStmt.prototype.visitStatement=function(visitor,context){return visitor.visitThrowStmt(this,context)},ThrowStmt}(Statement),AstTransformer$1=function(){function AstTransformer(){}return AstTransformer.prototype.transformExpr=function(expr,context){return expr},AstTransformer.prototype.transformStmt=function(stmt,context){return stmt},AstTransformer.prototype.visitReadVarExpr=function(ast,context){return this.transformExpr(ast,context)},AstTransformer.prototype.visitWriteVarExpr=function(expr,context){
return this.transformExpr(new WriteVarExpr(expr.name,expr.value.visitExpression(this,context),expr.type,expr.sourceSpan),context)},AstTransformer.prototype.visitWriteKeyExpr=function(expr,context){return this.transformExpr(new WriteKeyExpr(expr.receiver.visitExpression(this,context),expr.index.visitExpression(this,context),expr.value.visitExpression(this,context),expr.type,expr.sourceSpan),context)},AstTransformer.prototype.visitWritePropExpr=function(expr,context){return this.transformExpr(new WritePropExpr(expr.receiver.visitExpression(this,context),expr.name,expr.value.visitExpression(this,context),expr.type,expr.sourceSpan),context)},AstTransformer.prototype.visitInvokeMethodExpr=function(ast,context){var method=ast.builtin||ast.name;return this.transformExpr(new InvokeMethodExpr(ast.receiver.visitExpression(this,context),method,this.visitAllExpressions(ast.args,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitInvokeFunctionExpr=function(ast,context){return this.transformExpr(new InvokeFunctionExpr(ast.fn.visitExpression(this,context),this.visitAllExpressions(ast.args,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitInstantiateExpr=function(ast,context){return this.transformExpr(new InstantiateExpr(ast.classExpr.visitExpression(this,context),this.visitAllExpressions(ast.args,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitLiteralExpr=function(ast,context){return this.transformExpr(ast,context)},AstTransformer.prototype.visitExternalExpr=function(ast,context){return this.transformExpr(ast,context)},AstTransformer.prototype.visitConditionalExpr=function(ast,context){return this.transformExpr(new ConditionalExpr(ast.condition.visitExpression(this,context),ast.trueCase.visitExpression(this,context),ast.falseCase.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitNotExpr=function(ast,context){return this.transformExpr(new NotExpr(ast.condition.visitExpression(this,context),ast.sourceSpan),context)},AstTransformer.prototype.visitAssertNotNullExpr=function(ast,context){return this.transformExpr(new AssertNotNull(ast.condition.visitExpression(this,context),ast.sourceSpan),context)},AstTransformer.prototype.visitCastExpr=function(ast,context){return this.transformExpr(new CastExpr(ast.value.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitFunctionExpr=function(ast,context){return this.transformExpr(new FunctionExpr(ast.params,this.visitAllStatements(ast.statements,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitBinaryOperatorExpr=function(ast,context){return this.transformExpr(new BinaryOperatorExpr(ast.operator,ast.lhs.visitExpression(this,context),ast.rhs.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitReadPropExpr=function(ast,context){return this.transformExpr(new ReadPropExpr(ast.receiver.visitExpression(this,context),ast.name,ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitReadKeyExpr=function(ast,context){return this.transformExpr(new ReadKeyExpr(ast.receiver.visitExpression(this,context),ast.index.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitLiteralArrayExpr=function(ast,context){return this.transformExpr(new LiteralArrayExpr(this.visitAllExpressions(ast.entries,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitLiteralMapExpr=function(ast,context){var _this=this,entries=ast.entries.map(function(entry){return new LiteralMapEntry(entry.key,entry.value.visitExpression(_this,context),entry.quoted)}),mapType=new MapType(ast.valueType,null);return this.transformExpr(new LiteralMapExpr(entries,mapType,ast.sourceSpan),context)},AstTransformer.prototype.visitCommaExpr=function(ast,context){return this.transformExpr(new CommaExpr(this.visitAllExpressions(ast.parts,context),ast.sourceSpan),context)},AstTransformer.prototype.visitAllExpressions=function(exprs,context){var _this=this;return exprs.map(function(expr){return expr.visitExpression(_this,context)})},AstTransformer.prototype.visitDeclareVarStmt=function(stmt,context){return this.transformStmt(new DeclareVarStmt(stmt.name,stmt.value.visitExpression(this,context),stmt.type,stmt.modifiers,stmt.sourceSpan),context)},AstTransformer.prototype.visitDeclareFunctionStmt=function(stmt,context){return this.transformStmt(new DeclareFunctionStmt(stmt.name,stmt.params,this.visitAllStatements(stmt.statements,context),stmt.type,stmt.modifiers,stmt.sourceSpan),context)},AstTransformer.prototype.visitExpressionStmt=function(stmt,context){return this.transformStmt(new ExpressionStatement(stmt.expr.visitExpression(this,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitReturnStmt=function(stmt,context){return this.transformStmt(new ReturnStatement(stmt.value.visitExpression(this,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitDeclareClassStmt=function(stmt,context){var _this=this,parent=stmt.parent.visitExpression(this,context),getters=stmt.getters.map(function(getter){return new ClassGetter(getter.name,_this.visitAllStatements(getter.body,context),getter.type,getter.modifiers)}),ctorMethod=stmt.constructorMethod&&new ClassMethod(stmt.constructorMethod.name,stmt.constructorMethod.params,this.visitAllStatements(stmt.constructorMethod.body,context),stmt.constructorMethod.type,stmt.constructorMethod.modifiers),methods=stmt.methods.map(function(method){return new ClassMethod(method.name,method.params,_this.visitAllStatements(method.body,context),method.type,method.modifiers)});return this.transformStmt(new ClassStmt(stmt.name,parent,stmt.fields,getters,ctorMethod,methods,stmt.modifiers,stmt.sourceSpan),context)},AstTransformer.prototype.visitIfStmt=function(stmt,context){return this.transformStmt(new IfStmt(stmt.condition.visitExpression(this,context),this.visitAllStatements(stmt.trueCase,context),this.visitAllStatements(stmt.falseCase,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitTryCatchStmt=function(stmt,context){return this.transformStmt(new TryCatchStmt(this.visitAllStatements(stmt.bodyStmts,context),this.visitAllStatements(stmt.catchStmts,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitThrowStmt=function(stmt,context){return this.transformStmt(new ThrowStmt(stmt.error.visitExpression(this,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitCommentStmt=function(stmt,context){return this.transformStmt(stmt,context)},AstTransformer.prototype.visitAllStatements=function(stmts,context){var _this=this;return stmts.map(function(stmt){return stmt.visitStatement(_this,context)})},AstTransformer}(),RecursiveAstVisitor$1=function(){function RecursiveAstVisitor(){}return RecursiveAstVisitor.prototype.visitType=function(ast,context){return ast},RecursiveAstVisitor.prototype.visitExpression=function(ast,context){return ast.type&&ast.type.visitType(this,context),ast},RecursiveAstVisitor.prototype.visitBuiltintType=function(type,context){return this.visitType(type,context)},RecursiveAstVisitor.prototype.visitExpressionType=function(type,context){return type.value.visitExpression(this,context),this.visitType(type,context)},RecursiveAstVisitor.prototype.visitArrayType=function(type,context){return this.visitType(type,context)},RecursiveAstVisitor.prototype.visitMapType=function(type,context){return this.visitType(type,context)},RecursiveAstVisitor.prototype.visitReadVarExpr=function(ast,context){return this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitWriteVarExpr=function(ast,context){return ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitWriteKeyExpr=function(ast,context){return ast.receiver.visitExpression(this,context),ast.index.visitExpression(this,context),ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitWritePropExpr=function(ast,context){return ast.receiver.visitExpression(this,context),ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitInvokeMethodExpr=function(ast,context){return ast.receiver.visitExpression(this,context),this.visitAllExpressions(ast.args,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitInvokeFunctionExpr=function(ast,context){return ast.fn.visitExpression(this,context),this.visitAllExpressions(ast.args,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitInstantiateExpr=function(ast,context){return ast.classExpr.visitExpression(this,context),this.visitAllExpressions(ast.args,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitLiteralExpr=function(ast,context){return this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitExternalExpr=function(ast,context){var _this=this;return ast.typeParams&&ast.typeParams.forEach(function(type){return type.visitType(_this,context)}),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitConditionalExpr=function(ast,context){return ast.condition.visitExpression(this,context),ast.trueCase.visitExpression(this,context),ast.falseCase.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitNotExpr=function(ast,context){return ast.condition.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitAssertNotNullExpr=function(ast,context){return ast.condition.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitCastExpr=function(ast,context){return ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitFunctionExpr=function(ast,context){return this.visitAllStatements(ast.statements,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitBinaryOperatorExpr=function(ast,context){return ast.lhs.visitExpression(this,context),ast.rhs.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitReadPropExpr=function(ast,context){return ast.receiver.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitReadKeyExpr=function(ast,context){return ast.receiver.visitExpression(this,context),ast.index.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitLiteralArrayExpr=function(ast,context){return this.visitAllExpressions(ast.entries,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitLiteralMapExpr=function(ast,context){var _this=this;return ast.entries.forEach(function(entry){return entry.value.visitExpression(_this,context)}),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitCommaExpr=function(ast,context){return this.visitAllExpressions(ast.parts,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitAllExpressions=function(exprs,context){var _this=this;exprs.forEach(function(expr){return expr.visitExpression(_this,context)})},RecursiveAstVisitor.prototype.visitDeclareVarStmt=function(stmt,context){return stmt.value.visitExpression(this,context),stmt.type&&stmt.type.visitType(this,context),stmt},RecursiveAstVisitor.prototype.visitDeclareFunctionStmt=function(stmt,context){return this.visitAllStatements(stmt.statements,context),stmt.type&&stmt.type.visitType(this,context),stmt},RecursiveAstVisitor.prototype.visitExpressionStmt=function(stmt,context){return stmt.expr.visitExpression(this,context),stmt},RecursiveAstVisitor.prototype.visitReturnStmt=function(stmt,context){return stmt.value.visitExpression(this,context),stmt},RecursiveAstVisitor.prototype.visitDeclareClassStmt=function(stmt,context){var _this=this;return stmt.parent.visitExpression(this,context),stmt.getters.forEach(function(getter){return _this.visitAllStatements(getter.body,context)}),stmt.constructorMethod&&this.visitAllStatements(stmt.constructorMethod.body,context),stmt.methods.forEach(function(method){return _this.visitAllStatements(method.body,context)}),stmt},RecursiveAstVisitor.prototype.visitIfStmt=function(stmt,context){return stmt.condition.visitExpression(this,context),this.visitAllStatements(stmt.trueCase,context),this.visitAllStatements(stmt.falseCase,context),stmt},RecursiveAstVisitor.prototype.visitTryCatchStmt=function(stmt,context){return this.visitAllStatements(stmt.bodyStmts,context),this.visitAllStatements(stmt.catchStmts,context),stmt},RecursiveAstVisitor.prototype.visitThrowStmt=function(stmt,context){return stmt.error.visitExpression(this,context),stmt},RecursiveAstVisitor.prototype.visitCommentStmt=function(stmt,context){return stmt},RecursiveAstVisitor.prototype.visitAllStatements=function(stmts,context){var _this=this;stmts.forEach(function(stmt){return stmt.visitStatement(_this,context)})},RecursiveAstVisitor}(),_ReadVarVisitor=function(_super){function _ReadVarVisitor(){var _this=null!==_super&&_super.apply(this,arguments)||this;return _this.varNames=new Set,_this}return __extends(_ReadVarVisitor,_super),_ReadVarVisitor.prototype.visitDeclareFunctionStmt=function(stmt,context){return stmt},_ReadVarVisitor.prototype.visitDeclareClassStmt=function(stmt,context){return stmt},_ReadVarVisitor.prototype.visitReadVarExpr=function(ast,context){return ast.name&&this.varNames.add(ast.name),null},_ReadVarVisitor}(RecursiveAstVisitor$1),_FindExternalReferencesVisitor=function(_super){function _FindExternalReferencesVisitor(){var _this=null!==_super&&_super.apply(this,arguments)||this;return _this.externalReferences=[],_this}return __extends(_FindExternalReferencesVisitor,_super),_FindExternalReferencesVisitor.prototype.visitExternalExpr=function(e,context){return this.externalReferences.push(e.value),_super.prototype.visitExternalExpr.call(this,e,context)},_FindExternalReferencesVisitor}(RecursiveAstVisitor$1),_ApplySourceSpanTransformer=function(_super){function _ApplySourceSpanTransformer(sourceSpan){var _this=_super.call(this)||this;return _this.sourceSpan=sourceSpan,_this}return __extends(_ApplySourceSpanTransformer,_super),_ApplySourceSpanTransformer.prototype._clone=function(obj){var clone=Object.create(obj.constructor.prototype);for(var prop in obj)clone[prop]=obj[prop];return clone},_ApplySourceSpanTransformer.prototype.transformExpr=function(expr,context){return expr.sourceSpan||(expr=this._clone(expr),expr.sourceSpan=this.sourceSpan),expr},_ApplySourceSpanTransformer.prototype.transformStmt=function(stmt,context){return stmt.sourceSpan||(stmt=this._clone(stmt),stmt.sourceSpan=this.sourceSpan),stmt},_ApplySourceSpanTransformer}(AstTransformer$1),ProviderError=function(_super){function ProviderError(message,span){return _super.call(this,span,message)||this}return __extends(ProviderError,_super),ProviderError}(ParseError),ProviderViewContext=function(){function ProviderViewContext(reflector,component){var _this=this;this.reflector=reflector,this.component=component,this.errors=[],this.viewQueries=_getViewQueries(component),this.viewProviders=new Map,component.viewProviders.forEach(function(provider){null==_this.viewProviders.get(tokenReference(provider.token))&&_this.viewProviders.set(tokenReference(provider.token),!0)})}return ProviderViewContext}(),ProviderElementContext=function(){function ProviderElementContext(viewContext,_parent,_isViewRoot,_directiveAsts,attrs,refs,isTemplate,contentQueryStartId,_sourceSpan){var _this=this;this.viewContext=viewContext,this._parent=_parent,this._isViewRoot=_isViewRoot,this._directiveAsts=_directiveAsts,this._sourceSpan=_sourceSpan,this._transformedProviders=new Map,this._seenProviders=new Map,this._queriedTokens=new Map,this.transformedHasViewContainer=!1,this._attrs={},attrs.forEach(function(attrAst){return _this._attrs[attrAst.name]=attrAst.value});var directivesMeta=_directiveAsts.map(function(directiveAst){return directiveAst.directive});if(this._allProviders=_resolveProvidersFromDirectives(directivesMeta,_sourceSpan,viewContext.errors),this._contentQueries=_getContentQueries(contentQueryStartId,directivesMeta),Array.from(this._allProviders.values()).forEach(function(provider){_this._addQueryReadsTo(provider.token,provider.token,_this._queriedTokens)}),isTemplate){var templateRefId=createTokenForExternalReference(this.viewContext.reflector,Identifiers.TemplateRef);this._addQueryReadsTo(templateRefId,templateRefId,this._queriedTokens)}refs.forEach(function(refAst){var defaultQueryValue=refAst.value||createTokenForExternalReference(_this.viewContext.reflector,Identifiers.ElementRef);_this._addQueryReadsTo({value:refAst.name},defaultQueryValue,_this._queriedTokens)}),this._queriedTokens.get(this.viewContext.reflector.resolveExternalReference(Identifiers.ViewContainerRef))&&(this.transformedHasViewContainer=!0),Array.from(this._allProviders.values()).forEach(function(provider){(provider.eager||_this._queriedTokens.get(tokenReference(provider.token)))&&_this._getOrCreateLocalProvider(provider.providerType,provider.token,!0)})}return ProviderElementContext.prototype.afterElement=function(){var _this=this;Array.from(this._allProviders.values()).forEach(function(provider){_this._getOrCreateLocalProvider(provider.providerType,provider.token,!1)})},Object.defineProperty(ProviderElementContext.prototype,"transformProviders",{get:function(){var lazyProviders=[],eagerProviders=[];return this._transformedProviders.forEach(function(provider){provider.eager?eagerProviders.push(provider):lazyProviders.push(provider)}),lazyProviders.concat(eagerProviders)},enumerable:!0,configurable:!0}),Object.defineProperty(ProviderElementContext.prototype,"transformedDirectiveAsts",{get:function(){var sortedProviderTypes=this.transformProviders.map(function(provider){return provider.token.identifier}),sortedDirectives=this._directiveAsts.slice();return sortedDirectives.sort(function(dir1,dir2){return sortedProviderTypes.indexOf(dir1.directive.type)-sortedProviderTypes.indexOf(dir2.directive.type)}),sortedDirectives},enumerable:!0,configurable:!0}),Object.defineProperty(ProviderElementContext.prototype,"queryMatches",{get:function(){var allMatches=[];return this._queriedTokens.forEach(function(matches){allMatches.push.apply(allMatches,matches)}),allMatches},enumerable:!0,configurable:!0}),ProviderElementContext.prototype._addQueryReadsTo=function(token,defaultValue,queryReadTokens){this._getQueriesFor(token).forEach(function(query){var queryValue=query.meta.read||defaultValue,tokenRef=tokenReference(queryValue),queryMatches=queryReadTokens.get(tokenRef);queryMatches||(queryMatches=[],queryReadTokens.set(tokenRef,queryMatches)),queryMatches.push({queryId:query.queryId,value:queryValue})})},ProviderElementContext.prototype._getQueriesFor=function(token){for(var queries,result=[],currentEl=this,distance=0;null!==currentEl;)queries=currentEl._contentQueries.get(tokenReference(token)),queries&&result.push.apply(result,queries.filter(function(query){return query.meta.descendants||distance<=1})),currentEl._directiveAsts.length>0&&distance++,currentEl=currentEl._parent;return queries=this.viewContext.viewQueries.get(tokenReference(token)),queries&&result.push.apply(result,queries),result},ProviderElementContext.prototype._getOrCreateLocalProvider=function(requestingProviderType,token,eager){var _this=this,resolvedProvider=this._allProviders.get(tokenReference(token));if(!resolvedProvider||(requestingProviderType===ProviderAstType.Directive||requestingProviderType===ProviderAstType.PublicService)&&resolvedProvider.providerType===ProviderAstType.PrivateService||(requestingProviderType===ProviderAstType.PrivateService||requestingProviderType===ProviderAstType.PublicService)&&resolvedProvider.providerType===ProviderAstType.Builtin)return null;var transformedProviderAst=this._transformedProviders.get(tokenReference(token));if(transformedProviderAst)return transformedProviderAst;if(null!=this._seenProviders.get(tokenReference(token)))return this.viewContext.errors.push(new ProviderError("Cannot instantiate cyclic dependency! "+tokenName(token),this._sourceSpan)),null;this._seenProviders.set(tokenReference(token),!0);var transformedProviders=resolvedProvider.providers.map(function(provider){var transformedUseValue=provider.useValue,transformedUseExisting=provider.useExisting,transformedDeps=void 0;if(null!=provider.useExisting){var existingDiDep=_this._getDependency(resolvedProvider.providerType,{token:provider.useExisting},eager);null!=existingDiDep.token?transformedUseExisting=existingDiDep.token:(transformedUseExisting=null,transformedUseValue=existingDiDep.value)}else if(provider.useFactory){var deps=provider.deps||provider.useFactory.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(resolvedProvider.providerType,dep,eager)})}else if(provider.useClass){var deps=provider.deps||provider.useClass.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(resolvedProvider.providerType,dep,eager)})}return _transformProvider(provider,{useExisting:transformedUseExisting,useValue:transformedUseValue,deps:transformedDeps})});return transformedProviderAst=_transformProviderAst(resolvedProvider,{eager:eager,providers:transformedProviders}),this._transformedProviders.set(tokenReference(token),transformedProviderAst),transformedProviderAst},ProviderElementContext.prototype._getLocalDependency=function(requestingProviderType,dep,eager){if(void 0===eager&&(eager=!1),dep.isAttribute){var attrValue=this._attrs[dep.token.value];return{isValue:!0,value:null==attrValue?null:attrValue}}if(null!=dep.token){if(requestingProviderType===ProviderAstType.Directive||requestingProviderType===ProviderAstType.Component){if(tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.Renderer)||tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.ElementRef)||tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.ChangeDetectorRef)||tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.TemplateRef))return dep;tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.ViewContainerRef)&&(this.transformedHasViewContainer=!0)}if(tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.Injector))return dep;if(null!=this._getOrCreateLocalProvider(requestingProviderType,dep.token,eager))return dep}return null},ProviderElementContext.prototype._getDependency=function(requestingProviderType,dep,eager){void 0===eager&&(eager=!1);var currElement=this,currEager=eager,result=null;if(dep.isSkipSelf||(result=this._getLocalDependency(requestingProviderType,dep,eager)),dep.isSelf)!result&&dep.isOptional&&(result={isValue:!0,value:null});else{for(;!result&&currElement._parent;){var prevElement=currElement;currElement=currElement._parent,prevElement._isViewRoot&&(currEager=!1),result=currElement._getLocalDependency(ProviderAstType.PublicService,dep,currEager)}result||(result=!dep.isHost||this.viewContext.component.isHost||this.viewContext.component.type.reference===tokenReference(dep.token)||null!=this.viewContext.viewProviders.get(tokenReference(dep.token))?dep:dep.isOptional?result={isValue:!0,value:null}:null)}return result||this.viewContext.errors.push(new ProviderError("No provider for "+tokenName(dep.token),this._sourceSpan)),result},ProviderElementContext}(),NgModuleProviderAnalyzer=function(){function NgModuleProviderAnalyzer(reflector,ngModule,extraProviders,sourceSpan){var _this=this;this.reflector=reflector,this._transformedProviders=new Map,this._seenProviders=new Map,this._errors=[],this._allProviders=new Map,ngModule.transitiveModule.modules.forEach(function(ngModuleType){_resolveProviders([{token:{identifier:ngModuleType},useClass:ngModuleType}],ProviderAstType.PublicService,!0,sourceSpan,_this._errors,_this._allProviders)}),_resolveProviders(ngModule.transitiveModule.providers.map(function(entry){return entry.provider}).concat(extraProviders),ProviderAstType.PublicService,!1,sourceSpan,this._errors,this._allProviders)}return NgModuleProviderAnalyzer.prototype.parse=function(){var _this=this;if(Array.from(this._allProviders.values()).forEach(function(provider){_this._getOrCreateLocalProvider(provider.token,provider.eager)}),this._errors.length>0){var errorString=this._errors.join("\n");throw new Error("Provider parse errors:\n"+errorString)}var lazyProviders=[],eagerProviders=[];return this._transformedProviders.forEach(function(provider){provider.eager?eagerProviders.push(provider):lazyProviders.push(provider)}),lazyProviders.concat(eagerProviders)},NgModuleProviderAnalyzer.prototype._getOrCreateLocalProvider=function(token,eager){var _this=this,resolvedProvider=this._allProviders.get(tokenReference(token));if(!resolvedProvider)return null;var transformedProviderAst=this._transformedProviders.get(tokenReference(token));if(transformedProviderAst)return transformedProviderAst;if(null!=this._seenProviders.get(tokenReference(token)))return this._errors.push(new ProviderError("Cannot instantiate cyclic dependency! "+tokenName(token),resolvedProvider.sourceSpan)),null;this._seenProviders.set(tokenReference(token),!0);var transformedProviders=resolvedProvider.providers.map(function(provider){var transformedUseValue=provider.useValue,transformedUseExisting=provider.useExisting,transformedDeps=void 0;if(null!=provider.useExisting){var existingDiDep=_this._getDependency({token:provider.useExisting},eager,resolvedProvider.sourceSpan);null!=existingDiDep.token?transformedUseExisting=existingDiDep.token:(transformedUseExisting=null,transformedUseValue=existingDiDep.value)}else if(provider.useFactory){var deps=provider.deps||provider.useFactory.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(dep,eager,resolvedProvider.sourceSpan)})}else if(provider.useClass){var deps=provider.deps||provider.useClass.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(dep,eager,resolvedProvider.sourceSpan)})}return _transformProvider(provider,{useExisting:transformedUseExisting,useValue:transformedUseValue,deps:transformedDeps})});return transformedProviderAst=_transformProviderAst(resolvedProvider,{eager:eager,providers:transformedProviders}),this._transformedProviders.set(tokenReference(token),transformedProviderAst),transformedProviderAst},NgModuleProviderAnalyzer.prototype._getDependency=function(dep,eager,requestorSourceSpan){void 0===eager&&(eager=!1);var foundLocal=!1;dep.isSkipSelf||null==dep.token||(tokenReference(dep.token)===this.reflector.resolveExternalReference(Identifiers.Injector)||tokenReference(dep.token)===this.reflector.resolveExternalReference(Identifiers.ComponentFactoryResolver)?foundLocal=!0:null!=this._getOrCreateLocalProvider(dep.token,eager)&&(foundLocal=!0));var result=dep;return dep.isSelf&&!foundLocal&&(dep.isOptional?result={isValue:!0,value:null}:this._errors.push(new ProviderError("No provider for "+tokenName(dep.token),requestorSourceSpan))),result},NgModuleProviderAnalyzer}(),_ValueOutputAstTransformer=function(){function _ValueOutputAstTransformer(ctx){this.ctx=ctx}return _ValueOutputAstTransformer.prototype.visitArray=function(arr,type){var _this=this;return literalArr(arr.map(function(value){return visitValue(value,_this,null)}),type)},_ValueOutputAstTransformer.prototype.visitStringMap=function(map,type){var _this=this,entries=[],quotedSet=new Set(map&&map.$quoted$);return Object.keys(map).forEach(function(key){entries.push(new LiteralMapEntry(key,visitValue(map[key],_this,null),quotedSet.has(key)))}),new LiteralMapExpr(entries,type)},_ValueOutputAstTransformer.prototype.visitPrimitive=function(value,type){return literal(value,type)},_ValueOutputAstTransformer.prototype.visitOther=function(value,type){return value instanceof Expression?value:this.ctx.importExpr(value)},_ValueOutputAstTransformer}(),NgModuleCompileResult=function(){function NgModuleCompileResult(ngModuleFactoryVar){this.ngModuleFactoryVar=ngModuleFactoryVar}return NgModuleCompileResult}(),LOG_VAR=variable("_l"),NgModuleCompiler=function(){function NgModuleCompiler(reflector){this.reflector=reflector}return NgModuleCompiler.prototype.compile=function(ctx,ngModuleMeta,extraProviders){var sourceSpan=typeSourceSpan("NgModule",ngModuleMeta.type),entryComponentFactories=ngModuleMeta.transitiveModule.entryComponents,bootstrapComponents=ngModuleMeta.bootstrapComponents,providerParser=new NgModuleProviderAnalyzer(this.reflector,ngModuleMeta,extraProviders,sourceSpan),providerDefs=[componentFactoryResolverProviderDef(this.reflector,ctx,0,entryComponentFactories)].concat(providerParser.parse().map(function(provider){return providerDef(ctx,provider)})).map(function(_a){var providerExpr=_a.providerExpr,depsExpr=_a.depsExpr,flags=_a.flags,tokenExpr=_a.tokenExpr;return importExpr(Identifiers.moduleProviderDef).callFn([literal(flags),tokenExpr,providerExpr,depsExpr])}),ngModuleDef=importExpr(Identifiers.moduleDef).callFn([literalArr(providerDefs)]),ngModuleDefFactory=fn([new FnParam(LOG_VAR.name)],[new ReturnStatement(ngModuleDef)],INFERRED_TYPE),ngModuleFactoryVar=identifierName(ngModuleMeta.type)+"NgFactory";if(this._createNgModuleFactory(ctx,ngModuleMeta.type.reference,importExpr(Identifiers.createModuleFactory).callFn([ctx.importExpr(ngModuleMeta.type.reference),literalArr(bootstrapComponents.map(function(id){return ctx.importExpr(id.reference)})),ngModuleDefFactory])),ngModuleMeta.id){var registerFactoryStmt=importExpr(Identifiers.RegisterModuleFactoryFn).callFn([literal(ngModuleMeta.id),variable(ngModuleFactoryVar)]).toStmt();ctx.statements.push(registerFactoryStmt)}return new NgModuleCompileResult(ngModuleFactoryVar)},NgModuleCompiler.prototype.createStub=function(ctx,ngModuleReference){this._createNgModuleFactory(ctx,ngModuleReference,NULL_EXPR)},NgModuleCompiler.prototype._createNgModuleFactory=function(ctx,reference,value){var ngModuleFactoryVar=identifierName({reference:reference})+"NgFactory",ngModuleFactoryStmt=variable(ngModuleFactoryVar).set(value).toDeclStmt(importType(Identifiers.NgModuleFactory,[expressionType(ctx.importExpr(reference))],[TypeModifier.Const]),[StmtModifier.Final,StmtModifier.Exported]);ctx.statements.push(ngModuleFactoryStmt)},NgModuleCompiler}(),NgModuleResolver=function(){function NgModuleResolver(_reflector){this._reflector=_reflector}return NgModuleResolver.prototype.isNgModule=function(type){return this._reflector.annotations(type).some(createNgModule.isTypeOf)},NgModuleResolver.prototype.resolve=function(type,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var ngModuleMeta=findLast(this._reflector.annotations(type),createNgModule.isTypeOf);if(ngModuleMeta)return ngModuleMeta;if(throwIfNotFound)throw new Error("No NgModule metadata found for '"+stringify(type)+"'.");return null},NgModuleResolver}(),SourceMapGenerator=function(){function SourceMapGenerator(file){void 0===file&&(file=null),this.file=file,this.sourcesContent=new Map,this.lines=[],this.lastCol0=0,this.hasMappings=!1}return SourceMapGenerator.prototype.addSource=function(url,content){return void 0===content&&(content=null),this.sourcesContent.has(url)||this.sourcesContent.set(url,content),this},SourceMapGenerator.prototype.addLine=function(){return this.lines.push([]),this.lastCol0=0,this},SourceMapGenerator.prototype.addMapping=function(col0,sourceUrl,sourceLine0,sourceCol0){if(!this.currentLine)throw new Error("A line must be added before mappings can be added");if(null!=sourceUrl&&!this.sourcesContent.has(sourceUrl))throw new Error('Unknown source file "'+sourceUrl+'"');if(null==col0)throw new Error("The column in the generated code must be provided");if(col0<this.lastCol0)throw new Error("Mapping should be added in output order")
;if(sourceUrl&&(null==sourceLine0||null==sourceCol0))throw new Error("The source location must be provided when a source url is provided");return this.hasMappings=!0,this.lastCol0=col0,this.currentLine.push({col0:col0,sourceUrl:sourceUrl,sourceLine0:sourceLine0,sourceCol0:sourceCol0}),this},Object.defineProperty(SourceMapGenerator.prototype,"currentLine",{get:function(){return this.lines.slice(-1)[0]},enumerable:!0,configurable:!0}),SourceMapGenerator.prototype.toJSON=function(){var _this=this;if(!this.hasMappings)return null;var sourcesIndex=new Map,sources=[],sourcesContent=[];Array.from(this.sourcesContent.keys()).forEach(function(url,i){sourcesIndex.set(url,i),sources.push(url),sourcesContent.push(_this.sourcesContent.get(url)||null)});var mappings="",lastCol0=0,lastSourceIndex=0,lastSourceLine0=0,lastSourceCol0=0;return this.lines.forEach(function(segments){lastCol0=0,mappings+=segments.map(function(segment){var segAsStr=toBase64VLQ(segment.col0-lastCol0);return lastCol0=segment.col0,null!=segment.sourceUrl&&(segAsStr+=toBase64VLQ(sourcesIndex.get(segment.sourceUrl)-lastSourceIndex),lastSourceIndex=sourcesIndex.get(segment.sourceUrl),segAsStr+=toBase64VLQ(segment.sourceLine0-lastSourceLine0),lastSourceLine0=segment.sourceLine0,segAsStr+=toBase64VLQ(segment.sourceCol0-lastSourceCol0),lastSourceCol0=segment.sourceCol0),segAsStr}).join(","),mappings+=";"}),mappings=mappings.slice(0,-1),{file:this.file||"",version:3,sourceRoot:"",sources:sources,sourcesContent:sourcesContent,mappings:mappings}},SourceMapGenerator.prototype.toJsComment=function(){return this.hasMappings?"//# sourceMappingURL=data:application/json;base64,"+toBase64String(JSON.stringify(this,null,0)):""},SourceMapGenerator}(),B64_DIGITS="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",_SINGLE_QUOTE_ESCAPE_STRING_RE=/'|\\|\n|\r|\$/g,_LEGAL_IDENTIFIER_RE=/^[$A-Z_][0-9A-Z_$]*$/i,_INDENT_WITH="  ",CATCH_ERROR_VAR$1=variable("error",null,null),CATCH_STACK_VAR$1=variable("stack",null,null),_EmittedLine=function(){function _EmittedLine(indent){this.indent=indent,this.partsLength=0,this.parts=[],this.srcSpans=[]}return _EmittedLine}(),EmitterVisitorContext=function(){function EmitterVisitorContext(_indent){this._indent=_indent,this._classes=[],this._preambleLineCount=0,this._lines=[new _EmittedLine(_indent)]}return EmitterVisitorContext.createRoot=function(){return new EmitterVisitorContext(0)},Object.defineProperty(EmitterVisitorContext.prototype,"_currentLine",{get:function(){return this._lines[this._lines.length-1]},enumerable:!0,configurable:!0}),EmitterVisitorContext.prototype.println=function(from,lastPart){void 0===lastPart&&(lastPart=""),this.print(from||null,lastPart,!0)},EmitterVisitorContext.prototype.lineIsEmpty=function(){return 0===this._currentLine.parts.length},EmitterVisitorContext.prototype.lineLength=function(){return this._currentLine.indent*_INDENT_WITH.length+this._currentLine.partsLength},EmitterVisitorContext.prototype.print=function(from,part,newLine){void 0===newLine&&(newLine=!1),part.length>0&&(this._currentLine.parts.push(part),this._currentLine.partsLength+=part.length,this._currentLine.srcSpans.push(from&&from.sourceSpan||null)),newLine&&this._lines.push(new _EmittedLine(this._indent))},EmitterVisitorContext.prototype.removeEmptyLastLine=function(){this.lineIsEmpty()&&this._lines.pop()},EmitterVisitorContext.prototype.incIndent=function(){this._indent++,this.lineIsEmpty()&&(this._currentLine.indent=this._indent)},EmitterVisitorContext.prototype.decIndent=function(){this._indent--,this.lineIsEmpty()&&(this._currentLine.indent=this._indent)},EmitterVisitorContext.prototype.pushClass=function(clazz){this._classes.push(clazz)},EmitterVisitorContext.prototype.popClass=function(){return this._classes.pop()},Object.defineProperty(EmitterVisitorContext.prototype,"currentClass",{get:function(){return this._classes.length>0?this._classes[this._classes.length-1]:null},enumerable:!0,configurable:!0}),EmitterVisitorContext.prototype.toSource=function(){return this.sourceLines.map(function(l){return l.parts.length>0?_createIndent(l.indent)+l.parts.join(""):""}).join("\n")},EmitterVisitorContext.prototype.toSourceMapGenerator=function(genFilePath,startsAtLine){void 0===startsAtLine&&(startsAtLine=0);for(var map=new SourceMapGenerator(genFilePath),firstOffsetMapped=!1,mapFirstOffsetIfNeeded=function(){firstOffsetMapped||(map.addSource(genFilePath," ").addMapping(0,genFilePath,0,0),firstOffsetMapped=!0)},i=0;i<startsAtLine;i++)map.addLine(),mapFirstOffsetIfNeeded();return this.sourceLines.forEach(function(line,lineIdx){map.addLine();for(var spans=line.srcSpans,parts=line.parts,col0=line.indent*_INDENT_WITH.length,spanIdx=0;spanIdx<spans.length&&!spans[spanIdx];)col0+=parts[spanIdx].length,spanIdx++;for(spanIdx<spans.length&&0===lineIdx&&0===col0?firstOffsetMapped=!0:mapFirstOffsetIfNeeded();spanIdx<spans.length;){var span=spans[spanIdx],source=span.start.file,sourceLine=span.start.line,sourceCol=span.start.col;for(map.addSource(source.url,source.content).addMapping(col0,source.url,sourceLine,sourceCol),col0+=parts[spanIdx].length,spanIdx++;spanIdx<spans.length&&(span===spans[spanIdx]||!spans[spanIdx]);)col0+=parts[spanIdx].length,spanIdx++}}),map},EmitterVisitorContext.prototype.setPreambleLineCount=function(count){return this._preambleLineCount=count},EmitterVisitorContext.prototype.spanOf=function(line,column){var emittedLine=this._lines[line-this._preambleLineCount];if(emittedLine)for(var columnsLeft=column-_createIndent(emittedLine.indent).length,partIndex=0;partIndex<emittedLine.parts.length;partIndex++){var part=emittedLine.parts[partIndex];if(part.length>columnsLeft)return emittedLine.srcSpans[partIndex];columnsLeft-=part.length}return null},Object.defineProperty(EmitterVisitorContext.prototype,"sourceLines",{get:function(){return this._lines.length&&0===this._lines[this._lines.length-1].parts.length?this._lines.slice(0,-1):this._lines},enumerable:!0,configurable:!0}),EmitterVisitorContext}(),AbstractEmitterVisitor=function(){function AbstractEmitterVisitor(_escapeDollarInStrings){this._escapeDollarInStrings=_escapeDollarInStrings}return AbstractEmitterVisitor.prototype.visitExpressionStmt=function(stmt,ctx){return stmt.expr.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractEmitterVisitor.prototype.visitReturnStmt=function(stmt,ctx){return ctx.print(stmt,"return "),stmt.value.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractEmitterVisitor.prototype.visitIfStmt=function(stmt,ctx){ctx.print(stmt,"if ("),stmt.condition.visitExpression(this,ctx),ctx.print(stmt,") {");var hasElseCase=null!=stmt.falseCase&&stmt.falseCase.length>0;return stmt.trueCase.length<=1&&!hasElseCase?(ctx.print(stmt," "),this.visitAllStatements(stmt.trueCase,ctx),ctx.removeEmptyLastLine(),ctx.print(stmt," ")):(ctx.println(),ctx.incIndent(),this.visitAllStatements(stmt.trueCase,ctx),ctx.decIndent(),hasElseCase&&(ctx.println(stmt,"} else {"),ctx.incIndent(),this.visitAllStatements(stmt.falseCase,ctx),ctx.decIndent())),ctx.println(stmt,"}"),null},AbstractEmitterVisitor.prototype.visitThrowStmt=function(stmt,ctx){return ctx.print(stmt,"throw "),stmt.error.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractEmitterVisitor.prototype.visitCommentStmt=function(stmt,ctx){return stmt.comment.split("\n").forEach(function(line){ctx.println(stmt,"// "+line)}),null},AbstractEmitterVisitor.prototype.visitWriteVarExpr=function(expr,ctx){var lineWasEmpty=ctx.lineIsEmpty();return lineWasEmpty||ctx.print(expr,"("),ctx.print(expr,expr.name+" = "),expr.value.visitExpression(this,ctx),lineWasEmpty||ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitWriteKeyExpr=function(expr,ctx){var lineWasEmpty=ctx.lineIsEmpty();return lineWasEmpty||ctx.print(expr,"("),expr.receiver.visitExpression(this,ctx),ctx.print(expr,"["),expr.index.visitExpression(this,ctx),ctx.print(expr,"] = "),expr.value.visitExpression(this,ctx),lineWasEmpty||ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitWritePropExpr=function(expr,ctx){var lineWasEmpty=ctx.lineIsEmpty();return lineWasEmpty||ctx.print(expr,"("),expr.receiver.visitExpression(this,ctx),ctx.print(expr,"."+expr.name+" = "),expr.value.visitExpression(this,ctx),lineWasEmpty||ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitInvokeMethodExpr=function(expr,ctx){expr.receiver.visitExpression(this,ctx);var name=expr.name;return null!=expr.builtin&&null==(name=this.getBuiltinMethodName(expr.builtin))?null:(ctx.print(expr,"."+name+"("),this.visitAllExpressions(expr.args,ctx,","),ctx.print(expr,")"),null)},AbstractEmitterVisitor.prototype.visitInvokeFunctionExpr=function(expr,ctx){return expr.fn.visitExpression(this,ctx),ctx.print(expr,"("),this.visitAllExpressions(expr.args,ctx,","),ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitReadVarExpr=function(ast,ctx){var varName=ast.name;if(null!=ast.builtin)switch(ast.builtin){case BuiltinVar.Super:varName="super";break;case BuiltinVar.This:varName="this";break;case BuiltinVar.CatchError:varName=CATCH_ERROR_VAR$1.name;break;case BuiltinVar.CatchStack:varName=CATCH_STACK_VAR$1.name;break;default:throw new Error("Unknown builtin variable "+ast.builtin)}return ctx.print(ast,varName),null},AbstractEmitterVisitor.prototype.visitInstantiateExpr=function(ast,ctx){return ctx.print(ast,"new "),ast.classExpr.visitExpression(this,ctx),ctx.print(ast,"("),this.visitAllExpressions(ast.args,ctx,","),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitLiteralExpr=function(ast,ctx){var value=ast.value;return"string"==typeof value?ctx.print(ast,escapeIdentifier(value,this._escapeDollarInStrings)):ctx.print(ast,""+value),null},AbstractEmitterVisitor.prototype.visitConditionalExpr=function(ast,ctx){return ctx.print(ast,"("),ast.condition.visitExpression(this,ctx),ctx.print(ast,"? "),ast.trueCase.visitExpression(this,ctx),ctx.print(ast,": "),ast.falseCase.visitExpression(this,ctx),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitNotExpr=function(ast,ctx){return ctx.print(ast,"!"),ast.condition.visitExpression(this,ctx),null},AbstractEmitterVisitor.prototype.visitAssertNotNullExpr=function(ast,ctx){return ast.condition.visitExpression(this,ctx),null},AbstractEmitterVisitor.prototype.visitBinaryOperatorExpr=function(ast,ctx){var opStr;switch(ast.operator){case BinaryOperator.Equals:opStr="==";break;case BinaryOperator.Identical:opStr="===";break;case BinaryOperator.NotEquals:opStr="!=";break;case BinaryOperator.NotIdentical:opStr="!==";break;case BinaryOperator.And:opStr="&&";break;case BinaryOperator.Or:opStr="||";break;case BinaryOperator.Plus:opStr="+";break;case BinaryOperator.Minus:opStr="-";break;case BinaryOperator.Divide:opStr="/";break;case BinaryOperator.Multiply:opStr="*";break;case BinaryOperator.Modulo:opStr="%";break;case BinaryOperator.Lower:opStr="<";break;case BinaryOperator.LowerEquals:opStr="<=";break;case BinaryOperator.Bigger:opStr=">";break;case BinaryOperator.BiggerEquals:opStr=">=";break;default:throw new Error("Unknown operator "+ast.operator)}return ctx.print(ast,"("),ast.lhs.visitExpression(this,ctx),ctx.print(ast," "+opStr+" "),ast.rhs.visitExpression(this,ctx),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitReadPropExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx),ctx.print(ast,"."),ctx.print(ast,ast.name),null},AbstractEmitterVisitor.prototype.visitReadKeyExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx),ctx.print(ast,"["),ast.index.visitExpression(this,ctx),ctx.print(ast,"]"),null},AbstractEmitterVisitor.prototype.visitLiteralArrayExpr=function(ast,ctx){return ctx.print(ast,"["),this.visitAllExpressions(ast.entries,ctx,","),ctx.print(ast,"]"),null},AbstractEmitterVisitor.prototype.visitLiteralMapExpr=function(ast,ctx){var _this=this;return ctx.print(ast,"{"),this.visitAllObjects(function(entry){ctx.print(ast,escapeIdentifier(entry.key,_this._escapeDollarInStrings,entry.quoted)+":"),entry.value.visitExpression(_this,ctx)},ast.entries,ctx,","),ctx.print(ast,"}"),null},AbstractEmitterVisitor.prototype.visitCommaExpr=function(ast,ctx){return ctx.print(ast,"("),this.visitAllExpressions(ast.parts,ctx,","),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitAllExpressions=function(expressions,ctx,separator){var _this=this;this.visitAllObjects(function(expr){return expr.visitExpression(_this,ctx)},expressions,ctx,separator)},AbstractEmitterVisitor.prototype.visitAllObjects=function(handler,expressions,ctx,separator){for(var incrementedIndent=!1,i=0;i<expressions.length;i++)i>0&&(ctx.lineLength()>80?(ctx.print(null,separator,!0),incrementedIndent||(ctx.incIndent(),ctx.incIndent(),incrementedIndent=!0)):ctx.print(null,separator,!1)),handler(expressions[i]);incrementedIndent&&(ctx.decIndent(),ctx.decIndent())},AbstractEmitterVisitor.prototype.visitAllStatements=function(statements,ctx){var _this=this;statements.forEach(function(stmt){return stmt.visitStatement(_this,ctx)})},AbstractEmitterVisitor}(),TypeScriptEmitter=function(){function TypeScriptEmitter(){}return TypeScriptEmitter.prototype.emitStatementsAndContext=function(genFilePath,stmts,preamble,emitSourceMaps,referenceFilter){void 0===preamble&&(preamble=""),void 0===emitSourceMaps&&(emitSourceMaps=!0);var converter=new _TsEmitterVisitor(referenceFilter),ctx=EmitterVisitorContext.createRoot();converter.visitAllStatements(stmts,ctx);var preambleLines=preamble?preamble.split("\n"):[];converter.reexports.forEach(function(reexports,exportedModuleName){var reexportsCode=reexports.map(function(reexport){return reexport.name+" as "+reexport.as}).join(",");preambleLines.push("export {"+reexportsCode+"} from '"+exportedModuleName+"';")}),converter.importsWithPrefixes.forEach(function(prefix,importedModuleName){preambleLines.push("import * as "+prefix+" from '"+importedModuleName+"';")});var sm=emitSourceMaps?ctx.toSourceMapGenerator(genFilePath,preambleLines.length).toJsComment():"",lines=preambleLines.concat([ctx.toSource(),sm]);return sm&&lines.push(""),ctx.setPreambleLineCount(preambleLines.length),{sourceText:lines.join("\n"),context:ctx}},TypeScriptEmitter.prototype.emitStatements=function(genFilePath,stmts,preamble){return void 0===preamble&&(preamble=""),this.emitStatementsAndContext(genFilePath,stmts,preamble).sourceText},TypeScriptEmitter}(),_TsEmitterVisitor=function(_super){function _TsEmitterVisitor(referenceFilter){var _this=_super.call(this,!1)||this;return _this.referenceFilter=referenceFilter,_this.typeExpression=0,_this.importsWithPrefixes=new Map,_this.reexports=new Map,_this}return __extends(_TsEmitterVisitor,_super),_TsEmitterVisitor.prototype.visitType=function(t,ctx,defaultType){void 0===defaultType&&(defaultType="any"),t?(this.typeExpression++,t.visitType(this,ctx),this.typeExpression--):ctx.print(null,defaultType)},_TsEmitterVisitor.prototype.visitLiteralExpr=function(ast,ctx){var value=ast.value;return null==value&&ast.type!=INFERRED_TYPE?(ctx.print(ast,"("+value+" as any)"),null):_super.prototype.visitLiteralExpr.call(this,ast,ctx)},_TsEmitterVisitor.prototype.visitLiteralArrayExpr=function(ast,ctx){0===ast.entries.length&&ctx.print(ast,"(");var result=_super.prototype.visitLiteralArrayExpr.call(this,ast,ctx);return 0===ast.entries.length&&ctx.print(ast," as any[])"),result},_TsEmitterVisitor.prototype.visitExternalExpr=function(ast,ctx){return this._visitIdentifier(ast.value,ast.typeParams,ctx),null},_TsEmitterVisitor.prototype.visitAssertNotNullExpr=function(ast,ctx){var result=_super.prototype.visitAssertNotNullExpr.call(this,ast,ctx);return ctx.print(ast,"!"),result},_TsEmitterVisitor.prototype.visitDeclareVarStmt=function(stmt,ctx){if(stmt.hasModifier(StmtModifier.Exported)&&stmt.value instanceof ExternalExpr&&!stmt.type){var _a=stmt.value.value,name_1=_a.name,moduleName=_a.moduleName;if(moduleName){var reexports=this.reexports.get(moduleName);return reexports||(reexports=[],this.reexports.set(moduleName,reexports)),reexports.push({name:name_1,as:stmt.name}),null}}return stmt.hasModifier(StmtModifier.Exported)&&ctx.print(stmt,"export "),stmt.hasModifier(StmtModifier.Final)?ctx.print(stmt,"const"):ctx.print(stmt,"var"),ctx.print(stmt," "+stmt.name),this._printColonType(stmt.type,ctx),ctx.print(stmt," = "),stmt.value.visitExpression(this,ctx),ctx.println(stmt,";"),null},_TsEmitterVisitor.prototype.visitCastExpr=function(ast,ctx){return ctx.print(ast,"(<"),ast.type.visitType(this,ctx),ctx.print(ast,">"),ast.value.visitExpression(this,ctx),ctx.print(ast,")"),null},_TsEmitterVisitor.prototype.visitInstantiateExpr=function(ast,ctx){return ctx.print(ast,"new "),this.typeExpression++,ast.classExpr.visitExpression(this,ctx),this.typeExpression--,ctx.print(ast,"("),this.visitAllExpressions(ast.args,ctx,","),ctx.print(ast,")"),null},_TsEmitterVisitor.prototype.visitDeclareClassStmt=function(stmt,ctx){var _this=this;return ctx.pushClass(stmt),stmt.hasModifier(StmtModifier.Exported)&&ctx.print(stmt,"export "),ctx.print(stmt,"class "+stmt.name),null!=stmt.parent&&(ctx.print(stmt," extends "),this.typeExpression++,stmt.parent.visitExpression(this,ctx),this.typeExpression--),ctx.println(stmt," {"),ctx.incIndent(),stmt.fields.forEach(function(field){return _this._visitClassField(field,ctx)}),null!=stmt.constructorMethod&&this._visitClassConstructor(stmt,ctx),stmt.getters.forEach(function(getter){return _this._visitClassGetter(getter,ctx)}),stmt.methods.forEach(function(method){return _this._visitClassMethod(method,ctx)}),ctx.decIndent(),ctx.println(stmt,"}"),ctx.popClass(),null},_TsEmitterVisitor.prototype._visitClassField=function(field,ctx){field.hasModifier(StmtModifier.Private)&&ctx.print(null,"/*private*/ "),ctx.print(null,field.name),this._printColonType(field.type,ctx),ctx.println(null,";")},_TsEmitterVisitor.prototype._visitClassGetter=function(getter,ctx){getter.hasModifier(StmtModifier.Private)&&ctx.print(null,"private "),ctx.print(null,"get "+getter.name+"()"),this._printColonType(getter.type,ctx),ctx.println(null," {"),ctx.incIndent(),this.visitAllStatements(getter.body,ctx),ctx.decIndent(),ctx.println(null,"}")},_TsEmitterVisitor.prototype._visitClassConstructor=function(stmt,ctx){ctx.print(stmt,"constructor("),this._visitParams(stmt.constructorMethod.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),this.visitAllStatements(stmt.constructorMethod.body,ctx),ctx.decIndent(),ctx.println(stmt,"}")},_TsEmitterVisitor.prototype._visitClassMethod=function(method,ctx){method.hasModifier(StmtModifier.Private)&&ctx.print(null,"private "),ctx.print(null,method.name+"("),this._visitParams(method.params,ctx),ctx.print(null,")"),this._printColonType(method.type,ctx,"void"),ctx.println(null," {"),ctx.incIndent(),this.visitAllStatements(method.body,ctx),ctx.decIndent(),ctx.println(null,"}")},_TsEmitterVisitor.prototype.visitFunctionExpr=function(ast,ctx){return ctx.print(ast,"("),this._visitParams(ast.params,ctx),ctx.print(ast,")"),this._printColonType(ast.type,ctx,"void"),ctx.println(ast," => {"),ctx.incIndent(),this.visitAllStatements(ast.statements,ctx),ctx.decIndent(),ctx.print(ast,"}"),null},_TsEmitterVisitor.prototype.visitDeclareFunctionStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&ctx.print(stmt,"export "),ctx.print(stmt,"function "+stmt.name+"("),this._visitParams(stmt.params,ctx),ctx.print(stmt,")"),this._printColonType(stmt.type,ctx,"void"),ctx.println(stmt," {"),ctx.incIndent(),this.visitAllStatements(stmt.statements,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},_TsEmitterVisitor.prototype.visitTryCatchStmt=function(stmt,ctx){ctx.println(stmt,"try {"),ctx.incIndent(),this.visitAllStatements(stmt.bodyStmts,ctx),ctx.decIndent(),ctx.println(stmt,"} catch ("+CATCH_ERROR_VAR$1.name+") {"),ctx.incIndent();var catchStmts=[CATCH_STACK_VAR$1.set(CATCH_ERROR_VAR$1.prop("stack",null)).toDeclStmt(null,[StmtModifier.Final])].concat(stmt.catchStmts);return this.visitAllStatements(catchStmts,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},_TsEmitterVisitor.prototype.visitBuiltintType=function(type,ctx){var typeStr;switch(type.name){case BuiltinTypeName.Bool:typeStr="boolean";break;case BuiltinTypeName.Dynamic:typeStr="any";break;case BuiltinTypeName.Function:typeStr="Function";break;case BuiltinTypeName.Number:case BuiltinTypeName.Int:typeStr="number";break;case BuiltinTypeName.String:typeStr="string";break;default:throw new Error("Unsupported builtin type "+type.name)}return ctx.print(null,typeStr),null},_TsEmitterVisitor.prototype.visitExpressionType=function(ast,ctx){return ast.value.visitExpression(this,ctx),null},_TsEmitterVisitor.prototype.visitArrayType=function(type,ctx){return this.visitType(type.of,ctx),ctx.print(null,"[]"),null},_TsEmitterVisitor.prototype.visitMapType=function(type,ctx){return ctx.print(null,"{[key: string]:"),this.visitType(type.valueType,ctx),ctx.print(null,"}"),null},_TsEmitterVisitor.prototype.getBuiltinMethodName=function(method){var name;switch(method){case BuiltinMethod.ConcatArray:name="concat";break;case BuiltinMethod.SubscribeObservable:name="subscribe";break;case BuiltinMethod.Bind:name="bind";break;default:throw new Error("Unknown builtin method: "+method)}return name},_TsEmitterVisitor.prototype._visitParams=function(params,ctx){var _this=this;this.visitAllObjects(function(param){ctx.print(null,param.name),_this._printColonType(param.type,ctx)},params,ctx,",")},_TsEmitterVisitor.prototype._visitIdentifier=function(value,typeParams,ctx){var _this=this,name=value.name,moduleName=value.moduleName;if(this.referenceFilter&&this.referenceFilter(value))return void ctx.print(null,"(null as any)");if(moduleName){var prefix=this.importsWithPrefixes.get(moduleName);null==prefix&&(prefix="i"+this.importsWithPrefixes.size,this.importsWithPrefixes.set(moduleName,prefix)),ctx.print(null,prefix+".")}if(ctx.print(null,name),this.typeExpression>0){(typeParams||[]).length>0&&(ctx.print(null,"<"),this.visitAllObjects(function(type){return type.visitType(_this,ctx)},typeParams,ctx,","),ctx.print(null,">"))}},_TsEmitterVisitor.prototype._printColonType=function(type,ctx,defaultType){type!==INFERRED_TYPE&&(ctx.print(null,":"),this.visitType(type,ctx,defaultType))},_TsEmitterVisitor}(AbstractEmitterVisitor),PipeResolver=function(){function PipeResolver(_reflector){this._reflector=_reflector}return PipeResolver.prototype.isPipe=function(type){var typeMetadata=this._reflector.annotations(resolveForwardRef(type));return typeMetadata&&typeMetadata.some(createPipe.isTypeOf)},PipeResolver.prototype.resolve=function(type,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var metas=this._reflector.annotations(resolveForwardRef(type));if(metas){var annotation=findLast(metas,createPipe.isTypeOf);if(annotation)return annotation}if(throwIfNotFound)throw new Error("No Pipe decorator found on "+stringify(type));return null},PipeResolver}(),SECURITY_SCHEMA={};registerContext(SecurityContext.HTML,["iframe|srcdoc","*|innerHTML","*|outerHTML"]),registerContext(SecurityContext.STYLE,["*|style"]),registerContext(SecurityContext.URL,["*|formAction","area|href","area|ping","audio|src","a|href","a|ping","blockquote|cite","body|background","del|cite","form|action","img|src","img|srcset","input|src","ins|cite","q|cite","source|src","source|srcset","track|src","video|poster","video|src"]),registerContext(SecurityContext.RESOURCE_URL,["applet|code","applet|codebase","base|href","embed|src","frame|src","head|profile","html|manifest","iframe|src","link|href","media|src","object|codebase","object|data","script|src"]);/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var ElementSchemaRegistry=function(){function ElementSchemaRegistry(){}return ElementSchemaRegistry}(),BOOLEAN$1="boolean",NUMBER$1="number",STRING$1="string",OBJECT$1="object",SCHEMA$1=["[Element]|textContent,%classList,className,id,innerHTML,*beforecopy,*beforecut,*beforepaste,*copy,*cut,*paste,*search,*selectstart,*webkitfullscreenchange,*webkitfullscreenerror,*wheel,outerHTML,#scrollLeft,#scrollTop,slot,*message,*mozfullscreenchange,*mozfullscreenerror,*mozpointerlockchange,*mozpointerlockerror,*webglcontextcreationerror,*webglcontextlost,*webglcontextrestored","[HTMLElement]^[Element]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate","abbr,address,article,aside,b,bdi,bdo,cite,code,dd,dfn,dt,em,figcaption,figure,footer,header,i,kbd,main,mark,nav,noscript,rb,rp,rt,rtc,ruby,s,samp,section,small,strong,sub,sup,u,var,wbr^[HTMLElement]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate","media^[HTMLElement]|!autoplay,!controls,%controlsList,%crossOrigin,#currentTime,!defaultMuted,#defaultPlaybackRate,!disableRemotePlayback,!loop,!muted,*encrypted,*waitingforkey,#playbackRate,preload,src,%srcObject,#volume",":svg:^[HTMLElement]|*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,%style,#tabIndex",":svg:graphics^:svg:|",":svg:animation^:svg:|*begin,*end,*repeat",":svg:geometry^:svg:|",":svg:componentTransferFunction^:svg:|",":svg:gradient^:svg:|",":svg:textContent^:svg:graphics|",":svg:textPositioning^:svg:textContent|","a^[HTMLElement]|charset,coords,download,hash,host,hostname,href,hreflang,name,password,pathname,ping,port,protocol,referrerPolicy,rel,rev,search,shape,target,text,type,username","area^[HTMLElement]|alt,coords,download,hash,host,hostname,href,!noHref,password,pathname,ping,port,protocol,referrerPolicy,rel,search,shape,target,username","audio^media|","br^[HTMLElement]|clear","base^[HTMLElement]|href,target","body^[HTMLElement]|aLink,background,bgColor,link,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,text,vLink","button^[HTMLElement]|!autofocus,!disabled,formAction,formEnctype,formMethod,!formNoValidate,formTarget,name,type,value","canvas^[HTMLElement]|#height,#width","content^[HTMLElement]|select","dl^[HTMLElement]|!compact","datalist^[HTMLElement]|","details^[HTMLElement]|!open","dialog^[HTMLElement]|!open,returnValue","dir^[HTMLElement]|!compact","div^[HTMLElement]|align","embed^[HTMLElement]|align,height,name,src,type,width","fieldset^[HTMLElement]|!disabled,name","font^[HTMLElement]|color,face,size","form^[HTMLElement]|acceptCharset,action,autocomplete,encoding,enctype,method,name,!noValidate,target","frame^[HTMLElement]|frameBorder,longDesc,marginHeight,marginWidth,name,!noResize,scrolling,src","frameset^[HTMLElement]|cols,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,rows","hr^[HTMLElement]|align,color,!noShade,size,width","head^[HTMLElement]|","h1,h2,h3,h4,h5,h6^[HTMLElement]|align","html^[HTMLElement]|version","iframe^[HTMLElement]|align,!allowFullscreen,frameBorder,height,longDesc,marginHeight,marginWidth,name,referrerPolicy,%sandbox,scrolling,src,srcdoc,width","img^[HTMLElement]|align,alt,border,%crossOrigin,#height,#hspace,!isMap,longDesc,lowsrc,name,referrerPolicy,sizes,src,srcset,useMap,#vspace,#width","input^[HTMLElement]|accept,align,alt,autocapitalize,autocomplete,!autofocus,!checked,!defaultChecked,defaultValue,dirName,!disabled,%files,formAction,formEnctype,formMethod,!formNoValidate,formTarget,#height,!incremental,!indeterminate,max,#maxLength,min,#minLength,!multiple,name,pattern,placeholder,!readOnly,!required,selectionDirection,#selectionEnd,#selectionStart,#size,src,step,type,useMap,value,%valueAsDate,#valueAsNumber,#width","li^[HTMLElement]|type,#value","label^[HTMLElement]|htmlFor","legend^[HTMLElement]|align","link^[HTMLElement]|as,charset,%crossOrigin,!disabled,href,hreflang,integrity,media,referrerPolicy,rel,%relList,rev,%sizes,target,type","map^[HTMLElement]|name","marquee^[HTMLElement]|behavior,bgColor,direction,height,#hspace,#loop,#scrollAmount,#scrollDelay,!trueSpeed,#vspace,width","menu^[HTMLElement]|!compact","meta^[HTMLElement]|content,httpEquiv,name,scheme","meter^[HTMLElement]|#high,#low,#max,#min,#optimum,#value","ins,del^[HTMLElement]|cite,dateTime","ol^[HTMLElement]|!compact,!reversed,#start,type","object^[HTMLElement]|align,archive,border,code,codeBase,codeType,data,!declare,height,#hspace,name,standby,type,useMap,#vspace,width","optgroup^[HTMLElement]|!disabled,label","option^[HTMLElement]|!defaultSelected,!disabled,label,!selected,text,value","output^[HTMLElement]|defaultValue,%htmlFor,name,value","p^[HTMLElement]|align","param^[HTMLElement]|name,type,value,valueType","picture^[HTMLElement]|","pre^[HTMLElement]|#width","progress^[HTMLElement]|#max,#value","q,blockquote,cite^[HTMLElement]|","script^[HTMLElement]|!async,charset,%crossOrigin,!defer,event,htmlFor,integrity,src,text,type","select^[HTMLElement]|!autofocus,!disabled,#length,!multiple,name,!required,#selectedIndex,#size,value","shadow^[HTMLElement]|","slot^[HTMLElement]|name","source^[HTMLElement]|media,sizes,src,srcset,type","span^[HTMLElement]|","style^[HTMLElement]|!disabled,media,type","caption^[HTMLElement]|align","th,td^[HTMLElement]|abbr,align,axis,bgColor,ch,chOff,#colSpan,headers,height,!noWrap,#rowSpan,scope,vAlign,width","col,colgroup^[HTMLElement]|align,ch,chOff,#span,vAlign,width","table^[HTMLElement]|align,bgColor,border,%caption,cellPadding,cellSpacing,frame,rules,summary,%tFoot,%tHead,width","tr^[HTMLElement]|align,bgColor,ch,chOff,vAlign","tfoot,thead,tbody^[HTMLElement]|align,ch,chOff,vAlign","template^[HTMLElement]|","textarea^[HTMLElement]|autocapitalize,!autofocus,#cols,defaultValue,dirName,!disabled,#maxLength,#minLength,name,placeholder,!readOnly,!required,#rows,selectionDirection,#selectionEnd,#selectionStart,value,wrap","title^[HTMLElement]|text","track^[HTMLElement]|!default,kind,label,src,srclang","ul^[HTMLElement]|!compact,type","unknown^[HTMLElement]|","video^media|#height,poster,#width",":svg:a^:svg:graphics|",":svg:animate^:svg:animation|",":svg:animateMotion^:svg:animation|",":svg:animateTransform^:svg:animation|",":svg:circle^:svg:geometry|",":svg:clipPath^:svg:graphics|",":svg:defs^:svg:graphics|",":svg:desc^:svg:|",":svg:discard^:svg:|",":svg:ellipse^:svg:geometry|",":svg:feBlend^:svg:|",":svg:feColorMatrix^:svg:|",":svg:feComponentTransfer^:svg:|",":svg:feComposite^:svg:|",":svg:feConvolveMatrix^:svg:|",":svg:feDiffuseLighting^:svg:|",":svg:feDisplacementMap^:svg:|",":svg:feDistantLight^:svg:|",":svg:feDropShadow^:svg:|",":svg:feFlood^:svg:|",":svg:feFuncA^:svg:componentTransferFunction|",":svg:feFuncB^:svg:componentTransferFunction|",":svg:feFuncG^:svg:componentTransferFunction|",":svg:feFuncR^:svg:componentTransferFunction|",":svg:feGaussianBlur^:svg:|",":svg:feImage^:svg:|",":svg:feMerge^:svg:|",":svg:feMergeNode^:svg:|",":svg:feMorphology^:svg:|",":svg:feOffset^:svg:|",":svg:fePointLight^:svg:|",":svg:feSpecularLighting^:svg:|",":svg:feSpotLight^:svg:|",":svg:feTile^:svg:|",":svg:feTurbulence^:svg:|",":svg:filter^:svg:|",":svg:foreignObject^:svg:graphics|",":svg:g^:svg:graphics|",":svg:image^:svg:graphics|",":svg:line^:svg:geometry|",":svg:linearGradient^:svg:gradient|",":svg:mpath^:svg:|",":svg:marker^:svg:|",":svg:mask^:svg:|",":svg:metadata^:svg:|",":svg:path^:svg:geometry|",":svg:pattern^:svg:|",":svg:polygon^:svg:geometry|",":svg:polyline^:svg:geometry|",":svg:radialGradient^:svg:gradient|",":svg:rect^:svg:geometry|",":svg:svg^:svg:graphics|#currentScale,#zoomAndPan",":svg:script^:svg:|type",":svg:set^:svg:animation|",":svg:stop^:svg:|",":svg:style^:svg:|!disabled,media,title,type",":svg:switch^:svg:graphics|",":svg:symbol^:svg:|",":svg:tspan^:svg:textPositioning|",":svg:text^:svg:textPositioning|",":svg:textPath^:svg:textContent|",":svg:title^:svg:|",":svg:use^:svg:graphics|",":svg:view^:svg:|#zoomAndPan","data^[HTMLElement]|value","keygen^[HTMLElement]|!autofocus,challenge,!disabled,form,keytype,name","menuitem^[HTMLElement]|type,label,icon,!disabled,!checked,radiogroup,!default","summary^[HTMLElement]|","time^[HTMLElement]|dateTime",":svg:cursor^:svg:|"],_ATTR_TO_PROP={class:"className",for:"htmlFor",formaction:"formAction",innerHtml:"innerHTML",readonly:"readOnly",tabindex:"tabIndex"},DomElementSchemaRegistry=function(_super){function DomElementSchemaRegistry(){var _this=_super.call(this)||this;return _this._schema={},SCHEMA$1.forEach(function(encodedType){var type={},_a=encodedType.split("|"),strType=_a[0],strProperties=_a[1],properties=strProperties.split(","),_b=strType.split("^"),typeNames=_b[0],superName=_b[1];typeNames.split(",").forEach(function(tag){return _this._schema[tag.toLowerCase()]=type});var superType=superName&&_this._schema[superName.toLowerCase()];superType&&Object.keys(superType).forEach(function(prop){type[prop]=superType[prop]}),properties.forEach(function(property){if(property.length>0)switch(property[0]){case"*":break;case"!":type[property.substring(1)]=BOOLEAN$1;break;case"#":type[property.substring(1)]=NUMBER$1;break;case"%":type[property.substring(1)]=OBJECT$1;break;default:type[property]=STRING$1}})}),_this}return __extends(DomElementSchemaRegistry,_super),DomElementSchemaRegistry.prototype.hasProperty=function(tagName,propName,schemaMetas){if(schemaMetas.some(function(schema){return schema.name===NO_ERRORS_SCHEMA.name}))return!0;if(tagName.indexOf("-")>-1){if(isNgContainer(tagName)||isNgContent(tagName))return!1;if(schemaMetas.some(function(schema){return schema.name===CUSTOM_ELEMENTS_SCHEMA.name}))return!0}return!!(this._schema[tagName.toLowerCase()]||this._schema.unknown)[propName]},DomElementSchemaRegistry.prototype.hasElement=function(tagName,schemaMetas){if(schemaMetas.some(function(schema){return schema.name===NO_ERRORS_SCHEMA.name}))return!0;if(tagName.indexOf("-")>-1){if(isNgContainer(tagName)||isNgContent(tagName))return!0;if(schemaMetas.some(function(schema){return schema.name===CUSTOM_ELEMENTS_SCHEMA.name}))return!0}return!!this._schema[tagName.toLowerCase()]},DomElementSchemaRegistry.prototype.securityContext=function(tagName,propName,isAttribute){isAttribute&&(propName=this.getMappedPropName(propName)),tagName=tagName.toLowerCase(),propName=propName.toLowerCase();var ctx=SECURITY_SCHEMA[tagName+"|"+propName];return ctx||((ctx=SECURITY_SCHEMA["*|"+propName])||SecurityContext.NONE)},DomElementSchemaRegistry.prototype.getMappedPropName=function(propName){return _ATTR_TO_PROP[propName]||propName},DomElementSchemaRegistry.prototype.getDefaultComponentElementName=function(){return"ng-component"},DomElementSchemaRegistry.prototype.validateProperty=function(name){if(name.toLowerCase().startsWith("on")){return{error:!0,msg:"Binding to event property '"+name+"' is disallowed for security reasons, please use ("+name.slice(2)+")=...\nIf '"+name+"' is a directive input, make sure the directive is imported by the current module."}}return{error:!1}},DomElementSchemaRegistry.prototype.validateAttribute=function(name){if(name.toLowerCase().startsWith("on")){return{error:!0,msg:"Binding to event attribute '"+name+"' is disallowed for security reasons, please use ("+name.slice(2)+")=..."}}return{error:!1}},DomElementSchemaRegistry.prototype.allKnownElementNames=function(){return Object.keys(this._schema)},DomElementSchemaRegistry.prototype.normalizeAnimationStyleProperty=function(propName){return dashCaseToCamelCase(propName)},DomElementSchemaRegistry.prototype.normalizeAnimationStyleValue=function(camelCaseProp,userProvidedProp,val){var unit="",strVal=val.toString().trim(),errorMsg=null;if(_isPixelDimensionStyle(camelCaseProp)&&0!==val&&"0"!==val)if("number"==typeof val)unit="px";else{var valAndSuffixMatch=val.match(/^[+-]?[\d\.]+([a-z]*)$/);valAndSuffixMatch&&0==valAndSuffixMatch[1].length&&(errorMsg="Please provide a CSS unit value for "+userProvidedProp+":"+val)}return{error:errorMsg,value:strVal+unit}},DomElementSchemaRegistry}(ElementSchemaRegistry),ShadowCss=function(){function ShadowCss(){this.strictStyling=!0}return ShadowCss.prototype.shimCssText=function(cssText,selector,hostSelector){void 0===hostSelector&&(hostSelector="");var commentsWithHash=extractCommentsWithHash(cssText);return cssText=stripComments(cssText),cssText=this._insertDirectives(cssText),[this._scopeCssText(cssText,selector,hostSelector)].concat(commentsWithHash).join("\n")},ShadowCss.prototype._insertDirectives=function(cssText){return cssText=this._insertPolyfillDirectivesInCssText(cssText),this._insertPolyfillRulesInCssText(cssText)},ShadowCss.prototype._insertPolyfillDirectivesInCssText=function(cssText){return cssText.replace(_cssContentNextSelectorRe,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];return m[2]+"{"})},ShadowCss.prototype._insertPolyfillRulesInCssText=function(cssText){return cssText.replace(_cssContentRuleRe,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];var rule=m[0].replace(m[1],"").replace(m[2],"");return m[4]+rule})},ShadowCss.prototype._scopeCssText=function(cssText,scopeSelector,hostSelector){var unscopedRules=this._extractUnscopedRulesFromCssText(cssText);return cssText=this._insertPolyfillHostInCssText(cssText),cssText=this._convertColonHost(cssText),cssText=this._convertColonHostContext(cssText),cssText=this._convertShadowDOMSelectors(cssText),scopeSelector&&(cssText=this._scopeSelectors(cssText,scopeSelector,hostSelector)),cssText=cssText+"\n"+unscopedRules,cssText.trim()},ShadowCss.prototype._extractUnscopedRulesFromCssText=function(cssText){var m,r="";for(_cssContentUnscopedRuleRe.lastIndex=0;null!==(m=_cssContentUnscopedRuleRe.exec(cssText));){r+=m[0].replace(m[2],"").replace(m[1],m[4])+"\n\n"}return r},ShadowCss.prototype._convertColonHost=function(cssText){return this._convertColonRule(cssText,_cssColonHostRe,this._colonHostPartReplacer)},ShadowCss.prototype._convertColonHostContext=function(cssText){return this._convertColonRule(cssText,_cssColonHostContextRe,this._colonHostContextPartReplacer)},ShadowCss.prototype._convertColonRule=function(cssText,regExp,partReplacer){return cssText.replace(regExp,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];if(m[2]){for(var parts=m[2].split(","),r=[],i=0;i<parts.length;i++){var p=parts[i].trim();if(!p)break;r.push(partReplacer(_polyfillHostNoCombinator,p,m[3]))}return r.join(",")}return _polyfillHostNoCombinator+m[3]})},ShadowCss.prototype._colonHostContextPartReplacer=function(host,part,suffix){return part.indexOf(_polyfillHost)>-1?this._colonHostPartReplacer(host,part,suffix):host+part+suffix+", "+part+" "+host+suffix},ShadowCss.prototype._colonHostPartReplacer=function(host,part,suffix){return host+part.replace(_polyfillHost,"")+suffix},ShadowCss.prototype._convertShadowDOMSelectors=function(cssText){return _shadowDOMSelectorsRe.reduce(function(result,pattern){return result.replace(pattern," ")},cssText)},ShadowCss.prototype._scopeSelectors=function(cssText,scopeSelector,hostSelector){var _this=this;return processRules(cssText,function(rule){var selector=rule.selector,content=rule.content;return"@"!=rule.selector[0]?selector=_this._scopeSelector(rule.selector,scopeSelector,hostSelector,_this.strictStyling):(rule.selector.startsWith("@media")||rule.selector.startsWith("@supports")||rule.selector.startsWith("@page")||rule.selector.startsWith("@document"))&&(content=_this._scopeSelectors(rule.content,scopeSelector,hostSelector)),new CssRule(selector,content)})},ShadowCss.prototype._scopeSelector=function(selector,scopeSelector,hostSelector,strict){var _this=this;return selector.split(",").map(function(part){return part.trim().split(_shadowDeepSelectors)}).map(function(deepParts){var shallowPart=deepParts[0],otherParts=deepParts.slice(1);return[function(shallowPart){return _this._selectorNeedsScoping(shallowPart,scopeSelector)?strict?_this._applyStrictSelectorScope(shallowPart,scopeSelector,hostSelector):_this._applySelectorScope(shallowPart,scopeSelector,hostSelector):shallowPart}(shallowPart)].concat(otherParts).join(" ")}).join(", ")},ShadowCss.prototype._selectorNeedsScoping=function(selector,scopeSelector){return!this._makeScopeMatcher(scopeSelector).test(selector)},ShadowCss.prototype._makeScopeMatcher=function(scopeSelector){var lre=/\[/g,rre=/\]/g;return scopeSelector=scopeSelector.replace(lre,"\\[").replace(rre,"\\]"),new RegExp("^("+scopeSelector+")"+_selectorReSuffix,"m")},ShadowCss.prototype._applySelectorScope=function(selector,scopeSelector,hostSelector){return this._applySimpleSelectorScope(selector,scopeSelector,hostSelector)},ShadowCss.prototype._applySimpleSelectorScope=function(selector,scopeSelector,hostSelector){if(_polyfillHostRe.lastIndex=0,_polyfillHostRe.test(selector)){var replaceBy_1=this.strictStyling?"["+hostSelector+"]":scopeSelector;return selector.replace(_polyfillHostNoCombinatorRe,function(hnc,selector){return selector.replace(/([^:]*)(:*)(.*)/,function(_,before,colon,after){return before+replaceBy_1+colon+after})}).replace(_polyfillHostRe,replaceBy_1+" ")}return scopeSelector+" "+selector},ShadowCss.prototype._applyStrictSelectorScope=function(selector,scopeSelector,hostSelector){var _this=this,isRe=/\[is=([^\]]*)\]/g;scopeSelector=scopeSelector.replace(isRe,function(_){for(var parts=[],_i=1;_i<arguments.length;_i++)parts[_i-1]=arguments[_i];return parts[0]});var attrName="["+scopeSelector+"]",_scopeSelectorPart=function(p){var scopedP=p.trim();if(!scopedP)return"";if(p.indexOf(_polyfillHostNoCombinator)>-1)scopedP=_this._applySimpleSelectorScope(p,scopeSelector,hostSelector);else{var t=p.replace(_polyfillHostRe,"");if(t.length>0){var matches=t.match(/([^:]*)(:*)(.*)/);matches&&(scopedP=matches[1]+attrName+matches[2]+matches[3])}}return scopedP},safeContent=new SafeSelector(selector);selector=safeContent.content();for(var res,scopedSelector="",startIndex=0,sep=/( |>|\+|~(?!=))\s*/g,hasHost=selector.indexOf(_polyfillHostNoCombinator)>-1,shouldScope=!hasHost;null!==(res=sep.exec(selector));){var separator=res[1],part_1=selector.slice(startIndex,res.index).trim();shouldScope=shouldScope||part_1.indexOf(_polyfillHostNoCombinator)>-1;scopedSelector+=(shouldScope?_scopeSelectorPart(part_1):part_1)+" "+separator+" ",startIndex=sep.lastIndex}var part=selector.substring(startIndex);return shouldScope=shouldScope||part.indexOf(_polyfillHostNoCombinator)>-1,scopedSelector+=shouldScope?_scopeSelectorPart(part):part,safeContent.restore(scopedSelector)},ShadowCss.prototype._insertPolyfillHostInCssText=function(selector){return selector.replace(_colonHostContextRe,_polyfillHostContext).replace(_colonHostRe,_polyfillHost)},ShadowCss}(),SafeSelector=function(){function SafeSelector(selector){var _this=this;this.placeholders=[],this.index=0,selector=selector.replace(/(\[[^\]]*\])/g,function(_,keep){var replaceBy="__ph-"+_this.index+"__";return _this.placeholders.push(keep),_this.index++,replaceBy}),this._content=selector.replace(/(:nth-[-\w]+)(\([^)]+\))/g,function(_,pseudo,exp){var replaceBy="__ph-"+_this.index+"__";return _this.placeholders.push(exp),_this.index++,pseudo+replaceBy})}return SafeSelector.prototype.restore=function(content){var _this=this;return content.replace(/__ph-(\d+)__/g,function(ph,index){return _this.placeholders[+index]})},SafeSelector.prototype.content=function(){return this._content},SafeSelector}(),_cssContentNextSelectorRe=/polyfill-next-selector[^}]*content:[\s]*?(['"])(.*?)\1[;\s]*}([^{]*?){/gim,_cssContentRuleRe=/(polyfill-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim,_cssContentUnscopedRuleRe=/(polyfill-unscoped-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim,_polyfillHost="-shadowcsshost",_polyfillHostContext="-shadowcsscontext",_parenSuffix=")(?:\\(((?:\\([^)(]*\\)|[^)(]*)+?)\\))?([^,{]*)",_cssColonHostRe=new RegExp("("+_polyfillHost+_parenSuffix,"gim"),_cssColonHostContextRe=new RegExp("("+_polyfillHostContext+_parenSuffix,"gim"),_polyfillHostNoCombinator=_polyfillHost+"-no-combinator",_polyfillHostNoCombinatorRe=/-shadowcsshost-no-combinator([^\s]*)/,_shadowDOMSelectorsRe=[/::shadow/g,/::content/g,/\/shadow-deep\//g,/\/shadow\//g],_shadowDeepSelectors=/(?:>>>)|(?:\/deep\/)|(?:::ng-deep)/g,_selectorReSuffix="([>\\s~+[.,{:][\\s\\S]*)?$",_polyfillHostRe=/-shadowcsshost/gim,_colonHostRe=/:host/gim,_colonHostContextRe=/:host-context/gim,_commentRe=/\/\*\s*[\s\S]*?\*\//g,_commentWithHashRe=/\/\*\s*#\s*source(Mapping)?URL=[\s\S]+?\*\//g,_ruleRe=/(\s*)([^;\{\}]+?)(\s*)((?:{%BLOCK%}?\s*;?)|(?:\s*;))/g,_curlyRe=/([{}])/g,OPEN_CURLY="{",CLOSE_CURLY="}",BLOCK_PLACEHOLDER="%BLOCK%",CssRule=function(){function CssRule(selector,content){this.selector=selector,this.content=content}return CssRule}(),StringWithEscapedBlocks=function(){function StringWithEscapedBlocks(escapedString,blocks){this.escapedString=escapedString,this.blocks=blocks}return StringWithEscapedBlocks}(),StylesCompileDependency=function(){function StylesCompileDependency(name,moduleUrl,setValue){this.name=name,this.moduleUrl=moduleUrl,this.setValue=setValue}return StylesCompileDependency}(),CompiledStylesheet=function(){function CompiledStylesheet(outputCtx,stylesVar,dependencies,isShimmed,meta){this.outputCtx=outputCtx,this.stylesVar=stylesVar,this.dependencies=dependencies,this.isShimmed=isShimmed,this.meta=meta}return CompiledStylesheet}(),StyleCompiler=function(){function StyleCompiler(_urlResolver){this._urlResolver=_urlResolver,this._shadowCss=new ShadowCss}return StyleCompiler.prototype.compileComponent=function(outputCtx,comp){var template=comp.template;return this._compileStyles(outputCtx,comp,new CompileStylesheetMetadata({styles:template.styles,styleUrls:template.styleUrls,moduleUrl:identifierModuleUrl(comp.type)}),this.needsStyleShim(comp),!0)},StyleCompiler.prototype.compileStyles=function(outputCtx,comp,stylesheet,shim){return void 0===shim&&(shim=this.needsStyleShim(comp)),this._compileStyles(outputCtx,comp,stylesheet,shim,!1)},StyleCompiler.prototype.needsStyleShim=function(comp){return comp.template.encapsulation===ViewEncapsulation.Emulated},StyleCompiler.prototype._compileStyles=function(outputCtx,comp,stylesheet,shim,isComponentStylesheet){var _this=this,styleExpressions=stylesheet.styles.map(function(plainStyle){return literal(_this._shimIfNeeded(plainStyle,shim))}),dependencies=[];stylesheet.styleUrls.forEach(function(styleUrl){var exprIndex=styleExpressions.length;styleExpressions.push(null),dependencies.push(new StylesCompileDependency(getStylesVarName(null),styleUrl,function(value){return styleExpressions[exprIndex]=outputCtx.importExpr(value)}))});var stylesVar=getStylesVarName(isComponentStylesheet?comp:null),stmt=variable(stylesVar).set(literalArr(styleExpressions,new ArrayType(DYNAMIC_TYPE,[TypeModifier.Const]))).toDeclStmt(null,isComponentStylesheet?[StmtModifier.Final]:[StmtModifier.Final,StmtModifier.Exported]);return outputCtx.statements.push(stmt),new CompiledStylesheet(outputCtx,stylesVar,dependencies,shim,stylesheet)},StyleCompiler.prototype._shimIfNeeded=function(style,shim){return shim?this._shadowCss.shimCssText(style,"_ngcontent-%COMP%","_nghost-%COMP%"):style},StyleCompiler}(),PRESERVE_WS_ATTR_NAME="ngPreserveWhitespaces",SKIP_WS_TRIM_TAGS=new Set(["pre","template","textarea","script","style"]),WS_CHARS=" \f\n\r\t\v ᠎ - \u2028\u2029  　\ufeff",NO_WS_REGEXP=new RegExp("[^"+WS_CHARS+"]"),WS_REPLACE_REGEXP=new RegExp("["+WS_CHARS+"]{2,}","g"),WhitespaceVisitor=function(){function WhitespaceVisitor(){}return WhitespaceVisitor.prototype.visitElement=function(element,context){return SKIP_WS_TRIM_TAGS.has(element.name)||hasPreserveWhitespacesAttr(element.attrs)?new Element(element.name,visitAll(this,element.attrs),element.children,element.sourceSpan,element.startSourceSpan,element.endSourceSpan):new Element(element.name,element.attrs,visitAll(this,element.children),element.sourceSpan,element.startSourceSpan,element.endSourceSpan)},WhitespaceVisitor.prototype.visitAttribute=function(attribute,context){return attribute.name!==PRESERVE_WS_ATTR_NAME?attribute:null},WhitespaceVisitor.prototype.visitText=function(text,context){return text.value.match(NO_WS_REGEXP)?new Text(replaceNgsp(text.value).replace(WS_REPLACE_REGEXP," "),text.sourceSpan):null},WhitespaceVisitor.prototype.visitComment=function(comment,context){return comment},WhitespaceVisitor.prototype.visitExpansion=function(expansion,context){return expansion},WhitespaceVisitor.prototype.visitExpansionCase=function(expansionCase,context){return expansionCase},WhitespaceVisitor}(),PLURAL_CASES=["zero","one","two","few","many","other"],ExpansionResult=function(){function ExpansionResult(nodes,expanded,errors){this.nodes=nodes,this.expanded=expanded,this.errors=errors}return ExpansionResult}(),ExpansionError=function(_super){function ExpansionError(span,errorMsg){return _super.call(this,span,errorMsg)||this}return __extends(ExpansionError,_super),ExpansionError}(ParseError),_Expander=function(){function _Expander(){this.isExpanded=!1,this.errors=[]}return _Expander.prototype.visitElement=function(element,context){return new Element(element.name,element.attrs,visitAll(this,element.children),element.sourceSpan,element.startSourceSpan,element.endSourceSpan)},_Expander.prototype.visitAttribute=function(attribute,context){return attribute},_Expander.prototype.visitText=function(text,context){return text},_Expander.prototype.visitComment=function(comment,context){return comment},_Expander.prototype.visitExpansion=function(icu,context){return this.isExpanded=!0,"plural"==icu.type?_expandPluralForm(icu,this.errors):_expandDefaultForm(icu,this.errors)},_Expander.prototype.visitExpansionCase=function(icuCase,context){throw new Error("Should not be reached")},_Expander}(),BoundPropertyType={DEFAULT:0,LITERAL_ATTR:1,ANIMATION:2};BoundPropertyType[BoundPropertyType.DEFAULT]="DEFAULT",BoundPropertyType[BoundPropertyType.LITERAL_ATTR]="LITERAL_ATTR",BoundPropertyType[BoundPropertyType.ANIMATION]="ANIMATION";var BoundProperty=function(){function BoundProperty(name,expression,type,sourceSpan){this.name=name,this.expression=expression,this.type=type,this.sourceSpan=sourceSpan,this.isLiteral=this.type===BoundPropertyType.LITERAL_ATTR,this.isAnimation=this.type===BoundPropertyType.ANIMATION}return BoundProperty}(),BindingParser=function(){function BindingParser(_exprParser,_interpolationConfig,_schemaRegistry,pipes,_targetErrors){var _this=this;this._exprParser=_exprParser,this._interpolationConfig=_interpolationConfig,this._schemaRegistry=_schemaRegistry,this._targetErrors=_targetErrors,this.pipesByName=new Map,this._usedPipes=new Map,pipes.forEach(function(pipe){return _this.pipesByName.set(pipe.name,pipe)})}return BindingParser.prototype.getUsedPipes=function(){return Array.from(this._usedPipes.values())},BindingParser.prototype.createDirectiveHostPropertyAsts=function(dirMeta,elementSelector,sourceSpan){var _this=this;if(dirMeta.hostProperties){var boundProps_1=[];return Object.keys(dirMeta.hostProperties).forEach(function(propName){var expression=dirMeta.hostProperties[propName];"string"==typeof expression?_this.parsePropertyBinding(propName,expression,!0,sourceSpan,[],boundProps_1):_this._reportError('Value of the host property binding "'+propName+'" needs to be a string representing an expression but got "'+expression+'" ('+typeof expression+")",sourceSpan)}),boundProps_1.map(function(prop){return _this.createElementPropertyAst(elementSelector,prop)})}return null},BindingParser.prototype.createDirectiveHostEventAsts=function(dirMeta,sourceSpan){var _this=this;if(dirMeta.hostListeners){var targetEventAsts_1=[];return Object.keys(dirMeta.hostListeners).forEach(function(propName){var expression=dirMeta.hostListeners[propName];"string"==typeof expression?_this.parseEvent(propName,expression,sourceSpan,[],targetEventAsts_1):_this._reportError('Value of the host listener "'+propName+'" needs to be a string representing an expression but got "'+expression+'" ('+typeof expression+")",sourceSpan)}),targetEventAsts_1}return null},BindingParser.prototype.parseInterpolation=function(value,sourceSpan){var sourceInfo=sourceSpan.start.toString();try{var ast=this._exprParser.parseInterpolation(value,sourceInfo,this._interpolationConfig);return ast&&this._reportExpressionParserErrors(ast.errors,sourceSpan),this._checkPipes(ast,sourceSpan),ast}catch(e){return this._reportError(""+e,sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)}},BindingParser.prototype.parseInlineTemplateBinding=function(prefixToken,value,sourceSpan,targetMatchableAttrs,targetProps,targetVars){for(var bindings=this._parseTemplateBindings(prefixToken,value,sourceSpan),i=0;i<bindings.length;i++){var binding=bindings[i];binding.keyIsVar?targetVars.push(new VariableAst(binding.key,binding.name,sourceSpan)):binding.expression?this._parsePropertyAst(binding.key,binding.expression,sourceSpan,targetMatchableAttrs,targetProps):(targetMatchableAttrs.push([binding.key,""]),this.parseLiteralAttr(binding.key,null,sourceSpan,targetMatchableAttrs,targetProps))}},BindingParser.prototype._parseTemplateBindings=function(prefixToken,value,sourceSpan){var _this=this,sourceInfo=sourceSpan.start.toString();try{var bindingsResult=this._exprParser.parseTemplateBindings(prefixToken,value,sourceInfo);return this._reportExpressionParserErrors(bindingsResult.errors,sourceSpan),bindingsResult.templateBindings.forEach(function(binding){binding.expression&&_this._checkPipes(binding.expression,sourceSpan)}),bindingsResult.warnings.forEach(function(warning){_this._reportError(warning,sourceSpan,ParseErrorLevel.WARNING)}),bindingsResult.templateBindings}catch(e){
return this._reportError(""+e,sourceSpan),[]}},BindingParser.prototype.parseLiteralAttr=function(name,value,sourceSpan,targetMatchableAttrs,targetProps){_isAnimationLabel(name)?(name=name.substring(1),value&&this._reportError('Assigning animation triggers via @prop="exp" attributes with an expression is invalid. Use property bindings (e.g. [@prop]="exp") or use an attribute without a value (e.g. @prop) instead.',sourceSpan,ParseErrorLevel.ERROR),this._parseAnimation(name,value,sourceSpan,targetMatchableAttrs,targetProps)):targetProps.push(new BoundProperty(name,this._exprParser.wrapLiteralPrimitive(value,""),BoundPropertyType.LITERAL_ATTR,sourceSpan))},BindingParser.prototype.parsePropertyBinding=function(name,expression,isHost,sourceSpan,targetMatchableAttrs,targetProps){var isAnimationProp=!1;name.startsWith("animate-")?(isAnimationProp=!0,name=name.substring("animate-".length)):_isAnimationLabel(name)&&(isAnimationProp=!0,name=name.substring(1)),isAnimationProp?this._parseAnimation(name,expression,sourceSpan,targetMatchableAttrs,targetProps):this._parsePropertyAst(name,this._parseBinding(expression,isHost,sourceSpan),sourceSpan,targetMatchableAttrs,targetProps)},BindingParser.prototype.parsePropertyInterpolation=function(name,value,sourceSpan,targetMatchableAttrs,targetProps){var expr=this.parseInterpolation(value,sourceSpan);return!!expr&&(this._parsePropertyAst(name,expr,sourceSpan,targetMatchableAttrs,targetProps),!0)},BindingParser.prototype._parsePropertyAst=function(name,ast,sourceSpan,targetMatchableAttrs,targetProps){targetMatchableAttrs.push([name,ast.source]),targetProps.push(new BoundProperty(name,ast,BoundPropertyType.DEFAULT,sourceSpan))},BindingParser.prototype._parseAnimation=function(name,expression,sourceSpan,targetMatchableAttrs,targetProps){var ast=this._parseBinding(expression||"undefined",!1,sourceSpan);targetMatchableAttrs.push([name,ast.source]),targetProps.push(new BoundProperty(name,ast,BoundPropertyType.ANIMATION,sourceSpan))},BindingParser.prototype._parseBinding=function(value,isHostBinding,sourceSpan){var sourceInfo=sourceSpan.start.toString();try{var ast=isHostBinding?this._exprParser.parseSimpleBinding(value,sourceInfo,this._interpolationConfig):this._exprParser.parseBinding(value,sourceInfo,this._interpolationConfig);return ast&&this._reportExpressionParserErrors(ast.errors,sourceSpan),this._checkPipes(ast,sourceSpan),ast}catch(e){return this._reportError(""+e,sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)}},BindingParser.prototype.createElementPropertyAst=function(elementSelector,boundProp){if(boundProp.isAnimation)return new BoundElementPropertyAst(boundProp.name,PropertyBindingType.Animation,SecurityContext.NONE,boundProp.expression,null,boundProp.sourceSpan);var unit=null,bindingType=void 0,boundPropertyName=null,parts=boundProp.name.split("."),securityContexts=void 0;if(parts.length>1)if("attr"==parts[0]){boundPropertyName=parts[1],this._validatePropertyOrAttributeName(boundPropertyName,boundProp.sourceSpan,!0),securityContexts=calcPossibleSecurityContexts(this._schemaRegistry,elementSelector,boundPropertyName,!0);var nsSeparatorIdx=boundPropertyName.indexOf(":");if(nsSeparatorIdx>-1){var ns=boundPropertyName.substring(0,nsSeparatorIdx),name_1=boundPropertyName.substring(nsSeparatorIdx+1);boundPropertyName=mergeNsAndName(ns,name_1)}bindingType=PropertyBindingType.Attribute}else"class"==parts[0]?(boundPropertyName=parts[1],bindingType=PropertyBindingType.Class,securityContexts=[SecurityContext.NONE]):"style"==parts[0]&&(unit=parts.length>2?parts[2]:null,boundPropertyName=parts[1],bindingType=PropertyBindingType.Style,securityContexts=[SecurityContext.STYLE]);return null===boundPropertyName&&(boundPropertyName=this._schemaRegistry.getMappedPropName(boundProp.name),securityContexts=calcPossibleSecurityContexts(this._schemaRegistry,elementSelector,boundPropertyName,!1),bindingType=PropertyBindingType.Property,this._validatePropertyOrAttributeName(boundPropertyName,boundProp.sourceSpan,!1)),new BoundElementPropertyAst(boundPropertyName,bindingType,securityContexts[0],boundProp.expression,unit,boundProp.sourceSpan)},BindingParser.prototype.parseEvent=function(name,expression,sourceSpan,targetMatchableAttrs,targetEvents){_isAnimationLabel(name)?(name=name.substr(1),this._parseAnimationEvent(name,expression,sourceSpan,targetEvents)):this._parseEvent(name,expression,sourceSpan,targetMatchableAttrs,targetEvents)},BindingParser.prototype._parseAnimationEvent=function(name,expression,sourceSpan,targetEvents){var matches=splitAtPeriod(name,[name,""]),eventName=matches[0],phase=matches[1].toLowerCase();if(phase)switch(phase){case"start":case"done":var ast=this._parseAction(expression,sourceSpan);targetEvents.push(new BoundEventAst(eventName,null,phase,ast,sourceSpan));break;default:this._reportError('The provided animation output phase value "'+phase+'" for "@'+eventName+'" is not supported (use start or done)',sourceSpan)}else this._reportError("The animation trigger output event (@"+eventName+") is missing its phase value name (start or done are currently supported)",sourceSpan)},BindingParser.prototype._parseEvent=function(name,expression,sourceSpan,targetMatchableAttrs,targetEvents){var _a=splitAtColon(name,[null,name]),target=_a[0],eventName=_a[1],ast=this._parseAction(expression,sourceSpan);targetMatchableAttrs.push([name,ast.source]),targetEvents.push(new BoundEventAst(eventName,target,null,ast,sourceSpan))},BindingParser.prototype._parseAction=function(value,sourceSpan){var sourceInfo=sourceSpan.start.toString();try{var ast=this._exprParser.parseAction(value,sourceInfo,this._interpolationConfig);return ast&&this._reportExpressionParserErrors(ast.errors,sourceSpan),!ast||ast.ast instanceof EmptyExpr?(this._reportError("Empty expressions are not allowed",sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)):(this._checkPipes(ast,sourceSpan),ast)}catch(e){return this._reportError(""+e,sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)}},BindingParser.prototype._reportError=function(message,sourceSpan,level){void 0===level&&(level=ParseErrorLevel.ERROR),this._targetErrors.push(new ParseError(sourceSpan,message,level))},BindingParser.prototype._reportExpressionParserErrors=function(errors,sourceSpan){for(var _i=0,errors_1=errors;_i<errors_1.length;_i++){var error=errors_1[_i];this._reportError(error.message,sourceSpan)}},BindingParser.prototype._checkPipes=function(ast,sourceSpan){var _this=this;if(ast){var collector=new PipeCollector;ast.visit(collector),collector.pipes.forEach(function(ast,pipeName){var pipeMeta=_this.pipesByName.get(pipeName);pipeMeta?_this._usedPipes.set(pipeName,pipeMeta):_this._reportError("The pipe '"+pipeName+"' could not be found",new ParseSourceSpan(sourceSpan.start.moveBy(ast.span.start),sourceSpan.start.moveBy(ast.span.end)))})}},BindingParser.prototype._validatePropertyOrAttributeName=function(propName,sourceSpan,isAttr){var report=isAttr?this._schemaRegistry.validateAttribute(propName):this._schemaRegistry.validateProperty(propName);report.error&&this._reportError(report.msg,sourceSpan,ParseErrorLevel.ERROR)},BindingParser}(),PipeCollector=function(_super){function PipeCollector(){var _this=null!==_super&&_super.apply(this,arguments)||this;return _this.pipes=new Map,_this}return __extends(PipeCollector,_super),PipeCollector.prototype.visitPipe=function(ast,context){return this.pipes.set(ast.name,ast),ast.exp.visit(this),this.visitAll(ast.args,context),null},PipeCollector}(RecursiveAstVisitor),BIND_NAME_REGEXP=/^(?:(?:(?:(bind-)|(let-)|(ref-|#)|(on-)|(bindon-)|(@))(.+))|\[\(([^\)]+)\)\]|\[([^\]]+)\]|\(([^\)]+)\))$/,TEMPLATE_ELEMENT="template",CLASS_ATTR="class",TEXT_CSS_SELECTOR=CssSelector.parse("*")[0],TEMPLATE_ELEMENT_DEPRECATION_WARNING="The <template> element is deprecated. Use <ng-template> instead",warningCounts={},TemplateParseError=function(_super){function TemplateParseError(message,span,level){return _super.call(this,span,message,level)||this}return __extends(TemplateParseError,_super),TemplateParseError}(ParseError),TemplateParseResult=function(){function TemplateParseResult(templateAst,usedPipes,errors){this.templateAst=templateAst,this.usedPipes=usedPipes,this.errors=errors}return TemplateParseResult}(),TemplateParser=function(){function TemplateParser(_config,_reflector,_exprParser,_schemaRegistry,_htmlParser,_console,transforms){this._config=_config,this._reflector=_reflector,this._exprParser=_exprParser,this._schemaRegistry=_schemaRegistry,this._htmlParser=_htmlParser,this._console=_console,this.transforms=transforms}return TemplateParser.prototype.parse=function(component,template,directives,pipes,schemas,templateUrl,preserveWhitespaces){var result=this.tryParse(component,template,directives,pipes,schemas,templateUrl,preserveWhitespaces),warnings=result.errors.filter(function(error){return error.level===ParseErrorLevel.WARNING}).filter(warnOnlyOnce(["The template attribute is deprecated. Use an ng-template element instead.",TEMPLATE_ELEMENT_DEPRECATION_WARNING])),errors=result.errors.filter(function(error){return error.level===ParseErrorLevel.ERROR});if(warnings.length>0&&this._console.warn("Template parse warnings:\n"+warnings.join("\n")),errors.length>0){throw syntaxError("Template parse errors:\n"+errors.join("\n"),errors)}return{template:result.templateAst,pipes:result.usedPipes}},TemplateParser.prototype.tryParse=function(component,template,directives,pipes,schemas,templateUrl,preserveWhitespaces){var htmlParseResult="string"==typeof template?this._htmlParser.parse(template,templateUrl,!0,this.getInterpolationConfig(component)):template;return preserveWhitespaces||(htmlParseResult=removeWhitespaces(htmlParseResult)),this.tryParseHtml(this.expandHtml(htmlParseResult),component,directives,pipes,schemas)},TemplateParser.prototype.tryParseHtml=function(htmlAstWithErrors,component,directives,pipes,schemas){var result,errors=htmlAstWithErrors.errors,usedPipes=[];if(htmlAstWithErrors.rootNodes.length>0){var uniqDirectives=removeSummaryDuplicates(directives),uniqPipes=removeSummaryDuplicates(pipes),providerViewContext=new ProviderViewContext(this._reflector,component),interpolationConfig=void 0;component.template&&component.template.interpolation&&(interpolationConfig={start:component.template.interpolation[0],end:component.template.interpolation[1]});var bindingParser=new BindingParser(this._exprParser,interpolationConfig,this._schemaRegistry,uniqPipes,errors),parseVisitor=new TemplateParseVisitor(this._reflector,this._config,providerViewContext,uniqDirectives,bindingParser,this._schemaRegistry,schemas,errors);result=visitAll(parseVisitor,htmlAstWithErrors.rootNodes,EMPTY_ELEMENT_CONTEXT),errors.push.apply(errors,providerViewContext.errors),usedPipes.push.apply(usedPipes,bindingParser.getUsedPipes())}else result=[];return this._assertNoReferenceDuplicationOnTemplate(result,errors),errors.length>0?new TemplateParseResult(result,usedPipes,errors):(this.transforms&&this.transforms.forEach(function(transform){result=templateVisitAll(transform,result)}),new TemplateParseResult(result,usedPipes,errors))},TemplateParser.prototype.expandHtml=function(htmlAstWithErrors,forced){void 0===forced&&(forced=!1);var errors=htmlAstWithErrors.errors;if(0==errors.length||forced){var expandedHtmlAst=expandNodes(htmlAstWithErrors.rootNodes);errors.push.apply(errors,expandedHtmlAst.errors),htmlAstWithErrors=new ParseTreeResult(expandedHtmlAst.nodes,errors)}return htmlAstWithErrors},TemplateParser.prototype.getInterpolationConfig=function(component){if(component.template)return InterpolationConfig.fromArray(component.template.interpolation)},TemplateParser.prototype._assertNoReferenceDuplicationOnTemplate=function(result,errors){var existingReferences=[];result.filter(function(element){return!!element.references}).forEach(function(element){return element.references.forEach(function(reference){var name=reference.name;if(existingReferences.indexOf(name)<0)existingReferences.push(name);else{var error=new TemplateParseError('Reference "#'+name+'" is defined several times',reference.sourceSpan,ParseErrorLevel.ERROR);errors.push(error)}})})},TemplateParser}(),TemplateParseVisitor=function(){function TemplateParseVisitor(reflector,config,providerViewContext,directives,_bindingParser,_schemaRegistry,_schemas,_targetErrors){var _this=this;this.reflector=reflector,this.config=config,this.providerViewContext=providerViewContext,this._bindingParser=_bindingParser,this._schemaRegistry=_schemaRegistry,this._schemas=_schemas,this._targetErrors=_targetErrors,this.selectorMatcher=new SelectorMatcher,this.directivesIndex=new Map,this.ngContentCount=0,this.contentQueryStartId=providerViewContext.component.viewQueries.length+1,directives.forEach(function(directive,index){var selector=CssSelector.parse(directive.selector);_this.selectorMatcher.addSelectables(selector,directive),_this.directivesIndex.set(directive,index)})}return TemplateParseVisitor.prototype.visitExpansion=function(expansion,context){return null},TemplateParseVisitor.prototype.visitExpansionCase=function(expansionCase,context){return null},TemplateParseVisitor.prototype.visitText=function(text,parent){var ngContentIndex=parent.findNgContentIndex(TEXT_CSS_SELECTOR),valueNoNgsp=replaceNgsp(text.value),expr=this._bindingParser.parseInterpolation(valueNoNgsp,text.sourceSpan);return expr?new BoundTextAst(expr,ngContentIndex,text.sourceSpan):new TextAst(valueNoNgsp,ngContentIndex,text.sourceSpan)},TemplateParseVisitor.prototype.visitAttribute=function(attribute,context){return new AttrAst(attribute.name,attribute.value,attribute.sourceSpan)},TemplateParseVisitor.prototype.visitComment=function(comment,context){return null},TemplateParseVisitor.prototype.visitElement=function(element,parent){var _this=this,queryStartIndex=this.contentQueryStartId,nodeName=element.name,preparsedElement=preparseElement(element);if(preparsedElement.type===PreparsedElementType.SCRIPT||preparsedElement.type===PreparsedElementType.STYLE)return null;if(preparsedElement.type===PreparsedElementType.STYLESHEET&&isStyleUrlResolvable(preparsedElement.hrefAttr))return null;var matchableAttrs=[],elementOrDirectiveProps=[],elementOrDirectiveRefs=[],elementVars=[],events=[],templateElementOrDirectiveProps=[],templateMatchableAttrs=[],templateElementVars=[],hasInlineTemplates=!1,attrs=[],isTemplateElement=isTemplate(element,this.config.enableLegacyTemplate,function(m,span){return _this._reportError(m,span,ParseErrorLevel.WARNING)});element.attrs.forEach(function(attr){var templateBindingsSource,prefixToken,hasBinding=_this._parseAttr(isTemplateElement,attr,matchableAttrs,elementOrDirectiveProps,events,elementOrDirectiveRefs,elementVars),normalizedName=_this._normalizeAttributeName(attr.name);_this.config.enableLegacyTemplate&&"template"==normalizedName?(_this._reportError("The template attribute is deprecated. Use an ng-template element instead.",attr.sourceSpan,ParseErrorLevel.WARNING),templateBindingsSource=attr.value):normalizedName.startsWith("*")&&(templateBindingsSource=attr.value,prefixToken=normalizedName.substring("*".length)+":");var hasTemplateBinding=null!=templateBindingsSource;hasTemplateBinding&&(hasInlineTemplates&&_this._reportError("Can't have multiple template bindings on one element. Use only one attribute named 'template' or prefixed with *",attr.sourceSpan),hasInlineTemplates=!0,_this._bindingParser.parseInlineTemplateBinding(prefixToken,templateBindingsSource,attr.sourceSpan,templateMatchableAttrs,templateElementOrDirectiveProps,templateElementVars)),hasBinding||hasTemplateBinding||(attrs.push(_this.visitAttribute(attr,null)),matchableAttrs.push([attr.name,attr.value]))});var elementCssSelector=createElementCssSelector$1(nodeName,matchableAttrs),_a=this._parseDirectives(this.selectorMatcher,elementCssSelector),directiveMetas=_a.directives,matchElement=_a.matchElement,references=[],boundDirectivePropNames=new Set,directiveAsts=this._createDirectiveAsts(isTemplateElement,element.name,directiveMetas,elementOrDirectiveProps,elementOrDirectiveRefs,element.sourceSpan,references,boundDirectivePropNames),elementProps=this._createElementPropertyAsts(element.name,elementOrDirectiveProps,boundDirectivePropNames),isViewRoot=parent.isTemplateElement||hasInlineTemplates,providerContext=new ProviderElementContext(this.providerViewContext,parent.providerContext,isViewRoot,directiveAsts,attrs,references,isTemplateElement,queryStartIndex,element.sourceSpan),children=visitAll(preparsedElement.nonBindable?NON_BINDABLE_VISITOR:this,element.children,ElementContext.create(isTemplateElement,directiveAsts,isTemplateElement?parent.providerContext:providerContext));providerContext.afterElement();var parsedElement,projectionSelector=null!=preparsedElement.projectAs?CssSelector.parse(preparsedElement.projectAs)[0]:elementCssSelector,ngContentIndex=parent.findNgContentIndex(projectionSelector);if(preparsedElement.type===PreparsedElementType.NG_CONTENT)element.children&&!element.children.every(_isEmptyTextNode)&&this._reportError("<ng-content> element cannot have content.",element.sourceSpan),parsedElement=new NgContentAst(this.ngContentCount++,hasInlineTemplates?null:ngContentIndex,element.sourceSpan);else if(isTemplateElement)this._assertAllEventsPublishedByDirectives(directiveAsts,events),this._assertNoComponentsNorElementBindingsOnTemplate(directiveAsts,elementProps,element.sourceSpan),parsedElement=new EmbeddedTemplateAst(attrs,events,references,elementVars,providerContext.transformedDirectiveAsts,providerContext.transformProviders,providerContext.transformedHasViewContainer,providerContext.queryMatches,children,hasInlineTemplates?null:ngContentIndex,element.sourceSpan);else{this._assertElementExists(matchElement,element),this._assertOnlyOneComponent(directiveAsts,element.sourceSpan);var ngContentIndex_1=hasInlineTemplates?null:parent.findNgContentIndex(projectionSelector);parsedElement=new ElementAst(nodeName,attrs,elementProps,events,references,providerContext.transformedDirectiveAsts,providerContext.transformProviders,providerContext.transformedHasViewContainer,providerContext.queryMatches,children,hasInlineTemplates?null:ngContentIndex_1,element.sourceSpan,element.endSourceSpan||null)}if(hasInlineTemplates){var templateQueryStartIndex=this.contentQueryStartId,templateSelector=createElementCssSelector$1(TEMPLATE_ELEMENT,templateMatchableAttrs),templateDirectiveMetas=this._parseDirectives(this.selectorMatcher,templateSelector).directives,templateBoundDirectivePropNames=new Set,templateDirectiveAsts=this._createDirectiveAsts(!0,element.name,templateDirectiveMetas,templateElementOrDirectiveProps,[],element.sourceSpan,[],templateBoundDirectivePropNames),templateElementProps=this._createElementPropertyAsts(element.name,templateElementOrDirectiveProps,templateBoundDirectivePropNames);this._assertNoComponentsNorElementBindingsOnTemplate(templateDirectiveAsts,templateElementProps,element.sourceSpan);var templateProviderContext=new ProviderElementContext(this.providerViewContext,parent.providerContext,parent.isTemplateElement,templateDirectiveAsts,[],[],!0,templateQueryStartIndex,element.sourceSpan);templateProviderContext.afterElement(),parsedElement=new EmbeddedTemplateAst([],[],[],templateElementVars,templateProviderContext.transformedDirectiveAsts,templateProviderContext.transformProviders,templateProviderContext.transformedHasViewContainer,templateProviderContext.queryMatches,[parsedElement],ngContentIndex,element.sourceSpan)}return parsedElement},TemplateParseVisitor.prototype._parseAttr=function(isTemplateElement,attr,targetMatchableAttrs,targetProps,targetEvents,targetRefs,targetVars){var name=this._normalizeAttributeName(attr.name),value=attr.value,srcSpan=attr.sourceSpan,bindParts=name.match(BIND_NAME_REGEXP),hasBinding=!1;if(null!==bindParts)if(hasBinding=!0,null!=bindParts[1])this._bindingParser.parsePropertyBinding(bindParts[7],value,!1,srcSpan,targetMatchableAttrs,targetProps);else if(bindParts[2])if(isTemplateElement){var identifier=bindParts[7];this._parseVariable(identifier,value,srcSpan,targetVars)}else this._reportError('"let-" is only supported on ng-template elements.',srcSpan);else if(bindParts[3]){var identifier=bindParts[7];this._parseReference(identifier,value,srcSpan,targetRefs)}else bindParts[4]?this._bindingParser.parseEvent(bindParts[7],value,srcSpan,targetMatchableAttrs,targetEvents):bindParts[5]?(this._bindingParser.parsePropertyBinding(bindParts[7],value,!1,srcSpan,targetMatchableAttrs,targetProps),this._parseAssignmentEvent(bindParts[7],value,srcSpan,targetMatchableAttrs,targetEvents)):bindParts[6]?this._bindingParser.parseLiteralAttr(name,value,srcSpan,targetMatchableAttrs,targetProps):bindParts[8]?(this._bindingParser.parsePropertyBinding(bindParts[8],value,!1,srcSpan,targetMatchableAttrs,targetProps),this._parseAssignmentEvent(bindParts[8],value,srcSpan,targetMatchableAttrs,targetEvents)):bindParts[9]?this._bindingParser.parsePropertyBinding(bindParts[9],value,!1,srcSpan,targetMatchableAttrs,targetProps):bindParts[10]&&this._bindingParser.parseEvent(bindParts[10],value,srcSpan,targetMatchableAttrs,targetEvents);else hasBinding=this._bindingParser.parsePropertyInterpolation(name,value,srcSpan,targetMatchableAttrs,targetProps);return hasBinding||this._bindingParser.parseLiteralAttr(name,value,srcSpan,targetMatchableAttrs,targetProps),hasBinding},TemplateParseVisitor.prototype._normalizeAttributeName=function(attrName){return/^data-/i.test(attrName)?attrName.substring(5):attrName},TemplateParseVisitor.prototype._parseVariable=function(identifier,value,sourceSpan,targetVars){identifier.indexOf("-")>-1&&this._reportError('"-" is not allowed in variable names',sourceSpan),targetVars.push(new VariableAst(identifier,value,sourceSpan))},TemplateParseVisitor.prototype._parseReference=function(identifier,value,sourceSpan,targetRefs){identifier.indexOf("-")>-1&&this._reportError('"-" is not allowed in reference names',sourceSpan),targetRefs.push(new ElementOrDirectiveRef(identifier,value,sourceSpan))},TemplateParseVisitor.prototype._parseAssignmentEvent=function(name,expression,sourceSpan,targetMatchableAttrs,targetEvents){this._bindingParser.parseEvent(name+"Change",expression+"=$event",sourceSpan,targetMatchableAttrs,targetEvents)},TemplateParseVisitor.prototype._parseDirectives=function(selectorMatcher,elementCssSelector){var _this=this,directives=new Array(this.directivesIndex.size),matchElement=!1;return selectorMatcher.match(elementCssSelector,function(selector,directive){directives[_this.directivesIndex.get(directive)]=directive,matchElement=matchElement||selector.hasElementSelector()}),{directives:directives.filter(function(dir){return!!dir}),matchElement:matchElement}},TemplateParseVisitor.prototype._createDirectiveAsts=function(isTemplateElement,elementName,directives,props,elementOrDirectiveRefs,elementSourceSpan,targetReferences,targetBoundDirectivePropNames){var _this=this,matchedReferences=new Set,component=null,directiveAsts=directives.map(function(directive){var sourceSpan=new ParseSourceSpan(elementSourceSpan.start,elementSourceSpan.end,"Directive "+identifierName(directive.type));directive.isComponent&&(component=directive);var directiveProperties=[],hostProperties=_this._bindingParser.createDirectiveHostPropertyAsts(directive,elementName,sourceSpan);hostProperties=_this._checkPropertiesInSchema(elementName,hostProperties);var hostEvents=_this._bindingParser.createDirectiveHostEventAsts(directive,sourceSpan);_this._createDirectivePropertyAsts(directive.inputs,props,directiveProperties,targetBoundDirectivePropNames),elementOrDirectiveRefs.forEach(function(elOrDirRef){(0===elOrDirRef.value.length&&directive.isComponent||elOrDirRef.isReferenceToDirective(directive))&&(targetReferences.push(new ReferenceAst(elOrDirRef.name,createTokenForReference(directive.type.reference),elOrDirRef.sourceSpan)),matchedReferences.add(elOrDirRef.name))});var contentQueryStartId=_this.contentQueryStartId;return _this.contentQueryStartId+=directive.queries.length,new DirectiveAst(directive,directiveProperties,hostProperties,hostEvents,contentQueryStartId,sourceSpan)});return elementOrDirectiveRefs.forEach(function(elOrDirRef){if(elOrDirRef.value.length>0)matchedReferences.has(elOrDirRef.name)||_this._reportError('There is no directive with "exportAs" set to "'+elOrDirRef.value+'"',elOrDirRef.sourceSpan);else if(!component){var refToken=null;isTemplateElement&&(refToken=createTokenForExternalReference(_this.reflector,Identifiers.TemplateRef)),targetReferences.push(new ReferenceAst(elOrDirRef.name,refToken,elOrDirRef.sourceSpan))}}),directiveAsts},TemplateParseVisitor.prototype._createDirectivePropertyAsts=function(directiveProperties,boundProps,targetBoundDirectiveProps,targetBoundDirectivePropNames){if(directiveProperties){var boundPropsByName_1=new Map;boundProps.forEach(function(boundProp){var prevValue=boundPropsByName_1.get(boundProp.name);prevValue&&!prevValue.isLiteral||boundPropsByName_1.set(boundProp.name,boundProp)}),Object.keys(directiveProperties).forEach(function(dirProp){var elProp=directiveProperties[dirProp],boundProp=boundPropsByName_1.get(elProp);boundProp&&(targetBoundDirectivePropNames.add(boundProp.name),isEmptyExpression(boundProp.expression)||targetBoundDirectiveProps.push(new BoundDirectivePropertyAst(dirProp,boundProp.name,boundProp.expression,boundProp.sourceSpan)))})}},TemplateParseVisitor.prototype._createElementPropertyAsts=function(elementName,props,boundDirectivePropNames){var _this=this,boundElementProps=[];return props.forEach(function(prop){prop.isLiteral||boundDirectivePropNames.has(prop.name)||boundElementProps.push(_this._bindingParser.createElementPropertyAst(elementName,prop))}),this._checkPropertiesInSchema(elementName,boundElementProps)},TemplateParseVisitor.prototype._findComponentDirectives=function(directives){return directives.filter(function(directive){return directive.directive.isComponent})},TemplateParseVisitor.prototype._findComponentDirectiveNames=function(directives){return this._findComponentDirectives(directives).map(function(directive){return identifierName(directive.directive.type)})},TemplateParseVisitor.prototype._assertOnlyOneComponent=function(directives,sourceSpan){var componentTypeNames=this._findComponentDirectiveNames(directives);componentTypeNames.length>1&&this._reportError("More than one component matched on this element.\nMake sure that only one component's selector can match a given element.\nConflicting components: "+componentTypeNames.join(","),sourceSpan)},TemplateParseVisitor.prototype._assertElementExists=function(matchElement,element){var elName=element.name.replace(/^:xhtml:/,"");if(!matchElement&&!this._schemaRegistry.hasElement(elName,this._schemas)){var errorMsg="'"+elName+"' is not a known element:\n";errorMsg+="1. If '"+elName+"' is an Angular component, then verify that it is part of this module.\n",elName.indexOf("-")>-1?errorMsg+="2. If '"+elName+"' is a Web Component then add 'CUSTOM_ELEMENTS_SCHEMA' to the '@NgModule.schemas' of this component to suppress this message.":errorMsg+="2. To allow any element add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component.",this._reportError(errorMsg,element.sourceSpan)}},TemplateParseVisitor.prototype._assertNoComponentsNorElementBindingsOnTemplate=function(directives,elementProps,sourceSpan){var _this=this,componentTypeNames=this._findComponentDirectiveNames(directives);componentTypeNames.length>0&&this._reportError("Components on an embedded template: "+componentTypeNames.join(","),sourceSpan),elementProps.forEach(function(prop){_this._reportError("Property binding "+prop.name+' not used by any directive on an embedded template. Make sure that the property name is spelled correctly and all directives are listed in the "@NgModule.declarations".',sourceSpan)})},TemplateParseVisitor.prototype._assertAllEventsPublishedByDirectives=function(directives,events){var _this=this,allDirectiveEvents=new Set;directives.forEach(function(directive){Object.keys(directive.directive.outputs).forEach(function(k){var eventName=directive.directive.outputs[k];allDirectiveEvents.add(eventName)})}),events.forEach(function(event){null==event.target&&allDirectiveEvents.has(event.name)||_this._reportError("Event binding "+event.fullName+' not emitted by any directive on an embedded template. Make sure that the event name is spelled correctly and all directives are listed in the "@NgModule.declarations".',event.sourceSpan)})},TemplateParseVisitor.prototype._checkPropertiesInSchema=function(elementName,boundProps){var _this=this;return boundProps.filter(function(boundProp){if(boundProp.type===PropertyBindingType.Property&&!_this._schemaRegistry.hasProperty(elementName,boundProp.name,_this._schemas)){var errorMsg="Can't bind to '"+boundProp.name+"' since it isn't a known property of '"+elementName+"'.";elementName.startsWith("ng-")?errorMsg+="\n1. If '"+boundProp.name+"' is an Angular directive, then add 'CommonModule' to the '@NgModule.imports' of this component.\n2. To allow any property add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component.":elementName.indexOf("-")>-1&&(errorMsg+="\n1. If '"+elementName+"' is an Angular component and it has '"+boundProp.name+"' input, then verify that it is part of this module.\n2. If '"+elementName+"' is a Web Component then add 'CUSTOM_ELEMENTS_SCHEMA' to the '@NgModule.schemas' of this component to suppress this message.\n3. To allow any property add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component."),_this._reportError(errorMsg,boundProp.sourceSpan)}return!isEmptyExpression(boundProp.value)})},TemplateParseVisitor.prototype._reportError=function(message,sourceSpan,level){void 0===level&&(level=ParseErrorLevel.ERROR),this._targetErrors.push(new ParseError(sourceSpan,message,level))},TemplateParseVisitor}(),NonBindableVisitor=function(){function NonBindableVisitor(){}return NonBindableVisitor.prototype.visitElement=function(ast,parent){var preparsedElement=preparseElement(ast);if(preparsedElement.type===PreparsedElementType.SCRIPT||preparsedElement.type===PreparsedElementType.STYLE||preparsedElement.type===PreparsedElementType.STYLESHEET)return null;var attrNameAndValues=ast.attrs.map(function(attr){return[attr.name,attr.value]}),selector=createElementCssSelector$1(ast.name,attrNameAndValues),ngContentIndex=parent.findNgContentIndex(selector),children=visitAll(this,ast.children,EMPTY_ELEMENT_CONTEXT);return new ElementAst(ast.name,visitAll(this,ast.attrs),[],[],[],[],[],!1,[],children,ngContentIndex,ast.sourceSpan,ast.endSourceSpan)},NonBindableVisitor.prototype.visitComment=function(comment,context){return null},NonBindableVisitor.prototype.visitAttribute=function(attribute,context){return new AttrAst(attribute.name,attribute.value,attribute.sourceSpan)},NonBindableVisitor.prototype.visitText=function(text,parent){var ngContentIndex=parent.findNgContentIndex(TEXT_CSS_SELECTOR);return new TextAst(text.value,ngContentIndex,text.sourceSpan)},NonBindableVisitor.prototype.visitExpansion=function(expansion,context){return expansion},NonBindableVisitor.prototype.visitExpansionCase=function(expansionCase,context){return expansionCase},NonBindableVisitor}(),ElementOrDirectiveRef=function(){function ElementOrDirectiveRef(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return ElementOrDirectiveRef.prototype.isReferenceToDirective=function(directive){return-1!==splitExportAs(directive.exportAs).indexOf(this.value)},ElementOrDirectiveRef}(),ElementContext=function(){function ElementContext(isTemplateElement,_ngContentIndexMatcher,_wildcardNgContentIndex,providerContext){this.isTemplateElement=isTemplateElement,this._ngContentIndexMatcher=_ngContentIndexMatcher,this._wildcardNgContentIndex=_wildcardNgContentIndex,this.providerContext=providerContext}return ElementContext.create=function(isTemplateElement,directives,providerContext){
var matcher=new SelectorMatcher,wildcardNgContentIndex=null,component=directives.find(function(directive){return directive.directive.isComponent});if(component)for(var ngContentSelectors=component.directive.template.ngContentSelectors,i=0;i<ngContentSelectors.length;i++){var selector=ngContentSelectors[i];"*"===selector?wildcardNgContentIndex=i:matcher.addSelectables(CssSelector.parse(ngContentSelectors[i]),i)}return new ElementContext(isTemplateElement,matcher,wildcardNgContentIndex,providerContext)},ElementContext.prototype.findNgContentIndex=function(selector){var ngContentIndices=[];return this._ngContentIndexMatcher.match(selector,function(selector,ngContentIndex){ngContentIndices.push(ngContentIndex)}),ngContentIndices.sort(),null!=this._wildcardNgContentIndex&&ngContentIndices.push(this._wildcardNgContentIndex),ngContentIndices.length>0?ngContentIndices[0]:null},ElementContext}(),EMPTY_ELEMENT_CONTEXT=new ElementContext(!0,new SelectorMatcher,null,null),NON_BINDABLE_VISITOR=new NonBindableVisitor,EventHandlerVars=function(){function EventHandlerVars(){}return EventHandlerVars.event=variable("$event"),EventHandlerVars}(),ConvertActionBindingResult=function(){function ConvertActionBindingResult(stmts,allowDefault){this.stmts=stmts,this.allowDefault=allowDefault}return ConvertActionBindingResult}(),ConvertPropertyBindingResult=function(){function ConvertPropertyBindingResult(stmts,currValExpr){this.stmts=stmts,this.currValExpr=currValExpr}return ConvertPropertyBindingResult}(),BindingForm={General:0,TrySimple:1};BindingForm[BindingForm.General]="General",BindingForm[BindingForm.TrySimple]="TrySimple";var _Mode={Statement:0,Expression:1};_Mode[_Mode.Statement]="Statement",_Mode[_Mode.Expression]="Expression";var _BuiltinAstConverter=function(_super){function _BuiltinAstConverter(_converterFactory){var _this=_super.call(this)||this;return _this._converterFactory=_converterFactory,_this}return __extends(_BuiltinAstConverter,_super),_BuiltinAstConverter.prototype.visitPipe=function(ast,context){var _this=this,args=[ast.exp].concat(ast.args).map(function(ast){return ast.visit(_this,context)});return new BuiltinFunctionCall(ast.span,args,this._converterFactory.createPipeConverter(ast.name,args.length))},_BuiltinAstConverter.prototype.visitLiteralArray=function(ast,context){var _this=this,args=ast.expressions.map(function(ast){return ast.visit(_this,context)});return new BuiltinFunctionCall(ast.span,args,this._converterFactory.createLiteralArrayConverter(ast.expressions.length))},_BuiltinAstConverter.prototype.visitLiteralMap=function(ast,context){var _this=this,args=ast.values.map(function(ast){return ast.visit(_this,context)});return new BuiltinFunctionCall(ast.span,args,this._converterFactory.createLiteralMapConverter(ast.keys))},_BuiltinAstConverter}(AstTransformer),_AstToIrVisitor=function(){function _AstToIrVisitor(_localResolver,_implicitReceiver,bindingId){this._localResolver=_localResolver,this._implicitReceiver=_implicitReceiver,this.bindingId=bindingId,this._nodeMap=new Map,this._resultMap=new Map,this._currentTemporary=0,this.temporaryCount=0}return _AstToIrVisitor.prototype.visitBinary=function(ast,mode){var op;switch(ast.operation){case"+":op=BinaryOperator.Plus;break;case"-":op=BinaryOperator.Minus;break;case"*":op=BinaryOperator.Multiply;break;case"/":op=BinaryOperator.Divide;break;case"%":op=BinaryOperator.Modulo;break;case"&&":op=BinaryOperator.And;break;case"||":op=BinaryOperator.Or;break;case"==":op=BinaryOperator.Equals;break;case"!=":op=BinaryOperator.NotEquals;break;case"===":op=BinaryOperator.Identical;break;case"!==":op=BinaryOperator.NotIdentical;break;case"<":op=BinaryOperator.Lower;break;case">":op=BinaryOperator.Bigger;break;case"<=":op=BinaryOperator.LowerEquals;break;case">=":op=BinaryOperator.BiggerEquals;break;default:throw new Error("Unsupported operation "+ast.operation)}return convertToStatementIfNeeded(mode,new BinaryOperatorExpr(op,this._visit(ast.left,_Mode.Expression),this._visit(ast.right,_Mode.Expression)))},_AstToIrVisitor.prototype.visitChain=function(ast,mode){return ensureStatementMode(mode,ast),this.visitAll(ast.expressions,mode)},_AstToIrVisitor.prototype.visitConditional=function(ast,mode){return convertToStatementIfNeeded(mode,this._visit(ast.condition,_Mode.Expression).conditional(this._visit(ast.trueExp,_Mode.Expression),this._visit(ast.falseExp,_Mode.Expression)))},_AstToIrVisitor.prototype.visitPipe=function(ast,mode){throw new Error("Illegal state: Pipes should have been converted into functions. Pipe: "+ast.name)},_AstToIrVisitor.prototype.visitFunctionCall=function(ast,mode){var fnResult,convertedArgs=this.visitAll(ast.args,_Mode.Expression);return fnResult=ast instanceof BuiltinFunctionCall?ast.converter(convertedArgs):this._visit(ast.target,_Mode.Expression).callFn(convertedArgs),convertToStatementIfNeeded(mode,fnResult)},_AstToIrVisitor.prototype.visitImplicitReceiver=function(ast,mode){return ensureExpressionMode(mode,ast),this._implicitReceiver},_AstToIrVisitor.prototype.visitInterpolation=function(ast,mode){ensureExpressionMode(mode,ast);for(var args=[literal(ast.expressions.length)],i=0;i<ast.strings.length-1;i++)args.push(literal(ast.strings[i])),args.push(this._visit(ast.expressions[i],_Mode.Expression));return args.push(literal(ast.strings[ast.strings.length-1])),ast.expressions.length<=9?importExpr(Identifiers.inlineInterpolate).callFn(args):importExpr(Identifiers.interpolate).callFn([args[0],literalArr(args.slice(1))])},_AstToIrVisitor.prototype.visitKeyedRead=function(ast,mode){var leftMostSafe=this.leftMostSafeNode(ast);return leftMostSafe?this.convertSafeAccess(ast,leftMostSafe,mode):convertToStatementIfNeeded(mode,this._visit(ast.obj,_Mode.Expression).key(this._visit(ast.key,_Mode.Expression)))},_AstToIrVisitor.prototype.visitKeyedWrite=function(ast,mode){var obj=this._visit(ast.obj,_Mode.Expression),key=this._visit(ast.key,_Mode.Expression),value=this._visit(ast.value,_Mode.Expression);return convertToStatementIfNeeded(mode,obj.key(key).set(value))},_AstToIrVisitor.prototype.visitLiteralArray=function(ast,mode){throw new Error("Illegal State: literal arrays should have been converted into functions")},_AstToIrVisitor.prototype.visitLiteralMap=function(ast,mode){throw new Error("Illegal State: literal maps should have been converted into functions")},_AstToIrVisitor.prototype.visitLiteralPrimitive=function(ast,mode){var type=null===ast.value||void 0===ast.value||!0===ast.value||!0===ast.value?INFERRED_TYPE:void 0;return convertToStatementIfNeeded(mode,literal(ast.value,type))},_AstToIrVisitor.prototype._getLocal=function(name){return this._localResolver.getLocal(name)},_AstToIrVisitor.prototype.visitMethodCall=function(ast,mode){if(ast.receiver instanceof ImplicitReceiver&&"$any"==ast.name){var args=this.visitAll(ast.args,_Mode.Expression);if(1!=args.length)throw new Error("Invalid call to $any, expected 1 argument but received "+(args.length||"none"));return args[0].cast(DYNAMIC_TYPE)}var leftMostSafe=this.leftMostSafeNode(ast);if(leftMostSafe)return this.convertSafeAccess(ast,leftMostSafe,mode);var args=this.visitAll(ast.args,_Mode.Expression),result=null,receiver=this._visit(ast.receiver,_Mode.Expression);if(receiver===this._implicitReceiver){var varExpr=this._getLocal(ast.name);varExpr&&(result=varExpr.callFn(args))}return null==result&&(result=receiver.callMethod(ast.name,args)),convertToStatementIfNeeded(mode,result)},_AstToIrVisitor.prototype.visitPrefixNot=function(ast,mode){return convertToStatementIfNeeded(mode,not(this._visit(ast.expression,_Mode.Expression)))},_AstToIrVisitor.prototype.visitNonNullAssert=function(ast,mode){return convertToStatementIfNeeded(mode,assertNotNull(this._visit(ast.expression,_Mode.Expression)))},_AstToIrVisitor.prototype.visitPropertyRead=function(ast,mode){var leftMostSafe=this.leftMostSafeNode(ast);if(leftMostSafe)return this.convertSafeAccess(ast,leftMostSafe,mode);var result=null,receiver=this._visit(ast.receiver,_Mode.Expression);return receiver===this._implicitReceiver&&(result=this._getLocal(ast.name)),null==result&&(result=receiver.prop(ast.name)),convertToStatementIfNeeded(mode,result)},_AstToIrVisitor.prototype.visitPropertyWrite=function(ast,mode){var receiver=this._visit(ast.receiver,_Mode.Expression);if(receiver===this._implicitReceiver){if(this._getLocal(ast.name))throw new Error("Cannot assign to a reference or variable!")}return convertToStatementIfNeeded(mode,receiver.prop(ast.name).set(this._visit(ast.value,_Mode.Expression)))},_AstToIrVisitor.prototype.visitSafePropertyRead=function(ast,mode){return this.convertSafeAccess(ast,this.leftMostSafeNode(ast),mode)},_AstToIrVisitor.prototype.visitSafeMethodCall=function(ast,mode){return this.convertSafeAccess(ast,this.leftMostSafeNode(ast),mode)},_AstToIrVisitor.prototype.visitAll=function(asts,mode){var _this=this;return asts.map(function(ast){return _this._visit(ast,mode)})},_AstToIrVisitor.prototype.visitQuote=function(ast,mode){throw new Error("Quotes are not supported for evaluation!\n        Statement: "+ast.uninterpretedExpression+" located at "+ast.location)},_AstToIrVisitor.prototype._visit=function(ast,mode){var result=this._resultMap.get(ast);return result||(this._nodeMap.get(ast)||ast).visit(this,mode)},_AstToIrVisitor.prototype.convertSafeAccess=function(ast,leftMostSafe,mode){var guardedExpression=this._visit(leftMostSafe.receiver,_Mode.Expression),temporary=void 0;this.needsTemporary(leftMostSafe.receiver)&&(temporary=this.allocateTemporary(),guardedExpression=temporary.set(guardedExpression),this._resultMap.set(leftMostSafe.receiver,temporary));var condition=guardedExpression.isBlank();leftMostSafe instanceof SafeMethodCall?this._nodeMap.set(leftMostSafe,new MethodCall(leftMostSafe.span,leftMostSafe.receiver,leftMostSafe.name,leftMostSafe.args)):this._nodeMap.set(leftMostSafe,new PropertyRead(leftMostSafe.span,leftMostSafe.receiver,leftMostSafe.name));var access=this._visit(ast,_Mode.Expression);return this._nodeMap.delete(leftMostSafe),temporary&&this.releaseTemporary(temporary),convertToStatementIfNeeded(mode,condition.conditional(literal(null),access))},_AstToIrVisitor.prototype.leftMostSafeNode=function(ast){var _this=this,visit=function(visitor,ast){return(_this._nodeMap.get(ast)||ast).visit(visitor)};return ast.visit({visitBinary:function(ast){return null},visitChain:function(ast){return null},visitConditional:function(ast){return null},visitFunctionCall:function(ast){return null},visitImplicitReceiver:function(ast){return null},visitInterpolation:function(ast){return null},visitKeyedRead:function(ast){return visit(this,ast.obj)},visitKeyedWrite:function(ast){return null},visitLiteralArray:function(ast){return null},visitLiteralMap:function(ast){return null},visitLiteralPrimitive:function(ast){return null},visitMethodCall:function(ast){return visit(this,ast.receiver)},visitPipe:function(ast){return null},visitPrefixNot:function(ast){return null},visitNonNullAssert:function(ast){return null},visitPropertyRead:function(ast){return visit(this,ast.receiver)},visitPropertyWrite:function(ast){return null},visitQuote:function(ast){return null},visitSafeMethodCall:function(ast){return visit(this,ast.receiver)||ast},visitSafePropertyRead:function(ast){return visit(this,ast.receiver)||ast}})},_AstToIrVisitor.prototype.needsTemporary=function(ast){var _this=this,visit=function(visitor,ast){return ast&&(_this._nodeMap.get(ast)||ast).visit(visitor)},visitSome=function(visitor,ast){return ast.some(function(ast){return visit(visitor,ast)})};return ast.visit({visitBinary:function(ast){return visit(this,ast.left)||visit(this,ast.right)},visitChain:function(ast){return!1},visitConditional:function(ast){return visit(this,ast.condition)||visit(this,ast.trueExp)||visit(this,ast.falseExp)},visitFunctionCall:function(ast){return!0},visitImplicitReceiver:function(ast){return!1},visitInterpolation:function(ast){return visitSome(this,ast.expressions)},visitKeyedRead:function(ast){return!1},visitKeyedWrite:function(ast){return!1},visitLiteralArray:function(ast){return!0},visitLiteralMap:function(ast){return!0},visitLiteralPrimitive:function(ast){return!1},visitMethodCall:function(ast){return!0},visitPipe:function(ast){return!0},visitPrefixNot:function(ast){return visit(this,ast.expression)},visitNonNullAssert:function(ast){return visit(this,ast.expression)},visitPropertyRead:function(ast){return!1},visitPropertyWrite:function(ast){return!1},visitQuote:function(ast){return!1},visitSafeMethodCall:function(ast){return!0},visitSafePropertyRead:function(ast){return!1}})},_AstToIrVisitor.prototype.allocateTemporary=function(){var tempNumber=this._currentTemporary++;return this.temporaryCount=Math.max(this._currentTemporary,this.temporaryCount),new ReadVarExpr(temporaryName(this.bindingId,tempNumber))},_AstToIrVisitor.prototype.releaseTemporary=function(temporary){if(this._currentTemporary--,temporary.name!=temporaryName(this.bindingId,this._currentTemporary))throw new Error("Temporary "+temporary.name+" released out of order")},_AstToIrVisitor}(),DefaultLocalResolver=function(){function DefaultLocalResolver(){}return DefaultLocalResolver.prototype.getLocal=function(name){return name===EventHandlerVars.event.name?EventHandlerVars.event:null},DefaultLocalResolver}(),BuiltinFunctionCall=function(_super){function BuiltinFunctionCall(span,args,converter){var _this=_super.call(this,span,null,args)||this;return _this.args=args,_this.converter=converter,_this}return __extends(BuiltinFunctionCall,_super),BuiltinFunctionCall}(FunctionCall),TypeCheckCompiler=function(){function TypeCheckCompiler(options,reflector){this.options=options,this.reflector=reflector}return TypeCheckCompiler.prototype.compileComponent=function(componentId,component,template,usedPipes,externalReferenceVars,ctx){var _this=this,pipes=new Map;usedPipes.forEach(function(p){return pipes.set(p.name,p.type.reference)});var embeddedViewCount=0,viewBuilderFactory=function(parent,guards){var embeddedViewIndex=embeddedViewCount++;return new ViewBuilder(_this.options,_this.reflector,externalReferenceVars,parent,component.type.reference,component.isHost,embeddedViewIndex,pipes,guards,ctx,viewBuilderFactory)},visitor=viewBuilderFactory(null,[]);return visitor.visitAll([],template),visitor.build(componentId)},TypeCheckCompiler}(),TypeCheckLocalResolver=function(){function TypeCheckLocalResolver(){}return TypeCheckLocalResolver.prototype.getLocal=function(name){return name===EventHandlerVars.event.name?variable("_any"):null},TypeCheckLocalResolver}(),defaultResolver=new TypeCheckLocalResolver,ViewBuilder=function(){function ViewBuilder(options,reflector,externalReferenceVars,parent,component,isHostComponent,embeddedViewIndex,pipes,guards,ctx,viewBuilderFactory){this.options=options,this.reflector=reflector,this.externalReferenceVars=externalReferenceVars,this.parent=parent,this.component=component,this.isHostComponent=isHostComponent,this.embeddedViewIndex=embeddedViewIndex,this.pipes=pipes,this.guards=guards,this.ctx=ctx,this.viewBuilderFactory=viewBuilderFactory,this.refOutputVars=new Map,this.variables=[],this.children=[],this.updates=[],this.actions=[]}return ViewBuilder.prototype.getOutputVar=function(type){var varName;if(!(varName=type===this.component&&this.isHostComponent?"_any":type instanceof StaticSymbol?this.externalReferenceVars.get(type):"_any"))throw new Error("Illegal State: referring to a type without a variable "+JSON.stringify(type));return varName},ViewBuilder.prototype.getTypeGuardExpressions=function(ast){for(var result=this.guards.slice(),_i=0,_a=ast.directives;_i<_a.length;_i++)for(var directive=_a[_i],_b=0,_c=directive.inputs;_b<_c.length;_b++){var input=_c[_b],guard=directive.directive.guards[input.directiveName];if(guard){var useIf="UseIf"===guard;result.push({guard:guard,useIf:useIf,expression:{context:this.component,value:input.value}})}}return result},ViewBuilder.prototype.visitAll=function(variables,astNodes){this.variables=variables,templateVisitAll(this,astNodes)},ViewBuilder.prototype.build=function(componentId,targetStatements){var _this=this;void 0===targetStatements&&(targetStatements=[]),this.children.forEach(function(child){return child.build(componentId,targetStatements)});var viewStmts=[variable("_any").set(NULL_EXPR).toDeclStmt(DYNAMIC_TYPE)],bindingCount=0;if(this.updates.forEach(function(expression){var _a=_this.preprocessUpdateExpression(expression),sourceSpan=_a.sourceSpan,context=_a.context,value=_a.value,bindingId=""+bindingCount++,nameResolver=context===_this.component?_this:defaultResolver,_b=convertPropertyBinding(nameResolver,variable(_this.getOutputVar(context)),value,bindingId,BindingForm.General),stmts=_b.stmts,currValExpr=_b.currValExpr;stmts.push(new ExpressionStatement(currValExpr)),viewStmts.push.apply(viewStmts,stmts.map(function(stmt){return applySourceSpanToStatementIfNeeded(stmt,sourceSpan)}))}),this.actions.forEach(function(_a){var sourceSpan=_a.sourceSpan,context=_a.context,value=_a.value,bindingId=""+bindingCount++,nameResolver=context===_this.component?_this:defaultResolver,stmts=convertActionBinding(nameResolver,variable(_this.getOutputVar(context)),value,bindingId).stmts;viewStmts.push.apply(viewStmts,stmts.map(function(stmt){return applySourceSpanToStatementIfNeeded(stmt,sourceSpan)}))}),this.guards.length){for(var guardExpression=void 0,_i=0,_a=this.guards;_i<_a.length;_i++){var guard=_a[_i],_b=this.preprocessUpdateExpression(guard.expression),context=_b.context,value=_b.value,bindingId=""+bindingCount++,nameResolver=context===this.component?this:defaultResolver,_c=convertPropertyBinding(nameResolver,variable(this.getOutputVar(context)),value,bindingId,BindingForm.TrySimple),stmts=_c.stmts,currValExpr=_c.currValExpr;if(0==stmts.length){var guardClause=guard.useIf?currValExpr:this.ctx.importExpr(guard.guard).callFn([currValExpr]);guardExpression=guardExpression?guardExpression.and(guardClause):guardClause}}guardExpression&&(viewStmts=[new IfStmt(guardExpression,viewStmts)])}var viewName="_View_"+componentId+"_"+this.embeddedViewIndex,viewFactory=new DeclareFunctionStmt(viewName,[],viewStmts);return targetStatements.push(viewFactory),targetStatements},ViewBuilder.prototype.visitBoundText=function(ast,context){var _this=this;ast.value.ast.expressions.forEach(function(expr){return _this.updates.push({context:_this.component,value:expr,sourceSpan:ast.sourceSpan})})},ViewBuilder.prototype.visitEmbeddedTemplate=function(ast,context){if(this.visitElementOrTemplate(ast),this.options.fullTemplateTypeCheck){var guards=this.getTypeGuardExpressions(ast),childVisitor=this.viewBuilderFactory(this,guards);this.children.push(childVisitor),childVisitor.visitAll(ast.variables,ast.children)}},ViewBuilder.prototype.visitElement=function(ast,context){var _this=this;this.visitElementOrTemplate(ast);ast.inputs.forEach(function(inputAst){_this.updates.push({context:_this.component,value:inputAst.value,sourceSpan:inputAst.sourceSpan})}),templateVisitAll(this,ast.children)},ViewBuilder.prototype.visitElementOrTemplate=function(ast){var _this=this;ast.directives.forEach(function(dirAst){_this.visitDirective(dirAst)}),ast.references.forEach(function(ref){var outputVarType=null;outputVarType=ref.value&&ref.value.identifier&&_this.options.fullTemplateTypeCheck?ref.value.identifier.reference:BuiltinTypeName.Dynamic,_this.refOutputVars.set(ref.name,outputVarType)}),ast.outputs.forEach(function(outputAst){_this.actions.push({context:_this.component,value:outputAst.handler,sourceSpan:outputAst.sourceSpan})})},ViewBuilder.prototype.visitDirective=function(dirAst){var _this=this,dirType=dirAst.directive.type.reference;dirAst.inputs.forEach(function(input){return _this.updates.push({context:_this.component,value:input.value,sourceSpan:input.sourceSpan})}),this.options.fullTemplateTypeCheck&&(dirAst.hostProperties.forEach(function(inputAst){return _this.updates.push({context:dirType,value:inputAst.value,sourceSpan:inputAst.sourceSpan})}),dirAst.hostEvents.forEach(function(hostEventAst){return _this.actions.push({context:dirType,value:hostEventAst.handler,sourceSpan:hostEventAst.sourceSpan})}))},ViewBuilder.prototype.getLocal=function(name){if(name==EventHandlerVars.event.name)return variable(this.getOutputVar(BuiltinTypeName.Dynamic));for(var currBuilder=this;currBuilder;currBuilder=currBuilder.parent){var outputVarType=void 0;if(null==(outputVarType=currBuilder.refOutputVars.get(name))){currBuilder.variables.find(function(varAst){return varAst.name===name})&&(outputVarType=BuiltinTypeName.Dynamic)}if(null!=outputVarType)return variable(this.getOutputVar(outputVarType))}return null},ViewBuilder.prototype.pipeOutputVar=function(name){var pipe=this.pipes.get(name);if(!pipe)throw new Error("Illegal State: Could not find pipe "+name+" in template of "+this.component);return this.getOutputVar(pipe)},ViewBuilder.prototype.preprocessUpdateExpression=function(expression){var _this=this;return{sourceSpan:expression.sourceSpan,context:expression.context,value:convertPropertyBindingBuiltins({createLiteralArrayConverter:function(argCount){return function(args){var arr=literalArr(args);return _this.options.fullTemplateTypeCheck?arr:arr.cast(DYNAMIC_TYPE)}},createLiteralMapConverter:function(keys){return function(values){var entries=keys.map(function(k,i){return{key:k.key,value:values[i],quoted:k.quoted}}),map=literalMap(entries);return _this.options.fullTemplateTypeCheck?map:map.cast(DYNAMIC_TYPE)}},createPipeConverter:function(name,argCount){return function(args){return variable(_this.options.fullTemplateTypeCheck?_this.pipeOutputVar(name):_this.getOutputVar(BuiltinTypeName.Dynamic)).callMethod("transform",args)}}},expression.value)}},ViewBuilder.prototype.visitNgContent=function(ast,context){},ViewBuilder.prototype.visitText=function(ast,context){},ViewBuilder.prototype.visitDirectiveProperty=function(ast,context){},ViewBuilder.prototype.visitReference=function(ast,context){},ViewBuilder.prototype.visitVariable=function(ast,context){},ViewBuilder.prototype.visitEvent=function(ast,context){},ViewBuilder.prototype.visitElementProperty=function(ast,context){},ViewBuilder.prototype.visitAttr=function(ast,context){},ViewBuilder}(),CLASS_ATTR$1="class",STYLE_ATTR="style",ViewCompileResult=function(){function ViewCompileResult(viewClassVar,rendererTypeVar){this.viewClassVar=viewClassVar,this.rendererTypeVar=rendererTypeVar}return ViewCompileResult}(),ViewCompiler=function(){function ViewCompiler(_reflector){this._reflector=_reflector}return ViewCompiler.prototype.compileComponent=function(outputCtx,component,template,styles,usedPipes){var _this=this,embeddedViewCount=0,staticQueryIds=findStaticQueryIds(template),renderComponentVarName=void 0;if(!component.isHost){var template_1=component.template,customRenderData=[];template_1.animations&&template_1.animations.length&&customRenderData.push(new LiteralMapEntry("animation",convertValueToOutputAst(outputCtx,template_1.animations),!0));var renderComponentVar=variable(rendererTypeName(component.type.reference));renderComponentVarName=renderComponentVar.name,outputCtx.statements.push(renderComponentVar.set(importExpr(Identifiers.createRendererType2).callFn([new LiteralMapExpr([new LiteralMapEntry("encapsulation",literal(template_1.encapsulation),!1),new LiteralMapEntry("styles",styles,!1),new LiteralMapEntry("data",new LiteralMapExpr(customRenderData),!1)])])).toDeclStmt(importType(Identifiers.RendererType2),[StmtModifier.Final,StmtModifier.Exported]))}var viewBuilderFactory=function(parent){var embeddedViewIndex=embeddedViewCount++;return new ViewBuilder$1(_this._reflector,outputCtx,parent,component,embeddedViewIndex,usedPipes,staticQueryIds,viewBuilderFactory)},visitor=viewBuilderFactory(null);return visitor.visitAll([],template),(_a=outputCtx.statements).push.apply(_a,visitor.build()),new ViewCompileResult(visitor.viewName,renderComponentVarName);var _a},ViewCompiler}(),LOG_VAR$1=variable("_l"),VIEW_VAR=variable("_v"),CHECK_VAR=variable("_ck"),COMP_VAR=variable("_co"),EVENT_NAME_VAR=variable("en"),ALLOW_DEFAULT_VAR=variable("ad"),ViewBuilder$1=function(){function ViewBuilder(reflector,outputCtx,parent,component,embeddedViewIndex,usedPipes,staticQueryIds,viewBuilderFactory){this.reflector=reflector,this.outputCtx=outputCtx,this.parent=parent,this.component=component,this.embeddedViewIndex=embeddedViewIndex,this.usedPipes=usedPipes,this.staticQueryIds=staticQueryIds,this.viewBuilderFactory=viewBuilderFactory,this.nodes=[],this.purePipeNodeIndices=Object.create(null),this.refNodeIndices=Object.create(null),this.variables=[],this.children=[],this.compType=this.embeddedViewIndex>0?DYNAMIC_TYPE:expressionType(outputCtx.importExpr(this.component.type.reference)),this.viewName=viewClassName(this.component.type.reference,this.embeddedViewIndex)}return ViewBuilder.prototype.visitAll=function(variables,astNodes){var _this=this;if(this.variables=variables,this.parent||this.usedPipes.forEach(function(pipe){pipe.pure&&(_this.purePipeNodeIndices[pipe.name]=_this._createPipe(null,pipe))}),!this.parent){var queryIds_1=staticViewQueryIds(this.staticQueryIds);this.component.viewQueries.forEach(function(query,queryIndex){var queryId=queryIndex+1,bindingType=query.first?0:1,flags=134217728|calcStaticDynamicQueryFlags(queryIds_1,queryId,query.first);_this.nodes.push(function(){return{sourceSpan:null,nodeFlags:flags,nodeDef:importExpr(Identifiers.queryDef).callFn([literal(flags),literal(queryId),new LiteralMapExpr([new LiteralMapEntry(query.propertyName,literal(bindingType),!1)])])}})})}templateVisitAll(this,astNodes),this.parent&&(0===astNodes.length||needsAdditionalRootNode(astNodes))&&this.nodes.push(function(){return{sourceSpan:null,nodeFlags:1,nodeDef:importExpr(Identifiers.anchorDef).callFn([literal(0),NULL_EXPR,NULL_EXPR,literal(0)])}})},ViewBuilder.prototype.build=function(targetStatements){void 0===targetStatements&&(targetStatements=[]),this.children.forEach(function(child){return child.build(targetStatements)});var _a=this._createNodeExpressions(),updateRendererStmts=_a.updateRendererStmts,updateDirectivesStmts=_a.updateDirectivesStmts,nodeDefExprs=_a.nodeDefExprs,updateRendererFn=this._createUpdateFn(updateRendererStmts),updateDirectivesFn=this._createUpdateFn(updateDirectivesStmts),viewFlags=0;this.parent||this.component.changeDetection!==ChangeDetectionStrategy.OnPush||(viewFlags|=2);var viewFactory=new DeclareFunctionStmt(this.viewName,[new FnParam(LOG_VAR$1.name)],[new ReturnStatement(importExpr(Identifiers.viewDef).callFn([literal(viewFlags),literalArr(nodeDefExprs),updateDirectivesFn,updateRendererFn]))],importType(Identifiers.ViewDefinition),0===this.embeddedViewIndex?[StmtModifier.Exported]:[]);return targetStatements.push(viewFactory),targetStatements},ViewBuilder.prototype._createUpdateFn=function(updateStmts){var updateFn;if(updateStmts.length>0){var preStmts=[];!this.component.isHost&&findReadVarNames(updateStmts).has(COMP_VAR.name)&&preStmts.push(COMP_VAR.set(VIEW_VAR.prop("component")).toDeclStmt(this.compType)),updateFn=fn([new FnParam(CHECK_VAR.name,INFERRED_TYPE),new FnParam(VIEW_VAR.name,INFERRED_TYPE)],preStmts.concat(updateStmts),INFERRED_TYPE)}else updateFn=NULL_EXPR;return updateFn},ViewBuilder.prototype.visitNgContent=function(ast,context){this.nodes.push(function(){return{sourceSpan:ast.sourceSpan,nodeFlags:8,nodeDef:importExpr(Identifiers.ngContentDef).callFn([literal(ast.ngContentIndex),literal(ast.index)])}})},ViewBuilder.prototype.visitText=function(ast,context){this.nodes.push(function(){return{sourceSpan:ast.sourceSpan,nodeFlags:2,nodeDef:importExpr(Identifiers.textDef).callFn([literal(-1),literal(ast.ngContentIndex),literalArr([literal(ast.value)])])}})},ViewBuilder.prototype.visitBoundText=function(ast,context){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null);var astWithSource=ast.value,inter=astWithSource.ast,updateRendererExpressions=inter.expressions.map(function(expr,bindingIndex){return _this._preprocessUpdateExpression({nodeIndex:nodeIndex,bindingIndex:bindingIndex,sourceSpan:ast.sourceSpan,context:COMP_VAR,value:expr})}),checkIndex=nodeIndex;this.nodes[nodeIndex]=function(){return{sourceSpan:ast.sourceSpan,nodeFlags:2,nodeDef:importExpr(Identifiers.textDef).callFn([literal(checkIndex),literal(ast.ngContentIndex),literalArr(inter.strings.map(function(s){return literal(s)}))]),updateRenderer:updateRendererExpressions}}},ViewBuilder.prototype.visitEmbeddedTemplate=function(ast,context){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null);var _a=this._visitElementOrTemplate(nodeIndex,ast),flags=_a.flags,queryMatchesExpr=_a.queryMatchesExpr,hostEvents=_a.hostEvents,childVisitor=this.viewBuilderFactory(this);this.children.push(childVisitor),childVisitor.visitAll(ast.variables,ast.children);var childCount=this.nodes.length-nodeIndex-1;this.nodes[nodeIndex]=function(){return{sourceSpan:ast.sourceSpan,nodeFlags:1|flags,nodeDef:importExpr(Identifiers.anchorDef).callFn([literal(flags),queryMatchesExpr,literal(ast.ngContentIndex),literal(childCount),_this._createElementHandleEventFn(nodeIndex,hostEvents),variable(childVisitor.viewName)])}}},ViewBuilder.prototype.visitElement=function(ast,context){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null);var elName=isNgContainer(ast.name)?null:ast.name,_a=this._visitElementOrTemplate(nodeIndex,ast),flags=_a.flags,usedEvents=_a.usedEvents,queryMatchesExpr=_a.queryMatchesExpr,dirHostBindings=_a.hostBindings,hostEvents=_a.hostEvents,inputDefs=[],updateRendererExpressions=[],outputDefs=[];if(elName){var hostBindings=ast.inputs.map(function(inputAst){return{context:COMP_VAR,inputAst:inputAst,dirAst:null}}).concat(dirHostBindings);hostBindings.length&&(updateRendererExpressions=hostBindings.map(function(hostBinding,bindingIndex){return _this._preprocessUpdateExpression({context:hostBinding.context,nodeIndex:nodeIndex,bindingIndex:bindingIndex,sourceSpan:hostBinding.inputAst.sourceSpan,value:hostBinding.inputAst.value})}),inputDefs=hostBindings.map(function(hostBinding){return elementBindingDef(hostBinding.inputAst,hostBinding.dirAst)})),outputDefs=usedEvents.map(function(_a){var target=_a[0],eventName=_a[1];return literalArr([literal(target),literal(eventName)])})}templateVisitAll(this,ast.children);var childCount=this.nodes.length-nodeIndex-1,compAst=ast.directives.find(function(dirAst){return dirAst.directive.isComponent}),compRendererType=NULL_EXPR,compView=NULL_EXPR;compAst&&(compView=this.outputCtx.importExpr(compAst.directive.componentViewType),compRendererType=this.outputCtx.importExpr(compAst.directive.rendererType));var checkIndex=nodeIndex;this.nodes[nodeIndex]=function(){return{sourceSpan:ast.sourceSpan,nodeFlags:1|flags,nodeDef:importExpr(Identifiers.elementDef).callFn([literal(checkIndex),literal(flags),queryMatchesExpr,literal(ast.ngContentIndex),literal(childCount),literal(elName),elName?fixedAttrsDef(ast):NULL_EXPR,inputDefs.length?literalArr(inputDefs):NULL_EXPR,outputDefs.length?literalArr(outputDefs):NULL_EXPR,_this._createElementHandleEventFn(nodeIndex,hostEvents),compView,compRendererType]),updateRenderer:updateRendererExpressions}}},ViewBuilder.prototype._visitElementOrTemplate=function(nodeIndex,ast){var _this=this,flags=0;ast.hasViewContainer&&(flags|=16777216);var usedEvents=new Map;ast.outputs.forEach(function(event){var _a=elementEventNameAndTarget(event,null),name=_a.name,target=_a.target;usedEvents.set(elementEventFullName(target,name),[target,name])}),ast.directives.forEach(function(dirAst){dirAst.hostEvents.forEach(function(event){var _a=elementEventNameAndTarget(event,dirAst),name=_a.name,target=_a.target;usedEvents.set(elementEventFullName(target,name),[target,name])})});var hostBindings=[],hostEvents=[];this._visitComponentFactoryResolverProvider(ast.directives),ast.providers.forEach(function(providerAst,providerIndex){var dirAst=void 0,dirIndex=void 0;if(ast.directives.forEach(function(localDirAst,i){
localDirAst.directive.type.reference===tokenReference(providerAst.token)&&(dirAst=localDirAst,dirIndex=i)}),dirAst){var _a=_this._visitDirective(providerAst,dirAst,dirIndex,nodeIndex,ast.references,ast.queryMatches,usedEvents,_this.staticQueryIds.get(ast)),dirHostBindings=_a.hostBindings,dirHostEvents=_a.hostEvents;hostBindings.push.apply(hostBindings,dirHostBindings),hostEvents.push.apply(hostEvents,dirHostEvents)}else _this._visitProvider(providerAst,ast.queryMatches)});var queryMatchExprs=[];return ast.queryMatches.forEach(function(match){var valueType=void 0;tokenReference(match.value)===_this.reflector.resolveExternalReference(Identifiers.ElementRef)?valueType=0:tokenReference(match.value)===_this.reflector.resolveExternalReference(Identifiers.ViewContainerRef)?valueType=3:tokenReference(match.value)===_this.reflector.resolveExternalReference(Identifiers.TemplateRef)&&(valueType=2),null!=valueType&&queryMatchExprs.push(literalArr([literal(match.queryId),literal(valueType)]))}),ast.references.forEach(function(ref){var valueType=void 0;ref.value?tokenReference(ref.value)===_this.reflector.resolveExternalReference(Identifiers.TemplateRef)&&(valueType=2):valueType=1,null!=valueType&&(_this.refNodeIndices[ref.name]=nodeIndex,queryMatchExprs.push(literalArr([literal(ref.name),literal(valueType)])))}),ast.outputs.forEach(function(outputAst){hostEvents.push({context:COMP_VAR,eventAst:outputAst,dirAst:null})}),{flags:flags,usedEvents:Array.from(usedEvents.values()),queryMatchesExpr:queryMatchExprs.length?literalArr(queryMatchExprs):NULL_EXPR,hostBindings:hostBindings,hostEvents:hostEvents}},ViewBuilder.prototype._visitDirective=function(providerAst,dirAst,directiveIndex,elementNodeIndex,refs,queryMatches,usedEvents,queryIds){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null),dirAst.directive.queries.forEach(function(query,queryIndex){var queryId=dirAst.contentQueryStartId+queryIndex,flags=67108864|calcStaticDynamicQueryFlags(queryIds,queryId,query.first),bindingType=query.first?0:1;_this.nodes.push(function(){return{sourceSpan:dirAst.sourceSpan,nodeFlags:flags,nodeDef:importExpr(Identifiers.queryDef).callFn([literal(flags),literal(queryId),new LiteralMapExpr([new LiteralMapEntry(query.propertyName,literal(bindingType),!1)])])}})});var childCount=this.nodes.length-nodeIndex-1,_a=this._visitProviderOrDirective(providerAst,queryMatches),flags=_a.flags,queryMatchExprs=_a.queryMatchExprs,providerExpr=_a.providerExpr,depsExpr=_a.depsExpr;refs.forEach(function(ref){ref.value&&tokenReference(ref.value)===tokenReference(providerAst.token)&&(_this.refNodeIndices[ref.name]=nodeIndex,queryMatchExprs.push(literalArr([literal(ref.name),literal(4)])))}),dirAst.directive.isComponent&&(flags|=32768);var inputDefs=dirAst.inputs.map(function(inputAst,inputIndex){var mapValue=literalArr([literal(inputIndex),literal(inputAst.directiveName)]);return new LiteralMapEntry(inputAst.directiveName,mapValue,!1)}),outputDefs=[],dirMeta=dirAst.directive;Object.keys(dirMeta.outputs).forEach(function(propName){var eventName=dirMeta.outputs[propName];usedEvents.has(eventName)&&outputDefs.push(new LiteralMapEntry(propName,literal(eventName),!1))});var updateDirectiveExpressions=[];(dirAst.inputs.length||(327680&flags)>0)&&(updateDirectiveExpressions=dirAst.inputs.map(function(input,bindingIndex){return _this._preprocessUpdateExpression({nodeIndex:nodeIndex,bindingIndex:bindingIndex,sourceSpan:input.sourceSpan,context:COMP_VAR,value:input.value})}));var dirContextExpr=importExpr(Identifiers.nodeValue).callFn([VIEW_VAR,literal(nodeIndex)]),hostBindings=dirAst.hostProperties.map(function(inputAst){return{context:dirContextExpr,dirAst:dirAst,inputAst:inputAst}}),hostEvents=dirAst.hostEvents.map(function(hostEventAst){return{context:dirContextExpr,eventAst:hostEventAst,dirAst:dirAst}}),checkIndex=nodeIndex;return this.nodes[nodeIndex]=function(){return{sourceSpan:dirAst.sourceSpan,nodeFlags:16384|flags,nodeDef:importExpr(Identifiers.directiveDef).callFn([literal(checkIndex),literal(flags),queryMatchExprs.length?literalArr(queryMatchExprs):NULL_EXPR,literal(childCount),providerExpr,depsExpr,inputDefs.length?new LiteralMapExpr(inputDefs):NULL_EXPR,outputDefs.length?new LiteralMapExpr(outputDefs):NULL_EXPR]),updateDirectives:updateDirectiveExpressions,directive:dirAst.directive.type}},{hostBindings:hostBindings,hostEvents:hostEvents}},ViewBuilder.prototype._visitProvider=function(providerAst,queryMatches){this._addProviderNode(this._visitProviderOrDirective(providerAst,queryMatches))},ViewBuilder.prototype._visitComponentFactoryResolverProvider=function(directives){var componentDirMeta=directives.find(function(dirAst){return dirAst.directive.isComponent});if(componentDirMeta&&componentDirMeta.directive.entryComponents.length){var _a=componentFactoryResolverProviderDef(this.reflector,this.outputCtx,8192,componentDirMeta.directive.entryComponents),providerExpr=_a.providerExpr,depsExpr=_a.depsExpr,flags=_a.flags,tokenExpr=_a.tokenExpr;this._addProviderNode({providerExpr:providerExpr,depsExpr:depsExpr,flags:flags,tokenExpr:tokenExpr,queryMatchExprs:[],sourceSpan:componentDirMeta.sourceSpan})}},ViewBuilder.prototype._addProviderNode=function(data){this.nodes.length;this.nodes.push(function(){return{sourceSpan:data.sourceSpan,nodeFlags:data.flags,nodeDef:importExpr(Identifiers.providerDef).callFn([literal(data.flags),data.queryMatchExprs.length?literalArr(data.queryMatchExprs):NULL_EXPR,data.tokenExpr,data.providerExpr,data.depsExpr])}})},ViewBuilder.prototype._visitProviderOrDirective=function(providerAst,queryMatches){var queryMatchExprs=[];queryMatches.forEach(function(match){tokenReference(match.value)===tokenReference(providerAst.token)&&queryMatchExprs.push(literalArr([literal(match.queryId),literal(4)]))});var _a=providerDef(this.outputCtx,providerAst),providerExpr=_a.providerExpr,depsExpr=_a.depsExpr,providerFlags=_a.flags,tokenExpr=_a.tokenExpr;return{flags:0|providerFlags,queryMatchExprs:queryMatchExprs,providerExpr:providerExpr,depsExpr:depsExpr,tokenExpr:tokenExpr,sourceSpan:providerAst.sourceSpan}},ViewBuilder.prototype.getLocal=function(name){if(name==EventHandlerVars.event.name)return EventHandlerVars.event;for(var currViewExpr=VIEW_VAR,currBuilder=this;currBuilder;currBuilder=currBuilder.parent,currViewExpr=currViewExpr.prop("parent").cast(DYNAMIC_TYPE)){var refNodeIndex=currBuilder.refNodeIndices[name];if(null!=refNodeIndex)return importExpr(Identifiers.nodeValue).callFn([currViewExpr,literal(refNodeIndex)]);var varAst=currBuilder.variables.find(function(varAst){return varAst.name===name});if(varAst){var varValue=varAst.value||"$implicit";return currViewExpr.prop("context").prop(varValue)}}return null},ViewBuilder.prototype._createLiteralArrayConverter=function(sourceSpan,argCount){if(0===argCount){var valueExpr_1=importExpr(Identifiers.EMPTY_ARRAY);return function(){return valueExpr_1}}var checkIndex=this.nodes.length;return this.nodes.push(function(){return{sourceSpan:sourceSpan,nodeFlags:32,nodeDef:importExpr(Identifiers.pureArrayDef).callFn([literal(checkIndex),literal(argCount)])}}),function(args){return callCheckStmt(checkIndex,args)}},ViewBuilder.prototype._createLiteralMapConverter=function(sourceSpan,keys){if(0===keys.length){var valueExpr_2=importExpr(Identifiers.EMPTY_MAP);return function(){return valueExpr_2}}var map=literalMap(keys.map(function(e,i){return __assign({},e,{value:literal(i)})})),checkIndex=this.nodes.length;return this.nodes.push(function(){return{sourceSpan:sourceSpan,nodeFlags:64,nodeDef:importExpr(Identifiers.pureObjectDef).callFn([literal(checkIndex),map])}}),function(args){return callCheckStmt(checkIndex,args)}},ViewBuilder.prototype._createPipeConverter=function(expression,name,argCount){var pipe=this.usedPipes.find(function(pipeSummary){return pipeSummary.name===name});if(pipe.pure){var checkIndex_1=this.nodes.length;this.nodes.push(function(){return{sourceSpan:expression.sourceSpan,nodeFlags:128,nodeDef:importExpr(Identifiers.purePipeDef).callFn([literal(checkIndex_1),literal(argCount)])}});for(var compViewExpr=VIEW_VAR,compBuilder=this;compBuilder.parent;)compBuilder=compBuilder.parent,compViewExpr=compViewExpr.prop("parent").cast(DYNAMIC_TYPE);var pipeNodeIndex=compBuilder.purePipeNodeIndices[name],pipeValueExpr_1=importExpr(Identifiers.nodeValue).callFn([compViewExpr,literal(pipeNodeIndex)]);return function(args){return callUnwrapValue(expression.nodeIndex,expression.bindingIndex,callCheckStmt(checkIndex_1,[pipeValueExpr_1].concat(args)))}}var nodeIndex=this._createPipe(expression.sourceSpan,pipe),nodeValueExpr_1=importExpr(Identifiers.nodeValue).callFn([VIEW_VAR,literal(nodeIndex)]);return function(args){return callUnwrapValue(expression.nodeIndex,expression.bindingIndex,nodeValueExpr_1.callMethod("transform",args))}},ViewBuilder.prototype._createPipe=function(sourceSpan,pipe){var _this=this,nodeIndex=this.nodes.length,flags=0;pipe.type.lifecycleHooks.forEach(function(lifecycleHook){lifecycleHook===LifecycleHooks.OnDestroy&&(flags|=lifecycleHookToNodeFlag(lifecycleHook))});var depExprs=pipe.type.diDeps.map(function(diDep){return depDef(_this.outputCtx,diDep)});return this.nodes.push(function(){return{sourceSpan:sourceSpan,nodeFlags:16,nodeDef:importExpr(Identifiers.pipeDef).callFn([literal(flags),_this.outputCtx.importExpr(pipe.type.reference),literalArr(depExprs)])}}),nodeIndex},ViewBuilder.prototype._preprocessUpdateExpression=function(expression){var _this=this;return{nodeIndex:expression.nodeIndex,bindingIndex:expression.bindingIndex,sourceSpan:expression.sourceSpan,context:expression.context,value:convertPropertyBindingBuiltins({createLiteralArrayConverter:function(argCount){return _this._createLiteralArrayConverter(expression.sourceSpan,argCount)},createLiteralMapConverter:function(keys){return _this._createLiteralMapConverter(expression.sourceSpan,keys)},createPipeConverter:function(name,argCount){return _this._createPipeConverter(expression,name,argCount)}},expression.value)}},ViewBuilder.prototype._createNodeExpressions=function(){function createUpdateStatements(nodeIndex,sourceSpan,expressions,allowEmptyExprs){var updateStmts=[],exprs=expressions.map(function(_a){var sourceSpan=_a.sourceSpan,context=_a.context,value=_a.value,bindingId=""+updateBindingCount++,nameResolver=context===COMP_VAR?self:null,_b=convertPropertyBinding(nameResolver,context,value,bindingId,BindingForm.General),stmts=_b.stmts,currValExpr=_b.currValExpr;return updateStmts.push.apply(updateStmts,stmts.map(function(stmt){return applySourceSpanToStatementIfNeeded(stmt,sourceSpan)})),applySourceSpanToExpressionIfNeeded(currValExpr,sourceSpan)});return(expressions.length||allowEmptyExprs)&&updateStmts.push(applySourceSpanToStatementIfNeeded(callCheckStmt(nodeIndex,exprs).toStmt(),sourceSpan)),updateStmts}var self=this,updateBindingCount=0,updateRendererStmts=[],updateDirectivesStmts=[],nodeDefExprs=this.nodes.map(function(factory,nodeIndex){var _a=factory(),nodeDef=_a.nodeDef,nodeFlags=_a.nodeFlags,updateDirectives=_a.updateDirectives,updateRenderer=_a.updateRenderer,sourceSpan=_a.sourceSpan;return updateRenderer&&updateRendererStmts.push.apply(updateRendererStmts,createUpdateStatements(nodeIndex,sourceSpan,updateRenderer,!1)),updateDirectives&&updateDirectivesStmts.push.apply(updateDirectivesStmts,createUpdateStatements(nodeIndex,sourceSpan,updateDirectives,(327680&nodeFlags)>0)),applySourceSpanToExpressionIfNeeded(3&nodeFlags?new CommaExpr([LOG_VAR$1.callFn([]).callFn([]),nodeDef]):nodeDef,sourceSpan)});return{updateRendererStmts:updateRendererStmts,updateDirectivesStmts:updateDirectivesStmts,nodeDefExprs:nodeDefExprs}},ViewBuilder.prototype._createElementHandleEventFn=function(nodeIndex,handlers){var _this=this,handleEventStmts=[],handleEventBindingCount=0;handlers.forEach(function(_a){var context=_a.context,eventAst=_a.eventAst,dirAst=_a.dirAst,bindingId=""+handleEventBindingCount++,nameResolver=context===COMP_VAR?_this:null,_b=convertActionBinding(nameResolver,context,eventAst.handler,bindingId),stmts=_b.stmts,allowDefault=_b.allowDefault,trueStmts=stmts;allowDefault&&trueStmts.push(ALLOW_DEFAULT_VAR.set(allowDefault.and(ALLOW_DEFAULT_VAR)).toStmt());var _c=elementEventNameAndTarget(eventAst,dirAst),eventTarget=_c.target,eventName=_c.name,fullEventName=elementEventFullName(eventTarget,eventName);handleEventStmts.push(applySourceSpanToStatementIfNeeded(new IfStmt(literal(fullEventName).identical(EVENT_NAME_VAR),trueStmts),eventAst.sourceSpan))});var handleEventFn;if(handleEventStmts.length>0){var preStmts=[ALLOW_DEFAULT_VAR.set(literal(!0)).toDeclStmt(BOOL_TYPE)];!this.component.isHost&&findReadVarNames(handleEventStmts).has(COMP_VAR.name)&&preStmts.push(COMP_VAR.set(VIEW_VAR.prop("component")).toDeclStmt(this.compType)),handleEventFn=fn([new FnParam(VIEW_VAR.name,INFERRED_TYPE),new FnParam(EVENT_NAME_VAR.name,INFERRED_TYPE),new FnParam(EventHandlerVars.event.name,INFERRED_TYPE)],preStmts.concat(handleEventStmts,[new ReturnStatement(ALLOW_DEFAULT_VAR)]),INFERRED_TYPE)}else handleEventFn=NULL_EXPR;return handleEventFn},ViewBuilder.prototype.visitDirective=function(ast,context){},ViewBuilder.prototype.visitDirectiveProperty=function(ast,context){},ViewBuilder.prototype.visitReference=function(ast,context){},ViewBuilder.prototype.visitVariable=function(ast,context){},ViewBuilder.prototype.visitEvent=function(ast,context){},ViewBuilder.prototype.visitElementProperty=function(ast,context){},ViewBuilder.prototype.visitAttr=function(ast,context){},ViewBuilder}(),MessageBundle=function(){function MessageBundle(_htmlParser,_implicitTags,_implicitAttrs,_locale){void 0===_locale&&(_locale=null),this._htmlParser=_htmlParser,this._implicitTags=_implicitTags,this._implicitAttrs=_implicitAttrs,this._locale=_locale,this._messages=[]}return MessageBundle.prototype.updateFromTemplate=function(html,url,interpolationConfig){var htmlParserResult=this._htmlParser.parse(html,url,!0,interpolationConfig);if(htmlParserResult.errors.length)return htmlParserResult.errors;var i18nParserResult=extractMessages(htmlParserResult.rootNodes,interpolationConfig,this._implicitTags,this._implicitAttrs);return i18nParserResult.errors.length?i18nParserResult.errors:((_a=this._messages).push.apply(_a,i18nParserResult.messages),[]);var _a},MessageBundle.prototype.getMessages=function(){return this._messages},MessageBundle.prototype.write=function(serializer,filterSources){var messages={},mapperVisitor=new MapPlaceholderNames;this._messages.forEach(function(message){var id=serializer.digest(message);messages.hasOwnProperty(id)?(_a=messages[id].sources).push.apply(_a,message.sources):messages[id]=message;var _a});var msgList=Object.keys(messages).map(function(id){var mapper=serializer.createNameMapper(messages[id]),src=messages[id],nodes=mapper?mapperVisitor.convert(src.nodes,mapper):src.nodes,transformedMessage=new Message(nodes,{},{},src.meaning,src.description,id);return transformedMessage.sources=src.sources,filterSources&&transformedMessage.sources.forEach(function(source){return source.filePath=filterSources(source.filePath)}),transformedMessage});return serializer.write(msgList,this._locale)},MessageBundle}(),MapPlaceholderNames=function(_super){function MapPlaceholderNames(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(MapPlaceholderNames,_super),MapPlaceholderNames.prototype.convert=function(nodes,mapper){var _this=this;return mapper?nodes.map(function(n){return n.visit(_this,mapper)}):nodes},MapPlaceholderNames.prototype.visitTagPlaceholder=function(ph,mapper){var _this=this,startName=mapper.toPublicName(ph.startName),closeName=ph.closeName?mapper.toPublicName(ph.closeName):ph.closeName,children=ph.children.map(function(n){return n.visit(_this,mapper)});return new TagPlaceholder(ph.tag,ph.attrs,startName,closeName,children,ph.isVoid,ph.sourceSpan)},MapPlaceholderNames.prototype.visitPlaceholder=function(ph,mapper){return new Placeholder(ph.value,mapper.toPublicName(ph.name),ph.sourceSpan)},MapPlaceholderNames.prototype.visitIcuPlaceholder=function(ph,mapper){return new IcuPlaceholder(ph.value,mapper.toPublicName(ph.name),ph.sourceSpan)},MapPlaceholderNames}(CloneVisitor),GeneratedFile=function(){function GeneratedFile(srcFileUrl,genFileUrl,sourceOrStmts){this.srcFileUrl=srcFileUrl,this.genFileUrl=genFileUrl,"string"==typeof sourceOrStmts?(this.source=sourceOrStmts,this.stmts=null):(this.source=null,this.stmts=sourceOrStmts)}return GeneratedFile.prototype.isEquivalent=function(other){return this.genFileUrl===other.genFileUrl&&(this.source?this.source===other.source:null!=other.stmts&&areAllEquivalent(this.stmts,other.stmts))},GeneratedFile}(),ResolvedStaticSymbol=function(){function ResolvedStaticSymbol(symbol,metadata){this.symbol=symbol,this.metadata=metadata}return ResolvedStaticSymbol}(),StaticSymbolResolver=function(){function StaticSymbolResolver(host,staticSymbolCache,summaryResolver,errorRecorder){this.host=host,this.staticSymbolCache=staticSymbolCache,this.summaryResolver=summaryResolver,this.errorRecorder=errorRecorder,this.metadataCache=new Map,this.resolvedSymbols=new Map,this.resolvedFilePaths=new Set,this.importAs=new Map,this.symbolResourcePaths=new Map,this.symbolFromFile=new Map,this.knownFileNameToModuleNames=new Map}return StaticSymbolResolver.prototype.resolveSymbol=function(staticSymbol){if(staticSymbol.members.length>0)return this._resolveSymbolMembers(staticSymbol);var resultFromSummary=this._resolveSymbolFromSummary(staticSymbol);if(resultFromSummary)return resultFromSummary;var resultFromCache=this.resolvedSymbols.get(staticSymbol);return resultFromCache||(this._createSymbolsOf(staticSymbol.filePath),this.resolvedSymbols.get(staticSymbol))},StaticSymbolResolver.prototype.getImportAs=function(staticSymbol,useSummaries){if(void 0===useSummaries&&(useSummaries=!0),staticSymbol.members.length){var baseSymbol=this.getStaticSymbol(staticSymbol.filePath,staticSymbol.name),baseImportAs=this.getImportAs(baseSymbol,useSummaries);return baseImportAs?this.getStaticSymbol(baseImportAs.filePath,baseImportAs.name,staticSymbol.members):null}var summarizedFileName=stripSummaryForJitFileSuffix(staticSymbol.filePath);if(summarizedFileName!==staticSymbol.filePath){var summarizedName=stripSummaryForJitNameSuffix(staticSymbol.name),baseSymbol=this.getStaticSymbol(summarizedFileName,summarizedName,staticSymbol.members),baseImportAs=this.getImportAs(baseSymbol,useSummaries);return baseImportAs?this.getStaticSymbol(summaryForJitFileName(baseImportAs.filePath),summaryForJitName(baseImportAs.name),baseSymbol.members):null}var result=useSummaries&&this.summaryResolver.getImportAs(staticSymbol)||null;return result||(result=this.importAs.get(staticSymbol)),result},StaticSymbolResolver.prototype.getResourcePath=function(staticSymbol){return this.symbolResourcePaths.get(staticSymbol)||staticSymbol.filePath},StaticSymbolResolver.prototype.getTypeArity=function(staticSymbol){if(isGeneratedFile(staticSymbol.filePath))return null;for(var resolvedSymbol=unwrapResolvedMetadata(this.resolveSymbol(staticSymbol));resolvedSymbol&&resolvedSymbol.metadata instanceof StaticSymbol;)resolvedSymbol=unwrapResolvedMetadata(this.resolveSymbol(resolvedSymbol.metadata));return resolvedSymbol&&resolvedSymbol.metadata&&resolvedSymbol.metadata.arity||null},StaticSymbolResolver.prototype.getKnownModuleName=function(filePath){return this.knownFileNameToModuleNames.get(filePath)||null},StaticSymbolResolver.prototype.recordImportAs=function(sourceSymbol,targetSymbol){sourceSymbol.assertNoMembers(),targetSymbol.assertNoMembers(),this.importAs.set(sourceSymbol,targetSymbol)},StaticSymbolResolver.prototype.recordModuleNameForFileName=function(fileName,moduleName){this.knownFileNameToModuleNames.set(fileName,moduleName)},StaticSymbolResolver.prototype.invalidateFile=function(fileName){this.metadataCache.delete(fileName),this.resolvedFilePaths.delete(fileName);var symbols=this.symbolFromFile.get(fileName);if(symbols){this.symbolFromFile.delete(fileName);for(var _i=0,symbols_1=symbols;_i<symbols_1.length;_i++){var symbol=symbols_1[_i];this.resolvedSymbols.delete(symbol),this.importAs.delete(symbol),this.symbolResourcePaths.delete(symbol)}}},StaticSymbolResolver.prototype.ignoreErrorsFor=function(cb){var recorder=this.errorRecorder;this.errorRecorder=function(){};try{return cb()}finally{this.errorRecorder=recorder}},StaticSymbolResolver.prototype._resolveSymbolMembers=function(staticSymbol){var members=staticSymbol.members,baseResolvedSymbol=this.resolveSymbol(this.getStaticSymbol(staticSymbol.filePath,staticSymbol.name));if(!baseResolvedSymbol)return null;var baseMetadata=unwrapResolvedMetadata(baseResolvedSymbol.metadata);if(baseMetadata instanceof StaticSymbol)return new ResolvedStaticSymbol(staticSymbol,this.getStaticSymbol(baseMetadata.filePath,baseMetadata.name,members));if(!baseMetadata||"class"!==baseMetadata.__symbolic){for(var value=baseMetadata,i=0;i<members.length&&value;i++)value=value[members[i]];return new ResolvedStaticSymbol(staticSymbol,value)}return baseMetadata.statics&&1===members.length?new ResolvedStaticSymbol(staticSymbol,baseMetadata.statics[members[0]]):null},StaticSymbolResolver.prototype._resolveSymbolFromSummary=function(staticSymbol){var summary=this.summaryResolver.resolveSummary(staticSymbol);return summary?new ResolvedStaticSymbol(staticSymbol,summary.metadata):null},StaticSymbolResolver.prototype.getStaticSymbol=function(declarationFile,name,members){return this.staticSymbolCache.get(declarationFile,name,members)},StaticSymbolResolver.prototype.hasDecorators=function(filePath){var metadata=this.getModuleMetadata(filePath);return!!metadata.metadata&&Object.keys(metadata.metadata).some(function(metadataKey){var entry=metadata.metadata[metadataKey];return entry&&"class"===entry.__symbolic&&entry.decorators})},StaticSymbolResolver.prototype.getSymbolsOf=function(filePath){var summarySymbols=this.summaryResolver.getSymbolsOf(filePath);if(summarySymbols)return summarySymbols;this._createSymbolsOf(filePath);var metadataSymbols=[];return this.resolvedSymbols.forEach(function(resolvedSymbol){resolvedSymbol.symbol.filePath===filePath&&metadataSymbols.push(resolvedSymbol.symbol)}),metadataSymbols},StaticSymbolResolver.prototype._createSymbolsOf=function(filePath){var _this=this;if(!this.resolvedFilePaths.has(filePath)){this.resolvedFilePaths.add(filePath);var resolvedSymbols=[],metadata=this.getModuleMetadata(filePath);if(metadata.importAs&&this.knownFileNameToModuleNames.set(filePath,metadata.importAs),metadata.exports)for(var this_1=this,_i=0,_a=metadata.exports;_i<_a.length;_i++){var moduleExport=_a[_i];!function(moduleExport){if(moduleExport.export)moduleExport.export.forEach(function(exportSymbol){var symbolName;symbolName="string"==typeof exportSymbol?exportSymbol:exportSymbol.as,symbolName=unescapeIdentifier(symbolName);var symName=symbolName;"string"!=typeof exportSymbol&&(symName=unescapeIdentifier(exportSymbol.name));var resolvedModule=_this.resolveModule(moduleExport.from,filePath);if(resolvedModule){var targetSymbol=_this.getStaticSymbol(resolvedModule,symName),sourceSymbol=_this.getStaticSymbol(filePath,symbolName);resolvedSymbols.push(_this.createExport(sourceSymbol,targetSymbol))}});else{var resolvedModule=this_1.resolveModule(moduleExport.from,filePath);if(resolvedModule){this_1.getSymbolsOf(resolvedModule).forEach(function(targetSymbol){var sourceSymbol=_this.getStaticSymbol(filePath,targetSymbol.name);resolvedSymbols.push(_this.createExport(sourceSymbol,targetSymbol))})}}}(moduleExport)}if(metadata.metadata){var topLevelSymbolNames_1=new Set(Object.keys(metadata.metadata).map(unescapeIdentifier)),origins_1=metadata.origins||{};Object.keys(metadata.metadata).forEach(function(metadataKey){var symbolMeta=metadata.metadata[metadataKey],name=unescapeIdentifier(metadataKey),symbol=_this.getStaticSymbol(filePath,name),origin=origins_1.hasOwnProperty(metadataKey)&&origins_1[metadataKey];if(origin){var originFilePath=_this.resolveModule(origin,filePath);originFilePath?_this.symbolResourcePaths.set(symbol,originFilePath):_this.reportError(new Error("Couldn't resolve original symbol for "+origin+" from "+filePath))}resolvedSymbols.push(_this.createResolvedSymbol(symbol,filePath,topLevelSymbolNames_1,symbolMeta))})}resolvedSymbols.forEach(function(resolvedSymbol){return _this.resolvedSymbols.set(resolvedSymbol.symbol,resolvedSymbol)}),this.symbolFromFile.set(filePath,resolvedSymbols.map(function(resolvedSymbol){return resolvedSymbol.symbol}))}},StaticSymbolResolver.prototype.createResolvedSymbol=function(sourceSymbol,topLevelPath,topLevelSymbolNames,metadata){var _this=this;if(this.summaryResolver.isLibraryFile(sourceSymbol.filePath)&&metadata&&"class"===metadata.__symbolic){var transformedMeta_1={__symbolic:"class",arity:metadata.arity};return new ResolvedStaticSymbol(sourceSymbol,transformedMeta_1)}var _originalFileMemo,getOriginalName=function(){return _originalFileMemo||(_originalFileMemo=_this.host.getOutputName(topLevelPath.replace(/((\.ts)|(\.d\.ts)|)$/,".ts").replace(/^.*node_modules[\/\\]/,""))),_originalFileMemo},self=this,ReferenceTransformer=function(_super){function ReferenceTransformer(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ReferenceTransformer,_super),ReferenceTransformer.prototype.visitStringMap=function(map,functionParams){var symbolic=map.__symbolic;if("function"===symbolic){var oldLen=functionParams.length;functionParams.push.apply(functionParams,map.parameters||[]);var result=_super.prototype.visitStringMap.call(this,map,functionParams);return functionParams.length=oldLen,result}if("reference"!==symbolic)return"error"===symbolic?__assign({},map,{fileName:getOriginalName()}):_super.prototype.visitStringMap.call(this,map,functionParams);var module=map.module,name_1=map.name?unescapeIdentifier(map.name):map.name;if(!name_1)return null;var filePath=void 0;return module?(filePath=self.resolveModule(module,sourceSymbol.filePath),filePath?{__symbolic:"resolved",symbol:self.getStaticSymbol(filePath,name_1),line:map.line,character:map.character,fileName:getOriginalName()}:{__symbolic:"error",message:"Could not resolve "+module+" relative to "+sourceSymbol.filePath+".",line:map.line,character:map.character,fileName:getOriginalName()}):functionParams.indexOf(name_1)>=0?{__symbolic:"reference",name:name_1}:topLevelSymbolNames.has(name_1)?self.getStaticSymbol(topLevelPath,name_1):void 0},ReferenceTransformer}(ValueTransformer),transformedMeta=visitValue(metadata,new ReferenceTransformer,[]),unwrappedTransformedMeta=unwrapResolvedMetadata(transformedMeta);return unwrappedTransformedMeta instanceof StaticSymbol?this.createExport(sourceSymbol,unwrappedTransformedMeta):new ResolvedStaticSymbol(sourceSymbol,transformedMeta)},StaticSymbolResolver.prototype.createExport=function(sourceSymbol,targetSymbol){return sourceSymbol.assertNoMembers(),targetSymbol.assertNoMembers(),this.summaryResolver.isLibraryFile(sourceSymbol.filePath)&&this.summaryResolver.isLibraryFile(targetSymbol.filePath)&&this.importAs.set(targetSymbol,this.getImportAs(sourceSymbol)||sourceSymbol),new ResolvedStaticSymbol(sourceSymbol,targetSymbol)},StaticSymbolResolver.prototype.reportError=function(error,context,path$$1){if(!this.errorRecorder)throw error;this.errorRecorder(error,context&&context.filePath||path$$1)},StaticSymbolResolver.prototype.getModuleMetadata=function(module){var moduleMetadata=this.metadataCache.get(module);if(!moduleMetadata){var moduleMetadatas=this.host.getMetadataFor(module);if(moduleMetadatas){var maxVersion_1=-1;moduleMetadatas.forEach(function(md){md&&md.version>maxVersion_1&&(maxVersion_1=md.version,moduleMetadata=md)})}if(moduleMetadata||(moduleMetadata={__symbolic:"module",version:4,module:module,metadata:{}}),4!=moduleMetadata.version){var errorMessage=2==moduleMetadata.version?"Unsupported metadata version "+moduleMetadata.version+" for module "+module+". This module should be compiled with a newer version of ngc":"Metadata version mismatch for module "+module+", found version "+moduleMetadata.version+", expected 4";this.reportError(new Error(errorMessage))}this.metadataCache.set(module,moduleMetadata)}return moduleMetadata},StaticSymbolResolver.prototype.getSymbolByModule=function(module,symbolName,containingFile){var filePath=this.resolveModule(module,containingFile);return filePath?this.getStaticSymbol(filePath,symbolName):(this.reportError(new Error("Could not resolve module "+module+(containingFile?" relative to "+containingFile:""))),this.getStaticSymbol("ERROR:"+module,symbolName))},StaticSymbolResolver.prototype.resolveModule=function(module,containingFile){try{return this.host.moduleNameToFileName(module,containingFile)}catch(e){console.error("Could not resolve module '"+module+"' relative to file "+containingFile),this.reportError(e,void 0,containingFile)}return null},StaticSymbolResolver}(),ToJsonSerializer=function(_super){function ToJsonSerializer(symbolResolver,summaryResolver,srcFileName){var _this=_super.call(this)||this;return _this.symbolResolver=symbolResolver,_this.summaryResolver=summaryResolver,_this.srcFileName=srcFileName,_this.symbols=[],_this.indexBySymbol=new Map,_this.reexportedBy=new Map,_this.processedSummaryBySymbol=new Map,_this.processedSummaries=[],_this.unprocessedSymbolSummariesBySymbol=new Map,_this.moduleName=symbolResolver.getKnownModuleName(srcFileName),_this}return __extends(ToJsonSerializer,_super),ToJsonSerializer.prototype.addSummary=function(summary){var _this=this,unprocessedSummary=this.unprocessedSymbolSummariesBySymbol.get(summary.symbol),processedSummary=this.processedSummaryBySymbol.get(summary.symbol);if(unprocessedSummary||(unprocessedSummary={symbol:summary.symbol,metadata:void 0},this.unprocessedSymbolSummariesBySymbol.set(summary.symbol,unprocessedSummary),processedSummary={symbol:this.processValue(summary.symbol,0)},this.processedSummaries.push(processedSummary),this.processedSummaryBySymbol.set(summary.symbol,processedSummary)),!unprocessedSummary.metadata&&summary.metadata){var metadata_1=summary.metadata||{};if("class"===metadata_1.__symbolic){var clone_1={};Object.keys(metadata_1).forEach(function(propName){"decorators"!==propName&&(clone_1[propName]=metadata_1[propName])}),metadata_1=clone_1}else isCall(metadata_1)&&(isFunctionCall(metadata_1)||isMethodCallOnVariable(metadata_1)||(metadata_1={__symbolic:"error",message:"Complex function calls are not supported."}));if(unprocessedSummary.metadata=metadata_1,processedSummary.metadata=this.processValue(metadata_1,1),metadata_1 instanceof StaticSymbol&&this.summaryResolver.isLibraryFile(metadata_1.filePath)){var declarationSymbol=this.symbols[this.indexBySymbol.get(metadata_1)];isLoweredSymbol(declarationSymbol.name)||this.reexportedBy.set(declarationSymbol,summary.symbol)}}if(!unprocessedSummary.type&&summary.type&&(unprocessedSummary.type=summary.type,processedSummary.type=this.processValue(summary.type,0),summary.type.summaryKind===CompileSummaryKind.NgModule)){var ngModuleSummary=summary.type;ngModuleSummary.exportedDirectives.concat(ngModuleSummary.exportedPipes).forEach(function(id){var symbol=id.reference;if(_this.summaryResolver.isLibraryFile(symbol.filePath)&&!_this.unprocessedSymbolSummariesBySymbol.has(symbol)){var summary_1=_this.summaryResolver.resolveSummary(symbol);summary_1&&_this.addSummary(summary_1)}})}},ToJsonSerializer.prototype.serialize=function(){var _this=this,exportAs=[];return{json:JSON.stringify({moduleName:this.moduleName,summaries:this.processedSummaries,symbols:this.symbols.map(function(symbol,index){symbol.assertNoMembers();var importAs=void 0;if(_this.summaryResolver.isLibraryFile(symbol.filePath)){var reexportSymbol=_this.reexportedBy.get(symbol);if(reexportSymbol)importAs=_this.indexBySymbol.get(reexportSymbol);else{var summary=_this.unprocessedSymbolSummariesBySymbol.get(symbol);summary&&summary.metadata&&"interface"===summary.metadata.__symbolic||(importAs=symbol.name+"_"+index,exportAs.push({symbol:symbol,
exportAs:importAs}))}}return{__symbol:index,name:symbol.name,filePath:_this.summaryResolver.toSummaryFileName(symbol.filePath,_this.srcFileName),importAs:importAs}})}),exportAs:exportAs}},ToJsonSerializer.prototype.processValue=function(value,flags){return visitValue(value,this,flags)},ToJsonSerializer.prototype.visitOther=function(value,context){if(value instanceof StaticSymbol){var baseSymbol=this.symbolResolver.getStaticSymbol(value.filePath,value.name);return{__symbol:this.visitStaticSymbol(baseSymbol,context),members:value.members}}},ToJsonSerializer.prototype.visitStaticSymbol=function(baseSymbol,flags){var index=this.indexBySymbol.get(baseSymbol),summary=null;if(1&flags&&this.summaryResolver.isLibraryFile(baseSymbol.filePath)){if(this.unprocessedSymbolSummariesBySymbol.has(baseSymbol))return index;summary=this.loadSummary(baseSymbol),summary&&summary.metadata instanceof StaticSymbol&&(index=this.visitStaticSymbol(summary.metadata,flags),summary=null)}else if(null!=index)return index;return null==index&&(index=this.symbols.length,this.symbols.push(baseSymbol)),this.indexBySymbol.set(baseSymbol,index),summary&&this.addSummary(summary),index},ToJsonSerializer.prototype.loadSummary=function(symbol){var summary=this.summaryResolver.resolveSummary(symbol);if(!summary){var resolvedSymbol=this.symbolResolver.resolveSymbol(symbol);resolvedSymbol&&(summary={symbol:resolvedSymbol.symbol,metadata:resolvedSymbol.metadata})}return summary},ToJsonSerializer}(ValueTransformer),ForJitSerializer=function(){function ForJitSerializer(outputCtx,symbolResolver,summaryResolver){this.outputCtx=outputCtx,this.symbolResolver=symbolResolver,this.summaryResolver=summaryResolver,this.data=[]}return ForJitSerializer.prototype.addSourceType=function(summary,metadata){this.data.push({summary:summary,metadata:metadata,isLibrary:!1})},ForJitSerializer.prototype.addLibType=function(summary){this.data.push({summary:summary,metadata:null,isLibrary:!0})},ForJitSerializer.prototype.serialize=function(exportAsArr){for(var _this=this,exportAsBySymbol=new Map,_i=0,exportAsArr_1=exportAsArr;_i<exportAsArr_1.length;_i++){var _a=exportAsArr_1[_i],symbol=_a.symbol,exportAs=_a.exportAs;exportAsBySymbol.set(symbol,exportAs)}for(var ngModuleSymbols=new Set,_b=0,_c=this.data;_b<_c.length;_b++){var _d=_c[_b],summary=_d.summary,metadata=_d.metadata,isLibrary=_d.isLibrary;if(summary.summaryKind===CompileSummaryKind.NgModule){ngModuleSymbols.add(summary.type.reference);for(var modSummary=summary,_e=0,_f=modSummary.modules;_e<_f.length;_e++){var mod=_f[_e];ngModuleSymbols.add(mod.reference)}}if(!isLibrary){summaryForJitName(summary.type.reference.name);createSummaryForJitFunction(this.outputCtx,summary.type.reference,this.serializeSummaryWithDeps(summary,metadata))}}ngModuleSymbols.forEach(function(ngModuleSymbol){if(_this.summaryResolver.isLibraryFile(ngModuleSymbol.filePath)){var exportAs=exportAsBySymbol.get(ngModuleSymbol)||ngModuleSymbol.name,jitExportAsName=summaryForJitName(exportAs);_this.outputCtx.statements.push(variable(jitExportAsName).set(_this.serializeSummaryRef(ngModuleSymbol)).toDeclStmt(null,[StmtModifier.Exported]))}})},ForJitSerializer.prototype.serializeSummaryWithDeps=function(summary,metadata){var _this=this,expressions=[this.serializeSummary(summary)],providers=[];if(metadata instanceof CompileNgModuleMetadata)expressions.push.apply(expressions,metadata.declaredDirectives.concat(metadata.declaredPipes).map(function(type){return type.reference}).concat(metadata.transitiveModule.modules.map(function(type){return type.reference}).filter(function(ref){return ref!==metadata.type.reference})).map(function(ref){return _this.serializeSummaryRef(ref)})),providers=metadata.providers;else if(summary.summaryKind===CompileSummaryKind.Directive){var dirSummary=summary;providers=dirSummary.providers.concat(dirSummary.viewProviders)}return expressions.push.apply(expressions,providers.filter(function(provider){return!!provider.useClass}).map(function(provider){return _this.serializeSummary({summaryKind:CompileSummaryKind.Injectable,type:provider.useClass})})),literalArr(expressions)},ForJitSerializer.prototype.serializeSummaryRef=function(typeSymbol){var jitImportedSymbol=this.symbolResolver.getStaticSymbol(summaryForJitFileName(typeSymbol.filePath),summaryForJitName(typeSymbol.name));return this.outputCtx.importExpr(jitImportedSymbol)},ForJitSerializer.prototype.serializeSummary=function(data){var outputCtx=this.outputCtx;return visitValue(data,new(function(){function Transformer(){}return Transformer.prototype.visitArray=function(arr,context){var _this=this;return literalArr(arr.map(function(entry){return visitValue(entry,_this,context)}))},Transformer.prototype.visitStringMap=function(map,context){var _this=this;return new LiteralMapExpr(Object.keys(map).map(function(key){return new LiteralMapEntry(key,visitValue(map[key],_this,context),!1)}))},Transformer.prototype.visitPrimitive=function(value,context){return literal(value)},Transformer.prototype.visitOther=function(value,context){if(value instanceof StaticSymbol)return outputCtx.importExpr(value);throw new Error("Illegal State: Encountered value "+value)},Transformer}()),null)},ForJitSerializer}(),FromJsonDeserializer=function(_super){function FromJsonDeserializer(symbolCache,summaryResolver){var _this=_super.call(this)||this;return _this.symbolCache=symbolCache,_this.summaryResolver=summaryResolver,_this}return __extends(FromJsonDeserializer,_super),FromJsonDeserializer.prototype.deserialize=function(libraryFileName,json){var _this=this,data=JSON.parse(json),allImportAs=[];this.symbols=data.symbols.map(function(serializedSymbol){return _this.symbolCache.get(_this.summaryResolver.fromSummaryFileName(serializedSymbol.filePath,libraryFileName),serializedSymbol.name)}),data.symbols.forEach(function(serializedSymbol,index){var symbol=_this.symbols[index],importAs=serializedSymbol.importAs;"number"==typeof importAs?allImportAs.push({symbol:symbol,importAs:_this.symbols[importAs]}):"string"==typeof importAs&&allImportAs.push({symbol:symbol,importAs:_this.symbolCache.get(ngfactoryFilePath(libraryFileName),importAs)})});var summaries=visitValue(data.summaries,this,null);return{moduleName:data.moduleName,summaries:summaries,importAs:allImportAs}},FromJsonDeserializer.prototype.visitStringMap=function(map,context){if("__symbol"in map){var baseSymbol=this.symbols[map.__symbol],members=map.members;return members.length?this.symbolCache.get(baseSymbol.filePath,baseSymbol.name,members):baseSymbol}return _super.prototype.visitStringMap.call(this,map,context)},FromJsonDeserializer}(ValueTransformer),StubEmitFlags={Basic:1,TypeCheck:2,All:3};StubEmitFlags[StubEmitFlags.Basic]="Basic",StubEmitFlags[StubEmitFlags.TypeCheck]="TypeCheck",StubEmitFlags[StubEmitFlags.All]="All";var AotCompiler=function(){function AotCompiler(_config,_options,_host,_reflector,_metadataResolver,_templateParser,_styleCompiler,_viewCompiler,_typeCheckCompiler,_ngModuleCompiler,_outputEmitter,_summaryResolver,_symbolResolver){this._config=_config,this._options=_options,this._host=_host,this._reflector=_reflector,this._metadataResolver=_metadataResolver,this._templateParser=_templateParser,this._styleCompiler=_styleCompiler,this._viewCompiler=_viewCompiler,this._typeCheckCompiler=_typeCheckCompiler,this._ngModuleCompiler=_ngModuleCompiler,this._outputEmitter=_outputEmitter,this._summaryResolver=_summaryResolver,this._symbolResolver=_symbolResolver,this._templateAstCache=new Map,this._analyzedFiles=new Map}return AotCompiler.prototype.clearCache=function(){this._metadataResolver.clearCache()},AotCompiler.prototype.analyzeModulesSync=function(rootFiles){var _this=this,analyzeResult=analyzeAndValidateNgModules(rootFiles,this._host,this._symbolResolver,this._metadataResolver);return analyzeResult.ngModules.forEach(function(ngModule){return _this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!0)}),analyzeResult},AotCompiler.prototype.analyzeModulesAsync=function(rootFiles){var _this=this,analyzeResult=analyzeAndValidateNgModules(rootFiles,this._host,this._symbolResolver,this._metadataResolver);return Promise.all(analyzeResult.ngModules.map(function(ngModule){return _this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!1)})).then(function(){return analyzeResult})},AotCompiler.prototype._analyzeFile=function(fileName){var analyzedFile=this._analyzedFiles.get(fileName);return analyzedFile||(analyzedFile=analyzeFile(this._host,this._symbolResolver,this._metadataResolver,fileName),this._analyzedFiles.set(fileName,analyzedFile)),analyzedFile},AotCompiler.prototype.findGeneratedFileNames=function(fileName){var _this=this,genFileNames=[],file=this._analyzeFile(fileName);(this._options.allowEmptyCodegenFiles||file.directives.length||file.pipes.length||file.injectables.length||file.ngModules.length||file.exportsNonSourceFiles)&&(genFileNames.push(ngfactoryFilePath(file.fileName,!0)),this._options.enableSummariesForJit&&genFileNames.push(summaryForJitFileName(file.fileName,!0)));var fileSuffix=normalizeGenFileSuffix(splitTypescriptSuffix(file.fileName,!0)[1]);return file.directives.forEach(function(dirSymbol){var compMeta=_this._metadataResolver.getNonNormalizedDirectiveMetadata(dirSymbol).metadata;compMeta.isComponent&&compMeta.template.styleUrls.forEach(function(styleUrl){var normalizedUrl=_this._host.resourceNameToFileName(styleUrl,file.fileName);if(!normalizedUrl)throw syntaxError("Couldn't resolve resource "+styleUrl+" relative to "+file.fileName);var needsShim=(compMeta.template.encapsulation||_this._config.defaultEncapsulation)===ViewEncapsulation.Emulated;genFileNames.push(_stylesModuleUrl(normalizedUrl,needsShim,fileSuffix)),_this._options.allowEmptyCodegenFiles&&genFileNames.push(_stylesModuleUrl(normalizedUrl,!needsShim,fileSuffix))})}),genFileNames},AotCompiler.prototype.emitBasicStub=function(genFileName,originalFileName){var outputCtx=this._createOutputContext(genFileName);if(genFileName.endsWith(".ngfactory.ts")){if(!originalFileName)throw new Error("Assertion error: require the original file for .ngfactory.ts stubs. File: "+genFileName);var originalFile=this._analyzeFile(originalFileName);this._createNgFactoryStub(outputCtx,originalFile,StubEmitFlags.Basic)}else if(genFileName.endsWith(".ngsummary.ts")){if(this._options.enableSummariesForJit){if(!originalFileName)throw new Error("Assertion error: require the original file for .ngsummary.ts stubs. File: "+genFileName);var originalFile=this._analyzeFile(originalFileName);_createEmptyStub(outputCtx),originalFile.ngModules.forEach(function(ngModule){createForJitStub(outputCtx,ngModule.type.reference)})}}else genFileName.endsWith(".ngstyle.ts")&&_createEmptyStub(outputCtx);return this._codegenSourceModule("unknown",outputCtx)},AotCompiler.prototype.emitTypeCheckStub=function(genFileName,originalFileName){var originalFile=this._analyzeFile(originalFileName),outputCtx=this._createOutputContext(genFileName);return genFileName.endsWith(".ngfactory.ts")&&this._createNgFactoryStub(outputCtx,originalFile,StubEmitFlags.TypeCheck),outputCtx.statements.length>0?this._codegenSourceModule(originalFile.fileName,outputCtx):null},AotCompiler.prototype.loadFilesAsync=function(fileNames){var _this=this,files=fileNames.map(function(fileName){return _this._analyzeFile(fileName)}),loadingPromises=[];return files.forEach(function(file){return file.ngModules.forEach(function(ngModule){return loadingPromises.push(_this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!1))})}),Promise.all(loadingPromises).then(function(_){return mergeAndValidateNgFiles(files)})},AotCompiler.prototype.loadFilesSync=function(fileNames){var _this=this,files=fileNames.map(function(fileName){return _this._analyzeFile(fileName)});return files.forEach(function(file){return file.ngModules.forEach(function(ngModule){return _this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!0)})}),mergeAndValidateNgFiles(files)},AotCompiler.prototype._createNgFactoryStub=function(outputCtx,file,emitFlags){var _this=this,componentId=0;file.ngModules.forEach(function(ngModuleMeta,ngModuleIndex){_this._ngModuleCompiler.createStub(outputCtx,ngModuleMeta.type.reference);var externalReferences=ngModuleMeta.transitiveModule.directives.map(function(d){return d.reference}).concat(ngModuleMeta.transitiveModule.pipes.map(function(d){return d.reference}),ngModuleMeta.importedModules.map(function(m){return m.type.reference}),ngModuleMeta.exportedModules.map(function(m){return m.type.reference}),_this._externalIdentifierReferences([Identifiers.TemplateRef,Identifiers.ElementRef])),externalReferenceVars=new Map;externalReferences.forEach(function(ref,typeIndex){externalReferenceVars.set(ref,"_decl"+ngModuleIndex+"_"+typeIndex)}),externalReferenceVars.forEach(function(varName,reference){outputCtx.statements.push(variable(varName).set(NULL_EXPR.cast(DYNAMIC_TYPE)).toDeclStmt(expressionType(outputCtx.importExpr(reference,null,!1))))}),emitFlags&StubEmitFlags.TypeCheck&&ngModuleMeta.declaredDirectives.forEach(function(dirId){var compMeta=_this._metadataResolver.getDirectiveMetadata(dirId.reference);compMeta.isComponent&&(componentId++,_this._createTypeCheckBlock(outputCtx,compMeta.type.reference.name+"_Host_"+componentId,ngModuleMeta,_this._metadataResolver.getHostComponentMetadata(compMeta),[compMeta.type],externalReferenceVars),_this._createTypeCheckBlock(outputCtx,compMeta.type.reference.name+"_"+componentId,ngModuleMeta,compMeta,ngModuleMeta.transitiveModule.directives,externalReferenceVars))})}),0===outputCtx.statements.length&&_createEmptyStub(outputCtx)},AotCompiler.prototype._externalIdentifierReferences=function(references){for(var result=[],_i=0,references_1=references;_i<references_1.length;_i++){var reference=references_1[_i],token=createTokenForExternalReference(this._reflector,reference);token.identifier&&result.push(token.identifier.reference)}return result},AotCompiler.prototype._createTypeCheckBlock=function(ctx,componentId,moduleMeta,compMeta,directives,externalReferenceVars){var _a=this._parseTemplate(compMeta,moduleMeta,directives),parsedTemplate=_a.template,usedPipes=_a.pipes;(_b=ctx.statements).push.apply(_b,this._typeCheckCompiler.compileComponent(componentId,compMeta,parsedTemplate,usedPipes,externalReferenceVars,ctx));var _b},AotCompiler.prototype.emitMessageBundle=function(analyzeResult,locale){var _this=this,errors=[],htmlParser=new HtmlParser,messageBundle=new MessageBundle(htmlParser,[],{},locale);if(analyzeResult.files.forEach(function(file){var compMetas=[];file.directives.forEach(function(directiveType){var dirMeta=_this._metadataResolver.getDirectiveMetadata(directiveType);dirMeta&&dirMeta.isComponent&&compMetas.push(dirMeta)}),compMetas.forEach(function(compMeta){var html=compMeta.template.template,interpolationConfig=InterpolationConfig.fromArray(compMeta.template.interpolation);errors.push.apply(errors,messageBundle.updateFromTemplate(html,file.fileName,interpolationConfig))})}),errors.length)throw new Error(errors.map(function(e){return e.toString()}).join("\n"));return messageBundle},AotCompiler.prototype.emitAllImpls=function(analyzeResult){var _this=this,ngModuleByPipeOrDirective=analyzeResult.ngModuleByPipeOrDirective;return flatten$1(analyzeResult.files.map(function(file){return _this._compileImplFile(file.fileName,ngModuleByPipeOrDirective,file.directives,file.pipes,file.ngModules,file.injectables)}))},AotCompiler.prototype._compileImplFile=function(srcFileUrl,ngModuleByPipeOrDirective,directives,pipes,ngModules,injectables){var _this=this,fileSuffix=normalizeGenFileSuffix(splitTypescriptSuffix(srcFileUrl,!0)[1]),generatedFiles=[],outputCtx=this._createOutputContext(ngfactoryFilePath(srcFileUrl,!0));if(generatedFiles.push.apply(generatedFiles,this._createSummary(srcFileUrl,directives,pipes,ngModules,injectables,outputCtx)),ngModules.forEach(function(ngModuleMeta){return _this._compileModule(outputCtx,ngModuleMeta)}),directives.forEach(function(dirType){var compMeta=_this._metadataResolver.getDirectiveMetadata(dirType);if(compMeta.isComponent){var ngModule=ngModuleByPipeOrDirective.get(dirType);if(!ngModule)throw new Error("Internal Error: cannot determine the module for component "+identifierName(compMeta.type)+"!");var componentStylesheet=_this._styleCompiler.compileComponent(outputCtx,compMeta);compMeta.template.externalStylesheets.forEach(function(stylesheetMeta){var shim=_this._styleCompiler.needsStyleShim(compMeta);generatedFiles.push(_this._codegenStyles(srcFileUrl,compMeta,stylesheetMeta,shim,fileSuffix)),_this._options.allowEmptyCodegenFiles&&generatedFiles.push(_this._codegenStyles(srcFileUrl,compMeta,stylesheetMeta,!shim,fileSuffix))});_this._compileComponent(outputCtx,compMeta,ngModule,ngModule.transitiveModule.directives,componentStylesheet,fileSuffix);_this._compileComponentFactory(outputCtx,compMeta,ngModule,fileSuffix)}}),outputCtx.statements.length>0||this._options.allowEmptyCodegenFiles){var srcModule=this._codegenSourceModule(srcFileUrl,outputCtx);generatedFiles.unshift(srcModule)}return generatedFiles},AotCompiler.prototype._createSummary=function(srcFileName,directives,pipes,ngModules,injectables,ngFactoryCtx){var _this=this,symbolSummaries=this._symbolResolver.getSymbolsOf(srcFileName).map(function(symbol){return _this._symbolResolver.resolveSymbol(symbol)}),typeData=ngModules.map(function(meta){return{summary:_this._metadataResolver.getNgModuleSummary(meta.type.reference),metadata:_this._metadataResolver.getNgModuleMetadata(meta.type.reference)}}).concat(directives.map(function(ref){return{summary:_this._metadataResolver.getDirectiveSummary(ref),metadata:_this._metadataResolver.getDirectiveMetadata(ref)}}),pipes.map(function(ref){return{summary:_this._metadataResolver.getPipeSummary(ref),metadata:_this._metadataResolver.getPipeMetadata(ref)}}),injectables.map(function(ref){return{summary:_this._metadataResolver.getInjectableSummary(ref),metadata:_this._metadataResolver.getInjectableSummary(ref).type}})),forJitOutputCtx=this._options.enableSummariesForJit?this._createOutputContext(summaryForJitFileName(srcFileName,!0)):null,_a=serializeSummaries(srcFileName,forJitOutputCtx,this._summaryResolver,this._symbolResolver,symbolSummaries,typeData),json=_a.json;_a.exportAs.forEach(function(entry){ngFactoryCtx.statements.push(variable(entry.exportAs).set(ngFactoryCtx.importExpr(entry.symbol)).toDeclStmt(null,[StmtModifier.Exported]))});var summaryJson=new GeneratedFile(srcFileName,summaryFileName(srcFileName),json),result=[summaryJson];return forJitOutputCtx&&result.push(this._codegenSourceModule(srcFileName,forJitOutputCtx)),result},AotCompiler.prototype._compileModule=function(outputCtx,ngModule){var providers=[];if(this._options.locale){var normalizedLocale=this._options.locale.replace(/_/g,"-");providers.push({token:createTokenForExternalReference(this._reflector,Identifiers.LOCALE_ID),useValue:normalizedLocale})}this._options.i18nFormat&&providers.push({token:createTokenForExternalReference(this._reflector,Identifiers.TRANSLATIONS_FORMAT),useValue:this._options.i18nFormat}),this._ngModuleCompiler.compile(outputCtx,ngModule,providers)},AotCompiler.prototype._compileComponentFactory=function(outputCtx,compMeta,ngModule,fileSuffix){var hostMeta=this._metadataResolver.getHostComponentMetadata(compMeta),hostViewFactoryVar=this._compileComponent(outputCtx,hostMeta,ngModule,[compMeta.type],null,fileSuffix).viewClassVar,compFactoryVar=componentFactoryName(compMeta.type.reference),inputsExprs=[];for(var propName in compMeta.inputs){var templateName=compMeta.inputs[propName];inputsExprs.push(new LiteralMapEntry(propName,literal(templateName),!1))}var outputsExprs=[];for(var propName in compMeta.outputs){var templateName=compMeta.outputs[propName];outputsExprs.push(new LiteralMapEntry(propName,literal(templateName),!1))}outputCtx.statements.push(variable(compFactoryVar).set(importExpr(Identifiers.createComponentFactory).callFn([literal(compMeta.selector),outputCtx.importExpr(compMeta.type.reference),variable(hostViewFactoryVar),new LiteralMapExpr(inputsExprs),new LiteralMapExpr(outputsExprs),literalArr(compMeta.template.ngContentSelectors.map(function(selector){return literal(selector)}))])).toDeclStmt(importType(Identifiers.ComponentFactory,[expressionType(outputCtx.importExpr(compMeta.type.reference))],[TypeModifier.Const]),[StmtModifier.Final,StmtModifier.Exported]))},AotCompiler.prototype._compileComponent=function(outputCtx,compMeta,ngModule,directiveIdentifiers,componentStyles,fileSuffix){var _a=this._parseTemplate(compMeta,ngModule,directiveIdentifiers),parsedTemplate=_a.template,usedPipes=_a.pipes,stylesExpr=componentStyles?variable(componentStyles.stylesVar):literalArr([]),viewResult=this._viewCompiler.compileComponent(outputCtx,compMeta,parsedTemplate,stylesExpr,usedPipes);return componentStyles&&_resolveStyleStatements(this._symbolResolver,componentStyles,this._styleCompiler.needsStyleShim(compMeta),fileSuffix),viewResult},AotCompiler.prototype._parseTemplate=function(compMeta,ngModule,directiveIdentifiers){var _this=this;if(this._templateAstCache.has(compMeta.type.reference))return this._templateAstCache.get(compMeta.type.reference);var preserveWhitespaces=compMeta.template.preserveWhitespaces,directives=directiveIdentifiers.map(function(dir){return _this._metadataResolver.getDirectiveSummary(dir.reference)}),pipes=ngModule.transitiveModule.pipes.map(function(pipe){return _this._metadataResolver.getPipeSummary(pipe.reference)}),result=this._templateParser.parse(compMeta,compMeta.template.htmlAst,directives,pipes,ngModule.schemas,templateSourceUrl(ngModule.type,compMeta,compMeta.template),preserveWhitespaces);return this._templateAstCache.set(compMeta.type.reference,result),result},AotCompiler.prototype._createOutputContext=function(genFilePath){var _this=this;return{statements:[],genFilePath:genFilePath,importExpr:function(symbol,typeParams,useSummaries){if(void 0===typeParams&&(typeParams=null),void 0===useSummaries&&(useSummaries=!0),!(symbol instanceof StaticSymbol))throw new Error("Internal error: unknown identifier "+JSON.stringify(symbol));var arity=_this._symbolResolver.getTypeArity(symbol)||0,_a=_this._symbolResolver.getImportAs(symbol,useSummaries)||symbol,filePath=_a.filePath,name=_a.name,members=_a.members,importModule=_this._fileNameToModuleName(filePath,genFilePath),selfReference=_this._fileNameToModuleName(genFilePath,genFilePath),moduleName=importModule===selfReference?null:importModule,suppliedTypeParams=typeParams||[],missingTypeParamsCount=arity-suppliedTypeParams.length,allTypeParams=suppliedTypeParams.concat(new Array(missingTypeParamsCount).fill(DYNAMIC_TYPE));return members.reduce(function(expr,memberName){return expr.prop(memberName)},importExpr(new ExternalReference(moduleName,name,null),allTypeParams))}}},AotCompiler.prototype._fileNameToModuleName=function(importedFilePath,containingFilePath){return this._summaryResolver.getKnownModuleName(importedFilePath)||this._symbolResolver.getKnownModuleName(importedFilePath)||this._host.fileNameToModuleName(importedFilePath,containingFilePath)},AotCompiler.prototype._codegenStyles=function(srcFileUrl,compMeta,stylesheetMetadata,isShimmed,fileSuffix){var outputCtx=this._createOutputContext(_stylesModuleUrl(stylesheetMetadata.moduleUrl,isShimmed,fileSuffix)),compiledStylesheet=this._styleCompiler.compileStyles(outputCtx,compMeta,stylesheetMetadata,isShimmed);return _resolveStyleStatements(this._symbolResolver,compiledStylesheet,isShimmed,fileSuffix),this._codegenSourceModule(srcFileUrl,outputCtx)},AotCompiler.prototype._codegenSourceModule=function(srcFileUrl,ctx){return new GeneratedFile(srcFileUrl,ctx.genFilePath,ctx.statements)},AotCompiler.prototype.listLazyRoutes=function(entryRoute,analyzedModules){function visitLazyRoute(symbol,seenRoutes,allLazyRoutes){if(void 0===seenRoutes&&(seenRoutes=new Set),void 0===allLazyRoutes&&(allLazyRoutes=[]),seenRoutes.has(symbol)||!symbol.name)return allLazyRoutes;seenRoutes.add(symbol);for(var lazyRoutes=listLazyRoutes(self._metadataResolver.getNgModuleMetadata(symbol,!0),self._reflector),_i=0,lazyRoutes_2=lazyRoutes;_i<lazyRoutes_2.length;_i++){var lazyRoute=lazyRoutes_2[_i];allLazyRoutes.push(lazyRoute),visitLazyRoute(lazyRoute.referencedModule,seenRoutes,allLazyRoutes)}return allLazyRoutes}var self=this;if(entryRoute){return visitLazyRoute(parseLazyRoute(entryRoute,this._reflector).referencedModule)}if(analyzedModules){for(var allLazyRoutes=[],_i=0,_a=analyzedModules.ngModules;_i<_a.length;_i++)for(var ngModule=_a[_i],lazyRoutes=listLazyRoutes(ngModule,this._reflector),_b=0,lazyRoutes_1=lazyRoutes;_b<lazyRoutes_1.length;_b++){var lazyRoute=lazyRoutes_1[_b];allLazyRoutes.push(lazyRoute)}return allLazyRoutes}throw new Error("Either route or analyzedModules has to be specified!")},AotCompiler}(),FORMATTED_MESSAGE="ngFormattedMessage",ANGULAR_CORE="@angular/core",HIDDEN_KEY=/^\$.*\$$/,IGNORE={__symbolic:"ignore"},USE_VALUE="useValue",PROVIDE="provide",REFERENCE_SET=new Set([USE_VALUE,"useFactory","data"]),StaticReflector=function(){function StaticReflector(summaryResolver,symbolResolver,knownMetadataClasses,knownMetadataFunctions,errorRecorder){void 0===knownMetadataClasses&&(knownMetadataClasses=[]),void 0===knownMetadataFunctions&&(knownMetadataFunctions=[]);var _this=this;this.summaryResolver=summaryResolver,this.symbolResolver=symbolResolver,this.errorRecorder=errorRecorder,this.annotationCache=new Map,this.propertyCache=new Map,this.parameterCache=new Map,this.methodCache=new Map,this.staticCache=new Map,this.conversionMap=new Map,this.resolvedExternalReferences=new Map,this.annotationForParentClassWithSummaryKind=new Map,this.initializeConversionMap(),knownMetadataClasses.forEach(function(kc){return _this._registerDecoratorOrConstructor(_this.getStaticSymbol(kc.filePath,kc.name),kc.ctor)}),knownMetadataFunctions.forEach(function(kf){return _this._registerFunction(_this.getStaticSymbol(kf.filePath,kf.name),kf.fn)}),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.Directive,[createDirective,createComponent]),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.Pipe,[createPipe]),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.NgModule,[createNgModule]),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.Injectable,[createInjectable,createPipe,createDirective,createComponent,createNgModule])}return StaticReflector.prototype.componentModuleUrl=function(typeOrFunc){var staticSymbol=this.findSymbolDeclaration(typeOrFunc);return this.symbolResolver.getResourcePath(staticSymbol)},StaticReflector.prototype.resolveExternalReference=function(ref,containingFile){var key=void 0;if(!containingFile){key=ref.moduleName+":"+ref.name;var declarationSymbol_1=this.resolvedExternalReferences.get(key);if(declarationSymbol_1)return declarationSymbol_1}var refSymbol=this.symbolResolver.getSymbolByModule(ref.moduleName,ref.name,containingFile),declarationSymbol=this.findSymbolDeclaration(refSymbol);return containingFile||(this.symbolResolver.recordModuleNameForFileName(refSymbol.filePath,ref.moduleName),this.symbolResolver.recordImportAs(declarationSymbol,refSymbol)),key&&this.resolvedExternalReferences.set(key,declarationSymbol),declarationSymbol},StaticReflector.prototype.findDeclaration=function(moduleUrl,name,containingFile){return this.findSymbolDeclaration(this.symbolResolver.getSymbolByModule(moduleUrl,name,containingFile))},StaticReflector.prototype.tryFindDeclaration=function(moduleUrl,name){var _this=this;return this.symbolResolver.ignoreErrorsFor(function(){return _this.findDeclaration(moduleUrl,name)})},StaticReflector.prototype.findSymbolDeclaration=function(symbol){var resolvedSymbol=this.symbolResolver.resolveSymbol(symbol);if(resolvedSymbol){var resolvedMetadata=resolvedSymbol.metadata;if(resolvedMetadata&&"resolved"===resolvedMetadata.__symbolic&&(resolvedMetadata=resolvedMetadata.symbol),resolvedMetadata instanceof StaticSymbol)return this.findSymbolDeclaration(resolvedSymbol.metadata)}return symbol},StaticReflector.prototype.annotations=function(type){var annotations=this.annotationCache.get(type);if(!annotations){annotations=[];var classMetadata=this.getTypeMetadata(type),parentType=this.findParentType(type,classMetadata);if(parentType){var parentAnnotations=this.annotations(parentType);annotations.push.apply(annotations,parentAnnotations)}var ownAnnotations_1=[];if(classMetadata.decorators&&(ownAnnotations_1=this.simplify(type,classMetadata.decorators),annotations.push.apply(annotations,ownAnnotations_1)),parentType&&!this.summaryResolver.isLibraryFile(type.filePath)&&this.summaryResolver.isLibraryFile(parentType.filePath)){var summary=this.summaryResolver.resolveSummary(parentType);if(summary&&summary.type){var requiredAnnotationTypes=this.annotationForParentClassWithSummaryKind.get(summary.type.summaryKind);requiredAnnotationTypes.some(function(requiredType){return ownAnnotations_1.some(function(ann){return requiredType.isTypeOf(ann)})})||this.reportError(formatMetadataError(metadataError("Class "+type.name+" in "+type.filePath+" extends from a "+CompileSummaryKind[summary.type.summaryKind]+" in another compilation unit without duplicating the decorator",void 0,"Please add a "+requiredAnnotationTypes.map(function(type){return type.ngMetadataName}).join(" or ")+" decorator to the class"),type),type)}}this.annotationCache.set(type,annotations.filter(function(ann){return!!ann}))}return annotations},StaticReflector.prototype.propMetadata=function(type){var _this=this,propMetadata=this.propertyCache.get(type);if(!propMetadata){var classMetadata=this.getTypeMetadata(type);propMetadata={};var parentType=this.findParentType(type,classMetadata);if(parentType){var parentPropMetadata_1=this.propMetadata(parentType);Object.keys(parentPropMetadata_1).forEach(function(parentProp){propMetadata[parentProp]=parentPropMetadata_1[parentProp]})}var members_1=classMetadata.members||{};Object.keys(members_1).forEach(function(propName){var propData=members_1[propName],prop=propData.find(function(a){return"property"==a.__symbolic||"method"==a.__symbolic}),decorators=[];propMetadata[propName]&&decorators.push.apply(decorators,propMetadata[propName]),propMetadata[propName]=decorators,prop&&prop.decorators&&decorators.push.apply(decorators,_this.simplify(type,prop.decorators))}),this.propertyCache.set(type,propMetadata)}return propMetadata},StaticReflector.prototype.parameters=function(type){var _this=this;if(!(type instanceof StaticSymbol))return this.reportError(new Error("parameters received "+JSON.stringify(type)+" which is not a StaticSymbol"),type),[];try{var parameters_1=this.parameterCache.get(type);if(!parameters_1){var classMetadata=this.getTypeMetadata(type),parentType=this.findParentType(type,classMetadata),members=classMetadata?classMetadata.members:null,ctorData=members?members.__ctor__:null;if(ctorData){var ctor=ctorData.find(function(a){return"constructor"==a.__symbolic}),rawParameterTypes=ctor.parameters||[],parameterDecorators_1=this.simplify(type,ctor.parameterDecorators||[]);parameters_1=[],rawParameterTypes.forEach(function(rawParamType,index){var nestedResult=[],paramType=_this.trySimplify(type,rawParamType);paramType&&nestedResult.push(paramType);var decorators=parameterDecorators_1?parameterDecorators_1[index]:null;decorators&&nestedResult.push.apply(nestedResult,decorators),parameters_1.push(nestedResult)})}else parentType&&(parameters_1=this.parameters(parentType));parameters_1||(parameters_1=[]),this.parameterCache.set(type,parameters_1)}return parameters_1}catch(e){throw console.error("Failed on type "+JSON.stringify(type)+" with error "+e),e}},StaticReflector.prototype._methodNames=function(type){var methodNames=this.methodCache.get(type);if(!methodNames){var classMetadata=this.getTypeMetadata(type);methodNames={};var parentType=this.findParentType(type,classMetadata)
;if(parentType){var parentMethodNames_1=this._methodNames(parentType);Object.keys(parentMethodNames_1).forEach(function(parentProp){methodNames[parentProp]=parentMethodNames_1[parentProp]})}var members_2=classMetadata.members||{};Object.keys(members_2).forEach(function(propName){var propData=members_2[propName],isMethod=propData.some(function(a){return"method"==a.__symbolic});methodNames[propName]=methodNames[propName]||isMethod}),this.methodCache.set(type,methodNames)}return methodNames},StaticReflector.prototype._staticMembers=function(type){var staticMembers=this.staticCache.get(type);if(!staticMembers){var classMetadata=this.getTypeMetadata(type),staticMemberData=classMetadata.statics||{};staticMembers=Object.keys(staticMemberData),this.staticCache.set(type,staticMembers)}return staticMembers},StaticReflector.prototype.findParentType=function(type,classMetadata){var parentType=this.trySimplify(type,classMetadata.extends);if(parentType instanceof StaticSymbol)return parentType},StaticReflector.prototype.hasLifecycleHook=function(type,lcProperty){type instanceof StaticSymbol||this.reportError(new Error("hasLifecycleHook received "+JSON.stringify(type)+" which is not a StaticSymbol"),type);try{return!!this._methodNames(type)[lcProperty]}catch(e){throw console.error("Failed on type "+JSON.stringify(type)+" with error "+e),e}},StaticReflector.prototype.guards=function(type){if(!(type instanceof StaticSymbol))return this.reportError(new Error("guards received "+JSON.stringify(type)+" which is not a StaticSymbol"),type),{};for(var staticMembers=this._staticMembers(type),result={},_i=0,staticMembers_1=staticMembers;_i<staticMembers_1.length;_i++){var name_1=staticMembers_1[_i];if(name_1.endsWith("TypeGuard")){var property=name_1.substr(0,name_1.length-"TypeGuard".length),value=void 0;property.endsWith("UseIf")?(property=name_1.substr(0,property.length-"UseIf".length),value="UseIf"):value=this.getStaticSymbol(type.filePath,type.name,[name_1]),result[property]=value}}return result},StaticReflector.prototype._registerDecoratorOrConstructor=function(type,ctor){this.conversionMap.set(type,function(context,args){return new(ctor.bind.apply(ctor,[void 0].concat(args)))})},StaticReflector.prototype._registerFunction=function(type,fn){this.conversionMap.set(type,function(context,args){return fn.apply(void 0,args)})},StaticReflector.prototype.initializeConversionMap=function(){this.injectionToken=this.findDeclaration(ANGULAR_CORE,"InjectionToken"),this.opaqueToken=this.findDeclaration(ANGULAR_CORE,"OpaqueToken"),this.ROUTES=this.tryFindDeclaration("@angular/router","ROUTES"),this.ANALYZE_FOR_ENTRY_COMPONENTS=this.findDeclaration(ANGULAR_CORE,"ANALYZE_FOR_ENTRY_COMPONENTS"),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Host"),createHost),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Injectable"),createInjectable),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Self"),createSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"SkipSelf"),createSkipSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Inject"),createInject),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Optional"),createOptional),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Attribute"),createAttribute),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ContentChild"),createContentChild),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ContentChildren"),createContentChildren),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ViewChild"),createViewChild),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ViewChildren"),createViewChildren),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Input"),createInput),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Output"),createOutput),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Pipe"),createPipe),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"HostBinding"),createHostBinding),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"HostListener"),createHostListener),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Directive"),createDirective),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Component"),createComponent),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"NgModule"),createNgModule),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Host"),createHost),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Self"),createSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"SkipSelf"),createSkipSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Optional"),createOptional)},StaticReflector.prototype.getStaticSymbol=function(declarationFile,name,members){return this.symbolResolver.getStaticSymbol(declarationFile,name,members)},StaticReflector.prototype.trySimplify=function(context,value){var originalRecorder=this.errorRecorder;this.errorRecorder=function(error,fileName){};var result=this.simplify(context,value);return this.errorRecorder=originalRecorder,result},StaticReflector.prototype.simplify=function(context,value){function simplifyInContext(context,value,depth,references){function resolveReferenceValue(staticSymbol){var resolvedSymbol=self.symbolResolver.resolveSymbol(staticSymbol);return resolvedSymbol?resolvedSymbol.metadata:null}function simplifyEagerly(value){return simplifyInContext(context,value,depth,0)}function simplifyLazily(value){return simplifyInContext(context,value,depth,references+1)}function simplifyNested(nestedContext,value){if(nestedContext===context)return simplifyInContext(nestedContext,value,depth+1,references);try{return simplifyInContext(nestedContext,value,depth+1,references)}catch(e){if(!isMetadataError(e))throw e;var summaryMsg=e.chain?"references '"+e.symbol.name+"'":errorSummary(e),summary="'"+nestedContext.name+"' "+summaryMsg,chain={message:summary,position:e.position,next:e.chain};self.error({message:e.message,advise:e.advise,context:e.context,chain:chain,symbol:nestedContext},context)}}function simplifyCall(functionSymbol,targetFunction,args,targetExpression){if(targetFunction&&"function"==targetFunction.__symbolic){calling.get(functionSymbol)&&self.error({message:"Recursion is not supported",summary:"called '"+functionSymbol.name+"' recursively",value:targetFunction},functionSymbol);try{var value_1=targetFunction.value;if(value_1&&(0!=depth||"error"!=value_1.__symbolic)){var parameters=targetFunction.parameters,defaults=targetFunction.defaults;args=args.map(function(arg){return simplifyNested(context,arg)}).map(function(arg){return shouldIgnore(arg)?void 0:arg}),defaults&&defaults.length>args.length&&args.push.apply(args,defaults.slice(args.length).map(function(value){return simplify(value)})),calling.set(functionSymbol,!0);for(var functionScope=BindingScope.build(),i=0;i<parameters.length;i++)functionScope.define(parameters[i],args[i]);var result_1,oldScope=scope;try{scope=functionScope.done(),result_1=simplifyNested(functionSymbol,value_1)}finally{scope=oldScope}return result_1}}finally{calling.delete(functionSymbol)}}if(0===depth)return IGNORE;var position=void 0;if(targetExpression&&"resolved"==targetExpression.__symbolic){var line=targetExpression.line,character=targetExpression.character,fileName=targetExpression.fileName;null!=fileName&&null!=line&&null!=character&&(position={fileName:fileName,line:line,column:character})}self.error({message:FUNCTION_CALL_NOT_SUPPORTED,context:functionSymbol,value:targetFunction,position:position},context)}function simplify(expression){if(isPrimitive(expression))return expression;if(expression instanceof Array){for(var result_2=[],_i=0,_a=expression;_i<_a.length;_i++){var item=_a[_i];if(item&&"spread"===item.__symbolic){var spreadArray=simplifyEagerly(item.expression);if(Array.isArray(spreadArray)){for(var _b=0,spreadArray_1=spreadArray;_b<spreadArray_1.length;_b++){var spreadItem=spreadArray_1[_b];result_2.push(spreadItem)}continue}}var value_2=simplify(item);shouldIgnore(value_2)||result_2.push(value_2)}return result_2}if(expression instanceof StaticSymbol){if(expression===self.injectionToken||self.conversionMap.has(expression)||references>0&&!expression.members.length)return expression;var staticSymbol=expression,declarationValue=resolveReferenceValue(staticSymbol);return null!=declarationValue?simplifyNested(staticSymbol,declarationValue):staticSymbol}if(expression){if(expression.__symbolic){var staticSymbol=void 0;switch(expression.__symbolic){case"binop":var left=simplify(expression.left);if(shouldIgnore(left))return left;var right=simplify(expression.right);if(shouldIgnore(right))return right;switch(expression.operator){case"&&":return left&&right;case"||":return left||right;case"|":return left|right;case"^":return left^right;case"&":return left&right;case"==":return left==right;case"!=":return left!=right;case"===":return left===right;case"!==":return left!==right;case"<":return left<right;case">":return left>right;case"<=":return left<=right;case">=":return left>=right;case"<<":return left<<right;case">>":return left>>right;case"+":return left+right;case"-":return left-right;case"*":return left*right;case"/":return left/right;case"%":return left%right}return null;case"if":return simplify(simplify(expression.condition)?expression.thenExpression:expression.elseExpression);case"pre":var operand=simplify(expression.operand);if(shouldIgnore(operand))return operand;switch(expression.operator){case"+":return operand;case"-":return-operand;case"!":return!operand;case"~":return~operand}return null;case"index":var indexTarget=simplifyEagerly(expression.expression),index=simplifyEagerly(expression.index);return indexTarget&&isPrimitive(index)?indexTarget[index]:null;case"select":var member=expression.member,selectContext=context,selectTarget=simplify(expression.expression);if(selectTarget instanceof StaticSymbol){var members=selectTarget.members.concat(member);selectContext=self.getStaticSymbol(selectTarget.filePath,selectTarget.name,members);var declarationValue=resolveReferenceValue(selectContext);return null!=declarationValue?simplifyNested(selectContext,declarationValue):selectContext}return selectTarget&&isPrimitive(member)?simplifyNested(selectContext,selectTarget[member]):null;case"reference":var name_2=expression.name,localValue=scope.resolve(name_2);if(localValue!=BindingScope.missing)return localValue;break;case"resolved":try{return simplify(expression.symbol)}catch(e){throw isMetadataError(e)&&null!=expression.fileName&&null!=expression.line&&null!=expression.character&&(e.position={fileName:expression.fileName,line:expression.line,column:expression.character}),e}case"class":case"function":return context;case"new":case"call":if((staticSymbol=simplifyInContext(context,expression.expression,depth+1,0))instanceof StaticSymbol){if(staticSymbol===self.injectionToken||staticSymbol===self.opaqueToken)return context;var argExpressions=expression.arguments||[],converter=self.conversionMap.get(staticSymbol);if(converter){var args=argExpressions.map(function(arg){return simplifyNested(context,arg)}).map(function(arg){return shouldIgnore(arg)?void 0:arg});return converter(context,args)}return simplifyCall(staticSymbol,resolveReferenceValue(staticSymbol),argExpressions,expression.expression)}return IGNORE;case"error":var message=expression.message;return null!=expression.line?self.error({message:message,context:expression.context,value:expression,position:{fileName:expression.fileName,line:expression.line,column:expression.character}},context):self.error({message:message,context:expression.context},context),IGNORE;case"ignore":return expression}return null}return mapStringMap(expression,function(value,name){if(REFERENCE_SET.has(name)){if(name===USE_VALUE&&PROVIDE in expression){var provide=simplify(expression.provide);if(provide===self.ROUTES||provide==self.ANALYZE_FOR_ENTRY_COMPONENTS)return simplify(value)}return simplifyLazily(value)}return simplify(value)})}return IGNORE}return simplify(value)}var result,self=this,scope=BindingScope.empty,calling=new Map;try{result=simplifyInContext(context,value,0,0)}catch(e){if(!this.errorRecorder)throw formatMetadataError(e,context);this.reportError(e,context)}if(!shouldIgnore(result))return result},StaticReflector.prototype.getTypeMetadata=function(type){var resolvedSymbol=this.symbolResolver.resolveSymbol(type);return resolvedSymbol&&resolvedSymbol.metadata?resolvedSymbol.metadata:{__symbolic:"class"}},StaticReflector.prototype.reportError=function(error,context,path$$1){if(!this.errorRecorder)throw error;this.errorRecorder(formatMetadataError(error,context),context&&context.filePath||path$$1)},StaticReflector.prototype.error=function(_a,reportingContext){var message=_a.message,summary=_a.summary,advise=_a.advise,position=_a.position,context=_a.context,symbol=(_a.value,_a.symbol),chain=_a.chain;this.reportError(metadataError(message,summary,advise,position,symbol,context,chain),reportingContext)},StaticReflector}(),METADATA_ERROR="ngMetadataError",REFERENCE_TO_NONEXPORTED_CLASS="Reference to non-exported class",VARIABLE_NOT_INITIALIZED="Variable not initialized",DESTRUCTURE_NOT_SUPPORTED="Destructuring not supported",COULD_NOT_RESOLVE_TYPE="Could not resolve type",FUNCTION_CALL_NOT_SUPPORTED="Function call not supported",REFERENCE_TO_LOCAL_SYMBOL="Reference to a local symbol",LAMBDA_NOT_SUPPORTED="Lambda not supported",BindingScope=function(){function BindingScope(){}return BindingScope.build=function(){var current=new Map;return{define:function(name,value){return current.set(name,value),this},done:function(){return current.size>0?new PopulatedScope(current):BindingScope.empty}}},BindingScope.missing={},BindingScope.empty={resolve:function(name){return BindingScope.missing}},BindingScope}(),PopulatedScope=function(_super){function PopulatedScope(bindings){var _this=_super.call(this)||this;return _this.bindings=bindings,_this}return __extends(PopulatedScope,_super),PopulatedScope.prototype.resolve=function(name){return this.bindings.has(name)?this.bindings.get(name):BindingScope.missing},PopulatedScope}(BindingScope),AotSummaryResolver=function(){function AotSummaryResolver(host,staticSymbolCache){this.host=host,this.staticSymbolCache=staticSymbolCache,this.summaryCache=new Map,this.loadedFilePaths=new Map,this.importAs=new Map,this.knownFileNameToModuleNames=new Map}return AotSummaryResolver.prototype.isLibraryFile=function(filePath){return!this.host.isSourceFile(stripGeneratedFileSuffix(filePath))},AotSummaryResolver.prototype.toSummaryFileName=function(filePath,referringSrcFileName){return this.host.toSummaryFileName(filePath,referringSrcFileName)},AotSummaryResolver.prototype.fromSummaryFileName=function(fileName,referringLibFileName){return this.host.fromSummaryFileName(fileName,referringLibFileName)},AotSummaryResolver.prototype.resolveSummary=function(staticSymbol){var rootSymbol=staticSymbol.members.length?this.staticSymbolCache.get(staticSymbol.filePath,staticSymbol.name):staticSymbol,summary=this.summaryCache.get(rootSymbol);return summary||(this._loadSummaryFile(staticSymbol.filePath),summary=this.summaryCache.get(staticSymbol)),rootSymbol===staticSymbol&&summary||null},AotSummaryResolver.prototype.getSymbolsOf=function(filePath){return this._loadSummaryFile(filePath)?Array.from(this.summaryCache.keys()).filter(function(symbol){return symbol.filePath===filePath}):null},AotSummaryResolver.prototype.getImportAs=function(staticSymbol){return staticSymbol.assertNoMembers(),this.importAs.get(staticSymbol)},AotSummaryResolver.prototype.getKnownModuleName=function(importedFilePath){return this.knownFileNameToModuleNames.get(importedFilePath)||null},AotSummaryResolver.prototype.addSummary=function(summary){this.summaryCache.set(summary.symbol,summary)},AotSummaryResolver.prototype._loadSummaryFile=function(filePath){var _this=this,hasSummary=this.loadedFilePaths.get(filePath);if(null!=hasSummary)return hasSummary;var json=null;if(this.isLibraryFile(filePath)){var summaryFilePath=summaryFileName(filePath);try{json=this.host.loadSummary(summaryFilePath)}catch(e){throw console.error("Error loading summary file "+summaryFilePath),e}}if(hasSummary=null!=json,this.loadedFilePaths.set(filePath,hasSummary),json){var _a=deserializeSummaries(this.staticSymbolCache,this,filePath,json),moduleName=_a.moduleName,summaries=_a.summaries,importAs=_a.importAs;summaries.forEach(function(summary){return _this.summaryCache.set(summary.symbol,summary)}),moduleName&&this.knownFileNameToModuleNames.set(filePath,moduleName),importAs.forEach(function(importAs){_this.importAs.set(importAs.symbol,importAs.importAs)})}return hasSummary},AotSummaryResolver}(),SummaryResolver=function(){function SummaryResolver(){}return SummaryResolver}(),JitSummaryResolver=function(){function JitSummaryResolver(){this._summaries=new Map}return JitSummaryResolver.prototype.isLibraryFile=function(){return!1},JitSummaryResolver.prototype.toSummaryFileName=function(fileName){return fileName},JitSummaryResolver.prototype.fromSummaryFileName=function(fileName){return fileName},JitSummaryResolver.prototype.resolveSummary=function(reference){return this._summaries.get(reference)||null},JitSummaryResolver.prototype.getSymbolsOf=function(){return[]},JitSummaryResolver.prototype.getImportAs=function(reference){return reference},JitSummaryResolver.prototype.getKnownModuleName=function(fileName){return null},JitSummaryResolver.prototype.addSummary=function(summary){this._summaries.set(summary.symbol,summary)},JitSummaryResolver}(),_ExecutionContext=function(){function _ExecutionContext(parent,instance,className,vars){this.parent=parent,this.instance=instance,this.className=className,this.vars=vars,this.exports=[]}return _ExecutionContext.prototype.createChildWihtLocalVars=function(){return new _ExecutionContext(this,this.instance,this.className,new Map)},_ExecutionContext}(),ReturnValue=function(){function ReturnValue(value){this.value=value}return ReturnValue}(),StatementInterpreter=function(){function StatementInterpreter(reflector){this.reflector=reflector}return StatementInterpreter.prototype.debugAst=function(ast){return debugOutputAstAsTypeScript(ast)},StatementInterpreter.prototype.visitDeclareVarStmt=function(stmt,ctx){return ctx.vars.set(stmt.name,stmt.value.visitExpression(this,ctx)),stmt.hasModifier(StmtModifier.Exported)&&ctx.exports.push(stmt.name),null},StatementInterpreter.prototype.visitWriteVarExpr=function(expr,ctx){for(var value=expr.value.visitExpression(this,ctx),currCtx=ctx;null!=currCtx;){if(currCtx.vars.has(expr.name))return currCtx.vars.set(expr.name,value),value;currCtx=currCtx.parent}throw new Error("Not declared variable "+expr.name)},StatementInterpreter.prototype.visitReadVarExpr=function(ast,ctx){var varName=ast.name;if(null!=ast.builtin)switch(ast.builtin){case BuiltinVar.Super:return ctx.instance.__proto__;case BuiltinVar.This:return ctx.instance;case BuiltinVar.CatchError:varName=CATCH_ERROR_VAR$2;break;case BuiltinVar.CatchStack:varName=CATCH_STACK_VAR$2;break;default:throw new Error("Unknown builtin variable "+ast.builtin)}for(var currCtx=ctx;null!=currCtx;){if(currCtx.vars.has(varName))return currCtx.vars.get(varName);currCtx=currCtx.parent}throw new Error("Not declared variable "+varName)},StatementInterpreter.prototype.visitWriteKeyExpr=function(expr,ctx){var receiver=expr.receiver.visitExpression(this,ctx),index=expr.index.visitExpression(this,ctx),value=expr.value.visitExpression(this,ctx);return receiver[index]=value,value},StatementInterpreter.prototype.visitWritePropExpr=function(expr,ctx){var receiver=expr.receiver.visitExpression(this,ctx),value=expr.value.visitExpression(this,ctx);return receiver[expr.name]=value,value},StatementInterpreter.prototype.visitInvokeMethodExpr=function(expr,ctx){var result,receiver=expr.receiver.visitExpression(this,ctx),args=this.visitAllExpressions(expr.args,ctx);if(null!=expr.builtin)switch(expr.builtin){case BuiltinMethod.ConcatArray:result=receiver.concat.apply(receiver,args);break;case BuiltinMethod.SubscribeObservable:result=receiver.subscribe({next:args[0]});break;case BuiltinMethod.Bind:result=receiver.bind.apply(receiver,args);break;default:throw new Error("Unknown builtin method "+expr.builtin)}else result=receiver[expr.name].apply(receiver,args);return result},StatementInterpreter.prototype.visitInvokeFunctionExpr=function(stmt,ctx){var args=this.visitAllExpressions(stmt.args,ctx),fnExpr=stmt.fn;return fnExpr instanceof ReadVarExpr&&fnExpr.builtin===BuiltinVar.Super?(ctx.instance.constructor.prototype.constructor.apply(ctx.instance,args),null):stmt.fn.visitExpression(this,ctx).apply(null,args)},StatementInterpreter.prototype.visitReturnStmt=function(stmt,ctx){return new ReturnValue(stmt.value.visitExpression(this,ctx))},StatementInterpreter.prototype.visitDeclareClassStmt=function(stmt,ctx){var clazz=createDynamicClass(stmt,ctx,this);return ctx.vars.set(stmt.name,clazz),stmt.hasModifier(StmtModifier.Exported)&&ctx.exports.push(stmt.name),null},StatementInterpreter.prototype.visitExpressionStmt=function(stmt,ctx){return stmt.expr.visitExpression(this,ctx)},StatementInterpreter.prototype.visitIfStmt=function(stmt,ctx){return stmt.condition.visitExpression(this,ctx)?this.visitAllStatements(stmt.trueCase,ctx):null!=stmt.falseCase?this.visitAllStatements(stmt.falseCase,ctx):null},StatementInterpreter.prototype.visitTryCatchStmt=function(stmt,ctx){try{return this.visitAllStatements(stmt.bodyStmts,ctx)}catch(e){var childCtx=ctx.createChildWihtLocalVars();return childCtx.vars.set(CATCH_ERROR_VAR$2,e),childCtx.vars.set(CATCH_STACK_VAR$2,e.stack),this.visitAllStatements(stmt.catchStmts,childCtx)}},StatementInterpreter.prototype.visitThrowStmt=function(stmt,ctx){throw stmt.error.visitExpression(this,ctx)},StatementInterpreter.prototype.visitCommentStmt=function(stmt,context){return null},StatementInterpreter.prototype.visitInstantiateExpr=function(ast,ctx){var args=this.visitAllExpressions(ast.args,ctx),clazz=ast.classExpr.visitExpression(this,ctx);return new(clazz.bind.apply(clazz,[void 0].concat(args)))},StatementInterpreter.prototype.visitLiteralExpr=function(ast,ctx){return ast.value},StatementInterpreter.prototype.visitExternalExpr=function(ast,ctx){return this.reflector.resolveExternalReference(ast.value)},StatementInterpreter.prototype.visitConditionalExpr=function(ast,ctx){return ast.condition.visitExpression(this,ctx)?ast.trueCase.visitExpression(this,ctx):null!=ast.falseCase?ast.falseCase.visitExpression(this,ctx):null},StatementInterpreter.prototype.visitNotExpr=function(ast,ctx){return!ast.condition.visitExpression(this,ctx)},StatementInterpreter.prototype.visitAssertNotNullExpr=function(ast,ctx){return ast.condition.visitExpression(this,ctx)},StatementInterpreter.prototype.visitCastExpr=function(ast,ctx){return ast.value.visitExpression(this,ctx)},StatementInterpreter.prototype.visitFunctionExpr=function(ast,ctx){return _declareFn(ast.params.map(function(param){return param.name}),ast.statements,ctx,this)},StatementInterpreter.prototype.visitDeclareFunctionStmt=function(stmt,ctx){var paramNames=stmt.params.map(function(param){return param.name});return ctx.vars.set(stmt.name,_declareFn(paramNames,stmt.statements,ctx,this)),stmt.hasModifier(StmtModifier.Exported)&&ctx.exports.push(stmt.name),null},StatementInterpreter.prototype.visitBinaryOperatorExpr=function(ast,ctx){var _this=this,lhs=function(){return ast.lhs.visitExpression(_this,ctx)},rhs=function(){return ast.rhs.visitExpression(_this,ctx)};switch(ast.operator){case BinaryOperator.Equals:return lhs()==rhs();case BinaryOperator.Identical:return lhs()===rhs();case BinaryOperator.NotEquals:return lhs()!=rhs();case BinaryOperator.NotIdentical:return lhs()!==rhs();case BinaryOperator.And:return lhs()&&rhs();case BinaryOperator.Or:return lhs()||rhs();case BinaryOperator.Plus:return lhs()+rhs();case BinaryOperator.Minus:return lhs()-rhs();case BinaryOperator.Divide:return lhs()/rhs();case BinaryOperator.Multiply:return lhs()*rhs();case BinaryOperator.Modulo:return lhs()%rhs();case BinaryOperator.Lower:return lhs()<rhs();case BinaryOperator.LowerEquals:return lhs()<=rhs();case BinaryOperator.Bigger:return lhs()>rhs();case BinaryOperator.BiggerEquals:return lhs()>=rhs();default:throw new Error("Unknown operator "+ast.operator)}},StatementInterpreter.prototype.visitReadPropExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx)[ast.name]},StatementInterpreter.prototype.visitReadKeyExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx)[ast.index.visitExpression(this,ctx)]},StatementInterpreter.prototype.visitLiteralArrayExpr=function(ast,ctx){return this.visitAllExpressions(ast.entries,ctx)},StatementInterpreter.prototype.visitLiteralMapExpr=function(ast,ctx){var _this=this,result={};return ast.entries.forEach(function(entry){return result[entry.key]=entry.value.visitExpression(_this,ctx)}),result},StatementInterpreter.prototype.visitCommaExpr=function(ast,context){var values=this.visitAllExpressions(ast.parts,context);return values[values.length-1]},StatementInterpreter.prototype.visitAllExpressions=function(expressions,ctx){var _this=this;return expressions.map(function(expr){return expr.visitExpression(_this,ctx)})},StatementInterpreter.prototype.visitAllStatements=function(statements,ctx){for(var i=0;i<statements.length;i++){var stmt=statements[i],val=stmt.visitStatement(this,ctx);if(val instanceof ReturnValue)return val}return null},StatementInterpreter}(),CATCH_ERROR_VAR$2="error",CATCH_STACK_VAR$2="stack",AbstractJsEmitterVisitor=function(_super){function AbstractJsEmitterVisitor(){return _super.call(this,!1)||this}return __extends(AbstractJsEmitterVisitor,_super),AbstractJsEmitterVisitor.prototype.visitDeclareClassStmt=function(stmt,ctx){var _this=this;return ctx.pushClass(stmt),this._visitClassConstructor(stmt,ctx),null!=stmt.parent&&(ctx.print(stmt,stmt.name+".prototype = Object.create("),stmt.parent.visitExpression(this,ctx),ctx.println(stmt,".prototype);")),stmt.getters.forEach(function(getter){return _this._visitClassGetter(stmt,getter,ctx)}),stmt.methods.forEach(function(method){return _this._visitClassMethod(stmt,method,ctx)}),ctx.popClass(),null},AbstractJsEmitterVisitor.prototype._visitClassConstructor=function(stmt,ctx){ctx.print(stmt,"function "+stmt.name+"("),null!=stmt.constructorMethod&&this._visitParams(stmt.constructorMethod.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),null!=stmt.constructorMethod&&stmt.constructorMethod.body.length>0&&(ctx.println(stmt,"var self = this;"),this.visitAllStatements(stmt.constructorMethod.body,ctx)),ctx.decIndent(),ctx.println(stmt,"}")},AbstractJsEmitterVisitor.prototype._visitClassGetter=function(stmt,getter,ctx){ctx.println(stmt,"Object.defineProperty("+stmt.name+".prototype, '"+getter.name+"', { get: function() {"),ctx.incIndent(),getter.body.length>0&&(ctx.println(stmt,"var self = this;"),this.visitAllStatements(getter.body,ctx)),ctx.decIndent(),ctx.println(stmt,"}});")},AbstractJsEmitterVisitor.prototype._visitClassMethod=function(stmt,method,ctx){ctx.print(stmt,stmt.name+".prototype."+method.name+" = function("),this._visitParams(method.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),method.body.length>0&&(ctx.println(stmt,"var self = this;"),this.visitAllStatements(method.body,ctx)),ctx.decIndent(),ctx.println(stmt,"};")},AbstractJsEmitterVisitor.prototype.visitReadVarExpr=function(ast,ctx){if(ast.builtin===BuiltinVar.This)ctx.print(ast,"self");else{if(ast.builtin===BuiltinVar.Super)throw new Error("'super' needs to be handled at a parent ast node, not at the variable level!");_super.prototype.visitReadVarExpr.call(this,ast,ctx)}return null},AbstractJsEmitterVisitor.prototype.visitDeclareVarStmt=function(stmt,ctx){return ctx.print(stmt,"var "+stmt.name+" = "),stmt.value.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractJsEmitterVisitor.prototype.visitCastExpr=function(ast,ctx){return ast.value.visitExpression(this,ctx),null},AbstractJsEmitterVisitor.prototype.visitInvokeFunctionExpr=function(expr,ctx){var fnExpr=expr.fn;return fnExpr instanceof ReadVarExpr&&fnExpr.builtin===BuiltinVar.Super?(ctx.currentClass.parent.visitExpression(this,ctx),ctx.print(expr,".call(this"),expr.args.length>0&&(ctx.print(expr,", "),this.visitAllExpressions(expr.args,ctx,",")),ctx.print(expr,")")):_super.prototype.visitInvokeFunctionExpr.call(this,expr,ctx),null},AbstractJsEmitterVisitor.prototype.visitFunctionExpr=function(ast,ctx){return ctx.print(ast,"function("),this._visitParams(ast.params,ctx),ctx.println(ast,") {"),ctx.incIndent(),this.visitAllStatements(ast.statements,ctx),ctx.decIndent(),ctx.print(ast,"}"),null},AbstractJsEmitterVisitor.prototype.visitDeclareFunctionStmt=function(stmt,ctx){return ctx.print(stmt,"function "+stmt.name+"("),this._visitParams(stmt.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),this.visitAllStatements(stmt.statements,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},AbstractJsEmitterVisitor.prototype.visitTryCatchStmt=function(stmt,ctx){ctx.println(stmt,"try {"),ctx.incIndent(),this.visitAllStatements(stmt.bodyStmts,ctx),ctx.decIndent(),ctx.println(stmt,"} catch ("+CATCH_ERROR_VAR$1.name+") {"),ctx.incIndent();var catchStmts=[CATCH_STACK_VAR$1.set(CATCH_ERROR_VAR$1.prop("stack")).toDeclStmt(null,[StmtModifier.Final])].concat(stmt.catchStmts);return this.visitAllStatements(catchStmts,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},AbstractJsEmitterVisitor.prototype._visitParams=function(params,ctx){this.visitAllObjects(function(param){return ctx.print(null,param.name)},params,ctx,",")},AbstractJsEmitterVisitor.prototype.getBuiltinMethodName=function(method){var name;switch(method){case BuiltinMethod.ConcatArray:name="concat";break;case BuiltinMethod.SubscribeObservable:name="subscribe";break;case BuiltinMethod.Bind:name="bind";break;default:throw new Error("Unknown builtin method: "+method)}return name},AbstractJsEmitterVisitor}(AbstractEmitterVisitor),JitEmitterVisitor=function(_super){function JitEmitterVisitor(reflector){var _this=_super.call(this)||this;return _this.reflector=reflector,_this._evalArgNames=[],_this._evalArgValues=[],_this._evalExportedVars=[],_this}return __extends(JitEmitterVisitor,_super),JitEmitterVisitor.prototype.createReturnStmt=function(ctx){new ReturnStatement(new LiteralMapExpr(this._evalExportedVars.map(function(resultVar){return new LiteralMapEntry(resultVar,variable(resultVar),!1)}))).visitStatement(this,ctx)},JitEmitterVisitor.prototype.getArgs=function(){for(var result={},i=0;i<this._evalArgNames.length;i++)result[this._evalArgNames[i]]=this._evalArgValues[i];return result},JitEmitterVisitor.prototype.visitExternalExpr=function(ast,ctx){var value=this.reflector.resolveExternalReference(ast.value),id=this._evalArgValues.indexOf(value);if(-1===id){id=this._evalArgValues.length,this._evalArgValues.push(value);var name_1=identifierName({reference:value})||"val";this._evalArgNames.push("jit_"+name_1+"_"+id)}return ctx.print(ast,this._evalArgNames[id]),null},JitEmitterVisitor.prototype.visitDeclareVarStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&this._evalExportedVars.push(stmt.name),_super.prototype.visitDeclareVarStmt.call(this,stmt,ctx)},JitEmitterVisitor.prototype.visitDeclareFunctionStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&this._evalExportedVars.push(stmt.name),_super.prototype.visitDeclareFunctionStmt.call(this,stmt,ctx)},JitEmitterVisitor.prototype.visitDeclareClassStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&this._evalExportedVars.push(stmt.name),_super.prototype.visitDeclareClassStmt.call(this,stmt,ctx)},
JitEmitterVisitor}(AbstractJsEmitterVisitor),JitCompiler=function(){function JitCompiler(_metadataResolver,_templateParser,_styleCompiler,_viewCompiler,_ngModuleCompiler,_summaryResolver,_reflector,_compilerConfig,_console,getExtraNgModuleProviders){this._metadataResolver=_metadataResolver,this._templateParser=_templateParser,this._styleCompiler=_styleCompiler,this._viewCompiler=_viewCompiler,this._ngModuleCompiler=_ngModuleCompiler,this._summaryResolver=_summaryResolver,this._reflector=_reflector,this._compilerConfig=_compilerConfig,this._console=_console,this.getExtraNgModuleProviders=getExtraNgModuleProviders,this._compiledTemplateCache=new Map,this._compiledHostTemplateCache=new Map,this._compiledDirectiveWrapperCache=new Map,this._compiledNgModuleCache=new Map,this._sharedStylesheetCount=0,this._addedAotSummaries=new Set}return JitCompiler.prototype.compileModuleSync=function(moduleType){return SyncAsync.assertSync(this._compileModuleAndComponents(moduleType,!0))},JitCompiler.prototype.compileModuleAsync=function(moduleType){return Promise.resolve(this._compileModuleAndComponents(moduleType,!1))},JitCompiler.prototype.compileModuleAndAllComponentsSync=function(moduleType){return SyncAsync.assertSync(this._compileModuleAndAllComponents(moduleType,!0))},JitCompiler.prototype.compileModuleAndAllComponentsAsync=function(moduleType){return Promise.resolve(this._compileModuleAndAllComponents(moduleType,!1))},JitCompiler.prototype.getComponentFactory=function(component){return this._metadataResolver.getDirectiveSummary(component).componentFactory},JitCompiler.prototype.loadAotSummaries=function(summaries){this.clearCache(),this._addAotSummaries(summaries)},JitCompiler.prototype._addAotSummaries=function(fn$$1){if(!this._addedAotSummaries.has(fn$$1)){this._addedAotSummaries.add(fn$$1);for(var summaries=fn$$1(),i=0;i<summaries.length;i++){var entry=summaries[i];if("function"==typeof entry)this._addAotSummaries(entry);else{var summary=entry;this._summaryResolver.addSummary({symbol:summary.type.reference,metadata:null,type:summary})}}}},JitCompiler.prototype.hasAotSummary=function(ref){return!!this._summaryResolver.resolveSummary(ref)},JitCompiler.prototype._filterJitIdentifiers=function(ids){var _this=this;return ids.map(function(mod){return mod.reference}).filter(function(ref){return!_this.hasAotSummary(ref)})},JitCompiler.prototype._compileModuleAndComponents=function(moduleType,isSync){var _this=this;return SyncAsync.then(this._loadModules(moduleType,isSync),function(){return _this._compileComponents(moduleType,null),_this._compileModule(moduleType)})},JitCompiler.prototype._compileModuleAndAllComponents=function(moduleType,isSync){var _this=this;return SyncAsync.then(this._loadModules(moduleType,isSync),function(){var componentFactories=[];return _this._compileComponents(moduleType,componentFactories),{ngModuleFactory:_this._compileModule(moduleType),componentFactories:componentFactories}})},JitCompiler.prototype._loadModules=function(mainModule,isSync){var _this=this,loading=[],mainNgModule=this._metadataResolver.getNgModuleMetadata(mainModule);return this._filterJitIdentifiers(mainNgModule.transitiveModule.modules).forEach(function(nestedNgModule){var moduleMeta=_this._metadataResolver.getNgModuleMetadata(nestedNgModule);_this._filterJitIdentifiers(moduleMeta.declaredDirectives).forEach(function(ref){var promise=_this._metadataResolver.loadDirectiveMetadata(moduleMeta.type.reference,ref,isSync);promise&&loading.push(promise)}),_this._filterJitIdentifiers(moduleMeta.declaredPipes).forEach(function(ref){return _this._metadataResolver.getOrLoadPipeMetadata(ref)})}),SyncAsync.all(loading)},JitCompiler.prototype._compileModule=function(moduleType){var ngModuleFactory=this._compiledNgModuleCache.get(moduleType);if(!ngModuleFactory){var moduleMeta=this._metadataResolver.getNgModuleMetadata(moduleType),extraProviders=this.getExtraNgModuleProviders(moduleMeta.type.reference),outputCtx=createOutputContext(),compileResult=this._ngModuleCompiler.compile(outputCtx,moduleMeta,extraProviders);ngModuleFactory=this._interpretOrJit(ngModuleJitUrl(moduleMeta),outputCtx.statements)[compileResult.ngModuleFactoryVar],this._compiledNgModuleCache.set(moduleMeta.type.reference,ngModuleFactory)}return ngModuleFactory},JitCompiler.prototype._compileComponents=function(mainModule,allComponentFactories){var _this=this,ngModule=this._metadataResolver.getNgModuleMetadata(mainModule),moduleByJitDirective=new Map,templates=new Set,transJitModules=this._filterJitIdentifiers(ngModule.transitiveModule.modules);transJitModules.forEach(function(localMod){var localModuleMeta=_this._metadataResolver.getNgModuleMetadata(localMod);_this._filterJitIdentifiers(localModuleMeta.declaredDirectives).forEach(function(dirRef){moduleByJitDirective.set(dirRef,localModuleMeta);var dirMeta=_this._metadataResolver.getDirectiveMetadata(dirRef);if(dirMeta.isComponent&&(templates.add(_this._createCompiledTemplate(dirMeta,localModuleMeta)),allComponentFactories)){var template=_this._createCompiledHostTemplate(dirMeta.type.reference,localModuleMeta);templates.add(template),allComponentFactories.push(dirMeta.componentFactory)}})}),transJitModules.forEach(function(localMod){var localModuleMeta=_this._metadataResolver.getNgModuleMetadata(localMod);_this._filterJitIdentifiers(localModuleMeta.declaredDirectives).forEach(function(dirRef){var dirMeta=_this._metadataResolver.getDirectiveMetadata(dirRef);dirMeta.isComponent&&dirMeta.entryComponents.forEach(function(entryComponentType){var moduleMeta=moduleByJitDirective.get(entryComponentType.componentType);templates.add(_this._createCompiledHostTemplate(entryComponentType.componentType,moduleMeta))})}),localModuleMeta.entryComponents.forEach(function(entryComponentType){if(!_this.hasAotSummary(entryComponentType.componentType.reference)){var moduleMeta=moduleByJitDirective.get(entryComponentType.componentType);templates.add(_this._createCompiledHostTemplate(entryComponentType.componentType,moduleMeta))}})}),templates.forEach(function(template){return _this._compileTemplate(template)})},JitCompiler.prototype.clearCacheFor=function(type){this._compiledNgModuleCache.delete(type),this._metadataResolver.clearCacheFor(type),this._compiledHostTemplateCache.delete(type),this._compiledTemplateCache.get(type)&&this._compiledTemplateCache.delete(type)},JitCompiler.prototype.clearCache=function(){this._metadataResolver.clearCache(),this._compiledTemplateCache.clear(),this._compiledHostTemplateCache.clear(),this._compiledNgModuleCache.clear()},JitCompiler.prototype._createCompiledHostTemplate=function(compType,ngModule){if(!ngModule)throw new Error("Component "+stringify(compType)+" is not part of any NgModule or the module has not been imported into your module.");var compiledTemplate=this._compiledHostTemplateCache.get(compType);if(!compiledTemplate){var compMeta=this._metadataResolver.getDirectiveMetadata(compType);assertComponent(compMeta);var hostMeta=this._metadataResolver.getHostComponentMetadata(compMeta,compMeta.componentFactory.viewDefFactory);compiledTemplate=new CompiledTemplate(!0,compMeta.type,hostMeta,ngModule,[compMeta.type]),this._compiledHostTemplateCache.set(compType,compiledTemplate)}return compiledTemplate},JitCompiler.prototype._createCompiledTemplate=function(compMeta,ngModule){var compiledTemplate=this._compiledTemplateCache.get(compMeta.type.reference);return compiledTemplate||(assertComponent(compMeta),compiledTemplate=new CompiledTemplate(!1,compMeta.type,compMeta,ngModule,ngModule.transitiveModule.directives),this._compiledTemplateCache.set(compMeta.type.reference,compiledTemplate)),compiledTemplate},JitCompiler.prototype._compileTemplate=function(template){var _this=this;if(!template.isCompiled){var compMeta=template.compMeta,externalStylesheetsByModuleUrl=new Map,outputContext=createOutputContext(),componentStylesheet=this._styleCompiler.compileComponent(outputContext,compMeta);compMeta.template.externalStylesheets.forEach(function(stylesheetMeta){var compiledStylesheet=_this._styleCompiler.compileStyles(createOutputContext(),compMeta,stylesheetMeta);externalStylesheetsByModuleUrl.set(stylesheetMeta.moduleUrl,compiledStylesheet)}),this._resolveStylesCompileResult(componentStylesheet,externalStylesheetsByModuleUrl);var _a=(template.ngModule.transitiveModule.pipes.map(function(pipe){return _this._metadataResolver.getPipeSummary(pipe.reference)}),this._parseTemplate(compMeta,template.ngModule,template.directives)),parsedTemplate=_a.template,usedPipes=_a.pipes,compileResult=this._viewCompiler.compileComponent(outputContext,compMeta,parsedTemplate,variable(componentStylesheet.stylesVar),usedPipes),evalResult=this._interpretOrJit(templateJitUrl(template.ngModule.type,template.compMeta),outputContext.statements),viewClass=evalResult[compileResult.viewClassVar],rendererType=evalResult[compileResult.rendererTypeVar];template.compiled(viewClass,rendererType)}},JitCompiler.prototype._parseTemplate=function(compMeta,ngModule,directiveIdentifiers){var _this=this,preserveWhitespaces=compMeta.template.preserveWhitespaces,directives=directiveIdentifiers.map(function(dir){return _this._metadataResolver.getDirectiveSummary(dir.reference)}),pipes=ngModule.transitiveModule.pipes.map(function(pipe){return _this._metadataResolver.getPipeSummary(pipe.reference)});return this._templateParser.parse(compMeta,compMeta.template.htmlAst,directives,pipes,ngModule.schemas,templateSourceUrl(ngModule.type,compMeta,compMeta.template),preserveWhitespaces)},JitCompiler.prototype._resolveStylesCompileResult=function(result,externalStylesheetsByModuleUrl){var _this=this;result.dependencies.forEach(function(dep,i){var nestedCompileResult=externalStylesheetsByModuleUrl.get(dep.moduleUrl),nestedStylesArr=_this._resolveAndEvalStylesCompileResult(nestedCompileResult,externalStylesheetsByModuleUrl);dep.setValue(nestedStylesArr)})},JitCompiler.prototype._resolveAndEvalStylesCompileResult=function(result,externalStylesheetsByModuleUrl){return this._resolveStylesCompileResult(result,externalStylesheetsByModuleUrl),this._interpretOrJit(sharedStylesheetJitUrl(result.meta,this._sharedStylesheetCount++),result.outputCtx.statements)[result.stylesVar]},JitCompiler.prototype._interpretOrJit=function(sourceUrl,statements){return this._compilerConfig.useJit?jitStatements(sourceUrl,statements,this._reflector,this._compilerConfig.jitDevMode):interpretStatements(statements,this._reflector)},JitCompiler}(),CompiledTemplate=function(){function CompiledTemplate(isHost,compType,compMeta,ngModule,directives){this.isHost=isHost,this.compType=compType,this.compMeta=compMeta,this.ngModule=ngModule,this.directives=directives,this._viewClass=null,this.isCompiled=!1}return CompiledTemplate.prototype.compiled=function(viewClass,rendererType){this._viewClass=viewClass,this.compMeta.componentViewType.setDelegate(viewClass);for(var prop in rendererType)this.compMeta.rendererType[prop]=rendererType[prop];this.isCompiled=!0},CompiledTemplate}(),CompileReflector=function(){function CompileReflector(){}return CompileReflector}(),UrlResolver=function(){function UrlResolverImpl(_packagePrefix){void 0===_packagePrefix&&(_packagePrefix=null),this._packagePrefix=_packagePrefix}return UrlResolverImpl.prototype.resolve=function(baseUrl,url){var resolvedUrl=url;null!=baseUrl&&baseUrl.length>0&&(resolvedUrl=_resolveUrl(baseUrl,resolvedUrl));var resolvedParts=_split(resolvedUrl),prefix=this._packagePrefix;if(null!=prefix&&null!=resolvedParts&&"package"==resolvedParts[_ComponentIndex.Scheme]){var path$$1=resolvedParts[_ComponentIndex.Path];return prefix=prefix.replace(/\/+$/,""),path$$1=path$$1.replace(/^\/+/,""),prefix+"/"+path$$1}return resolvedUrl},UrlResolverImpl}(),_splitRe=new RegExp("^(?:([^:/?#.]+):)?(?://(?:([^/?#]*)@)?([\\w\\d\\-\\u0100-\\uffff.%]*)(?::([0-9]+))?)?([^?#]+)?(?:\\?([^#]*))?(?:#(.*))?$"),_ComponentIndex={Scheme:1,UserInfo:2,Domain:3,Port:4,Path:5,QueryData:6,Fragment:7};_ComponentIndex[_ComponentIndex.Scheme]="Scheme",_ComponentIndex[_ComponentIndex.UserInfo]="UserInfo",_ComponentIndex[_ComponentIndex.Domain]="Domain",_ComponentIndex[_ComponentIndex.Port]="Port",_ComponentIndex[_ComponentIndex.Path]="Path",_ComponentIndex[_ComponentIndex.QueryData]="QueryData",_ComponentIndex[_ComponentIndex.Fragment]="Fragment";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var ResourceLoader=function(){function ResourceLoader(){}return ResourceLoader.prototype.get=function(url){return""},ResourceLoader}(),Extractor=function(){function Extractor(host,staticSymbolResolver,messageBundle,metadataResolver){this.host=host,this.staticSymbolResolver=staticSymbolResolver,this.messageBundle=messageBundle,this.metadataResolver=metadataResolver}return Extractor.prototype.extract=function(rootFiles){var _this=this,_a=analyzeAndValidateNgModules(rootFiles,this.host,this.staticSymbolResolver,this.metadataResolver),files=_a.files,ngModules=_a.ngModules;return Promise.all(ngModules.map(function(ngModule){return _this.metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!1)})).then(function(){var errors=[];if(files.forEach(function(file){var compMetas=[];file.directives.forEach(function(directiveType){var dirMeta=_this.metadataResolver.getDirectiveMetadata(directiveType);dirMeta&&dirMeta.isComponent&&compMetas.push(dirMeta)}),compMetas.forEach(function(compMeta){var html=compMeta.template.template,interpolationConfig=InterpolationConfig.fromArray(compMeta.template.interpolation);errors.push.apply(errors,_this.messageBundle.updateFromTemplate(html,file.fileName,interpolationConfig))})}),errors.length)throw new Error(errors.map(function(e){return e.toString()}).join("\n"));return _this.messageBundle})},Extractor.create=function(host,locale){var htmlParser=new HtmlParser,urlResolver=createAotUrlResolver(host),symbolCache=new StaticSymbolCache,summaryResolver=new AotSummaryResolver(host,symbolCache),staticSymbolResolver=new StaticSymbolResolver(host,symbolCache,summaryResolver),staticReflector=new StaticReflector(summaryResolver,staticSymbolResolver),config=new CompilerConfig({defaultEncapsulation:ViewEncapsulation.Emulated,useJit:!1}),normalizer=new DirectiveNormalizer({get:function(url){return host.loadResource(url)}},urlResolver,htmlParser,config),elementSchemaRegistry=new DomElementSchemaRegistry,resolver=new CompileMetadataResolver(config,htmlParser,new NgModuleResolver(staticReflector),new DirectiveResolver(staticReflector),new PipeResolver(staticReflector),summaryResolver,elementSchemaRegistry,normalizer,console,symbolCache,staticReflector),messageBundle=new MessageBundle(htmlParser,[],{},locale);return{extractor:new Extractor(host,staticSymbolResolver,messageBundle,resolver),staticReflector:staticReflector}},Extractor}(),compiler=Object.freeze({core:core,CompilerConfig:CompilerConfig,preserveWhitespacesDefault:preserveWhitespacesDefault,isLoweredSymbol:isLoweredSymbol,createLoweredSymbol:createLoweredSymbol,Identifiers:Identifiers,JitCompiler:JitCompiler,DirectiveResolver:DirectiveResolver,PipeResolver:PipeResolver,NgModuleResolver:NgModuleResolver,DEFAULT_INTERPOLATION_CONFIG:DEFAULT_INTERPOLATION_CONFIG,InterpolationConfig:InterpolationConfig,NgModuleCompiler:NgModuleCompiler,AssertNotNull:AssertNotNull,BinaryOperator:BinaryOperator,BinaryOperatorExpr:BinaryOperatorExpr,BuiltinMethod:BuiltinMethod,BuiltinVar:BuiltinVar,CastExpr:CastExpr,ClassStmt:ClassStmt,CommaExpr:CommaExpr,CommentStmt:CommentStmt,ConditionalExpr:ConditionalExpr,DeclareFunctionStmt:DeclareFunctionStmt,DeclareVarStmt:DeclareVarStmt,ExpressionStatement:ExpressionStatement,ExternalExpr:ExternalExpr,ExternalReference:ExternalReference,FunctionExpr:FunctionExpr,IfStmt:IfStmt,InstantiateExpr:InstantiateExpr,InvokeFunctionExpr:InvokeFunctionExpr,InvokeMethodExpr:InvokeMethodExpr,LiteralArrayExpr:LiteralArrayExpr,LiteralExpr:LiteralExpr,LiteralMapExpr:LiteralMapExpr,NotExpr:NotExpr,ReadKeyExpr:ReadKeyExpr,ReadPropExpr:ReadPropExpr,ReadVarExpr:ReadVarExpr,ReturnStatement:ReturnStatement,ThrowStmt:ThrowStmt,TryCatchStmt:TryCatchStmt,WriteKeyExpr:WriteKeyExpr,WritePropExpr:WritePropExpr,WriteVarExpr:WriteVarExpr,StmtModifier:StmtModifier,Statement:Statement,collectExternalReferences:collectExternalReferences,EmitterVisitorContext:EmitterVisitorContext,ViewCompiler:ViewCompiler,getParseErrors:getParseErrors,isSyntaxError:isSyntaxError,syntaxError:syntaxError,Version:Version,VERSION:VERSION$1,TextAst:TextAst,BoundTextAst:BoundTextAst,AttrAst:AttrAst,BoundElementPropertyAst:BoundElementPropertyAst,BoundEventAst:BoundEventAst,ReferenceAst:ReferenceAst,VariableAst:VariableAst,ElementAst:ElementAst,EmbeddedTemplateAst:EmbeddedTemplateAst,BoundDirectivePropertyAst:BoundDirectivePropertyAst,DirectiveAst:DirectiveAst,ProviderAst:ProviderAst,ProviderAstType:ProviderAstType,NgContentAst:NgContentAst,PropertyBindingType:PropertyBindingType,NullTemplateVisitor:NullTemplateVisitor,RecursiveTemplateAstVisitor:RecursiveTemplateAstVisitor,templateVisitAll:templateVisitAll,identifierName:identifierName,identifierModuleUrl:identifierModuleUrl,viewClassName:viewClassName,rendererTypeName:rendererTypeName,hostViewClassName:hostViewClassName,componentFactoryName:componentFactoryName,CompileSummaryKind:CompileSummaryKind,tokenName:tokenName,tokenReference:tokenReference,CompileStylesheetMetadata:CompileStylesheetMetadata,CompileTemplateMetadata:CompileTemplateMetadata,CompileDirectiveMetadata:CompileDirectiveMetadata,CompilePipeMetadata:CompilePipeMetadata,CompileNgModuleMetadata:CompileNgModuleMetadata,TransitiveCompileNgModuleMetadata:TransitiveCompileNgModuleMetadata,ProviderMeta:ProviderMeta,flatten:flatten$1,templateSourceUrl:templateSourceUrl,sharedStylesheetJitUrl:sharedStylesheetJitUrl,ngModuleJitUrl:ngModuleJitUrl,templateJitUrl:templateJitUrl,createAotUrlResolver:createAotUrlResolver,createAotCompiler:createAotCompiler,AotCompiler:AotCompiler,analyzeNgModules:analyzeNgModules,analyzeAndValidateNgModules:analyzeAndValidateNgModules,analyzeFile:analyzeFile,mergeAnalyzedFiles:mergeAnalyzedFiles,GeneratedFile:GeneratedFile,toTypeScript:toTypeScript,formattedError:formattedError,isFormattedError:isFormattedError,StaticReflector:StaticReflector,StaticSymbol:StaticSymbol,StaticSymbolCache:StaticSymbolCache,ResolvedStaticSymbol:ResolvedStaticSymbol,StaticSymbolResolver:StaticSymbolResolver,unescapeIdentifier:unescapeIdentifier,unwrapResolvedMetadata:unwrapResolvedMetadata,AotSummaryResolver:AotSummaryResolver,AstPath:AstPath,SummaryResolver:SummaryResolver,JitSummaryResolver:JitSummaryResolver,CompileReflector:CompileReflector,createUrlResolverWithoutPackagePrefix:createUrlResolverWithoutPackagePrefix,createOfflineCompileUrlResolver:createOfflineCompileUrlResolver,UrlResolver:UrlResolver,getUrlScheme:getUrlScheme,ResourceLoader:ResourceLoader,ElementSchemaRegistry:ElementSchemaRegistry,Extractor:Extractor,I18NHtmlParser:I18NHtmlParser,MessageBundle:MessageBundle,Serializer:Serializer,Xliff:Xliff,Xliff2:Xliff2,Xmb:Xmb,Xtb:Xtb,DirectiveNormalizer:DirectiveNormalizer,ParserError:ParserError,ParseSpan:ParseSpan,AST:AST,Quote:Quote,EmptyExpr:EmptyExpr,ImplicitReceiver:ImplicitReceiver,Chain:Chain,Conditional:Conditional,PropertyRead:PropertyRead,PropertyWrite:PropertyWrite,SafePropertyRead:SafePropertyRead,KeyedRead:KeyedRead,KeyedWrite:KeyedWrite,BindingPipe:BindingPipe,LiteralPrimitive:LiteralPrimitive,LiteralArray:LiteralArray,LiteralMap:LiteralMap,Interpolation:Interpolation,Binary:Binary,PrefixNot:PrefixNot,NonNullAssert:NonNullAssert,MethodCall:MethodCall,SafeMethodCall:SafeMethodCall,FunctionCall:FunctionCall,ASTWithSource:ASTWithSource,TemplateBinding:TemplateBinding,NullAstVisitor:NullAstVisitor,RecursiveAstVisitor:RecursiveAstVisitor,AstTransformer:AstTransformer,visitAstChildren:visitAstChildren,TokenType:TokenType,Lexer:Lexer,Token:Token,EOF:EOF,isIdentifier:isIdentifier,isQuote:isQuote,SplitInterpolation:SplitInterpolation,TemplateBindingParseResult:TemplateBindingParseResult,Parser:Parser,_ParseAST:_ParseAST,ERROR_COMPONENT_TYPE:ERROR_COMPONENT_TYPE,CompileMetadataResolver:CompileMetadataResolver,Text:Text,Expansion:Expansion,ExpansionCase:ExpansionCase,Attribute:Attribute$1,Element:Element,Comment:Comment,visitAll:visitAll,RecursiveVisitor:RecursiveVisitor,findNode:findNode,ParseTreeResult:ParseTreeResult,TreeError:TreeError,HtmlParser:HtmlParser,HtmlTagDefinition:HtmlTagDefinition,getHtmlTagDefinition:getHtmlTagDefinition,TagContentType:TagContentType,splitNsName:splitNsName,isNgContainer:isNgContainer,isNgContent:isNgContent,isNgTemplate:isNgTemplate,getNsPrefix:getNsPrefix,mergeNsAndName:mergeNsAndName,NAMED_ENTITIES:NAMED_ENTITIES,NGSP_UNICODE:NGSP_UNICODE,debugOutputAstAsTypeScript:debugOutputAstAsTypeScript,TypeScriptEmitter:TypeScriptEmitter,ParseLocation:ParseLocation,ParseSourceFile:ParseSourceFile,ParseSourceSpan:ParseSourceSpan,ParseErrorLevel:ParseErrorLevel,ParseError:ParseError,typeSourceSpan:typeSourceSpan,DomElementSchemaRegistry:DomElementSchemaRegistry,CssSelector:CssSelector,SelectorMatcher:SelectorMatcher,SelectorListContext:SelectorListContext,SelectorContext:SelectorContext,StylesCompileDependency:StylesCompileDependency,CompiledStylesheet:CompiledStylesheet,StyleCompiler:StyleCompiler,TemplateParseError:TemplateParseError,TemplateParseResult:TemplateParseResult,TemplateParser:TemplateParser,splitClasses:splitClasses,createElementCssSelector:createElementCssSelector$1,removeSummaryDuplicates:removeSummaryDuplicates}),commonjsGlobal="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{},symbols=createCommonjsModule(function(module,exports){/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0});!function(BuiltinType){BuiltinType[BuiltinType.Any=0]="Any",BuiltinType[BuiltinType.String=1]="String",BuiltinType[BuiltinType.Number=2]="Number",BuiltinType[BuiltinType.Boolean=3]="Boolean",BuiltinType[BuiltinType.Undefined=4]="Undefined",BuiltinType[BuiltinType.Null=5]="Null",BuiltinType[BuiltinType.Unbound=6]="Unbound",BuiltinType[BuiltinType.Other=7]="Other"}(exports.BuiltinType||(exports.BuiltinType={}))}),compiler_1=compiler&&void 0||compiler,expression_type=createCommonjsModule(function(module,exports){/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0});var DiagnosticKind;!function(DiagnosticKind){DiagnosticKind[DiagnosticKind.Error=0]="Error",DiagnosticKind[DiagnosticKind.Warning=1]="Warning"}(DiagnosticKind=exports.DiagnosticKind||(exports.DiagnosticKind={}));var TypeDiagnostic=function(){function TypeDiagnostic(kind,message,ast){this.kind=kind,this.message=message,this.ast=ast}return TypeDiagnostic}();exports.TypeDiagnostic=TypeDiagnostic;var AstType=function(){function AstType(scope,query,context){this.scope=scope,this.query=query,this.context=context}return AstType.prototype.getType=function(ast){return ast.visit(this)},AstType.prototype.getDiagnostics=function(ast){this.diagnostics=[];var type=ast.visit(this);return this.context.event&&type.callable&&this.reportWarning("Unexpected callable expression. Expected a method call",ast),this.diagnostics},AstType.prototype.visitBinary=function(ast){function normalize(kind,other){switch(kind){case symbols.BuiltinType.Undefined:case symbols.BuiltinType.Null:return normalize(other,symbols.BuiltinType.Other)}return kind}var _this=this,getType=function(ast,operation){var type=_this.getType(ast);if(type.nullable){switch(operation){case"&&":case"||":case"==":case"!=":case"===":case"!==":break;default:_this.reportError("The expression might be null",ast)}return _this.query.getNonNullableType(type)}return type},leftType=getType(ast.left,ast.operation),rightType=getType(ast.right,ast.operation),leftRawKind=this.query.getTypeKind(leftType),rightRawKind=this.query.getTypeKind(rightType),leftKind=normalize(leftRawKind,rightRawKind),rightKind=normalize(rightRawKind,leftRawKind),operKind=leftKind<<8|rightKind;switch(ast.operation){case"*":case"/":case"%":case"-":case"<<":case">>":case">>>":case"&":case"^":case"|":switch(operKind){case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Number:case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Number:return this.query.getBuiltinType(symbols.BuiltinType.Number);default:var errorAst=ast.left;switch(leftKind){case symbols.BuiltinType.Any:case symbols.BuiltinType.Number:errorAst=ast.right}return this.reportError("Expected a numeric type",errorAst)}case"+":switch(operKind){case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Boolean:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Number:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Other:case symbols.BuiltinType.Boolean<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Other<<8|symbols.BuiltinType.Any:return this.anyType;case symbols.BuiltinType.Any<<8|symbols.BuiltinType.String:case symbols.BuiltinType.Boolean<<8|symbols.BuiltinType.String:case symbols.BuiltinType.Number<<8|symbols.BuiltinType.String:case symbols.BuiltinType.String<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.String<<8|symbols.BuiltinType.Boolean:case symbols.BuiltinType.String<<8|symbols.BuiltinType.Number:case symbols.BuiltinType.String<<8|symbols.BuiltinType.String:case symbols.BuiltinType.String<<8|symbols.BuiltinType.Other:case symbols.BuiltinType.Other<<8|symbols.BuiltinType.String:return this.query.getBuiltinType(symbols.BuiltinType.String);case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Number:return this.query.getBuiltinType(symbols.BuiltinType.Number);case symbols.BuiltinType.Boolean<<8|symbols.BuiltinType.Number:case symbols.BuiltinType.Other<<8|symbols.BuiltinType.Number:return this.reportError("Expected a number type",ast.left);case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Boolean:case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Other:return this.reportError("Expected a number type",ast.right);default:return this.reportError("Expected operands to be a string or number type",ast)}case">":case"<":case"<=":case">=":case"==":case"!=":case"===":case"!==":switch(operKind){case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Boolean:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Number:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.String:case symbols.BuiltinType.Any<<8|symbols.BuiltinType.Other:case symbols.BuiltinType.Boolean<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Boolean<<8|symbols.BuiltinType.Boolean:case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Number<<8|symbols.BuiltinType.Number:case symbols.BuiltinType.String<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.String<<8|symbols.BuiltinType.String:case symbols.BuiltinType.Other<<8|symbols.BuiltinType.Any:case symbols.BuiltinType.Other<<8|symbols.BuiltinType.Other:return this.query.getBuiltinType(symbols.BuiltinType.Boolean);default:return this.reportError("Expected the operants to be of similar type or any",ast)}case"&&":return rightType;case"||":return this.query.getTypeUnion(leftType,rightType)}return this.reportError("Unrecognized operator "+ast.operation,ast)},AstType.prototype.visitChain=function(ast){return this.diagnostics&&compiler_1.visitAstChildren(ast,this),this.query.getBuiltinType(symbols.BuiltinType.Undefined)},AstType.prototype.visitConditional=function(ast){return this.diagnostics&&compiler_1.visitAstChildren(ast,this),this.query.getTypeUnion(this.getType(ast.trueExp),this.getType(ast.falseExp))},AstType.prototype.visitFunctionCall=function(ast){var _this=this,args=ast.args.map(function(arg){return _this.getType(arg)}),target=this.getType(ast.target);if(!target||!target.callable)return this.reportError("Call target is not callable",ast);var signature=target.selectSignature(args);return signature?signature.result:this.reportError("Unable no compatible signature found for call",ast)},AstType.prototype.visitImplicitReceiver=function(ast){var _this=this;return{name:"$implict",kind:"component",language:"ng-template",type:void 0,container:void 0,callable:!1,nullable:!1,public:!0,definition:void 0,members:function(){return _this.scope},signatures:function(){return[]},selectSignature:function(types){},indexed:function(argument){}}},AstType.prototype.visitInterpolation=function(ast){return this.diagnostics&&compiler_1.visitAstChildren(ast,this),this.undefinedType},AstType.prototype.visitKeyedRead=function(ast){var targetType=this.getType(ast.obj),keyType=this.getType(ast.key);return targetType.indexed(keyType)||this.anyType},AstType.prototype.visitKeyedWrite=function(ast){return this.getType(ast.value)},AstType.prototype.visitLiteralArray=function(ast){var _this=this;return this.query.getArrayType((_a=this.query).getTypeUnion.apply(_a,ast.expressions.map(function(element){return _this.getType(element)})));var _a},AstType.prototype.visitLiteralMap=function(ast){return this.diagnostics&&compiler_1.visitAstChildren(ast,this),this.anyType},AstType.prototype.visitLiteralPrimitive=function(ast){switch(ast.value){case!0:case!1:return this.query.getBuiltinType(symbols.BuiltinType.Boolean);case null:return this.query.getBuiltinType(symbols.BuiltinType.Null);case void 0:return this.query.getBuiltinType(symbols.BuiltinType.Undefined);default:switch(typeof ast.value){case"string":return this.query.getBuiltinType(symbols.BuiltinType.String);case"number":return this.query.getBuiltinType(symbols.BuiltinType.Number);default:return this.reportError("Unrecognized primitive",ast)}}},AstType.prototype.visitMethodCall=function(ast){return this.resolveMethodCall(this.getType(ast.receiver),ast)},AstType.prototype.visitPipe=function(ast){var _this=this,pipe=this.query.getPipes().get(ast.name);if(!pipe)return this.reportError("No pipe by the name "+ast.name+" found",ast);var expType=this.getType(ast.exp),signature=pipe.selectSignature([expType].concat(ast.args.map(function(arg){return _this.getType(arg)})));return signature?signature.result:this.reportError("Unable to resolve signature for pipe invocation",ast)},AstType.prototype.visitPrefixNot=function(ast){return this.query.getBuiltinType(symbols.BuiltinType.Boolean)},AstType.prototype.visitNonNullAssert=function(ast){var expressionType=this.getType(ast.expression);return this.query.getNonNullableType(expressionType)},AstType.prototype.visitPropertyRead=function(ast){return this.resolvePropertyRead(this.getType(ast.receiver),ast)},AstType.prototype.visitPropertyWrite=function(ast){return this.getType(ast.value)},AstType.prototype.visitQuote=function(ast){return this.query.getBuiltinType(symbols.BuiltinType.Any)},AstType.prototype.visitSafeMethodCall=function(ast){return this.resolveMethodCall(this.query.getNonNullableType(this.getType(ast.receiver)),ast)},AstType.prototype.visitSafePropertyRead=function(ast){return this.resolvePropertyRead(this.query.getNonNullableType(this.getType(ast.receiver)),ast)},Object.defineProperty(AstType.prototype,"anyType",{get:function(){var result=this._anyType;return result||(result=this._anyType=this.query.getBuiltinType(symbols.BuiltinType.Any)),result},enumerable:!0,configurable:!0}),Object.defineProperty(AstType.prototype,"undefinedType",{get:function(){var result=this._undefinedType;return result||(result=this._undefinedType=this.query.getBuiltinType(symbols.BuiltinType.Undefined)),result},enumerable:!0,configurable:!0}),AstType.prototype.resolveMethodCall=function(receiverType,ast){var _this=this;if(this.isAny(receiverType))return this.anyType;var method=receiverType.members().get(ast.name);if(!method)return this.reportError("Unknown method '"+ast.name+"'",ast);if(!method.type)return this.reportError("Could not find a type for '"+ast.name+"'",ast);if(!method.type.callable)return this.reportError("Member '"+ast.name+"' is not callable",ast);var signature=method.type.selectSignature(ast.args.map(function(arg){return _this.getType(arg)}));return signature?signature.result:this.reportError("Unable to resolve signature for call of method "+ast.name,ast)},AstType.prototype.resolvePropertyRead=function(receiverType,ast){if(this.isAny(receiverType))return this.anyType;var member=receiverType.members().get(ast.name);if(!member){var receiverInfo=receiverType.name;if("$implict"==receiverInfo)receiverInfo="The component declaration, template variable declarations, and element references do";else{if(receiverType.nullable)return this.reportError("The expression might be null",ast.receiver);receiverInfo="'"+receiverInfo+"' does"}return this.reportError("Identifier '"+ast.name+"' is not defined. "+receiverInfo+" not contain such a member",ast)}if(!member.public){var receiverInfo=receiverType.name;receiverInfo="$implict"==receiverInfo?"the component":"'"+receiverInfo+"'",this.reportWarning("Identifier '"+ast.name+"' refers to a private member of "+receiverInfo,ast)}return member.type},AstType.prototype.reportError=function(message,ast){return this.diagnostics&&this.diagnostics.push(new TypeDiagnostic(DiagnosticKind.Error,message,ast)),this.anyType},AstType.prototype.reportWarning=function(message,ast){return this.diagnostics&&this.diagnostics.push(new TypeDiagnostic(DiagnosticKind.Warning,message,ast)),this.anyType},AstType.prototype.isAny=function(symbol){return!symbol||this.query.getTypeKind(symbol)==symbols.BuiltinType.Any||!!symbol.type&&this.isAny(symbol.type)},AstType}();exports.AstType=AstType}),expression_diagnostics=createCommonjsModule(function(module,exports){function getTemplateExpressionDiagnostics(info){var visitor=new ExpressionDiagnosticsVisitor(info,function(path$$1,includeEvent){return getExpressionScope(info,path$$1,includeEvent)});return compiler_1.templateVisitAll(visitor,info.templateAst),visitor.diagnostics}function getExpressionDiagnostics(scope,ast,query,context){void 0===context&&(context={});var analyzer=new expression_type.AstType(scope,query,context);return analyzer.getDiagnostics(ast),analyzer.diagnostics}function getReferences(info){function processReferences(references){for(var _i=0,references_1=references;_i<references_1.length;_i++){var reference=references_1[_i];!function(reference){var type=void 0;reference.value&&(type=info.query.getTypeSymbol(compiler_1.tokenReference(reference.value))),result.push({name:reference.name,kind:"reference",type:type||info.query.getBuiltinType(symbols.BuiltinType.Any),get definition(){return getDefinitionOf(info,reference)}})}(reference)}}var result=[],visitor=new(function(_super){function class_1(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(class_1,_super),class_1.prototype.visitEmbeddedTemplate=function(ast,context){_super.prototype.visitEmbeddedTemplate.call(this,ast,context),processReferences(ast.references)},class_1.prototype.visitElement=function(ast,context){_super.prototype.visitElement.call(this,ast,context),processReferences(ast.references)},class_1}(compiler_1.RecursiveTemplateAstVisitor));return compiler_1.templateVisitAll(visitor,info.templateAst),result}function getDefinitionOf(info,ast){if(info.fileName){var templateOffset=info.offset;return[{fileName:info.fileName,span:{start:ast.sourceSpan.start.offset+templateOffset,end:ast.sourceSpan.end.offset+templateOffset}}]}}function getVarDeclarations(info,path$$1){for(var result=[],current=path$$1.tail;current;){if(current instanceof compiler_1.EmbeddedTemplateAst)for(var _i=0,_a=current.variables;_i<_a.length;_i++){var variable=_a[_i];!function(variable){var name_1=variable.name,context=current.directives.map(function(d){return info.query.getTemplateContext(d.directive.type.reference)}).find(function(c){return!!c}),type=void 0;if(context){var value=context.get(variable.value);if(value){type=value.type;var kind=info.query.getTypeKind(type);kind!==symbols.BuiltinType.Any&&kind!=symbols.BuiltinType.Unbound||(type=refinedVariableType(type,info,current))}}type||(type=info.query.getBuiltinType(symbols.BuiltinType.Any)),result.push({name:name_1,kind:"variable",type:type,get definition(){return getDefinitionOf(info,variable)}})}(variable)}current=path$$1.parentOf(current)}return result}function refinedVariableType(type,info,templateElement){var ngForDirective=templateElement.directives.find(function(d){var name=compiler_1.identifierName(d.directive.type);return"NgFor"==name||"NgForOf"==name});if(ngForDirective){var ngForOfBinding=ngForDirective.inputs.find(function(i){return"ngForOf"==i.directiveName});if(ngForOfBinding){var bindingType=new expression_type.AstType(info.members,info.query,{}).getType(ngForOfBinding.value);if(bindingType){var result=info.query.getElementType(bindingType);if(result)return result}}}return info.query.getBuiltinType(symbols.BuiltinType.Any)}function getEventDeclaration(info,includeEvent){var result=[];return includeEvent&&(result=[{name:"$event",kind:"variable",type:info.query.getBuiltinType(symbols.BuiltinType.Any)}]),result}function getExpressionScope(info,path$$1,includeEvent){var result=info.members,references=getReferences(info),variables=getVarDeclarations(info,path$$1),events=getEventDeclaration(info,includeEvent);if(references.length||variables.length||events.length){var referenceTable=info.query.createSymbolTable(references),variableTable=info.query.createSymbolTable(variables),eventsTable=info.query.createSymbolTable(events);result=info.query.mergeSymbolTable([result,referenceTable,variableTable,eventsTable])}return result}function hasTemplateReference(type){if(type.diDeps)for(var _i=0,_a=type.diDeps;_i<_a.length;_i++){var diDep=_a[_i];if(diDep.token&&diDep.token.identifier&&"TemplateRef"==compiler_1.identifierName(diDep.token.identifier))return!0}return!1}function offsetSpan(span,amount){return{start:span.start+amount,end:span.end+amount}}function spanOf(sourceSpan){return{start:sourceSpan.start.offset,end:sourceSpan.end.offset}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __extends=commonjsGlobal&&commonjsGlobal.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])};return function(d,b){function __(){this.constructor=d}extendStatics(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0}),exports.getTemplateExpressionDiagnostics=getTemplateExpressionDiagnostics,exports.getExpressionDiagnostics=getExpressionDiagnostics,exports.getExpressionScope=getExpressionScope;var ExpressionDiagnosticsVisitor=function(_super){function ExpressionDiagnosticsVisitor(info,getExpressionScope){var _this=_super.call(this)||this;return _this.info=info,_this.getExpressionScope=getExpressionScope,_this.diagnostics=[],_this.path=new compiler_1.AstPath([]),_this}return __extends(ExpressionDiagnosticsVisitor,_super),ExpressionDiagnosticsVisitor.prototype.visitDirective=function(ast,context){ast.inputs&&ast.inputs.length&&compiler_1.templateVisitAll(this,ast.inputs,context)},ExpressionDiagnosticsVisitor.prototype.visitBoundText=function(ast){this.push(ast),this.diagnoseExpression(ast.value,ast.sourceSpan.start.offset,!1),this.pop()},ExpressionDiagnosticsVisitor.prototype.visitDirectiveProperty=function(ast){this.push(ast),this.diagnoseExpression(ast.value,this.attributeValueLocation(ast),!1),this.pop()},ExpressionDiagnosticsVisitor.prototype.visitElementProperty=function(ast){this.push(ast),this.diagnoseExpression(ast.value,this.attributeValueLocation(ast),!1),this.pop()},ExpressionDiagnosticsVisitor.prototype.visitEvent=function(ast){this.push(ast),this.diagnoseExpression(ast.handler,this.attributeValueLocation(ast),!0),this.pop()},ExpressionDiagnosticsVisitor.prototype.visitVariable=function(ast){var directive=this.directiveSummary;if(directive&&ast.value){var context=this.info.query.getTemplateContext(directive.type.reference);context&&!context.has(ast.value)&&("$implicit"===ast.value?this.reportError("The template context does not have an implicit value",spanOf(ast.sourceSpan)):this.reportError("The template context does not defined a member called '"+ast.value+"'",spanOf(ast.sourceSpan)))}},ExpressionDiagnosticsVisitor.prototype.visitElement=function(ast,context){this.push(ast),_super.prototype.visitElement.call(this,ast,context),this.pop()},ExpressionDiagnosticsVisitor.prototype.visitEmbeddedTemplate=function(ast,context){var previousDirectiveSummary=this.directiveSummary;this.push(ast),this.directiveSummary=ast.directives.map(function(d){return d.directive}).find(function(d){return hasTemplateReference(d.type)}),_super.prototype.visitEmbeddedTemplate.call(this,ast,context),this.pop(),this.directiveSummary=previousDirectiveSummary},ExpressionDiagnosticsVisitor.prototype.attributeValueLocation=function(ast){var path$$1=compiler_1.findNode(this.info.htmlAst,ast.sourceSpan.start.offset),last=path$$1.tail;return last instanceof compiler_1.Attribute&&last.valueSpan?last.valueSpan.start.offset+1:ast.sourceSpan.start.offset},ExpressionDiagnosticsVisitor.prototype.diagnoseExpression=function(ast,offset,includeEvent){var _this=this,scope=this.getExpressionScope(this.path,includeEvent);(_a=this.diagnostics).push.apply(_a,getExpressionDiagnostics(scope,ast,this.info.query,{event:includeEvent}).map(function(d){return{span:offsetSpan(d.ast.span,offset+_this.info.offset),kind:d.kind,message:d.message}}));var _a},ExpressionDiagnosticsVisitor.prototype.push=function(ast){this.path.push(ast)},ExpressionDiagnosticsVisitor.prototype.pop=function(){this.path.pop()},ExpressionDiagnosticsVisitor.prototype.reportError=function(message,span){span&&this.diagnostics.push({span:offsetSpan(span,this.info.offset),kind:expression_type.DiagnosticKind.Error,message:message})},ExpressionDiagnosticsVisitor.prototype.reportWarning=function(message,span){this.diagnostics.push({span:offsetSpan(span,this.info.offset),kind:expression_type.DiagnosticKind.Warning,message:message})},ExpressionDiagnosticsVisitor}(compiler_1.RecursiveTemplateAstVisitor)}),typescript_symbols=createCommonjsModule(function(module,exports){function getSymbolQuery(program,checker,source,fetchPipes){return new TypeScriptSymbolQuery(program,checker,source,fetchPipes)}function getClassMembers(program,checker,staticSymbol){var declaration=getClassFromStaticSymbol(program,staticSymbol);if(declaration){var type=checker.getTypeAtLocation(declaration),node=program.getSourceFile(staticSymbol.filePath);return new TypeWrapper(type,{node:node,program:program,checker:checker}).members()}}function getClassMembersFromDeclaration(program,checker,source,declaration){var type=checker.getTypeAtLocation(declaration);return new TypeWrapper(type,{node:source,program:program,checker:checker}).members()}function getClassFromStaticSymbol(program,type){var source=program.getSourceFile(type.filePath);if(source)return ts__default.forEachChild(source,function(child){if(child.kind===ts__default.SyntaxKind.ClassDeclaration){var classDeclaration=child;if(null!=classDeclaration.name&&classDeclaration.name.text===type.name)return classDeclaration}})}function getPipesTable(source,program,checker,pipes){return new PipesTable(pipes,{program:program,checker:checker,node:source})}function typeCallable(type){var signatures=type.getCallSignatures();return signatures&&0!=signatures.length}function signaturesOf(type,context){return type.getCallSignatures().map(function(s){return new SignatureWrapper(s,context)})}function selectSignature(type,context,types){var signatures=type.getCallSignatures();return signatures.length?new SignatureWrapper(signatures[0],context):void 0}function toSymbols(symbolTable){if(!symbolTable)return[];var table=symbolTable;if("function"==typeof table.values)return Array.from(table.values());var result=[],own="function"==typeof table.hasOwnProperty?function(name){return table.hasOwnProperty(name)}:function(name){return!!table[name]};for(var name_1 in table)own(name_1)&&result.push(table[name_1]);return result}function findClassSymbolInContext(type,context){var sourceFile=context.program.getSourceFile(type.filePath);if(sourceFile){var moduleSymbol=sourceFile.module||sourceFile.symbol;return(context.checker.getExportsOfModule(moduleSymbol)||[]).find(function(symbol){return symbol.name==type.name})}}function isSymbolPrivate(s){return!!s.valueDeclaration&&isPrivate(s.valueDeclaration)}function getBuiltinTypeFromTs(kind,context){var type,checker=context.checker,node=context.node;switch(kind){case symbols.BuiltinType.Any:type=checker.getTypeAtLocation(setParents({kind:ts__default.SyntaxKind.AsExpression,expression:{kind:ts__default.SyntaxKind.TrueKeyword},type:{kind:ts__default.SyntaxKind.AnyKeyword}},node));break;case symbols.BuiltinType.Boolean:type=checker.getTypeAtLocation(setParents({kind:ts__default.SyntaxKind.TrueKeyword},node));break;case symbols.BuiltinType.Null:type=checker.getTypeAtLocation(setParents({kind:ts__default.SyntaxKind.NullKeyword},node));break;case symbols.BuiltinType.Number:var numeric={kind:ts__default.SyntaxKind.NumericLiteral};setParents({kind:ts__default.SyntaxKind.ExpressionStatement,expression:numeric},node),type=checker.getTypeAtLocation(numeric);break;case symbols.BuiltinType.String:type=checker.getTypeAtLocation(setParents({kind:ts__default.SyntaxKind.NoSubstitutionTemplateLiteral},node));break;case symbols.BuiltinType.Undefined:type=checker.getTypeAtLocation(setParents({kind:ts__default.SyntaxKind.VoidExpression,expression:{kind:ts__default.SyntaxKind.NumericLiteral}},node));break;default:throw new Error("Internal error, unhandled literal kind "+kind+":"+symbols.BuiltinType[kind])}return type}function setParents(node,parent){return node.parent=parent,ts__default.forEachChild(node,function(child){return setParents(child,node)}),node}function spanAt(sourceFile,line,column){if(null!=line&&null!=column){var position_1=ts__default.getPositionOfLineAndCharacter(sourceFile,line,column),findChild=function findChild(node){if(node.kind>ts__default.SyntaxKind.LastToken&&node.pos<=position_1&&node.end>position_1){return ts__default.forEachChild(node,findChild)||node}},node=ts__default.forEachChild(sourceFile,findChild);if(node)return{start:node.getStart(),end:node.getEnd()}}}function definitionFromTsSymbol(symbol){var declarations=symbol.declarations;if(declarations)return declarations.map(function(declaration){return{fileName:declaration.getSourceFile().fileName,span:{start:declaration.getStart(),end:declaration.getEnd()}}})}function parentDeclarationOf(node){for(;node;){switch(node.kind){case ts__default.SyntaxKind.ClassDeclaration:case ts__default.SyntaxKind.InterfaceDeclaration:return node;case ts__default.SyntaxKind.SourceFile:return}node=node.parent}}function getContainerOf(symbol,context){if(symbol.getFlags()&ts__default.SymbolFlags.ClassMember&&symbol.declarations)for(var _i=0,_a=symbol.declarations;_i<_a.length;_i++){var declaration=_a[_i],parent_1=parentDeclarationOf(declaration);if(parent_1){var type=context.checker.getTypeAtLocation(parent_1);if(type)return new TypeWrapper(type,context)}}}function getTypeParameterOf(type,name){if(type&&type.symbol&&type.symbol.name==name){var typeArguments=type.typeArguments;if(typeArguments&&typeArguments.length<=1)return typeArguments[0]}}function typeKindOf(type){if(type){if(type.flags&ts__default.TypeFlags.Any)return symbols.BuiltinType.Any;if(type.flags&(ts__default.TypeFlags.String|ts__default.TypeFlags.StringLike|ts__default.TypeFlags.StringLiteral))return symbols.BuiltinType.String;if(type.flags&(ts__default.TypeFlags.Number|ts__default.TypeFlags.NumberLike))return symbols.BuiltinType.Number;if(type.flags&ts__default.TypeFlags.Undefined)return symbols.BuiltinType.Undefined;if(type.flags&ts__default.TypeFlags.Null)return symbols.BuiltinType.Null;if(type.flags&ts__default.TypeFlags.Union){var candidate=null,unionType=type;if(unionType.types.length>0){candidate=typeKindOf(unionType.types[0]);for(var _i=0,_a=unionType.types;_i<_a.length;_i++){if(candidate!=typeKindOf(_a[_i]))return symbols.BuiltinType.Other}}if(null!=candidate)return candidate}else if(type.flags&ts__default.TypeFlags.TypeParameter)return symbols.BuiltinType.Unbound}return symbols.BuiltinType.Other}function getFromSymbolTable(symbolTable,key){var table=symbolTable;return"function"==typeof table.get?table.get(key):table[key]}function toNumbers(value){return value?value.split(".").map(function(v){return+v}):[]}function compareNumbers(a,b){for(var i=0;i<a.length&&i<b.length;i++){if(a[i]>b[i])return 1;if(a[i]<b[i])return-1}return 0}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0});var isPrivate=ts__default.ModifierFlags?function(node){return!!(ts__default.getCombinedModifierFlags(node)&ts__default.ModifierFlags.Private)}:function(node){return!!(node.flags&ts__default.NodeFlags.Private)},isReferenceType=ts__default.ObjectFlags?function(type){return!!(type.flags&ts__default.TypeFlags.Object&&type.objectFlags&ts__default.ObjectFlags.Reference)}:function(type){return!!(type.flags&ts__default.TypeFlags.Reference)};exports.getSymbolQuery=getSymbolQuery,exports.getClassMembers=getClassMembers,exports.getClassMembersFromDeclaration=getClassMembersFromDeclaration,exports.getClassFromStaticSymbol=getClassFromStaticSymbol,exports.getPipesTable=getPipesTable;var TypeScriptSymbolQuery=function(){function TypeScriptSymbolQuery(program,checker,source,fetchPipes){this.program=program,this.checker=checker,this.source=source,this.fetchPipes=fetchPipes,this.typeCache=new Map}return TypeScriptSymbolQuery.prototype.getTypeKind=function(symbol){return typeKindOf(this.getTsTypeOf(symbol))},TypeScriptSymbolQuery.prototype.getBuiltinType=function(kind){var result=this.typeCache.get(kind);if(!result){var type=getBuiltinTypeFromTs(kind,{checker:this.checker,node:this.source,program:this.program});result=new TypeWrapper(type,{program:this.program,checker:this.checker,node:this.source}),this.typeCache.set(kind,result)}return result},TypeScriptSymbolQuery.prototype.getTypeUnion=function(){for(var types=[],_i=0;_i<arguments.length;_i++)types[_i]=arguments[_i];var result=void 0;if(types.length){result=types[0];for(var i=1;i<types.length;i++)if(types[i]!=result){result=void 0;break}}return result||this.getBuiltinType(symbols.BuiltinType.Any)},TypeScriptSymbolQuery.prototype.getArrayType=function(type){return this.getBuiltinType(symbols.BuiltinType.Any)},TypeScriptSymbolQuery.prototype.getElementType=function(type){if(type instanceof TypeWrapper){var elementType=getTypeParameterOf(type.tsType,"Array");if(elementType)return new TypeWrapper(elementType,type.context)}},TypeScriptSymbolQuery.prototype.getNonNullableType=function(symbol){if(symbol instanceof TypeWrapper&&"function"==typeof this.checker.getNonNullableType){var tsType=symbol.tsType,nonNullableType=this.checker.getNonNullableType(tsType);if(nonNullableType!=tsType)return new TypeWrapper(nonNullableType,symbol.context);if(nonNullableType==tsType)return symbol}return this.getBuiltinType(symbols.BuiltinType.Any)},TypeScriptSymbolQuery.prototype.getPipes=function(){var result=this.pipesCache;return result||(result=this.pipesCache=this.fetchPipes()),result},TypeScriptSymbolQuery.prototype.getTemplateContext=function(type){var context={node:this.source,program:this.program,checker:this.checker},typeSymbol=findClassSymbolInContext(type,context);if(typeSymbol){var contextType=this.getTemplateRefContextType(typeSymbol);if(contextType)return new SymbolWrapper(contextType,context).members()}},TypeScriptSymbolQuery.prototype.getTypeSymbol=function(type){var context={node:this.source,program:this.program,checker:this.checker},typeSymbol=findClassSymbolInContext(type,context);return typeSymbol&&new SymbolWrapper(typeSymbol,context)},TypeScriptSymbolQuery.prototype.createSymbolTable=function(symbols$$2){var result=new MapSymbolTable;return result.addAll(symbols$$2.map(function(s){return new DeclaredSymbol(s)})),result},TypeScriptSymbolQuery.prototype.mergeSymbolTable=function(symbolTables){for(var result=new MapSymbolTable,_i=0,symbolTables_1=symbolTables;_i<symbolTables_1.length;_i++){var symbolTable=symbolTables_1[_i];result.addAll(symbolTable.values())}return result},TypeScriptSymbolQuery.prototype.getSpanAt=function(line,column){return spanAt(this.source,line,column)},TypeScriptSymbolQuery.prototype.getTemplateRefContextType=function(typeSymbol){var type=this.checker.getTypeOfSymbolAtLocation(typeSymbol,this.source),constructor=type.symbol&&type.symbol.members&&getFromSymbolTable(type.symbol.members,"__constructor");if(constructor)for(var constructorDeclaration=constructor.declarations[0],_i=0,_a=constructorDeclaration.parameters;_i<_a.length;_i++){var parameter=_a[_i],type_1=this.checker.getTypeAtLocation(parameter.type);if("TemplateRef"==type_1.symbol.name&&isReferenceType(type_1)){var typeReference=type_1;if(typeReference.typeArguments&&1===typeReference.typeArguments.length)return typeReference.typeArguments[0].symbol}}},TypeScriptSymbolQuery.prototype.getTsTypeOf=function(symbol){var type=this.getTypeWrapper(symbol);return type&&type.tsType},TypeScriptSymbolQuery.prototype.getTypeWrapper=function(symbol){var type=void 0;return symbol instanceof TypeWrapper?type=symbol:symbol.type instanceof TypeWrapper&&(type=symbol.type),type},TypeScriptSymbolQuery}(),TypeWrapper=function(){function TypeWrapper(tsType,context){if(this.tsType=tsType,this.context=context,this.kind="type",this.language="typescript",this.type=void 0,this.container=void 0,this.public=!0,!tsType)throw Error("Internal: null type")}return Object.defineProperty(TypeWrapper.prototype,"name",{get:function(){var symbol=this.tsType.symbol;return symbol&&symbol.name||"<anonymous>"},enumerable:!0,configurable:!0}),Object.defineProperty(TypeWrapper.prototype,"callable",{get:function(){return typeCallable(this.tsType)},enumerable:!0,configurable:!0}),Object.defineProperty(TypeWrapper.prototype,"nullable",{get:function(){return this.context.checker.getNonNullableType(this.tsType)!=this.tsType},enumerable:!0,configurable:!0}),Object.defineProperty(TypeWrapper.prototype,"definition",{get:function(){var symbol=this.tsType.getSymbol();return symbol?definitionFromTsSymbol(symbol):void 0},enumerable:!0,configurable:!0}),TypeWrapper.prototype.members=function(){return new SymbolTableWrapper(this.tsType.getProperties(),this.context)},TypeWrapper.prototype.signatures=function(){return signaturesOf(this.tsType,this.context)},TypeWrapper.prototype.selectSignature=function(types){return selectSignature(this.tsType,this.context,types)},TypeWrapper.prototype.indexed=function(argument){},TypeWrapper}(),SymbolWrapper=function(){function SymbolWrapper(symbol,context){this.context=context,this.nullable=!1,this.language="typescript",this.symbol=symbol&&context&&symbol.flags&ts__default.SymbolFlags.Alias?context.checker.getAliasedSymbol(symbol):symbol}return Object.defineProperty(SymbolWrapper.prototype,"name",{get:function(){return this.symbol.name},enumerable:!0,configurable:!0}),Object.defineProperty(SymbolWrapper.prototype,"kind",{get:function(){return this.callable?"method":"property"},enumerable:!0,configurable:!0}),Object.defineProperty(SymbolWrapper.prototype,"type",{get:function(){return new TypeWrapper(this.tsType,this.context)},enumerable:!0,configurable:!0}),Object.defineProperty(SymbolWrapper.prototype,"container",{get:function(){return getContainerOf(this.symbol,this.context)},enumerable:!0,configurable:!0}),Object.defineProperty(SymbolWrapper.prototype,"public",{get:function(){return!isSymbolPrivate(this.symbol)},enumerable:!0,configurable:!0}),Object.defineProperty(SymbolWrapper.prototype,"callable",{get:function(){return typeCallable(this.tsType)},enumerable:!0,configurable:!0}),Object.defineProperty(SymbolWrapper.prototype,"definition",{get:function(){return definitionFromTsSymbol(this.symbol)},enumerable:!0,configurable:!0}),SymbolWrapper.prototype.members=function(){if(!this._members)if(0!=(this.symbol.flags&(ts__default.SymbolFlags.Class|ts__default.SymbolFlags.Interface))){var declaredType=this.context.checker.getDeclaredTypeOfSymbol(this.symbol),typeWrapper=new TypeWrapper(declaredType,this.context);this._members=typeWrapper.members()}else this._members=new SymbolTableWrapper(this.symbol.members,this.context);return this._members},SymbolWrapper.prototype.signatures=function(){return signaturesOf(this.tsType,this.context)},SymbolWrapper.prototype.selectSignature=function(types){return selectSignature(this.tsType,this.context,types)},SymbolWrapper.prototype.indexed=function(argument){},Object.defineProperty(SymbolWrapper.prototype,"tsType",{get:function(){var type=this._tsType;return type||(type=this._tsType=this.context.checker.getTypeOfSymbolAtLocation(this.symbol,this.context.node)),type},enumerable:!0,configurable:!0}),SymbolWrapper}(),DeclaredSymbol=function(){function DeclaredSymbol(declaration){this.declaration=declaration,this.language="ng-template",this.nullable=!1,this.public=!0}return Object.defineProperty(DeclaredSymbol.prototype,"name",{get:function(){return this.declaration.name},enumerable:!0,configurable:!0}),Object.defineProperty(DeclaredSymbol.prototype,"kind",{get:function(){return this.declaration.kind},enumerable:!0,configurable:!0}),Object.defineProperty(DeclaredSymbol.prototype,"container",{get:function(){},enumerable:!0,configurable:!0}),Object.defineProperty(DeclaredSymbol.prototype,"type",{get:function(){return this.declaration.type},enumerable:!0,configurable:!0}),Object.defineProperty(DeclaredSymbol.prototype,"callable",{get:function(){return this.declaration.type.callable},enumerable:!0,configurable:!0}),Object.defineProperty(DeclaredSymbol.prototype,"definition",{get:function(){return this.declaration.definition},enumerable:!0,configurable:!0}),DeclaredSymbol.prototype.members=function(){return this.declaration.type.members()},DeclaredSymbol.prototype.signatures=function(){return this.declaration.type.signatures()},DeclaredSymbol.prototype.selectSignature=function(types){return this.declaration.type.selectSignature(types)},DeclaredSymbol.prototype.indexed=function(argument){},DeclaredSymbol}(),SignatureWrapper=function(){function SignatureWrapper(signature,context){this.signature=signature,this.context=context}return Object.defineProperty(SignatureWrapper.prototype,"arguments",{get:function(){return new SymbolTableWrapper(this.signature.getParameters(),this.context)},enumerable:!0,configurable:!0}),Object.defineProperty(SignatureWrapper.prototype,"result",{get:function(){return new TypeWrapper(this.signature.getReturnType(),this.context)},enumerable:!0,configurable:!0}),SignatureWrapper}(),SignatureResultOverride=function(){function SignatureResultOverride(signature,resultType){this.signature=signature,this.resultType=resultType}return Object.defineProperty(SignatureResultOverride.prototype,"arguments",{get:function(){return this.signature.arguments},enumerable:!0,configurable:!0}),Object.defineProperty(SignatureResultOverride.prototype,"result",{get:function(){return this.resultType},enumerable:!0,configurable:!0}),SignatureResultOverride}(),toSymbolTable=function(low,high){var tsNumbers=toNumbers(ts__default.version);return compareNumbers(toNumbers(low),tsNumbers)<=0&&compareNumbers(toNumbers(high),tsNumbers)>=0}("2.2")?function(symbols$$2){for(var result=new Map,_i=0,symbols_2=symbols$$2;_i<symbols_2.length;_i++){var symbol=symbols_2[_i];result.set(symbol.name,symbol)}return result}:function(symbols$$2){for(var result={},_i=0,symbols_3=symbols$$2;_i<symbols_3.length;_i++){var symbol=symbols_3[_i];result[symbol.name]=symbol}return result},SymbolTableWrapper=function(){function SymbolTableWrapper(symbols$$2,context){this.context=context,symbols$$2=symbols$$2||[],Array.isArray(symbols$$2)?(this.symbols=symbols$$2,this.symbolTable=toSymbolTable(symbols$$2)):(this.symbols=toSymbols(symbols$$2),this.symbolTable=symbols$$2)}return Object.defineProperty(SymbolTableWrapper.prototype,"size",{get:function(){return this.symbols.length},enumerable:!0,configurable:!0}),SymbolTableWrapper.prototype.get=function(key){var symbol=getFromSymbolTable(this.symbolTable,key);return symbol?new SymbolWrapper(symbol,this.context):void 0},SymbolTableWrapper.prototype.has=function(key){var table=this.symbolTable;return"function"==typeof table.has?table.has(key):null!=table[key]},SymbolTableWrapper.prototype.values=function(){var _this=this;return this.symbols.map(function(s){return new SymbolWrapper(s,_this.context)})},SymbolTableWrapper}(),MapSymbolTable=function(){function MapSymbolTable(){this.map=new Map,this._values=[]}return Object.defineProperty(MapSymbolTable.prototype,"size",{get:function(){return this.map.size},enumerable:!0,configurable:!0}),MapSymbolTable.prototype.get=function(key){return this.map.get(key)},MapSymbolTable.prototype.add=function(symbol){if(this.map.has(symbol.name)){var previous=this.map.get(symbol.name);this._values[this._values.indexOf(previous)]=symbol}this.map.set(symbol.name,symbol),this._values.push(symbol)},MapSymbolTable.prototype.addAll=function(symbols$$2){for(var _i=0,symbols_4=symbols$$2;_i<symbols_4.length;_i++){var symbol=symbols_4[_i];this.add(symbol)}},MapSymbolTable.prototype.has=function(key){return this.map.has(key)},MapSymbolTable.prototype.values=function(){return this._values},MapSymbolTable}(),PipesTable=function(){function PipesTable(pipes,context){this.pipes=pipes,this.context=context}return Object.defineProperty(PipesTable.prototype,"size",{get:function(){return this.pipes.length},enumerable:!0,configurable:!0}),PipesTable.prototype.get=function(key){var pipe=this.pipes.find(function(pipe){return pipe.name==key});if(pipe)return new PipeSymbol(pipe,this.context)},PipesTable.prototype.has=function(key){return null!=this.pipes.find(function(pipe){return pipe.name==key})},PipesTable.prototype.values=function(){var _this=this;return this.pipes.map(function(pipe){return new PipeSymbol(pipe,_this.context)})},PipesTable}(),PipeSymbol=function(){function PipeSymbol(pipe,context){this.pipe=pipe,this.context=context,this.kind="pipe",this.language="typescript",this.container=void 0,this.callable=!0,this.nullable=!1,this.public=!0}return Object.defineProperty(PipeSymbol.prototype,"name",{get:function(){return this.pipe.name},enumerable:!0,configurable:!0}),Object.defineProperty(PipeSymbol.prototype,"type",{get:function(){return new TypeWrapper(this.tsType,this.context)},enumerable:!0,configurable:!0}),Object.defineProperty(PipeSymbol.prototype,"definition",{get:function(){var symbol=this.tsType.getSymbol();return symbol?definitionFromTsSymbol(symbol):void 0},enumerable:!0,configurable:!0}),PipeSymbol.prototype.members=function(){return EmptyTable.instance},PipeSymbol.prototype.signatures=function(){return signaturesOf(this.tsType,this.context)},PipeSymbol.prototype.selectSignature=function(types){var signature=selectSignature(this.tsType,this.context,types);if(1==types.length){var parameterType=types[0];if(parameterType instanceof TypeWrapper){var resultType=void 0;switch(this.name){case"async":switch(parameterType.name){case"Observable":case"Promise":case"EventEmitter":resultType=getTypeParameterOf(parameterType.tsType,parameterType.name);break;default:resultType=getBuiltinTypeFromTs(symbols.BuiltinType.Any,this.context)}break;case"slice":resultType=getTypeParameterOf(parameterType.tsType,"Array")}resultType&&(signature=new SignatureResultOverride(signature,new TypeWrapper(resultType,parameterType.context)))}}return signature},PipeSymbol.prototype.indexed=function(argument){},Object.defineProperty(PipeSymbol.prototype,"tsType",{get:function(){var type=this._tsType;if(!type){var classSymbol=this.findClassSymbol(this.pipe.type.reference);classSymbol&&(type=this._tsType=this.findTransformMethodType(classSymbol)),type||(type=this._tsType=getBuiltinTypeFromTs(symbols.BuiltinType.Any,this.context))}return type},enumerable:!0,configurable:!0}),PipeSymbol.prototype.findClassSymbol=function(type){return findClassSymbolInContext(type,this.context)},PipeSymbol.prototype.findTransformMethodType=function(classSymbol){var classType=this.context.checker.getDeclaredTypeOfSymbol(classSymbol);if(classType){var transform=classType.getProperty("transform");if(transform)return this.context.checker.getTypeOfSymbolAtLocation(transform,this.context.node)}},PipeSymbol}(),EmptyTable=function(){function EmptyTable(){this.size=0}return EmptyTable.prototype.get=function(key){},EmptyTable.prototype.has=function(key){return!1},EmptyTable.prototype.values=function(){return[]},EmptyTable.instance=new EmptyTable,EmptyTable}()}),schema=createCommonjsModule(function(module,exports){function isModuleMetadata(value){return value&&"module"===value.__symbolic}function isClassMetadata(value){return value&&"class"===value.__symbolic}function isInterfaceMetadata(value){return value&&"interface"===value.__symbolic}function isMemberMetadata(value){if(value)switch(value.__symbolic){case"constructor":case"method":case"property":return!0}return!1}function isMethodMetadata(value){return value&&("constructor"===value.__symbolic||"method"===value.__symbolic)}function isConstructorMetadata(value){return value&&"constructor"===value.__symbolic}function isFunctionMetadata(value){return value&&"function"===value.__symbolic}function isMetadataSymbolicExpression(value){if(value)switch(value.__symbolic){case"binary":case"call":case"index":case"new":case"pre":case"reference":case"select":case"spread":case"if":return!0}return!1}function isMetadataSymbolicBinaryExpression(value){return value&&"binary"===value.__symbolic}function isMetadataSymbolicIndexExpression(value){return value&&"index"===value.__symbolic}function isMetadataSymbolicCallExpression(value){return value&&("call"===value.__symbolic||"new"===value.__symbolic)}function isMetadataSymbolicPrefixExpression(value){return value&&"pre"===value.__symbolic}function isMetadataSymbolicIfExpression(value){return value&&"if"===value.__symbolic}function isMetadataGlobalReferenceExpression(value){return value&&value.name&&!value.module&&isMetadataSymbolicReferenceExpression(value)}function isMetadataModuleReferenceExpression(value){return value&&value.module&&!value.name&&!value.default&&isMetadataSymbolicReferenceExpression(value)}function isMetadataImportedSymbolReferenceExpression(value){return value&&value.module&&!!value.name&&isMetadataSymbolicReferenceExpression(value)}function isMetadataImportDefaultReference(value){return value&&value.module&&value.default&&isMetadataSymbolicReferenceExpression(value)}function isMetadataSymbolicReferenceExpression(value){return value&&"reference"===value.__symbolic}function isMetadataSymbolicSelectExpression(value){return value&&"select"===value.__symbolic}function isMetadataSymbolicSpreadExpression(value){return value&&"spread"===value.__symbolic}function isMetadataError(value){return value&&"error"===value.__symbolic}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0}),exports.METADATA_VERSION=4,exports.isModuleMetadata=isModuleMetadata,exports.isClassMetadata=isClassMetadata,exports.isInterfaceMetadata=isInterfaceMetadata,exports.isMemberMetadata=isMemberMetadata,exports.isMethodMetadata=isMethodMetadata,exports.isConstructorMetadata=isConstructorMetadata,exports.isFunctionMetadata=isFunctionMetadata,exports.isMetadataSymbolicExpression=isMetadataSymbolicExpression,exports.isMetadataSymbolicBinaryExpression=isMetadataSymbolicBinaryExpression,exports.isMetadataSymbolicIndexExpression=isMetadataSymbolicIndexExpression,exports.isMetadataSymbolicCallExpression=isMetadataSymbolicCallExpression,exports.isMetadataSymbolicPrefixExpression=isMetadataSymbolicPrefixExpression,exports.isMetadataSymbolicIfExpression=isMetadataSymbolicIfExpression,exports.isMetadataGlobalReferenceExpression=isMetadataGlobalReferenceExpression,exports.isMetadataModuleReferenceExpression=isMetadataModuleReferenceExpression,exports.isMetadataImportedSymbolReferenceExpression=isMetadataImportedSymbolReferenceExpression,exports.isMetadataImportDefaultReference=isMetadataImportDefaultReference,exports.isMetadataSymbolicReferenceExpression=isMetadataSymbolicReferenceExpression,exports.isMetadataSymbolicSelectExpression=isMetadataSymbolicSelectExpression,exports.isMetadataSymbolicSpreadExpression=isMetadataSymbolicSpreadExpression,exports.isMetadataError=isMetadataError}),evaluator=createCommonjsModule(function(module,exports){function isMethodCallOf(callExpression,memberName){var expression=callExpression.expression;if(expression.kind===ts__default.SyntaxKind.PropertyAccessExpression){var propertyAccessExpression=expression,name_1=propertyAccessExpression.name;if(name_1.kind==ts__default.SyntaxKind.Identifier)return name_1.text===memberName}return!1}function isCallOf(callExpression,ident){var expression=callExpression.expression;if(expression.kind===ts__default.SyntaxKind.Identifier){return expression.text===ident}return!1}function recordMapEntry(entry,node,nodeMap,sourceFile){if(!nodeMap.has(entry)&&(nodeMap.set(entry,node),node&&(schema.isMetadataImportedSymbolReferenceExpression(entry)||schema.isMetadataImportDefaultReference(entry))&&null==entry.line)){var info=sourceInfo(node,sourceFile);null!=info.line&&(entry.line=info.line),null!=info.character&&(entry.character=info.character)}return entry}function everyNodeChild(node,cb){return!ts__default.forEachChild(node,function(node){return!cb(node)})}function isPrimitive(value){return Object(value)!==value}function isDefined(obj){return void 0!==obj}function getSourceFileOfNode(node){for(;node&&node.kind!=ts__default.SyntaxKind.SourceFile;)node=node.parent;return node}function sourceInfo(node,sourceFile){return node&&(sourceFile=sourceFile||getSourceFileOfNode(node))?ts__default.getLineAndCharacterOfPosition(sourceFile,node.getStart(sourceFile)):{}}function errorSymbol(message,node,context,sourceFile){var result=__assign({__symbolic:"error",message:message},sourceInfo(node,sourceFile));return context&&(result.context=context),result}function isPropertyAssignment(node){return node.kind==ts__default.SyntaxKind.PropertyAssignment}function arrayOrEmpty(v){return v||empty}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __assign=commonjsGlobal&&commonjsGlobal.__assign||Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)Object.prototype.hasOwnProperty.call(s,p)&&(t[p]=s[p])}return t};Object.defineProperty(exports,"__esModule",{value:!0});var spreadElementSyntaxKind=ts__default.SyntaxKind.SpreadElement||ts__default.SyntaxKind.SpreadElementExpression;exports.recordMapEntry=recordMapEntry,exports.isPrimitive=isPrimitive,exports.sourceInfo=sourceInfo,exports.errorSymbol=errorSymbol;var Evaluator=function(){function Evaluator(symbols,nodeMap,options,recordExport){void 0===options&&(options={}),this.symbols=symbols,this.nodeMap=nodeMap,this.options=options,this.recordExport=recordExport}return Evaluator.prototype.nameOf=function(node){if(node&&node.kind==ts__default.SyntaxKind.Identifier)return node.text;var result=node&&this.evaluateNode(node);return schema.isMetadataError(result)||"string"==typeof result?result:errorSymbol("Name expected",node,{received:node&&node.getText()||"<missing>"})},Evaluator.prototype.isFoldable=function(node){return this.isFoldableWorker(node,new Map)},Evaluator.prototype.isFoldableWorker=function(node,folding){var _this=this;if(node)switch(node.kind){case ts__default.SyntaxKind.ObjectLiteralExpression:return everyNodeChild(node,function(child){if(child.kind===ts__default.SyntaxKind.PropertyAssignment){var propertyAssignment=child;return _this.isFoldableWorker(propertyAssignment.initializer,folding)}return!1});case ts__default.SyntaxKind.ArrayLiteralExpression:return everyNodeChild(node,function(child){return _this.isFoldableWorker(child,folding)});case ts__default.SyntaxKind.CallExpression:var callExpression=node;if(isMethodCallOf(callExpression,"concat")&&1===arrayOrEmpty(callExpression.arguments).length){var arrayNode=callExpression.expression.expression;if(this.isFoldableWorker(arrayNode,folding)&&this.isFoldableWorker(callExpression.arguments[0],folding)){var arrayValue=this.evaluateNode(arrayNode);if(arrayValue&&Array.isArray(arrayValue))return!0}}return!(!isCallOf(callExpression,"CONST_EXPR")||1!==arrayOrEmpty(callExpression.arguments).length)&&this.isFoldableWorker(callExpression.arguments[0],folding);case ts__default.SyntaxKind.NoSubstitutionTemplateLiteral:case ts__default.SyntaxKind.StringLiteral:case ts__default.SyntaxKind.NumericLiteral:case ts__default.SyntaxKind.NullKeyword:case ts__default.SyntaxKind.TrueKeyword:case ts__default.SyntaxKind.FalseKeyword:case ts__default.SyntaxKind.TemplateHead:case ts__default.SyntaxKind.TemplateMiddle:case ts__default.SyntaxKind.TemplateTail:return!0;case ts__default.SyntaxKind.ParenthesizedExpression:var parenthesizedExpression=node;return this.isFoldableWorker(parenthesizedExpression.expression,folding);case ts__default.SyntaxKind.BinaryExpression:var binaryExpression=node;switch(binaryExpression.operatorToken.kind){case ts__default.SyntaxKind.PlusToken:case ts__default.SyntaxKind.MinusToken:case ts__default.SyntaxKind.AsteriskToken:case ts__default.SyntaxKind.SlashToken:case ts__default.SyntaxKind.PercentToken:case ts__default.SyntaxKind.AmpersandAmpersandToken:case ts__default.SyntaxKind.BarBarToken:return this.isFoldableWorker(binaryExpression.left,folding)&&this.isFoldableWorker(binaryExpression.right,folding);default:return!1}case ts__default.SyntaxKind.PropertyAccessExpression:var propertyAccessExpression=node;return this.isFoldableWorker(propertyAccessExpression.expression,folding);case ts__default.SyntaxKind.ElementAccessExpression:var elementAccessExpression=node;return this.isFoldableWorker(elementAccessExpression.expression,folding)&&this.isFoldableWorker(elementAccessExpression.argumentExpression,folding);case ts__default.SyntaxKind.Identifier:var identifier=node,reference=this.symbols.resolve(identifier.text);if(void 0!==reference&&isPrimitive(reference))return!0;break;case ts__default.SyntaxKind.TemplateExpression:return node.templateSpans.every(function(span){return _this.isFoldableWorker(span.expression,folding)})}return!1},Evaluator.prototype.evaluateNode=function(node,preferReference){function recordEntry(entry,node){if(t.options.substituteExpression){var newEntry=t.options.substituteExpression(entry,node);t.recordExport&&newEntry!=entry&&schema.isMetadataGlobalReferenceExpression(newEntry)&&t.recordExport(newEntry.name,entry),entry=newEntry}return recordMapEntry(entry,node,t.nodeMap)}function isFoldableError(value){return!t.options.verboseInvalidExpression&&schema.isMetadataError(value)}var error,_this=this,t=this,resolveName=function(name,preferReference){var reference=_this.symbols.resolve(name,preferReference);return void 0===reference?recordEntry({__symbolic:"reference",name:name},node):reference&&schema.isMetadataSymbolicReferenceExpression(reference)?recordEntry(__assign({},reference),node):reference};switch(node.kind){case ts__default.SyntaxKind.ObjectLiteralExpression:var obj_1={},quoted_1=[];return ts__default.forEachChild(node,function(child){switch(child.kind){case ts__default.SyntaxKind.ShorthandPropertyAssignment:case ts__default.SyntaxKind.PropertyAssignment:var assignment=child;if(assignment.name.kind==ts__default.SyntaxKind.StringLiteral){var name_2=assignment.name.text;quoted_1.push(name_2)}var propertyName=_this.nameOf(assignment.name);if(isFoldableError(propertyName))return error=propertyName,!0;var propertyValue=isPropertyAssignment(assignment)?_this.evaluateNode(assignment.initializer,!0):resolveName(propertyName,!0);if(isFoldableError(propertyValue))return error=propertyValue,!0;obj_1[propertyName]=isPropertyAssignment(assignment)?recordEntry(propertyValue,assignment.initializer):propertyValue}}),error?error:(this.options.quotedNames&&quoted_1.length&&(obj_1.$quoted$=quoted_1),recordEntry(obj_1,node));case ts__default.SyntaxKind.ArrayLiteralExpression:var arr_1=[];return ts__default.forEachChild(node,function(child){var value=_this.evaluateNode(child,!0);if(isFoldableError(value))return error=value,!0;if(schema.isMetadataSymbolicSpreadExpression(value)&&Array.isArray(value.expression))for(var _i=0,_a=value.expression;_i<_a.length;_i++){var spreadValue=_a[_i];arr_1.push(spreadValue)}else arr_1.push(value)}),error||recordEntry(arr_1,node);case spreadElementSyntaxKind:return recordEntry({__symbolic:"spread",expression:this.evaluateNode(node.expression)},node);case ts__default.SyntaxKind.CallExpression:var callExpression=node;if(isCallOf(callExpression,"forwardRef")&&1===arrayOrEmpty(callExpression.arguments).length){var firstArgument=callExpression.arguments[0];if(firstArgument.kind==ts__default.SyntaxKind.ArrowFunction){var arrowFunction=firstArgument;return recordEntry(this.evaluateNode(arrowFunction.body),node)}}var args=arrayOrEmpty(callExpression.arguments).map(function(arg){return _this.evaluateNode(arg)});if(this.isFoldable(callExpression)&&isMethodCallOf(callExpression,"concat")){var arrayValue=this.evaluateNode(callExpression.expression.expression);return isFoldableError(arrayValue)?arrayValue:arrayValue.concat(args[0])}if(isCallOf(callExpression,"CONST_EXPR")&&1===arrayOrEmpty(callExpression.arguments).length)return recordEntry(args[0],node);var expression=this.evaluateNode(callExpression.expression);if(isFoldableError(expression))return recordEntry(expression,node);var result={__symbolic:"call",expression:expression};return args&&args.length&&(result.arguments=args),recordEntry(result,node);case ts__default.SyntaxKind.NewExpression:var newExpression=node,newArgs=arrayOrEmpty(newExpression.arguments).map(function(arg){return _this.evaluateNode(arg)});if(!this.options.verboseInvalidExpression&&newArgs.some(schema.isMetadataError))return recordEntry(newArgs.find(schema.isMetadataError),node);var newTarget=this.evaluateNode(newExpression.expression);if(schema.isMetadataError(newTarget))return recordEntry(newTarget,node);var call={__symbolic:"new",expression:newTarget};return newArgs.length&&(call.arguments=newArgs),recordEntry(call,node);case ts__default.SyntaxKind.PropertyAccessExpression:var propertyAccessExpression=node,expression_1=this.evaluateNode(propertyAccessExpression.expression);if(isFoldableError(expression_1))return recordEntry(expression_1,node);var member=this.nameOf(propertyAccessExpression.name);return isFoldableError(member)?recordEntry(member,node):expression_1&&this.isFoldable(propertyAccessExpression.expression)?expression_1[member]:schema.isMetadataModuleReferenceExpression(expression_1)?recordEntry({__symbolic:"reference",module:expression_1.module,name:member},node):recordEntry({__symbolic:"select",expression:expression_1,member:member},node);case ts__default.SyntaxKind.ElementAccessExpression:var elementAccessExpression=node,expression_2=this.evaluateNode(elementAccessExpression.expression);if(isFoldableError(expression_2))return recordEntry(expression_2,node);if(!elementAccessExpression.argumentExpression)return recordEntry(errorSymbol("Expression form not supported",node),node);var index=this.evaluateNode(elementAccessExpression.argumentExpression);return isFoldableError(expression_2)?recordEntry(expression_2,node):this.isFoldable(elementAccessExpression.expression)&&this.isFoldable(elementAccessExpression.argumentExpression)?expression_2[index]:recordEntry({__symbolic:"index",expression:expression_2,index:index},node);case ts__default.SyntaxKind.Identifier:var identifier=node,name_3=identifier.text;return resolveName(name_3,preferReference);case ts__default.SyntaxKind.TypeReference:var typeReferenceNode=node,typeNameNode_1=typeReferenceNode.typeName,typeReference=function(node){if(typeNameNode_1.kind===ts__default.SyntaxKind.QualifiedName){var qualifiedName=node,left_1=_this.evaluateNode(qualifiedName.left);return schema.isMetadataModuleReferenceExpression(left_1)?recordEntry({__symbolic:"reference",module:left_1.module,name:qualifiedName.right.text},node):{__symbolic:"select",expression:left_1,member:qualifiedName.right.text}}var identifier_1=typeNameNode_1,symbol=_this.symbols.resolve(identifier_1.text);return isFoldableError(symbol)||schema.isMetadataSymbolicReferenceExpression(symbol)?recordEntry(symbol,node):recordEntry(errorSymbol("Could not resolve type",node,{typeName:identifier_1.text}),node)}(typeNameNode_1);if(isFoldableError(typeReference))return recordEntry(typeReference,node);if(!schema.isMetadataModuleReferenceExpression(typeReference)&&typeReferenceNode.typeArguments&&typeReferenceNode.typeArguments.length){var args_1=typeReferenceNode.typeArguments.map(function(element){return _this.evaluateNode(element)});typeReference.arguments=args_1}return recordEntry(typeReference,node);case ts__default.SyntaxKind.UnionType:for(var unionType=node,references=unionType.types.filter(function(n){return n.kind!=ts__default.SyntaxKind.NullKeyword&&n.kind!=ts__default.SyntaxKind.UndefinedKeyword}).map(function(n){return _this.evaluateNode(n)}),candidate=null,i=0;i<references.length;i++){var reference=references[i];if(!schema.isMetadataSymbolicReferenceExpression(reference))return reference;candidate?reference.name!=candidate.name||reference.module!=candidate.module||reference.arguments||(candidate=reference):candidate=reference}if(candidate)return candidate;break;case ts__default.SyntaxKind.NoSubstitutionTemplateLiteral:case ts__default.SyntaxKind.StringLiteral:case ts__default.SyntaxKind.TemplateHead:case ts__default.SyntaxKind.TemplateTail:case ts__default.SyntaxKind.TemplateMiddle:return node.text;case ts__default.SyntaxKind.NumericLiteral:return parseFloat(node.text);case ts__default.SyntaxKind.AnyKeyword:return recordEntry({__symbolic:"reference",name:"any"},node);case ts__default.SyntaxKind.StringKeyword:return recordEntry({__symbolic:"reference",name:"string"},node);case ts__default.SyntaxKind.NumberKeyword:return recordEntry({__symbolic:"reference",name:"number"},node);case ts__default.SyntaxKind.BooleanKeyword:return recordEntry({__symbolic:"reference",name:"boolean"},node);case ts__default.SyntaxKind.ArrayType:var arrayTypeNode=node;return recordEntry({__symbolic:"reference",name:"Array",arguments:[this.evaluateNode(arrayTypeNode.elementType)]},node);case ts__default.SyntaxKind.NullKeyword:return null;case ts__default.SyntaxKind.TrueKeyword:return!0;case ts__default.SyntaxKind.FalseKeyword:return!1;case ts__default.SyntaxKind.ParenthesizedExpression:var parenthesizedExpression=node;return this.evaluateNode(parenthesizedExpression.expression);case ts__default.SyntaxKind.TypeAssertionExpression:var typeAssertion=node;return this.evaluateNode(typeAssertion.expression);case ts__default.SyntaxKind.PrefixUnaryExpression:var prefixUnaryExpression=node,operand=this.evaluateNode(prefixUnaryExpression.operand);if(isDefined(operand)&&isPrimitive(operand))switch(prefixUnaryExpression.operator){case ts__default.SyntaxKind.PlusToken:return+operand;case ts__default.SyntaxKind.MinusToken:return-operand;case ts__default.SyntaxKind.TildeToken:return~operand;case ts__default.SyntaxKind.ExclamationToken:return!operand}var operatorText=void 0;switch(prefixUnaryExpression.operator){case ts__default.SyntaxKind.PlusToken:operatorText="+";break;case ts__default.SyntaxKind.MinusToken:operatorText="-";break;case ts__default.SyntaxKind.TildeToken:operatorText="~";break;case ts__default.SyntaxKind.ExclamationToken:operatorText="!";break;default:return}return recordEntry({__symbolic:"pre",operator:operatorText,operand:operand},node);case ts__default.SyntaxKind.BinaryExpression:var binaryExpression=node,left=this.evaluateNode(binaryExpression.left),right=this.evaluateNode(binaryExpression.right);if(isDefined(left)&&isDefined(right)){if(isPrimitive(left)&&isPrimitive(right))switch(binaryExpression.operatorToken.kind){case ts__default.SyntaxKind.BarBarToken:return left||right;case ts__default.SyntaxKind.AmpersandAmpersandToken:return left&&right;case ts__default.SyntaxKind.AmpersandToken:return left&right;case ts__default.SyntaxKind.BarToken:return left|right;case ts__default.SyntaxKind.CaretToken:return left^right;case ts__default.SyntaxKind.EqualsEqualsToken:return left==right;case ts__default.SyntaxKind.ExclamationEqualsToken:return left!=right;case ts__default.SyntaxKind.EqualsEqualsEqualsToken:return left===right;case ts__default.SyntaxKind.ExclamationEqualsEqualsToken:return left!==right;case ts__default.SyntaxKind.LessThanToken:return left<right;case ts__default.SyntaxKind.GreaterThanToken:return left>right;case ts__default.SyntaxKind.LessThanEqualsToken:return left<=right;case ts__default.SyntaxKind.GreaterThanEqualsToken:return left>=right;case ts__default.SyntaxKind.LessThanLessThanToken:return left<<right;case ts__default.SyntaxKind.GreaterThanGreaterThanToken:return left>>right;case ts__default.SyntaxKind.GreaterThanGreaterThanGreaterThanToken:return left>>>right;case ts__default.SyntaxKind.PlusToken:return left+right;case ts__default.SyntaxKind.MinusToken:return left-right;case ts__default.SyntaxKind.AsteriskToken:return left*right;case ts__default.SyntaxKind.SlashToken:return left/right;case ts__default.SyntaxKind.PercentToken:return left%right}return recordEntry({__symbolic:"binop",operator:binaryExpression.operatorToken.getText(),left:left,right:right},node)}break;case ts__default.SyntaxKind.ConditionalExpression:var conditionalExpression=node,condition=this.evaluateNode(conditionalExpression.condition),thenExpression=this.evaluateNode(conditionalExpression.whenTrue),elseExpression=this.evaluateNode(conditionalExpression.whenFalse);return isPrimitive(condition)?condition?thenExpression:elseExpression:recordEntry({__symbolic:"if",condition:condition,thenExpression:thenExpression,elseExpression:elseExpression},node);case ts__default.SyntaxKind.FunctionExpression:case ts__default.SyntaxKind.ArrowFunction:return recordEntry(errorSymbol("Lambda not supported",node),node);case ts__default.SyntaxKind.TaggedTemplateExpression:return recordEntry(errorSymbol("Tagged template expressions are not supported in metadata",node),node);case ts__default.SyntaxKind.TemplateExpression:var templateExpression=node;return this.isFoldable(node)?templateExpression.templateSpans.reduce(function(previous,current){return previous+_this.evaluateNode(current.expression)+_this.evaluateNode(current.literal)},this.evaluateNode(templateExpression.head)):templateExpression.templateSpans.reduce(function(previous,current){var expr=_this.evaluateNode(current.expression),literal=_this.evaluateNode(current.literal);if(isFoldableError(expr))return expr;if(isFoldableError(literal))return literal;if("string"==typeof previous&&"string"==typeof expr&&"string"==typeof literal)return previous+expr+literal;var result=expr;return""!==previous&&(result={__symbolic:"binop",operator:"+",left:previous,right:expr}),""!=literal&&(result={__symbolic:"binop",operator:"+",left:result,right:literal}),result},this.evaluateNode(templateExpression.head));case ts__default.SyntaxKind.AsExpression:var asExpression=node;return this.evaluateNode(asExpression.expression);case ts__default.SyntaxKind.ClassExpression:return{__symbolic:"class"}}return recordEntry(errorSymbol("Expression form not supported",node),node)},Evaluator}();exports.Evaluator=Evaluator;var empty=ts__default.createNodeArray()}),symbols$2=createCommonjsModule(function(module,exports){function populateBuiltins(symbols){["Object","Function","String","Number","Array","Boolean","Map","NaN","Infinity","Math","Date","RegExp","Error","Error","EvalError","RangeError","ReferenceError","SyntaxError","TypeError","URIError","JSON","ArrayBuffer","DataView","Int8Array","Uint8Array","Uint8ClampedArray","Uint16Array","Int16Array","Int32Array","Uint32Array","Float32Array","Float64Array"].forEach(function(name){return symbols.set(name,{__symbolic:"reference",name:name})})}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0});var Symbols=function(){function Symbols(sourceFile){this.sourceFile=sourceFile,this.references=new Map}return Symbols.prototype.resolve=function(name,preferReference){return preferReference&&this.references.get(name)||this.symbols.get(name)},Symbols.prototype.define=function(name,value){this.symbols.set(name,value)},Symbols.prototype.defineReference=function(name,value){this.references.set(name,value)},Symbols.prototype.has=function(name){return this.symbols.has(name)},Object.defineProperty(Symbols.prototype,"symbols",{get:function(){var result=this._symbols;return result||(result=this._symbols=new Map,populateBuiltins(result),this.buildImports()),result},enumerable:!0,configurable:!0}),Symbols.prototype.buildImports=function(){var _this=this,symbols=this._symbols,stripQuotes=function(s){return s.replace(/^['"]|['"]$/g,"")},visit=function(node){switch(node.kind){case ts__default.SyntaxKind.ImportEqualsDeclaration:var importEqualsDeclaration=node;if(importEqualsDeclaration.moduleReference.kind===ts__default.SyntaxKind.ExternalModuleReference){var externalReference=importEqualsDeclaration.moduleReference;if(externalReference.expression){externalReference.expression.parent||(externalReference.expression.parent=externalReference,externalReference.parent=_this.sourceFile);var from_1=stripQuotes(externalReference.expression.getText());symbols.set(importEqualsDeclaration.name.text,{__symbolic:"reference",module:from_1});break}}symbols.set(importEqualsDeclaration.name.text,{__symbolic:"error",message:"Unsupported import syntax"});break;case ts__default.SyntaxKind.ImportDeclaration:var importDecl=node;if(!importDecl.importClause)break;importDecl.moduleSpecifier.parent||(importDecl.moduleSpecifier.parent=importDecl,importDecl.parent=_this.sourceFile);var from=stripQuotes(importDecl.moduleSpecifier.getText());importDecl.importClause.name&&symbols.set(importDecl.importClause.name.text,{__symbolic:"reference",module:from,default:!0});var bindings=importDecl.importClause.namedBindings;if(bindings)switch(bindings.kind){case ts__default.SyntaxKind.NamedImports:for(var _i=0,_a=bindings.elements;_i<_a.length;_i++){var binding=_a[_i];symbols.set(binding.name.text,{__symbolic:"reference",module:from,name:binding.propertyName?binding.propertyName.text:binding.name.text})}break;case ts__default.SyntaxKind.NamespaceImport:symbols.set(bindings.name.text,{__symbolic:"reference",module:from})}}ts__default.forEachChild(node,visit)};this.sourceFile&&ts__default.forEachChild(this.sourceFile,visit)},Symbols}();exports.Symbols=Symbols}),collector=createCommonjsModule(function(module,exports){function validateMetadata(sourceFile,nodeMap,metadata){function validateExpression(expression){if(expression)if(Array.isArray(expression))expression.forEach(validateExpression);else if("object"!=typeof expression||expression.hasOwnProperty("__symbolic")){if(schema.isMetadataError(expression))reportError(expression);else if(schema.isMetadataGlobalReferenceExpression(expression)){if(!locals.has(expression.name)){var reference=metadata[expression.name];reference&&validateExpression(reference)}}else if(schema.isFunctionMetadata(expression))validateFunction(expression);else if(schema.isMetadataSymbolicExpression(expression))switch(expression.__symbolic){case"binary":var binaryExpression=expression;validateExpression(binaryExpression.left),validateExpression(binaryExpression.right);break;case"call":case"new":var callExpression=expression;validateExpression(callExpression.expression),callExpression.arguments&&callExpression.arguments.forEach(validateExpression);break;case"index":var indexExpression=expression;validateExpression(indexExpression.expression),validateExpression(indexExpression.index);break;case"pre":var prefixExpression=expression;validateExpression(prefixExpression.operand);break;case"select":var selectExpression=expression;validateExpression(selectExpression.expression);break;case"spread":var spreadExpression=expression;validateExpression(spreadExpression.expression);break;case"if":var ifExpression=expression;validateExpression(ifExpression.condition),validateExpression(ifExpression.elseExpression),validateExpression(ifExpression.thenExpression)}}else Object.getOwnPropertyNames(expression).forEach(function(v){return validateExpression(expression[v])})}function validateMember(classData,member){member.decorators&&member.decorators.forEach(validateExpression),schema.isMethodMetadata(member)&&member.parameterDecorators&&member.parameterDecorators.forEach(validateExpression),classData.decorators&&schema.isConstructorMetadata(member)&&member.parameters&&member.parameters.forEach(validateExpression)}function validateClass(classData){classData.decorators&&classData.decorators.forEach(validateExpression),classData.members&&Object.getOwnPropertyNames(classData.members).forEach(function(name){return classData.members[name].forEach(function(m){return validateMember(classData,m)})}),classData.statics&&Object.getOwnPropertyNames(classData.statics).forEach(function(name){var staticMember=classData.statics[name];validateExpression(schema.isFunctionMetadata(staticMember)?staticMember.value:staticMember)})}function validateFunction(functionDeclaration){if(functionDeclaration.value){var oldLocals=locals;functionDeclaration.parameters&&(locals=new Set(oldLocals.values()),functionDeclaration.parameters&&functionDeclaration.parameters.forEach(function(n){return locals.add(n)})),validateExpression(functionDeclaration.value),locals=oldLocals}}function shouldReportNode(node){if(node){var nodeStart=node.getStart();return!(node.pos!=nodeStart&&sourceFile.text.substring(node.pos,nodeStart).indexOf("@dynamic")>=0)}return!0}function reportError(error){if(shouldReportNode(nodeMap.get(error))){var lineInfo=void 0!=error.line?void 0!=error.character?":"+(error.line+1)+":"+(error.character+1):":"+(error.line+1):"";throw new Error(""+sourceFile.fileName+lineInfo+": Metadata collected contains an error that will be reported at runtime: "+expandedMessage(error)+".\n  "+JSON.stringify(error))}}var locals=new Set(["Array","Object","Set","Map","string","number","any"]);Object.getOwnPropertyNames(metadata).forEach(function(name){var entry=metadata[name];try{schema.isClassMetadata(entry)&&validateClass(entry)}catch(e){var node=nodeMap.get(entry);if(shouldReportNode(node)){if(node){var _a=sourceFile.getLineAndCharacterOfPosition(node.getStart()),line=_a.line,character=_a.character;throw new Error(sourceFile.fileName+":"+(line+1)+":"+(character+1)+": Error encountered in metadata generated for exported symbol '"+name+"': \n "+e.message)}throw new Error("Error encountered in metadata generated for exported symbol "+name+": \n "+e.message)}}})}function namesOf(parameters){function addNamesOf(name){if(name.kind==ts__default.SyntaxKind.Identifier){var identifier=name;result.push(identifier.text)}else for(var bindingPattern=name,_i=0,_a=bindingPattern.elements;_i<_a.length;_i++){var element=_a[_i],name_11=element.name;name_11&&addNamesOf(name_11)}}for(var result=[],_i=0,parameters_2=parameters;_i<parameters_2.length;_i++){addNamesOf(parameters_2[_i].name)}return result}function expandedMessage(error){switch(error.message){case"Reference to non-exported class":if(error.context&&error.context.className)return"Reference to a non-exported class "+error.context.className+". Consider exporting the class";break;case"Variable not initialized":return"Only initialized variables and constants can be referenced because the value of this variable is needed by the template compiler";case"Destructuring not supported":return"Referencing an exported destructured variable or constant is not supported by the template compiler. Consider simplifying this to avoid destructuring";case"Could not resolve type":if(error.context&&error.context.typeName)return"Could not resolve type "+error.context.typeName;break;case"Function call not supported":return(error.context&&error.context.name?"Calling function '"+error.context.name+"', f":"F")+"unction calls are not supported. Consider replacing the function or lambda with a reference to an exported function";case"Reference to a local symbol":if(error.context&&error.context.name)return"Reference to a local (non-exported) symbol '"+error.context.name+"'. Consider exporting the symbol"}return error.message}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __assign=commonjsGlobal&&commonjsGlobal.__assign||Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)Object.prototype.hasOwnProperty.call(s,p)&&(t[p]=s[p])}return t};Object.defineProperty(exports,"__esModule",{value:!0});var isStatic=function(node){return ts__default.getCombinedModifierFlags(node)&ts__default.ModifierFlags.Static},MetadataCollector=function(){function MetadataCollector(options){void 0===options&&(options={}),this.options=options}return MetadataCollector.prototype.getMetadata=function(sourceFile,strict,substituteExpression){function objFromDecorator(decoratorNode){return evaluator$$1.evaluateNode(decoratorNode.expression)}function recordEntry(entry,node){return evaluator.recordMapEntry(entry,node,nodeMap,sourceFile)}function errorSym(message,node,context){return evaluator.errorSymbol(message,node,context,sourceFile)}function maybeGetSimpleFunction(functionDeclaration){if(functionDeclaration.name&&functionDeclaration.name.kind==ts__default.SyntaxKind.Identifier){var nameNode=functionDeclaration.name,functionName=nameNode.text,functionBody=functionDeclaration.body;if(functionBody&&1==functionBody.statements.length){var statement=functionBody.statements[0];if(statement.kind===ts__default.SyntaxKind.ReturnStatement){var returnStatement=statement;if(returnStatement.expression){var func={__symbolic:"function",parameters:namesOf(functionDeclaration.parameters),value:evaluator$$1.evaluateNode(returnStatement.expression)};return functionDeclaration.parameters.some(function(p){return null!=p.initializer})&&(func.defaults=functionDeclaration.parameters.map(function(p){return p.initializer&&evaluator$$1.evaluateNode(p.initializer)})),recordEntry({func:func,name:functionName},functionDeclaration)}}}}}function classMetadataOf(classDeclaration){function getDecorators(decorators){if(decorators&&decorators.length)return decorators.map(function(decorator){return objFromDecorator(decorator)})}function referenceFrom(node){var result=evaluator$$1.evaluateNode(node);return schema.isMetadataError(result)||schema.isMetadataSymbolicReferenceExpression(result)||schema.isMetadataSymbolicSelectExpression(result)?result:errorSym("Symbol reference expected",node)}function recordMember(name,metadata){members||(members={});var data=members.hasOwnProperty(name)?members[name]:[];data.push(metadata),members[name]=data}function recordStaticMember(name,value){statics||(statics={}),statics[name]=value}var result={__symbolic:"class"};classDeclaration.heritageClauses&&classDeclaration.heritageClauses.forEach(function(hc){hc.token===ts__default.SyntaxKind.ExtendsKeyword&&hc.types&&hc.types.forEach(function(type){return result.extends=referenceFrom(type.expression)})});var typeParameters=classDeclaration.typeParameters;typeParameters&&typeParameters.length&&(result.arity=typeParameters.length),classDeclaration.decorators&&(result.decorators=getDecorators(classDeclaration.decorators));for(var members=null,statics=null,_i=0,_a=classDeclaration.members;_i<_a.length;_i++){var member=_a[_i],isConstructor=!1;switch(member.kind){case ts__default.SyntaxKind.Constructor:case ts__default.SyntaxKind.MethodDeclaration:isConstructor=member.kind===ts__default.SyntaxKind.Constructor;var method=member;if(isStatic(method)){var maybeFunc=maybeGetSimpleFunction(method);maybeFunc&&recordStaticMember(maybeFunc.name,maybeFunc.func);continue}for(var methodDecorators=getDecorators(method.decorators),parameters=method.parameters,parameterDecoratorData=[],parametersData=[],hasDecoratorData=!1,hasParameterData=!1,_b=0,parameters_1=parameters;_b<parameters_1.length;_b++){var parameter=parameters_1[_b],parameterData=getDecorators(parameter.decorators);parameterDecoratorData.push(parameterData),hasDecoratorData=hasDecoratorData||!!parameterData,isConstructor&&(parameter.type?parametersData.push(referenceFrom(parameter.type)):parametersData.push(null),hasParameterData=!0)}var data={__symbolic:isConstructor?"constructor":"method"},name_1=isConstructor?"__ctor__":evaluator$$1.nameOf(member.name);methodDecorators&&(data.decorators=methodDecorators),hasDecoratorData&&(data.parameterDecorators=parameterDecoratorData),hasParameterData&&(data.parameters=parametersData),schema.isMetadataError(name_1)||recordMember(name_1,data);break;case ts__default.SyntaxKind.PropertyDeclaration:case ts__default.SyntaxKind.GetAccessor:case ts__default.SyntaxKind.SetAccessor:var property=member;if(isStatic(property)){var name_2=evaluator$$1.nameOf(property.name);if(!schema.isMetadataError(name_2))if(property.initializer){var value=evaluator$$1.evaluateNode(property.initializer);recordStaticMember(name_2,value)}else recordStaticMember(name_2,errorSym("Variable not initialized",property.name))}var propertyDecorators=getDecorators(property.decorators);if(propertyDecorators){var name_3=evaluator$$1.nameOf(property.name);schema.isMetadataError(name_3)||recordMember(name_3,{__symbolic:"property",decorators:propertyDecorators})}}}return members&&(result.members=members),statics&&(result.statics=statics),recordEntry(result,classDeclaration)}var _this=this;void 0===strict&&(strict=!1);var metadata,locals=new symbols$2.Symbols(sourceFile),nodeMap=new Map,composedSubstituter=substituteExpression&&this.options.substituteExpression?function(value,node){return _this.options.substituteExpression(substituteExpression(value,node),node)}:substituteExpression,evaluatorOptions=substituteExpression?__assign({},this.options,{substituteExpression:composedSubstituter}):this.options,evaluator$$1=new evaluator.Evaluator(locals,nodeMap,evaluatorOptions,function(name,value){metadata||(metadata={}),metadata[name]=value}),exports=void 0,exportMap=new Map;ts__default.forEachChild(sourceFile,function(node){switch(node.kind){case ts__default.SyntaxKind.ExportDeclaration:var exportDeclaration=node,moduleSpecifier=exportDeclaration.moduleSpecifier,exportClause=exportDeclaration.exportClause;moduleSpecifier||exportClause.elements.forEach(function(spec){var exportedAs=spec.name.text,name=(spec.propertyName||spec.name).text;exportMap.set(name,exportedAs)})}});var isExport=function(node){return sourceFile.isDeclarationFile||ts__default.getCombinedModifierFlags(node)&ts__default.ModifierFlags.Export},isExportedIdentifier=function(identifier){return identifier&&exportMap.has(identifier.text)},isExported=function(node){return isExport(node)||isExportedIdentifier(node.name)},exportedIdentifierName=function(identifier){return identifier&&(exportMap.get(identifier.text)||identifier.text)},exportedName=function(node){return exportedIdentifierName(node.name)};if(ts__default.forEachChild(sourceFile,function(node){switch(node.kind){case ts__default.SyntaxKind.ClassDeclaration:var classDeclaration=node;if(classDeclaration.name){var className=classDeclaration.name.text;isExported(classDeclaration)?locals.define(className,{__symbolic:"reference",name:exportedName(classDeclaration)}):locals.define(className,errorSym("Reference to non-exported class",node,{className:className}))}break;case ts__default.SyntaxKind.InterfaceDeclaration:var interfaceDeclaration=node;if(interfaceDeclaration.name){var interfaceName=interfaceDeclaration.name.text;locals.define(interfaceName,{__symbolic:"reference",name:"any"})}break;case ts__default.SyntaxKind.FunctionDeclaration:var functionDeclaration=node;if(!isExported(functionDeclaration)){var nameNode=functionDeclaration.name;nameNode&&nameNode.text&&locals.define(nameNode.text,errorSym("Reference to a non-exported function",nameNode,{name:nameNode.text}))}}}),ts__default.forEachChild(sourceFile,function(node){switch(node.kind){case ts__default.SyntaxKind.ExportDeclaration:var exportDeclaration=node,moduleSpecifier=exportDeclaration.moduleSpecifier,exportClause=exportDeclaration.exportClause;if(moduleSpecifier||exportClause&&exportClause.elements.forEach(function(spec){var name=spec.name.text;if(!metadata||!metadata[name]){var propNode=spec.propertyName||spec.name,value=evaluator$$1.evaluateNode(propNode);metadata||(metadata={}),metadata[name]=recordEntry(value,node)}}),moduleSpecifier&&moduleSpecifier.kind==ts__default.SyntaxKind.StringLiteral){var from=moduleSpecifier.text,moduleExport={from:from};exportClause&&(moduleExport.export=exportClause.elements.map(function(spec){return spec.propertyName?{name:spec.propertyName.text,as:spec.name.text}:spec.name.text})),exports||(exports=[]),exports.push(moduleExport)}break;case ts__default.SyntaxKind.ClassDeclaration:var classDeclaration=node;if(classDeclaration.name&&isExported(classDeclaration)){var name_4=exportedName(classDeclaration);name_4&&(metadata||(metadata={}),metadata[name_4]=classMetadataOf(classDeclaration))}break;case ts__default.SyntaxKind.TypeAliasDeclaration:var typeDeclaration=node;if(typeDeclaration.name&&isExported(typeDeclaration)){var name_5=exportedName(typeDeclaration);name_5&&(metadata||(metadata={}),metadata[name_5]={__symbolic:"interface"})}break;case ts__default.SyntaxKind.InterfaceDeclaration:var interfaceDeclaration=node;if(interfaceDeclaration.name&&isExported(interfaceDeclaration)){var name_6=exportedName(interfaceDeclaration);name_6&&(metadata||(metadata={}),metadata[name_6]={__symbolic:"interface"})}break;case ts__default.SyntaxKind.FunctionDeclaration:var functionDeclaration=node;if(isExported(functionDeclaration)&&functionDeclaration.name){var name_7=exportedName(functionDeclaration),maybeFunc=maybeGetSimpleFunction(functionDeclaration);name_7&&(metadata||(metadata={}),metadata[name_7]=maybeFunc?recordEntry(maybeFunc.func,node):{__symbolic:"function"})}break;case ts__default.SyntaxKind.EnumDeclaration:var enumDeclaration=node;if(isExported(enumDeclaration)){for(var enumValueHolder={},enumName=exportedName(enumDeclaration),nextDefaultValue=0,writtenMembers=0,_i=0,_a=enumDeclaration.members;_i<_a.length;_i++){var member=_a[_i],enumValue=void 0;enumValue=member.initializer?evaluator$$1.evaluateNode(member.initializer):nextDefaultValue;var name_8=void 0;if(member.name.kind==ts__default.SyntaxKind.Identifier){name_8=member.name.text,enumValueHolder[name_8]=enumValue,writtenMembers++}nextDefaultValue="number"==typeof enumValue?enumValue+1:name_8?{__symbolic:"binary",operator:"+",left:{__symbolic:"select",expression:recordEntry({__symbolic:"reference",name:enumName},node),name:name_8}}:recordEntry(errorSym("Unsupported enum member name",member.name),node)}writtenMembers&&enumName&&(metadata||(metadata={}),metadata[enumName]=recordEntry(enumValueHolder,node))}break;case ts__default.SyntaxKind.VariableStatement:for(var variableStatement=node,_b=0,_c=variableStatement.declarationList.declarations;_b<_c.length;_b++){var variableDeclaration=_c[_b];!function(variableDeclaration){if(variableDeclaration.name.kind==ts__default.SyntaxKind.Identifier){var nameNode=variableDeclaration.name,varValue=void 0;varValue=variableDeclaration.initializer?evaluator$$1.evaluateNode(variableDeclaration.initializer):recordEntry(errorSym("Variable not initialized",nameNode),nameNode);var exported=!1;if(isExport(variableStatement)||isExport(variableDeclaration)||isExportedIdentifier(nameNode)){var name_9=exportedIdentifierName(nameNode);name_9&&(metadata||(metadata={}),metadata[name_9]=recordEntry(varValue,node)),exported=!0}"string"==typeof varValue||"number"==typeof varValue||"boolean"==typeof varValue?(locals.define(nameNode.text,varValue),exported&&locals.defineReference(nameNode.text,{__symbolic:"reference",name:nameNode.text})):exported||(varValue&&!schema.isMetadataError(varValue)?locals.define(nameNode.text,recordEntry(varValue,node)):locals.define(nameNode.text,recordEntry(errorSym("Reference to a local symbol",nameNode,{name:nameNode.text}),node)))}else{var report_1=function(nameNode){switch(nameNode.kind){case ts__default.SyntaxKind.Identifier:var name_10=nameNode,varValue=errorSym("Destructuring not supported",name_10);locals.define(name_10.text,varValue),isExport(node)&&(metadata||(metadata={}),metadata[name_10.text]=varValue);break;case ts__default.SyntaxKind.BindingElement:report_1(nameNode.name);break;case ts__default.SyntaxKind.ObjectBindingPattern:case ts__default.SyntaxKind.ArrayBindingPattern:nameNode.elements.forEach(report_1)}};report_1(variableDeclaration.name)}}(variableDeclaration)}}}),metadata||exports){metadata?strict&&validateMetadata(sourceFile,nodeMap,metadata):metadata={};var result={__symbolic:"module",version:this.options.version||schema.METADATA_VERSION,metadata:metadata};return sourceFile.moduleName&&(result.importAs=sourceFile.moduleName),exports&&(result.exports=exports),result}},MetadataCollector}();exports.MetadataCollector=MetadataCollector}),bundler=createCommonjsModule(function(module,exports){function resolveModule(importName,from){if(importName.startsWith(".")&&from){var normalPath=path__default.normalize(path__default.join(path__default.dirname(from),importName));return!normalPath.startsWith(".")&&from.startsWith(".")&&(normalPath="."+path__default.sep+normalPath),normalPath.replace(/\\/g,"/")}return importName}function isPrimitive(o){return null===o||"function"!=typeof o&&"object"!=typeof o}function getRootExport(symbol){return symbol.reexportedAs?getRootExport(symbol.reexportedAs):symbol}function getSymbolDeclaration(symbol){return symbol.exports?getSymbolDeclaration(symbol.exports):symbol}Object.defineProperty(exports,"__esModule",{value:!0});/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var PRIVATE_NAME_CHARS="abcdefghijklmnopqrstuvwxyz",MetadataBundler=function(){function MetadataBundler(root,importAs,host){this.root=root,this.importAs=importAs,this.host=host,this.symbolMap=new Map,this.metadataCache=new Map,this.exports=new Map,this.rootModule="./"+path__default.basename(root)}return MetadataBundler.prototype.getMetadataBundle=function(){var exportedSymbols=this.exportAll(this.rootModule);this.canonicalizeSymbols(exportedSymbols);var metadata=this.getEntries(exportedSymbols),privates=Array.from(this.symbolMap.values()).filter(function(s){return s.referenced&&s.isPrivate}).map(function(s){return{privateName:s.privateName,name:s.declaration.name,module:s.declaration.module}}),origins=Array.from(this.symbolMap.values()).filter(function(s){return s.referenced&&!s.reexport}).reduce(function(p,s){return p[s.isPrivate?s.privateName:s.name]=s.declaration.module,p},{}),exports=this.getReExports(exportedSymbols);return{metadata:{__symbolic:"module",version:schema.METADATA_VERSION,exports:exports.length?exports:void 0,metadata:metadata,origins:origins,importAs:this.importAs},privates:privates}},MetadataBundler.resolveModule=function(importName,from){return resolveModule(importName,from)},MetadataBundler.prototype.getMetadata=function(moduleName){var result=this.metadataCache.get(moduleName);if(!result){if(moduleName.startsWith(".")){var fullModuleName=resolveModule(moduleName,this.root);result=this.host.getMetadataFor(fullModuleName)}this.metadataCache.set(moduleName,result)}return result},MetadataBundler.prototype.exportAll=function(moduleName){var _this=this,module=this.getMetadata(moduleName),result=this.exports.get(moduleName);if(result)return result;result=[];var exportSymbol=function(exportedSymbol,exportAs){var symbol=_this.symbolOf(moduleName,exportAs);result.push(symbol),exportedSymbol.reexportedAs=symbol,symbol.exports=exportedSymbol};if(module&&module.metadata)for(var key in module.metadata){var data=module.metadata[key];if(schema.isMetadataImportedSymbolReferenceExpression(data)){var exportFrom=resolveModule(data.module,moduleName);this.exportAll(exportFrom);var symbol=this.symbolOf(exportFrom,data.name);exportSymbol(symbol,key)}else result.push(this.symbolOf(moduleName,key))}if(module&&module.exports)for(var _i=0,_a=module.exports;_i<_a.length;_i++){var exportDeclaration=_a[_i],exportFrom=resolveModule(exportDeclaration.from,moduleName),exportedSymbols=this.exportAll(exportFrom);if(exportDeclaration.export)for(var _b=0,_c=exportDeclaration.export;_b<_c.length;_b++){var exportItem=_c[_b],name_1="string"==typeof exportItem?exportItem:exportItem.name,exportAs="string"==typeof exportItem?exportItem:exportItem.as,symbol=this.symbolOf(exportFrom,name_1);exportedSymbols&&1==exportedSymbols.length&&exportedSymbols[0].reexport&&"*"==exportedSymbols[0].name&&(symbol.reexport=!0),exportSymbol(this.symbolOf(exportFrom,name_1),exportAs)}else for(var exportedSymbols_1=this.exportAll(exportFrom),_d=0,exportedSymbols_2=exportedSymbols_1;_d<exportedSymbols_2.length;_d++){var exportedSymbol=exportedSymbols_2[_d],name_2=exportedSymbol.name;exportSymbol(exportedSymbol,name_2)}}if(!module){var symbol=this.symbolOf(moduleName,"*");symbol.reexport=!0,result.push(symbol)}return this.exports.set(moduleName,result),result},MetadataBundler.prototype.canonicalizeSymbols=function(exportedSymbols){var symbols=Array.from(this.symbolMap.values());this.exported=new Set(exportedSymbols),symbols.forEach(this.canonicalizeSymbol,this)},MetadataBundler.prototype.canonicalizeSymbol=function(symbol){var rootExport=getRootExport(symbol),declaration=getSymbolDeclaration(symbol),isPrivate=!this.exported.has(rootExport),canonicalSymbol=isPrivate?declaration:rootExport;symbol.isPrivate=isPrivate,symbol.declaration=declaration,symbol.canonicalSymbol=canonicalSymbol,symbol.reexport=declaration.reexport},MetadataBundler.prototype.getEntries=function(exportedSymbols){function newPrivateName(){for(;;){for(var digits=[],index=privateName++,base=PRIVATE_NAME_CHARS;!digits.length||index>0;)digits.unshift(base[index%base.length]),index=Math.floor(index/base.length);digits.unshift("ɵ");var result_1=digits.join("");if(!exportedNames.has(result_1))return result_1}}var _this=this,result={},exportedNames=new Set(exportedSymbols.map(function(s){return s.name})),privateName=0;exportedSymbols.forEach(function(symbol){return _this.convertSymbol(symbol)});var symbolsMap=new Map;return Array.from(this.symbolMap.values()).forEach(function(symbol){if(symbol.referenced&&!symbol.reexport){var name_3=symbol.name,identifier=symbol.declaration.module+":"+symbol.declaration.name;if(symbol.isPrivate&&!symbol.privateName&&(name_3=newPrivateName(),symbol.privateName=name_3),symbolsMap.has(identifier)){symbolsMap.get(identifier).push(name_3)}else symbolsMap.set(identifier,[name_3]);result[name_3]=symbol.value}}),symbolsMap.forEach(function(names,identifier){if(names.length>1){var _a=identifier.split(":"),declaredName=(_a[0],_a[1]),reference_1=names.indexOf(declaredName);-1===reference_1&&(reference_1=0),names.forEach(function(name,i){i!==reference_1&&(result[name]={__symbolic:"reference",name:names[reference_1]})})}}),result},MetadataBundler.prototype.getReExports=function(exportedSymbols){for(var modules=new Map,exportAlls=new Set,_i=0,exportedSymbols_3=exportedSymbols;_i<exportedSymbols_3.length;_i++){var symbol=exportedSymbols_3[_i];if(symbol.reexport){var declaration=symbol.declaration,module_2=declaration.module;if("*"==declaration.name)exportAlls.add(declaration.module);else{var entry=modules.get(module_2);entry||(entry=[],modules.set(module_2,entry));var as=symbol.name,name_4=declaration.name;entry.push({name:name_4,as:as})}}}return Array.from(exportAlls.values()).map(function(from){return{from:from}}).concat(Array.from(modules.entries()).map(function(_a){var from=_a[0];return{export:_a[1],from:from}}))},MetadataBundler.prototype.convertSymbol=function(symbol){var canonicalSymbol=symbol.canonicalSymbol;if(!canonicalSymbol.referenced){canonicalSymbol.referenced=!0;var declaration=canonicalSymbol.declaration,module_3=this.getMetadata(declaration.module);if(module_3){var value=module_3.metadata[declaration.name];value&&!declaration.name.startsWith("___")&&(canonicalSymbol.value=this.convertEntry(declaration.module,value))}}},MetadataBundler.prototype.convertEntry=function(moduleName,value){return schema.isClassMetadata(value)?this.convertClass(moduleName,value):schema.isFunctionMetadata(value)?this.convertFunction(moduleName,value):schema.isInterfaceMetadata(value)?value:this.convertValue(moduleName,value)},MetadataBundler.prototype.convertClass=function(moduleName,value){var _this=this;return{__symbolic:"class",arity:value.arity,extends:this.convertExpression(moduleName,value.extends),decorators:value.decorators&&value.decorators.map(function(d){return _this.convertExpression(moduleName,d)}),members:this.convertMembers(moduleName,value.members),statics:value.statics&&this.convertStatics(moduleName,value.statics)}},MetadataBundler.prototype.convertMembers=function(moduleName,members){var _this=this,result={};for(var name_5 in members){var value=members[name_5];result[name_5]=value.map(function(v){return _this.convertMember(moduleName,v)})}return result},MetadataBundler.prototype.convertMember=function(moduleName,member){var _this=this,result={__symbolic:member.__symbolic};return result.decorators=member.decorators&&member.decorators.map(function(d){return _this.convertExpression(moduleName,d)}),schema.isMethodMetadata(member)&&(result.parameterDecorators=member.parameterDecorators&&member.parameterDecorators.map(function(d){return d&&d.map(function(p){return _this.convertExpression(moduleName,p)})}),schema.isConstructorMetadata(member)&&member.parameters&&(result.parameters=member.parameters.map(function(p){return _this.convertExpression(moduleName,p)}))),result},MetadataBundler.prototype.convertStatics=function(moduleName,statics){var result={};for(var key in statics){var value=statics[key];result[key]=schema.isFunctionMetadata(value)?this.convertFunction(moduleName,value):value}return result},MetadataBundler.prototype.convertFunction=function(moduleName,value){var _this=this;return{__symbolic:"function",parameters:value.parameters,defaults:value.defaults&&value.defaults.map(function(v){return _this.convertValue(moduleName,v)}),value:this.convertValue(moduleName,value.value)}},MetadataBundler.prototype.convertValue=function(moduleName,value){var _this=this;if(isPrimitive(value))return value;if(schema.isMetadataError(value))return this.convertError(moduleName,value);if(schema.isMetadataSymbolicExpression(value))return this.convertExpression(moduleName,value);if(Array.isArray(value))return value.map(function(v){return _this.convertValue(moduleName,v)});var object=value,result={};for(var key in object)result[key]=this.convertValue(moduleName,object[key]);return result},MetadataBundler.prototype.convertExpression=function(moduleName,value){if(value)switch(value.__symbolic){case"error":return this.convertError(moduleName,value);case"reference":return this.convertReference(moduleName,value);default:return this.convertExpressionNode(moduleName,value)}return value},MetadataBundler.prototype.convertError=function(module,value){return{__symbolic:"error",message:value.message,line:value.line,character:value.character,context:value.context,module:module}},MetadataBundler.prototype.convertReference=function(moduleName,value){var _this=this,createReference=function(symbol){var declaration=symbol.declaration;return declaration.module.startsWith(".")?(_this.convertSymbol(symbol),{__symbolic:"reference",get name(){var canonicalSymbol=symbol.canonicalSymbol;if(null==canonicalSymbol.isPrivate)throw Error("Invalid state: isPrivate was not initialized");return canonicalSymbol.isPrivate?canonicalSymbol.privateName:canonicalSymbol.name}}):{__symbolic:"reference",name:declaration.name,module:declaration.module}};if(schema.isMetadataGlobalReferenceExpression(value)){var metadata=this.getMetadata(moduleName);return metadata&&metadata.metadata&&metadata.metadata[value.name]?createReference(this.canonicalSymbolOf(moduleName,value.name)):value.arguments?{__symbolic:"reference",name:value.name,arguments:value.arguments.map(function(a){return _this.convertValue(moduleName,a)})}:value}if(schema.isMetadataImportedSymbolReferenceExpression(value)){if(value.module.startsWith(".")){var referencedModule=resolveModule(value.module,moduleName),referencedName=value.name;return createReference(this.canonicalSymbolOf(referencedModule,referencedName))}return value.arguments?{__symbolic:"reference",name:value.name,module:value.module,arguments:value.arguments.map(function(a){return _this.convertValue(moduleName,a)})}:value}if(schema.isMetadataModuleReferenceExpression(value))return value.module.startsWith(".")?{__symbolic:"error",message:"Unsupported bundled module reference",context:{module:value.module}}:value},MetadataBundler.prototype.convertExpressionNode=function(moduleName,value){var result={__symbolic:value.__symbolic};for(var key in value)result[key]=this.convertValue(moduleName,value[key]);return result},MetadataBundler.prototype.symbolOf=function(module,name){var symbolKey=module+":"+name,symbol=this.symbolMap.get(symbolKey);return symbol||(symbol={module:module,name:name},this.symbolMap.set(symbolKey,symbol)),symbol},MetadataBundler.prototype.canonicalSymbolOf=function(module,name){this.exportAll(module);var symbol=this.symbolOf(module,name);return symbol.canonicalSymbol||this.canonicalizeSymbol(symbol),symbol},MetadataBundler}();exports.MetadataBundler=MetadataBundler;var CompilerHostAdapter=function(){function CompilerHostAdapter(host){this.host=host,this.collector=new collector.MetadataCollector}return CompilerHostAdapter.prototype.getMetadataFor=function(fileName){if(this.host.fileExists(fileName+".ts")){var sourceFile=this.host.getSourceFile(fileName+".ts",ts__default.ScriptTarget.Latest);return sourceFile&&this.collector.getMetadata(sourceFile)}},CompilerHostAdapter}();exports.CompilerHostAdapter=CompilerHostAdapter}),index_writer=createCommonjsModule(function(module,exports){function privateEntriesToIndex(index,privates){var results=[INDEX_HEADER];results.push("export * from '"+index+"';","");for(var exports=new Map,_i=0,privates_1=privates;_i<privates_1.length;_i++){var entry=privates_1[_i],entries=exports.get(entry.module);entries||(entries=[],exports.set(entry.module,entries)),entries.push(entry)}for(var compareEntries=compare(function(e){return e.name}),compareModules=compare(function(e){return e[0]}),orderedExports=Array.from(exports).map(function(_a){return[_a[0],_a[1].sort(compareEntries)]}).sort(compareModules),_a=0,orderedExports_1=orderedExports;_a<orderedExports_1.length;_a++){var _b=orderedExports_1[_a],module_1=_b[0],entries=_b[1],symbols=entries.map(function(e){return e.name+" as "+e.privateName});results.push("export {"+symbols+"} from '"+module_1+"';")}return results.join("\n")}function compare(select){return function(a,b){var ak=select(a),bk=select(b);return ak>bk?1:ak<bk?-1:0}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0});var INDEX_HEADER="/**\n * Generated bundle index. Do not edit.\n */\n";exports.privateEntriesToIndex=privateEntriesToIndex}),bundle_index_host=createCommonjsModule(function(module,exports){function createSyntheticIndexHost(delegate,syntheticIndex){var normalSyntheticIndexName=path__default.normalize(syntheticIndex.name),indexContent=syntheticIndex.content,indexMetadata=syntheticIndex.metadata,newHost=Object.create(delegate);return newHost.fileExists=function(fileName){return path__default.normalize(fileName)==normalSyntheticIndexName||delegate.fileExists(fileName)},newHost.readFile=function(fileName){return path__default.normalize(fileName)==normalSyntheticIndexName?indexContent:delegate.readFile(fileName)},newHost.getSourceFile=function(fileName,languageVersion,onError){return path__default.normalize(fileName)==normalSyntheticIndexName?ts__default.createSourceFile(fileName,indexContent,languageVersion,!0):delegate.getSourceFile(fileName,languageVersion,onError)},newHost.writeFile=function(fileName,data,writeByteOrderMark,onError,sourceFiles){if(delegate.writeFile(fileName,data,writeByteOrderMark,onError,sourceFiles),fileName.match(DTS)&&sourceFiles&&1==sourceFiles.length&&path__default.normalize(sourceFiles[0].fileName)==normalSyntheticIndexName){var metadataName=fileName.replace(DTS,".metadata.json");fs__default.writeFileSync(metadataName,indexMetadata,{encoding:"utf8"})}},newHost}function createBundleIndexHost(ngOptions,rootFiles,host){var files=rootFiles.filter(function(f){return!DTS.test(f)});if(1!=files.length)return{host:host,errors:[{file:null,start:null,length:null,messageText:'Angular compiler option "flatModuleIndex" requires one and only one .ts file in the "files" field.',category:ts__default.DiagnosticCategory.Error,code:0}]};var file=files[0],indexModule=file.replace(/\.ts$/,""),bundler$$1=new bundler.MetadataBundler(indexModule,ngOptions.flatModuleId,new bundler.CompilerHostAdapter(host)),metadataBundle=bundler$$1.getMetadataBundle(),metadata=JSON.stringify(metadataBundle.metadata),name=path__default.join(path__default.dirname(indexModule),ngOptions.flatModuleOutFile.replace(JS_EXT,".ts")),libraryIndex="./"+path__default.basename(indexModule);return host=createSyntheticIndexHost(host,{name:name,content:index_writer.privateEntriesToIndex(libraryIndex,metadataBundle.privates),metadata:metadata}),{host:host,indexName:name}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0});var DTS=/\.d\.ts$/,JS_EXT=/(\.js|)$/;exports.createBundleIndexHost=createBundleIndexHost}),index=createCommonjsModule(function(module,exports){/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function __export(m){for(var p in m)exports.hasOwnProperty(p)||(exports[p]=m[p])}Object.defineProperty(exports,"__esModule",{value:!0}),__export(collector),__export(schema),__export(bundle_index_host)}),api=createCommonjsModule(function(module,exports){function isTsDiagnostic(diagnostic){return null!=diagnostic&&"angular"!==diagnostic.source}function isNgDiagnostic(diagnostic){return null!=diagnostic&&"angular"===diagnostic.source}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0}),exports.DEFAULT_ERROR_CODE=100,exports.UNKNOWN_ERROR_CODE=500,exports.SOURCE="angular",exports.isTsDiagnostic=isTsDiagnostic,exports.isNgDiagnostic=isNgDiagnostic;!function(EmitFlags){EmitFlags[EmitFlags.DTS=1]="DTS",EmitFlags[EmitFlags.JS=2]="JS",EmitFlags[EmitFlags.Metadata=4]="Metadata",EmitFlags[EmitFlags.I18nBundle=8]="I18nBundle",EmitFlags[EmitFlags.Codegen=16]="Codegen",EmitFlags[EmitFlags.Default=19]="Default",EmitFlags[EmitFlags.All=31]="All"}(exports.EmitFlags||(exports.EmitFlags={}))}),util=createCommonjsModule(function(module,exports){function tsStructureIsReused(program){return program.structureIsReused}function createMessageDiagnostic(messageText){return{file:void 0,start:void 0,length:void 0,category:ts__default.DiagnosticCategory.Message,messageText:messageText,code:api.DEFAULT_ERROR_CODE,source:api.SOURCE}}function isInRootDir(fileName,options){return!options.rootDir||pathStartsWithPrefix(options.rootDir,fileName)}function relativeToRootDirs(filePath,rootDirs){if(!filePath)return filePath;for(var _i=0,_a=rootDirs||[];_i<_a.length;_i++){var dir=_a[_i],rel=pathStartsWithPrefix(dir,filePath);if(rel)return rel}return filePath}function pathStartsWithPrefix(prefix,fullPath){var rel=path__default.relative(prefix,fullPath);return rel.startsWith("..")?null:rel}function ngToTsDiagnostic(ng){var file,start,length;return ng.span&&(file={fileName:ng.span.start.file.url,text:ng.span.start.file.content},start=ng.span.start.offset,length=ng.span.end.offset-start),{file:file,messageText:ng.messageText,category:ng.category,code:ng.code,start:start,length:length}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0}),exports.GENERATED_FILES=/(.*?)\.(ngfactory|shim\.ngstyle|ngstyle|ngsummary)\.(js|d\.ts|ts)$/,exports.DTS=/\.d\.ts$/,exports.tsStructureIsReused=tsStructureIsReused,exports.createMessageDiagnostic=createMessageDiagnostic,exports.isInRootDir=isInRootDir,exports.relativeToRootDirs=relativeToRootDirs,exports.ngToTsDiagnostic=ngToTsDiagnostic}),metadata_reader=createCommonjsModule(function(module,exports){function createMetadataReaderCache(){return{data:new Map}}function readMetadata(filePath,host,cache){var metadatas=cache&&cache.data.get(filePath);if(metadatas)return metadatas;if(host.fileExists(filePath))if(util.DTS.test(filePath))(metadatas=readMetadataFile(host,filePath))||(metadatas=[upgradeMetadataWithDtsData(host,{__symbolic:"module",version:1,metadata:{}},filePath)]);else{var metadata=host.getSourceFileMetadata(filePath);metadatas=metadata?[metadata]:[]}return!cache||host.cacheMetadata&&!host.cacheMetadata(filePath)||cache.data.set(filePath,metadatas),metadatas}function readMetadataFile(host,dtsFilePath){var metadataPath=dtsFilePath.replace(util.DTS,".metadata.json");if(host.fileExists(metadataPath))try{var metadataOrMetadatas=JSON.parse(host.readFile(metadataPath)),metadatas=metadataOrMetadatas?Array.isArray(metadataOrMetadatas)?metadataOrMetadatas:[metadataOrMetadatas]:[];if(metadatas.length){var maxMetadata=metadatas.reduce(function(p,c){return p.version>c.version?p:c});maxMetadata.version<index.METADATA_VERSION&&metadatas.push(upgradeMetadataWithDtsData(host,maxMetadata,dtsFilePath))}return metadatas}catch(e){throw console.error("Failed to read JSON file "+metadataPath),e}}function upgradeMetadataWithDtsData(host,oldMetadata,dtsFilePath){var newMetadata={__symbolic:"module",version:index.METADATA_VERSION,metadata:__assign({},oldMetadata.metadata)};oldMetadata.exports&&(newMetadata.exports=oldMetadata.exports),oldMetadata.importAs&&(newMetadata.importAs=oldMetadata.importAs),oldMetadata.origins&&(newMetadata.origins=oldMetadata.origins);var dtsMetadata=host.getSourceFileMetadata(dtsFilePath);if(dtsMetadata){for(var prop in dtsMetadata.metadata)newMetadata.metadata[prop]||(newMetadata.metadata[prop]=dtsMetadata.metadata[prop]);dtsMetadata.importAs&&(newMetadata.importAs=dtsMetadata.importAs),(!oldMetadata.version||oldMetadata.version<3)&&dtsMetadata.exports&&(newMetadata.exports=dtsMetadata.exports)}return newMetadata}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __assign=commonjsGlobal&&commonjsGlobal.__assign||Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)Object.prototype.hasOwnProperty.call(s,p)&&(t[p]=s[p])}return t};Object.defineProperty(exports,"__esModule",{value:!0}),exports.createMetadataReaderCache=createMetadataReaderCache,exports.readMetadata=readMetadata}),language_services=createCommonjsModule(function(module,exports){/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports,"__esModule",{value:!0}),exports.getExpressionDiagnostics=expression_diagnostics.getExpressionDiagnostics,exports.getExpressionScope=expression_diagnostics.getExpressionScope,exports.getTemplateExpressionDiagnostics=expression_diagnostics.getTemplateExpressionDiagnostics,exports.AstType=expression_type.AstType,exports.DiagnosticKind=expression_type.DiagnosticKind,exports.TypeDiagnostic=expression_type.TypeDiagnostic,exports.BuiltinType=symbols.BuiltinType,exports.getClassFromStaticSymbol=typescript_symbols.getClassFromStaticSymbol,exports.getClassMembers=typescript_symbols.getClassMembers,exports.getClassMembersFromDeclaration=typescript_symbols.getClassMembersFromDeclaration,exports.getPipesTable=typescript_symbols.getPipesTable,exports.getSymbolQuery=typescript_symbols.getSymbolQuery,exports.MetadataCollector=index.MetadataCollector,exports.createMetadataReaderCache=metadata_reader.createMetadataReaderCache,exports.readMetadata=metadata_reader.readMetadata}),language_services_2=language_services.getExpressionScope,language_services_3=language_services.getTemplateExpressionDiagnostics,language_services_4=language_services.AstType,language_services_7=language_services.BuiltinType,language_services_10=language_services.getClassMembersFromDeclaration,language_services_11=language_services.getPipesTable,language_services_12=language_services.getSymbolQuery,language_services_13=language_services.MetadataCollector,language_services_14=language_services.createMetadataReaderCache,language_services_15=language_services.readMetadata,__window$1="undefined"!=typeof window&&window,__self$1="undefined"!=typeof self&&"undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope&&self,__global$1=void 0!==commonjsGlobal&&commonjsGlobal,_root=__window$1||__global$1||__self$1,root_1=_root;!function(){if(!_root)throw new Error("RxJS could not find any global context (window, self, global)")}();var tryCatchTarget,root={root:root_1},isFunction_2=isFunction,isFunction_1={isFunction:isFunction_2},isArray_1=Array.isArray||function(x){return x&&"number"==typeof x.length},isArray={isArray:isArray_1},isObject_2=isObject,isObject_1={isObject:isObject_2},errorObject_1={e:{}},errorObject={errorObject:errorObject_1},tryCatch_2=tryCatch,tryCatch_1={tryCatch:tryCatch_2},__extends$2=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},UnsubscriptionError=function(_super){function UnsubscriptionError(errors){_super.call(this),this.errors=errors;var err=Error.call(this,errors?errors.length+" errors occurred during unsubscription:\n  "+errors.map(function(err,i){return i+1+") "+err.toString()}).join("\n  "):"");this.name=err.name="UnsubscriptionError",this.stack=err.stack,this.message=err.message}return __extends$2(UnsubscriptionError,_super),UnsubscriptionError}(Error),UnsubscriptionError_2=UnsubscriptionError,UnsubscriptionError_1={UnsubscriptionError:UnsubscriptionError_2},Subscription=function(){function Subscription(unsubscribe){this.closed=!1,this._parent=null,this._parents=null,this._subscriptions=null,unsubscribe&&(this._unsubscribe=unsubscribe)}return Subscription.prototype.unsubscribe=function(){var errors,hasErrors=!1;if(!this.closed){var _a=this,_parent=_a._parent,_parents=_a._parents,_unsubscribe=_a._unsubscribe,_subscriptions=_a._subscriptions;this.closed=!0,this._parent=null,this._parents=null,this._subscriptions=null;for(var index=-1,len=_parents?_parents.length:0;_parent;)_parent.remove(this),_parent=++index<len&&_parents[index]||null;if(isFunction_1.isFunction(_unsubscribe)){var trial=tryCatch_1.tryCatch(_unsubscribe).call(this);trial===errorObject.errorObject&&(hasErrors=!0,errors=errors||(errorObject.errorObject.e instanceof UnsubscriptionError_1.UnsubscriptionError?flattenUnsubscriptionErrors(errorObject.errorObject.e.errors):[errorObject.errorObject.e]))}if(isArray.isArray(_subscriptions))for(index=-1,len=_subscriptions.length;++index<len;){var sub=_subscriptions[index];if(isObject_1.isObject(sub)){var trial=tryCatch_1.tryCatch(sub.unsubscribe).call(sub);if(trial===errorObject.errorObject){hasErrors=!0,errors=errors||[];var err=errorObject.errorObject.e;err instanceof UnsubscriptionError_1.UnsubscriptionError?errors=errors.concat(flattenUnsubscriptionErrors(err.errors)):errors.push(err)}}}if(hasErrors)throw new UnsubscriptionError_1.UnsubscriptionError(errors)}},Subscription.prototype.add=function(teardown){if(!teardown||teardown===Subscription.EMPTY)return Subscription.EMPTY;if(teardown===this)return this;var subscription=teardown;switch(typeof teardown){case"function":subscription=new Subscription(teardown);case"object":if(subscription.closed||"function"!=typeof subscription.unsubscribe)return subscription;if(this.closed)return subscription.unsubscribe(),subscription;if("function"!=typeof subscription._addParent){var tmp=subscription;subscription=new Subscription,subscription._subscriptions=[tmp]}break;default:throw new Error("unrecognized teardown "+teardown+" added to Subscription.")}return(this._subscriptions||(this._subscriptions=[])).push(subscription),subscription._addParent(this),subscription},Subscription.prototype.remove=function(subscription){var subscriptions=this._subscriptions;if(subscriptions){var subscriptionIndex=subscriptions.indexOf(subscription);-1!==subscriptionIndex&&subscriptions.splice(subscriptionIndex,1)}},Subscription.prototype._addParent=function(parent){var _a=this,_parent=_a._parent,_parents=_a._parents;_parent&&_parent!==parent?_parents?-1===_parents.indexOf(parent)&&_parents.push(parent):this._parents=[parent]:this._parent=parent},Subscription.EMPTY=function(empty){return empty.closed=!0,empty}(new Subscription),Subscription}(),Subscription_2=Subscription,Subscription_1={Subscription:Subscription_2},empty={closed:!0,next:function(value){},error:function(err){throw err},complete:function(){}},Observer={empty:empty},rxSubscriber=createCommonjsModule(function(module,exports){var Symbol=root.root.Symbol;exports.rxSubscriber="function"==typeof Symbol&&"function"==typeof Symbol.for?Symbol.for("rxSubscriber"):"@@rxSubscriber",exports.$$rxSubscriber=exports.rxSubscriber}),__extends$1=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},Subscriber=function(_super){function Subscriber(destinationOrNext,error,complete){switch(_super.call(this),this.syncErrorValue=null,this.syncErrorThrown=!1,this.syncErrorThrowable=!1,this.isStopped=!1,arguments.length){case 0:this.destination=Observer.empty;break;case 1:if(!destinationOrNext){this.destination=Observer.empty;break}if("object"==typeof destinationOrNext){destinationOrNext instanceof Subscriber?(this.destination=destinationOrNext,this.destination.add(this)):(this.syncErrorThrowable=!0,this.destination=new SafeSubscriber(this,destinationOrNext));break}default:this.syncErrorThrowable=!0,this.destination=new SafeSubscriber(this,destinationOrNext,error,complete)}}return __extends$1(Subscriber,_super),Subscriber.prototype[rxSubscriber.rxSubscriber]=function(){return this},Subscriber.create=function(next,error,complete){var subscriber=new Subscriber(next,error,complete);return subscriber.syncErrorThrowable=!1,subscriber},Subscriber.prototype.next=function(value){this.isStopped||this._next(value)},Subscriber.prototype.error=function(err){this.isStopped||(this.isStopped=!0,this._error(err))},Subscriber.prototype.complete=function(){this.isStopped||(this.isStopped=!0,this._complete())},Subscriber.prototype.unsubscribe=function(){this.closed||(this.isStopped=!0,_super.prototype.unsubscribe.call(this))},Subscriber.prototype._next=function(value){this.destination.next(value)},Subscriber.prototype._error=function(err){this.destination.error(err),this.unsubscribe()},Subscriber.prototype._complete=function(){this.destination.complete(),this.unsubscribe()},Subscriber.prototype._unsubscribeAndRecycle=function(){var _a=this,_parent=_a._parent,_parents=_a._parents;return this._parent=null,this._parents=null,this.unsubscribe(),this.closed=!1,this.isStopped=!1,this._parent=_parent,this._parents=_parents,this},Subscriber}(Subscription_1.Subscription),Subscriber_2=Subscriber,SafeSubscriber=function(_super){function SafeSubscriber(_parentSubscriber,observerOrNext,error,complete){_super.call(this),this._parentSubscriber=_parentSubscriber;var next,context=this;isFunction_1.isFunction(observerOrNext)?next=observerOrNext:observerOrNext&&(next=observerOrNext.next,error=observerOrNext.error,complete=observerOrNext.complete,observerOrNext!==Observer.empty&&(context=Object.create(observerOrNext),isFunction_1.isFunction(context.unsubscribe)&&this.add(context.unsubscribe.bind(context)),context.unsubscribe=this.unsubscribe.bind(this))),this._context=context,this._next=next,this._error=error,this._complete=complete}return __extends$1(SafeSubscriber,_super),SafeSubscriber.prototype.next=function(value){if(!this.isStopped&&this._next){var _parentSubscriber=this._parentSubscriber;_parentSubscriber.syncErrorThrowable?this.__tryOrSetError(_parentSubscriber,this._next,value)&&this.unsubscribe():this.__tryOrUnsub(this._next,value)}},SafeSubscriber.prototype.error=function(err){if(!this.isStopped){var _parentSubscriber=this._parentSubscriber;if(this._error)_parentSubscriber.syncErrorThrowable?(this.__tryOrSetError(_parentSubscriber,this._error,err),this.unsubscribe()):(this.__tryOrUnsub(this._error,err),this.unsubscribe());else{if(!_parentSubscriber.syncErrorThrowable)throw this.unsubscribe(),err;_parentSubscriber.syncErrorValue=err,_parentSubscriber.syncErrorThrown=!0,this.unsubscribe()}}},SafeSubscriber.prototype.complete=function(){var _this=this;if(!this.isStopped){var _parentSubscriber=this._parentSubscriber;if(this._complete){var wrappedComplete=function(){return _this._complete.call(_this._context)};_parentSubscriber.syncErrorThrowable?(this.__tryOrSetError(_parentSubscriber,wrappedComplete),this.unsubscribe()):(this.__tryOrUnsub(wrappedComplete),this.unsubscribe())}else this.unsubscribe()}},SafeSubscriber.prototype.__tryOrUnsub=function(fn,value){try{fn.call(this._context,value)}catch(err){throw this.unsubscribe(),err}},SafeSubscriber.prototype.__tryOrSetError=function(parent,fn,value){try{fn.call(this._context,value)}catch(err){return parent.syncErrorValue=err,parent.syncErrorThrown=!0,!0}return!1},SafeSubscriber.prototype._unsubscribe=function(){var _parentSubscriber=this._parentSubscriber;this._context=null,this._parentSubscriber=null,_parentSubscriber.unsubscribe()},SafeSubscriber}(Subscriber),Subscriber_1={Subscriber:Subscriber_2},toSubscriber_2=toSubscriber,toSubscriber_1={toSubscriber:toSubscriber_2},observable=createCommonjsModule(function(module,exports){function getSymbolObservable(context){var $$observable,Symbol=context.Symbol;return"function"==typeof Symbol?Symbol.observable?$$observable=Symbol.observable:($$observable=Symbol("observable"),Symbol.observable=$$observable):$$observable="@@observable",$$observable}exports.getSymbolObservable=getSymbolObservable,exports.observable=getSymbolObservable(root.root),exports.$$observable=exports.observable}),noop_2=noop$1$1,noop_1={noop:noop_2},pipe_2=pipe,pipeFromArray_1=pipeFromArray,pipe_1={pipe:pipe_2,pipeFromArray:pipeFromArray_1},Observable=function(){function Observable(subscribe){this._isScalar=!1,subscribe&&(this._subscribe=subscribe)}return Observable.prototype.lift=function(operator){var observable$$1=new Observable;return observable$$1.source=this,observable$$1.operator=operator,observable$$1},Observable.prototype.subscribe=function(observerOrNext,error,complete){var operator=this.operator,sink=toSubscriber_1.toSubscriber(observerOrNext,error,complete);if(operator?operator.call(sink,this.source):sink.add(this.source?this._subscribe(sink):this._trySubscribe(sink)),sink.syncErrorThrowable&&(sink.syncErrorThrowable=!1,sink.syncErrorThrown))throw sink.syncErrorValue;return sink},Observable.prototype._trySubscribe=function(sink){try{return this._subscribe(sink)}catch(err){sink.syncErrorThrown=!0,sink.syncErrorValue=err,sink.error(err)}},Observable.prototype.forEach=function(next,PromiseCtor){var _this=this;if(PromiseCtor||(root.root.Rx&&root.root.Rx.config&&root.root.Rx.config.Promise?PromiseCtor=root.root.Rx.config.Promise:root.root.Promise&&(PromiseCtor=root.root.Promise)),!PromiseCtor)throw new Error("no Promise impl found");return new PromiseCtor(function(resolve,reject){var subscription;subscription=_this.subscribe(function(value){if(subscription)try{next(value)}catch(err){reject(err),subscription.unsubscribe()}else next(value)},reject,resolve)})},Observable.prototype._subscribe=function(subscriber){return this.source.subscribe(subscriber)},Observable.prototype[observable.observable]=function(){return this},Observable.prototype.pipe=function(){for(var operations=[],_i=0;_i<arguments.length;_i++)operations[_i-0]=arguments[_i];return 0===operations.length?this:pipe_1.pipeFromArray(operations)(this)},Observable.prototype.toPromise=function(PromiseCtor){var _this=this;if(PromiseCtor||(root.root.Rx&&root.root.Rx.config&&root.root.Rx.config.Promise?PromiseCtor=root.root.Rx.config.Promise:root.root.Promise&&(PromiseCtor=root.root.Promise)),!PromiseCtor)throw new Error("no Promise impl found");return new PromiseCtor(function(resolve,reject){var value;_this.subscribe(function(x){return value=x},function(err){return reject(err)},function(){return resolve(value)})})},Observable.create=function(subscribe){return new Observable(subscribe)},Observable}(),Observable_2=Observable,Observable_1={Observable:Observable_2},__extends$4=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},ScalarObservable=function(_super){function ScalarObservable(value,scheduler){_super.call(this),this.value=value,this.scheduler=scheduler,this._isScalar=!0,scheduler&&(this._isScalar=!1)}return __extends$4(ScalarObservable,_super),ScalarObservable.create=function(value,scheduler){return new ScalarObservable(value,scheduler)},ScalarObservable.dispatch=function(state){var done=state.done,value=state.value,subscriber=state.subscriber;if(done)return void subscriber.complete();subscriber.next(value),subscriber.closed||(state.done=!0,this.schedule(state))},ScalarObservable.prototype._subscribe=function(subscriber){var value=this.value,scheduler=this.scheduler;if(scheduler)return scheduler.schedule(ScalarObservable.dispatch,0,{done:!1,value:value,subscriber:subscriber});subscriber.next(value),subscriber.closed||subscriber.complete()},ScalarObservable}(Observable_1.Observable),ScalarObservable_2=ScalarObservable,ScalarObservable_1={ScalarObservable:ScalarObservable_2},__extends$5=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},EmptyObservable=function(_super){function EmptyObservable(scheduler){_super.call(this),this.scheduler=scheduler}return __extends$5(EmptyObservable,_super),EmptyObservable.create=function(scheduler){return new EmptyObservable(scheduler)},EmptyObservable.dispatch=function(arg){arg.subscriber.complete()},EmptyObservable.prototype._subscribe=function(subscriber){var scheduler=this.scheduler;if(scheduler)return scheduler.schedule(EmptyObservable.dispatch,0,{subscriber:subscriber});subscriber.complete()},EmptyObservable}(Observable_1.Observable),EmptyObservable_2=EmptyObservable,EmptyObservable_1={EmptyObservable:EmptyObservable_2},isScheduler_2=isScheduler,isScheduler_1={isScheduler:isScheduler_2},__extends$3=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},ArrayObservable=function(_super){function ArrayObservable(array,scheduler){_super.call(this),this.array=array,this.scheduler=scheduler,scheduler||1!==array.length||(this._isScalar=!0,this.value=array[0])}return __extends$3(ArrayObservable,_super),ArrayObservable.create=function(array,scheduler){return new ArrayObservable(array,scheduler)},ArrayObservable.of=function(){for(var array=[],_i=0;_i<arguments.length;_i++)array[_i-0]=arguments[_i];var scheduler=array[array.length-1];isScheduler_1.isScheduler(scheduler)?array.pop():scheduler=null;var len=array.length;return len>1?new ArrayObservable(array,scheduler):1===len?new ScalarObservable_1.ScalarObservable(array[0],scheduler):new EmptyObservable_1.EmptyObservable(scheduler)},ArrayObservable.dispatch=function(state){var array=state.array,index=state.index,count=state.count,subscriber=state.subscriber;if(index>=count)return void subscriber.complete();subscriber.next(array[index]),subscriber.closed||(state.index=index+1,this.schedule(state))},ArrayObservable.prototype._subscribe=function(subscriber){var array=this.array,count=array.length,scheduler=this.scheduler;if(scheduler)return scheduler.schedule(ArrayObservable.dispatch,0,{array:array,index:0,count:count,subscriber:subscriber});for(var i=0;i<count&&!subscriber.closed;i++)subscriber.next(array[i]);subscriber.complete()},ArrayObservable}(Observable_1.Observable),ArrayObservable_2=ArrayObservable,ArrayObservable_1={ArrayObservable:ArrayObservable_2},isArrayLike_1=function(x){return x&&"number"==typeof x.length},isArrayLike={isArrayLike:isArrayLike_1},isPromise_2=isPromise$2,isPromise_1={isPromise:isPromise_2},iterator=createCommonjsModule(function(module,exports){function symbolIteratorPonyfill(root$$2){var Symbol=root$$2.Symbol;if("function"==typeof Symbol)return Symbol.iterator||(Symbol.iterator=Symbol("iterator polyfill")),Symbol.iterator;var Set_1=root$$2.Set;if(Set_1&&"function"==typeof(new Set_1)["@@iterator"])return"@@iterator";var Map_1=root$$2.Map;if(Map_1)for(var keys=Object.getOwnPropertyNames(Map_1.prototype),i=0;i<keys.length;++i){var key=keys[i];if("entries"!==key&&"size"!==key&&Map_1.prototype[key]===Map_1.prototype.entries)return key}return"@@iterator"}exports.symbolIteratorPonyfill=symbolIteratorPonyfill,exports.iterator=symbolIteratorPonyfill(root.root),exports.$$iterator=exports.iterator}),__extends$7=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},InnerSubscriber=function(_super){function InnerSubscriber(parent,outerValue,outerIndex){_super.call(this),this.parent=parent,this.outerValue=outerValue,this.outerIndex=outerIndex,this.index=0}return __extends$7(InnerSubscriber,_super),InnerSubscriber.prototype._next=function(value){this.parent.notifyNext(this.outerValue,value,this.outerIndex,this.index++,this)},InnerSubscriber.prototype._error=function(error){this.parent.notifyError(error,this),this.unsubscribe()},InnerSubscriber.prototype._complete=function(){this.parent.notifyComplete(this),this.unsubscribe()},InnerSubscriber}(Subscriber_1.Subscriber),InnerSubscriber_2=InnerSubscriber,InnerSubscriber_1={InnerSubscriber:InnerSubscriber_2},subscribeToResult_2=subscribeToResult,subscribeToResult_1={subscribeToResult:subscribeToResult_2},__extends$8=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},OuterSubscriber=function(_super){function OuterSubscriber(){_super.apply(this,arguments)}return __extends$8(OuterSubscriber,_super),OuterSubscriber.prototype.notifyNext=function(outerValue,innerValue,outerIndex,innerIndex,innerSub){this.destination.next(innerValue)},OuterSubscriber.prototype.notifyError=function(error,innerSub){this.destination.error(error)},OuterSubscriber.prototype.notifyComplete=function(innerSub){this.destination.complete()},OuterSubscriber}(Subscriber_1.Subscriber),OuterSubscriber_2=OuterSubscriber,OuterSubscriber_1={OuterSubscriber:OuterSubscriber_2},__extends$6=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},mergeMap_2=mergeMap,MergeMapOperator=function(){function MergeMapOperator(project,resultSelector,concurrent){void 0===concurrent&&(concurrent=Number.POSITIVE_INFINITY),this.project=project,this.resultSelector=resultSelector,this.concurrent=concurrent}return MergeMapOperator.prototype.call=function(observer,source){return source.subscribe(new MergeMapSubscriber(observer,this.project,this.resultSelector,this.concurrent))},MergeMapOperator}(),MergeMapOperator_1=MergeMapOperator,MergeMapSubscriber=function(_super){function MergeMapSubscriber(destination,project,resultSelector,concurrent){void 0===concurrent&&(concurrent=Number.POSITIVE_INFINITY),_super.call(this,destination),this.project=project,this.resultSelector=resultSelector,this.concurrent=concurrent,this.hasCompleted=!1,this.buffer=[],this.active=0,this.index=0}return __extends$6(MergeMapSubscriber,_super),MergeMapSubscriber.prototype._next=function(value){this.active<this.concurrent?this._tryNext(value):this.buffer.push(value)},MergeMapSubscriber.prototype._tryNext=function(value){var result,index=this.index++;try{result=this.project(value,index)}catch(err){return void this.destination.error(err)}this.active++,this._innerSub(result,value,index)},MergeMapSubscriber.prototype._innerSub=function(ish,value,index){this.add(subscribeToResult_1.subscribeToResult(this,ish,value,index))},MergeMapSubscriber.prototype._complete=function(){this.hasCompleted=!0,0===this.active&&0===this.buffer.length&&this.destination.complete()},MergeMapSubscriber.prototype.notifyNext=function(outerValue,innerValue,outerIndex,innerIndex,innerSub){this.resultSelector?this._notifyResultSelector(outerValue,innerValue,outerIndex,innerIndex):this.destination.next(innerValue)},MergeMapSubscriber.prototype._notifyResultSelector=function(outerValue,innerValue,outerIndex,innerIndex){var result;try{result=this.resultSelector(outerValue,innerValue,outerIndex,innerIndex)}catch(err){return void this.destination.error(err)}this.destination.next(result)},MergeMapSubscriber.prototype.notifyComplete=function(innerSub){var buffer=this.buffer;this.remove(innerSub),this.active--,buffer.length>0?this._next(buffer.shift()):0===this.active&&this.hasCompleted&&this.destination.complete()},MergeMapSubscriber}(OuterSubscriber_1.OuterSubscriber),MergeMapSubscriber_1=MergeMapSubscriber,mergeMap_1={mergeMap:mergeMap_2,MergeMapOperator:MergeMapOperator_1,MergeMapSubscriber:MergeMapSubscriber_1},identity_2=identity,identity_1={identity:identity_2},mergeAll_2=mergeAll,mergeAll_1={mergeAll:mergeAll_2},merge_2=merge,__extends$11=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},ObjectUnsubscribedError=function(_super){function ObjectUnsubscribedError(){var err=_super.call(this,"object unsubscribed");this.name=err.name="ObjectUnsubscribedError",this.stack=err.stack,this.message=err.message}return __extends$11(ObjectUnsubscribedError,_super),ObjectUnsubscribedError}(Error),ObjectUnsubscribedError_2=ObjectUnsubscribedError,ObjectUnsubscribedError_1={ObjectUnsubscribedError:ObjectUnsubscribedError_2},__extends$12=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},SubjectSubscription=function(_super){function SubjectSubscription(subject,subscriber){_super.call(this),this.subject=subject,this.subscriber=subscriber,this.closed=!1}return __extends$12(SubjectSubscription,_super),SubjectSubscription.prototype.unsubscribe=function(){if(!this.closed){this.closed=!0;var subject=this.subject,observers=subject.observers;if(this.subject=null,observers&&0!==observers.length&&!subject.isStopped&&!subject.closed){var subscriberIndex=observers.indexOf(this.subscriber);-1!==subscriberIndex&&observers.splice(subscriberIndex,1)}}},SubjectSubscription}(Subscription_1.Subscription),SubjectSubscription_2=SubjectSubscription,SubjectSubscription_1={SubjectSubscription:SubjectSubscription_2},__extends$10=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},SubjectSubscriber=function(_super){function SubjectSubscriber(destination){_super.call(this,destination),this.destination=destination}return __extends$10(SubjectSubscriber,_super),SubjectSubscriber}(Subscriber_1.Subscriber),SubjectSubscriber_1=SubjectSubscriber,Subject=function(_super){function Subject(){_super.call(this),this.observers=[],this.closed=!1,this.isStopped=!1,this.hasError=!1,this.thrownError=null}return __extends$10(Subject,_super),Subject.prototype[rxSubscriber.rxSubscriber]=function(){return new SubjectSubscriber(this)},Subject.prototype.lift=function(operator){var subject=new AnonymousSubject(this,this);return subject.operator=operator,subject},Subject.prototype.next=function(value){if(this.closed)throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError;if(!this.isStopped)for(var observers=this.observers,len=observers.length,copy=observers.slice(),i=0;i<len;i++)copy[i].next(value)},Subject.prototype.error=function(err){if(this.closed)throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError;this.hasError=!0,this.thrownError=err,this.isStopped=!0;for(var observers=this.observers,len=observers.length,copy=observers.slice(),i=0;i<len;i++)copy[i].error(err);this.observers.length=0},Subject.prototype.complete=function(){if(this.closed)throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError;this.isStopped=!0;for(var observers=this.observers,len=observers.length,copy=observers.slice(),i=0;i<len;i++)copy[i].complete();this.observers.length=0},Subject.prototype.unsubscribe=function(){this.isStopped=!0,this.closed=!0,this.observers=null},Subject.prototype._trySubscribe=function(subscriber){if(this.closed)throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError;return _super.prototype._trySubscribe.call(this,subscriber)},Subject.prototype._subscribe=function(subscriber){if(this.closed)throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError;return this.hasError?(subscriber.error(this.thrownError),Subscription_1.Subscription.EMPTY):this.isStopped?(subscriber.complete(),Subscription_1.Subscription.EMPTY):(this.observers.push(subscriber),new SubjectSubscription_1.SubjectSubscription(this,subscriber))},Subject.prototype.asObservable=function(){var observable=new Observable_1.Observable;return observable.source=this,observable},Subject.create=function(destination,source){return new AnonymousSubject(destination,source)},Subject}(Observable_1.Observable),Subject_2=Subject,AnonymousSubject=function(_super){function AnonymousSubject(destination,source){_super.call(this),this.destination=destination,this.source=source}return __extends$10(AnonymousSubject,_super),AnonymousSubject.prototype.next=function(value){var destination=this.destination;destination&&destination.next&&destination.next(value)},AnonymousSubject.prototype.error=function(err){var destination=this.destination;destination&&destination.error&&this.destination.error(err)},AnonymousSubject.prototype.complete=function(){var destination=this.destination;destination&&destination.complete&&this.destination.complete()},AnonymousSubject.prototype._subscribe=function(subscriber){return this.source?this.source.subscribe(subscriber):Subscription_1.Subscription.EMPTY},AnonymousSubject}(Subject),AnonymousSubject_1=AnonymousSubject,Subject_1={SubjectSubscriber:SubjectSubscriber_1,Subject:Subject_2,AnonymousSubject:AnonymousSubject_1},__extends$13=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},refCount_2=refCount,RefCountOperator$1=function(){function RefCountOperator(connectable){this.connectable=connectable}return RefCountOperator.prototype.call=function(subscriber,source){var connectable=this.connectable;connectable._refCount++;var refCounter=new RefCountSubscriber$1(subscriber,connectable),subscription=source.subscribe(refCounter);return refCounter.closed||(refCounter.connection=connectable.connect()),subscription},RefCountOperator}(),RefCountSubscriber$1=function(_super){function RefCountSubscriber(destination,connectable){_super.call(this,destination),this.connectable=connectable}return __extends$13(RefCountSubscriber,_super),RefCountSubscriber.prototype._unsubscribe=function(){var connectable=this.connectable;if(!connectable)return void(this.connection=null);this.connectable=null;var refCount=connectable._refCount;if(refCount<=0)return void(this.connection=null);if(connectable._refCount=refCount-1,refCount>1)return void(this.connection=null);var connection=this.connection,sharedConnection=connectable._connection;this.connection=null,!sharedConnection||connection&&sharedConnection!==connection||sharedConnection.unsubscribe()},RefCountSubscriber}(Subscriber_1.Subscriber),refCount_1={refCount:refCount_2},__extends$9=commonjsGlobal&&commonjsGlobal.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},ConnectableObservable=function(_super){function ConnectableObservable(source,subjectFactory){_super.call(this),this.source=source,this.subjectFactory=subjectFactory,this._refCount=0,this._isComplete=!1}return __extends$9(ConnectableObservable,_super),ConnectableObservable.prototype._subscribe=function(subscriber){return this.getSubject().subscribe(subscriber)},ConnectableObservable.prototype.getSubject=function(){var subject=this._subject;return subject&&!subject.isStopped||(this._subject=this.subjectFactory()),this._subject},ConnectableObservable.prototype.connect=function(){var connection=this._connection;return connection||(this._isComplete=!1,connection=this._connection=new Subscription_1.Subscription,connection.add(this.source.subscribe(new ConnectableSubscriber(this.getSubject(),this))),connection.closed?(this._connection=null,connection=Subscription_1.Subscription.EMPTY):this._connection=connection),connection},ConnectableObservable.prototype.refCount=function(){return refCount_1.refCount()(this)},ConnectableObservable}(Observable_1.Observable),ConnectableObservable_2=ConnectableObservable,connectableProto=ConnectableObservable.prototype,connectableObservableDescriptor={operator:{value:null},_refCount:{value:0,writable:!0},_subject:{value:null,writable:!0},_connection:{value:null,writable:!0},_subscribe:{value:connectableProto._subscribe},_isComplete:{value:connectableProto._isComplete,writable:!0},getSubject:{value:connectableProto.getSubject},connect:{value:connectableProto.connect},refCount:{value:connectableProto.refCount}},ConnectableSubscriber=function(_super){function ConnectableSubscriber(destination,connectable){_super.call(this,destination),this.connectable=connectable}return __extends$9(ConnectableSubscriber,_super),ConnectableSubscriber.prototype._error=function(err){this._unsubscribe(),_super.prototype._error.call(this,err)},ConnectableSubscriber.prototype._complete=function(){this.connectable._isComplete=!0,this._unsubscribe(),_super.prototype._complete.call(this)},
ConnectableSubscriber.prototype._unsubscribe=function(){var connectable=this.connectable;if(connectable){this.connectable=null;var connection=connectable._connection;connectable._refCount=0,connectable._subject=null,connectable._connection=null,connection&&connection.unsubscribe()}},ConnectableSubscriber}(Subject_1.SubjectSubscriber),ConnectableObservable_1=(function(_super){function RefCountSubscriber(destination,connectable){_super.call(this,destination),this.connectable=connectable}__extends$9(RefCountSubscriber,_super),RefCountSubscriber.prototype._unsubscribe=function(){var connectable=this.connectable;if(!connectable)return void(this.connection=null);this.connectable=null;var refCount=connectable._refCount;if(refCount<=0)return void(this.connection=null);if(connectable._refCount=refCount-1,refCount>1)return void(this.connection=null);var connection=this.connection,sharedConnection=connectable._connection;this.connection=null,!sharedConnection||connection&&sharedConnection!==connection||sharedConnection.unsubscribe()}}(Subscriber_1.Subscriber),{ConnectableObservable:ConnectableObservable_2,connectableObservableDescriptor:connectableObservableDescriptor}),multicast_2=multicast,MulticastOperator=function(){function MulticastOperator(subjectFactory,selector){this.subjectFactory=subjectFactory,this.selector=selector}return MulticastOperator.prototype.call=function(subscriber,source){var selector=this.selector,subject=this.subjectFactory(),subscription=selector(subject).subscribe(subscriber);return subscription.add(source.subscribe(subject)),subscription},MulticastOperator}(),MulticastOperator_1=MulticastOperator,multicast_1={multicast:multicast_2,MulticastOperator:MulticastOperator_1},share_2$2=share$1,share_1={share:share_2$2},share_3=share,InjectionToken=function(){function InjectionToken(_desc){this._desc=_desc,this.ngMetadataName="InjectionToken"}return InjectionToken.prototype.toString=function(){return"InjectionToken "+this._desc},InjectionToken}(),ANNOTATIONS="__annotations__",PARAMETERS="__paramaters__",ChangeDetectionStrategy$1=(new InjectionToken("AnalyzeForEntryComponents"),makeParamDecorator("Attribute",function(attributeName){return{attributeName:attributeName}}),{OnPush:0,Default:1});ChangeDetectionStrategy$1[ChangeDetectionStrategy$1.OnPush]="OnPush",ChangeDetectionStrategy$1[ChangeDetectionStrategy$1.Default]="Default";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var Directive$1=makeDecorator("Directive",function(dir){return void 0===dir&&(dir={}),dir}),NgModule$1=(makeDecorator("Component",function(c){return void 0===c&&(c={}),__assign({changeDetection:ChangeDetectionStrategy$1.Default},c)},Directive$1),makeDecorator("Pipe",function(p){return __assign({pure:!0},p)}),makeDecorator("NgModule",function(ngModule){return ngModule})),ViewEncapsulation$1={Emulated:0,Native:1,None:2};ViewEncapsulation$1[ViewEncapsulation$1.Emulated]="Emulated",ViewEncapsulation$1[ViewEncapsulation$1.Native]="Native",ViewEncapsulation$1[ViewEncapsulation$1.None]="None";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var trace,events,_platform,Version$1=function(){function Version(full){this.full=full,this.major=full.split(".")[0],this.minor=full.split(".")[1],this.patch=full.split(".").slice(2).join(".")}return Version}(),VERSION$2=new Version$1("5.2.11"),Inject$1=makeParamDecorator("Inject",function(token){return{token:token}}),Optional=makeParamDecorator("Optional"),Injectable=makeDecorator("Injectable"),Self=makeParamDecorator("Self"),SkipSelf=makeParamDecorator("SkipSelf"),__window=(makeParamDecorator("Host"),"undefined"!=typeof window&&window),__self="undefined"!=typeof self&&"undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope&&self,__global="undefined"!=typeof global&&global,_global=__window||__global||__self,promise=Promise.resolve(0),_symbolIterator=null,SOURCE="__source",_THROW_IF_NOT_FOUND=new Object,THROW_IF_NOT_FOUND=_THROW_IF_NOT_FOUND,_NullInjector=function(){function _NullInjector(){}return _NullInjector.prototype.get=function(token,notFoundValue){if(void 0===notFoundValue&&(notFoundValue=_THROW_IF_NOT_FOUND),notFoundValue===_THROW_IF_NOT_FOUND)throw new Error("NullInjectorError: No provider for "+stringify$1(token)+"!");return notFoundValue},_NullInjector}(),Injector=function(){function Injector(){}return Injector.create=function(options,parent){return Array.isArray(options)?new StaticInjector(options,parent):new StaticInjector(options.providers,options.parent,options.name||null)},Injector.THROW_IF_NOT_FOUND=_THROW_IF_NOT_FOUND,Injector.NULL=new _NullInjector,Injector}(),IDENT=function(value){return value},EMPTY=[],CIRCULAR=IDENT,MULTI_PROVIDER_FN=function(){return Array.prototype.slice.call(arguments)},GET_PROPERTY_NAME={},ɵ2=GET_PROPERTY_NAME,USE_VALUE$1=function(objWithPropertyToExtract){for(var key in objWithPropertyToExtract)if(objWithPropertyToExtract[key]===GET_PROPERTY_NAME)return key;throw Error("!prop")}({provide:String,useValue:ɵ2}),NG_TEMP_TOKEN_PATH="ngTempTokenPath",NULL_INJECTOR=Injector.NULL,NEW_LINE=/\n/gm,NO_NEW_LINE="ɵ",StaticInjector=function(){function StaticInjector(providers,parent,source){void 0===parent&&(parent=NULL_INJECTOR),void 0===source&&(source=null),this.parent=parent,this.source=source;var records=this._records=new Map;records.set(Injector,{token:Injector,fn:IDENT,deps:EMPTY,value:this,useNew:!1}),recursivelyProcessProviders(records,providers)}return StaticInjector.prototype.get=function(token,notFoundValue){var record=this._records.get(token);try{return tryResolveToken(token,record,this._records,this.parent,notFoundValue)}catch(e){var tokenPath=e[NG_TEMP_TOKEN_PATH];throw token[SOURCE]&&tokenPath.unshift(token[SOURCE]),e.message=formatError("\n"+e.message,tokenPath,this.source),e.ngTokenPath=tokenPath,e[NG_TEMP_TOKEN_PATH]=null,e}},StaticInjector.prototype.toString=function(){var tokens=[];return this._records.forEach(function(v,token){return tokens.push(stringify$1(token))}),"StaticInjector["+tokens.join(", ")+"]"},StaticInjector}(),ERROR_DEBUG_CONTEXT="ngDebugContext",ERROR_ORIGINAL_ERROR="ngOriginalError",ERROR_LOGGER="ngErrorLogger",ErrorHandler=function(){function ErrorHandler(){this._console=console}return ErrorHandler.prototype.handleError=function(error){var originalError=this._findOriginalError(error),context=this._findContext(error),errorLogger=getErrorLogger(error);errorLogger(this._console,"ERROR",error),originalError&&errorLogger(this._console,"ORIGINAL ERROR",originalError),context&&errorLogger(this._console,"ERROR CONTEXT",context)},ErrorHandler.prototype._findContext=function(error){return error?getDebugContext(error)?getDebugContext(error):this._findContext(getOriginalError(error)):null},ErrorHandler.prototype._findOriginalError=function(error){for(var e=getOriginalError(error);e&&getOriginalError(e);)e=getOriginalError(e);return e},ErrorHandler}(),ReflectiveKey=function(){function ReflectiveKey(token,id){if(this.token=token,this.id=id,!token)throw new Error("Token must be defined!");this.displayName=stringify$1(this.token)}return ReflectiveKey.get=function(token){return _globalKeyRegistry.get(resolveForwardRef$1(token))},Object.defineProperty(ReflectiveKey,"numberOfKeys",{get:function(){return _globalKeyRegistry.numberOfKeys},enumerable:!0,configurable:!0}),ReflectiveKey}(),KeyRegistry=function(){function KeyRegistry(){this._allKeys=new Map}return KeyRegistry.prototype.get=function(token){if(token instanceof ReflectiveKey)return token;if(this._allKeys.has(token))return this._allKeys.get(token);var newKey=new ReflectiveKey(token,ReflectiveKey.numberOfKeys);return this._allKeys.set(token,newKey),newKey},Object.defineProperty(KeyRegistry.prototype,"numberOfKeys",{get:function(){return this._allKeys.size},enumerable:!0,configurable:!0}),KeyRegistry}(),_globalKeyRegistry=new KeyRegistry,Type$1$1=Function,DELEGATE_CTOR=/^function\s+\S+\(\)\s*{[\s\S]+\.apply\(this,\s*arguments\)/,INHERITED_CLASS=/^class\s+[A-Za-z\d$_]*\s*extends\s+[A-Za-z\d$_]+\s*{/,INHERITED_CLASS_WITH_CTOR=/^class\s+[A-Za-z\d$_]*\s*extends\s+[A-Za-z\d$_]+\s*{[\s\S]*constructor\s*\(/,ReflectionCapabilities=function(){function ReflectionCapabilities(reflect){this._reflect=reflect||_global.Reflect}return ReflectionCapabilities.prototype.isReflectionEnabled=function(){return!0},ReflectionCapabilities.prototype.factory=function(t){return function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];return new(t.bind.apply(t,[void 0].concat(args)))}},ReflectionCapabilities.prototype._zipTypesAndAnnotations=function(paramTypes,paramAnnotations){var result;result=void 0===paramTypes?new Array(paramAnnotations.length):new Array(paramTypes.length);for(var i=0;i<result.length;i++)void 0===paramTypes?result[i]=[]:paramTypes[i]!=Object?result[i]=[paramTypes[i]]:result[i]=[],paramAnnotations&&null!=paramAnnotations[i]&&(result[i]=result[i].concat(paramAnnotations[i]));return result},ReflectionCapabilities.prototype._ownParameters=function(type,parentCtor){var typeStr=type.toString();if(DELEGATE_CTOR.exec(typeStr)||INHERITED_CLASS.exec(typeStr)&&!INHERITED_CLASS_WITH_CTOR.exec(typeStr))return null;if(type.parameters&&type.parameters!==parentCtor.parameters)return type.parameters;var tsickleCtorParams=type.ctorParameters;if(tsickleCtorParams&&tsickleCtorParams!==parentCtor.ctorParameters){var ctorParameters="function"==typeof tsickleCtorParams?tsickleCtorParams():tsickleCtorParams,paramTypes_1=ctorParameters.map(function(ctorParam){return ctorParam&&ctorParam.type}),paramAnnotations_1=ctorParameters.map(function(ctorParam){return ctorParam&&convertTsickleDecoratorIntoMetadata(ctorParam.decorators)});return this._zipTypesAndAnnotations(paramTypes_1,paramAnnotations_1)}var paramAnnotations=type.hasOwnProperty(PARAMETERS)&&type[PARAMETERS],paramTypes=this._reflect&&this._reflect.getOwnMetadata&&this._reflect.getOwnMetadata("design:paramtypes",type);return paramTypes||paramAnnotations?this._zipTypesAndAnnotations(paramTypes,paramAnnotations):new Array(type.length).fill(void 0)},ReflectionCapabilities.prototype.parameters=function(type){if(!isType(type))return[];var parentCtor=getParentCtor(type),parameters=this._ownParameters(type,parentCtor);return parameters||parentCtor===Object||(parameters=this.parameters(parentCtor)),parameters||[]},ReflectionCapabilities.prototype._ownAnnotations=function(typeOrFunc,parentCtor){if(typeOrFunc.annotations&&typeOrFunc.annotations!==parentCtor.annotations){var annotations=typeOrFunc.annotations;return"function"==typeof annotations&&annotations.annotations&&(annotations=annotations.annotations),annotations}return typeOrFunc.decorators&&typeOrFunc.decorators!==parentCtor.decorators?convertTsickleDecoratorIntoMetadata(typeOrFunc.decorators):typeOrFunc.hasOwnProperty(ANNOTATIONS)?typeOrFunc[ANNOTATIONS]:null},ReflectionCapabilities.prototype.annotations=function(typeOrFunc){if(!isType(typeOrFunc))return[];var parentCtor=getParentCtor(typeOrFunc),ownAnnotations=this._ownAnnotations(typeOrFunc,parentCtor)||[];return(parentCtor!==Object?this.annotations(parentCtor):[]).concat(ownAnnotations)},ReflectionCapabilities.prototype._ownPropMetadata=function(typeOrFunc,parentCtor){if(typeOrFunc.propMetadata&&typeOrFunc.propMetadata!==parentCtor.propMetadata){var propMetadata=typeOrFunc.propMetadata;return"function"==typeof propMetadata&&propMetadata.propMetadata&&(propMetadata=propMetadata.propMetadata),propMetadata}if(typeOrFunc.propDecorators&&typeOrFunc.propDecorators!==parentCtor.propDecorators){var propDecorators_1=typeOrFunc.propDecorators,propMetadata_1={};return Object.keys(propDecorators_1).forEach(function(prop){propMetadata_1[prop]=convertTsickleDecoratorIntoMetadata(propDecorators_1[prop])}),propMetadata_1}return typeOrFunc.hasOwnProperty("__prop__metadata__")?typeOrFunc.__prop__metadata__:null},ReflectionCapabilities.prototype.propMetadata=function(typeOrFunc){if(!isType(typeOrFunc))return{};var parentCtor=getParentCtor(typeOrFunc),propMetadata={};if(parentCtor!==Object){var parentPropMetadata_1=this.propMetadata(parentCtor);Object.keys(parentPropMetadata_1).forEach(function(propName){propMetadata[propName]=parentPropMetadata_1[propName]})}var ownPropMetadata=this._ownPropMetadata(typeOrFunc,parentCtor);return ownPropMetadata&&Object.keys(ownPropMetadata).forEach(function(propName){var decorators=[];propMetadata.hasOwnProperty(propName)&&decorators.push.apply(decorators,propMetadata[propName]),decorators.push.apply(decorators,ownPropMetadata[propName]),propMetadata[propName]=decorators}),propMetadata},ReflectionCapabilities.prototype.hasLifecycleHook=function(type,lcProperty){return type instanceof Type$1$1&&lcProperty in type.prototype},ReflectionCapabilities.prototype.guards=function(type){return{}},ReflectionCapabilities.prototype.getter=function(name){return new Function("o","return o."+name+";")},ReflectionCapabilities.prototype.setter=function(name){return new Function("o","v","return o."+name+" = v;")},ReflectionCapabilities.prototype.method=function(name){var functionBody="if (!o."+name+") throw new Error('\""+name+"\" is undefined');\n        return o."+name+".apply(o, args);";return new Function("o","args",functionBody)},ReflectionCapabilities.prototype.importUri=function(type){return"object"==typeof type&&type.filePath?type.filePath:"./"+stringify$1(type)},ReflectionCapabilities.prototype.resourceUri=function(type){return"./"+stringify$1(type)},ReflectionCapabilities.prototype.resolveIdentifier=function(name,moduleUrl,members,runtime){return runtime},ReflectionCapabilities.prototype.resolveEnum=function(enumIdentifier,name){return enumIdentifier[name]},ReflectionCapabilities}(),Reflector=function(){function Reflector(reflectionCapabilities){this.reflectionCapabilities=reflectionCapabilities}return Reflector.prototype.updateCapabilities=function(caps){this.reflectionCapabilities=caps},Reflector.prototype.factory=function(type){return this.reflectionCapabilities.factory(type)},Reflector.prototype.parameters=function(typeOrFunc){return this.reflectionCapabilities.parameters(typeOrFunc)},Reflector.prototype.annotations=function(typeOrFunc){return this.reflectionCapabilities.annotations(typeOrFunc)},Reflector.prototype.propMetadata=function(typeOrFunc){return this.reflectionCapabilities.propMetadata(typeOrFunc)},Reflector.prototype.hasLifecycleHook=function(type,lcProperty){return this.reflectionCapabilities.hasLifecycleHook(type,lcProperty)},Reflector.prototype.getter=function(name){return this.reflectionCapabilities.getter(name)},Reflector.prototype.setter=function(name){return this.reflectionCapabilities.setter(name)},Reflector.prototype.method=function(name){return this.reflectionCapabilities.method(name)},Reflector.prototype.importUri=function(type){return this.reflectionCapabilities.importUri(type)},Reflector.prototype.resourceUri=function(type){return this.reflectionCapabilities.resourceUri(type)},Reflector.prototype.resolveIdentifier=function(name,moduleUrl,members,runtime){return this.reflectionCapabilities.resolveIdentifier(name,moduleUrl,members,runtime)},Reflector.prototype.resolveEnum=function(identifier,name){return this.reflectionCapabilities.resolveEnum(identifier,name)},Reflector}(),reflector=new Reflector(new ReflectionCapabilities),ReflectiveDependency=function(){function ReflectiveDependency(key,optional,visibility){this.key=key,this.optional=optional,this.visibility=visibility}return ReflectiveDependency.fromKey=function(key){return new ReflectiveDependency(key,!1,null)},ReflectiveDependency}(),_EMPTY_LIST=[],ResolvedReflectiveProvider_=function(){function ResolvedReflectiveProvider_(key,resolvedFactories,multiProvider){this.key=key,this.resolvedFactories=resolvedFactories,this.multiProvider=multiProvider,this.resolvedFactory=this.resolvedFactories[0]}return ResolvedReflectiveProvider_}(),ResolvedReflectiveFactory=function(){function ResolvedReflectiveFactory(factory,dependencies){this.factory=factory,this.dependencies=dependencies}return ResolvedReflectiveFactory}(),UNDEFINED=new Object,ReflectiveInjector=function(){function ReflectiveInjector(){}return ReflectiveInjector.resolve=function(providers){return resolveReflectiveProviders(providers)},ReflectiveInjector.resolveAndCreate=function(providers,parent){var ResolvedReflectiveProviders=ReflectiveInjector.resolve(providers);return ReflectiveInjector.fromResolvedProviders(ResolvedReflectiveProviders,parent)},ReflectiveInjector.fromResolvedProviders=function(providers,parent){return new ReflectiveInjector_(providers,parent)},ReflectiveInjector}(),ReflectiveInjector_=function(){function ReflectiveInjector_(_providers,_parent){this._constructionCounter=0,this._providers=_providers,this.parent=_parent||null;var len=_providers.length;this.keyIds=new Array(len),this.objs=new Array(len);for(var i=0;i<len;i++)this.keyIds[i]=_providers[i].key.id,this.objs[i]=UNDEFINED}return ReflectiveInjector_.prototype.get=function(token,notFoundValue){return void 0===notFoundValue&&(notFoundValue=THROW_IF_NOT_FOUND),this._getByKey(ReflectiveKey.get(token),null,notFoundValue)},ReflectiveInjector_.prototype.resolveAndCreateChild=function(providers){var ResolvedReflectiveProviders=ReflectiveInjector.resolve(providers);return this.createChildFromResolved(ResolvedReflectiveProviders)},ReflectiveInjector_.prototype.createChildFromResolved=function(providers){var inj=new ReflectiveInjector_(providers);return inj.parent=this,inj},ReflectiveInjector_.prototype.resolveAndInstantiate=function(provider){return this.instantiateResolved(ReflectiveInjector.resolve([provider])[0])},ReflectiveInjector_.prototype.instantiateResolved=function(provider){return this._instantiateProvider(provider)},ReflectiveInjector_.prototype.getProviderAtIndex=function(index){if(index<0||index>=this._providers.length)throw outOfBoundsError(index);return this._providers[index]},ReflectiveInjector_.prototype._new=function(provider){if(this._constructionCounter++>this._getMaxNumberOfObjects())throw cyclicDependencyError(this,provider.key);return this._instantiateProvider(provider)},ReflectiveInjector_.prototype._getMaxNumberOfObjects=function(){return this.objs.length},ReflectiveInjector_.prototype._instantiateProvider=function(provider){if(provider.multiProvider){for(var res=new Array(provider.resolvedFactories.length),i=0;i<provider.resolvedFactories.length;++i)res[i]=this._instantiate(provider,provider.resolvedFactories[i]);return res}return this._instantiate(provider,provider.resolvedFactories[0])},ReflectiveInjector_.prototype._instantiate=function(provider,ResolvedReflectiveFactory$$1){var deps,_this=this,factory=ResolvedReflectiveFactory$$1.factory;try{deps=ResolvedReflectiveFactory$$1.dependencies.map(function(dep){return _this._getByReflectiveDependency(dep)})}catch(e){throw e.addKey&&e.addKey(this,provider.key),e}var obj;try{obj=factory.apply(void 0,deps)}catch(e){throw instantiationError(this,e,e.stack,provider.key)}return obj},ReflectiveInjector_.prototype._getByReflectiveDependency=function(dep){return this._getByKey(dep.key,dep.visibility,dep.optional?null:THROW_IF_NOT_FOUND)},ReflectiveInjector_.prototype._getByKey=function(key,visibility,notFoundValue){return key===ReflectiveInjector_.INJECTOR_KEY?this:visibility instanceof Self?this._getByKeySelf(key,notFoundValue):this._getByKeyDefault(key,notFoundValue,visibility)},ReflectiveInjector_.prototype._getObjByKeyId=function(keyId){for(var i=0;i<this.keyIds.length;i++)if(this.keyIds[i]===keyId)return this.objs[i]===UNDEFINED&&(this.objs[i]=this._new(this._providers[i])),this.objs[i];return UNDEFINED},ReflectiveInjector_.prototype._throwOrNull=function(key,notFoundValue){if(notFoundValue!==THROW_IF_NOT_FOUND)return notFoundValue;throw noProviderError(this,key)},ReflectiveInjector_.prototype._getByKeySelf=function(key,notFoundValue){var obj=this._getObjByKeyId(key.id);return obj!==UNDEFINED?obj:this._throwOrNull(key,notFoundValue)},ReflectiveInjector_.prototype._getByKeyDefault=function(key,notFoundValue,visibility){var inj;for(inj=visibility instanceof SkipSelf?this.parent:this;inj instanceof ReflectiveInjector_;){var inj_=inj,obj=inj_._getObjByKeyId(key.id);if(obj!==UNDEFINED)return obj;inj=inj_.parent}return null!==inj?inj.get(key.token,notFoundValue):this._throwOrNull(key,notFoundValue)},Object.defineProperty(ReflectiveInjector_.prototype,"displayName",{get:function(){return"ReflectiveInjector(providers: ["+_mapProviders(this,function(b){return' "'+b.key.displayName+'" '}).join(", ")+"])"},enumerable:!0,configurable:!0}),ReflectiveInjector_.prototype.toString=function(){return this.displayName},ReflectiveInjector_.INJECTOR_KEY=ReflectiveKey.get(Injector),ReflectiveInjector_}(),APP_INITIALIZER=new InjectionToken("Application Initializer"),ApplicationInitStatus=function(){function ApplicationInitStatus(appInits){var _this=this;this.appInits=appInits,this.initialized=!1,this.done=!1,this.donePromise=new Promise(function(res,rej){_this.resolve=res,_this.reject=rej})}return ApplicationInitStatus.prototype.runInitializers=function(){var _this=this;if(!this.initialized){var asyncInitPromises=[],complete=function(){_this.done=!0,_this.resolve()};if(this.appInits)for(var i=0;i<this.appInits.length;i++){var initResult=this.appInits[i]();isPromise$1(initResult)&&asyncInitPromises.push(initResult)}Promise.all(asyncInitPromises).then(function(){complete()}).catch(function(e){_this.reject(e)}),0===asyncInitPromises.length&&complete(),this.initialized=!0}},ApplicationInitStatus.decorators=[{type:Injectable}],ApplicationInitStatus.ctorParameters=function(){return[{type:Array,decorators:[{type:Inject$1,args:[APP_INITIALIZER]},{type:Optional}]}]},ApplicationInitStatus}(),APP_ID=new InjectionToken("AppId"),APP_ID_RANDOM_PROVIDER={provide:APP_ID,useFactory:_appIdRandomProviderFactory,deps:[]},PLATFORM_INITIALIZER=new InjectionToken("Platform Initializer"),PLATFORM_ID=new InjectionToken("Platform ID"),APP_BOOTSTRAP_LISTENER=new InjectionToken("appBootstrapListener"),Console=(new InjectionToken("Application Packages Root URL"),function(){function Console(){}return Console.prototype.log=function(message){console.log(message)},Console.prototype.warn=function(message){console.warn(message)},Console.decorators=[{type:Injectable}],Console.ctorParameters=function(){return[]},Console}()),Compiler=function(){function Compiler(){}return Compiler.prototype.compileModuleSync=function(moduleType){throw _throwError()},Compiler.prototype.compileModuleAsync=function(moduleType){throw _throwError()},Compiler.prototype.compileModuleAndAllComponentsSync=function(moduleType){throw _throwError()},Compiler.prototype.compileModuleAndAllComponentsAsync=function(moduleType){throw _throwError()},Compiler.prototype.clearCache=function(){},Compiler.prototype.clearCacheFor=function(type){},Compiler.decorators=[{type:Injectable}],Compiler.ctorParameters=function(){return[]},Compiler}(),CompilerFactory=(new InjectionToken("compilerOptions"),function(){function CompilerFactory(){}return CompilerFactory}()),ComponentRef=function(){function ComponentRef(){}return ComponentRef}(),ComponentFactory=function(){function ComponentFactory(){}return ComponentFactory}(),ERROR_COMPONENT="ngComponent",_NullComponentFactoryResolver=function(){function _NullComponentFactoryResolver(){}return _NullComponentFactoryResolver.prototype.resolveComponentFactory=function(component){throw noComponentFactoryError(component)},_NullComponentFactoryResolver}(),ComponentFactoryResolver=function(){function ComponentFactoryResolver(){}return ComponentFactoryResolver.NULL=new _NullComponentFactoryResolver,ComponentFactoryResolver}(),ComponentFactoryBoundToModule=function(_super){function ComponentFactoryBoundToModule(factory,ngModule){var _this=_super.call(this)||this;return _this.factory=factory,_this.ngModule=ngModule,_this.selector=factory.selector,_this.componentType=factory.componentType,_this.ngContentSelectors=factory.ngContentSelectors,_this.inputs=factory.inputs,_this.outputs=factory.outputs,_this}return __extends(ComponentFactoryBoundToModule,_super),ComponentFactoryBoundToModule.prototype.create=function(injector,projectableNodes,rootSelectorOrNode,ngModule){return this.factory.create(injector,projectableNodes,rootSelectorOrNode,ngModule||this.ngModule)},ComponentFactoryBoundToModule}(ComponentFactory),NgModuleRef=function(){function NgModuleRef(){}return NgModuleRef}(),NgModuleFactory=function(){function NgModuleFactory(){}return NgModuleFactory}(),wtfEnabled=function(){var wtf=_global.wtf;return!(!wtf||!(trace=wtf.trace))&&(events=trace.events,!0)}(),wtfCreateScope=wtfEnabled?createScope:function(signature,flags){return noopScope},wtfLeave=wtfEnabled?leave:function(s,r){return r},EventEmitter=function(_super){function EventEmitter(isAsync){void 0===isAsync&&(isAsync=!1);var _this=_super.call(this)||this;return _this.__isAsync=isAsync,_this}return __extends(EventEmitter,_super),EventEmitter.prototype.emit=function(value){_super.prototype.next.call(this,value)},EventEmitter.prototype.subscribe=function(generatorOrNext,error,complete){var schedulerFn,errorFn=function(err){return null},completeFn=function(){return null};generatorOrNext&&"object"==typeof generatorOrNext?(schedulerFn=this.__isAsync?function(value){setTimeout(function(){return generatorOrNext.next(value)})}:function(value){generatorOrNext.next(value)},generatorOrNext.error&&(errorFn=this.__isAsync?function(err){setTimeout(function(){return generatorOrNext.error(err)})}:function(err){generatorOrNext.error(err)}),generatorOrNext.complete&&(completeFn=this.__isAsync?function(){setTimeout(function(){return generatorOrNext.complete()})}:function(){generatorOrNext.complete()})):(schedulerFn=this.__isAsync?function(value){setTimeout(function(){return generatorOrNext(value)})}:function(value){generatorOrNext(value)},error&&(errorFn=this.__isAsync?function(err){setTimeout(function(){return error(err)})}:function(err){error(err)}),complete&&(completeFn=this.__isAsync?function(){setTimeout(function(){return complete()})}:function(){complete()}));var sink=_super.prototype.subscribe.call(this,schedulerFn,errorFn,completeFn);return generatorOrNext instanceof Subscription_2&&generatorOrNext.add(sink),sink},EventEmitter}(Subject_2),NgZone=function(){function NgZone(_a){var _b=_a.enableLongStackTrace,enableLongStackTrace=void 0!==_b&&_b;if(this.hasPendingMicrotasks=!1,this.hasPendingMacrotasks=!1,this.isStable=!0,this.onUnstable=new EventEmitter(!1),this.onMicrotaskEmpty=new EventEmitter(!1),this.onStable=new EventEmitter(!1),this.onError=new EventEmitter(!1),"undefined"==typeof Zone)throw new Error("In this configuration Angular requires Zone.js");Zone.assertZonePatched();var self=this;self._nesting=0,self._outer=self._inner=Zone.current,Zone.wtfZoneSpec&&(self._inner=self._inner.fork(Zone.wtfZoneSpec)),enableLongStackTrace&&Zone.longStackTraceZoneSpec&&(self._inner=self._inner.fork(Zone.longStackTraceZoneSpec)),forkInnerZoneWithAngularBehavior(self)}return NgZone.isInAngularZone=function(){return!0===Zone.current.get("isAngularZone")},NgZone.assertInAngularZone=function(){if(!NgZone.isInAngularZone())throw new Error("Expected to be in Angular Zone, but it is not!")},NgZone.assertNotInAngularZone=function(){if(NgZone.isInAngularZone())throw new Error("Expected to not be in Angular Zone, but it is!")},NgZone.prototype.run=function(fn,applyThis,applyArgs){return this._inner.run(fn,applyThis,applyArgs)},NgZone.prototype.runTask=function(fn,applyThis,applyArgs,name){var zone=this._inner,task=zone.scheduleEventTask("NgZoneEvent: "+name,fn,EMPTY_PAYLOAD,noop,noop);try{return zone.runTask(task,applyThis,applyArgs)}finally{zone.cancelTask(task)}},NgZone.prototype.runGuarded=function(fn,applyThis,applyArgs){return this._inner.runGuarded(fn,applyThis,applyArgs)},NgZone.prototype.runOutsideAngular=function(fn){return this._outer.run(fn)},NgZone}(),EMPTY_PAYLOAD={},NoopNgZone=function(){function NoopNgZone(){this.hasPendingMicrotasks=!1,this.hasPendingMacrotasks=!1,this.isStable=!0,this.onUnstable=new EventEmitter,this.onMicrotaskEmpty=new EventEmitter,this.onStable=new EventEmitter,this.onError=new EventEmitter}return NoopNgZone.prototype.run=function(fn){return fn()},NoopNgZone.prototype.runGuarded=function(fn){return fn()},NoopNgZone.prototype.runOutsideAngular=function(fn){return fn()},NoopNgZone.prototype.runTask=function(fn){return fn()},NoopNgZone}(),Testability=function(){function Testability(_ngZone){this._ngZone=_ngZone,this._pendingCount=0,this._isZoneStable=!0,this._didWork=!1,this._callbacks=[],this._watchAngularEvents()}return Testability.prototype._watchAngularEvents=function(){var _this=this;this._ngZone.onUnstable.subscribe({next:function(){_this._didWork=!0,_this._isZoneStable=!1}}),this._ngZone.runOutsideAngular(function(){_this._ngZone.onStable.subscribe({next:function(){NgZone.assertNotInAngularZone(),scheduleMicroTask(function(){_this._isZoneStable=!0,_this._runCallbacksIfReady()})}})})},Testability.prototype.increasePendingRequestCount=function(){return this._pendingCount+=1,this._didWork=!0,this._pendingCount},Testability.prototype.decreasePendingRequestCount=function(){if(this._pendingCount-=1,this._pendingCount<0)throw new Error("pending async requests below zero");return this._runCallbacksIfReady(),this._pendingCount},Testability.prototype.isStable=function(){return this._isZoneStable&&0==this._pendingCount&&!this._ngZone.hasPendingMacrotasks},Testability.prototype._runCallbacksIfReady=function(){var _this=this;this.isStable()?scheduleMicroTask(function(){for(;0!==_this._callbacks.length;)_this._callbacks.pop()(_this._didWork);_this._didWork=!1}):this._didWork=!0},Testability.prototype.whenStable=function(callback){this._callbacks.push(callback),this._runCallbacksIfReady()},Testability.prototype.getPendingRequestCount=function(){return this._pendingCount},Testability.prototype.findProviders=function(using,provider,exactMatch){return[]},Testability.decorators=[{type:Injectable}],Testability.ctorParameters=function(){return[{type:NgZone}]},Testability}(),TestabilityRegistry=function(){function TestabilityRegistry(){this._applications=new Map,_testabilityGetter.addToWindow(this)}return TestabilityRegistry.prototype.registerApplication=function(token,testability){this._applications.set(token,testability)},TestabilityRegistry.prototype.unregisterApplication=function(token){this._applications.delete(token)},TestabilityRegistry.prototype.unregisterAllApplications=function(){this._applications.clear()},TestabilityRegistry.prototype.getTestability=function(elem){return this._applications.get(elem)||null},TestabilityRegistry.prototype.getAllTestabilities=function(){return Array.from(this._applications.values())},TestabilityRegistry.prototype.getAllRootElements=function(){return Array.from(this._applications.keys())},TestabilityRegistry.prototype.findTestabilityInTree=function(elem,findInAncestors){return void 0===findInAncestors&&(findInAncestors=!0),_testabilityGetter.findTestabilityInTree(this,elem,findInAncestors)},TestabilityRegistry.decorators=[{type:Injectable}],TestabilityRegistry.ctorParameters=function(){return[]},TestabilityRegistry}(),_NoopGetTestability=function(){function _NoopGetTestability(){}return _NoopGetTestability.prototype.addToWindow=function(registry){},_NoopGetTestability.prototype.findTestabilityInTree=function(registry,elem,findInAncestors){return null},_NoopGetTestability}(),_testabilityGetter=new _NoopGetTestability,_devMode=!0,_runModeLocked=!1,ALLOW_MULTIPLE_PLATFORMS=new InjectionToken("AllowMultipleToken"),PlatformRef=function(){function PlatformRef(_injector){this._injector=_injector,this._modules=[],this._destroyListeners=[],this._destroyed=!1}return PlatformRef.prototype.bootstrapModuleFactory=function(moduleFactory,options){var _this=this,ngZoneOption=options?options.ngZone:void 0,ngZone=getNgZone(ngZoneOption),providers=[{provide:NgZone,useValue:ngZone}];return ngZone.run(function(){var ngZoneInjector=Injector.create({providers:providers,parent:_this.injector,name:moduleFactory.moduleType.name}),moduleRef=moduleFactory.create(ngZoneInjector),exceptionHandler=moduleRef.injector.get(ErrorHandler,null);if(!exceptionHandler)throw new Error("No ErrorHandler. Is platform module (BrowserModule) included?");return moduleRef.onDestroy(function(){return remove(_this._modules,moduleRef)}),ngZone.runOutsideAngular(function(){return ngZone.onError.subscribe({next:function(error){exceptionHandler.handleError(error)}})}),_callAndReportToErrorHandler(exceptionHandler,ngZone,function(){var initStatus=moduleRef.injector.get(ApplicationInitStatus);return initStatus.runInitializers(),initStatus.donePromise.then(function(){return _this._moduleDoBootstrap(moduleRef),moduleRef})})})},PlatformRef.prototype.bootstrapModule=function(moduleType,compilerOptions){var _this=this;void 0===compilerOptions&&(compilerOptions=[]);var compilerFactory=this.injector.get(CompilerFactory),options=optionsReducer({},compilerOptions);return compilerFactory.createCompiler([options]).compileModuleAsync(moduleType).then(function(moduleFactory){return _this.bootstrapModuleFactory(moduleFactory,options)})},PlatformRef.prototype._moduleDoBootstrap=function(moduleRef){var appRef=moduleRef.injector.get(ApplicationRef);if(moduleRef._bootstrapComponents.length>0)moduleRef._bootstrapComponents.forEach(function(f){return appRef.bootstrap(f)});else{if(!moduleRef.instance.ngDoBootstrap)throw new Error("The module "+stringify$1(moduleRef.instance.constructor)+' was bootstrapped, but it does not declare "@NgModule.bootstrap" components nor a "ngDoBootstrap" method. Please define one of these.');moduleRef.instance.ngDoBootstrap(appRef)}this._modules.push(moduleRef)},PlatformRef.prototype.onDestroy=function(callback){this._destroyListeners.push(callback)},Object.defineProperty(PlatformRef.prototype,"injector",{get:function(){return this._injector},enumerable:!0,configurable:!0}),PlatformRef.prototype.destroy=function(){if(this._destroyed)throw new Error("The platform has already been destroyed!");this._modules.slice().forEach(function(module){return module.destroy()}),this._destroyListeners.forEach(function(listener){return listener()}),this._destroyed=!0},Object.defineProperty(PlatformRef.prototype,"destroyed",{get:function(){return this._destroyed},enumerable:!0,configurable:!0}),PlatformRef.decorators=[{type:Injectable}],PlatformRef.ctorParameters=function(){return[{type:Injector}]},PlatformRef}(),ApplicationRef=function(){function ApplicationRef(_zone,_console,_injector,_exceptionHandler,_componentFactoryResolver,_initStatus){var _this=this;this._zone=_zone,this._console=_console,this._injector=_injector,this._exceptionHandler=_exceptionHandler,this._componentFactoryResolver=_componentFactoryResolver,this._initStatus=_initStatus,this._bootstrapListeners=[],this._views=[],this._runningTick=!1,this._enforceNoNewChanges=!1,this._stable=!0,this.componentTypes=[],this.components=[],this._enforceNoNewChanges=isDevMode(),this._zone.onMicrotaskEmpty.subscribe({next:function(){_this._zone.run(function(){_this.tick()})}})
;var isCurrentlyStable=new Observable_2(function(observer){_this._stable=_this._zone.isStable&&!_this._zone.hasPendingMacrotasks&&!_this._zone.hasPendingMicrotasks,_this._zone.runOutsideAngular(function(){observer.next(_this._stable),observer.complete()})}),isStable=new Observable_2(function(observer){var stableSub;_this._zone.runOutsideAngular(function(){stableSub=_this._zone.onStable.subscribe(function(){NgZone.assertNotInAngularZone(),scheduleMicroTask(function(){_this._stable||_this._zone.hasPendingMacrotasks||_this._zone.hasPendingMicrotasks||(_this._stable=!0,observer.next(!0))})})});var unstableSub=_this._zone.onUnstable.subscribe(function(){NgZone.assertInAngularZone(),_this._stable&&(_this._stable=!1,_this._zone.runOutsideAngular(function(){observer.next(!1)}))});return function(){stableSub.unsubscribe(),unstableSub.unsubscribe()}});this.isStable=merge_2(isCurrentlyStable,share_3.call(isStable))}return ApplicationRef.prototype.bootstrap=function(componentOrFactory,rootSelectorOrNode){var _this=this;if(!this._initStatus.done)throw new Error("Cannot bootstrap as there are still asynchronous initializers running. Bootstrap components in the `ngDoBootstrap` method of the root module.");var componentFactory;componentFactory=componentOrFactory instanceof ComponentFactory?componentOrFactory:this._componentFactoryResolver.resolveComponentFactory(componentOrFactory),this.componentTypes.push(componentFactory.componentType);var ngModule=componentFactory instanceof ComponentFactoryBoundToModule?null:this._injector.get(NgModuleRef),selectorOrNode=rootSelectorOrNode||componentFactory.selector,compRef=componentFactory.create(Injector.NULL,[],selectorOrNode,ngModule);compRef.onDestroy(function(){_this._unloadComponent(compRef)});var testability=compRef.injector.get(Testability,null);return testability&&compRef.injector.get(TestabilityRegistry).registerApplication(compRef.location.nativeElement,testability),this._loadComponent(compRef),isDevMode()&&this._console.log("Angular is running in the development mode. Call enableProdMode() to enable the production mode."),compRef},ApplicationRef.prototype.tick=function(){var _this=this;if(this._runningTick)throw new Error("ApplicationRef.tick is called recursively");var scope=ApplicationRef._tickScope();try{this._runningTick=!0,this._views.forEach(function(view){return view.detectChanges()}),this._enforceNoNewChanges&&this._views.forEach(function(view){return view.checkNoChanges()})}catch(e){this._zone.runOutsideAngular(function(){return _this._exceptionHandler.handleError(e)})}finally{this._runningTick=!1,wtfLeave(scope)}},ApplicationRef.prototype.attachView=function(viewRef){var view=viewRef;this._views.push(view),view.attachToAppRef(this)},ApplicationRef.prototype.detachView=function(viewRef){var view=viewRef;remove(this._views,view),view.detachFromAppRef()},ApplicationRef.prototype._loadComponent=function(componentRef){this.attachView(componentRef.hostView),this.tick(),this.components.push(componentRef),this._injector.get(APP_BOOTSTRAP_LISTENER,[]).concat(this._bootstrapListeners).forEach(function(listener){return listener(componentRef)})},ApplicationRef.prototype._unloadComponent=function(componentRef){this.detachView(componentRef.hostView),remove(this.components,componentRef)},ApplicationRef.prototype.ngOnDestroy=function(){this._views.slice().forEach(function(view){return view.destroy()})},Object.defineProperty(ApplicationRef.prototype,"viewCount",{get:function(){return this._views.length},enumerable:!0,configurable:!0}),ApplicationRef._tickScope=wtfCreateScope("ApplicationRef#tick()"),ApplicationRef.decorators=[{type:Injectable}],ApplicationRef.ctorParameters=function(){return[{type:NgZone},{type:Console},{type:Injector},{type:ErrorHandler},{type:ComponentFactoryResolver},{type:ApplicationInitStatus}]},ApplicationRef}(),Renderer=function(){function Renderer(){}return Renderer}(),RendererFactory2=(new InjectionToken("Renderer2Interceptor"),function(){function RendererFactory2(){}return RendererFactory2}()),Renderer2=function(){function Renderer2(){}return Renderer2}(),ElementRef=function(){function ElementRef(nativeElement){this.nativeElement=nativeElement}return ElementRef}(),QueryList=function(){function QueryList(){this.dirty=!0,this._results=[],this.changes=new EventEmitter,this.length=0}return QueryList.prototype.map=function(fn){return this._results.map(fn)},QueryList.prototype.filter=function(fn){return this._results.filter(fn)},QueryList.prototype.find=function(fn){return this._results.find(fn)},QueryList.prototype.reduce=function(fn,init){return this._results.reduce(fn,init)},QueryList.prototype.forEach=function(fn){this._results.forEach(fn)},QueryList.prototype.some=function(fn){return this._results.some(fn)},QueryList.prototype.toArray=function(){return this._results.slice()},QueryList.prototype[getSymbolIterator()]=function(){return this._results[getSymbolIterator()]()},QueryList.prototype.toString=function(){return this._results.toString()},QueryList.prototype.reset=function(res){this._results=flatten$2(res),this.dirty=!1,this.length=this._results.length,this.last=this._results[this.length-1],this.first=this._results[0]},QueryList.prototype.notifyOnChanges=function(){this.changes.emit(this)},QueryList.prototype.setDirty=function(){this.dirty=!0},QueryList.prototype.destroy=function(){this.changes.complete(),this.changes.unsubscribe()},QueryList}(),TemplateRef=function(){function TemplateRef(){}return TemplateRef}(),ViewContainerRef=function(){function ViewContainerRef(){}return ViewContainerRef}(),ChangeDetectorRef=function(){function ChangeDetectorRef(){}return ChangeDetectorRef}(),ViewRef=function(_super){function ViewRef(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ViewRef,_super),ViewRef}(ChangeDetectorRef),EventListener=(function(_super){function EmbeddedViewRef(){return null!==_super&&_super.apply(this,arguments)||this}__extends(EmbeddedViewRef,_super)}(ViewRef),function(){function EventListener(name,callback){this.name=name,this.callback=callback}return EventListener}()),DebugNode=function(){function DebugNode(nativeNode,parent,_debugContext){this._debugContext=_debugContext,this.nativeNode=nativeNode,parent&&parent instanceof DebugElement?parent.addChild(this):this.parent=null,this.listeners=[]}return Object.defineProperty(DebugNode.prototype,"injector",{get:function(){return this._debugContext.injector},enumerable:!0,configurable:!0}),Object.defineProperty(DebugNode.prototype,"componentInstance",{get:function(){return this._debugContext.component},enumerable:!0,configurable:!0}),Object.defineProperty(DebugNode.prototype,"context",{get:function(){return this._debugContext.context},enumerable:!0,configurable:!0}),Object.defineProperty(DebugNode.prototype,"references",{get:function(){return this._debugContext.references},enumerable:!0,configurable:!0}),Object.defineProperty(DebugNode.prototype,"providerTokens",{get:function(){return this._debugContext.providerTokens},enumerable:!0,configurable:!0}),DebugNode}(),DebugElement=function(_super){function DebugElement(nativeNode,parent,_debugContext){var _this=_super.call(this,nativeNode,parent,_debugContext)||this;return _this.properties={},_this.attributes={},_this.classes={},_this.styles={},_this.childNodes=[],_this.nativeElement=nativeNode,_this}return __extends(DebugElement,_super),DebugElement.prototype.addChild=function(child){child&&(this.childNodes.push(child),child.parent=this)},DebugElement.prototype.removeChild=function(child){var childIndex=this.childNodes.indexOf(child);-1!==childIndex&&(child.parent=null,this.childNodes.splice(childIndex,1))},DebugElement.prototype.insertChildrenAfter=function(child,newChildren){var _this=this,siblingIndex=this.childNodes.indexOf(child);-1!==siblingIndex&&((_a=this.childNodes).splice.apply(_a,[siblingIndex+1,0].concat(newChildren)),newChildren.forEach(function(c){c.parent&&c.parent.removeChild(c),c.parent=_this}));var _a},DebugElement.prototype.insertBefore=function(refChild,newChild){var refIndex=this.childNodes.indexOf(refChild);-1===refIndex?this.addChild(newChild):(newChild.parent&&newChild.parent.removeChild(newChild),newChild.parent=this,this.childNodes.splice(refIndex,0,newChild))},DebugElement.prototype.query=function(predicate){return this.queryAll(predicate)[0]||null},DebugElement.prototype.queryAll=function(predicate){var matches=[];return _queryElementChildren(this,predicate,matches),matches},DebugElement.prototype.queryAllNodes=function(predicate){var matches=[];return _queryNodeChildren(this,predicate,matches),matches},Object.defineProperty(DebugElement.prototype,"children",{get:function(){return this.childNodes.filter(function(node){return node instanceof DebugElement})},enumerable:!0,configurable:!0}),DebugElement.prototype.triggerEventHandler=function(eventName,eventObj){this.listeners.forEach(function(listener){listener.name==eventName&&listener.callback(eventObj)})},DebugElement}(DebugNode),_nativeNodeToDebugNode=new Map,WrappedValue=function(){function WrappedValue(value){this.wrapped=value}return WrappedValue.wrap=function(value){return new WrappedValue(value)},WrappedValue.unwrap=function(value){return WrappedValue.isWrapped(value)?value.wrapped:value},WrappedValue.isWrapped=function(value){return value instanceof WrappedValue},WrappedValue}(),SimpleChange=function(){function SimpleChange(previousValue,currentValue,firstChange){this.previousValue=previousValue,this.currentValue=currentValue,this.firstChange=firstChange}return SimpleChange.prototype.isFirstChange=function(){return this.firstChange},SimpleChange}(),DefaultIterableDifferFactory=function(){function DefaultIterableDifferFactory(){}return DefaultIterableDifferFactory.prototype.supports=function(obj){return isListLikeIterable(obj)},DefaultIterableDifferFactory.prototype.create=function(trackByFn){return new DefaultIterableDiffer(trackByFn)},DefaultIterableDifferFactory}(),trackByIdentity=function(index,item){return item},DefaultIterableDiffer=function(){function DefaultIterableDiffer(trackByFn){this.length=0,this._linkedRecords=null,this._unlinkedRecords=null,this._previousItHead=null,this._itHead=null,this._itTail=null,this._additionsHead=null,this._additionsTail=null,this._movesHead=null,this._movesTail=null,this._removalsHead=null,this._removalsTail=null,this._identityChangesHead=null,this._identityChangesTail=null,this._trackByFn=trackByFn||trackByIdentity}return DefaultIterableDiffer.prototype.forEachItem=function(fn){var record;for(record=this._itHead;null!==record;record=record._next)fn(record)},DefaultIterableDiffer.prototype.forEachOperation=function(fn){for(var nextIt=this._itHead,nextRemove=this._removalsHead,addRemoveOffset=0,moveOffsets=null;nextIt||nextRemove;){var record=!nextRemove||nextIt&&nextIt.currentIndex<getPreviousIndex(nextRemove,addRemoveOffset,moveOffsets)?nextIt:nextRemove,adjPreviousIndex=getPreviousIndex(record,addRemoveOffset,moveOffsets),currentIndex=record.currentIndex;if(record===nextRemove)addRemoveOffset--,nextRemove=nextRemove._nextRemoved;else if(nextIt=nextIt._next,null==record.previousIndex)addRemoveOffset++;else{moveOffsets||(moveOffsets=[]);var localMovePreviousIndex=adjPreviousIndex-addRemoveOffset,localCurrentIndex=currentIndex-addRemoveOffset;if(localMovePreviousIndex!=localCurrentIndex){for(var i=0;i<localMovePreviousIndex;i++){var offset=i<moveOffsets.length?moveOffsets[i]:moveOffsets[i]=0,index=offset+i;localCurrentIndex<=index&&index<localMovePreviousIndex&&(moveOffsets[i]=offset+1)}var previousIndex=record.previousIndex;moveOffsets[previousIndex]=localCurrentIndex-localMovePreviousIndex}}adjPreviousIndex!==currentIndex&&fn(record,adjPreviousIndex,currentIndex)}},DefaultIterableDiffer.prototype.forEachPreviousItem=function(fn){var record;for(record=this._previousItHead;null!==record;record=record._nextPrevious)fn(record)},DefaultIterableDiffer.prototype.forEachAddedItem=function(fn){var record;for(record=this._additionsHead;null!==record;record=record._nextAdded)fn(record)},DefaultIterableDiffer.prototype.forEachMovedItem=function(fn){var record;for(record=this._movesHead;null!==record;record=record._nextMoved)fn(record)},DefaultIterableDiffer.prototype.forEachRemovedItem=function(fn){var record;for(record=this._removalsHead;null!==record;record=record._nextRemoved)fn(record)},DefaultIterableDiffer.prototype.forEachIdentityChange=function(fn){var record;for(record=this._identityChangesHead;null!==record;record=record._nextIdentityChange)fn(record)},DefaultIterableDiffer.prototype.diff=function(collection){if(null==collection&&(collection=[]),!isListLikeIterable(collection))throw new Error("Error trying to diff '"+stringify$1(collection)+"'. Only arrays and iterables are allowed");return this.check(collection)?this:null},DefaultIterableDiffer.prototype.onDestroy=function(){},DefaultIterableDiffer.prototype.check=function(collection){var _this=this;this._reset();var index,item,itemTrackBy,record=this._itHead,mayBeDirty=!1;if(Array.isArray(collection)){this.length=collection.length;for(var index_1=0;index_1<this.length;index_1++)item=collection[index_1],itemTrackBy=this._trackByFn(index_1,item),null!==record&&looseIdentical(record.trackById,itemTrackBy)?(mayBeDirty&&(record=this._verifyReinsertion(record,item,itemTrackBy,index_1)),looseIdentical(record.item,item)||this._addIdentityChange(record,item)):(record=this._mismatch(record,item,itemTrackBy,index_1),mayBeDirty=!0),record=record._next}else index=0,iterateListLike(collection,function(item){itemTrackBy=_this._trackByFn(index,item),null!==record&&looseIdentical(record.trackById,itemTrackBy)?(mayBeDirty&&(record=_this._verifyReinsertion(record,item,itemTrackBy,index)),looseIdentical(record.item,item)||_this._addIdentityChange(record,item)):(record=_this._mismatch(record,item,itemTrackBy,index),mayBeDirty=!0),record=record._next,index++}),this.length=index;return this._truncate(record),this.collection=collection,this.isDirty},Object.defineProperty(DefaultIterableDiffer.prototype,"isDirty",{get:function(){return null!==this._additionsHead||null!==this._movesHead||null!==this._removalsHead||null!==this._identityChangesHead},enumerable:!0,configurable:!0}),DefaultIterableDiffer.prototype._reset=function(){if(this.isDirty){var record=void 0,nextRecord=void 0;for(record=this._previousItHead=this._itHead;null!==record;record=record._next)record._nextPrevious=record._next;for(record=this._additionsHead;null!==record;record=record._nextAdded)record.previousIndex=record.currentIndex;for(this._additionsHead=this._additionsTail=null,record=this._movesHead;null!==record;record=nextRecord)record.previousIndex=record.currentIndex,nextRecord=record._nextMoved;this._movesHead=this._movesTail=null,this._removalsHead=this._removalsTail=null,this._identityChangesHead=this._identityChangesTail=null}},DefaultIterableDiffer.prototype._mismatch=function(record,item,itemTrackBy,index){var previousRecord;return null===record?previousRecord=this._itTail:(previousRecord=record._prev,this._remove(record)),record=null===this._linkedRecords?null:this._linkedRecords.get(itemTrackBy,index),null!==record?(looseIdentical(record.item,item)||this._addIdentityChange(record,item),this._moveAfter(record,previousRecord,index)):(record=null===this._unlinkedRecords?null:this._unlinkedRecords.get(itemTrackBy,null),null!==record?(looseIdentical(record.item,item)||this._addIdentityChange(record,item),this._reinsertAfter(record,previousRecord,index)):record=this._addAfter(new IterableChangeRecord_(item,itemTrackBy),previousRecord,index)),record},DefaultIterableDiffer.prototype._verifyReinsertion=function(record,item,itemTrackBy,index){var reinsertRecord=null===this._unlinkedRecords?null:this._unlinkedRecords.get(itemTrackBy,null);return null!==reinsertRecord?record=this._reinsertAfter(reinsertRecord,record._prev,index):record.currentIndex!=index&&(record.currentIndex=index,this._addToMoves(record,index)),record},DefaultIterableDiffer.prototype._truncate=function(record){for(;null!==record;){var nextRecord=record._next;this._addToRemovals(this._unlink(record)),record=nextRecord}null!==this._unlinkedRecords&&this._unlinkedRecords.clear(),null!==this._additionsTail&&(this._additionsTail._nextAdded=null),null!==this._movesTail&&(this._movesTail._nextMoved=null),null!==this._itTail&&(this._itTail._next=null),null!==this._removalsTail&&(this._removalsTail._nextRemoved=null),null!==this._identityChangesTail&&(this._identityChangesTail._nextIdentityChange=null)},DefaultIterableDiffer.prototype._reinsertAfter=function(record,prevRecord,index){null!==this._unlinkedRecords&&this._unlinkedRecords.remove(record);var prev=record._prevRemoved,next=record._nextRemoved;return null===prev?this._removalsHead=next:prev._nextRemoved=next,null===next?this._removalsTail=prev:next._prevRemoved=prev,this._insertAfter(record,prevRecord,index),this._addToMoves(record,index),record},DefaultIterableDiffer.prototype._moveAfter=function(record,prevRecord,index){return this._unlink(record),this._insertAfter(record,prevRecord,index),this._addToMoves(record,index),record},DefaultIterableDiffer.prototype._addAfter=function(record,prevRecord,index){return this._insertAfter(record,prevRecord,index),null===this._additionsTail?this._additionsTail=this._additionsHead=record:this._additionsTail=this._additionsTail._nextAdded=record,record},DefaultIterableDiffer.prototype._insertAfter=function(record,prevRecord,index){var next=null===prevRecord?this._itHead:prevRecord._next;return record._next=next,record._prev=prevRecord,null===next?this._itTail=record:next._prev=record,null===prevRecord?this._itHead=record:prevRecord._next=record,null===this._linkedRecords&&(this._linkedRecords=new _DuplicateMap),this._linkedRecords.put(record),record.currentIndex=index,record},DefaultIterableDiffer.prototype._remove=function(record){return this._addToRemovals(this._unlink(record))},DefaultIterableDiffer.prototype._unlink=function(record){null!==this._linkedRecords&&this._linkedRecords.remove(record);var prev=record._prev,next=record._next;return null===prev?this._itHead=next:prev._next=next,null===next?this._itTail=prev:next._prev=prev,record},DefaultIterableDiffer.prototype._addToMoves=function(record,toIndex){return record.previousIndex===toIndex?record:(null===this._movesTail?this._movesTail=this._movesHead=record:this._movesTail=this._movesTail._nextMoved=record,record)},DefaultIterableDiffer.prototype._addToRemovals=function(record){return null===this._unlinkedRecords&&(this._unlinkedRecords=new _DuplicateMap),this._unlinkedRecords.put(record),record.currentIndex=null,record._nextRemoved=null,null===this._removalsTail?(this._removalsTail=this._removalsHead=record,record._prevRemoved=null):(record._prevRemoved=this._removalsTail,this._removalsTail=this._removalsTail._nextRemoved=record),record},DefaultIterableDiffer.prototype._addIdentityChange=function(record,item){return record.item=item,null===this._identityChangesTail?this._identityChangesTail=this._identityChangesHead=record:this._identityChangesTail=this._identityChangesTail._nextIdentityChange=record,record},DefaultIterableDiffer}(),IterableChangeRecord_=function(){function IterableChangeRecord_(item,trackById){this.item=item,this.trackById=trackById,this.currentIndex=null,this.previousIndex=null,this._nextPrevious=null,this._prev=null,this._next=null,this._prevDup=null,this._nextDup=null,this._prevRemoved=null,this._nextRemoved=null,this._nextAdded=null,this._nextMoved=null,this._nextIdentityChange=null}return IterableChangeRecord_}(),_DuplicateItemRecordList=function(){function _DuplicateItemRecordList(){this._head=null,this._tail=null}return _DuplicateItemRecordList.prototype.add=function(record){null===this._head?(this._head=this._tail=record,record._nextDup=null,record._prevDup=null):(this._tail._nextDup=record,record._prevDup=this._tail,record._nextDup=null,this._tail=record)},_DuplicateItemRecordList.prototype.get=function(trackById,atOrAfterIndex){var record;for(record=this._head;null!==record;record=record._nextDup)if((null===atOrAfterIndex||atOrAfterIndex<=record.currentIndex)&&looseIdentical(record.trackById,trackById))return record;return null},_DuplicateItemRecordList.prototype.remove=function(record){var prev=record._prevDup,next=record._nextDup;return null===prev?this._head=next:prev._nextDup=next,null===next?this._tail=prev:next._prevDup=prev,null===this._head},_DuplicateItemRecordList}(),_DuplicateMap=function(){function _DuplicateMap(){this.map=new Map}return _DuplicateMap.prototype.put=function(record){var key=record.trackById,duplicates=this.map.get(key);duplicates||(duplicates=new _DuplicateItemRecordList,this.map.set(key,duplicates)),duplicates.add(record)},_DuplicateMap.prototype.get=function(trackById,atOrAfterIndex){var key=trackById,recordList=this.map.get(key);return recordList?recordList.get(trackById,atOrAfterIndex):null},_DuplicateMap.prototype.remove=function(record){var key=record.trackById;return this.map.get(key).remove(record)&&this.map.delete(key),record},Object.defineProperty(_DuplicateMap.prototype,"isEmpty",{get:function(){return 0===this.map.size},enumerable:!0,configurable:!0}),_DuplicateMap.prototype.clear=function(){this.map.clear()},_DuplicateMap}(),DefaultKeyValueDifferFactory=function(){function DefaultKeyValueDifferFactory(){}return DefaultKeyValueDifferFactory.prototype.supports=function(obj){return obj instanceof Map||isJsObject(obj)},DefaultKeyValueDifferFactory.prototype.create=function(){return new DefaultKeyValueDiffer},DefaultKeyValueDifferFactory}(),DefaultKeyValueDiffer=function(){function DefaultKeyValueDiffer(){this._records=new Map,this._mapHead=null,this._appendAfter=null,this._previousMapHead=null,this._changesHead=null,this._changesTail=null,this._additionsHead=null,this._additionsTail=null,this._removalsHead=null,this._removalsTail=null}return Object.defineProperty(DefaultKeyValueDiffer.prototype,"isDirty",{get:function(){return null!==this._additionsHead||null!==this._changesHead||null!==this._removalsHead},enumerable:!0,configurable:!0}),DefaultKeyValueDiffer.prototype.forEachItem=function(fn){var record;for(record=this._mapHead;null!==record;record=record._next)fn(record)},DefaultKeyValueDiffer.prototype.forEachPreviousItem=function(fn){var record;for(record=this._previousMapHead;null!==record;record=record._nextPrevious)fn(record)},DefaultKeyValueDiffer.prototype.forEachChangedItem=function(fn){var record;for(record=this._changesHead;null!==record;record=record._nextChanged)fn(record)},DefaultKeyValueDiffer.prototype.forEachAddedItem=function(fn){var record;for(record=this._additionsHead;null!==record;record=record._nextAdded)fn(record)},DefaultKeyValueDiffer.prototype.forEachRemovedItem=function(fn){var record;for(record=this._removalsHead;null!==record;record=record._nextRemoved)fn(record)},DefaultKeyValueDiffer.prototype.diff=function(map){if(map){if(!(map instanceof Map||isJsObject(map)))throw new Error("Error trying to diff '"+stringify$1(map)+"'. Only maps and objects are allowed")}else map=new Map;return this.check(map)?this:null},DefaultKeyValueDiffer.prototype.onDestroy=function(){},DefaultKeyValueDiffer.prototype.check=function(map){var _this=this;this._reset();var insertBefore=this._mapHead;if(this._appendAfter=null,this._forEach(map,function(value,key){if(insertBefore&&insertBefore.key===key)_this._maybeAddToChanges(insertBefore,value),_this._appendAfter=insertBefore,insertBefore=insertBefore._next;else{var record=_this._getOrCreateRecordForKey(key,value);insertBefore=_this._insertBeforeOrAppend(insertBefore,record)}}),insertBefore){insertBefore._prev&&(insertBefore._prev._next=null),this._removalsHead=insertBefore;for(var record=insertBefore;null!==record;record=record._nextRemoved)record===this._mapHead&&(this._mapHead=null),this._records.delete(record.key),record._nextRemoved=record._next,record.previousValue=record.currentValue,record.currentValue=null,record._prev=null,record._next=null}return this._changesTail&&(this._changesTail._nextChanged=null),this._additionsTail&&(this._additionsTail._nextAdded=null),this.isDirty},DefaultKeyValueDiffer.prototype._insertBeforeOrAppend=function(before,record){if(before){var prev=before._prev;return record._next=before,record._prev=prev,before._prev=record,prev&&(prev._next=record),before===this._mapHead&&(this._mapHead=record),this._appendAfter=before,before}return this._appendAfter?(this._appendAfter._next=record,record._prev=this._appendAfter):this._mapHead=record,this._appendAfter=record,null},DefaultKeyValueDiffer.prototype._getOrCreateRecordForKey=function(key,value){if(this._records.has(key)){var record_1=this._records.get(key);this._maybeAddToChanges(record_1,value);var prev=record_1._prev,next=record_1._next;return prev&&(prev._next=next),next&&(next._prev=prev),record_1._next=null,record_1._prev=null,record_1}var record=new KeyValueChangeRecord_(key);return this._records.set(key,record),record.currentValue=value,this._addToAdditions(record),record},DefaultKeyValueDiffer.prototype._reset=function(){if(this.isDirty){var record=void 0;for(this._previousMapHead=this._mapHead,record=this._previousMapHead;null!==record;record=record._next)record._nextPrevious=record._next;for(record=this._changesHead;null!==record;record=record._nextChanged)record.previousValue=record.currentValue;for(record=this._additionsHead;null!=record;record=record._nextAdded)record.previousValue=record.currentValue;this._changesHead=this._changesTail=null,this._additionsHead=this._additionsTail=null,this._removalsHead=null}},DefaultKeyValueDiffer.prototype._maybeAddToChanges=function(record,newValue){looseIdentical(newValue,record.currentValue)||(record.previousValue=record.currentValue,record.currentValue=newValue,this._addToChanges(record))},DefaultKeyValueDiffer.prototype._addToAdditions=function(record){null===this._additionsHead?this._additionsHead=this._additionsTail=record:(this._additionsTail._nextAdded=record,this._additionsTail=record)},DefaultKeyValueDiffer.prototype._addToChanges=function(record){null===this._changesHead?this._changesHead=this._changesTail=record:(this._changesTail._nextChanged=record,this._changesTail=record)},DefaultKeyValueDiffer.prototype._forEach=function(obj,fn){obj instanceof Map?obj.forEach(fn):Object.keys(obj).forEach(function(k){return fn(obj[k],k)})},DefaultKeyValueDiffer}(),KeyValueChangeRecord_=function(){function KeyValueChangeRecord_(key){this.key=key,this.previousValue=null,this.currentValue=null,this._nextPrevious=null,this._next=null,this._prev=null,this._nextAdded=null,this._nextRemoved=null,this._nextChanged=null}return KeyValueChangeRecord_}(),IterableDiffers=function(){function IterableDiffers(factories){this.factories=factories}return IterableDiffers.create=function(factories,parent){if(null!=parent){var copied=parent.factories.slice();return factories=factories.concat(copied),new IterableDiffers(factories)}return new IterableDiffers(factories)},IterableDiffers.extend=function(factories){return{provide:IterableDiffers,useFactory:function(parent){if(!parent)throw new Error("Cannot extend IterableDiffers without a parent injector");return IterableDiffers.create(factories,parent)},deps:[[IterableDiffers,new SkipSelf,new Optional]]}},IterableDiffers.prototype.find=function(iterable){var factory=this.factories.find(function(f){return f.supports(iterable)});if(null!=factory)return factory;throw new Error("Cannot find a differ supporting object '"+iterable+"' of type '"+getTypeNameForDebugging(iterable)+"'")},IterableDiffers}(),KeyValueDiffers=function(){function KeyValueDiffers(factories){this.factories=factories}return KeyValueDiffers.create=function(factories,parent){if(parent){var copied=parent.factories.slice();factories=factories.concat(copied)}return new KeyValueDiffers(factories)},KeyValueDiffers.extend=function(factories){return{provide:KeyValueDiffers,useFactory:function(parent){if(!parent)throw new Error("Cannot extend KeyValueDiffers without a parent injector");return KeyValueDiffers.create(factories,parent)},deps:[[KeyValueDiffers,new SkipSelf,new Optional]]}},KeyValueDiffers.prototype.find=function(kv){var factory=this.factories.find(function(f){return f.supports(kv)});if(factory)return factory;throw new Error("Cannot find a differ supporting object '"+kv+"'")},KeyValueDiffers}(),keyValDiff=[new DefaultKeyValueDifferFactory],iterableDiff=[new DefaultIterableDifferFactory],defaultIterableDiffers=new IterableDiffers(iterableDiff),defaultKeyValueDiffers=new KeyValueDiffers(keyValDiff),_CORE_PLATFORM_PROVIDERS=[{provide:PLATFORM_ID,useValue:"unknown"},{provide:PlatformRef,deps:[Injector]},{provide:TestabilityRegistry,deps:[]},{provide:Console,deps:[]}],LOCALE_ID=(function(parentPlatformFactory,name,providers){void 0===providers&&(providers=[]);var desc="Platform: "+name,marker=new InjectionToken(desc)}(null,"core",_CORE_PLATFORM_PROVIDERS),new InjectionToken("LocaleId")),SecurityContext$1=(new InjectionToken("Translations"),new InjectionToken("TranslationsFormat"),function(){function ApplicationModule(appRef){}ApplicationModule.decorators=[{type:NgModule$1,args:[{providers:[ApplicationRef,ApplicationInitStatus,Compiler,APP_ID_RANDOM_PROVIDER,{provide:IterableDiffers,useFactory:_iterableDiffersFactory},{provide:KeyValueDiffers,useFactory:_keyValueDiffersFactory},{provide:LOCALE_ID,useFactory:_localeFactory,deps:[[new Inject$1(LOCALE_ID),new Optional,new SkipSelf]]}]}]}],ApplicationModule.ctorParameters=function(){return[{type:ApplicationRef}]}}(),{NONE:0,HTML:1,STYLE:2,SCRIPT:3,URL:4,RESOURCE_URL:5});SecurityContext$1[SecurityContext$1.NONE]="NONE",SecurityContext$1[SecurityContext$1.HTML]="HTML",SecurityContext$1[SecurityContext$1.STYLE]="STYLE",SecurityContext$1[SecurityContext$1.SCRIPT]="SCRIPT",SecurityContext$1[SecurityContext$1.URL]="URL",SecurityContext$1[SecurityContext$1.RESOURCE_URL]="RESOURCE_URL";var Sanitizer=function(){function Sanitizer(){}return Sanitizer}(),Services={setCurrentNode:void 0,createRootView:void 0,createEmbeddedView:void 0,createComponentView:void 0,createNgModuleRef:void 0,overrideProvider:void 0,overrideComponentView:void 0,clearOverrides:void 0,checkAndUpdateView:void 0,checkNoChangesView:void 0,destroyView:void 0,resolveDep:void 0,createDebugContext:void 0,handleEvent:void 0,updateDirectives:void 0,updateRenderer:void 0,dirtyParentQueries:void 0},NOOP=function(){},_tokenKeyCache=new Map,DEFINITION_CACHE=new WeakMap,NS_PREFIX_RE=/^:([^:]+):(.+)$/,UNDEFINED_VALUE=new Object,InjectorRefTokenKey$1=tokenKey(Injector),NgModuleRefTokenKey=tokenKey(NgModuleRef),EMPTY_CONTEXT=new Object,ComponentRef_=(function(_super){function ComponentFactory_(selector,componentType,viewDefFactory,_inputs,_outputs,ngContentSelectors){var _this=_super.call(this)||this;return _this.selector=selector,_this.componentType=componentType,_this._inputs=_inputs,_this._outputs=_outputs,_this.ngContentSelectors=ngContentSelectors,_this.viewDefFactory=viewDefFactory,_this}__extends(ComponentFactory_,_super),Object.defineProperty(ComponentFactory_.prototype,"inputs",{get:function(){var inputsArr=[],inputs=this._inputs;for(var propName in inputs){var templateName=inputs[propName];inputsArr.push({propName:propName,templateName:templateName})}return inputsArr},enumerable:!0,configurable:!0}),Object.defineProperty(ComponentFactory_.prototype,"outputs",{get:function(){var outputsArr=[];for(var propName in this._outputs){var templateName=this._outputs[propName];outputsArr.push({propName:propName,templateName:templateName})}return outputsArr},enumerable:!0,configurable:!0}),ComponentFactory_.prototype.create=function(injector,projectableNodes,rootSelectorOrNode,ngModule){if(!ngModule)throw new Error("ngModule should be provided");var viewDef=resolveDefinition(this.viewDefFactory),componentNodeIndex=viewDef.nodes[0].element.componentProvider.nodeIndex,view=Services.createRootView(injector,projectableNodes||[],rootSelectorOrNode,viewDef,ngModule,EMPTY_CONTEXT),component=asProviderData(view,componentNodeIndex).instance
;return rootSelectorOrNode&&view.renderer.setAttribute(asElementData(view,0).renderElement,"ng-version",VERSION$2.full),new ComponentRef_(view,new ViewRef_(view),component)}}(ComponentFactory),function(_super){function ComponentRef_(_view,_viewRef,_component){var _this=_super.call(this)||this;return _this._view=_view,_this._viewRef=_viewRef,_this._component=_component,_this._elDef=_this._view.def.nodes[0],_this.hostView=_viewRef,_this.changeDetectorRef=_viewRef,_this.instance=_component,_this}return __extends(ComponentRef_,_super),Object.defineProperty(ComponentRef_.prototype,"location",{get:function(){return new ElementRef(asElementData(this._view,this._elDef.nodeIndex).renderElement)},enumerable:!0,configurable:!0}),Object.defineProperty(ComponentRef_.prototype,"injector",{get:function(){return new Injector_(this._view,this._elDef)},enumerable:!0,configurable:!0}),Object.defineProperty(ComponentRef_.prototype,"componentType",{get:function(){return this._component.constructor},enumerable:!0,configurable:!0}),ComponentRef_.prototype.destroy=function(){this._viewRef.destroy()},ComponentRef_.prototype.onDestroy=function(callback){this._viewRef.onDestroy(callback)},ComponentRef_}(ComponentRef)),ViewContainerRef_=function(){function ViewContainerRef_(_view,_elDef,_data){this._view=_view,this._elDef=_elDef,this._data=_data,this._embeddedViews=[]}return Object.defineProperty(ViewContainerRef_.prototype,"element",{get:function(){return new ElementRef(this._data.renderElement)},enumerable:!0,configurable:!0}),Object.defineProperty(ViewContainerRef_.prototype,"injector",{get:function(){return new Injector_(this._view,this._elDef)},enumerable:!0,configurable:!0}),Object.defineProperty(ViewContainerRef_.prototype,"parentInjector",{get:function(){for(var view=this._view,elDef=this._elDef.parent;!elDef&&view;)elDef=viewParentEl(view),view=view.parent;return view?new Injector_(view,elDef):new Injector_(this._view,null)},enumerable:!0,configurable:!0}),ViewContainerRef_.prototype.clear=function(){for(var len=this._embeddedViews.length,i=len-1;i>=0;i--){var view=detachEmbeddedView(this._data,i);Services.destroyView(view)}},ViewContainerRef_.prototype.get=function(index){var view=this._embeddedViews[index];if(view){var ref=new ViewRef_(view);return ref.attachToViewContainerRef(this),ref}return null},Object.defineProperty(ViewContainerRef_.prototype,"length",{get:function(){return this._embeddedViews.length},enumerable:!0,configurable:!0}),ViewContainerRef_.prototype.createEmbeddedView=function(templateRef,context,index){var viewRef=templateRef.createEmbeddedView(context||{});return this.insert(viewRef,index),viewRef},ViewContainerRef_.prototype.createComponent=function(componentFactory,index,injector,projectableNodes,ngModuleRef){var contextInjector=injector||this.parentInjector;ngModuleRef||componentFactory instanceof ComponentFactoryBoundToModule||(ngModuleRef=contextInjector.get(NgModuleRef));var componentRef=componentFactory.create(contextInjector,projectableNodes,void 0,ngModuleRef);return this.insert(componentRef.hostView,index),componentRef},ViewContainerRef_.prototype.insert=function(viewRef,index){if(viewRef.destroyed)throw new Error("Cannot insert a destroyed View in a ViewContainer!");var viewRef_=viewRef,viewData=viewRef_._view;return attachEmbeddedView(this._view,this._data,index,viewData),viewRef_.attachToViewContainerRef(this),viewRef},ViewContainerRef_.prototype.move=function(viewRef,currentIndex){if(viewRef.destroyed)throw new Error("Cannot move a destroyed View in a ViewContainer!");var previousIndex=this._embeddedViews.indexOf(viewRef._view);return moveEmbeddedView(this._data,previousIndex,currentIndex),viewRef},ViewContainerRef_.prototype.indexOf=function(viewRef){return this._embeddedViews.indexOf(viewRef._view)},ViewContainerRef_.prototype.remove=function(index){var viewData=detachEmbeddedView(this._data,index);viewData&&Services.destroyView(viewData)},ViewContainerRef_.prototype.detach=function(index){var view=detachEmbeddedView(this._data,index);return view?new ViewRef_(view):null},ViewContainerRef_}(),ViewRef_=function(){function ViewRef_(_view){this._view=_view,this._viewContainerRef=null,this._appRef=null}return Object.defineProperty(ViewRef_.prototype,"rootNodes",{get:function(){return rootRenderNodes(this._view)},enumerable:!0,configurable:!0}),Object.defineProperty(ViewRef_.prototype,"context",{get:function(){return this._view.context},enumerable:!0,configurable:!0}),Object.defineProperty(ViewRef_.prototype,"destroyed",{get:function(){return 0!=(128&this._view.state)},enumerable:!0,configurable:!0}),ViewRef_.prototype.markForCheck=function(){markParentViewsForCheck(this._view)},ViewRef_.prototype.detach=function(){this._view.state&=-5},ViewRef_.prototype.detectChanges=function(){var fs$$1=this._view.root.rendererFactory;fs$$1.begin&&fs$$1.begin();try{Services.checkAndUpdateView(this._view)}finally{fs$$1.end&&fs$$1.end()}},ViewRef_.prototype.checkNoChanges=function(){Services.checkNoChangesView(this._view)},ViewRef_.prototype.reattach=function(){this._view.state|=4},ViewRef_.prototype.onDestroy=function(callback){this._view.disposables||(this._view.disposables=[]),this._view.disposables.push(callback)},ViewRef_.prototype.destroy=function(){this._appRef?this._appRef.detachView(this):this._viewContainerRef&&this._viewContainerRef.detach(this._viewContainerRef.indexOf(this)),Services.destroyView(this._view)},ViewRef_.prototype.detachFromAppRef=function(){this._appRef=null,renderDetachView(this._view),Services.dirtyParentQueries(this._view)},ViewRef_.prototype.attachToAppRef=function(appRef){if(this._viewContainerRef)throw new Error("This view is already attached to a ViewContainer!");this._appRef=appRef},ViewRef_.prototype.attachToViewContainerRef=function(vcRef){if(this._appRef)throw new Error("This view is already attached directly to the ApplicationRef!");this._viewContainerRef=vcRef},ViewRef_}(),TemplateRef_=function(_super){function TemplateRef_(_parentView,_def){var _this=_super.call(this)||this;return _this._parentView=_parentView,_this._def=_def,_this}return __extends(TemplateRef_,_super),TemplateRef_.prototype.createEmbeddedView=function(context){return new ViewRef_(Services.createEmbeddedView(this._parentView,this._def,this._def.element.template,context))},Object.defineProperty(TemplateRef_.prototype,"elementRef",{get:function(){return new ElementRef(asElementData(this._parentView,this._def.nodeIndex).renderElement)},enumerable:!0,configurable:!0}),TemplateRef_}(TemplateRef),Injector_=function(){function Injector_(view,elDef){this.view=view,this.elDef=elDef}return Injector_.prototype.get=function(token,notFoundValue){void 0===notFoundValue&&(notFoundValue=Injector.THROW_IF_NOT_FOUND);var allowPrivateServices=!!this.elDef&&0!=(33554432&this.elDef.flags);return Services.resolveDep(this.view,this.elDef,allowPrivateServices,{flags:0,token:token,tokenKey:tokenKey(token)},notFoundValue)},Injector_}(),RendererAdapter=function(){function RendererAdapter(delegate){this.delegate=delegate}return RendererAdapter.prototype.selectRootElement=function(selectorOrNode){return this.delegate.selectRootElement(selectorOrNode)},RendererAdapter.prototype.createElement=function(parent,namespaceAndName){var _a=splitNamespace(namespaceAndName),ns=_a[0],name=_a[1],el=this.delegate.createElement(name,ns);return parent&&this.delegate.appendChild(parent,el),el},RendererAdapter.prototype.createViewRoot=function(hostElement){return hostElement},RendererAdapter.prototype.createTemplateAnchor=function(parentElement){var comment=this.delegate.createComment("");return parentElement&&this.delegate.appendChild(parentElement,comment),comment},RendererAdapter.prototype.createText=function(parentElement,value){var node=this.delegate.createText(value);return parentElement&&this.delegate.appendChild(parentElement,node),node},RendererAdapter.prototype.projectNodes=function(parentElement,nodes){for(var i=0;i<nodes.length;i++)this.delegate.appendChild(parentElement,nodes[i])},RendererAdapter.prototype.attachViewAfter=function(node,viewRootNodes){for(var parentElement=this.delegate.parentNode(node),nextSibling=this.delegate.nextSibling(node),i=0;i<viewRootNodes.length;i++)this.delegate.insertBefore(parentElement,viewRootNodes[i],nextSibling)},RendererAdapter.prototype.detachView=function(viewRootNodes){for(var i=0;i<viewRootNodes.length;i++){var node=viewRootNodes[i],parentElement=this.delegate.parentNode(node);this.delegate.removeChild(parentElement,node)}},RendererAdapter.prototype.destroyView=function(hostElement,viewAllNodes){for(var i=0;i<viewAllNodes.length;i++)this.delegate.destroyNode(viewAllNodes[i])},RendererAdapter.prototype.listen=function(renderElement,name,callback){return this.delegate.listen(renderElement,name,callback)},RendererAdapter.prototype.listenGlobal=function(target,name,callback){return this.delegate.listen(target,name,callback)},RendererAdapter.prototype.setElementProperty=function(renderElement,propertyName,propertyValue){this.delegate.setProperty(renderElement,propertyName,propertyValue)},RendererAdapter.prototype.setElementAttribute=function(renderElement,namespaceAndName,attributeValue){var _a=splitNamespace(namespaceAndName),ns=_a[0],name=_a[1];null!=attributeValue?this.delegate.setAttribute(renderElement,name,attributeValue,ns):this.delegate.removeAttribute(renderElement,name,ns)},RendererAdapter.prototype.setBindingDebugInfo=function(renderElement,propertyName,propertyValue){},RendererAdapter.prototype.setElementClass=function(renderElement,className,isAdd){isAdd?this.delegate.addClass(renderElement,className):this.delegate.removeClass(renderElement,className)},RendererAdapter.prototype.setElementStyle=function(renderElement,styleName,styleValue){null!=styleValue?this.delegate.setStyle(renderElement,styleName,styleValue):this.delegate.removeStyle(renderElement,styleName)},RendererAdapter.prototype.invokeElementMethod=function(renderElement,methodName,args){renderElement[methodName].apply(renderElement,args)},RendererAdapter.prototype.setText=function(renderNode$$1,text){this.delegate.setValue(renderNode$$1,text)},RendererAdapter.prototype.animate=function(){throw new Error("Renderer.animate is no longer supported!")},RendererAdapter}(),NgModuleRef_=function(){function NgModuleRef_(_moduleType,_parent,_bootstrapComponents,_def){this._moduleType=_moduleType,this._parent=_parent,this._bootstrapComponents=_bootstrapComponents,this._def=_def,this._destroyListeners=[],this._destroyed=!1,this.injector=this,initNgModule(this)}return NgModuleRef_.prototype.get=function(token,notFoundValue){return void 0===notFoundValue&&(notFoundValue=Injector.THROW_IF_NOT_FOUND),resolveNgModuleDep(this,{token:token,tokenKey:tokenKey(token),flags:0},notFoundValue)},Object.defineProperty(NgModuleRef_.prototype,"instance",{get:function(){return this.get(this._moduleType)},enumerable:!0,configurable:!0}),Object.defineProperty(NgModuleRef_.prototype,"componentFactoryResolver",{get:function(){return this.get(ComponentFactoryResolver)},enumerable:!0,configurable:!0}),NgModuleRef_.prototype.destroy=function(){if(this._destroyed)throw new Error("The ng module "+stringify$1(this.instance.constructor)+" has already been destroyed.");this._destroyed=!0,callNgModuleLifecycle(this,131072),this._destroyListeners.forEach(function(listener){return listener()})},NgModuleRef_.prototype.onDestroy=function(callback){this._destroyListeners.push(callback)},NgModuleRef_}(),RendererV1TokenKey=tokenKey(Renderer),Renderer2TokenKey=tokenKey(Renderer2),ElementRefTokenKey=tokenKey(ElementRef),ViewContainerRefTokenKey=tokenKey(ViewContainerRef),TemplateRefTokenKey=tokenKey(TemplateRef),ChangeDetectorRefTokenKey=tokenKey(ChangeDetectorRef),InjectorRefTokenKey=tokenKey(Injector),NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR={},ViewAction={CreateViewNodes:0,CheckNoChanges:1,CheckNoChangesProjectedViews:2,CheckAndUpdate:3,CheckAndUpdateProjectedViews:4,Destroy:5};ViewAction[ViewAction.CreateViewNodes]="CreateViewNodes",ViewAction[ViewAction.CheckNoChanges]="CheckNoChanges",ViewAction[ViewAction.CheckNoChangesProjectedViews]="CheckNoChangesProjectedViews",ViewAction[ViewAction.CheckAndUpdate]="CheckAndUpdate",ViewAction[ViewAction.CheckAndUpdateProjectedViews]="CheckAndUpdateProjectedViews",ViewAction[ViewAction.Destroy]="Destroy";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var initialized=!1,providerOverrides=new Map,viewDefOverrides=new Map,DebugAction={create:0,detectChanges:1,checkNoChanges:2,destroy:3,handleEvent:4};DebugAction[DebugAction.create]="create",DebugAction[DebugAction.detectChanges]="detectChanges",DebugAction[DebugAction.checkNoChanges]="checkNoChanges",DebugAction[DebugAction.destroy]="destroy",DebugAction[DebugAction.handleEvent]="handleEvent";var _currentAction,_currentView,_currentNodeIndex,CAMEL_CASE_REGEXP=/([A-Z])/g,DebugContext_=function(){function DebugContext_(view,nodeIndex){this.view=view,this.nodeIndex=nodeIndex,null==nodeIndex&&(this.nodeIndex=nodeIndex=0),this.nodeDef=view.def.nodes[nodeIndex];for(var elDef=this.nodeDef,elView=view;elDef&&0==(1&elDef.flags);)elDef=elDef.parent;if(!elDef)for(;!elDef&&elView;)elDef=viewParentEl(elView),elView=elView.parent;this.elDef=elDef,this.elView=elView}return Object.defineProperty(DebugContext_.prototype,"elOrCompView",{get:function(){return asElementData(this.elView,this.elDef.nodeIndex).componentView||this.view},enumerable:!0,configurable:!0}),Object.defineProperty(DebugContext_.prototype,"injector",{get:function(){return createInjector(this.elView,this.elDef)},enumerable:!0,configurable:!0}),Object.defineProperty(DebugContext_.prototype,"component",{get:function(){return this.elOrCompView.component},enumerable:!0,configurable:!0}),Object.defineProperty(DebugContext_.prototype,"context",{get:function(){return this.elOrCompView.context},enumerable:!0,configurable:!0}),Object.defineProperty(DebugContext_.prototype,"providerTokens",{get:function(){var tokens=[];if(this.elDef)for(var i=this.elDef.nodeIndex+1;i<=this.elDef.nodeIndex+this.elDef.childCount;i++){var childDef=this.elView.def.nodes[i];20224&childDef.flags&&tokens.push(childDef.provider.token),i+=childDef.childCount}return tokens},enumerable:!0,configurable:!0}),Object.defineProperty(DebugContext_.prototype,"references",{get:function(){var references={};if(this.elDef){collectReferences(this.elView,this.elDef,references);for(var i=this.elDef.nodeIndex+1;i<=this.elDef.nodeIndex+this.elDef.childCount;i++){var childDef=this.elView.def.nodes[i];20224&childDef.flags&&collectReferences(this.elView,childDef,references),i+=childDef.childCount}}return references},enumerable:!0,configurable:!0}),Object.defineProperty(DebugContext_.prototype,"componentRenderElement",{get:function(){var elData=findHostElement(this.elOrCompView);return elData?elData.renderElement:void 0},enumerable:!0,configurable:!0}),Object.defineProperty(DebugContext_.prototype,"renderNode",{get:function(){return 2&this.nodeDef.flags?renderNode(this.view,this.nodeDef):renderNode(this.elView,this.elDef)},enumerable:!0,configurable:!0}),DebugContext_.prototype.logError=function(console){for(var values=[],_i=1;_i<arguments.length;_i++)values[_i-1]=arguments[_i];var logViewDef,logNodeIndex;2&this.nodeDef.flags?(logViewDef=this.view.def,logNodeIndex=this.nodeDef.nodeIndex):(logViewDef=this.elView.def,logNodeIndex=this.elDef.nodeIndex);var renderNodeIndex=getRenderNodeIndex(logViewDef,logNodeIndex),currRenderNodeIndex=-1,nodeLogger=function(){return currRenderNodeIndex++,currRenderNodeIndex===renderNodeIndex?(_a=console.error).bind.apply(_a,[console].concat(values)):NOOP;var _a};logViewDef.factory(nodeLogger),currRenderNodeIndex<renderNodeIndex&&(console.error("Illegal state: the ViewDefinitionFactory did not call the logger!"),console.error.apply(console,values))},DebugContext_}(),DebugRendererFactory2=function(){function DebugRendererFactory2(delegate){this.delegate=delegate}return DebugRendererFactory2.prototype.createRenderer=function(element,renderData){return new DebugRenderer2(this.delegate.createRenderer(element,renderData))},DebugRendererFactory2.prototype.begin=function(){this.delegate.begin&&this.delegate.begin()},DebugRendererFactory2.prototype.end=function(){this.delegate.end&&this.delegate.end()},DebugRendererFactory2.prototype.whenRenderingDone=function(){return this.delegate.whenRenderingDone?this.delegate.whenRenderingDone():Promise.resolve(null)},DebugRendererFactory2}(),DebugRenderer2=function(){function DebugRenderer2(delegate){this.delegate=delegate,this.data=this.delegate.data}return DebugRenderer2.prototype.destroyNode=function(node){removeDebugNodeFromIndex(getDebugNode(node)),this.delegate.destroyNode&&this.delegate.destroyNode(node)},DebugRenderer2.prototype.destroy=function(){this.delegate.destroy()},DebugRenderer2.prototype.createElement=function(name,namespace){var el=this.delegate.createElement(name,namespace),debugCtx=getCurrentDebugContext();if(debugCtx){var debugEl=new DebugElement(el,null,debugCtx);debugEl.name=name,indexDebugNode(debugEl)}return el},DebugRenderer2.prototype.createComment=function(value){var comment=this.delegate.createComment(value),debugCtx=getCurrentDebugContext();return debugCtx&&indexDebugNode(new DebugNode(comment,null,debugCtx)),comment},DebugRenderer2.prototype.createText=function(value){var text=this.delegate.createText(value),debugCtx=getCurrentDebugContext();return debugCtx&&indexDebugNode(new DebugNode(text,null,debugCtx)),text},DebugRenderer2.prototype.appendChild=function(parent,newChild){var debugEl=getDebugNode(parent),debugChildEl=getDebugNode(newChild);debugEl&&debugChildEl&&debugEl instanceof DebugElement&&debugEl.addChild(debugChildEl),this.delegate.appendChild(parent,newChild)},DebugRenderer2.prototype.insertBefore=function(parent,newChild,refChild){var debugEl=getDebugNode(parent),debugChildEl=getDebugNode(newChild),debugRefEl=getDebugNode(refChild);debugEl&&debugChildEl&&debugEl instanceof DebugElement&&debugEl.insertBefore(debugRefEl,debugChildEl),this.delegate.insertBefore(parent,newChild,refChild)},DebugRenderer2.prototype.removeChild=function(parent,oldChild){var debugEl=getDebugNode(parent),debugChildEl=getDebugNode(oldChild);debugEl&&debugChildEl&&debugEl instanceof DebugElement&&debugEl.removeChild(debugChildEl),this.delegate.removeChild(parent,oldChild)},DebugRenderer2.prototype.selectRootElement=function(selectorOrNode){var el=this.delegate.selectRootElement(selectorOrNode),debugCtx=getCurrentDebugContext();return debugCtx&&indexDebugNode(new DebugElement(el,null,debugCtx)),el},DebugRenderer2.prototype.setAttribute=function(el,name,value,namespace){var debugEl=getDebugNode(el);if(debugEl&&debugEl instanceof DebugElement){var fullName=namespace?namespace+":"+name:name;debugEl.attributes[fullName]=value}this.delegate.setAttribute(el,name,value,namespace)},DebugRenderer2.prototype.removeAttribute=function(el,name,namespace){var debugEl=getDebugNode(el);if(debugEl&&debugEl instanceof DebugElement){var fullName=namespace?namespace+":"+name:name;debugEl.attributes[fullName]=null}this.delegate.removeAttribute(el,name,namespace)},DebugRenderer2.prototype.addClass=function(el,name){var debugEl=getDebugNode(el);debugEl&&debugEl instanceof DebugElement&&(debugEl.classes[name]=!0),this.delegate.addClass(el,name)},DebugRenderer2.prototype.removeClass=function(el,name){var debugEl=getDebugNode(el);debugEl&&debugEl instanceof DebugElement&&(debugEl.classes[name]=!1),this.delegate.removeClass(el,name)},DebugRenderer2.prototype.setStyle=function(el,style,value,flags){var debugEl=getDebugNode(el);debugEl&&debugEl instanceof DebugElement&&(debugEl.styles[style]=value),this.delegate.setStyle(el,style,value,flags)},DebugRenderer2.prototype.removeStyle=function(el,style,flags){var debugEl=getDebugNode(el);debugEl&&debugEl instanceof DebugElement&&(debugEl.styles[style]=null),this.delegate.removeStyle(el,style,flags)},DebugRenderer2.prototype.setProperty=function(el,name,value){var debugEl=getDebugNode(el);debugEl&&debugEl instanceof DebugElement&&(debugEl.properties[name]=value),this.delegate.setProperty(el,name,value)},DebugRenderer2.prototype.listen=function(target,eventName,callback){if("string"!=typeof target){var debugEl=getDebugNode(target);debugEl&&debugEl.listeners.push(new EventListener(eventName,callback))}return this.delegate.listen(target,eventName,callback)},DebugRenderer2.prototype.parentNode=function(node){return this.delegate.parentNode(node)},DebugRenderer2.prototype.nextSibling=function(node){return this.delegate.nextSibling(node)},DebugRenderer2.prototype.setValue=function(node,value){return this.delegate.setValue(node,value)},DebugRenderer2}();!function(_super){function NgModuleFactory_(moduleType,_bootstrapComponents,_ngModuleDefFactory){var _this=_super.call(this)||this;return _this.moduleType=moduleType,_this._bootstrapComponents=_bootstrapComponents,_this._ngModuleDefFactory=_ngModuleDefFactory,_this}__extends(NgModuleFactory_,_super),NgModuleFactory_.prototype.create=function(parentInjector){initServicesIfNeeded();var def=resolveDefinition(this._ngModuleDefFactory);return Services.createNgModuleRef(this.moduleType,parentInjector||Injector.NULL,this._bootstrapComponents,def)}}(NgModuleFactory);/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
"undefined"==typeof ngDevMode&&("undefined"!=typeof window&&(window.ngDevMode=!0),"undefined"!=typeof self&&(self.ngDevMode=!0),"undefined"!=typeof global&&(global.ngDevMode=!0));/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var currentView;!function(){function QueryList_(){this.dirty=!1,this._valuesTree=null,this._values=null}Object.defineProperty(QueryList_.prototype,"length",{get:function(){return ngDevMode&&assertNotNull$1(this._values,"refreshed"),this._values.length},enumerable:!0,configurable:!0}),Object.defineProperty(QueryList_.prototype,"first",{get:function(){ngDevMode&&assertNotNull$1(this._values,"refreshed");var values=this._values;return values.length?values[0]:null},enumerable:!0,configurable:!0}),Object.defineProperty(QueryList_.prototype,"last",{get:function(){ngDevMode&&assertNotNull$1(this._values,"refreshed");var values=this._values;return values.length?values[values.length-1]:null},enumerable:!0,configurable:!0}),QueryList_.prototype._refresh=function(){return null===this._values&&(this._values=this._valuesTree,!0)},QueryList_.prototype.map=function(fn){throw new Error("Method not implemented.")},QueryList_.prototype.filter=function(fn){throw new Error("Method not implemented.")},QueryList_.prototype.find=function(fn){throw new Error("Method not implemented.")},QueryList_.prototype.reduce=function(fn,init){throw new Error("Method not implemented.")},QueryList_.prototype.forEach=function(fn){throw new Error("Method not implemented.")},QueryList_.prototype.some=function(fn){throw new Error("Method not implemented.")},QueryList_.prototype.toArray=function(){return ngDevMode&&assertNotNull$1(this._values,"refreshed"),this._values},QueryList_.prototype.toString=function(){throw new Error("Method not implemented.")},QueryList_.prototype.reset=function(res){throw new Error("Method not implemented.")},QueryList_.prototype.notifyOnChanges=function(){throw new Error("Method not implemented.")},QueryList_.prototype.setDirty=function(){throw new Error("Method not implemented.")},QueryList_.prototype.destroy=function(){throw new Error("Method not implemented.")}}();currentView=function(viewId,renderer,ngStaticData){return{parent:currentView,id:viewId,node:null,data:[],ngStaticData:ngStaticData,cleanup:null,renderer:renderer,child:null,tail:null,next:null,bindingStartIndex:null,creationMode:!0,viewHookStartIndex:null}}(null,null,[]);var DiagnosticKind;!function(DiagnosticKind){DiagnosticKind[DiagnosticKind.Error=0]="Error",DiagnosticKind[DiagnosticKind.Warning=1]="Warning"}(DiagnosticKind||(DiagnosticKind={}));/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var values=["ID","CDATA","NAME",["ltr","rtl"],["rect","circle","poly","default"],"NUMBER",["nohref"],["ismap"],["declare"],["DATA","REF","OBJECT"],["GET","POST"],"IDREF",["TEXT","PASSWORD","CHECKBOX","RADIO","SUBMIT","RESET","FILE","HIDDEN","IMAGE","BUTTON"],["checked"],["disabled"],["readonly"],["multiple"],["selected"],["button","submit","reset"],["void","above","below","hsides","lhs","rhs","vsides","box","border"],["none","groups","rows","cols","all"],["left","center","right","justify","char"],["top","middle","bottom","baseline"],"IDREFS",["row","col","rowgroup","colgroup"],["defer"]],groups=[{id:0},{onclick:1,ondblclick:1,onmousedown:1,onmouseup:1,onmouseover:1,onmousemove:1,onmouseout:1,onkeypress:1,onkeydown:1,onkeyup:1},{lang:2,dir:3},{onload:1,onunload:1},{name:1},{href:1},{type:1},{alt:1},{tabindex:5},{media:1},{nohref:6},{usemap:1},{src:1},{onfocus:1,onblur:1},{charset:1},{declare:8,classid:1,codebase:1,data:1,codetype:1,archive:1,standby:1},{title:1},{value:1},{cite:1},{datetime:1},{accept:1},{shape:4,coords:1},{for:11},{action:1,method:10,enctype:1,onsubmit:1,onreset:1,"accept-charset":1},{valuetype:9},{longdesc:1},{width:1},{disabled:14},{readonly:15,onselect:1},{accesskey:1},{size:5,multiple:16},{onchange:1},{label:1},{selected:17},{type:12,checked:13,size:1,maxlength:5},{rows:5,cols:5},{type:18},{height:1},{summary:1,border:1,frame:19,rules:20,cellspacing:1,cellpadding:1,datapagesize:1},{align:21,char:1,charoff:1,valign:22},{span:5},{abbr:1,axis:1,headers:23,scope:24,rowspan:5,colspan:5},{profile:1},{"http-equiv":2,name:2,content:1,scheme:1},{class:1,style:1},{hreflang:2,rel:1,rev:1},{ismap:7},{defer:25,event:1,for:1}],elements={TT:[0,1,2,16,44],I:[0,1,2,16,44],B:[0,1,2,16,44],BIG:[0,1,2,16,44],SMALL:[0,1,2,16,44],EM:[0,1,2,16,44],STRONG:[0,1,2,16,44],DFN:[0,1,2,16,44],CODE:[0,1,2,16,44],SAMP:[0,1,2,16,44],KBD:[0,1,2,16,44],VAR:[0,1,2,16,44],CITE:[0,1,2,16,44],ABBR:[0,1,2,16,44],ACRONYM:[0,1,2,16,44],SUB:[0,1,2,16,44],SUP:[0,1,2,16,44],SPAN:[0,1,2,16,44],BDO:[0,2,16,44],BR:[0,16,44],BODY:[0,1,2,3,16,44],ADDRESS:[0,1,2,16,44],DIV:[0,1,2,16,44],A:[0,1,2,4,5,6,8,13,14,16,21,29,44,45],MAP:[0,1,2,4,16,44],AREA:[0,1,2,5,7,8,10,13,16,21,29,44],LINK:[0,1,2,5,6,9,14,16,44,45],IMG:[0,1,2,4,7,11,12,16,25,26,37,44,46],OBJECT:[0,1,2,4,6,8,11,15,16,26,37,44],PARAM:[0,4,6,17,24],HR:[0,1,2,16,44],P:[0,1,2,16,44],H1:[0,1,2,16,44],H2:[0,1,2,16,44],H3:[0,1,2,16,44],H4:[0,1,2,16,44],H5:[0,1,2,16,44],H6:[0,1,2,16,44],PRE:[0,1,2,16,44],Q:[0,1,2,16,18,44],BLOCKQUOTE:[0,1,2,16,18,44],INS:[0,1,2,16,18,19,44],DEL:[0,1,2,16,18,19,44],DL:[0,1,2,16,44],DT:[0,1,2,16,44],DD:[0,1,2,16,44],OL:[0,1,2,16,44],UL:[0,1,2,16,44],LI:[0,1,2,16,44],FORM:[0,1,2,4,16,20,23,44],LABEL:[0,1,2,13,16,22,29,44],INPUT:[0,1,2,4,7,8,11,12,13,16,17,20,27,28,29,31,34,44,46],SELECT:[0,1,2,4,8,13,16,27,30,31,44],OPTGROUP:[0,1,2,16,27,32,44],OPTION:[0,1,2,16,17,27,32,33,44],TEXTAREA:[0,1,2,4,8,13,16,27,28,29,31,35,44],FIELDSET:[0,1,2,16,44],LEGEND:[0,1,2,16,29,44],BUTTON:[0,1,2,4,8,13,16,17,27,29,36,44],TABLE:[0,1,2,16,26,38,44],CAPTION:[0,1,2,16,44],COLGROUP:[0,1,2,16,26,39,40,44],COL:[0,1,2,16,26,39,40,44],THEAD:[0,1,2,16,39,44],TBODY:[0,1,2,16,39,44],TFOOT:[0,1,2,16,39,44],TR:[0,1,2,16,39,44],TH:[0,1,2,16,39,41,44],TD:[0,1,2,16,39,41,44],HEAD:[2,42],TITLE:[2],BASE:[5],META:[2,43],STYLE:[2,6,9,16],SCRIPT:[6,12,14,47],NOSCRIPT:[0,1,2,16,44],HTML:[2]},defaultAttributes=[0,1,2,4],SCHEMA=["[Element]|textContent,%classList,className,id,innerHTML,*beforecopy,*beforecut,*beforepaste,*copy,*cut,*paste,*search,*selectstart,*webkitfullscreenchange,*webkitfullscreenerror,*wheel,outerHTML,#scrollLeft,#scrollTop,slot,*message,*mozfullscreenchange,*mozfullscreenerror,*mozpointerlockchange,*mozpointerlockerror,*webglcontextcreationerror,*webglcontextlost,*webglcontextrestored","[HTMLElement]^[Element]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate","abbr,address,article,aside,b,bdi,bdo,cite,code,dd,dfn,dt,em,figcaption,figure,footer,header,i,kbd,main,mark,nav,noscript,rb,rp,rt,rtc,ruby,s,samp,section,small,strong,sub,sup,u,var,wbr^[HTMLElement]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate","media^[HTMLElement]|!autoplay,!controls,%controlsList,%crossOrigin,#currentTime,!defaultMuted,#defaultPlaybackRate,!disableRemotePlayback,!loop,!muted,*encrypted,*waitingforkey,#playbackRate,preload,src,%srcObject,#volume",":svg:^[HTMLElement]|*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,%style,#tabIndex",":svg:graphics^:svg:|",":svg:animation^:svg:|*begin,*end,*repeat",":svg:geometry^:svg:|",":svg:componentTransferFunction^:svg:|",":svg:gradient^:svg:|",":svg:textContent^:svg:graphics|",":svg:textPositioning^:svg:textContent|","a^[HTMLElement]|charset,coords,download,hash,host,hostname,href,hreflang,name,password,pathname,ping,port,protocol,referrerPolicy,rel,rev,search,shape,target,text,type,username","area^[HTMLElement]|alt,coords,download,hash,host,hostname,href,!noHref,password,pathname,ping,port,protocol,referrerPolicy,rel,search,shape,target,username","audio^media|","br^[HTMLElement]|clear","base^[HTMLElement]|href,target","body^[HTMLElement]|aLink,background,bgColor,link,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,text,vLink","button^[HTMLElement]|!autofocus,!disabled,formAction,formEnctype,formMethod,!formNoValidate,formTarget,name,type,value","canvas^[HTMLElement]|#height,#width","content^[HTMLElement]|select","dl^[HTMLElement]|!compact","datalist^[HTMLElement]|","details^[HTMLElement]|!open","dialog^[HTMLElement]|!open,returnValue","dir^[HTMLElement]|!compact","div^[HTMLElement]|align","embed^[HTMLElement]|align,height,name,src,type,width","fieldset^[HTMLElement]|!disabled,name","font^[HTMLElement]|color,face,size","form^[HTMLElement]|acceptCharset,action,autocomplete,encoding,enctype,method,name,!noValidate,target","frame^[HTMLElement]|frameBorder,longDesc,marginHeight,marginWidth,name,!noResize,scrolling,src","frameset^[HTMLElement]|cols,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,rows","hr^[HTMLElement]|align,color,!noShade,size,width","head^[HTMLElement]|","h1,h2,h3,h4,h5,h6^[HTMLElement]|align","html^[HTMLElement]|version","iframe^[HTMLElement]|align,!allowFullscreen,frameBorder,height,longDesc,marginHeight,marginWidth,name,referrerPolicy,%sandbox,scrolling,src,srcdoc,width","img^[HTMLElement]|align,alt,border,%crossOrigin,#height,#hspace,!isMap,longDesc,lowsrc,name,referrerPolicy,sizes,src,srcset,useMap,#vspace,#width","input^[HTMLElement]|accept,align,alt,autocapitalize,autocomplete,!autofocus,!checked,!defaultChecked,defaultValue,dirName,!disabled,%files,formAction,formEnctype,formMethod,!formNoValidate,formTarget,#height,!incremental,!indeterminate,max,#maxLength,min,#minLength,!multiple,name,pattern,placeholder,!readOnly,!required,selectionDirection,#selectionEnd,#selectionStart,#size,src,step,type,useMap,value,%valueAsDate,#valueAsNumber,#width","li^[HTMLElement]|type,#value","label^[HTMLElement]|htmlFor","legend^[HTMLElement]|align","link^[HTMLElement]|as,charset,%crossOrigin,!disabled,href,hreflang,integrity,media,referrerPolicy,rel,%relList,rev,%sizes,target,type","map^[HTMLElement]|name","marquee^[HTMLElement]|behavior,bgColor,direction,height,#hspace,#loop,#scrollAmount,#scrollDelay,!trueSpeed,#vspace,width","menu^[HTMLElement]|!compact","meta^[HTMLElement]|content,httpEquiv,name,scheme","meter^[HTMLElement]|#high,#low,#max,#min,#optimum,#value","ins,del^[HTMLElement]|cite,dateTime","ol^[HTMLElement]|!compact,!reversed,#start,type","object^[HTMLElement]|align,archive,border,code,codeBase,codeType,data,!declare,height,#hspace,name,standby,type,useMap,#vspace,width","optgroup^[HTMLElement]|!disabled,label","option^[HTMLElement]|!defaultSelected,!disabled,label,!selected,text,value","output^[HTMLElement]|defaultValue,%htmlFor,name,value","p^[HTMLElement]|align","param^[HTMLElement]|name,type,value,valueType","picture^[HTMLElement]|","pre^[HTMLElement]|#width","progress^[HTMLElement]|#max,#value","q,blockquote,cite^[HTMLElement]|","script^[HTMLElement]|!async,charset,%crossOrigin,!defer,event,htmlFor,integrity,src,text,type","select^[HTMLElement]|!autofocus,!disabled,#length,!multiple,name,!required,#selectedIndex,#size,value","shadow^[HTMLElement]|","slot^[HTMLElement]|name","source^[HTMLElement]|media,sizes,src,srcset,type","span^[HTMLElement]|","style^[HTMLElement]|!disabled,media,type","caption^[HTMLElement]|align","th,td^[HTMLElement]|abbr,align,axis,bgColor,ch,chOff,#colSpan,headers,height,!noWrap,#rowSpan,scope,vAlign,width","col,colgroup^[HTMLElement]|align,ch,chOff,#span,vAlign,width","table^[HTMLElement]|align,bgColor,border,%caption,cellPadding,cellSpacing,frame,rules,summary,%tFoot,%tHead,width","tr^[HTMLElement]|align,bgColor,ch,chOff,vAlign","tfoot,thead,tbody^[HTMLElement]|align,ch,chOff,vAlign","template^[HTMLElement]|","textarea^[HTMLElement]|autocapitalize,!autofocus,#cols,defaultValue,dirName,!disabled,#maxLength,#minLength,name,placeholder,!readOnly,!required,#rows,selectionDirection,#selectionEnd,#selectionStart,value,wrap","title^[HTMLElement]|text","track^[HTMLElement]|!default,kind,label,src,srclang","ul^[HTMLElement]|!compact,type","unknown^[HTMLElement]|","video^media|#height,poster,#width",":svg:a^:svg:graphics|",":svg:animate^:svg:animation|",":svg:animateMotion^:svg:animation|",":svg:animateTransform^:svg:animation|",":svg:circle^:svg:geometry|",":svg:clipPath^:svg:graphics|",":svg:defs^:svg:graphics|",":svg:desc^:svg:|",":svg:discard^:svg:|",":svg:ellipse^:svg:geometry|",":svg:feBlend^:svg:|",":svg:feColorMatrix^:svg:|",":svg:feComponentTransfer^:svg:|",":svg:feComposite^:svg:|",":svg:feConvolveMatrix^:svg:|",":svg:feDiffuseLighting^:svg:|",":svg:feDisplacementMap^:svg:|",":svg:feDistantLight^:svg:|",":svg:feDropShadow^:svg:|",":svg:feFlood^:svg:|",":svg:feFuncA^:svg:componentTransferFunction|",":svg:feFuncB^:svg:componentTransferFunction|",":svg:feFuncG^:svg:componentTransferFunction|",":svg:feFuncR^:svg:componentTransferFunction|",":svg:feGaussianBlur^:svg:|",":svg:feImage^:svg:|",":svg:feMerge^:svg:|",":svg:feMergeNode^:svg:|",":svg:feMorphology^:svg:|",":svg:feOffset^:svg:|",":svg:fePointLight^:svg:|",":svg:feSpecularLighting^:svg:|",":svg:feSpotLight^:svg:|",":svg:feTile^:svg:|",":svg:feTurbulence^:svg:|",":svg:filter^:svg:|",":svg:foreignObject^:svg:graphics|",":svg:g^:svg:graphics|",":svg:image^:svg:graphics|",":svg:line^:svg:geometry|",":svg:linearGradient^:svg:gradient|",":svg:mpath^:svg:|",":svg:marker^:svg:|",":svg:mask^:svg:|",":svg:metadata^:svg:|",":svg:path^:svg:geometry|",":svg:pattern^:svg:|",":svg:polygon^:svg:geometry|",":svg:polyline^:svg:geometry|",":svg:radialGradient^:svg:gradient|",":svg:rect^:svg:geometry|",":svg:svg^:svg:graphics|#currentScale,#zoomAndPan",":svg:script^:svg:|type",":svg:set^:svg:animation|",":svg:stop^:svg:|",":svg:style^:svg:|!disabled,media,title,type",":svg:switch^:svg:graphics|",":svg:symbol^:svg:|",":svg:tspan^:svg:textPositioning|",":svg:text^:svg:textPositioning|",":svg:textPath^:svg:textContent|",":svg:title^:svg:|",":svg:use^:svg:graphics|",":svg:view^:svg:|#zoomAndPan","data^[HTMLElement]|value","keygen^[HTMLElement]|!autofocus,challenge,!disabled,form,keytype,name","menuitem^[HTMLElement]|type,label,icon,!disabled,!checked,radiogroup,!default","summary^[HTMLElement]|","time^[HTMLElement]|dateTime",":svg:cursor^:svg:|"],EVENT="event",BOOLEAN="boolean",NUMBER="number",STRING="string",OBJECT="object",SchemaInformation=function(){function SchemaInformation(){var _this=this;this.schema={},SCHEMA.forEach(function(encodedType){var parts=encodedType.split("|"),properties=parts[1].split(","),typeParts=(parts[0]+"^").split("^"),typeName=typeParts[0],type={};typeName.split(",").forEach(function(tag){return _this.schema[tag.toLowerCase()]=type});var superName=typeParts[1],superType=superName&&_this.schema[superName.toLowerCase()];if(superType)for(var key in superType)type[key]=superType[key];properties.forEach(function(property){""==property||(property.startsWith("*")?type[property.substring(1)]=EVENT:property.startsWith("!")?type[property.substring(1)]=BOOLEAN:property.startsWith("#")?type[property.substring(1)]=NUMBER:property.startsWith("%")?type[property.substring(1)]=OBJECT:type[property]=STRING)})})}return SchemaInformation.prototype.allKnownElements=function(){return Object.keys(this.schema)},SchemaInformation.prototype.eventsOf=function(elementName){var elementType=this.schema[elementName.toLowerCase()]||{};return Object.keys(elementType).filter(function(property){return elementType[property]===EVENT})},SchemaInformation.prototype.propertiesOf=function(elementName){var elementType=this.schema[elementName.toLowerCase()]||{};return Object.keys(elementType).filter(function(property){return elementType[property]!==EVENT})},SchemaInformation.prototype.typeOf=function(elementName,property){return(this.schema[elementName.toLowerCase()]||{})[property]},Object.defineProperty(SchemaInformation,"instance",{get:function(){var result=SchemaInformation._instance;return result||(result=SchemaInformation._instance=new SchemaInformation),result},enumerable:!0,configurable:!0}),SchemaInformation}(),hiddenHtmlElements={html:!0,script:!0,noscript:!0,base:!0,body:!0,title:!0,head:!0,link:!0},ExpressionVisitor=function(_super){function ExpressionVisitor(info,position,attr,getExpressionScope$$1){var _this=_super.call(this)||this;return _this.info=info,_this.position=position,_this.attr=attr,_this.getExpressionScope=getExpressionScope$$1||function(){return info.template.members},_this}return __extends(ExpressionVisitor,_super),ExpressionVisitor.prototype.visitDirectiveProperty=function(ast){this.attributeValueCompletions(ast.value)},ExpressionVisitor.prototype.visitElementProperty=function(ast){this.attributeValueCompletions(ast.value)},ExpressionVisitor.prototype.visitEvent=function(ast){this.attributeValueCompletions(ast.handler)},ExpressionVisitor.prototype.visitElement=function(ast){var _this=this;if(this.attr&&getSelectors(this.info)&&this.attr.name.startsWith("*")){var key_1=this.attr.name.substr("*".length),selectorInfo=getSelectors(this.info),selectors=selectorInfo.selectors,selector_1=selectors.filter(function(s){return s.attrs.some(function(attr,i){return i%2==0&&attr==key_1})})[0],templateBindingResult=this.info.expressionParser.parseTemplateBindings(key_1,this.attr.value,null);if(!this.attr.valueSpan)return;var valueRelativePosition_1=this.position-this.attr.valueSpan.start.offset-1,bindings=templateBindingResult.templateBindings,binding=bindings.find(function(binding){return inSpan(valueRelativePosition_1,binding.span,!0)})||bindings.find(function(binding){return inSpan(valueRelativePosition_1,binding.span)}),keyCompletions=function(){var keys=[];if(selector_1){keys=selector_1.attrs.filter(function(_,i){return i%2==0}).filter(function(name){return name.startsWith(key_1)&&name!=key_1}).map(function(name){return lowerName(name.substr(key_1.length))})}keys.push("let"),_this.result=keys.map(function(key){return{kind:"key",name:key,sort:key}})};if(!binding||binding.key==key_1&&!binding.expression)keyCompletions();else if(binding.keyIsVar){var equalLocation=this.attr.value.indexOf("=");if(this.result=[],equalLocation>=0&&valueRelativePosition_1>=equalLocation){var directiveMetadata=selectorInfo.map.get(selector_1);if(directiveMetadata){var contextTable=this.info.template.query.getTemplateContext(directiveMetadata.type.reference);contextTable&&(this.result=this.symbolsToCompletions(contextTable.values()))}}else binding.key&&valueRelativePosition_1<=binding.key.length-key_1.length&&keyCompletions()}else if(binding.expression&&inSpan(valueRelativePosition_1,binding.expression.ast.span)||binding.key&&valueRelativePosition_1>binding.span.start+(binding.key.length-key_1.length)||!binding.key){var span=new ParseSpan(0,this.attr.value.length);this.attributeValueCompletions(binding.expression?binding.expression.ast:new PropertyRead(span,new ImplicitReceiver(span),""),valueRelativePosition_1)}else keyCompletions()}},ExpressionVisitor.prototype.visitBoundText=function(ast){var expressionPosition=this.position-ast.sourceSpan.start.offset;if(inSpan(expressionPosition,ast.value.span)){var completions=getExpressionCompletions(this.getExpressionScope(),ast.value,expressionPosition,this.info.template.query);completions&&(this.result=this.symbolsToCompletions(completions))}},ExpressionVisitor.prototype.attributeValueCompletions=function(value,position){var symbols=getExpressionCompletions(this.getExpressionScope(),value,null==position?this.attributeValuePosition:position,this.info.template.query);symbols&&(this.result=this.symbolsToCompletions(symbols))},ExpressionVisitor.prototype.symbolsToCompletions=function(symbols){return symbols.filter(function(s){return!s.name.startsWith("__")&&s.public}).map(function(symbol){return{kind:symbol.kind,name:symbol.name,sort:symbol.name}})},Object.defineProperty(ExpressionVisitor.prototype,"attributeValuePosition",{get:function(){return this.attr&&this.attr.valueSpan?this.position-this.attr.valueSpan.start.offset-1:0},enumerable:!0,configurable:!0}),ExpressionVisitor}(NullTemplateVisitor),templateAttr=/^(\w+:)?(template$|^\*)/,OverrideKindSymbol=function(){function OverrideKindSymbol(sym,kindOverride){this.sym=sym,this.kind=kindOverride}return Object.defineProperty(OverrideKindSymbol.prototype,"name",{get:function(){return this.sym.name},enumerable:!0,configurable:!0}),Object.defineProperty(OverrideKindSymbol.prototype,"language",{get:function(){return this.sym.language},enumerable:!0,configurable:!0}),Object.defineProperty(OverrideKindSymbol.prototype,"type",{get:function(){return this.sym.type},enumerable:!0,configurable:!0}),Object.defineProperty(OverrideKindSymbol.prototype,"container",{get:function(){return this.sym.container},enumerable:!0,configurable:!0}),Object.defineProperty(OverrideKindSymbol.prototype,"public",{get:function(){return this.sym.public},enumerable:!0,configurable:!0}),Object.defineProperty(OverrideKindSymbol.prototype,"callable",{get:function(){return this.sym.callable},enumerable:!0,configurable:!0}),Object.defineProperty(OverrideKindSymbol.prototype,"nullable",{get:function(){return this.sym.nullable},enumerable:!0,configurable:!0}),Object.defineProperty(OverrideKindSymbol.prototype,"definition",{get:function(){return this.sym.definition},enumerable:!0,configurable:!0}),OverrideKindSymbol.prototype.members=function(){return this.sym.members()},OverrideKindSymbol.prototype.signatures=function(){return this.sym.signatures()},OverrideKindSymbol.prototype.selectSignature=function(types){return this.sym.selectSignature(types)},OverrideKindSymbol.prototype.indexed=function(argument){return this.sym.indexed(argument)},OverrideKindSymbol}(),LanguageServiceImpl=function(){function LanguageServiceImpl(host){this.host=host}return Object.defineProperty(LanguageServiceImpl.prototype,"metadataResolver",{get:function(){return this.host.resolver},enumerable:!0,configurable:!0}),LanguageServiceImpl.prototype.getTemplateReferences=function(){return this.host.getTemplateReferences()},LanguageServiceImpl.prototype.getDiagnostics=function(fileName){var results=[],templates=this.host.getTemplates(fileName);templates&&templates.length&&results.push.apply(results,getTemplateDiagnostics(fileName,this,templates));var declarations=this.host.getDeclarations(fileName);if(declarations&&declarations.length){var summary=this.host.getAnalyzedModules();results.push.apply(results,getDeclarationDiagnostics(declarations,summary))}return uniqueBySpan(results)},LanguageServiceImpl.prototype.getPipesAt=function(fileName,position){var templateInfo=this.getTemplateAstAtPosition(fileName,position);return templateInfo?templateInfo.pipes:[]},LanguageServiceImpl.prototype.getCompletionsAt=function(fileName,position){var templateInfo=this.getTemplateAstAtPosition(fileName,position);if(templateInfo)return getTemplateCompletions(templateInfo)},LanguageServiceImpl.prototype.getDefinitionAt=function(fileName,position){var templateInfo=this.getTemplateAstAtPosition(fileName,position);if(templateInfo)return getDefinition(templateInfo)},LanguageServiceImpl.prototype.getHoverAt=function(fileName,position){var templateInfo=this.getTemplateAstAtPosition(fileName,position);if(templateInfo)return getHover(templateInfo)},LanguageServiceImpl.prototype.getTemplateAstAtPosition=function(fileName,position){var template=this.host.getTemplateAt(fileName,position);if(template){var astResult=this.getTemplateAst(template,fileName);if(astResult&&astResult.htmlAst&&astResult.templateAst&&astResult.directive&&astResult.directives&&astResult.pipes&&astResult.expressionParser)return{position:position,fileName:fileName,template:template,htmlAst:astResult.htmlAst,directive:astResult.directive,directives:astResult.directives,pipes:astResult.pipes,templateAst:astResult.templateAst,expressionParser:astResult.expressionParser}}},LanguageServiceImpl.prototype.getTemplateAst=function(template,contextFile){var _this=this,result=void 0;try{var resolvedMetadata=this.metadataResolver.getNonNormalizedDirectiveMetadata(template.type),metadata=resolvedMetadata&&resolvedMetadata.metadata;if(metadata){var rawHtmlParser=new HtmlParser,htmlParser=new I18NHtmlParser(rawHtmlParser),expressionParser=new Parser(new Lexer),config=new CompilerConfig,parser=new TemplateParser(config,this.host.resolver.getReflector(),expressionParser,new DomElementSchemaRegistry,htmlParser,null,[]),htmlResult=htmlParser.parse(template.source,"",!0),analyzedModules=this.host.getAnalyzedModules(),ngModule=analyzedModules.ngModuleByPipeOrDirective.get(template.type);if(ngModule||(ngModule=findSuitableDefaultModule(analyzedModules)),ngModule){var resolvedDirectives=ngModule.transitiveModule.directives.map(function(d){return _this.host.resolver.getNonNormalizedDirectiveMetadata(d.reference)}),directives=removeMissing(resolvedDirectives).map(function(d){return d.metadata.toSummary()}),pipes=ngModule.transitiveModule.pipes.map(function(p){return _this.host.resolver.getOrLoadPipeMetadata(p.reference).toSummary()}),schemas=ngModule.schemas,parseResult=parser.tryParseHtml(htmlResult,metadata,directives,pipes,schemas);result={htmlAst:htmlResult.rootNodes,templateAst:parseResult.templateAst,directive:metadata,directives:directives,pipes:pipes,parseErrors:parseResult.errors,expressionParser:expressionParser,errors:void 0}}}}catch(e){var span=template.span;e.fileName==contextFile&&(span=template.query.getSpanAt(e.line,e.column)||span),result={errors:[{kind:DiagnosticKind.Error,message:e.message,span:span}]}}return result||{}},LanguageServiceImpl}(),ReflectorModuleModuleResolutionHost=function(){function ReflectorModuleModuleResolutionHost(host,getProgram){var _this=this;this.host=host,this.getProgram=getProgram,this.metadataCollector=new language_services_13({verboseInvalidExpression:!0}),host.directoryExists&&(this.directoryExists=function(directoryName){return _this.host.directoryExists(directoryName)})}return ReflectorModuleModuleResolutionHost.prototype.fileExists=function(fileName){return!!this.host.getScriptSnapshot(fileName)},ReflectorModuleModuleResolutionHost.prototype.readFile=function(fileName){var snapshot=this.host.getScriptSnapshot(fileName);if(snapshot)return snapshot.getText(0,snapshot.getLength())},ReflectorModuleModuleResolutionHost.prototype.getSourceFileMetadata=function(fileName){var sf=this.getProgram().getSourceFile(fileName);return sf?this.metadataCollector.getMetadata(sf):void 0},ReflectorModuleModuleResolutionHost.prototype.cacheMetadata=function(fileName){return fileName.endsWith(".d.ts")},ReflectorModuleModuleResolutionHost}(),ReflectorHost=function(){function ReflectorHost(getProgram,serviceHost,options){this.options=options,this.metadataReaderCache=language_services_14(),this.hostAdapter=new ReflectorModuleModuleResolutionHost(serviceHost,getProgram),this.moduleResolutionCache=ts.createModuleResolutionCache(serviceHost.getCurrentDirectory(),function(s){return s})}return ReflectorHost.prototype.getMetadataFor=function(modulePath){return language_services_15(modulePath,this.hostAdapter,this.metadataReaderCache)},ReflectorHost.prototype.moduleNameToFileName=function(moduleName,containingFile){if(!containingFile){if(0===moduleName.indexOf("."))throw new Error("Resolution of relative paths requires a containing file.");containingFile=path.join(this.options.basePath,"index.ts").replace(/\\/g,"/")}var resolved=ts.resolveModuleName(moduleName,containingFile,this.options,this.hostAdapter).resolvedModule;return resolved?resolved.resolvedFileName:null},ReflectorHost.prototype.getOutputName=function(filePath){return filePath},ReflectorHost}(),DummyHtmlParser=function(_super){function DummyHtmlParser(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(DummyHtmlParser,_super),DummyHtmlParser.prototype.parse=function(source,url,parseExpansionForms,interpolationConfig){return void 0===parseExpansionForms&&(parseExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),new ParseTreeResult([],[])},DummyHtmlParser}(HtmlParser),DummyResourceLoader=function(_super){function DummyResourceLoader(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(DummyResourceLoader,_super),DummyResourceLoader.prototype.get=function(url){return Promise.resolve("")},DummyResourceLoader}(ResourceLoader),TypeScriptServiceHost=function(){function TypeScriptServiceHost(host,tsService){this.host=host,this.tsService=tsService,this._staticSymbolCache=new StaticSymbolCache,this._typeCache=[],this.modulesOutOfDate=!0,this.fileVersions=new Map}return TypeScriptServiceHost.prototype.setSite=function(service){this.service=service},Object.defineProperty(TypeScriptServiceHost.prototype,"resolver",{get:function(){var _this=this;this.validate();var result=this._resolver;if(!result){var moduleResolver=new NgModuleResolver(this.reflector),directiveResolver=new DirectiveResolver(this.reflector),pipeResolver=new PipeResolver(this.reflector),elementSchemaRegistry=new DomElementSchemaRegistry,resourceLoader=new DummyResourceLoader,urlResolver=createOfflineCompileUrlResolver(),htmlParser=new DummyHtmlParser,config=new CompilerConfig({defaultEncapsulation:ViewEncapsulation$1.Emulated,useJit:!1}),directiveNormalizer=new DirectiveNormalizer(resourceLoader,urlResolver,htmlParser,config);result=this._resolver=new CompileMetadataResolver(config,htmlParser,moduleResolver,directiveResolver,pipeResolver,new JitSummaryResolver,elementSchemaRegistry,directiveNormalizer,new Console,this._staticSymbolCache,this.reflector,function(error,type){return _this.collectError(error,type&&type.filePath)})}return result},enumerable:!0,configurable:!0}),TypeScriptServiceHost.prototype.getTemplateReferences=function(){return this.ensureTemplateMap(),this.templateReferences||[]},TypeScriptServiceHost.prototype.getTemplateAt=function(fileName,position){var sourceFile=this.getSourceFile(fileName);if(sourceFile){this.context=sourceFile.fileName;var node=this.findNode(sourceFile,position);if(node)return this.getSourceFromNode(fileName,this.host.getScriptVersion(sourceFile.fileName),node)}else{this.ensureTemplateMap();var componentType=this.fileToComponent.get(fileName);if(componentType)return this.getSourceFromType(fileName,this.host.getScriptVersion(fileName),componentType)}},TypeScriptServiceHost.prototype.getAnalyzedModules=function(){return this.updateAnalyzedModules(),this.ensureAnalyzedModules()},TypeScriptServiceHost.prototype.ensureAnalyzedModules=function(){var analyzedModules=this.analyzedModules;if(!analyzedModules){if(0===this.host.getScriptFileNames().length)analyzedModules={files:[],ngModuleByPipeOrDirective:new Map,ngModules:[]};else{var analyzeHost={isSourceFile:function(filePath){return!0}};analyzedModules=analyzeNgModules(this.program.getSourceFiles().map(function(sf){return sf.fileName}),analyzeHost,this.staticSymbolResolver,this.resolver)}this.analyzedModules=analyzedModules}return analyzedModules},TypeScriptServiceHost.prototype.getTemplates=function(fileName){var _this=this;if(this.ensureTemplateMap(),!this.fileToComponent.get(fileName)){var version_1=this.host.getScriptVersion(fileName),result_1=[],visit_1=function(child){var templateSource=_this.getSourceFromNode(fileName,version_1,child);templateSource?result_1.push(templateSource):ts.forEachChild(child,visit_1)},sourceFile=this.getSourceFile(fileName);return sourceFile&&(this.context=sourceFile.path||sourceFile.fileName,ts.forEachChild(sourceFile,visit_1)),result_1.length?result_1:void 0}var templateSource=this.getTemplateAt(fileName,0);if(templateSource)return[templateSource]},TypeScriptServiceHost.prototype.getDeclarations=function(fileName){var _this=this,result=[],sourceFile=this.getSourceFile(fileName);if(sourceFile){var visit_2=function(child){var declaration=_this.getDeclarationFromNode(sourceFile,child);declaration?result.push(declaration):ts.forEachChild(child,visit_2)};ts.forEachChild(sourceFile,visit_2)}return result},TypeScriptServiceHost.prototype.getSourceFile=function(fileName){return this.tsService.getProgram().getSourceFile(fileName)},TypeScriptServiceHost.prototype.updateAnalyzedModules=function(){this.validate(),this.modulesOutOfDate&&(this.analyzedModules=null,this._reflector=null,this.templateReferences=null,this.fileToComponent=null,this.ensureAnalyzedModules(),this.modulesOutOfDate=!1)},Object.defineProperty(TypeScriptServiceHost.prototype,"program",{get:function(){return this.tsService.getProgram()},enumerable:!0,configurable:!0}),
Object.defineProperty(TypeScriptServiceHost.prototype,"checker",{get:function(){var checker=this._checker;return checker||(checker=this._checker=this.program.getTypeChecker()),checker},enumerable:!0,configurable:!0}),TypeScriptServiceHost.prototype.validate=function(){var _this=this,program=this.program;if(this.lastProgram!==program){var invalidateFile=function(fileName){return _this._staticSymbolResolver.invalidateFile(fileName)};this.clearCaches();for(var seen_1=new Set,_i=0,_a=this.program.getSourceFiles();_i<_a.length;_i++){var sourceFile=_a[_i],fileName=sourceFile.fileName;seen_1.add(fileName);var version$$1=this.host.getScriptVersion(fileName);version$$1!=this.fileVersions.get(fileName)&&(this.fileVersions.set(fileName,version$$1),this._staticSymbolResolver&&invalidateFile(fileName))}var missing=Array.from(this.fileVersions.keys()).filter(function(f){return!seen_1.has(f)});missing.forEach(function(f){return _this.fileVersions.delete(f)}),this._staticSymbolResolver&&missing.forEach(invalidateFile),this.lastProgram=program}},TypeScriptServiceHost.prototype.clearCaches=function(){this._checker=null,this._typeCache=[],this._resolver=null,this.collectedErrors=null,this.modulesOutOfDate=!0},TypeScriptServiceHost.prototype.ensureTemplateMap=function(){if(!this.fileToComponent||!this.templateReferences){for(var fileToComponent=new Map,templateReference=[],ngModuleSummary=this.getAnalyzedModules(),urlResolver=createOfflineCompileUrlResolver(),_i=0,_a=ngModuleSummary.ngModules;_i<_a.length;_i++)for(var module_1=_a[_i],_b=0,_c=module_1.declaredDirectives;_b<_c.length;_b++){var directive$$1=_c[_b],metadata=this.resolver.getNonNormalizedDirectiveMetadata(directive$$1.reference).metadata;if(metadata.isComponent&&metadata.template&&metadata.template.templateUrl){var templateName=urlResolver.resolve(this.reflector.componentModuleUrl(directive$$1.reference),metadata.template.templateUrl);fileToComponent.set(templateName,directive$$1.reference),templateReference.push(templateName)}}this.fileToComponent=fileToComponent,this.templateReferences=templateReference}},TypeScriptServiceHost.prototype.getSourceFromDeclaration=function(fileName,version$$1,source,span,type,declaration,node,sourceFile){var queryCache=void 0,t=this;if(declaration)return{version:version$$1,source:source,span:span,type:type,get members(){return language_services_10(t.program,t.checker,sourceFile,declaration)},get query(){if(!queryCache){var pipes_1=t.service.getPipesAt(fileName,node.getStart());queryCache=language_services_12(t.program,t.checker,sourceFile,function(){return language_services_11(sourceFile,t.program,t.checker,pipes_1)})}return queryCache}}},TypeScriptServiceHost.prototype.getSourceFromNode=function(fileName,version$$1,node){switch(node.kind){case ts.SyntaxKind.NoSubstitutionTemplateLiteral:case ts.SyntaxKind.StringLiteral:var _a=this.getTemplateClassDeclFromNode(node),declaration=_a[0];_a[1];if(declaration&&declaration.name){var sourceFile=this.getSourceFile(fileName);return this.getSourceFromDeclaration(fileName,version$$1,this.stringOf(node)||"",shrink(spanOf$1(node)),this.reflector.getStaticSymbol(sourceFile.fileName,declaration.name.text),declaration,node,sourceFile)}}},TypeScriptServiceHost.prototype.getSourceFromType=function(fileName,version$$1,type){var result=void 0,declaration=this.getTemplateClassFromStaticSymbol(type);if(declaration){var snapshot=this.host.getScriptSnapshot(fileName);if(snapshot){var source=snapshot.getText(0,snapshot.getLength());result=this.getSourceFromDeclaration(fileName,version$$1,source,{start:0,end:source.length},type,declaration,declaration,declaration.getSourceFile())}}return result},Object.defineProperty(TypeScriptServiceHost.prototype,"reflectorHost",{get:function(){var _this=this,result=this._reflectorHost;if(!result){if(!this.context){var scriptFileNames=this.host.getScriptFileNames();if(0===scriptFileNames.length)throw new Error("Internal error: no script file names found");this.context=scriptFileNames[0]}var source=this.tsService.getProgram().getSourceFile(this.context);if(!source)throw new Error("Internal error: no context could be determined");var tsConfigPath=findTsConfig(source.fileName),basePath=path.dirname(tsConfigPath||this.context),options={basePath:basePath,genDir:basePath},compilerOptions=this.host.getCompilationSettings();compilerOptions&&compilerOptions.baseUrl&&(options.baseUrl=compilerOptions.baseUrl),compilerOptions&&compilerOptions.paths&&(options.paths=compilerOptions.paths),result=this._reflectorHost=new ReflectorHost(function(){return _this.tsService.getProgram()},this.host,options)}return result},enumerable:!0,configurable:!0}),TypeScriptServiceHost.prototype.collectError=function(error,filePath){if(filePath){var errorMap=this.collectedErrors;errorMap&&this.collectedErrors||(errorMap=this.collectedErrors=new Map);var errors=errorMap.get(filePath);errors||(errors=[],this.collectedErrors.set(filePath,errors)),errors.push(error)}},Object.defineProperty(TypeScriptServiceHost.prototype,"staticSymbolResolver",{get:function(){var _this=this,result=this._staticSymbolResolver;return result||(this._summaryResolver=new AotSummaryResolver({loadSummary:function(filePath){return null},isSourceFile:function(sourceFilePath){return!0},toSummaryFileName:function(sourceFilePath){return sourceFilePath},fromSummaryFileName:function(filePath){return filePath}},this._staticSymbolCache),result=this._staticSymbolResolver=new StaticSymbolResolver(this.reflectorHost,this._staticSymbolCache,this._summaryResolver,function(e,filePath){return _this.collectError(e,filePath)})),result},enumerable:!0,configurable:!0}),Object.defineProperty(TypeScriptServiceHost.prototype,"reflector",{get:function(){var _this=this,result=this._reflector;if(!result){var ssr=this.staticSymbolResolver;result=this._reflector=new StaticReflector(this._summaryResolver,ssr,[],[],function(e,filePath){return _this.collectError(e,filePath)})}return result},enumerable:!0,configurable:!0}),TypeScriptServiceHost.prototype.getTemplateClassFromStaticSymbol=function(type){var source=this.getSourceFile(type.filePath);if(source){return ts.forEachChild(source,function(child){if(child.kind===ts.SyntaxKind.ClassDeclaration){var classDeclaration=child;if(null!=classDeclaration.name&&classDeclaration.name.text===type.name)return classDeclaration}})}},TypeScriptServiceHost.prototype.getTemplateClassDeclFromNode=function(currentToken){var parentNode=currentToken.parent;if(!parentNode)return TypeScriptServiceHost.missingTemplate;if(parentNode.kind!==ts.SyntaxKind.PropertyAssignment)return TypeScriptServiceHost.missingTemplate;if("template"!==parentNode.name.text)return TypeScriptServiceHost.missingTemplate;if(!(parentNode=parentNode.parent)||parentNode.kind!==ts.SyntaxKind.ObjectLiteralExpression)return TypeScriptServiceHost.missingTemplate;if(!(parentNode=parentNode.parent)||parentNode.kind!==ts.SyntaxKind.CallExpression)return TypeScriptServiceHost.missingTemplate;var callTarget=parentNode.expression,decorator=parentNode.parent;if(!decorator||decorator.kind!==ts.SyntaxKind.Decorator)return TypeScriptServiceHost.missingTemplate;var declaration=decorator.parent;return declaration&&declaration.kind===ts.SyntaxKind.ClassDeclaration?[declaration,callTarget]:TypeScriptServiceHost.missingTemplate},TypeScriptServiceHost.prototype.getCollectedErrors=function(defaultSpan,sourceFile){var errors=this.collectedErrors&&this.collectedErrors.get(sourceFile.fileName);return errors&&errors.map(function(e){var line=e.line||e.position&&e.position.line,column=e.column||e.position&&e.position.column,span=spanAt(sourceFile,line,column)||defaultSpan;return isFormattedError(e)?errorToDiagnosticWithChain(e,span):{message:e.message,span:span}})||[]},TypeScriptServiceHost.prototype.getDeclarationFromNode=function(sourceFile,node){if(node.kind==ts.SyntaxKind.ClassDeclaration&&node.decorators&&node.name)for(var _i=0,_a=node.decorators;_i<_a.length;_i++){var decorator=_a[_i];if(decorator.expression&&decorator.expression.kind==ts.SyntaxKind.CallExpression){var classDeclaration=node;if(classDeclaration.name){var call=decorator.expression,target=call.expression,type=this.checker.getTypeAtLocation(target);if(type){var staticSymbol=this.reflector.getStaticSymbol(sourceFile.fileName,classDeclaration.name.text);try{if(this.resolver.isDirective(staticSymbol)){var metadata=this.resolver.getNonNormalizedDirectiveMetadata(staticSymbol).metadata,declarationSpan=spanOf$1(target);return{type:staticSymbol,declarationSpan:declarationSpan,metadata:metadata,errors:this.getCollectedErrors(declarationSpan,sourceFile)}}}catch(e){if(e.message){this.collectError(e,sourceFile.fileName);var declarationSpan=spanOf$1(target);return{type:staticSymbol,declarationSpan:declarationSpan,errors:this.getCollectedErrors(declarationSpan,sourceFile)}}}}}}}},TypeScriptServiceHost.prototype.stringOf=function(node){switch(node.kind){case ts.SyntaxKind.NoSubstitutionTemplateLiteral:case ts.SyntaxKind.StringLiteral:return node.text}},TypeScriptServiceHost.prototype.findNode=function(sourceFile,position){function find(node){if(position>=node.getStart()&&position<node.getEnd())return ts.forEachChild(node,find)||node}return find(sourceFile)},TypeScriptServiceHost.missingTemplate=[void 0,void 0],TypeScriptServiceHost}(),projectHostMap=new WeakMap,angularOnlyResults=process.argv.indexOf("--angularOnlyResults")>=0,VERSION=new Version$1("5.2.11");exports.createLanguageService=createLanguageService,exports.TypeScriptServiceHost=TypeScriptServiceHost,exports.createLanguageServiceFromTypescript=createLanguageServiceFromTypescript,exports.VERSION=VERSION,exports.getExternalFiles=getExternalFiles,exports.create=create,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=language-service.umd.min.js.map