"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interface_1 = require("./interface");
class DelegateTree {
    constructor(_other) {
        this._other = _other;
    }
    branch() { return this._other.branch(); }
    merge(other, strategy) { this._other.merge(other, strategy); }
    get root() { return this._other.root; }
    // Readonly.
    read(path) { return this._other.read(path); }
    exists(path) { return this._other.exists(path); }
    get(path) { return this._other.get(path); }
    getDir(path) { return this._other.getDir(path); }
    visit(visitor) { return this._other.visit(visitor); }
    // Change content of host files.
    overwrite(path, content) {
        return this._other.overwrite(path, content);
    }
    beginUpdate(path) { return this._other.beginUpdate(path); }
    commitUpdate(record) { return this._other.commitUpdate(record); }
    // Structural methods.
    create(path, content) {
        return this._other.create(path, content);
    }
    delete(path) { return this._other.delete(path); }
    rename(from, to) { return this._other.rename(from, to); }
    apply(action, strategy) {
        return this._other.apply(action, strategy);
    }
    get actions() { return this._other.actions; }
    [interface_1.TreeSymbol]() {
        return this;
    }
}
exports.DelegateTree = DelegateTree;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVsZWdhdGUuanMiLCJzb3VyY2VSb290IjoiLi8iLCJzb3VyY2VzIjpbInBhY2thZ2VzL2FuZ3VsYXJfZGV2a2l0L3NjaGVtYXRpY3Mvc3JjL3RyZWUvZGVsZWdhdGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFRQSwyQ0FRcUI7QUFFckI7SUFDRSxZQUFzQixNQUFZO1FBQVosV0FBTSxHQUFOLE1BQU0sQ0FBTTtJQUFHLENBQUM7SUFFdEMsTUFBTSxLQUFXLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUMsQ0FBQztJQUMvQyxLQUFLLENBQUMsS0FBVyxFQUFFLFFBQXdCLElBQVUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUUxRixJQUFJLElBQUksS0FBZSxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBRWpELFlBQVk7SUFDWixJQUFJLENBQUMsSUFBWSxJQUFtQixNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3BFLE1BQU0sQ0FBQyxJQUFZLElBQWEsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNsRSxHQUFHLENBQUMsSUFBWSxJQUFzQixNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3JFLE1BQU0sQ0FBQyxJQUFZLElBQWMsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNuRSxLQUFLLENBQUMsT0FBb0IsSUFBVSxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRXhFLGdDQUFnQztJQUNoQyxTQUFTLENBQUMsSUFBWSxFQUFFLE9BQXdCO1FBQzlDLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELFdBQVcsQ0FBQyxJQUFZLElBQW9CLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbkYsWUFBWSxDQUFDLE1BQXNCLElBQVUsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUV2RixzQkFBc0I7SUFDdEIsTUFBTSxDQUFDLElBQVksRUFBRSxPQUF3QjtRQUMzQyxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxNQUFNLENBQUMsSUFBWSxJQUFVLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0QsTUFBTSxDQUFDLElBQVksRUFBRSxFQUFVLElBQVUsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFL0UsS0FBSyxDQUFDLE1BQWMsRUFBRSxRQUF3QjtRQUM1QyxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFJLE9BQU8sS0FBZSxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBRXZELENBQUMsc0JBQVUsQ0FBQztRQUNWLE1BQU0sQ0FBQyxJQUFJLENBQUM7SUFDZCxDQUFDO0NBQ0Y7QUFyQ0Qsb0NBcUNDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuaW1wb3J0IHsgQWN0aW9uIH0gZnJvbSAnLi9hY3Rpb24nO1xuaW1wb3J0IHtcbiAgRGlyRW50cnksXG4gIEZpbGVFbnRyeSxcbiAgRmlsZVZpc2l0b3IsXG4gIE1lcmdlU3RyYXRlZ3ksXG4gIFRyZWUsXG4gIFRyZWVTeW1ib2wsXG4gIFVwZGF0ZVJlY29yZGVyLFxufSBmcm9tICcuL2ludGVyZmFjZSc7XG5cbmV4cG9ydCBjbGFzcyBEZWxlZ2F0ZVRyZWUgaW1wbGVtZW50cyBUcmVlIHtcbiAgY29uc3RydWN0b3IocHJvdGVjdGVkIF9vdGhlcjogVHJlZSkge31cblxuICBicmFuY2goKTogVHJlZSB7IHJldHVybiB0aGlzLl9vdGhlci5icmFuY2goKTsgfVxuICBtZXJnZShvdGhlcjogVHJlZSwgc3RyYXRlZ3k/OiBNZXJnZVN0cmF0ZWd5KTogdm9pZCB7IHRoaXMuX290aGVyLm1lcmdlKG90aGVyLCBzdHJhdGVneSk7IH1cblxuICBnZXQgcm9vdCgpOiBEaXJFbnRyeSB7IHJldHVybiB0aGlzLl9vdGhlci5yb290OyB9XG5cbiAgLy8gUmVhZG9ubHkuXG4gIHJlYWQocGF0aDogc3RyaW5nKTogQnVmZmVyIHwgbnVsbCB7IHJldHVybiB0aGlzLl9vdGhlci5yZWFkKHBhdGgpOyB9XG4gIGV4aXN0cyhwYXRoOiBzdHJpbmcpOiBib29sZWFuIHsgcmV0dXJuIHRoaXMuX290aGVyLmV4aXN0cyhwYXRoKTsgfVxuICBnZXQocGF0aDogc3RyaW5nKTogRmlsZUVudHJ5IHwgbnVsbCB7IHJldHVybiB0aGlzLl9vdGhlci5nZXQocGF0aCk7IH1cbiAgZ2V0RGlyKHBhdGg6IHN0cmluZyk6IERpckVudHJ5IHsgcmV0dXJuIHRoaXMuX290aGVyLmdldERpcihwYXRoKTsgfVxuICB2aXNpdCh2aXNpdG9yOiBGaWxlVmlzaXRvcik6IHZvaWQgeyByZXR1cm4gdGhpcy5fb3RoZXIudmlzaXQodmlzaXRvcik7IH1cblxuICAvLyBDaGFuZ2UgY29udGVudCBvZiBob3N0IGZpbGVzLlxuICBvdmVyd3JpdGUocGF0aDogc3RyaW5nLCBjb250ZW50OiBCdWZmZXIgfCBzdHJpbmcpOiB2b2lkIHtcbiAgICByZXR1cm4gdGhpcy5fb3RoZXIub3ZlcndyaXRlKHBhdGgsIGNvbnRlbnQpO1xuICB9XG4gIGJlZ2luVXBkYXRlKHBhdGg6IHN0cmluZyk6IFVwZGF0ZVJlY29yZGVyIHsgcmV0dXJuIHRoaXMuX290aGVyLmJlZ2luVXBkYXRlKHBhdGgpOyB9XG4gIGNvbW1pdFVwZGF0ZShyZWNvcmQ6IFVwZGF0ZVJlY29yZGVyKTogdm9pZCB7IHJldHVybiB0aGlzLl9vdGhlci5jb21taXRVcGRhdGUocmVjb3JkKTsgfVxuXG4gIC8vIFN0cnVjdHVyYWwgbWV0aG9kcy5cbiAgY3JlYXRlKHBhdGg6IHN0cmluZywgY29udGVudDogQnVmZmVyIHwgc3RyaW5nKTogdm9pZCB7XG4gICAgcmV0dXJuIHRoaXMuX290aGVyLmNyZWF0ZShwYXRoLCBjb250ZW50KTtcbiAgfVxuICBkZWxldGUocGF0aDogc3RyaW5nKTogdm9pZCB7IHJldHVybiB0aGlzLl9vdGhlci5kZWxldGUocGF0aCk7IH1cbiAgcmVuYW1lKGZyb206IHN0cmluZywgdG86IHN0cmluZyk6IHZvaWQgeyByZXR1cm4gdGhpcy5fb3RoZXIucmVuYW1lKGZyb20sIHRvKTsgfVxuXG4gIGFwcGx5KGFjdGlvbjogQWN0aW9uLCBzdHJhdGVneT86IE1lcmdlU3RyYXRlZ3kpOiB2b2lkIHtcbiAgICByZXR1cm4gdGhpcy5fb3RoZXIuYXBwbHkoYWN0aW9uLCBzdHJhdGVneSk7XG4gIH1cbiAgZ2V0IGFjdGlvbnMoKTogQWN0aW9uW10geyByZXR1cm4gdGhpcy5fb3RoZXIuYWN0aW9uczsgfVxuXG4gIFtUcmVlU3ltYm9sXSgpIHtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxufVxuIl19