/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTProviderMessages;

public class JWTToken
implements JWT {
    private static JWTProviderMessages log = (JWTProviderMessages)MessagesFactory.get(JWTProviderMessages.class);
    SignedJWT jwt;

    private JWTToken(String header, String claims, String signature) throws ParseException {
        this.jwt = new SignedJWT(new Base64URL(header), new Base64URL(claims), new Base64URL(signature));
    }

    public JWTToken(String serializedJWT) throws ParseException {
        try {
            this.jwt = SignedJWT.parse((String)serializedJWT);
        }
        catch (ParseException e) {
            log.unableToParseToken(e);
            throw e;
        }
    }

    public JWTToken(String alg, String[] claimsArray) {
        this(alg, claimsArray, null);
    }

    public JWTToken(String alg, String[] claimsArray, List<String> audiences) {
        JWSHeader header = new JWSHeader(new JWSAlgorithm(alg));
        if (claimsArray[2] != null) {
            if (audiences == null) {
                audiences = new ArrayList<String>();
            }
            audiences.add(claimsArray[2]);
        }
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer(claimsArray[0]).subject(claimsArray[1]).audience(audiences);
        if (claimsArray[3] != null) {
            builder = builder.expirationTime(new Date(Long.parseLong(claimsArray[3])));
        }
        JWTClaimsSet claims = builder.build();
        this.jwt = new SignedJWT(header, claims);
    }

    @Override
    public String getHeader() {
        JWSHeader header = this.jwt.getHeader();
        return header.toString();
    }

    @Override
    public String getClaims() {
        String c = null;
        try {
            JWTClaimsSet claims = this.jwt.getJWTClaimsSet();
            c = claims.toJSONObject().toJSONString();
        }
        catch (ParseException e) {
            log.unableToParseToken(e);
        }
        return c;
    }

    @Override
    public String getPayload() {
        Payload payload = this.jwt.getPayload();
        return payload.toString();
    }

    public String toString() {
        return this.jwt.serialize();
    }

    @Override
    public void setSignaturePayload(byte[] payload) {
    }

    @Override
    public byte[] getSignaturePayload() {
        byte[] b = null;
        Base64URL b64 = this.jwt.getSignature();
        if (b64 != null) {
            b = b64.decode();
        }
        return b;
    }

    public static JWTToken parseToken(String wireToken) throws ParseException {
        log.parsingToken(wireToken);
        String[] parts = wireToken.split("\\.");
        return new JWTToken(parts[0], parts[1], parts[2]);
    }

    @Override
    public String getClaim(String claimName) {
        String claim = null;
        try {
            claim = this.jwt.getJWTClaimsSet().getStringClaim(claimName);
        }
        catch (ParseException e) {
            log.unableToParseToken(e);
        }
        return claim;
    }

    @Override
    public String getSubject() {
        return this.getClaim("sub");
    }

    @Override
    public String getIssuer() {
        return this.getClaim("iss");
    }

    @Override
    public String getAudience() {
        String c = null;
        String[] claim = this.getAudienceClaims();
        if (claim != null) {
            c = claim[0];
        }
        return c;
    }

    @Override
    public String[] getAudienceClaims() {
        String[] claims = null;
        try {
            claims = this.jwt.getJWTClaimsSet().getStringArrayClaim("aud");
        }
        catch (ParseException e) {
            log.unableToParseToken(e);
        }
        return claims;
    }

    @Override
    public String getExpires() {
        Date expires = this.getExpiresDate();
        if (expires != null) {
            return String.valueOf(expires.getTime());
        }
        return null;
    }

    @Override
    public Date getExpiresDate() {
        Date date = null;
        try {
            date = this.jwt.getJWTClaimsSet().getExpirationTime();
        }
        catch (ParseException e) {
            log.unableToParseToken(e);
        }
        return date;
    }

    @Override
    public Date getNotBeforeDate() {
        Date date = null;
        try {
            date = this.jwt.getJWTClaimsSet().getNotBeforeTime();
        }
        catch (ParseException e) {
            log.unableToParseToken(e);
        }
        return date;
    }

    @Override
    public String getPrincipal() {
        return this.getClaim("prn");
    }

    @Override
    public void sign(JWSSigner signer) {
        try {
            this.jwt.sign(signer);
        }
        catch (JOSEException e) {
            log.unableToSignToken(e);
        }
    }

    @Override
    public boolean verify(JWSVerifier verifier) {
        boolean rc = false;
        try {
            rc = this.jwt.verify(verifier);
        }
        catch (JOSEException e) {
            log.unableToVerifyToken(e);
        }
        return rc;
    }
}

