/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.authorization.generator;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.oidc.profile.keycloak.KeycloakOidcProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakRolesAuthorizationGenerator
implements AuthorizationGenerator<KeycloakOidcProfile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakRolesAuthorizationGenerator.class);
    private String clientId;

    public KeycloakRolesAuthorizationGenerator() {
    }

    public KeycloakRolesAuthorizationGenerator(String clientId) {
        this.clientId = clientId;
    }

    public KeycloakOidcProfile generate(WebContext context, KeycloakOidcProfile profile) {
        try {
            JSONArray vmsRolesJsonArray;
            JSONObject clientRolesJsonObject;
            JSONArray realmRolesJsonArray;
            SignedJWT jwt = SignedJWT.parse((String)profile.getAccessToken().getValue());
            JWTClaimsSet jwtClaimsSet = jwt.getJWTClaimsSet();
            JSONObject realmRolesJsonObject = jwtClaimsSet.getJSONObjectClaim("realm_access");
            if (realmRolesJsonObject != null && (realmRolesJsonArray = (JSONArray)realmRolesJsonObject.get((Object)"roles")) != null) {
                realmRolesJsonArray.forEach(role -> profile.addRole((String)role));
            }
            if (this.clientId != null && (clientRolesJsonObject = (JSONObject)jwtClaimsSet.getJSONObjectClaim("resource_access").get((Object)this.clientId)) != null && (vmsRolesJsonArray = (JSONArray)clientRolesJsonObject.get((Object)"roles")) != null) {
                vmsRolesJsonArray.forEach(role -> profile.addRole((String)role));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse Keycloak roles", (Throwable)e);
        }
        return profile;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

