/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.sso.SAML2MessageReceiver;
import org.pac4j.saml.sso.SAML2ResponseValidator;
import org.pac4j.saml.transport.Pac4jHTTPPostDecoder;
import org.pac4j.saml.util.Configuration;

public class SAML2WebSSOMessageReceiver
implements SAML2MessageReceiver {
    private static final String SAML2_WEBSSO_PROFILE_URI = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    private final SAML2ResponseValidator validator;

    public SAML2WebSSOMessageReceiver(SAML2ResponseValidator validator) {
        this.validator = validator;
    }

    @Override
    public Credentials receiveMessage(SAML2MessageContext context) {
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        context.getSAMLSelfProtocolContext().setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        Pac4jHTTPPostDecoder decoder = new Pac4jHTTPPostDecoder(context.getWebContext());
        try {
            decoder.setParserPool(Configuration.getParserPool());
            decoder.initialize();
            decoder.decode();
        }
        catch (Exception e) {
            throw new SAMLException("Error decoding saml message", e);
        }
        SAML2MessageContext decodedCtx = new SAML2MessageContext((MessageContext<SAMLObject>)decoder.getMessageContext());
        decodedCtx.setMessage(decoder.getMessageContext().getMessage());
        decodedCtx.setSAMLMessageStorage(context.getSAMLMessageStorage());
        SAMLBindingContext bindingContext = (SAMLBindingContext)decodedCtx.getParent().getSubcontext(SAMLBindingContext.class);
        decodedCtx.getSAMLBindingContext().setBindingDescriptor(bindingContext.getBindingDescriptor());
        decodedCtx.getSAMLBindingContext().setBindingUri(bindingContext.getBindingUri());
        decodedCtx.getSAMLBindingContext().setHasBindingSignature(bindingContext.hasBindingSignature());
        decodedCtx.getSAMLBindingContext().setIntendedDestinationEndpointURIRequired(bindingContext.isIntendedDestinationEndpointURIRequired());
        decodedCtx.getSAMLBindingContext().setRelayState(bindingContext.getRelayState());
        AssertionConsumerService acsService = context.getSPAssertionConsumerService();
        decodedCtx.getSAMLEndpointContext().setEndpoint((Endpoint)acsService);
        EntityDescriptor metadata = context.getSAMLPeerMetadataContext().getEntityDescriptor();
        if (metadata == null) {
            throw new SAMLException("IDP Metadata cannot be null");
        }
        decodedCtx.getSAMLPeerEntityContext().setEntityId(metadata.getEntityID());
        decodedCtx.getSAMLSelfEntityContext().setEntityId(context.getSAMLSelfEntityContext().getEntityId());
        decodedCtx.getSAMLSelfEndpointContext().setEndpoint(context.getSAMLSelfEndpointContext().getEndpoint());
        decodedCtx.getSAMLSelfEntityContext().setRole(context.getSAMLSelfEntityContext().getRole());
        decodedCtx.getProfileRequestContext().setProfileId(SAML2_WEBSSO_PROFILE_URI);
        decodedCtx.getSAMLSelfMetadataContext().setRoleDescriptor((RoleDescriptor)context.getSPSSODescriptor());
        return this.validator.validate(decodedCtx);
    }
}

