/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.karaf.instance.core.Instance;
import org.apache.karaf.instance.core.InstanceService;
import org.apache.karaf.instance.core.InstanceSettings;
import org.apache.karaf.instance.core.internal.InstanceImpl;
import org.apache.karaf.jpm.impl.ProcessBuilderFactoryImpl;
import org.apache.karaf.jpm.impl.ScriptUtils;
import org.apache.karaf.util.locks.FileLockUtils;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceServiceImpl
implements InstanceService {
    public static final String STORAGE_FILE = "instance.properties";
    public static final String BACKUP_EXTENSION = ".bak";
    private static final String FEATURES_CFG = "etc/org.apache.karaf.features.cfg";
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceServiceImpl.class);
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    private static final String KARAF_SHUTDOWN_PORT = "karaf.shutdown.port";
    private static final String KARAF_SHUTDOWN_HOST = "karaf.shutdown.host";
    private static final String KARAF_SHUTDOWN_PORT_FILE = "karaf.shutdown.port.file";
    private static final String KARAF_SHUTDOWN_COMMAND = "karaf.shutdown.command";
    private static final String KARAF_SHUTDOWN_PID_FILE = "karaf.shutdown.pid.file";
    private static final String KARAF_SHUTDOWN_TIMEOUT = "karaf.shutdown.timeout";
    private static final String DEFAULT_SHUTDOWN_COMMAND = "SHUTDOWN";
    public static final String DEFAULT_JAVA_OPTS = "-server -Xmx512M -Dcom.sun.management.jmxremote -XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass";
    private LinkedHashMap<String, InstanceImpl> proxies = new LinkedHashMap();
    private File storageLocation;
    private long stopTimeout = 30000L;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storage) {
        this.storageLocation = storage;
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    private State loadData(org.apache.felix.utils.properties.Properties storage) {
        State state = new State();
        int count = this.getInt(storage, "count", 0);
        state.defaultSshPortStart = this.getInt(storage, "ssh.port", state.defaultSshPortStart);
        state.defaultRmiRegistryPortStart = this.getInt(storage, "rmi.registry.port", state.defaultRmiRegistryPortStart);
        state.defaultRmiServerPortStart = this.getInt(storage, "rmi.server.port", state.defaultRmiServerPortStart);
        state.instances = new LinkedHashMap<String, InstanceState>();
        for (int i = 0; i < count; ++i) {
            InstanceState instance = new InstanceState();
            instance.name = this.getString(storage, "item." + i + ".name", null);
            instance.loc = this.getString(storage, "item." + i + ".loc", null);
            instance.opts = this.getString(storage, "item." + i + ".opts", null);
            instance.pid = this.getInt(storage, "item." + i + ".pid", 0);
            instance.root = this.getBool(storage, "item." + i + ".root", false);
            state.instances.put(instance.name, instance);
        }
        for (InstanceState instance : state.instances.values()) {
            if (this.proxies.containsKey(instance.name)) continue;
            this.proxies.put(instance.name, new InstanceImpl(this, instance.name));
        }
        ArrayList<String> names = new ArrayList<String>(this.proxies.keySet());
        for (String name : names) {
            if (state.instances.containsKey(name)) continue;
            this.proxies.remove(name);
        }
        return state;
    }

    private void saveData(State state, org.apache.felix.utils.properties.Properties storage) {
        storage.put("ssh.port", Integer.toString(state.defaultSshPortStart));
        storage.put("rmi.registry.port", Integer.toString(state.defaultRmiRegistryPortStart));
        storage.put("rmi.server.port", Integer.toString(state.defaultRmiServerPortStart));
        storage.put("count", Integer.toString(state.instances.size()));
        int i = 0;
        for (InstanceState instance : state.instances.values()) {
            storage.put("item." + i + ".name", instance.name);
            storage.put("item." + i + ".root", Boolean.toString(instance.root));
            storage.put("item." + i + ".loc", instance.loc);
            storage.put("item." + i + ".pid", Integer.toString(instance.pid));
            storage.put("item." + i + ".opts", instance.opts != null ? instance.opts : "");
            ++i;
        }
        while (storage.containsKey("item." + i + ".name")) {
            storage.remove("item." + i + ".name");
            storage.remove("item." + i + ".root");
            storage.remove("item." + i + ".loc");
            storage.remove("item." + i + ".pid");
            storage.remove("item." + i + ".opts");
            ++i;
        }
    }

    private boolean getBool(org.apache.felix.utils.properties.Properties storage, String name, boolean def) {
        Object value = storage.get(name);
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return def;
    }

    private int getInt(org.apache.felix.utils.properties.Properties storage, String name, int def) {
        Object value = storage.get(name);
        if (value != null) {
            return Integer.parseInt(value.toString());
        }
        return def;
    }

    private String getString(org.apache.felix.utils.properties.Properties storage, String name, String def) {
        Object value = storage.get(name);
        return value != null ? value.toString() : def;
    }

    synchronized <T> T execute(final Task<T> callback, final boolean writeToFile) {
        File storageFile = new File(this.storageLocation, STORAGE_FILE);
        if (!storageFile.exists()) {
            storageFile.getParentFile().mkdirs();
            try {
                storageFile.createNewFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (storageFile.exists()) {
            if (!storageFile.isFile()) {
                throw new IllegalStateException("Instance storage location should be a file: " + storageFile);
            }
            try {
                return FileLockUtils.execute(storageFile, new FileLockUtils.CallableWithProperties<T>(){

                    @Override
                    public T call(org.apache.felix.utils.properties.Properties properties) throws IOException {
                        State state = InstanceServiceImpl.this.loadData(properties);
                        Object t = callback.call(state);
                        if (writeToFile) {
                            InstanceServiceImpl.this.saveData(state, properties);
                        }
                        return t;
                    }
                }, writeToFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Instance storage location does not exist: " + storageFile);
    }

    @Override
    public synchronized void refreshInstance() throws Exception {
    }

    private void logInfo(String message, boolean printOutput, Object ... args) {
        if (LOGGER.isInfoEnabled() || printOutput) {
            String formatted = String.format(message, args);
            LOGGER.info(formatted);
            if (printOutput) {
                this.println(formatted);
            }
        }
    }

    @Override
    public synchronized Instance createInstance(final String name, final InstanceSettings settings, final boolean printOutput) throws Exception {
        return this.execute(new Task<Instance>(){

            @Override
            public Instance call(State state) throws IOException {
                int rmiServerPort;
                int sshPort;
                if (state.instances.get(name) != null) {
                    throw new IllegalArgumentException("Instance '" + name + "' already exists");
                }
                String loc = settings.getLocation() != null ? settings.getLocation() : name;
                File karafBase = new File(loc);
                if (!karafBase.isAbsolute()) {
                    karafBase = new File(InstanceServiceImpl.this.storageLocation, loc);
                }
                if ((sshPort = settings.getSshPort()) <= 0) {
                    sshPort = ++state.defaultSshPortStart;
                }
                String sshHost = settings.getAddress();
                int rmiRegistryPort = settings.getRmiRegistryPort();
                if (rmiRegistryPort <= 0) {
                    rmiRegistryPort = ++state.defaultRmiRegistryPortStart;
                }
                if ((rmiServerPort = settings.getRmiServerPort()) <= 0) {
                    rmiServerPort = ++state.defaultRmiServerPortStart;
                }
                InstanceServiceImpl.this.logInfo("Creating new instance on SSH port %d and registry port %d / RMI server port %d at: %s", printOutput, new Object[]{sshPort, rmiRegistryPort, rmiServerPort, karafBase});
                InstanceServiceImpl.this.mkdir(karafBase, "bin", printOutput);
                InstanceServiceImpl.this.mkdir(karafBase, "etc", printOutput);
                InstanceServiceImpl.this.mkdir(karafBase, "system", printOutput);
                InstanceServiceImpl.this.mkdir(karafBase, "deploy", printOutput);
                InstanceServiceImpl.this.mkdir(karafBase, "data", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/all.policy", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/config.properties", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/custom.properties", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/distribution.info", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/equinox-debug.properties", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/java.util.logging.properties", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/jmx.acl.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/jmx.acl.java.lang.Memory.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/jmx.acl.org.apache.karaf.bundle.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/jmx.acl.org.apache.karaf.config.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/jmx.acl.org.apache.karaf.security.jmx.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/jmx.acl.osgi.compendium.cm.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/jre.properties", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/keys.properties", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.felix.fileinstall-deploy.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.command.acl.bundle.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.command.acl.config.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.command.acl.feature.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.command.acl.jaas.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.command.acl.kar.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.command.acl.shell.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.command.acl.system.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.features.obr.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.features.repos.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.jaas.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.kar.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.apache.karaf.log.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.ops4j.pax.logging.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/org.ops4j.pax.url.mvn.cfg", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/regions-config.xml", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/shell.init.script", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, "etc/users.properties", printOutput);
                InstanceServiceImpl.this.copyResourceToDir(karafBase, InstanceServiceImpl.FEATURES_CFG, printOutput);
                InstanceServiceImpl.this.addFeaturesFromSettings(new File(karafBase, InstanceServiceImpl.FEATURES_CFG), settings);
                File rootEtc = new File(System.getProperty("karaf.etc"));
                InstanceServiceImpl.this.copy(new File(rootEtc, "startup.properties"), new File(karafBase, "etc/startup.properties"));
                File rootOverrides = new File(rootEtc, "overrides.properties");
                if (rootOverrides.exists()) {
                    InstanceServiceImpl.this.copy(rootOverrides, new File(karafBase, "etc/overrides.properties"));
                }
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("${SUBST-KARAF-NAME}", name);
                props.put("${SUBST-KARAF-HOME}", System.getProperty("karaf.home"));
                props.put("${SUBST-KARAF-BASE}", karafBase.getPath());
                props.put("${SUBST-SSH-PORT}", Integer.toString(sshPort));
                props.put("${SUBST-SSH-HOST}", sshHost);
                props.put("${SUBST-RMI-REGISTRY-PORT}", Integer.toString(rmiRegistryPort));
                props.put("${SUBST-RMI-SERVER-PORT}", Integer.toString(rmiServerPort));
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "etc/system.properties", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "etc/org.apache.karaf.shell.cfg", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "etc/org.apache.karaf.management.cfg", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "bin/karaf", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "bin/start", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "bin/stop", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "bin/karaf.bat", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "bin/start.bat", props, printOutput);
                InstanceServiceImpl.this.copyFilteredResourceToDir(karafBase, "bin/stop.bat", props, printOutput);
                try {
                    InstanceServiceImpl.this.chmod(new File(karafBase, "bin/karaf"), "a+x");
                    InstanceServiceImpl.this.chmod(new File(karafBase, "bin/start"), "a+x");
                    InstanceServiceImpl.this.chmod(new File(karafBase, "bin/stop"), "a+x");
                }
                catch (IOException e) {
                    LOGGER.debug("Could not set file mode on scripts.", (Throwable)e);
                }
                String javaOpts = settings.getJavaOpts();
                if (javaOpts == null || javaOpts.length() == 0) {
                    javaOpts = InstanceServiceImpl.DEFAULT_JAVA_OPTS;
                }
                InstanceState is = new InstanceState();
                is.name = name;
                is.loc = karafBase.toString();
                is.opts = javaOpts;
                state.instances.put(name, is);
                InstanceImpl instance = new InstanceImpl(InstanceServiceImpl.this, name);
                InstanceServiceImpl.this.proxies.put(name, instance);
                return instance;
            }
        }, true);
    }

    void addFeaturesFromSettings(File featuresCfg, final InstanceSettings settings) throws IOException {
        FileLockUtils.execute(featuresCfg, new FileLockUtils.RunnableWithProperties(){

            @Override
            public void run(org.apache.felix.utils.properties.Properties properties) throws IOException {
                InstanceServiceImpl.this.appendToPropList(properties, "featuresBoot", settings.getFeatures());
                InstanceServiceImpl.this.appendToPropList(properties, "featuresRepositories", settings.getFeatureURLs());
            }
        }, true);
    }

    private void appendToPropList(org.apache.felix.utils.properties.Properties p, String key, List<String> elements) {
        if (elements == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(((String)p.get(key)).toString().trim());
        for (String f : elements) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f);
        }
        p.put(key, sb.toString());
    }

    @Override
    public Instance[] getInstances() {
        return this.execute(new Task<Instance[]>(){

            @Override
            public Instance[] call(State state) throws IOException {
                return InstanceServiceImpl.this.proxies.values().toArray(new Instance[InstanceServiceImpl.this.proxies.size()]);
            }
        }, false);
    }

    @Override
    public Instance getInstance(final String name) {
        return this.execute(new Task<Instance>(){

            @Override
            public Instance call(State state) throws IOException {
                return (Instance)InstanceServiceImpl.this.proxies.get(name);
            }
        }, false);
    }

    public void startInstance(final String name, final String javaOpts) {
        this.execute(new Task<Object>(){

            @Override
            public Object call(State state) throws IOException {
                String karafOptsEnv;
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                InstanceServiceImpl.this.checkPid(instance);
                if (instance.pid != 0) {
                    throw new IllegalStateException("Instance already started");
                }
                String opts = javaOpts;
                if (opts == null || opts.length() == 0) {
                    opts = instance.opts;
                }
                if (opts == null || opts.length() == 0) {
                    opts = InstanceServiceImpl.DEFAULT_JAVA_OPTS;
                }
                String karafOpts = System.getProperty("karaf.opts", (karafOptsEnv = System.getenv("KARAF_OPTS")) != null ? karafOptsEnv : "");
                String location = instance.loc;
                File libDir = new File(System.getProperty("karaf.home"), "lib");
                File childLibDir = new File(location, "lib");
                StringBuilder classpath = this.classpathFromLibDir(libDir);
                StringBuilder childClasspath = this.classpathFromLibDir(childLibDir);
                if (childClasspath.length() > 0 && !libDir.equals(childLibDir)) {
                    classpath.append(System.getProperty("path.separator"));
                    classpath.append((CharSequence)childClasspath);
                }
                String command = "\"" + new File(System.getProperty("java.home"), ScriptUtils.isWindows() ? "bin\\java.exe" : "bin/java").getCanonicalPath() + "\" " + opts + " " + karafOpts + " -Djava.util.logging.config.file=\"" + new File(location, "etc/java.util.logging.properties").getCanonicalPath() + "\"" + " -Djava.endorsed.dirs=\"" + new File(new File(new File(System.getProperty("java.home"), "jre"), "lib"), "endorsed") + System.getProperty("path.separator") + new File(new File(System.getProperty("java.home"), "lib"), "endorsed") + System.getProperty("path.separator") + new File(libDir, "endorsed").getCanonicalPath() + "\"" + " -Djava.ext.dirs=\"" + new File(new File(new File(System.getProperty("java.home"), "jre"), "lib"), "ext") + System.getProperty("path.separator") + new File(new File(System.getProperty("java.home"), "lib"), "ext") + System.getProperty("path.separator") + new File(libDir, "ext").getCanonicalPath() + "\"" + " -Dkaraf.home=\"" + System.getProperty("karaf.home") + "\"" + " -Dkaraf.base=\"" + new File(location).getCanonicalPath() + "\"" + " -Dkaraf.data=\"" + new File(new File(location).getCanonicalPath(), "data") + "\"" + " -Dkaraf.etc=\"" + new File(new File(location).getCanonicalPath(), "etc") + "\"" + " -Dkaraf.startLocalConsole=false" + " -Dkaraf.startRemoteShell=true" + " -classpath \"" + classpath.toString() + "\"" + " org.apache.karaf.main.Main server";
                if (System.getenv("KARAF_REDIRECT") != null && !System.getenv("KARAF_REDIRECT").isEmpty()) {
                    command = command + " >> " + System.getenv("KARAF_REDIRECT");
                }
                LOGGER.debug("Starting instance " + name + " with command: " + command);
                org.apache.karaf.jpm.Process process = new ProcessBuilderFactoryImpl().newBuilder().directory(new File(location)).command(command).start();
                instance.pid = process.getPid();
                return null;
            }

            private StringBuilder classpathFromLibDir(File libDir) throws IOException {
                File[] jars = libDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                StringBuilder classpath = new StringBuilder();
                if (jars != null) {
                    for (File jar : jars) {
                        if (classpath.length() > 0) {
                            classpath.append(System.getProperty("path.separator"));
                        }
                        classpath.append(jar.getCanonicalPath());
                    }
                }
                return classpath;
            }
        }, true);
    }

    public void stopInstance(final String name) {
        Integer pid = (Integer)this.execute(new Task<Object>(){

            @Override
            public Object call(State state) throws IOException {
                int rootInstancePID = 0;
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                InstanceServiceImpl.this.checkPid(instance);
                if (instance.pid == 0) {
                    throw new IllegalStateException("Instance already stopped");
                }
                InstanceServiceImpl.this.cleanShutdown(instance);
                if (instance.pid > 0) {
                    if (!instance.root) {
                        org.apache.karaf.jpm.Process process = new ProcessBuilderFactoryImpl().newBuilder().attach(instance.pid);
                        process.destroy();
                    } else {
                        rootInstancePID = instance.pid;
                    }
                    instance.pid = 0;
                }
                return rootInstancePID;
            }
        }, true);
        if (pid != 0 && this.isInstanceRoot(name)) {
            try {
                org.apache.karaf.jpm.Process process = new ProcessBuilderFactoryImpl().newBuilder().attach(pid);
                process.destroy();
            }
            catch (IOException e) {
                LOGGER.debug("Unable to cleanly shutdown root instance ", (Throwable)e);
            }
        }
    }

    public void destroyInstance(final String name) {
        this.execute(new Task<Object>(){

            @Override
            public Object call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                InstanceServiceImpl.this.checkPid(instance);
                if (instance.pid != 0) {
                    throw new IllegalStateException("Instance not stopped");
                }
                InstanceServiceImpl.this.deleteFile(new File(instance.loc));
                state.instances.remove(name);
                InstanceServiceImpl.this.proxies.remove(name);
                return null;
            }
        }, true);
    }

    @Override
    public void renameInstance(final String oldName, final String newName, boolean printOutput) throws Exception {
        this.execute(new Task<Object>(){

            @Override
            public Object call(State state) throws IOException {
                if (state.instances.get(newName) != null) {
                    throw new IllegalArgumentException("Instance " + newName + " already exists");
                }
                InstanceState instance = state.instances.get(oldName);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + oldName + " not found");
                }
                if (instance.root) {
                    throw new IllegalArgumentException("Root instance cannot be renamed");
                }
                InstanceServiceImpl.this.checkPid(instance);
                if (instance.pid != 0) {
                    throw new IllegalStateException("Instance not stopped");
                }
                InstanceServiceImpl.this.println(Ansi.ansi().a("Renaming instance ").a(Ansi.Attribute.INTENSITY_BOLD).a(oldName).a(Ansi.Attribute.RESET).a(" to ").a(Ansi.Attribute.INTENSITY_BOLD).a(newName).a(Ansi.Attribute.RESET).toString());
                String oldLocationPath = instance.loc;
                File oldLocation = new File(oldLocationPath);
                String basedir = oldLocation.getParent();
                File newLocation = new File(basedir, newName);
                oldLocation.renameTo(newLocation);
                HashMap<String, String> props = new HashMap<String, String>();
                props.put(oldName, newName);
                props.put(oldLocationPath, newLocation.getPath());
                InstanceServiceImpl.this.filterResource(newLocation, "etc/system.properties", props);
                InstanceServiceImpl.this.filterResource(newLocation, "bin/karaf", props);
                InstanceServiceImpl.this.filterResource(newLocation, "bin/start", props);
                InstanceServiceImpl.this.filterResource(newLocation, "bin/stop", props);
                InstanceServiceImpl.this.filterResource(newLocation, "bin/karaf.bat", props);
                InstanceServiceImpl.this.filterResource(newLocation, "bin/start.bat", props);
                InstanceServiceImpl.this.filterResource(newLocation, "bin/stop.bat", props);
                instance.name = newName;
                instance.loc = newLocation.getPath();
                state.instances.put(newName, instance);
                state.instances.remove(oldName);
                InstanceImpl proxy = (InstanceImpl)InstanceServiceImpl.this.proxies.remove(oldName);
                if (proxy == null) {
                    proxy = new InstanceImpl(InstanceServiceImpl.this, newName);
                } else {
                    proxy.doSetName(newName);
                }
                InstanceServiceImpl.this.proxies.put(newName, proxy);
                return null;
            }
        }, true);
    }

    @Override
    public synchronized Instance cloneInstance(final String name, final String cloneName, final InstanceSettings settings, boolean printOutput) throws Exception {
        final int instanceSshPort = this.getInstanceSshPort(name);
        final int instanceRmiRegistryPort = this.getInstanceRmiRegistryPort(name);
        final int instanceRmiServerPort = this.getInstanceRmiServerPort(name);
        return this.execute(new Task<Instance>(){

            @Override
            public Instance call(State state) throws IOException {
                if (state.instances.get(cloneName) != null) {
                    throw new IllegalArgumentException("Instance " + cloneName + " already exists");
                }
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                String cloneLocationPath = settings.getLocation() != null ? settings.getLocation() : cloneName;
                File cloneLocation = new File(cloneLocationPath);
                if (!cloneLocation.isAbsolute()) {
                    cloneLocation = new File(InstanceServiceImpl.this.storageLocation, cloneLocationPath);
                }
                String locationPath = instance.loc;
                File location = new File(locationPath);
                InstanceServiceImpl.this.copy(location, cloneLocation);
                HashMap<String, String> props = new HashMap<String, String>();
                props.put(name, cloneName);
                props.put(locationPath, cloneLocationPath);
                if (settings.getSshPort() > 0) {
                    props.put(Integer.toString(instanceSshPort), Integer.toString(settings.getSshPort()));
                }
                if (settings.getRmiRegistryPort() > 0) {
                    props.put(Integer.toString(instanceRmiRegistryPort), Integer.toString(settings.getRmiRegistryPort()));
                }
                if (settings.getRmiServerPort() > 0) {
                    props.put(Integer.toString(instanceRmiServerPort), Integer.toString(settings.getRmiServerPort()));
                }
                InstanceServiceImpl.this.filterResource(cloneLocation, "etc/custom.properties", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "etc/org.apache.karaf.management.cfg", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "etc/org.apache.karaf.shell.cfg", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "etc/system.properties", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "bin/karaf", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "bin/start", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "bin/stop", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "bin/karaf.bat", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "bin/start.bat", props);
                InstanceServiceImpl.this.filterResource(cloneLocation, "bin/stop.bat", props);
                String javaOpts = settings.getJavaOpts();
                if (javaOpts == null || javaOpts.length() == 0) {
                    javaOpts = InstanceServiceImpl.DEFAULT_JAVA_OPTS;
                }
                InstanceState is = new InstanceState();
                is.name = cloneName;
                is.loc = cloneLocation.toString();
                is.opts = javaOpts;
                state.instances.put(cloneName, is);
                InstanceImpl cloneInstance = new InstanceImpl(InstanceServiceImpl.this, cloneName);
                InstanceServiceImpl.this.proxies.put(cloneName, cloneInstance);
                return cloneInstance;
            }
        }, true);
    }

    private void checkPid(InstanceState instance) throws IOException {
        org.apache.karaf.jpm.Process process;
        if (instance.pid != 0 && !(process = new ProcessBuilderFactoryImpl().newBuilder().attach(instance.pid)).isRunning()) {
            instance.pid = 0;
        }
    }

    protected void cleanShutdown(InstanceState instance) {
        try {
            File file = new File(new File(instance.loc, "etc"), CONFIG_PROPERTIES_FILE_NAME);
            URL configPropURL = file.toURI().toURL();
            Properties props = InstanceServiceImpl.loadPropertiesFile(configPropURL);
            props.put("karaf.base", new File(instance.loc).getCanonicalPath());
            props.put("karaf.home", System.getProperty("karaf.home"));
            props.put("karaf.data", new File(new File(instance.loc), "data").getCanonicalPath());
            props.put("karaf.etc", new File(new File(instance.loc), "etc").getCanonicalPath());
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                props.setProperty(key, InstanceServiceImpl.substVars(props.getProperty(key), key, null, props));
            }
            int port = Integer.parseInt(props.getProperty(KARAF_SHUTDOWN_PORT, "0"));
            String host = props.getProperty(KARAF_SHUTDOWN_HOST, "localhost");
            String portFile = props.getProperty(KARAF_SHUTDOWN_PORT_FILE);
            String shutdown = props.getProperty(KARAF_SHUTDOWN_COMMAND, DEFAULT_SHUTDOWN_COMMAND);
            if (port == 0 && portFile != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(portFile)));
                String portStr = r.readLine();
                port = Integer.parseInt(portStr);
                r.close();
            }
            if (port > 0) {
                Socket s = new Socket(host, port);
                s.getOutputStream().write(shutdown.getBytes());
                s.close();
                long stopTimeout = Long.parseLong(props.getProperty(KARAF_SHUTDOWN_TIMEOUT, Long.toString(this.getStopTimeout())));
                long t = System.currentTimeMillis() + stopTimeout;
                do {
                    Thread.sleep(100L);
                    this.checkPid(instance);
                } while (System.currentTimeMillis() < t && instance.pid > 0);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to cleanly shutdown instance " + instance.name, (Throwable)e);
        }
    }

    int getInstanceSshPort(String name) {
        return this.getKarafPort(name, "etc/org.apache.karaf.shell.cfg", "sshPort");
    }

    void changeInstanceSshPort(String name, int port) throws Exception {
        this.setKarafPort(name, "etc/org.apache.karaf.shell.cfg", "sshPort", port);
    }

    String getInstanceSshHost(String name) {
        return this.getKarafHost(name, "etc/org.apache.karaf.shell.cfg", "sshHost");
    }

    int getInstanceRmiRegistryPort(String name) {
        return this.getKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiRegistryPort");
    }

    void changeInstanceRmiRegistryPort(String name, int port) throws Exception {
        this.setKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiRegistryPort", port);
    }

    String getInstanceRmiRegistryHost(String name) {
        return this.getKarafHost(name, "etc/org.apache.karaf.management.cfg", "rmiRegistryHost");
    }

    int getInstanceRmiServerPort(String name) {
        return this.getKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiServerPort");
    }

    void changeInstanceRmiServerPort(String name, int port) throws Exception {
        this.setKarafPort(name, "etc/org.apache.karaf.management.cfg", "rmiServerPort", port);
    }

    String getInstanceRmiServerHost(String name) {
        return this.getKarafHost(name, "etc/org.apache.karaf.management.cfg", "rmiServerHost");
    }

    private int getKarafPort(final String name, final String path, final String key) {
        return this.execute(new Task<Integer>(){

            @Override
            public Integer call(State state) throws IOException {
                return InstanceServiceImpl.this.getKarafPort(state, name, path, key);
            }
        }, false);
    }

    private Integer getKarafPort(State state, String name, String path, final String key) {
        InstanceState instance = state.instances.get(name);
        if (instance == null) {
            throw new IllegalArgumentException("Instance " + name + " not found");
        }
        File f = new File(instance.loc, path);
        try {
            return FileLockUtils.execute(f, new FileLockUtils.CallableWithProperties<Integer>(){

                @Override
                public Integer call(org.apache.felix.utils.properties.Properties properties) throws IOException {
                    return Integer.parseInt(((String)properties.get(key)).toString());
                }
            }, false);
        }
        catch (IOException e) {
            return 0;
        }
    }

    private void setKarafPort(final String name, final String path, final String key, final int port) throws IOException {
        this.execute(new Task<Object>(){

            @Override
            public Object call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                InstanceServiceImpl.this.checkPid(instance);
                if (instance.pid != 0) {
                    throw new IllegalStateException("Instance is not stopped");
                }
                File f = new File(instance.loc, path);
                FileLockUtils.execute(f, new FileLockUtils.RunnableWithProperties(){

                    @Override
                    public void run(org.apache.felix.utils.properties.Properties properties) throws IOException {
                        properties.put(key, Integer.toString(port));
                    }
                }, true);
                return null;
            }
        }, true);
    }

    private String getKarafHost(final String name, final String path, final String key) {
        return this.execute(new Task<String>(){

            @Override
            public String call(State state) throws IOException {
                return InstanceServiceImpl.this.getKarafHost(state, name, path, key);
            }
        }, false);
    }

    private String getKarafHost(State state, String name, String path, final String key) {
        InstanceState instance = state.instances.get(name);
        if (instance == null) {
            throw new IllegalArgumentException("Instance " + name + " not found");
        }
        File f = new File(instance.loc, path);
        try {
            return FileLockUtils.execute(f, new FileLockUtils.CallableWithProperties<String>(){

                @Override
                public String call(org.apache.felix.utils.properties.Properties properties) throws IOException {
                    return ((String)properties.get(key)).toString();
                }
            }, false);
        }
        catch (IOException e) {
            return "0.0.0.0";
        }
    }

    boolean isInstanceRoot(final String name) {
        return this.execute(new Task<Boolean>(){

            @Override
            public Boolean call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                return instance.root;
            }
        }, false);
    }

    String getInstanceLocation(final String name) {
        return this.execute(new Task<String>(){

            @Override
            public String call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                return instance.loc;
            }
        }, true);
    }

    int getInstancePid(final String name) {
        boolean updateInstanceProperties = this.isInstancePidNeedUpdate(name);
        return this.execute(new Task<Integer>(){

            @Override
            public Integer call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                InstanceServiceImpl.this.checkPid(instance);
                return instance.pid;
            }
        }, updateInstanceProperties);
    }

    String getInstanceJavaOpts(final String name) {
        return this.execute(new Task<String>(){

            @Override
            public String call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                return instance.opts;
            }
        }, false);
    }

    void changeInstanceJavaOpts(final String name, final String opts) {
        this.execute(new Task<String>(){

            @Override
            public String call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                instance.opts = opts;
                return null;
            }
        }, true);
    }

    String getInstanceState(final String name) {
        boolean updateInstanceProperties = this.isInstancePidNeedUpdate(name);
        return this.execute(new Task<String>(){

            @Override
            public String call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                int port = InstanceServiceImpl.this.getKarafPort(state, name, "etc/org.apache.karaf.shell.cfg", "sshPort");
                String host = InstanceServiceImpl.this.getKarafHost(state, name, "etc/org.apache.karaf.shell.cfg", "sshHost");
                if (host.equals("0.0.0.0")) {
                    host = "localhost";
                }
                if (!new File(instance.loc).isDirectory() || port <= 0) {
                    return "Error";
                }
                InstanceServiceImpl.this.checkPid(instance);
                if (instance.pid == 0) {
                    return "Stopped";
                }
                try {
                    Socket s = new Socket(host, port);
                    s.close();
                    return "Started";
                }
                catch (Exception e) {
                    return "Starting";
                }
            }
        }, updateInstanceProperties);
    }

    private boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = true;
        if (fileToDelete.isDirectory()) {
            File[] files = fileToDelete.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= this.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result &= fileToDelete.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToDir(File target, String resource, boolean printOutput) throws IOException {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            this.logInfo("Creating file: %s", printOutput, outFile.getPath());
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/karaf/instance/resources/" + resource);
            try {
                PrintStream out = new PrintStream(new FileOutputStream(outFile));
                try {
                    Scanner scanner = new Scanner(is);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        out.println(line);
                    }
                }
                finally {
                    this.safeClose(out);
                }
            }
            finally {
                this.safeClose(is);
            }
        }
    }

    private void println(String st) {
        System.out.println(st);
    }

    protected static Properties loadPropertiesFile(URL configPropURL) throws Exception {
        Properties configProps = new Properties();
        InputStream is = null;
        try {
            is = configPropURL.openConnection().getInputStream();
            configProps.load(is);
            is.close();
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        return configProps;
    }

    private void filterResource(File basedir, String path, HashMap<String, String> props) throws IOException {
        File file = new File(basedir, path);
        File bak = new File(basedir, path + BACKUP_EXTENSION);
        if (!file.exists()) {
            return;
        }
        file.renameTo(bak);
        this.copyAndFilterResource(new FileInputStream(bak), new FileOutputStream(file), props);
        bak.delete();
    }

    private void copyFilteredResourceToDir(File target, String resource, HashMap<String, String> props, boolean printOutput) throws IOException {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            this.logInfo("Creating file: %s", printOutput, outFile.getPath());
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/karaf/instance/resources/" + resource);
            this.copyAndFilterResource(is, new FileOutputStream(outFile), props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAndFilterResource(InputStream source, OutputStream target, HashMap<String, String> props) throws IOException {
        try {
            PrintStream out = new PrintStream(target);
            try {
                Scanner scanner = new Scanner(source);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    line = this.filter(line, props);
                    out.println(line);
                }
            }
            finally {
                this.safeClose(out);
            }
        }
        finally {
            this.safeClose(source);
        }
    }

    private void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    private void mkdir(File karafBase, String path, boolean printOutput) {
        File file = new File(karafBase, path);
        if (!file.exists()) {
            this.logInfo("Creating dir: %s", printOutput, file.getPath());
            file.mkdirs();
        }
    }

    private int chmod(File serviceFile, String mode) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("chmod", mode, serviceFile.getCanonicalPath());
        Process p = builder.start();
        try {
            return p.waitFor();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
    }

    private void copy(File source, File destination) throws IOException {
        if (source.getName().equals("cache.lock")) {
            return;
        }
        if (source.getName().equals("lock")) {
            return;
        }
        if (source.getName().matches("transaction_\\d+\\.log")) {
            return;
        }
        if (source.getName().endsWith(".instance")) {
            return;
        }
        if (source.isDirectory()) {
            String[] children;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            for (String child : children = source.list()) {
                if (child.contains("instances") || child.contains("lib")) continue;
                this.copy(new File(source, child), new File(destination, child));
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    protected static String substVars(String val, String currentKey, Map<String, String> cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = InstanceServiceImpl.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    public void changeInstanceSshHost(String name, String host) throws Exception {
        this.setKarafHost(name, "etc/org.apache.karaf.shell.cfg", "sshHost", host);
    }

    private void setKarafHost(final String name, final String path, final String key, final String host) throws IOException {
        this.execute(new Task<Object>(){

            @Override
            public Object call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                InstanceServiceImpl.this.checkPid(instance);
                if (instance.pid != 0) {
                    throw new IllegalStateException("Instance is not stopped");
                }
                File f = new File(instance.loc, path);
                FileLockUtils.execute(f, new FileLockUtils.RunnableWithProperties(){

                    @Override
                    public void run(org.apache.felix.utils.properties.Properties properties) throws IOException {
                        properties.put(key, host);
                    }
                }, true);
                return null;
            }
        }, true);
    }

    private Boolean isInstancePidNeedUpdate(final String name) {
        return this.execute(new Task<Boolean>(){

            @Override
            public Boolean call(State state) throws IOException {
                InstanceState instance = state.instances.get(name);
                if (instance == null) {
                    throw new IllegalArgumentException("Instance " + name + " not found");
                }
                int origialPid = instance.pid;
                InstanceServiceImpl.this.checkPid(instance);
                int newPid = instance.pid;
                if (origialPid == newPid) {
                    return false;
                }
                return true;
            }
        }, false);
    }

    static interface Task<T> {
        public T call(State var1) throws IOException;
    }

    static class State {
        int defaultSshPortStart = 8101;
        int defaultRmiRegistryPortStart = 1099;
        int defaultRmiServerPortStart = 44444;
        Map<String, InstanceState> instances;

        State() {
        }
    }

    static class InstanceState {
        String name;
        String loc;
        String opts;
        int pid;
        boolean root;

        InstanceState() {
        }
    }
}

