// ***************************************************************************************************************************
// * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file *
// * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file        *
// * to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance            *
// * with the License.  You may obtain a copy of the License at                                                              *
// *                                                                                                                         *
// *  http://www.apache.org/licenses/LICENSE-2.0                                                                             *
// *                                                                                                                         *
// * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an  *
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the        *
// * specific language governing permissions and limitations under the License.                                              *
// ***************************************************************************************************************************
package org.apache.juneau.rest.client2;

import static org.apache.juneau.assertions.Assertions.*;
import static org.junit.Assert.*;
import static org.junit.runners.MethodSorters.*;

import java.io.*;

import org.apache.http.entity.*;
import org.apache.juneau.marshall.*;
import org.apache.juneau.parser.*;
import org.apache.juneau.rest.*;
import org.apache.juneau.rest.annotation.*;
import org.apache.juneau.rest.mock2.*;
import org.junit.*;

@FixMethodOrder(NAME_ASCENDING)
public class RestCallException_Test {

	public static class ABean {
		public int f;
		static ABean get() {
			ABean x = new ABean();
			x.f = 1;
			return x;
		}
		@Override
		public String toString() {
			return SimpleJson.DEFAULT.toString(this);
		}
	}

	@Rest
	public static class A extends BasicRest {
		@RestMethod
		public InputStream postEcho(InputStream is) {
			return is;
		}
	}

	@Test
	public void a01_basic() throws Exception {
		try {
			client().build().get().run();
			fail();
		} catch (RestCallException e) {
			assertInteger(e.getResponse().getStatusCode()).is(404);
			assertNull(e.getCause());
		}

		try {
			client().build().post("/echo",new StringEntity("{f:")).run().getBody().as(ABean.class);
			fail();
		} catch (RestCallException e) {
			assertThrowable(e.getCause(ParseException.class)).contains("Could not find '}'");
		}

		RestCallException e = new RestCallException(null, null, null);
		assertNull(e.getServerExceptionMessage());
		assertNull(e.getServerExceptionName());
		assertEquals(0, e.getResponseCode());
	}

	//-----------------------------------------------------------------------------------------------------------------
	// Helper methods.
	//-----------------------------------------------------------------------------------------------------------------

	private static RestClientBuilder client() {
		return MockRestClient.create(A.class).simpleJson();
	}
}
