/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.function;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

@FunctionalInterface
public interface OptionalSupplier<T>
extends Supplier<T> {
    public static <T> OptionalSupplier<T> of(Supplier<T> supplier) {
        AssertionUtils.assertArgNotNull("supplier", supplier);
        return supplier::get;
    }

    public static <T> OptionalSupplier<T> ofNullable(T value) {
        return () -> value;
    }

    public static <T> OptionalSupplier<T> empty() {
        return () -> null;
    }

    default public boolean isPresent() {
        return Utils.nn(this.get());
    }

    default public boolean isEmpty() {
        return !this.isPresent();
    }

    default public <U> OptionalSupplier<U> map(Function<? super T, ? extends U> mapper) {
        AssertionUtils.assertArgNotNull("mapper", mapper);
        return () -> {
            Object value = this.get();
            return Utils.nn(value) ? mapper.apply((T)value) : null;
        };
    }

    default public <U> OptionalSupplier<U> flatMap(Function<? super T, ? extends OptionalSupplier<? extends U>> mapper) {
        AssertionUtils.assertArgNotNull("mapper", mapper);
        return () -> {
            Object value = this.get();
            if (Utils.nn(value)) {
                OptionalSupplier result = (OptionalSupplier)mapper.apply((T)value);
                return result != null ? result.get() : null;
            }
            return null;
        };
    }

    default public OptionalSupplier<T> filter(Predicate<? super T> predicate) {
        AssertionUtils.assertArgNotNull("predicate", predicate);
        return () -> {
            Object value = this.get();
            return Utils.nn(value) && predicate.test((T)value) ? value : null;
        };
    }

    default public T orElse(T other) {
        Object value = this.get();
        return Utils.nn(value) ? value : other;
    }

    default public T orElseGet(Supplier<? extends T> other) {
        AssertionUtils.assertArgNotNull("other", other);
        Object value = this.get();
        return Utils.nn(value) ? value : other.get();
    }

    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        AssertionUtils.assertArgNotNull("exceptionSupplier", exceptionSupplier);
        Object value = this.get();
        if (Utils.nn(value)) {
            return value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    default public void ifPresent(Consumer<? super T> action) {
        AssertionUtils.assertArgNotNull("action", action);
        Object value = this.get();
        if (Utils.nn(value)) {
            action.accept(value);
        }
    }

    default public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        AssertionUtils.assertArgNotNull("action", action);
        AssertionUtils.assertArgNotNull("emptyAction", emptyAction);
        Object value = this.get();
        if (Utils.nn(value)) {
            action.accept(value);
        } else {
            emptyAction.run();
        }
    }

    default public Optional<T> toOptional() {
        return Utils.opt(this.get());
    }
}

