/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.juneau.commons.io.StringBuilderWriter;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.widget.Widget;

public abstract class MenuItemWidget
extends Widget {
    public String getAfterShowScript(RestRequest req, RestResponse res) {
        return null;
    }

    public String getBeforeShowScript(RestRequest req, RestResponse res) {
        return null;
    }

    public abstract Object getContent(RestRequest var1, RestResponse var2);

    @Override
    public String getHtml(RestRequest req, RestResponse res) {
        StringBuilder sb;
        block21: {
            sb = new StringBuilder();
            Integer id = null;
            String pre = Utils.nullIfEmpty((String)this.getBeforeShowScript(req, res));
            String post = Utils.nullIfEmpty((String)this.getAfterShowScript(req, res));
            sb.append("\n<div class='menu-item'>");
            if (Utils.nn((Object)pre) || Utils.nn((Object)post)) {
                id = MenuItemWidget.getId(req);
                sb.append("\n\t<script>");
                if (Utils.nn((Object)pre)) {
                    sb.append("\n\t\tfunction onPreShow" + id + "() {");
                    sb.append("\n").append(pre);
                    sb.append("\n\t\t}");
                }
                if (Utils.nn((Object)post)) {
                    sb.append("\n\t\tfunction onPostShow" + id + "() {");
                    sb.append("\n").append(pre);
                    sb.append("\n\t\t}");
                }
                sb.append("\n\t</script>");
            }
            String onclick = (String)(pre == null ? "" : "onPreShow" + id + "();") + "menuClick(this);" + (String)(post == null ? "" : "onPostShow" + id + "();");
            sb.append("\n\t<a onclick='" + onclick + "'>" + this.getLabel(req, res) + "</a>\n<div class='popup-content'>");
            Object o = this.getContent(req, res);
            if (o instanceof Reader) {
                Reader o2 = (Reader)o;
                try (Reader r = o2;
                     StringBuilderWriter w = new StringBuilderWriter(sb);){
                    IoUtils.pipe((Reader)r, (Writer)w);
                    break block21;
                }
                catch (IOException e) {
                    throw ThrowableUtils.toRex((Throwable)e);
                }
            }
            if (o instanceof CharSequence) {
                CharSequence o2 = (CharSequence)o;
                sb.append(o2);
            } else {
                HtmlSerializerSession session = HtmlSerializer.DEFAULT.createSession().properties(req.getAttributes().asMap()).debug(req.isDebug() ? Boolean.valueOf(true) : null).uriContext(req.getUriContext()).useWhitespace(req.isPlainText() ? Boolean.valueOf(true) : null).resolver(req.getVarResolverSession()).build();
                session.indent = 2;
                try {
                    session.serialize(o, (Object)sb);
                }
                catch (Exception e) {
                    throw ThrowableUtils.toRex((Throwable)e);
                }
            }
        }
        sb.append("\n\t</div>\n</div>");
        return sb.toString();
    }

    public abstract String getLabel(RestRequest var1, RestResponse var2);

    @Override
    public String getScript(RestRequest req, RestResponse res) {
        return this.loadScript(req, "scripts/MenuItemWidget.js");
    }

    @Override
    public String getStyle(RestRequest req, RestResponse res) {
        return this.loadStyle(req, "styles/MenuItemWidget.css");
    }

    private static Integer getId(RestRequest req) {
        int id = req.getAttribute("LastMenuItemId").as(Integer.class).orElse(0) + 1;
        req.setAttribute("LastMenuItemId", id);
        return id;
    }
}

