/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.BasicNamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttributeMap;
import org.apache.juneau.rest.httppart.RequestAttribute;
import org.apache.juneau.svl.VarResolverSession;

public class RequestAttributes {
    final RestRequest req;
    final HttpServletRequest sreq;
    final VarResolverSession vs;

    public RequestAttributes(RestRequest req) {
        this.req = req;
        this.sreq = req.getHttpServletRequest();
        this.vs = req.getVarResolverSession();
    }

    public RequestAttributes addDefault(List<NamedAttribute> pairs) {
        for (NamedAttribute p : pairs) {
            if (this.sreq.getAttribute(p.getName()) != null) continue;
            Object o = p.getValue();
            this.sreq.setAttribute(p.getName(), o instanceof String ? this.vs.resolve(o) : o);
        }
        return this;
    }

    public RequestAttributes addDefault(NamedAttribute ... pairs) {
        return this.addDefault(CollectionUtils.l((Object[])pairs));
    }

    public RequestAttributes addDefault(NamedAttributeMap pairs) {
        for (NamedAttribute p : pairs.values()) {
            if (this.sreq.getAttribute(p.getName()) != null) continue;
            Object o = p.getValue();
            this.sreq.setAttribute(p.getName(), o instanceof String ? this.vs.resolve(o) : o);
        }
        return this;
    }

    public RequestAttributes addDefault(String name, Object value) {
        return this.addDefault(BasicNamedAttribute.of(name, value));
    }

    public Map<String, Object> asMap() {
        JsonMap m = new JsonMap();
        Enumeration e = this.sreq.getAttributeNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            m.put(n, this.sreq.getAttribute(n));
        }
        return m;
    }

    public boolean contains(String ... names) {
        AssertionUtils.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (this.sreq.getAttribute(n) != null) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(String ... names) {
        AssertionUtils.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (!Utils.nn((Object)this.sreq.getAttribute(n))) continue;
            return true;
        }
        return false;
    }

    public RequestAttribute get(String name) {
        return new RequestAttribute(this.req, name, this.sreq.getAttribute(name));
    }

    public List<RequestAttribute> getAll() {
        List l = CollectionUtils.list((Object[])new RequestAttribute[0]);
        Enumeration e = this.sreq.getAttributeNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            l.add(new RequestAttribute(this.req, n, this.sreq.getAttribute(n)));
        }
        return l;
    }

    public RequestAttributes remove(NamedAttribute ... attributes) {
        for (NamedAttribute p : attributes) {
            this.remove(p.getName());
        }
        return this;
    }

    public RequestAttributes remove(String ... name) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        for (String n : name) {
            this.sreq.removeAttribute(n);
        }
        return this;
    }

    public RequestAttributes set(NamedAttribute ... attributes) {
        AssertionUtils.assertArgNotNull((String)"attributes", (Object)attributes);
        for (NamedAttribute p : attributes) {
            this.set(p);
        }
        return this;
    }

    public RequestAttributes set(String name, Object value) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        this.sreq.setAttribute(name, value);
        return this;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"attributes", this.asMap());
    }

    public String toString() {
        return Utils.r(this.properties());
    }
}

