/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client2;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.BasicHttpResource;
import org.apache.juneau.http.HttpResource;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.rest.client2.RestCallException;
import org.apache.juneau.rest.client2.RestClient;
import org.apache.juneau.rest.client2.RestRequest;
import org.apache.juneau.rest.client2.RestResponse;
import org.apache.juneau.rest.client2.RestResponseHeader;
import org.apache.juneau.utils.IOPipe;
import org.apache.juneau.utils.Mutable;
import org.apache.juneau.utils.PojoRest;

public class RestResponseBody
implements HttpEntity {
    private static final HttpEntity NULL_ENTITY = new HttpEntity(){

        public boolean isRepeatable() {
            return false;
        }

        public boolean isChunked() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public Header getContentType() {
            return RestResponseHeader.NULL_HEADER;
        }

        public Header getContentEncoding() {
            return RestResponseHeader.NULL_HEADER;
        }

        public InputStream getContent() throws IOException, UnsupportedOperationException {
            return new ByteArrayInputStream(new byte[0]);
        }

        public void writeTo(OutputStream outstream) throws IOException {
        }

        public boolean isStreaming() {
            return false;
        }

        public void consumeContent() throws IOException {
        }
    };
    private final RestClient client;
    final RestRequest request;
    final RestResponse response;
    private final HttpEntity entity;
    private HttpPartSchema schema;
    private Parser parser;
    private byte[] cache;
    private boolean cached;
    boolean isConsumed;

    public RestResponseBody(RestClient client, RestRequest request, RestResponse response, Parser parser) {
        this.client = client;
        this.request = request;
        this.response = response;
        this.parser = parser;
        this.entity = ObjectUtils.firstNonNull(response.asHttpResponse().getEntity(), NULL_ENTITY);
    }

    public RestResponseBody parser(Parser value) {
        this.parser = value;
        return this;
    }

    public RestResponseBody schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public RestResponseBody cache() {
        this.cached = true;
        return this;
    }

    public InputStream asInputStream() throws IOException {
        try {
            if (this.cache != null) {
                return new ByteArrayInputStream(this.cache);
            }
            if (this.cached) {
                this.cache = IOUtils.readBytes(this.entity.getContent());
                this.response.close();
                return new ByteArrayInputStream(this.cache);
            }
            if (this.isConsumed && !this.entity.isRepeatable()) {
                throw new IllegalStateException("Method cannot be called.  Response has already been consumed.  Consider using the RestResponse.cacheBody() method.");
            }
            HttpEntity e = this.response.asHttpResponse().getEntity();
            InputStream is = e == null ? new ByteArrayInputStream(new byte[0]) : e.getContent();
            is = new EofSensorInputStream(is, new EofSensorWatcher(){

                public boolean eofDetected(InputStream wrapped) throws IOException {
                    try {
                        RestResponseBody.this.response.close();
                    }
                    catch (RestCallException restCallException) {
                        // empty catch block
                    }
                    return true;
                }

                public boolean streamClosed(InputStream wrapped) throws IOException {
                    try {
                        RestResponseBody.this.response.close();
                    }
                    catch (RestCallException restCallException) {
                        // empty catch block
                    }
                    return true;
                }

                public boolean streamAbort(InputStream wrapped) throws IOException {
                    try {
                        RestResponseBody.this.response.close();
                    }
                    catch (RestCallException restCallException) {
                        // empty catch block
                    }
                    return true;
                }
            });
            this.isConsumed = true;
            return is;
        }
        catch (UnsupportedOperationException | RestCallException e) {
            throw new IOException((Throwable)e);
        }
    }

    public Reader asReader() throws IOException {
        String cs = null;
        String ct = this.getContentType().asString();
        if (ct != null && ct.contains("charset=")) {
            cs = ct.substring(ct.indexOf("charset=") + 8).trim();
        }
        return this.asReader(cs == null ? IOUtils.UTF8 : Charset.forName(cs));
    }

    public Reader asReader(Charset charset) throws IOException {
        return new InputStreamReader(this.asInputStream(), charset == null ? IOUtils.UTF8 : charset);
    }

    public byte[] asBytes() throws RestCallException {
        if (this.cache == null) {
            try {
                this.cache = IOUtils.readBytes(this.entity.getContent());
            }
            catch (IOException e) {
                throw new RestCallException(this.response, e, "Could not read response body.", new Object[0]);
            }
            finally {
                this.response.close();
            }
        }
        return this.cache;
    }

    public RestResponse pipeTo(OutputStream os) throws IOException {
        IOPipe.create(this.asInputStream(), os).run();
        return this.response;
    }

    public RestResponse pipeTo(Writer w) throws IOException {
        return this.pipeTo(w, false);
    }

    public RestResponse pipeTo(Writer w, Charset charset) throws IOException {
        return this.pipeTo(w, charset, false);
    }

    public RestResponse pipeTo(Writer w, boolean byLines) throws IOException {
        return this.pipeTo(w, null, byLines);
    }

    public RestResponse pipeTo(Writer w, Charset charset, boolean byLines) throws IOException {
        IOPipe.create(this.asReader(charset), w).byLines(byLines).run();
        return this.response;
    }

    public <T> T as(Type type, Type ... args) throws RestCallException {
        return this.as(this.getClassMeta(type, args));
    }

    public <T> RestResponse as(Mutable<T> m, Type type, Type ... args) throws RestCallException {
        m.set(this.as(type, args));
        return this.response;
    }

    public <T> T as(Class<T> type) throws RestCallException {
        return this.as(this.getClassMeta(type));
    }

    public <T> RestResponse as(Mutable<T> m, Class<T> type) throws RestCallException {
        m.set(this.as(type));
        return this.response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T as(ClassMeta<T> type) throws RestCallException {
        int n;
        int n2;
        RestResponseHeader[] restResponseHeaderArray;
        BasicHttpResource r;
        try {
            Class<T> ic = type.getInnerClass();
            if (ic.equals(RestResponseBody.class)) return (T)this;
            if (ic.equals(HttpEntity.class)) {
                return (T)this;
            }
            if (ic.equals(Reader.class)) {
                return (T)this.asReader();
            }
            if (ic.equals(InputStream.class)) {
                return (T)this.asInputStream();
            }
            if (type.isType(HttpResponse.class)) {
                return (T)this.response;
            }
            if (!type.isType(HttpResource.class)) {
                String ct = StringUtils.firstNonEmpty(this.response.getHeader("Content-Type").asStringOrElse("text/plain"));
                if (this.parser == null) {
                    this.parser = this.client.getMatchingParser(ct);
                }
                MediaType mt = MediaType.of(ct);
                if ((this.parser == null || mt.toString().equals("text/plain") && !this.parser.canHandle(ct)) && type.hasStringMutater()) {
                    return type.getStringMutater().mutate(this.asString());
                }
                if (this.parser != null) {
                    try (Closeable in = this.parser.isReaderParser() ? this.asReader() : this.asInputStream();){
                        ConstructorInfo c;
                        ParserSessionArgs pArgs = ParserSessionArgs.create().properties(new OMap().inner(this.request.getProperties())).locale(this.response.getLocale()).mediaType(mt).schema(this.schema);
                        T t = this.parser.createSession(pArgs).parse((Object)in, type);
                        if (t == null && !type.isType(String.class) && (c = type.getInfo().getPublicConstructor(new Class[0])) != null) {
                            try {
                                Object t2 = c.invoke(new Object[0]);
                                return t2;
                            }
                            catch (ExecutableException e) {
                                throw new ParseException(e);
                            }
                        }
                        T t3 = t;
                        return t3;
                    }
                }
                if (type.hasReaderMutater()) {
                    return type.getReaderMutater().mutate(this.asReader());
                }
                if (type.hasInputStreamMutater()) {
                    return type.getInputStreamMutater().mutate(this.asInputStream());
                }
                throw new ParseException("Unsupported media-type in request header ''Content-Type'': ''{0}''", this.response.getStringHeader("Content-Type"));
            }
            r = BasicHttpResource.of(this.asInputStream());
            restResponseHeaderArray = this.response.getAllHeaders();
            n2 = restResponseHeaderArray.length;
            n = 0;
        }
        catch (IOException | ParseException e) {
            this.response.close();
            throw new RestCallException(this.response, e, "Could not parse response body.", new Object[0]);
        }
        while (n < n2) {
            RestResponseHeader h = restResponseHeaderArray[n];
            if (h.getName().equalsIgnoreCase("Content-Type")) {
                r.contentType(h);
            } else if (h.getName().equalsIgnoreCase("Content-Encoding")) {
                r.contentEncoding(h);
            } else {
                r.header(h);
            }
            ++n;
        }
        return (T)r;
    }

    public <T> RestResponse as(Mutable<T> m, ClassMeta<T> type) throws RestCallException {
        m.set(this.as(type));
        return this.response;
    }

    public <T> Future<T> asFuture(final Class<T> type) throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RestResponseBody.this.as(type);
            }
        });
    }

    public <T> RestResponse asFuture(Mutable<Future<T>> m, Class<T> type) throws RestCallException {
        m.set(this.asFuture(type));
        return this.response;
    }

    public <T> Future<T> asFuture(final ClassMeta<T> type) throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RestResponseBody.this.as(type);
            }
        });
    }

    public <T> RestResponse asFuture(Mutable<Future<T>> m, ClassMeta<T> type) throws RestCallException {
        m.set(this.asFuture(type));
        return this.response;
    }

    public <T> Future<T> asFuture(final Type type, final Type ... args) throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RestResponseBody.this.as(type, args);
            }
        });
    }

    public <T> RestResponse asFuture(Mutable<Future<T>> m, Type type, Type ... args) throws RestCallException {
        m.set(this.asFuture(type, args));
        return this.response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String asString() throws RestCallException {
        this.cache();
        try (Reader r = this.asReader();){
            String string = IOUtils.read(r).toString();
            return string;
        }
        catch (IOException e) {
            this.response.close();
            throw new RestCallException(this.response, e, "Could not read response body.", new Object[0]);
        }
    }

    public RestResponse asString(Mutable<String> m) throws RestCallException {
        m.set(this.asString());
        return this.response;
    }

    public Future<String> asStringFuture() throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return RestResponseBody.this.asString();
            }
        });
    }

    public RestResponse asStringFuture(Mutable<Future<String>> m) throws RestCallException {
        m.set(this.asStringFuture());
        return this.response;
    }

    public String asAbbreviatedString(int length) throws RestCallException {
        return StringUtils.abbreviate(this.asString(), length);
    }

    public RestResponse asAbbreviatedString(Mutable<String> m, int length) throws RestCallException {
        m.set(this.asAbbreviatedString(length));
        return this.response;
    }

    public PojoRest asPojoRest(Class<?> innerType) throws RestCallException {
        return new PojoRest(this.as(innerType));
    }

    public RestResponse asPojoRest(Mutable<PojoRest> m, Class<?> innerType) throws RestCallException {
        m.set(this.asPojoRest(innerType));
        return this.response;
    }

    public PojoRest asPojoRest() throws RestCallException {
        return this.asPojoRest(OMap.class);
    }

    public RestResponse asPojoRest(Mutable<PojoRest> m) throws RestCallException {
        m.set(this.asPojoRest());
        return this.response;
    }

    public Matcher asMatcher(Pattern pattern) throws RestCallException {
        return pattern.matcher(this.asString());
    }

    public RestResponse asMatcher(Mutable<Matcher> m, Pattern pattern) throws RestCallException {
        m.set(pattern.matcher(this.asString()));
        return this.response;
    }

    public Matcher asMatcher(String regex) throws RestCallException {
        return this.asMatcher(regex, 0);
    }

    public RestResponse asMatcher(Mutable<Matcher> m, String regex) throws RestCallException {
        this.asMatcher(m, regex, 0);
        return this.response;
    }

    public Matcher asMatcher(String regex, int flags) throws RestCallException {
        return this.asMatcher(Pattern.compile(regex, flags));
    }

    public RestResponse asMatcher(Mutable<Matcher> m, String regex, int flags) throws RestCallException {
        this.asMatcher(m, Pattern.compile(regex, flags));
        return this.response;
    }

    public RestResponse toResponse() {
        return this.response;
    }

    public FluentStringAssertion<RestResponse> assertString() throws RestCallException {
        return new FluentStringAssertion<RestResponse>(this.asString(), this.response);
    }

    public FluentByteArrayAssertion<RestResponse> assertBytes() throws RestCallException {
        return new FluentByteArrayAssertion<RestResponse>(this.asBytes(), this.response);
    }

    public FluentObjectAssertion<RestResponse> assertObject(Class<?> type) throws RestCallException {
        return new FluentObjectAssertion<RestResponse>(this.as(type), this.response);
    }

    public boolean isRepeatable() {
        return this.cached || this.entity.isRepeatable();
    }

    public boolean isChunked() {
        return this.entity.isChunked();
    }

    public long getContentLength() {
        return this.cache != null ? (long)this.cache.length : this.entity.getContentLength();
    }

    public RestResponseHeader getContentType() {
        return new RestResponseHeader(this.request, this.response, this.entity.getContentType());
    }

    public RestResponseHeader getContentEncoding() {
        return new RestResponseHeader(this.request, this.response, this.entity.getContentEncoding());
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.asInputStream();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.pipeTo(outstream);
    }

    public boolean isStreaming() {
        return this.cached ? false : this.entity.isStreaming();
    }

    @Deprecated
    public void consumeContent() throws IOException {
        this.entity.consumeContent();
    }

    private BeanContext getBeanContext() {
        return this.parser == null ? BeanContext.DEFAULT : this.parser;
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> c) {
        return this.getBeanContext().getClassMeta(c);
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.getBeanContext().getClassMeta(type, args);
    }
}

