/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.urlencoding.UrlEncodingBeanPropertyMeta;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingCommon;
import org.apache.juneau.urlencoding.UrlEncodingMetaProvider;
import org.apache.juneau.urlencoding.UrlEncodingParserBuilder;
import org.apache.juneau.urlencoding.UrlEncodingParserSession;

@ConfigurableContext
public class UrlEncodingParser
extends UonParser
implements UrlEncodingMetaProvider,
UrlEncodingCommon {
    static final String PREFIX = "UrlEncodingParser";
    public static final String URLENC_expandedParams = "UrlEncodingParser.expandedParams.b";
    public static final UrlEncodingParser DEFAULT = new UrlEncodingParser(PropertyStore.DEFAULT);
    private final boolean expandedParams;
    private final Map<ClassMeta<?>, UrlEncodingClassMeta> urlEncodingClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, UrlEncodingBeanPropertyMeta> urlEncodingBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, UrlEncodingBeanPropertyMeta>();

    public UrlEncodingParser(PropertyStore ps) {
        super(ps.builder().setDefault("UonParser.decoding.b", true).build(), "application/x-www-form-urlencoded");
        this.expandedParams = this.getBooleanProperty(URLENC_expandedParams, false);
    }

    @Override
    public UrlEncodingParserBuilder builder() {
        return new UrlEncodingParserBuilder(this.getPropertyStore());
    }

    public static UrlEncodingParserBuilder create() {
        return new UrlEncodingParserBuilder();
    }

    @Override
    public UrlEncodingParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public UrlEncodingParserSession createSession(ParserSessionArgs args) {
        return new UrlEncodingParserSession(this, args);
    }

    @Override
    public UrlEncodingClassMeta getUrlEncodingClassMeta(ClassMeta<?> cm) {
        UrlEncodingClassMeta m = this.urlEncodingClassMetas.get(cm);
        if (m == null) {
            m = new UrlEncodingClassMeta(cm, this);
            this.urlEncodingClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public UrlEncodingBeanPropertyMeta getUrlEncodingBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return UrlEncodingBeanPropertyMeta.DEFAULT;
        }
        UrlEncodingBeanPropertyMeta m = this.urlEncodingBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new UrlEncodingBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.urlEncodingBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final boolean isExpandedParams() {
        return this.expandedParams;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("expandedParams", this.expandedParams));
    }
}

