/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.scale.Scales;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Transforms;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PositionalScalesUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ0\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00120\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J>\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u00040\u00062\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/MarginalLayerUtil;", "", "()V", "MARGINAL_SCALE", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "MARGINAL_SCALES", "", "Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "MARGINAL_SCALE_REVERSED", "marginalDomainByMargin", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "marginalLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "scaleXProto", "scaleYProto", "marginalLayersByMargin", "scaleXYByMargin", "Lkotlin/Pair;", "toMarginalScaleMap", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "scaleMap", "margin", "flipOrientation", "", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nMarginalLayerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarginalLayerUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/MarginalLayerUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,100:1\n1789#2,2:101\n1791#2:110\n1238#2,4:113\n1238#2,4:119\n372#3,7:103\n453#3:111\n403#3:112\n453#3:117\n403#3:118\n*S KotlinDebug\n*F\n+ 1 MarginalLayerUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/MarginalLayerUtil\n*L\n27#1:101,2\n27#1:110\n42#1:113,4\n93#1:119,4\n28#1:103,7\n42#1:111\n42#1:112\n93#1:117\n93#1:118\n*E\n"})
public final class MarginalLayerUtil {
    @NotNull
    public static final MarginalLayerUtil INSTANCE = new MarginalLayerUtil();
    @NotNull
    private static final Scale MARGINAL_SCALE = Scales.INSTANCE.continuousDomain("marginal", true);
    @NotNull
    private static final Scale MARGINAL_SCALE_REVERSED = MARGINAL_SCALE.with().continuousTransform(Transforms.INSTANCE.getREVERSE()).build();
    @NotNull
    private static final Map<MarginSide, Scale> MARGINAL_SCALES;

    private MarginalLayerUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<MarginSide, List<GeomLayer>> marginalLayersByMargin(@NotNull List<? extends GeomLayer> marginalLayers) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(marginalLayers, (String)"marginalLayers");
        Iterable iterable = marginalLayers;
        LinkedHashMap initial$iv = new LinkedHashMap();
        boolean $i$f$fold = false;
        LinkedHashMap accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Object object;
            void $this$getOrPut$iv;
            void layer;
            GeomLayer geomLayer = (GeomLayer)element$iv;
            LinkedHashMap map2 = accumulator$iv;
            boolean bl = false;
            Map map3 = map2;
            MarginSide key$iv = layer.getMarginalSide();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(layer);
            accumulator$iv = map2;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<MarginSide, DoubleSpan> marginalDomainByMargin(@NotNull List<? extends GeomLayer> marginalLayers, @NotNull Scale scaleXProto, @NotNull Scale scaleYProto) {
        void $this$mapValuesTo$iv$iv;
        Map<MarginSide, List<GeomLayer>> layersByMargin;
        Intrinsics.checkNotNullParameter(marginalLayers, (String)"marginalLayers");
        Intrinsics.checkNotNullParameter((Object)scaleXProto, (String)"scaleXProto");
        Intrinsics.checkNotNullParameter((Object)scaleYProto, (String)"scaleYProto");
        Map<MarginSide, Pair<Scale, Scale>> scaleXYByMargin = this.scaleXYByMargin(scaleXProto, scaleYProto);
        Map<MarginSide, List<GeomLayer>> $this$mapValues$iv = layersByMargin = this.marginalLayersByMargin(marginalLayers);
        boolean $i$f$mapValues = false;
        Map<MarginSide, List<GeomLayer>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            DoubleSpan doubleSpan;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            MarginSide side = (MarginSide)((Object)entry2.getKey());
            List layers = (List)entry2.getValue();
            Pair pair = (Pair)MapsKt.getValue(scaleXYByMargin, (Object)((Object)side));
            Scale marginScaleXProto = (Scale)pair.component1();
            Scale marginScaleYProto = (Scale)pair.component2();
            List layersByTile = CollectionsKt.listOf((Object)layers);
            List<Pair<DoubleSpan, DoubleSpan>> domainXYByTile = PositionalScalesUtil.INSTANCE.computePlotXYTransformedDomains(layersByTile, marginScaleXProto, marginScaleYProto, PlotFacets.Companion.undefined());
            Pair pair2 = (Pair)CollectionsKt.first(domainXYByTile);
            DoubleSpan xDomain = (DoubleSpan)pair2.component1();
            DoubleSpan yDomain = (DoubleSpan)pair2.component2();
            switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
                case 1: 
                case 2: {
                    doubleSpan = xDomain;
                    break;
                }
                case 3: 
                case 4: {
                    doubleSpan = yDomain;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DoubleSpan doubleSpan2 = doubleSpan;
            map4.put(k, doubleSpan2);
        }
        return destination$iv$iv;
    }

    private final Map<MarginSide, Pair<Scale, Scale>> scaleXYByMargin(Scale scaleXProto, Scale scaleYProto) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)MarginSide.LEFT), (Object)new Pair((Object)MARGINAL_SCALE_REVERSED, (Object)scaleYProto)), TuplesKt.to((Object)((Object)MarginSide.RIGHT), (Object)new Pair((Object)MARGINAL_SCALE, (Object)scaleYProto)), TuplesKt.to((Object)((Object)MarginSide.TOP), (Object)new Pair((Object)scaleXProto, (Object)MARGINAL_SCALE)), TuplesKt.to((Object)((Object)MarginSide.BOTTOM), (Object)new Pair((Object)scaleXProto, (Object)MARGINAL_SCALE_REVERSED))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Aes<?>, Scale> toMarginalScaleMap(@NotNull Map<Aes<?>, ? extends Scale> scaleMap, @NotNull MarginSide margin, boolean flipOrientation) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(scaleMap, (String)"scaleMap");
        Intrinsics.checkNotNullParameter((Object)((Object)margin), (String)"margin");
        Map<Aes<?>, Scale> $this$mapValues$iv = scaleMap;
        boolean $i$f$mapValues = false;
        Map<Aes<?>, Scale> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Scale scale;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Aes aes = (Aes)entry2.getKey();
            Scale scale2 = (Scale)entry2.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[margin.ordinal()]) {
                case 1: 
                case 2: {
                    if (MarginalLayerUtil.toMarginalScaleMap$isXAxis(flipOrientation, aes)) {
                        scale = (Scale)MapsKt.getValue(MARGINAL_SCALES, (Object)((Object)margin));
                        break;
                    }
                    scale = scale2;
                    break;
                }
                case 3: 
                case 4: {
                    if (MarginalLayerUtil.toMarginalScaleMap$isYAxis(flipOrientation, aes)) {
                        scale = (Scale)MapsKt.getValue(MARGINAL_SCALES, (Object)((Object)margin));
                        break;
                    }
                    scale = scale2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Scale scale3 = scale;
            map4.put(k, scale3);
        }
        return destination$iv$iv;
    }

    private static final boolean toMarginalScaleMap$isXAxis(boolean $flipOrientation, Aes<?> aes) {
        boolean bl;
        boolean bl2 = $flipOrientation;
        if (bl2) {
            bl = Aes.Companion.isPositionalY(aes);
        } else if (!bl2) {
            bl = Aes.Companion.isPositionalX(aes);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final boolean toMarginalScaleMap$isYAxis(boolean $flipOrientation, Aes<?> aes) {
        boolean bl;
        boolean bl2 = $flipOrientation;
        if (bl2) {
            bl = Aes.Companion.isPositionalX(aes);
        } else if (!bl2) {
            bl = Aes.Companion.isPositionalY(aes);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)MarginSide.LEFT), (Object)MARGINAL_SCALE_REVERSED), TuplesKt.to((Object)((Object)MarginSide.TOP), (Object)MARGINAL_SCALE), TuplesKt.to((Object)((Object)MarginSide.RIGHT), (Object)MARGINAL_SCALE), TuplesKt.to((Object)((Object)MarginSide.BOTTOM), (Object)MARGINAL_SCALE_REVERSED)};
        MARGINAL_SCALES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MarginSide.values().length];
            try {
                nArray[MarginSide.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarginSide.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarginSide.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarginSide.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

