/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authc;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.web.filter.authc.HttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerHttpAuthenticationFilter
extends HttpAuthenticationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BearerHttpAuthenticationFilter.class);
    private static final String BEARER = "Bearer";

    public BearerHttpAuthenticationFilter() {
        this.setAuthcScheme(BEARER);
        this.setAuthzScheme(BEARER);
    }

    @Override
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String authorizationHeader = this.getAuthzHeader(request);
        if (authorizationHeader == null || authorizationHeader.length() == 0) {
            return this.createBearerToken("", request);
        }
        LOGGER.debug("Attempting to execute login with auth header");
        String[] prinCred = this.getPrincipalsAndCredentials(authorizationHeader, request);
        if (prinCred == null || prinCred.length < 1) {
            return this.createBearerToken("", request);
        }
        String token = prinCred[0] != null ? prinCred[0] : "";
        return this.createBearerToken(token, request);
    }

    @Override
    protected String[] getPrincipalsAndCredentials(String scheme, String token) {
        return new String[]{token};
    }

    protected AuthenticationToken createBearerToken(String token, ServletRequest request) {
        return new BearerToken(token, request.getRemoteHost());
    }
}

