/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.WrappedSecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

public abstract class SecurityUtils {
    private static volatile SecurityManager securityManager;

    public static Subject getSubject() {
        Subject subject = ThreadContext.getSubject();
        if (subject == null) {
            subject = new Subject.Builder().buildSubject();
            ThreadContext.bind(subject);
        }
        return subject;
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        SecurityUtils.securityManager = securityManager;
    }

    public static SecurityManager getSecurityManager() throws UnavailableSecurityManagerException {
        SecurityManager securityManager = ThreadContext.getSecurityManager();
        if (securityManager == null) {
            securityManager = SecurityUtils.securityManager;
        }
        if (securityManager == null) {
            String msg = "No SecurityManager accessible to the calling code, either bound to the " + ThreadContext.class.getName() + " or as a vm static singleton.  This is an invalid application configuration.";
            throw new UnavailableSecurityManagerException(msg);
        }
        return securityManager;
    }

    public static <SM extends SecurityManager> SM getSecurityManager(Class<SM> type) {
        Objects.requireNonNull(type, "Class argument cannot be null.");
        return SecurityUtils.unwrapSecurityManager(SecurityUtils.getSecurityManager(), type);
    }

    public static boolean isSecurityManagerTypeOf(SecurityManager securityManager, Class<? extends SecurityManager> type) {
        return type.isAssignableFrom(SecurityUtils.unwrapSecurityManager(securityManager, type).getClass());
    }

    public static <SM extends SecurityManager> SM unwrapSecurityManager(SecurityManager securityManager, Class<SM> type) {
        return SecurityUtils.unwrapSecurityManager(securityManager, type, type::isAssignableFrom);
    }

    public static <SM extends SecurityManager> SM unwrapSecurityManager(SecurityManager securityManager, Class<SM> type, Predicate<Class<? extends SecurityManager>> predicate) {
        while (securityManager instanceof WrappedSecurityManager && !predicate.test(securityManager.getClass())) {
            WrappedSecurityManager wrappedSecurityManager = (WrappedSecurityManager)((Object)securityManager);
            if ((securityManager = wrappedSecurityManager.unwrap()) != wrappedSecurityManager) continue;
            throw new IllegalStateException("SecurityManager implementation of type [" + type.getName() + "] is wrapped by itself, which is an invalid configuration.");
        }
        return (SM)securityManager;
    }
}

