/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.net.http.HttpClient;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.exec.http.DSP;
import org.apache.jena.sparql.exec.http.GSP;

public class ModelStore {
    private final GSP gsp = GSP.request();

    public static ModelStore service(String service) {
        return new ModelStore().endpoint(service);
    }

    protected final GSP gsp() {
        return this.gsp;
    }

    protected ModelStore() {
    }

    public ModelStore endpoint(String serviceURL) {
        this.gsp().endpoint(serviceURL);
        return this;
    }

    public ModelStore httpClient(HttpClient httpClient) {
        this.gsp().httpClient(httpClient);
        return this;
    }

    public ModelStore httpHeader(String headerName, String headerValue) {
        this.gsp().httpHeader(headerName, headerValue);
        return this;
    }

    public ModelStore namedGraph(String graphName) {
        this.gsp().graphName(graphName);
        return this;
    }

    public ModelStore defaultModel() {
        return this.defaultGraph();
    }

    public ModelStore defaultGraph() {
        this.gsp().defaultGraph();
        return this;
    }

    public ModelStore acceptHeader(String acceptHeader) {
        this.gsp().acceptHeader(acceptHeader);
        return this;
    }

    public ModelStore accept(Lang lang) {
        this.gsp().accept(lang);
        return this;
    }

    public ModelStore contentTypeHeader(String contentType) {
        this.gsp().contentTypeHeader(contentType);
        return this;
    }

    public ModelStore contentType(RDFFormat rdfFormat) {
        this.gsp().contentType(rdfFormat);
        return this;
    }

    public Model GET() {
        Graph graph = this.gsp().GET();
        Model model = ModelFactory.createModelForGraph(graph);
        return model;
    }

    public void POST(String file) {
        this.gsp().POST(file);
    }

    public void POST(Model model) {
        this.gsp().POST(model.getGraph());
    }

    public void PUT(String file) {
        this.gsp().PUT(file);
    }

    public void PUT(Model model) {
        this.gsp().PUT(model.getGraph());
    }

    public void DELETE() {
        this.gsp().DELETE();
    }

    public Dataset getDataset() {
        DatasetGraph dsg = this.dsp().GET();
        return DatasetFactory.wrap(dsg);
    }

    private DSP dsp() {
        return (DSP)DSP.request().copySetup(this.gsp);
    }

    public void postDataset(String file) {
        this.dsp().POST(file);
    }

    public void postDataset(Dataset dataset) {
        this.dsp().POST(dataset.asDatasetGraph());
    }

    public void putDataset(String file) {
        this.dsp().PUT(file);
    }

    public void putDataset(Dataset dataset) {
        this.dsp().PUT(dataset.asDatasetGraph());
    }

    public void clearDataset() {
        this.dsp().clear();
    }
}

