/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import java.io.StringReader;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.apache.jena.fuseki.validation.json.ValidatorJsonLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class DataValidatorJSON {
    static final String jInput = "input";
    static final String paramFormat = "outputFormat";
    static final String paramIndirection = "url";
    static final String paramData = "data";
    static final String paramSyntax = "languageSyntax";

    public static JsonObject execute(ValidationAction action) {
        Lang language;
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String syntax = ValidatorJsonLib.getArgOrNull(action, paramSyntax);
        if (syntax == null || syntax.equals("")) {
            syntax = RDFLanguages.NQUADS.getName();
        }
        if ((language = RDFLanguages.shortnameToLang(syntax)) == null) {
            ServletOps.errorBadRequest("Unknown syntax: " + syntax);
            return null;
        }
        String string = ValidatorJsonLib.getArg(action, paramData);
        StringReader sr = new StringReader(string);
        obj.key(jInput).value(string);
        StreamRDF dest = StreamRDFLib.sinkNull();
        try {
            RDFParser.create().source(sr).lang(language).parse(dest);
        }
        catch (RiotParseException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.key("parse-error-line").value(ex.getLine());
            obj.key("parse-error-column").value(ex.getCol());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        catch (RiotException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        obj.finishObject();
        return obj.build().getAsObject();
    }
}

